package com.elitesland.yst.production.sale.entity;

import com.elitesland.yst.production.sale.core.convert.BigDecimalConvert;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

/**
 * SAL_RECEIPT_SETTLEITEM(订单收款结算商品细表).
 * <p>
 * 订单收款结算商品细表
 *
 * @author Evin.dong
 * @date 2021/6/28 19:46
 */
@Entity
@Table(name = "sal_receipt_settleitem", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "sal_receipt_settleitem", comment = "订单收款结算商品细表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class SalReceiptSettleitemDO extends BaseModel implements Serializable {

    @Column(name = "mas_id", columnDefinition = "bigint(20) default 0 comment '主表ID'")
    private Long masId;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "line_no", columnDefinition = "decimal(20, 4) default null  comment '行号'")
    private BigDecimal lineNo;

    @Column(name = "item_cat", columnDefinition = "longtext default null  comment '商品品类'")
    private String itemCat;

    @Column(name = "fin_cat", columnDefinition = "longtext default null  comment '财务分类'")
    private String finCat;

    @Column(name = "tax_rate_no", columnDefinition = "longtext default null  comment '税率编号'")
    private String taxRateNo;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "tax_rate", columnDefinition = "decimal(20, 4) default null  comment '税率'")
    private BigDecimal taxRate;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "ap_amt", columnDefinition = "decimal(20, 4) default 0  comment '应收款金额'")
    private BigDecimal apAmt;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "coupon_amt", columnDefinition = "decimal(20, 4) default 0  comment '优惠券金额'")
    private BigDecimal couponAmt;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "card_amt", columnDefinition = "decimal(20, 4) default 0  comment '购物卡金额'")
    private BigDecimal cardAmt;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "gift_amt", columnDefinition = "decimal(20, 4) default 0  comment '提货券金额'")
    private BigDecimal giftAmt;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "usepoint_amt", columnDefinition = "decimal(20, 4) default 0  comment '使用积分金额'")
    private BigDecimal usepointAmt;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "receipt_amt", columnDefinition = "decimal(20, 4) default 0  comment '收款金额'")
    private BigDecimal receiptAmt;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "receipt_tax", columnDefinition = "decimal(20, 4) default 0  comment '收款税额'")
    private BigDecimal receiptTax;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SalReceiptSettleitemDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SalReceiptSettleitemDO entity = (SalReceiptSettleitemDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}
