package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.entity.SalAcceptanceDDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021-06-21 17:06
 */
public interface SalAcceptanceDRepo extends JpaRepository<SalAcceptanceDDO, Long>, QuerydslPredicateExecutor<SalAcceptanceDDO> {

    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "delete from sal_acceptance_d where mas_id = ?1", nativeQuery = true)
    void deleteAllByMasId(Long masId);

    List<SalAcceptanceDDO> findAllByMasId(Long masId);

}
