package com.elitesland.yst.production.sale.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsDealerQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsDealerSumRespVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.repo.QsqlDO.QsqlSaleStatisticsDealerDO;
import com.elitesland.yst.production.sale.repo.QsqlDO.QsqlSaleStatisticsDealerDtlDO;
import com.querydsl.core.types.*;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQueryFactory;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;


/**
 * @author : ssy
 * @date : 2023-8-11
 * @desc : 销售业绩统计-经销商 Repo_SQL_Proc
 */

@Component
public class SaleStatisticsDealerRepoSqlProc  {

    private final SQLQueryFactory sqlQueryFactory;
    private static final QsqlSaleStatisticsDealerDO qSqlSaleStatisticsDealerDO = QsqlSaleStatisticsDealerDO.saleStatisticsDealer;
    private static final QsqlSaleStatisticsDealerDtlDO DTL_DO = QsqlSaleStatisticsDealerDtlDO.saleStatisticsStoreDtlDO;

    private static final String SHIP_TOTAL_QTY = "shipTotalQty";
    private static final String ORDER_TOTAL_QTY = "orderTotalQty";
    private static final String DEALER_TOTAL_QTY = "dealerTotalQty";

    public SaleStatisticsDealerRepoSqlProc(SQLQueryFactory sqlQueryFactory) {
        this.sqlQueryFactory = sqlQueryFactory;
    }


    public StatisticsDealerSumRespVO pageSum(SaleStatisticsDealerQueryVO queryVO) {
        // https://www.php.cn/faq/543497.html
        StringPath t = Expressions.stringPath("t");
        List<Predicate> where = where(queryVO);

        SubQueryExpression subQueryExpression = SQLExpressions.select(
                        qSqlSaleStatisticsDealerDO.id,
                        qSqlSaleStatisticsDealerDO.docTime,
                        qSqlSaleStatisticsDealerDO.dealerCode,
                        qSqlSaleStatisticsDealerDO.dealerName,
                        qSqlSaleStatisticsDealerDO.dealerSerialNo,
                        qSqlSaleStatisticsDealerDO.region,
                        qSqlSaleStatisticsDealerDO.salesmanPath,
                        qSqlSaleStatisticsDealerDO.vehicleType,
                        qSqlSaleStatisticsDealerDO.shipQty.sum().as(SHIP_TOTAL_QTY),
                        qSqlSaleStatisticsDealerDO.orderQty.sum().as(ORDER_TOTAL_QTY),
                        qSqlSaleStatisticsDealerDO.custType,
                        qSqlSaleStatisticsDealerDO.itemType3,
                        qSqlSaleStatisticsDealerDO.remark,
                        qSqlSaleStatisticsDealerDO.createTime,
                        qSqlSaleStatisticsDealerDO.updateRegionFailureReason,
                        qSqlSaleStatisticsDealerDO.updateSalesmanFailureReason
                ).from(qSqlSaleStatisticsDealerDO)
                .where(ExpressionUtils.allOf(where))
                .groupBy(qSqlSaleStatisticsDealerDO.region, qSqlSaleStatisticsDealerDO.dealerCode,
                        qSqlSaleStatisticsDealerDO.salesmanPath, qSqlSaleStatisticsDealerDO.docTime)
                .having(having(queryVO));

        return sqlQueryFactory.select(
                        Projections.bean(StatisticsDealerSumRespVO.class,
                                Expressions.template(BigDecimal.class, "sum(t.shipTotalQty)").as(SHIP_TOTAL_QTY),
                                Expressions.template(BigDecimal.class, "sum(t.orderTotalQty)").as(ORDER_TOTAL_QTY),
                                Expressions.template(Long.class, "count(distinct t.dealer_code)").as(DEALER_TOTAL_QTY)
                        )
                )
                .from(subQueryExpression, t).fetchOne();
    }
    private Predicate having(SaleStatisticsDealerQueryVO queryVO){
        return BaseRepoProc.PredicateBuilder.builder()
                .andEq(Expressions.ONE,1)
                .andGoe(!Objects.isNull(queryVO.getShipTotalQtyFrom()), qSqlSaleStatisticsDealerDO.shipQty.sum(), (queryVO.getShipTotalQtyFrom()))
                .andLoe(!Objects.isNull(queryVO.getShipTotalQtyTo()), qSqlSaleStatisticsDealerDO.shipQty.sum(), (queryVO.getShipTotalQtyTo()))
                .andGoe(!Objects.isNull(queryVO.getOrderTotalQtyFrom()), qSqlSaleStatisticsDealerDO.orderQty.sum(), (queryVO.getOrderTotalQtyFrom()))
                .andLoe(!Objects.isNull(queryVO.getOrderTotalQtyTo()), qSqlSaleStatisticsDealerDO.orderQty.sum(), (queryVO.getOrderTotalQtyTo()))
                .build();
    }
    private List<Predicate> where(SaleStatisticsDealerQueryVO queryVO) {
        List<Predicate> predicates = new ArrayList<>();

        if (Objects.equals(queryVO.getRegionFlag(), ConstantsSale.STATISTICS_DEALER_QUERY_FLAG)) {
            predicates.add(qSqlSaleStatisticsDealerDO.region.isNull());
        }
        if (Objects.equals(queryVO.getSalesmanPathFlag(), ConstantsSale.STATISTICS_DEALER_QUERY_FLAG)) {
            predicates.add(qSqlSaleStatisticsDealerDO.salesmanPath.isNull());
        }
        if (!Objects.isNull(queryVO.getId())) {
            predicates.add(qSqlSaleStatisticsDealerDO.id.eq(queryVO.getId()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getIds())) {
            predicates.add(qSqlSaleStatisticsDealerDO.id.in(queryVO.getIds()));
        }
        if (!StringUtils.isEmpty(queryVO.getDealerCode())) {
            predicates.add(qSqlSaleStatisticsDealerDO.dealerCode.eq(queryVO.getDealerCode()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getDealerCodeList())) {
            predicates.add(qSqlSaleStatisticsDealerDO.dealerCode.in(queryVO.getDealerCodeList()));
        }
        if (!StringUtils.isEmpty(queryVO.getDealerCodeKeyword())) {
            predicates.add(qSqlSaleStatisticsDealerDO.dealerCode.like("%" + queryVO.getDealerCodeKeyword() + "%"));
        }
        if (!StringUtils.isEmpty(queryVO.getDealerName())) {
            predicates.add(qSqlSaleStatisticsDealerDO.dealerName.like("%" + queryVO.getDealerName() + "%"));
        }
        if (!StringUtils.isEmpty(queryVO.getDealerKeyword())) {
            predicates.add(qSqlSaleStatisticsDealerDO.dealerCode.like("%" + queryVO.getDealerKeyword() + "%").or(qSqlSaleStatisticsDealerDO.dealerName.like("%" + queryVO.getDealerKeyword() + "%")));
        }
        if (!StringUtils.isEmpty(queryVO.getKeyword())) {
            predicates.add(qSqlSaleStatisticsDealerDO.dealerCode.like("%" + queryVO.getKeyword() + "%").or(qSqlSaleStatisticsDealerDO.dealerName.like("%" + queryVO.getKeyword() + "%")));
        }
        if (!StringUtils.isEmpty(queryVO.getDealerSerialNo())) {
            predicates.add(qSqlSaleStatisticsDealerDO.dealerSerialNo.like("%" + queryVO.getDealerSerialNo() + "%"));
        }
        if (!StringUtils.isEmpty(queryVO.getDealerSerialNo1())) {
            predicates.add(qSqlSaleStatisticsDealerDO.dealerSerialNo.eq(queryVO.getDealerSerialNo1()));
        }
        if (!StringUtils.isEmpty(queryVO.getRegion())) {
            predicates.add(qSqlSaleStatisticsDealerDO.region.eq(queryVO.getRegion()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getRegionList())) {
            predicates.add(qSqlSaleStatisticsDealerDO.region.in(queryVO.getRegionList()));
        }
        if (Objects.equals(queryVO.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_YES.getValueCode())){
            predicates.add(qSqlSaleStatisticsDealerDO.region.isNull());
        }
        if (Objects.equals(queryVO.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_NO.getValueCode())){
            predicates.add(qSqlSaleStatisticsDealerDO.region.isNotNull());
        }

        if (!StringUtils.isEmpty(queryVO.getType())) {
            predicates.add(qSqlSaleStatisticsDealerDO.type.eq(queryVO.getType()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getTypeList())) {
            predicates.add(qSqlSaleStatisticsDealerDO.type.in(queryVO.getTypeList()));
        }
        if (!StringUtils.isEmpty(queryVO.getSalesmanPath())) {
            predicates.add(qSqlSaleStatisticsDealerDO.salesmanPath.eq(queryVO.getSalesmanPath()));
        }
        if (Objects.equals(queryVO.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_YES.getValueCode())){
            predicates.add(qSqlSaleStatisticsDealerDO.salesmanPath.isNull());
        }
        if (Objects.equals(queryVO.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_NO.getValueCode())){
            predicates.add(qSqlSaleStatisticsDealerDO.salesmanPath.isNotNull());
        }
        if (!StringUtils.isEmpty(queryVO.getVehicleType())) {
            predicates.add(qSqlSaleStatisticsDealerDO.vehicleType.eq(queryVO.getVehicleType()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getVehicleTypeList())) {
            predicates.add(qSqlSaleStatisticsDealerDO.vehicleType.in(queryVO.getVehicleTypeList()));
        }

        if (queryVO.getDocTimeStart() != null && queryVO.getDocTimeEnd() != null) {
            predicates.add(qSqlSaleStatisticsDealerDO.docTime.between(queryVO.getDocTimeStart(), queryVO.getDocTimeEnd()));
        } else {
            if (queryVO.getDocTimeStart() != null) {
                predicates.add(qSqlSaleStatisticsDealerDO.docTime.goe(queryVO.getDocTimeStart()));
            }
            if (queryVO.getDocTimeEnd() != null) {
                predicates.add(qSqlSaleStatisticsDealerDO.docTime.loe(queryVO.getDocTimeEnd()));
            }
        }

        if (Objects.nonNull(queryVO.getDocTimeItStart())) {
            predicates.add(qSqlSaleStatisticsDealerDO.docTime.yearMonth().goe(queryVO.getDocTimeItStart()));
        }
        if (Objects.nonNull(queryVO.getDocTimeItEnd())) {
            predicates.add(qSqlSaleStatisticsDealerDO.docTime.yearMonth().loe(queryVO.getDocTimeItEnd()));
        }
        if (Objects.nonNull(queryVO.getDocMonth())) {
            BooleanExpression booleanTemplate = Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m')", qSqlSaleStatisticsDealerDO.docTime)
                    .eq(queryVO.getDocMonth());
            predicates.add(booleanTemplate);
        }

        if (Objects.nonNull(queryVO.getDocTime())) {
            BooleanExpression booleanTemplate = Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m-%d')", qSqlSaleStatisticsDealerDO.docTime)
                    .eq(queryVO.getDocTime().toLocalDate().toString());
            predicates.add(booleanTemplate);
        }

        if (!Objects.isNull(queryVO.getShipQty())) {
            predicates.add(qSqlSaleStatisticsDealerDO.shipQty.eq(queryVO.getShipQty()));
        }
        if (!Objects.isNull(queryVO.getOrderQty())) {
            predicates.add(qSqlSaleStatisticsDealerDO.orderQty.eq(queryVO.getOrderQty()));
        }

        if (!StringUtils.isEmpty(queryVO.getCustType())) {
            predicates.add(qSqlSaleStatisticsDealerDO.custType.eq(queryVO.getCustType()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getCustTypes())) {
            predicates.add(qSqlSaleStatisticsDealerDO.custType.in(queryVO.getCustTypes()));
        }
        if (!StringUtils.isEmpty(queryVO.getItemType3())) {
            predicates.add(qSqlSaleStatisticsDealerDO.itemType3.eq(queryVO.getItemType3()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getItemType3List())) {
            predicates.add(qSqlSaleStatisticsDealerDO.itemType3.in(queryVO.getItemType3List()));
        }

        return predicates;
    }


    public StatisticsDealerSumRespVO pageSum2(SaleStatisticsDealerQueryVO queryVO) {
        // https://www.php.cn/faq/543497.html
        StringPath t = Expressions.stringPath("t");
        List<Predicate> where = where2(queryVO);

        SubQueryExpression subQueryExpression = SQLExpressions.select(
                qSqlSaleStatisticsDealerDO.id,
                qSqlSaleStatisticsDealerDO.docTime,
                qSqlSaleStatisticsDealerDO.dealerCode,
                qSqlSaleStatisticsDealerDO.dealerName,
                qSqlSaleStatisticsDealerDO.dealerSerialNo,
                qSqlSaleStatisticsDealerDO.region,
                qSqlSaleStatisticsDealerDO.salesmanPath,
                qSqlSaleStatisticsDealerDO.vehicleType,
                qSqlSaleStatisticsDealerDO.shipQty.sum().as(SHIP_TOTAL_QTY),
                qSqlSaleStatisticsDealerDO.orderQty.sum().as(ORDER_TOTAL_QTY),
                qSqlSaleStatisticsDealerDO.custType,
                qSqlSaleStatisticsDealerDO.itemType3,
                qSqlSaleStatisticsDealerDO.remark,
                qSqlSaleStatisticsDealerDO.createTime,
                qSqlSaleStatisticsDealerDO.updateRegionFailureReason,
                qSqlSaleStatisticsDealerDO.updateSalesmanFailureReason
        ).from(qSqlSaleStatisticsDealerDO)
                .where(ExpressionUtils.allOf(where))
                .groupBy(qSqlSaleStatisticsDealerDO.region, qSqlSaleStatisticsDealerDO.dealerCode,
                        qSqlSaleStatisticsDealerDO.salesmanPath, qSqlSaleStatisticsDealerDO.docTime)
                .having(having(queryVO));

        return sqlQueryFactory.select(
                Projections.bean(StatisticsDealerSumRespVO.class,
                        Expressions.template(BigDecimal.class, "sum(t.shipTotalQty)").as(SHIP_TOTAL_QTY),
                        Expressions.template(BigDecimal.class, "sum(t.orderTotalQty)").as(ORDER_TOTAL_QTY),
                        Expressions.template(Long.class, "count(distinct t.dealer_code)").as(DEALER_TOTAL_QTY)
                )
        )
                .from(subQueryExpression, t).fetchOne();
    }

    private List<Predicate> where2(SaleStatisticsDealerQueryVO queryVO) {
        List<Predicate> predicates = new ArrayList<>();

        if (Objects.equals(queryVO.getRegionFlag(), ConstantsSale.STATISTICS_DEALER_QUERY_FLAG)) {
            predicates.add(qSqlSaleStatisticsDealerDO.region.isNull());
        }
        if (Objects.equals(queryVO.getSalesmanPathFlag(), ConstantsSale.STATISTICS_DEALER_QUERY_FLAG)) {
            predicates.add(qSqlSaleStatisticsDealerDO.salesmanPath.isNull());
        }
        if (!Objects.isNull(queryVO.getId())) {
            predicates.add(qSqlSaleStatisticsDealerDO.id.eq(queryVO.getId()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getIds())) {
            predicates.add(qSqlSaleStatisticsDealerDO.id.in(queryVO.getIds()));
        }
        if (!StringUtils.isEmpty(queryVO.getDealerCode())) {
            predicates.add(qSqlSaleStatisticsDealerDO.dealerCode.eq(queryVO.getDealerCode()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getDealerCodeList())) {
            predicates.add(qSqlSaleStatisticsDealerDO.dealerCode.in(queryVO.getDealerCodeList()));
        }
        if (!StringUtils.isEmpty(queryVO.getDealerCodeKeyword())) {
            predicates.add(qSqlSaleStatisticsDealerDO.dealerCode.like("%" + queryVO.getDealerCodeKeyword() + "%"));
        }
        if (!StringUtils.isEmpty(queryVO.getDealerName())) {
            predicates.add(qSqlSaleStatisticsDealerDO.dealerName.like("%" + queryVO.getDealerName() + "%"));
        }
        if (!StringUtils.isEmpty(queryVO.getDealerKeyword())) {
            predicates.add(qSqlSaleStatisticsDealerDO.dealerCode.like("%" + queryVO.getDealerKeyword() + "%").or(qSqlSaleStatisticsDealerDO.dealerName.like("%" + queryVO.getDealerKeyword() + "%")));
        }
        if (!StringUtils.isEmpty(queryVO.getKeyword())) {
            predicates.add(qSqlSaleStatisticsDealerDO.dealerCode.like("%" + queryVO.getKeyword() + "%").or(qSqlSaleStatisticsDealerDO.dealerName.like("%" + queryVO.getKeyword() + "%")));
        }
        if (!StringUtils.isEmpty(queryVO.getDealerSerialNo())) {
            predicates.add(qSqlSaleStatisticsDealerDO.dealerSerialNo.like("%" + queryVO.getDealerSerialNo() + "%"));
        }
        if (!StringUtils.isEmpty(queryVO.getDealerSerialNo1())) {
            predicates.add(qSqlSaleStatisticsDealerDO.dealerSerialNo.eq(queryVO.getDealerSerialNo1()));
        }
        if (!StringUtils.isEmpty(queryVO.getRegion())) {
            predicates.add(qSqlSaleStatisticsDealerDO.region.eq(queryVO.getRegion()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getRegionList())) {
            predicates.add(qSqlSaleStatisticsDealerDO.region.in(queryVO.getRegionList()));
        }
        if (Objects.equals(queryVO.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_YES.getValueCode())){
            predicates.add(qSqlSaleStatisticsDealerDO.region.isNull());
        }
        if (Objects.equals(queryVO.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_NO.getValueCode())){
            predicates.add(qSqlSaleStatisticsDealerDO.region.isNotNull());
        }

        if (!StringUtils.isEmpty(queryVO.getType())) {
            predicates.add(qSqlSaleStatisticsDealerDO.type.eq(queryVO.getType()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getTypeList())) {
            predicates.add(qSqlSaleStatisticsDealerDO.type.in(queryVO.getTypeList()));
        }
        if (!StringUtils.isEmpty(queryVO.getSalesmanPath())) {
            predicates.add(qSqlSaleStatisticsDealerDO.salesmanPath.eq(queryVO.getSalesmanPath()));
        }
        if (Objects.equals(queryVO.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_YES.getValueCode())){
            predicates.add(qSqlSaleStatisticsDealerDO.salesmanPath.isNull());
        }
        if (Objects.equals(queryVO.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_NO.getValueCode())){
            predicates.add(qSqlSaleStatisticsDealerDO.salesmanPath.isNotNull());
        }
        if (!StringUtils.isEmpty(queryVO.getVehicleType())) {
            predicates.add(qSqlSaleStatisticsDealerDO.vehicleType.eq(queryVO.getVehicleType()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getVehicleTypeList())) {
            predicates.add(qSqlSaleStatisticsDealerDO.vehicleType.in(queryVO.getVehicleTypeList()));
        }

        if (queryVO.getDocTimeStart() != null && queryVO.getDocTimeEnd() != null) {
            predicates.add(qSqlSaleStatisticsDealerDO.docTime.between(queryVO.getDocTimeStart(), queryVO.getDocTimeEnd()));
        } else {
            if (queryVO.getDocTimeStart() != null) {
                predicates.add(qSqlSaleStatisticsDealerDO.docTime.goe(queryVO.getDocTimeStart()));
            }
            if (queryVO.getDocTimeEnd() != null) {
                predicates.add(qSqlSaleStatisticsDealerDO.docTime.loe(queryVO.getDocTimeEnd()));
            }
        }

        if (Objects.nonNull(queryVO.getDocTimeItStart())) {
            predicates.add(qSqlSaleStatisticsDealerDO.docTime.yearMonth().goe(queryVO.getDocTimeItStart()));
        }
        if (Objects.nonNull(queryVO.getDocTimeItEnd())) {
            predicates.add(qSqlSaleStatisticsDealerDO.docTime.yearMonth().loe(queryVO.getDocTimeItEnd()));
        }
        if (Objects.nonNull(queryVO.getDocMonth())) {
            BooleanExpression booleanTemplate = Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m')", qSqlSaleStatisticsDealerDO.docTime)
                    .eq(queryVO.getDocMonth());
            predicates.add(booleanTemplate);
        }

        if (Objects.nonNull(queryVO.getDocTime())) {
            BooleanExpression booleanTemplate = Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m-%d')", qSqlSaleStatisticsDealerDO.docTime)
                    .eq(queryVO.getDocTime().toLocalDate().toString());
            predicates.add(booleanTemplate);
        }

        if (!Objects.isNull(queryVO.getShipQty())) {
            predicates.add(qSqlSaleStatisticsDealerDO.shipQty.eq(queryVO.getShipQty()));
        }
        if (!Objects.isNull(queryVO.getOrderQty())) {
            predicates.add(qSqlSaleStatisticsDealerDO.orderQty.eq(queryVO.getOrderQty()));
        }

        if (!StringUtils.isEmpty(queryVO.getCustType())) {
            predicates.add(qSqlSaleStatisticsDealerDO.custType.eq(queryVO.getCustType()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getCustTypes())) {
            predicates.add(qSqlSaleStatisticsDealerDO.custType.in(queryVO.getCustTypes()));
        }
        if (!StringUtils.isEmpty(queryVO.getItemType3())) {
            predicates.add(qSqlSaleStatisticsDealerDO.itemType3.eq(queryVO.getItemType3()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getItemType3List())) {
            predicates.add(qSqlSaleStatisticsDealerDO.itemType3.in(queryVO.getItemType3List()));
        }

        if (StringUtils.isNotBlank(queryVO.getAgentEmp())) {
            predicates.add(qSqlSaleStatisticsDealerDO.id.in(JPAExpressions
                    .select(DTL_DO.masId)
                    .from(DTL_DO)
                    .where(DTL_DO.code.eq(queryVO.getAgentEmp()))));
        }

        return predicates;
    }

}

