package com.elitesland.yst.production.sale.service;

import com.elitesland.yst.production.sale.api.service.BusFitstMenuConfDService;
import com.elitesland.yst.production.sale.api.vo.param.menu.BusFirstMenuConfDPagingParam;
import com.elitesland.yst.production.sale.api.vo.param.menu.BusFirstMenuConfDSaveParam;
import com.elitesland.yst.production.sale.api.vo.resp.menu.BusFirstMenuConfDVO;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.BusFirstMenuConfDDO;
import com.elitesland.yst.production.sale.entity.BusFirstMenuConfDO;
import com.elitesland.yst.production.sale.repo.BusFirstMenuConfDRepo;
import com.elitesland.yst.production.sale.repo.BusFirstMenuConfDRepoProc;
import com.elitesland.yst.production.sale.repo.BusFirstMenuConfRepo;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.support.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Service
@Slf4j
@RequiredArgsConstructor
public class BusFirstMenuConfDServiceImpl implements BusFitstMenuConfDService {

    private final OrgEmpRpcService orgEmpRpcService;

    private final BusFirstMenuConfDRepoProc busFirstMenuConfDRepoProc;

    private final BusFirstMenuConfDRepo busFirstMenuConfDRepo;

    private final BusFirstMenuConfRepo busFirstMenuConfRepo;




    @Override
    public PagingVO<BusFirstMenuConfDVO> findPagingResult(BusFirstMenuConfDPagingParam param) {
        if(null == param.getOuId()){
            //获取当前用户的ou
            OrgUserEmpInfoRpcDTO empInfo = getCurrentEmpInfo();
            if(null == empInfo.getOuId()){
                return new PagingVO<>();
            }
        }
        PagingVO<BusFirstMenuConfDVO> list = busFirstMenuConfDRepoProc.findPagingResult(param);


        return null;
    }

    @Override
    public ApiResult<Object> saveMenuConfDetail(List<BusFirstMenuConfDSaveParam> list) {
        if(!list.isEmpty()){
            List<BusFirstMenuConfDDO> resList = new ArrayList<>();
            list.stream().forEach(l->{
                Optional<BusFirstMenuConfDO> optional = busFirstMenuConfRepo.findById(l.getMenuId());
                if(optional.isPresent()){
                    BusFirstMenuConfDO d = optional.get();
                    BusFirstMenuConfDDO busFirstMenuConfDDO = new BusFirstMenuConfDDO();
                    BeanUtils.copyProperties(l,busFirstMenuConfDDO);
                    busFirstMenuConfDDO.setOuId(d.getOuId());
                    busFirstMenuConfDDO.setOuName(d.getOuName());
                    resList.add(busFirstMenuConfDDO);
                }
            });
            if(!resList.isEmpty()){
                busFirstMenuConfDRepo.saveAll(resList);
            }
        }
        return ApiResult.ok();
    }

    @Override
    public ApiResult<Object> delMenuConfDetail(List<Long> ids) {
        if(!ids.isEmpty()){
            ids.stream().forEach(id ->{
                Optional<BusFirstMenuConfDDO> optional = busFirstMenuConfDRepo.findById(id);
                if(optional.isPresent()){
                    BusFirstMenuConfDDO busFirstMenuConfDDO = optional.get();
                    busFirstMenuConfDDO.setDeleteFlag(1);
                    busFirstMenuConfDRepo.save(busFirstMenuConfDDO);
                }
            });
        }
        return ApiResult.ok();
    }


    private OrgUserEmpInfoRpcDTO getCurrentEmpInfo() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户已失效,请重登录重试");
        }
        OrgUserEmpInfoRpcDTO userEmpInfo = orgEmpRpcService.findUserEmpInfo(currentUser.getUserId());
        if (userEmpInfo == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "无法获取当前用户信息");
        }
        return userEmpInfo;
    }

}
