package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import com.alibaba.excel.EasyExcel;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.common.param.AreaVO;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.SysEmployeeDetailDTO;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.req.*;
import com.elitescloud.cloudt.system.dto.resp.EmployeePageRespDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeeUnderlingDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.param.SysOrgQueryDTO;
import com.elitescloud.cloudt.system.provider.SysUserPermissionRpcService;
import com.elitescloud.cloudt.system.provider.extend.SysAreaRpcService;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitescloud.cloudt.system.provider.org.OrgRpcService;
import com.elitesland.yst.production.sale.api.service.SalesmanInfoService;
import com.elitesland.yst.production.sale.api.vo.param.salesman.*;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustBaseRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.salesman.*;
import com.elitesland.yst.production.sale.api.vo.save.SalesmanImportSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.SalesmanInfoSaveVO;
import com.elitesland.yst.production.sale.common.constant.Constant;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.SalesmanInfoConvert;
import com.elitesland.yst.production.sale.dto.SalesmanInfoDTO;
import com.elitesland.yst.production.sale.dto.SalesmanLevelInfoDTO;
import com.elitesland.yst.production.sale.dto.query.SalesmanAPPQueryDTO;
import com.elitesland.yst.production.sale.dto.query.SalesmanInfoAPPRespDTO;
import com.elitesland.yst.production.sale.dto.query.SalesmanQueryDTO;
import com.elitesland.yst.production.sale.entity.SalesmanInfoDO;
import com.elitesland.yst.production.sale.entity.SalesmanRegionDO;
import com.elitesland.yst.production.sale.repo.CrmCustRepoProc;
import com.elitesland.yst.production.sale.repo.SalesmanInfoRepo;
import com.elitesland.yst.production.sale.repo.SalesmanInfoRepoProc;
import com.elitesland.yst.production.sale.repo.SalesmanRegionRepo;
import com.elitesland.yst.production.sale.search.bean.SalesmanInfoSearchBean;
import com.elitesland.yst.production.sale.search.service.SearchBeanService;
import com.elitesland.yst.production.sale.util.ExcelEntityDataListener;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgOuRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.service.OrgOuRpcService;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.multipart.MultipartFile;

import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author Danny.Wang
 * @title SalesmanInfoServiceImpl
 * @Date2023/2/21 16:08
 */
@Log4j2
@Service
public class SalesmanInfoServiceImpl implements SalesmanInfoService {

    @Autowired
    private SalesmanInfoRepo salesmanInfoRepo;
    @Autowired
    private SalesmanInfoRepoProc salesmanInfoRepoProc;
    @Autowired
    private RmiSysUDCService rmiSysUDCService;
    @Autowired
    private EmployeeRpcService employeeRpcService;
    @Autowired
    private OrgRpcService orgRpcService;
    @Autowired
    private Constant constant;
    @Autowired
    private SalesmanRegionRepo salesmanRegionRepo;
    @Autowired
    private OrgOuRpcService orgOuRpcService;
    @Autowired
    private SysAreaRpcService sysAreaRpcService;
    @Autowired
    private SysUserPermissionRpcService sysUserPermissionRpcService;
    @Autowired
    private SalesmanRpcServiceImpl salesmanRpcService;
    @Autowired
    private CrmCustRepoProc crmCustRepoProc;
    @Autowired
    private SearchBeanService searchBeanService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> save(SalesmanInfoSaveVO salesmanInfoSaveVO) {

        log.info("业务员信息保存入参 {}", salesmanInfoSaveVO.toString());
        if (salesmanInfoSaveVO.getSalesmanType().equals(UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getValueCode())
                && CollUtil.isEmpty(salesmanInfoSaveVO.getJurisdictions())) {
            return ApiResult.fail("销售总监必须填写管辖区域！");
        }
        if (salesmanInfoSaveVO.getSalesmanType().equals(UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getValueCode())
                && salesmanInfoSaveVO.getLeaderUserId() != null) {
            return ApiResult.fail("销售总监不允许有上级");
        }

        SalesmanInfoDO bySalesmanNo = salesmanInfoRepo.findBySalesmanNo(salesmanInfoSaveVO.getSalesmanNo());
        if (Optional.ofNullable(bySalesmanNo).isPresent() && (salesmanInfoSaveVO.getId() == null || salesmanInfoSaveVO.getId() == 0)) {
            return ApiResult.fail("该编号已存在，请重新输入");
        }
        SalesmanInfoDO byLoginAccount = salesmanInfoRepo.findByLoginAccount(salesmanInfoSaveVO.getLoginAccount());
        if (Optional.ofNullable(byLoginAccount).isPresent() && (salesmanInfoSaveVO.getId() == null || salesmanInfoSaveVO.getId() == 0)){
            throw new BusinessException("该登录账号已存在，请重新输入");
        }
        if (salesmanInfoSaveVO.getId() != null){
            salesmanRegionRepo.deleteByMasId(salesmanInfoSaveVO.getId());
        }
        SalesmanInfoDO salesmanInfoDO = SalesmanInfoConvert.INSTANCE.salesmanInfoSaveToDO(salesmanInfoSaveVO);
        salesmanInfoDO.setEnableStatus(1);

        EmployeeUpsertDTO upsertDTO = SalesmanInfoConvert.INSTANCE.salesmanInfoSaveVOToUpsertDTO(salesmanInfoSaveVO);
        if (StringUtils.isNotBlank(salesmanInfoSaveVO.getBirthdayTime())){
            upsertDTO.setBirthDate(constant.stringToLocalDate(salesmanInfoSaveVO.getBirthdayTime()));
        }
        if (StringUtils.isNotBlank(salesmanInfoSaveVO.getJoinTime())) {
            upsertDTO.setJoinTime(constant.swapTimeMin(salesmanInfoSaveVO.getJoinTime()));
        }
        //保存员工信息
        buildEmployee(salesmanInfoSaveVO, salesmanInfoDO, upsertDTO);
        //保存业务员信息
        SalesmanInfoDO save = salesmanInfoRepo.save(salesmanInfoDO);
        //保存业务员区域
        List<SalesmanRegionDO> salesmanRegionDOS = new ArrayList<>();
        if (CollUtil.isNotEmpty(salesmanInfoSaveVO.getJurisdictions())){
            for (String jurisdiction : salesmanInfoSaveVO.getJurisdictions()) {
                SalesmanRegionDO salesmanRegionDO = new SalesmanRegionDO();
                salesmanRegionDO.setRegionCode(jurisdiction);
                salesmanRegionDO.setMasId(save.getId());
                salesmanRegionDOS.add(salesmanRegionDO);
            }
        }
        salesmanRegionRepo.saveAll(salesmanRegionDOS);
        return ApiResult.ok();
    }

    private void buildEmployee(SalesmanInfoSaveVO salesmanInfoSaveVO, SalesmanInfoDO salesmanInfoDO, EmployeeUpsertDTO employeeUpsertDTO) {
        AreaVO areaVO = new AreaVO();
        areaVO.setProvinceCode(salesmanInfoSaveVO.getProvince());
        areaVO.setCityCode(salesmanInfoSaveVO.getCity());
        areaVO.setCountyCode(salesmanInfoSaveVO.getArea());
        EmployeeUpsertDTO.EmployeeOrg employeeOrg = new EmployeeUpsertDTO.EmployeeOrg();
        employeeOrg.setOrgId(salesmanInfoSaveVO.getBuId());
        employeeOrg.setLeaderUserId(salesmanInfoSaveVO.getLeaderUserId());
        if (salesmanInfoSaveVO.getSex() != null) {
            employeeUpsertDTO.setGender(salesmanInfoSaveVO.getSex().equals(1) ? "MALE" : "FEMALE");
        }
        employeeUpsertDTO.setAreaVO(areaVO);
        employeeUpsertDTO.setPhone(salesmanInfoSaveVO.getPhone());
        employeeUpsertDTO.setType(UdcEnum.CUST_TYPE_SALESMAN.getValueCode());
        employeeUpsertDTO.setId(salesmanInfoSaveVO.getUserId());
        employeeUpsertDTO.setOrgList(List.of(employeeOrg));
        employeeUpsertDTO.setCode(salesmanInfoDO.getSalesmanNo());
        ApiResult<String> result = employeeRpcService.upsert(employeeUpsertDTO);
        if (!result.isSuccess()) {
            throw new BusinessException(result.getMsg()+" 保存员工失败");
        }
        UserRoleSaveDTO userRoleSaveDTO = new UserRoleSaveDTO();
        userRoleSaveDTO.setUsername(salesmanInfoSaveVO.getLoginAccount());
        userRoleSaveDTO.setRoleCodes(Collections.singleton(Constant.SALESMAN));
        ApiResult<List<Long>> userRoles = sysUserPermissionRpcService.saveUserRoles(Collections.singletonList(userRoleSaveDTO));
        if (userRoles.isFailed()){
            throw new BusinessException(userRoles.getMsg()+" 保存业务员角色失败");
        }
    }

    @Override
    public ApiResult<PagingVO<SalesmanInfoRespVO>> query(SalesmanInfoQueryVO salesmanInfoQueryVO) {
        log.info("业务员信息分页查询入参 {}", salesmanInfoQueryVO);

        Map<String, String> salesmanTypeUDCMap = rmiSysUDCService.getCodeMap("yst-sale", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
        Map<String, String> regionUDCMap = rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.CRM_CUST_REGION_HN_NORTH.getCode());
        //无条件查询（只查询没有上级的）
        if (salesmanInfoQueryVO.getNoQueryParam() == 1) {
            List<EmployeePageRespDTO> employeePageRespDTOList = getWithoutLeaderEmployee();
            List<EmployeeInfoRespVO> employeeInfoRespVOS = SalesmanInfoConvert.INSTANCE.employeePageRespDTOToEmployeeInfoRespVO(employeePageRespDTOList);
            Map<String, EmployeeInfoRespVO> employeeInfoRespVOMap = employeeInfoRespVOS.stream()
                            .collect(Collectors.toMap(EmployeeInfoRespVO::getCode, Function.identity(), (k1, k2) -> k1));
            salesmanInfoQueryVO.setCodes(employeePageRespDTOList.stream().map(EmployeePageRespDTO::getCode).collect(Collectors.toList()));
            JPAQuery<SalesmanInfoRespVO> jpaQuery = salesmanInfoRepoProc.findSalesmanInfo(salesmanInfoQueryVO);
            List<SalesmanInfoRespVO> salesmanInfoRespVOList = jpaQuery.fetch();
            if (CollUtil.isEmpty(salesmanInfoRespVOList)) {
                ApiResult.ok(PagingVO.<SalesmanInfoRespVO>builder()
                        .total(0)
                        .records(Collections.emptyList())
                        .build());
            }
            Map<Long, List<SalesmanRegionVO>> regionMap = getSalesmanRegionMap(regionUDCMap, salesmanInfoRespVOList.stream().map(SalesmanInfoRespVO::getId).collect(Collectors.toList()));
            // 拼接数据
            for (SalesmanInfoRespVO salesmanInfoRespVO : salesmanInfoRespVOList) {
                salesmanInfoRespVO.setEmployeeInfoRespVO(employeeInfoRespVOMap.get(salesmanInfoRespVO.getSalesmanNo()));
                salesmanInfoRespVO.setEnableStatusName(salesmanInfoRespVO.getEnableStatus() == 1 ? "启用" : "禁用");
                salesmanInfoRespVO.setSalesmanTypeName(salesmanTypeUDCMap.get(salesmanInfoRespVO.getSalesmanType()));
                salesmanInfoRespVO.setJurisdiction(regionMap.get(salesmanInfoRespVO.getId()));
                if(CollUtil.isNotEmpty(salesmanInfoRespVO.getJurisdiction())){
                    String jurisdictionName = salesmanInfoRespVO.getJurisdiction().stream().map(SalesmanRegionVO::getRegionName).filter(StringUtils::isNotEmpty).collect(Collectors.joining(","));
                    salesmanInfoRespVO.setJurisdictionName(jurisdictionName);
                }
            }
            List<SalesmanInfoRespVO> page = ListUtil.page(salesmanInfoQueryVO.getCurrent(), salesmanInfoQueryVO.getSize(), salesmanInfoRespVOList);
            return ApiResult.ok(PagingVO.<SalesmanInfoRespVO>builder()
                    .total(salesmanInfoRespVOList.size())
                    .records(page)
                    .build());
        }

        //查询所有业务员类型的员工信息
        EmployeePageQueryDTO employeePageQueryDTO = new EmployeePageQueryDTO();
        employeePageQueryDTO.setType(UdcEnum.CUST_TYPE_SALESMAN.getValueCode());
        employeePageQueryDTO.setSize(60000);
        ApiResult<PagingVO<EmployeePageRespDTO>> result = employeeRpcService.queryByPage(employeePageQueryDTO);
        if (!result.isSuccess()) {
            throw new BusinessException("员工信息查询失败！" + result.getMsg());
        }
        //员工数据
        List<EmployeePageRespDTO> employeePageRespDTOList = result.getData().getRecords();
        if (CollUtil.isEmpty(employeePageRespDTOList)){
            return ApiResult.ok(PagingVO.<SalesmanInfoRespVO>builder()
                    .total(0)
                    .records(Collections.emptyList())
                    .build());
        }
        if (StringUtils.isNotBlank(salesmanInfoQueryVO.getSalesman())) {
            employeePageRespDTOList = employeePageRespDTOList.stream().filter(s -> {
                if (StringUtils.isNotBlank(s.getFullName()) && StringUtils.isNotBlank(s.getCode())) {
                    if (s.getFullName().contains(salesmanInfoQueryVO.getSalesman()) || s.getCode().contains(salesmanInfoQueryVO.getSalesman())){
                        return true;
                    }
                }
                return false;
            }).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank(salesmanInfoQueryVO.getOrgId())) {
            employeePageRespDTOList = employeePageRespDTOList.stream().filter(s -> {
                if (CollUtil.isNotEmpty(s.getOrgList())){
                    for (IdCodeNameParam idCodeNameParam : s.getOrgList()) {
                        if (Long.valueOf(salesmanInfoQueryVO.getOrgId()).equals(idCodeNameParam.getId())) {
                            return true;
                        }
                    }
                }
                return false;
            }).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank(salesmanInfoQueryVO.getLoginAccount())) {
            employeePageRespDTOList = employeePageRespDTOList.stream().filter(s -> {
                if (StringUtils.isNotBlank(s.getUsername()) && s.getUsername().contains(salesmanInfoQueryVO.getLoginAccount())){
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank(salesmanInfoQueryVO.getPhone())) {
            employeePageRespDTOList = employeePageRespDTOList.stream().filter(s -> {
                if (StringUtils.isNotBlank(s.getPhone()) && s.getPhone().contains(salesmanInfoQueryVO.getPhone())){
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
        }
        if (CollUtil.isEmpty(employeePageRespDTOList)){
            return ApiResult.ok(PagingVO.<SalesmanInfoRespVO>builder()
                    .total(0)
                    .records(Collections.emptyList())
                    .build());
        }

        List<EmployeeInfoRespVO> employeeInfoRespVOS = SalesmanInfoConvert.INSTANCE.employeePageRespDTOToEmployeeInfoRespVO(employeePageRespDTOList);
        Map<String, EmployeeInfoRespVO> employeeInfoRespVOMap = employeeInfoRespVOS.stream()
                .collect(Collectors.toMap(EmployeeInfoRespVO::getCode, Function.identity(), (k1, k2) -> k1));
        salesmanInfoQueryVO.setCodes(employeePageRespDTOList.stream().map(EmployeePageRespDTO::getCode).collect(Collectors.toList()));
        JPAQuery<SalesmanInfoRespVO> jpaQuery = salesmanInfoRepoProc.findSalesmanInfo(salesmanInfoQueryVO);
        List<SalesmanInfoRespVO> salesmanInfoRespVOList = jpaQuery.fetch();
        if (CollUtil.isEmpty(salesmanInfoRespVOList)) {
            return ApiResult.ok(PagingVO.<SalesmanInfoRespVO>builder()
                    .total(0)
                    .records(Collections.emptyList())
                    .build());
        }
        if (StringUtils.isNotBlank(salesmanInfoQueryVO.getOuCode())){
            salesmanInfoRespVOList = salesmanInfoRespVOList.stream().filter(s -> {
                if (salesmanInfoQueryVO.getOuCode().equals(s.getOuCode())){
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
        }
        if (salesmanInfoQueryVO.getEnableStatus() != null){
            salesmanInfoRespVOList = salesmanInfoRespVOList.stream().filter(s -> {
                if (salesmanInfoQueryVO.getEnableStatus().equals(s.getEnableStatus())){
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank(salesmanInfoQueryVO.getSalesmanType())){
            salesmanInfoRespVOList = salesmanInfoRespVOList.stream().filter(s -> {
                if (salesmanInfoQueryVO.getSalesmanType().equals(s.getSalesmanType())){
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
        }
        if (CollUtil.isEmpty(salesmanInfoRespVOList)){
            return ApiResult.ok(PagingVO.<SalesmanInfoRespVO>builder()
                    .total(0)
                    .records(Collections.emptyList())
                    .build());
        }
        Map<Long, List<SalesmanRegionVO>> regionMap = getSalesmanRegionMap(regionUDCMap, salesmanInfoRespVOList.stream().map(SalesmanInfoRespVO::getId).collect(Collectors.toList()));
        // 拼接数据
        for (SalesmanInfoRespVO salesmanInfoRespVO : salesmanInfoRespVOList) {
            salesmanInfoRespVO.setEmployeeInfoRespVO(employeeInfoRespVOMap.get(salesmanInfoRespVO.getSalesmanNo()));
            salesmanInfoRespVO.setEnableStatusName(salesmanInfoRespVO.getEnableStatus() == 1 ? "启用" : "禁用");
            salesmanInfoRespVO.setSalesmanTypeName(salesmanTypeUDCMap.get(salesmanInfoRespVO.getSalesmanType()));
            salesmanInfoRespVO.setJurisdiction(regionMap.get(salesmanInfoRespVO.getId()));
            if(CollUtil.isNotEmpty(salesmanInfoRespVO.getJurisdiction())){
                String jurisdictionName = salesmanInfoRespVO.getJurisdiction().stream().map(SalesmanRegionVO::getRegionName).filter(StringUtils::isNotEmpty).collect(Collectors.joining(","));
                salesmanInfoRespVO.setJurisdictionName(jurisdictionName);
            }
        }
        List<SalesmanInfoRespVO> page = ListUtil.page(salesmanInfoQueryVO.getCurrent(), salesmanInfoQueryVO.getSize(), salesmanInfoRespVOList);
        return ApiResult.ok(PagingVO.<SalesmanInfoRespVO>builder()
                .total(salesmanInfoRespVOList.size())
                .records(page)
                .build());
    }

    @Nullable
    private List<EmployeePageRespDTO> getWithoutLeaderEmployee() {
        EmployeePageQueryDTO employeePageQueryDTO = new EmployeePageQueryDTO();
        //employeePageQueryDTO.setType(UdcEnum.CUST_TYPE_SALESMAN.getValueCode());
        employeePageQueryDTO.setSize(60000);
        employeePageQueryDTO.setWithoutLeader(true);
        ApiResult<PagingVO<EmployeePageRespDTO>> result = employeeRpcService.queryByPage(employeePageQueryDTO);
        if (!result.isSuccess()) {
            throw new BusinessException("员工信息查询失败！" + result.getMsg());
        }
        //员工数据
        List<EmployeePageRespDTO> employeePageRespDTOList = result.getData().getRecords();
        if (CollUtil.isEmpty(employeePageRespDTOList)){
            ApiResult.ok(PagingVO.<SalesmanInfoRespVO>builder()
                    .total(0)
                    .build());
        }
        return employeePageRespDTOList;
    }


    // log.info("业务员信息分页查询入参 {}", salesmanInfoQueryVO);
        // Map<String, String> salesmanTypeUDCMap = rmiSysUDCService.getCodeMap("yst-sale", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
        // Map<String, String> regionUDCMap = rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.CRM_CUST_REGION_HN_NORTH.getCode());
        // //包含业务员条件查询或无条件查询
        // if (salesmanInfoQueryVO.getEnableStatus() != null
        //         || StringUtils.isNotBlank(salesmanInfoQueryVO.getOuCode())
        //         || StringUtils.isNotBlank(salesmanInfoQueryVO.getSalesmanType())
        //         || salesmanInfoQueryVO.getNoQueryParam() == 1) {
        //     //无条件查询
        //     if (salesmanInfoQueryVO.getNoQueryParam() == 1){
        //         EmployeePageQueryDTO employeePageQueryDTO = SalesmanInfoConvert.INSTANCE.salesmanInfoQueryVOToQueryDTO(salesmanInfoQueryVO);
        //         employeePageQueryDTO.setKeyword(salesmanInfoQueryVO.getSalesman());
        //         employeePageQueryDTO.setSize(salesmanInfoQueryVO.getSize());
        //         employeePageQueryDTO.setType(UdcEnum.CUST_TYPE_SALESMAN.getValueCode());
        //         employeePageQueryDTO.setCurrent(salesmanInfoQueryVO.getCurrent() + 2);
        //         employeePageQueryDTO.setOrders(salesmanInfoQueryVO.getOrders());
        //         employeePageQueryDTO.setWithoutLeader(true);
        //         ApiResult<PagingVO<EmployeePageRespDTO>> result = employeeRpcService.queryByPage(employeePageQueryDTO);
        //         if (!result.isSuccess()) {
        //             throw new BusinessException("员工信息查询失败！" + result.getMsg()
        //             );
        //         }
        //         log.info("查询员工信息结果 {}", JSON.toJSONString(result.getData()));
        //         //员工数据
        //         List<EmployeePageRespDTO> employeePageRespDTOList = result.getData().getRecords();
        //         if (CollUtil.isEmpty(employeePageRespDTOList)){
        //             ApiResult.ok(PagingVO.<SalesmanInfoRespVO>builder()
        //                     .total(0)
        //                     .build());
        //         }
        //         List<EmployeeInfoRespVO> employeeInfoRespVOS = SalesmanInfoConvert.INSTANCE.employeePageRespDTOToEmployeeInfoRespVO(employeePageRespDTOList);
        //         Map<String, EmployeeInfoRespVO> employeeInfoRespVOMap = employeeInfoRespVOS.stream()
        //                 .collect(Collectors.toMap(EmployeeInfoRespVO::getCode, Function.identity(), (k1, k2) -> k1));
        //         salesmanInfoQueryVO.setCodes(employeePageRespDTOList.stream().map(EmployeePageRespDTO::getCode).collect(Collectors.toList()));
        //         salesmanInfoQueryVO.setCurrent(0);
        //         JPAQuery<SalesmanInfoRespVO> jpaQuery = salesmanInfoRepoProc.findSalesmanInfo(salesmanInfoQueryVO);
        //         List<SalesmanInfoRespVO> salesmanInfoRespVOList = jpaQuery.fetch();
        //         Map<Long, List<SalesmanRegionVO>> regionMap = getSalesmanRegionMap(regionUDCMap, salesmanInfoRespVOList.stream().map(SalesmanInfoRespVO::getId).collect(Collectors.toList()));
        //         if (CollUtil.isEmpty(salesmanInfoRespVOList)) {
        //             return ApiResult.ok();
        //         }
        //         //拼接数据
        //         for (SalesmanInfoRespVO salesmanInfoRespVO : salesmanInfoRespVOList) {
        //             salesmanInfoRespVO.setEmployeeInfoRespVO(employeeInfoRespVOMap.get(salesmanInfoRespVO.getSalesmanNo()));
        //             salesmanInfoRespVO.setEnableStatusName(salesmanInfoRespVO.getEnableStatus() == 1 ? "启用" : "禁用");
        //             salesmanInfoRespVO.setSalesmanTypeName(salesmanTypeUDCMap.get(salesmanInfoRespVO.getSalesmanType()));
        //             salesmanInfoRespVO.setJurisdiction(regionMap.get(salesmanInfoRespVO.getId()));
        //         }
        //         return ApiResult.ok(PagingVO.<SalesmanInfoRespVO>builder()
        //                 .total(result.getData().getTotal())
        //                 .records(salesmanInfoRespVOList)
        //                 .build());
        //     }
        //
        //     //条件查询
        //     JPAQuery<SalesmanInfoRespVO> jpaQuery = salesmanInfoRepoProc.findSalesmanInfo(salesmanInfoQueryVO);
        //     List<SalesmanInfoRespVO> salesmanInfoRespVOList = jpaQuery.fetch();
        //     if (CollUtil.isEmpty(salesmanInfoRespVOList)) {
        //         return ApiResult.ok();
        //     }
        //     Map<Long, List<SalesmanRegionVO>> regionMap = getSalesmanRegionMap(regionUDCMap, salesmanInfoRespVOList.stream().map(SalesmanInfoRespVO::getId).collect(Collectors.toList()));
        //     Set<String> codeList = salesmanInfoRespVOList.stream().map(SalesmanInfoRespVO::getSalesmanNo).collect(Collectors.toSet());
        //     EmployeePageQueryDTO employeePageQueryDTO = SalesmanInfoConvert.INSTANCE.salesmanInfoQueryVOToQueryDTO(salesmanInfoQueryVO);
        //     employeePageQueryDTO.setKeyword(salesmanInfoQueryVO.getSalesman());
        //     employeePageQueryDTO.setCodes(codeList);
        //     employeePageQueryDTO.setType(UdcEnum.CUST_TYPE_SALESMAN.getValueCode());
        //     employeePageQueryDTO.setSize(salesmanInfoQueryVO.getSize());
        //     log.info("查询员工信息参数 {}", JSON.toJSONString(employeePageQueryDTO));
        //     ApiResult<PagingVO<EmployeePageRespDTO>> result = employeeRpcService.queryByPage(employeePageQueryDTO);
        //     if (!result.isSuccess()) {
        //         throw new BusinessException("员工信息查询失败！" + result.getMsg()
        //         );
        //     }
        //     log.info("查询员工信息结果 {}", JSON.toJSONString(result.getData()));
        //     //员工数据
        //     List<EmployeePageRespDTO> employeePageRespDTOList = result.getData().getRecords();
        //     if (CollUtil.isEmpty(employeePageRespDTOList)){
        //         ApiResult.ok(PagingVO.<SalesmanInfoRespVO>builder()
        //                 .total(result.getData().getTotal())
        //                 .records(salesmanInfoRespVOList)
        //                 .build());
        //     }
        //     List<EmployeeInfoRespVO> employeeInfoRespVOS = SalesmanInfoConvert.INSTANCE.employeePageRespDTOToEmployeeInfoRespVO(employeePageRespDTOList);
        //     Map<String, EmployeeInfoRespVO> employeeInfoRespVOMap = employeeInfoRespVOS.stream()
        //             .collect(Collectors.toMap(EmployeeInfoRespVO::getCode, Function.identity(), (k1, k2) -> k1));
        //     //过滤
        //     salesmanInfoRespVOList = salesmanInfoRespVOList.stream().filter(s -> {
        //         if (Optional.ofNullable(employeeInfoRespVOMap.get(s.getSalesmanNo())).isPresent()) {
        //             return true;
        //         }
        //         return false;
        //     }).collect(Collectors.toList());
        //     //拼接数据
        //     for (SalesmanInfoRespVO salesmanInfoRespVO : salesmanInfoRespVOList) {
        //         salesmanInfoRespVO.setEmployeeInfoRespVO(employeeInfoRespVOMap.get(salesmanInfoRespVO.getSalesmanNo()));
        //         salesmanInfoRespVO.setEnableStatusName(salesmanInfoRespVO.getEnableStatus() == 1 ? "启用" : "禁用");
        //         salesmanInfoRespVO.setSalesmanTypeName(salesmanTypeUDCMap.get(salesmanInfoRespVO.getSalesmanType()));
        //         salesmanInfoRespVO.setJurisdiction(regionMap.get(salesmanInfoRespVO.getId()));
        //     }
        //     return ApiResult.ok(PagingVO.<SalesmanInfoRespVO>builder()
        //             .total(result.getData().getTotal())
        //             .records(salesmanInfoRespVOList)
        //             .build());
        //
        //     //只包含员工查询条件
        // } else if (salesmanInfoQueryVO.getNoQueryParam() != 1) {
        //     EmployeePageQueryDTO employeePageQueryDTO = SalesmanInfoConvert.INSTANCE.salesmanInfoQueryVOToQueryDTO(salesmanInfoQueryVO);
        //     if (salesmanInfoQueryVO.getOrgId() != null){
        //         employeePageQueryDTO.setOrgId(Long.valueOf(salesmanInfoQueryVO.getOrgId()));
        //     }
        //     employeePageQueryDTO.setKeyword(salesmanInfoQueryVO.getSalesman());
        //     employeePageQueryDTO.setSize(salesmanInfoQueryVO.getSize());
        //     employeePageQueryDTO.setType(UdcEnum.CUST_TYPE_SALESMAN.getValueCode());
        //     employeePageQueryDTO.setCurrent(salesmanInfoQueryVO.getCurrent() + 2);
        //     employeePageQueryDTO.setOrders(salesmanInfoQueryVO.getOrders());
        //     employeePageQueryDTO.setEnabled(true);
        //     //先查询员工信息
        //     log.info("查询员工信息参数 {}", JSON.toJSONString(employeePageQueryDTO));
        //     ApiResult<PagingVO<EmployeePageRespDTO>> result = employeeRpcService.queryByPage(employeePageQueryDTO);
        //     if (!result.isSuccess()) {
        //         throw new BusinessException("员工信息查询失败！" + result.getMsg());
        //     }
        //     if (result.getData().getTotal() == 0) {
        //         return ApiResult.ok();
        //     }
        //     log.info("查询员工信息结果 {}", JSON.toJSONString(result.getData()));
        //     List<EmployeePageRespDTO> employeePageRespDTOS = result.getData().getRecords();
        //     List<EmployeeInfoRespVO> employeeInfoRespVOS = SalesmanInfoConvert.INSTANCE.employeePageRespDTOToEmployeeInfoRespVO(employeePageRespDTOS);
        //     Map<String, EmployeeInfoRespVO> employeeInfoRespVOMap = employeeInfoRespVOS.stream()
        //             .collect(Collectors.toMap(EmployeeInfoRespVO::getCode, Function.identity(), (k1, k2) -> k1));
        //     List<String> codeList = employeeInfoRespVOS.stream().map(EmployeeInfoRespVO::getCode).collect(Collectors.toList());
        //     //查询业务员信息
        //     salesmanInfoQueryVO.setCurrent(0);
        //     JPAQuery<SalesmanInfoRespVO> jpaQuery = salesmanInfoRepoProc.findByRelateCode(codeList, salesmanInfoQueryVO);
        //     List<SalesmanInfoRespVO> infoRespVOS = jpaQuery.fetch();
        //     //获取区域信息
        //     Map<Long, List<SalesmanRegionVO>> regionMap = getSalesmanRegionMap(regionUDCMap, infoRespVOS.stream().map(SalesmanInfoRespVO::getId).collect(Collectors.toList()));
        //     //拼接数据
        //     for (SalesmanInfoRespVO salesmanInfoRespVO : infoRespVOS) {
        //         salesmanInfoRespVO.setEmployeeInfoRespVO(employeeInfoRespVOMap.get(salesmanInfoRespVO.getSalesmanNo()));
        //         salesmanInfoRespVO.setEnableStatusName(salesmanInfoRespVO.getEnableStatus() == 1 ? "启用" : "禁用");
        //         salesmanInfoRespVO.setSalesmanTypeName(salesmanTypeUDCMap.get(salesmanInfoRespVO.getSalesmanType()));
        //         salesmanInfoRespVO.setJurisdiction(regionMap.get(salesmanInfoRespVO.getId()));
        //     }
        //     return ApiResult.ok(PagingVO.<SalesmanInfoRespVO>builder()
        //             .total(result.getData().getTotal())
        //             .records(infoRespVOS)
        //             .build());
        // }

    @Override
    public List<SalesmanInfoSimpleRespVO> simpleQuery(SalesmanInfoSimpleQueryVO param){
        log.info("业务员基本信息查询入参 {}", param);
        List<SalesmanInfoSimpleRespVO> simpleRespVOS = salesmanInfoRepoProc.simpleQuery(param);
        if (CollUtil.isEmpty(simpleRespVOS)){
            return new ArrayList<>();
        }
        Set<String> codes = simpleRespVOS.stream().map(SalesmanInfoSimpleRespVO::getSalesmanNo).collect(Collectors.toSet());
        ApiResult<List<SysEmployeeDetailDTO>> detailListByCode = employeeRpcService.getDetailListByCode(codes);
        if (!detailListByCode.isSuccess()){
            return simpleRespVOS;
        }
        List<SysEmployeeDetailDTO> employeeDetailDTOS = detailListByCode.getData();
        Map<String, SysEmployeeDetailDTO> detailDTOMap = employeeDetailDTOS.stream().collect(Collectors.toMap(SysEmployeeDetailDTO::getCode, v -> v, (v1, v2) -> v1));
        for (SalesmanInfoSimpleRespVO simpleRespVO : simpleRespVOS) {
            SysEmployeeDetailDTO employeeDetailDTO = detailDTOMap.get(simpleRespVO.getSalesmanNo());
            if (Optional.ofNullable(employeeDetailDTO).isPresent()) {
                simpleRespVO.setFullName(employeeDetailDTO.getFullName());
                simpleRespVO.setAreaVO(employeeDetailDTO.getAreaVO());
                simpleRespVO.setAddress(employeeDetailDTO.getAddress());
                simpleRespVO.setPhone(employeeDetailDTO.getPhone());
            }
        }
        return simpleRespVOS;
    }

    @Override
    public SalesmanInfoAppDetailRespVO appQueryDetail(String code) {
        log.info("业务员app个人信息查询入参 {}", code);
        SalesmanInfoAppDetailRespVO salesmanInfoAppDetailRespVO = new SalesmanInfoAppDetailRespVO();
        if (StringUtils.isBlank(code)){
            throw new BusinessException(ApiCode.FAIL, "业务员账号为空！");
        }
        SalesmanInfoDO salesmanInfoDO = salesmanInfoRepo.findByLoginAccount(code);
        if (Optional.ofNullable(salesmanInfoDO).isEmpty()){
            return salesmanInfoAppDetailRespVO;
        }
        Map<String, String> salesmanTypeUDCMap = rmiSysUDCService.getCodeMap("yst-sale", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
        salesmanInfoAppDetailRespVO.setId(salesmanInfoDO.getId());
        salesmanInfoAppDetailRespVO.setSalesmanNo(salesmanInfoDO.getSalesmanNo());
        salesmanInfoAppDetailRespVO.setFileCode(salesmanInfoDO.getFileCode());
        salesmanInfoAppDetailRespVO.setSalesmanType(salesmanInfoDO.getSalesmanType());
        salesmanInfoAppDetailRespVO.setSalesmanTypeName(salesmanTypeUDCMap.get(salesmanInfoDO.getSalesmanType()));
        salesmanInfoAppDetailRespVO.setEnableStatus(salesmanInfoDO.getEnableStatus());
        salesmanInfoAppDetailRespVO.setEnableStatusName(salesmanInfoDO.getEnableStatus() == 1 ? "启用" : "禁用");
        ApiResult<SysEmployeeDetailDTO> detailByCode = employeeRpcService.getDetailByCode(salesmanInfoDO.getSalesmanNo());
        if (!detailByCode.isSuccess()) {
            log.error("查询员工详情信息失败！ {}", detailByCode.getMsg());
            return salesmanInfoAppDetailRespVO;
        }
        SysEmployeeDetailDTO employeeDetailDTO = detailByCode.getData();
        salesmanInfoAppDetailRespVO.setUsername(employeeDetailDTO.getUsername());
        salesmanInfoAppDetailRespVO.setPhone(employeeDetailDTO.getPhone());
        salesmanInfoAppDetailRespVO.setFullName(employeeDetailDTO.getFullName());
        List<SalesmanInfoAppDetailRespVO.EmployeeOrg> employeeOrgs = new ArrayList<>();
        if (CollUtil.isNotEmpty(employeeDetailDTO.getOrgList())){
            for (SysEmployeeDetailDTO.EmployeeOrg employeeOrg : employeeDetailDTO.getOrgList()) {
                SalesmanInfoAppDetailRespVO.EmployeeOrg org = new SalesmanInfoAppDetailRespVO.EmployeeOrg();
                org.setOrgId(employeeOrg.getOrgId());
                org.setOrgName(employeeOrg.getOrgName());
                employeeOrgs.add(org);
            }
        }
        salesmanInfoAppDetailRespVO.setOrgList(employeeOrgs);

        return salesmanInfoAppDetailRespVO;
    }


    public Map<Long, List<SalesmanRegionVO>> getSalesmanRegionMap(Map<String, String> regionUDCMap, List<Long> ids) {
        List<SalesmanRegionDO> regionDOS = salesmanRegionRepo.findByMasIdIn(ids);
        Map<Long, List<SalesmanRegionVO>> regionMap = new HashMap<>();
        if (CollUtil.isNotEmpty(regionDOS)){
            //翻译区域udc
            List<SalesmanRegionVO> salesmanRegionVOS = SalesmanInfoConvert.INSTANCE.salesmanRegionDOToVo(regionDOS);
            for (SalesmanRegionVO regionVO : salesmanRegionVOS) {
                regionVO.setRegionName(regionUDCMap.get(regionVO.getRegionCode()));
            }
            regionMap = salesmanRegionVOS.stream().collect(Collectors.groupingBy(SalesmanRegionVO::getMasId));
        }
        return regionMap;
    }

    @Override
    public ApiResult<SalesmanInfoDetailRespVO> queryDetail(Long id) {
        log.info("业务员详细信息查询入参 {}", id);
        Optional<SalesmanInfoDO> salesmanInfoDOOptional = salesmanInfoRepo.findById(id);
        if (salesmanInfoDOOptional.isEmpty()) {
            return ApiResult.ok();
        }
        Map<String, String> salesmanTypeUDCMap = rmiSysUDCService.getCodeMap("yst-sale", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
        Map<String, String> regionUDCMap = rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.CRM_CUST_REGION_HN_NORTH.getCode());
        SalesmanInfoDO salesmanInfoDO = salesmanInfoDOOptional.get();
        ApiResult<SysEmployeeDetailDTO> detailByCode = employeeRpcService.getDetailByCode(salesmanInfoDO.getSalesmanNo());
        if (!detailByCode.isSuccess()) {
            throw new BusinessException("查询员工详情信息失败！" + detailByCode.getMsg());
        }
            EmployeeDetailInfoRespVO employeeDetailInfoRespVO = SalesmanInfoConvert.INSTANCE.SysEmployeeDetailDTOToRespVO(detailByCode.getData());
        SalesmanInfoDetailRespVO salesmanInfoDetailRespVO = SalesmanInfoConvert.INSTANCE.salesmanInfoDOToDetailRespVO(salesmanInfoDO);
        //查询区域信息
        Map<Long, List<SalesmanRegionVO>> salesmanRegionMap = getSalesmanRegionMap(regionUDCMap, List.of(salesmanInfoDO.getId()));
        salesmanInfoDetailRespVO.setEnableStatusName(salesmanInfoDetailRespVO.getEnableStatus() == 1 ? "启用" : "禁用");
        salesmanInfoDetailRespVO.setSalesmanTypeName(salesmanTypeUDCMap.get(salesmanInfoDetailRespVO.getSalesmanType()));
        salesmanInfoDetailRespVO.setJurisdiction(salesmanRegionMap.get(salesmanInfoDO.getId()));
        salesmanInfoDetailRespVO.setEmployeeDetailInfoRespVO(employeeDetailInfoRespVO);
        return ApiResult.ok(salesmanInfoDetailRespVO);
    }

    @Override
    public SysEmployeeBasicDTO queryDetailByUserId(Long userId) {
        ApiResult<SysEmployeeBasicDTO> empInfo = employeeRpcService.getByUserId(userId);
        if(empInfo.isSuccess()){
            return empInfo.getData();
        }
        return null;
    }

    @Override
    public ApiResult<PagingVO<SalesmanInfoRespVO>> querySubordinate(SalesmanSubordinateQueryVO salesmanSubordinateQueryVO) {

        log.info("业务员下级信息查询入参 {}", salesmanSubordinateQueryVO);
        ApiResult<List<EmployeeUnderlingDTO>> apiResult = employeeRpcService.getUnderlingByCode(salesmanSubordinateQueryVO.getCode(), true, null);
        if (!apiResult.isSuccess()) {
            throw new BusinessException("查询员工下级信息失败！" + apiResult.getMsg());
        }
        //员工信息
        List<EmployeeUnderlingDTO> resultData = apiResult.getData();
        List<String> codeList = new ArrayList<>();
        if (CollUtil.isEmpty(resultData)) {
            return ApiResult.ok();
        }
        codeList.addAll(resultData.stream().map(EmployeeUnderlingDTO::getCode).collect(Collectors.toList()));
        List<EmployeeInfoRespVO> employeeInfoRespVOS = SalesmanInfoConvert.INSTANCE.employeeUnderlingDTOToRespVO(resultData);
        Map<String, EmployeeInfoRespVO> employeeInfoRespVOMap = employeeInfoRespVOS.stream()
                .collect(Collectors.toMap(EmployeeInfoRespVO::getCode, Function.identity(), (k1, k2) -> k1));
        //业务员信息
        JPAQuery<SalesmanInfoRespVO> jpaQuery = salesmanInfoRepoProc.findByRelateCode(codeList, salesmanSubordinateQueryVO);
        List<SalesmanInfoRespVO> salesmanInfoRespVOS = jpaQuery.fetch();
        if (CollUtil.isEmpty(salesmanInfoRespVOS)) {
            return ApiResult.ok();
        }
        //翻译UDC,拼接数据
        Map<String, String> salesmanTypeUDCMap = rmiSysUDCService.getCodeMap("yst-sale", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
        Map<String, String> regionUDCMap = rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.CRM_CUST_REGION_HN_NORTH.getCode());

        Map<Long, List<SalesmanRegionVO>> salesmanRegionMap = getSalesmanRegionMap(regionUDCMap, salesmanInfoRespVOS.stream().map(SalesmanInfoRespVO::getId).collect(Collectors.toList()));
        for (SalesmanInfoRespVO salesmanInfoRespVO : salesmanInfoRespVOS) {
            salesmanInfoRespVO.setEnableStatusName(salesmanInfoRespVO.getEnableStatus() == 1 ? "启用" : "禁用");
            salesmanInfoRespVO.setSalesmanTypeName(salesmanTypeUDCMap.get(salesmanInfoRespVO.getSalesmanType()));
            salesmanInfoRespVO.setJurisdiction(salesmanRegionMap.get(salesmanInfoRespVO.getId()));
            salesmanInfoRespVO.setEmployeeInfoRespVO(employeeInfoRespVOMap.get(salesmanInfoRespVO.getSalesmanNo()));
            if (CollUtil.isNotEmpty(salesmanInfoRespVO.getEmployeeInfoRespVO().getUnderlingList())){
                salesmanInfoRespVO.setHasUnder(true);
            }
        }

        return ApiResult.ok(PagingVO.<SalesmanInfoRespVO>builder()
                .total(jpaQuery.fetchCount())
                .records(salesmanInfoRespVOS)
                .build());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> changeStatus(SalesmanInfoChangeVO salesmanInfoChangeVO) {

        log.info("业务员状态信息更改入参 {}", salesmanInfoChangeVO);
        Optional<SalesmanInfoDO> salesmanInfoDO = salesmanInfoRepo.findById(salesmanInfoChangeVO.getId());
        if (salesmanInfoDO.isEmpty()) {
            return ApiResult.fail("未查询到信息");
        }
        if (salesmanInfoChangeVO.isSync()) {
            ApiResult<String> result = employeeRpcService.updateEnabledByCode(salesmanInfoChangeVO.getCode()
                    , salesmanInfoChangeVO.getEnableStatus() == 1 ? true : false);
            if (!result.isSuccess()) {
                throw new BusinessException("更新员工状态失败！" + result.getMsg());
            }
        }
        salesmanInfoRepoProc.changeEnableStatus(salesmanInfoChangeVO.getId(), salesmanInfoChangeVO.getEnableStatus());
        return ApiResult.ok();
    }

    @Override
    public ApiResult<PagingVO<SalesmanSuperiorRespVO>> querySuperior(SalesmanSuperiorQueryVO salesmanSuperiorQueryVO) {
        log.info("查询业务员上级入参 {}", JSON.toJSONString(salesmanSuperiorQueryVO));
        PagingVO<SalesmanSuperiorRespVO> page = salesmanInfoRepoProc.getSalesmanSelectPage(salesmanSuperiorQueryVO);
        if(page.isNotEmpty() && org.apache.commons.collections4.CollectionUtils.isNotEmpty(page.getRecords())){
            Map<String, String> salesmanTypeUDCMap = rmiSysUDCService.getCodeMap("yst-sale", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
            Set<String> codes = page.getRecords().stream().map(SalesmanSuperiorRespVO :: getSalesmanNo).collect(Collectors.toSet());
            EmployeeQueryDTO employeeQueryDTO = new EmployeeQueryDTO();
            employeeQueryDTO.setCodes(codes);
            ApiResult<List<SysEmployeeBasicDTO>> emp = employeeRpcService.queryList(employeeQueryDTO);
            Map<String,Long> map = new HashMap<>();
            if(emp.isSuccess() && org.apache.commons.collections4.CollectionUtils.isNotEmpty(emp.getData())){
                map = emp.getData().stream().collect(Collectors.toMap(SysEmployeeBasicDTO :: getCode,SysEmployeeBasicDTO :: getUserId,(t1,t2) -> t1));
            }
            Map<String, Long> finalMap = map;
            page.getRecords().forEach(p ->{
                p.setTypeName(salesmanTypeUDCMap.get(p.getType()));
                if(MapUtils.isNotEmpty(finalMap) && StringUtils.isNotBlank(p.getSalesmanNo())){
                    p.setUserId(finalMap.get(p.getSalesmanNo()));
                }
            });
        }
        return ApiResult.ok(page);
//
//        //业务员信息
//        JPAQuery<SalesmanSuperiorRespVO> jpaQuery = salesmanInfoRepoProc.findBySalesmanType(salesmanSuperiorQueryVO);
//        List<SalesmanSuperiorRespVO> salesmanSuperiorRespVOS = jpaQuery.fetch();
//        if (CollUtil.isEmpty(salesmanSuperiorRespVOS)) {
//            return ApiResult.ok();
//        }
//        Set<String> codeSet = salesmanSuperiorRespVOS.stream().map(SalesmanSuperiorRespVO::getSalesmanNo).collect(Collectors.toSet());
//        EmployeePageQueryDTO employeePageQueryDTO = new EmployeePageQueryDTO();
//        employeePageQueryDTO.setCodes(codeSet);
//        employeePageQueryDTO.setSize(salesmanSuperiorQueryVO.getSize());
//        if (StringUtils.isNotBlank(salesmanSuperiorQueryVO.getName())) {
//            employeePageQueryDTO.setKeyword(salesmanSuperiorQueryVO.getName());
//        }
//        employeePageQueryDTO.setSize(salesmanSuperiorQueryVO.getSize());
//        //员工信息
//        ApiResult<PagingVO<EmployeePageRespDTO>> pagingVOApiResult = employeeRpcService.queryByPage(employeePageQueryDTO);
//        if (!pagingVOApiResult.isSuccess()) {
//            throw new BusinessException("查询员工信息失败！" + pagingVOApiResult.getMsg());
//        }
//        List<EmployeePageRespDTO> employeePageRespDTOS = pagingVOApiResult.getData().getRecords();
//        if (CollUtil.isEmpty(employeePageRespDTOS)){
//            ApiResult.ok(PagingVO.<SalesmanSuperiorRespVO>builder()
//                    .total(pagingVOApiResult.getData().getTotal())
//                    .records(salesmanSuperiorRespVOS));
//        }
//        Map<String, EmployeePageRespDTO> userMap = employeePageRespDTOS.stream()
//                .collect(Collectors.toMap(EmployeePageRespDTO::getCode, Function.identity(), (k1, k2) -> k1));
//        Map<String, String> salesmanTypeUDCMap = rmiSysUDCService.getCodeMap("yst-sale", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
//        //剔除不需要的数据
//        salesmanSuperiorRespVOS = salesmanSuperiorRespVOS.stream().filter(s -> {
//            if (Optional.ofNullable(userMap.get(s.getSalesmanNo())).isPresent()) {
//                return true;
//            }
//            return false;
//        }).collect(Collectors.toList());
//        for (SalesmanSuperiorRespVO salesmanSuperiorRespVO : salesmanSuperiorRespVOS) {
//            if (Optional.ofNullable(userMap.get(salesmanSuperiorRespVO.getSalesmanNo())).isPresent()){
//                salesmanSuperiorRespVO.setUserId(userMap.get(salesmanSuperiorRespVO.getSalesmanNo()).getUserId());
//                salesmanSuperiorRespVO.setName(userMap.get(salesmanSuperiorRespVO.getSalesmanNo()).getFullName());
//                salesmanSuperiorRespVO.setTypeName(salesmanTypeUDCMap.get(salesmanSuperiorRespVO.getType()));
//            }
//        }
//        return ApiResult.ok(PagingVO.<SalesmanSuperiorRespVO>builder()
//                .total(salesmanSuperiorRespVOS.size())
//                .records(salesmanSuperiorRespVOS));
    }

    @Override
    public ApiResult<Object> salesmanImport(MultipartFile file) {
        ExcelEntityDataListener<SalesmanImportSaveVO> dataListener = new ExcelEntityDataListener<>();
        try {
            //从第三行开始读取数据
            EasyExcel.read(file.getInputStream(), SalesmanImportSaveVO.class, dataListener).sheet(0).headRowNumber(2).doRead();
        } catch (Exception e) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "导入数据异常，请检查导入 excel的列值是否与模板对应");
        }
        //读取数据
        List<SalesmanImportSaveVO> recommendRelateCustVOS = dataListener.getDatas();
        List<String> list = recommendRelateCustVOS.stream().map(SalesmanImportSaveVO::getSalesmanNo).collect(Collectors.toList());

        if (CollUtil.isEmpty(recommendRelateCustVOS)) {
            throw new BusinessException("导入数据为空");
        }
        StringBuffer failMsg = new StringBuffer();
        boolean failFlag = false;
        Map<String, String> salesmanTypeUDCMap = rmiSysUDCService.getCodeMap("yst-sale", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
        Map<String, String> newTypeMap = salesmanTypeUDCMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        Map<String, String> regionUDCMap = rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.CRM_CUST_REGION_HN_NORTH.getCode());
        Map<String, String> newRegionMap = regionUDCMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        //查询填写的业务员编码是否已存在
        Map<String, List<SalesmanInfoDO>> salesmanMap = getSalesMap(list);
        //查询填写的登陆账号是否已存在
        Map<String, List<SalesmanInfoDO>> loginMap = getLoginMap(recommendRelateCustVOS);
        //查询填写的组织信息
        Map<String, List<SysOrgBasicDTO>> buMap = getBuMap(recommendRelateCustVOS);
        //查询填写的公司信息是否存在
        Map<String, List<OrgOuRpcDTO>> ouMap = getOuMap(recommendRelateCustVOS);
        //根据上级编码查询上级id
        Map<String, Long> userCodeIdMap = getLeaderMap(recommendRelateCustVOS);
        //查询所有的省市区
        List<String> areaNameList = new ArrayList<>();
        Map<String, List<SysAreaRespDTO>> areaMap = new HashMap<>();
        ApiResult<List<SysAreaRespDTO>> areaList = sysAreaRpcService.queryList(new SysAreaQueryDTO());
        if (!areaList.isSuccess()){
            throw new BusinessException("查询省市区信息失败！" + areaList.getMsg());
        }
        List<SysAreaRespDTO> areaListData = areaList.getData();
        if (CollUtil.isNotEmpty(areaListData)){
            areaNameList = areaListData.stream().map(SysAreaRespDTO::getAreaName).collect(Collectors.toList());
            areaMap = areaListData.stream().collect(Collectors.groupingBy(SysAreaRespDTO::getAreaName));
        }else {
            throw new BusinessException("未查询到省市区信息！" );
        }

        //检查导入数据
        failFlag = checkData(failFlag, recommendRelateCustVOS, failMsg, salesmanMap, loginMap, buMap, userCodeIdMap, ouMap, newTypeMap, newRegionMap, areaNameList);
        if(failFlag){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, failMsg.toString());
        }
        //校验员工数据是否可以保存
        failFlag = checkEmployee(recommendRelateCustVOS, failMsg, failFlag, buMap);
        if(failFlag){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, failMsg.toString());
        }

        int line = 3;
        //一个一个保存
        for (SalesmanImportSaveVO recommendRelateCustVO : recommendRelateCustVOS) {
            //业务员信息
            SalesmanInfoDO salesmanInfoDO = SalesmanInfoConvert.INSTANCE.salesmanImportSaveToDO(recommendRelateCustVO);
            salesmanInfoDO.setEnableStatus(1);
            salesmanInfoDO.setSalesmanType(newTypeMap.get(salesmanInfoDO.getSalesmanType()));
            salesmanInfoDO.setOuName(ouMap.get(salesmanInfoDO.getOuCode()).get(0).getOuName());
            //区域
            List<String> regions = new ArrayList<>();
            if (StringUtils.isNotBlank(salesmanInfoDO.getJurisdiction())) {
                String[] jurisdictions = salesmanInfoDO.getJurisdiction().split("[;；]");
                regions = List.of(jurisdictions);
            }

            //创建新员工
            EmployeeUpsertDTO upsertDTO = SalesmanInfoConvert.INSTANCE.salesmanImportSaveVOToUpsertDTO(recommendRelateCustVO);
            if (StringUtils.isNotBlank(recommendRelateCustVO.getSexName())) {
                upsertDTO.setGender(recommendRelateCustVO.getSexName().equals("男") ? "MALE" : "FEMALE");
            }
            AreaVO areaVO = new AreaVO();
            if (StringUtils.isNotBlank(recommendRelateCustVO.getBirthdayTime())){
                upsertDTO.setBirthDate(constant.stringToLocalDate(recommendRelateCustVO.getBirthdayTime()));
            }
            if (StringUtils.isNotBlank(recommendRelateCustVO.getJoinTime())) {
                upsertDTO.setJoinTime(constant.swapTimeMin(recommendRelateCustVO.getJoinTime()));
            }
            //省市区信息
            areaVO.setProvinceName(recommendRelateCustVO.getProvince());
            areaVO.setCityName(recommendRelateCustVO.getCity());
            areaVO.setCountyName(recommendRelateCustVO.getArea());
            if (CollUtil.isNotEmpty(areaMap.get(recommendRelateCustVO.getProvince()))){
                areaVO.setProvinceCode(areaMap.get(recommendRelateCustVO.getProvince()).get(0).getAreaCode());
            }
            if (CollUtil.isNotEmpty(areaMap.get(recommendRelateCustVO.getCity()))){
                areaVO.setCityCode(areaMap.get(recommendRelateCustVO.getCity()).get(0).getAreaCode());
            }
            if (CollUtil.isNotEmpty(areaMap.get(recommendRelateCustVO.getArea()))){
                areaVO.setCountyCode(areaMap.get(recommendRelateCustVO.getArea()).get(0).getAreaCode());
            }
            upsertDTO.setAreaVO(areaVO);
            EmployeeUpsertDTO.EmployeeOrg employeeOrg = new EmployeeUpsertDTO.EmployeeOrg();
            if (StringUtils.isNotBlank(recommendRelateCustVO.getLeaderUserCode())) {
                employeeOrg.setLeaderUserId(userCodeIdMap.get(recommendRelateCustVO.getLeaderUserCode()));
            }
            if (CollUtil.isNotEmpty(buMap.get(recommendRelateCustVO.getBuCode()))){
                employeeOrg.setOrgId(buMap.get(recommendRelateCustVO.getBuCode()).get(0).getId());
            }
            upsertDTO.setOrgList(List.of(employeeOrg));
            upsertDTO.setCode(recommendRelateCustVO.getSalesmanNo());
            upsertDTO.setType(UdcEnum.CUST_TYPE_SALESMAN.getValueCode());
            //创建新用户
            ApiResult<String> result = employeeRpcService.upsert(upsertDTO);
            if (!result.isSuccess()) {
                throw new BusinessException( "第"+line+"行"+result.getMsg()+"  第"+line+"行及之后数据调用创建新员工接口失败！ ");
            }
            UserRoleSaveDTO userRoleSaveDTO = new UserRoleSaveDTO();
            userRoleSaveDTO.setUsername(recommendRelateCustVO.getLoginAccount());
            userRoleSaveDTO.setRoleCodes(Collections.singleton(Constant.SALESMAN));
            ApiResult<List<Long>> userRoles = sysUserPermissionRpcService.saveUserRoles(Collections.singletonList(userRoleSaveDTO));
            if (userRoles.isFailed()){
                throw new BusinessException("第"+line+"行"+ userRoles.getMsg() +" 保存业务员角色失败");
            }
            //保存业务员信息
            SalesmanInfoDO save = salesmanInfoRepo.save(salesmanInfoDO);
            if (Optional.ofNullable(save).isEmpty()) {
                throw new BusinessException("  第"+line+"行及之后数据调用保存接口失败！");
            }
            //保存业务员区域信息
            List<SalesmanRegionDO> regionDOS = new ArrayList<>();
            if (CollUtil.isNotEmpty(regions)) {
                for (String jurisdiction : regions) {
                    SalesmanRegionDO salesmanRegionDO = new SalesmanRegionDO();
                    salesmanRegionDO.setRegionCode(newRegionMap.get(jurisdiction));
                    salesmanRegionDO.setMasId(save.getId());
                    regionDOS.add(salesmanRegionDO);
                }
                salesmanRegionRepo.saveAll(regionDOS);
            }
            line++;
        }
        return ApiResult.ok();
    }

    private Map<String, List<SysOrgBasicDTO>> getBuMap(List<SalesmanImportSaveVO> recommendRelateCustVOS) {
        Set<String> buCodesSet = recommendRelateCustVOS.stream().map(SalesmanImportSaveVO::getBuCode).collect(Collectors.toSet());
        SysOrgQueryDTO sysOrgQueryDTO = new SysOrgQueryDTO();
        //查询组织信息获取组织id
        sysOrgQueryDTO.setCodes(buCodesSet);
        ApiResult<List<SysOrgBasicDTO>> listApiResult = orgRpcService.queryList(sysOrgQueryDTO);
        if (!listApiResult.isSuccess()){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "查询组织信息失败！ "+listApiResult.getMsg());
        }
        List<SysOrgBasicDTO> buList = listApiResult.getData();
        Map<String, List<SysOrgBasicDTO>> buMap = new HashMap<>();
        if (CollUtil.isNotEmpty(buList)){
            buMap = buList.stream().collect(Collectors.groupingBy(SysOrgBasicDTO::getCode));
        }
        return buMap;
    }

    private boolean checkEmployee(List<SalesmanImportSaveVO> recommendRelateCustVOS, StringBuffer failMsg, boolean failFlag, Map<String, List<SysOrgBasicDTO>> buMap) {
        List<EmployeeUpsertDTO> employeeUpsertDTOS = new ArrayList<>();
        for (SalesmanImportSaveVO recommendRelateCustVO : recommendRelateCustVOS) {
            EmployeeUpsertDTO upsertDTO = SalesmanInfoConvert.INSTANCE.salesmanImportSaveVOToUpsertDTO(recommendRelateCustVO);
            if (CollUtil.isNotEmpty(buMap.get(recommendRelateCustVO.getBuCode()))){
                EmployeeUpsertDTO.EmployeeOrg employeeOrg = new EmployeeUpsertDTO.EmployeeOrg();
                employeeOrg.setOrgId(buMap.get(recommendRelateCustVO.getBuCode()).get(0).getId());
                upsertDTO.setOrgList(List.of(employeeOrg));
            }
            employeeUpsertDTOS.add(upsertDTO);

        }
        ApiResult<List<String>> apiResult = employeeRpcService.checkBatch(employeeUpsertDTOS);
        List<String> data = apiResult.getData();
        if (apiResult.isSuccess() && CollUtil.isNotEmpty(data)){
            int n = 3;
            for (String datum : data) {
                if (StringUtils.isNotBlank(datum) && datum.contains("IllegalArgumentException")){
                    failFlag = true;
                    failMsg.append("第"+n+"行数据"+datum+" ");
                }
                n++;
            }
        }
        return failFlag;
    }

    private Map<String, List<SalesmanInfoDO>> getSalesMap(List<String> list) {
        List<SalesmanInfoDO> byMasSalesmanNoIn = salesmanInfoRepo.findBySalesmanNoIn(list);
        Map<String, List<SalesmanInfoDO>> salesmanMap = new HashMap<>();
        if (CollUtil.isNotEmpty(byMasSalesmanNoIn)){
            salesmanMap = byMasSalesmanNoIn.stream().collect(Collectors.groupingBy(SalesmanInfoDO::getSalesmanNo));
        }
        return salesmanMap;
    }

    private Map<String, List<SalesmanInfoDO>> getLoginMap(List<SalesmanImportSaveVO> recommendRelateCustVOS) {
        List<String> loginAccounts = recommendRelateCustVOS.stream()
                .map(SalesmanImportSaveVO::getLoginAccount).collect(Collectors.toList());
        List<SalesmanInfoDO> salesmanInfoRepoByLoginAccountIn = salesmanInfoRepo.findByLoginAccountIn(loginAccounts);
        Map<String, List<SalesmanInfoDO>> loginMap = new HashMap<>();
        if (CollUtil.isNotEmpty(salesmanInfoRepoByLoginAccountIn)){
            loginMap = salesmanInfoRepoByLoginAccountIn.stream().collect(Collectors.groupingBy(SalesmanInfoDO::getLoginAccount));
        }
        return loginMap;
    }

    @NotNull
    private Map<String, Long> getLeaderMap(List<SalesmanImportSaveVO> recommendRelateCustVOS) {
        Set<String> leaderCodes = recommendRelateCustVOS.stream()
                .map(SalesmanImportSaveVO::getLeaderUserCode)
                .filter(leaderUserCode -> leaderUserCode != null).collect(Collectors.toSet());
        Map<String, Long> userCodeIdMap = new HashMap<>();
        if (CollUtil.isNotEmpty(leaderCodes)) {
            EmployeePageQueryDTO employeePageQueryDTO = new EmployeePageQueryDTO();
            employeePageQueryDTO.setCodes(leaderCodes);
            ApiResult<PagingVO<EmployeePageRespDTO>> apiResult = employeeRpcService.queryByPage(employeePageQueryDTO);
            if (!apiResult.isSuccess()) {
                throw new BusinessException("查询上级信息失败！" + apiResult.getMsg());
            }
            userCodeIdMap = apiResult.getData().getRecords()
                    .stream().collect(Collectors.toMap(EmployeePageRespDTO::getCode, EmployeePageRespDTO::getUserId));
        }
        return userCodeIdMap;
    }

    private Map<String, List<OrgOuRpcDTO>> getOuMap(List<SalesmanImportSaveVO> recommendRelateCustVOS) {
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuCodes(recommendRelateCustVOS.stream().map(SalesmanImportSaveVO::getOuCode).distinct().collect(Collectors.toList()));
        List<OrgOuRpcDTO> ouDtoByParam = orgOuRpcService.findOuDtoByParam(orgOuRpcDtoParam);
        Map<String, List<OrgOuRpcDTO>> ouMap = new HashMap<>();
        if (CollUtil.isNotEmpty(ouDtoByParam)){
            ouMap = ouDtoByParam.stream().collect(Collectors.groupingBy(OrgOuRpcDTO::getOuCode));
        }
        return ouMap;
    }

    private static Boolean checkData(Boolean failFlag, List<SalesmanImportSaveVO> recommendRelateCustVOS, StringBuffer failMsg, Map<String, List<SalesmanInfoDO>> salesmanMap, Map<String, List<SalesmanInfoDO>> loginMap,
                                     Map<String, List<SysOrgBasicDTO>> buMap, Map<String, Long> userCodeIdMap, Map<String, List<OrgOuRpcDTO>> ouMap, Map<String, String> salesmanTypeUDCMap, Map<String, String> newRegionMap, List<String> areaNameList) {
        //从第三行开始判断
        int i = 3;
        for (SalesmanImportSaveVO recommendRelateCustVO : recommendRelateCustVOS) {

            if (StringUtils.isBlank(recommendRelateCustVO.getSalesmanNo())){
                failFlag = true;
                failMsg.append("第").append(i).append("行导入的业务员编号为空 ");
            }
            if (UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getValueCode().equals(salesmanTypeUDCMap.get(recommendRelateCustVO.getSalesmanType()))
                    && StringUtils.isBlank(recommendRelateCustVO.getJurisdiction())){
                failFlag = true;
                failMsg.append("第"+i+"行销售总监的管辖区域为空 ");
            }
            if (UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getValueCode().equals(salesmanTypeUDCMap.get(recommendRelateCustVO.getSalesmanType()))
                    && StringUtils.isNotBlank(recommendRelateCustVO.getLeaderUserCode())){
                failFlag = true;
                failMsg.append("第"+i+"行销售总监不允许有上级 ");
            }
            if (StringUtils.isNotBlank(recommendRelateCustVO.getJurisdiction())){
                String[] split = recommendRelateCustVO.getJurisdiction().split("[;；]");
                for (String s : split) {
                    if (StringUtils.isBlank(newRegionMap.get(s))){
                        failFlag = true;
                        failMsg.append("第"+i+"行区域信息错误,区域"+ s +"不存在 ");
                    }
                }
            }
            if (StringUtils.isBlank(recommendRelateCustVO.getName())){
                failFlag = true;
                failMsg.append("第"+i+"行导入的姓名为空 ");
            }
            if (StringUtils.isBlank(recommendRelateCustVO.getPhone())){
                failFlag = true;
                failMsg.append("第"+i+"行导入的手机号为空 ");
            }
            if (StringUtils.isNotBlank(recommendRelateCustVO.getProvince()) && !areaNameList.contains(recommendRelateCustVO.getProvince())){
                failFlag = true;
                failMsg.append("第"+i+"行导入的省信息不存在 ");
            }
            if (StringUtils.isNotBlank(recommendRelateCustVO.getCity()) && !areaNameList.contains(recommendRelateCustVO.getCity())){
                failFlag = true;
                failMsg.append("第"+i+"行导入的市信息不存在 ");
            }
            if (StringUtils.isNotBlank(recommendRelateCustVO.getArea()) && !areaNameList.contains(recommendRelateCustVO.getArea())){
                failFlag = true;
                failMsg.append("第"+i+"行导入的区信息不存在 ");
            }
            if (StringUtils.isBlank(recommendRelateCustVO.getOuCode())){
                failFlag = true;
                failMsg.append("第"+i+"行导入的公司编号为空 ");
            }
            if (StringUtils.isBlank(recommendRelateCustVO.getBuCode())){
                failFlag = true;
                failMsg.append("第"+i+"行导入的组织编号为空 ");
            }
            if (StringUtils.isNotBlank(recommendRelateCustVO.getBuCode()) && CollUtil.isEmpty(buMap.get(recommendRelateCustVO.getBuCode()))){
                failFlag = true;
                failMsg.append("第"+i+"行导入的组织编号未查询到对应的组织信息 ");
            }
            if (StringUtils.isBlank(recommendRelateCustVO.getLoginAccount())){
                failFlag = true;
                failMsg.append("第"+i+"行导入的登录账号为空 ");
            }
            if (StringUtils.isBlank(recommendRelateCustVO.getSalesmanType())){
                failFlag = true;
                failMsg.append("第"+i+"行导入的业务员类型为空 ");
            }
            if (StringUtils.isNotBlank(recommendRelateCustVO.getSalesmanType()) && StringUtils.isBlank(salesmanTypeUDCMap.get(recommendRelateCustVO.getSalesmanType()))){
                failFlag = true;
                failMsg.append("第"+i+"行导入的业务员类型不存在 ");
            }
            if (StringUtils.isNotBlank(recommendRelateCustVO.getSalesmanNo()) && CollUtil.isNotEmpty(salesmanMap.get(recommendRelateCustVO.getSalesmanNo()))){
                failFlag = true;
                failMsg.append("第"+i+"行导入的业务员编号已经存在，请重新输入 ");
            }
            if (StringUtils.isNotBlank(recommendRelateCustVO.getLoginAccount()) && CollUtil.isNotEmpty(loginMap.get(recommendRelateCustVO.getLoginAccount()))){
                failFlag = true;
                failMsg.append("第"+i+"行导入的登录账号已经存在，请重新输入 ");
            }
            if (StringUtils.isNotBlank(recommendRelateCustVO.getBuCode()) && StringUtils.isNotBlank(recommendRelateCustVO.getOuCode())
            && CollUtil.isNotEmpty(buMap.get(recommendRelateCustVO.getBuCode())) && CollUtil.isNotEmpty(ouMap.get(recommendRelateCustVO.getOuCode()))){
                if (ouMap.get(recommendRelateCustVO.getOuCode()).get(0).getBuId() != null &&
                        buMap.get(recommendRelateCustVO.getBuCode()).get(0).getId() != null &&
                        !ouMap.get(recommendRelateCustVO.getOuCode()).get(0).getBuId().equals(buMap.get(recommendRelateCustVO.getBuCode()).get(0).getId()) &&
                        !recommendRelateCustVO.getOuCode().equals(buMap.get(recommendRelateCustVO.getBuCode()).get(0).getParentCode())){
                    failFlag = true;
                    failMsg.append("第"+i+"行导入的信息错误，该公司与该组织没有绑定关系，请重新输入 ");
                }
            }
            if (StringUtils.isNotBlank(recommendRelateCustVO.getOuCode()) && CollUtil.isEmpty(ouMap.get(recommendRelateCustVO.getOuCode()))){
                failFlag = true;
                failMsg.append("第"+i+"行导入的公司编号未查询到对应的公司信息，请重新输入 ");
            }
            if (StringUtils.isNotBlank(recommendRelateCustVO.getLeaderUserCode()) && userCodeIdMap.get(recommendRelateCustVO.getLeaderUserCode()) == null){
                failFlag = true;
                failMsg.append("第"+i+"行导入上级编号未查询到对应的上级信息，请重新输入 ");
            }
            i++;
        }
        return failFlag;
    }

    @Override
    public ApiResult<PagingVO<SalesmanDetailInfoRespVO>> querySalesmanAllInfo(SalesmanInfoQueryVO salesmanInfoQueryVO) {
        log.info("业务员全部信息查询入参 {}", salesmanInfoQueryVO);
        Map<String, String> salesmanTypeUDCMap = rmiSysUDCService.getCodeMap("yst-sale", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
        Map<String, String> regionUDCMap = rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.CRM_CUST_REGION_HN_NORTH.getCode());
        //返回的数据
        List<SalesmanDetailInfoRespVO> salesmanDetailInfoRespVOS = new ArrayList<>();
        //包含业务员条件查询或无条件查询
        if (salesmanInfoQueryVO.getEnableStatus() != null
                || StringUtils.isNotBlank(salesmanInfoQueryVO.getOuCode())
                || StringUtils.isNotBlank(salesmanInfoQueryVO.getSalesmanType())
                || salesmanInfoQueryVO.getNoQueryParam() == 1) {
            JPAQuery<SalesmanDetailInfoRespVO> jpaQuery = salesmanInfoRepoProc.findSalesmanInfoDetail(salesmanInfoQueryVO);
            List<SalesmanDetailInfoRespVO> salesmanInfoRespVOList = jpaQuery.fetch();
            if (CollUtil.isEmpty(salesmanInfoRespVOList)) {
                return ApiResult.ok();
            }
            //组装区域信息
            Map<String, String> regionMap = buildReion(regionUDCMap, salesmanInfoRespVOList);

            //业务员map
            Map<String, SalesmanDetailInfoRespVO> salesmanMap = salesmanInfoRespVOList.stream()
                    .collect(Collectors.toMap(SalesmanDetailInfoRespVO::getSalesmanNo, Function.identity(), (k1, k2) -> k1));
            Set<String> codeList = salesmanInfoRespVOList.stream().map(SalesmanDetailInfoRespVO::getSalesmanNo).collect(Collectors.toSet());
            EmployeePageQueryDTO employeePageQueryDTO = SalesmanInfoConvert.INSTANCE.salesmanInfoQueryVOToQueryDTO(salesmanInfoQueryVO);
            employeePageQueryDTO.setKeyword(salesmanInfoQueryVO.getSalesman());
            employeePageQueryDTO.setCodes(codeList);
            ApiResult<PagingVO<EmployeePageRespDTO>> result = employeeRpcService.queryByPage(employeePageQueryDTO);
            if (!result.isSuccess()) {
                throw new BusinessException("员工信息查询失败！" + result.getMsg());
            }

            //员工数据
            List<EmployeePageRespDTO> employeePageRespDTOList = new ArrayList<>();
            if (Optional.ofNullable(result.getData()).isPresent()){
                employeePageRespDTOList = result.getData().getRecords();
            }
            if (CollUtil.isEmpty(employeePageRespDTOList)){
                ApiResult.ok(PagingVO.<SalesmanDetailInfoRespVO>builder()
                        .records(salesmanDetailInfoRespVOS));
            }
            Set<String> detailCodeSet = employeePageRespDTOList.stream().map(EmployeePageRespDTO::getCode).collect(Collectors.toSet());
            ApiResult<List<SysEmployeeDetailDTO>> apiResult = employeeRpcService.getDetailListByCode(detailCodeSet);
            if (!apiResult.isSuccess()) {
                throw new BusinessException("员工信息查询失败！" + apiResult.getMsg());
            }
            //需要的员工详情
            List<SysEmployeeDetailDTO> detailDTOS = apiResult.getData();
            if (CollUtil.isEmpty(detailDTOS)){
                return ApiResult.ok();
            }
            for (SysEmployeeDetailDTO detailDTO : detailDTOS) {
                SalesmanDetailInfoRespVO salesmanDetailInfoRespVO = new SalesmanDetailInfoRespVO();
                if (Optional.ofNullable(salesmanMap.get(detailDTO.getCode())).isPresent()){
                    salesmanDetailInfoRespVO.setOuName(salesmanMap.get(detailDTO.getCode()).getOuName());
                    salesmanDetailInfoRespVO.setId(salesmanMap.get(detailDTO.getCode()).getId());
                    salesmanDetailInfoRespVO.setSalesmanNo(salesmanMap.get(detailDTO.getCode()).getSalesmanNo());
                    salesmanDetailInfoRespVO.setSalesmanType(salesmanTypeUDCMap.get(salesmanMap.get(detailDTO.getCode()).getSalesmanType()));
                    salesmanDetailInfoRespVO.setEnableStatusName(salesmanMap.get(detailDTO.getCode()).getEnableStatus() == 1 ? "启用" : "禁用");
                }
                salesmanDetailInfoRespVO.setJurisdiction(regionMap.get(detailDTO.getCode()));
                salesmanDetailInfoRespVO.setJoinTime(detailDTO.getJoinTime());
                salesmanDetailInfoRespVO.setUsername(detailDTO.getUsername());
                salesmanDetailInfoRespVO.setFullName(detailDTO.getFullName());
                salesmanDetailInfoRespVO.setGenderName(detailDTO.getGenderName());
                salesmanDetailInfoRespVO.setEmail(detailDTO.getEmail());
                salesmanDetailInfoRespVO.setPhone(detailDTO.getPhone());
                salesmanDetailInfoRespVO.setBirthDate(detailDTO.getBirthDate() == null ? null : detailDTO.getBirthDate().format(DateTimeFormatter.ISO_LOCAL_DATE));
                salesmanDetailInfoRespVO.setIdCard(detailDTO.getIdCard());
                salesmanDetailInfoRespVO.setProvinceName(detailDTO.getAreaVO().getProvinceName());
                salesmanDetailInfoRespVO.setCityName(detailDTO.getAreaVO().getCityName());
                salesmanDetailInfoRespVO.setCountyName(detailDTO.getAreaVO().getCountyName());
                salesmanDetailInfoRespVO.setAddress(detailDTO.getAddress());
                if (CollUtil.isNotEmpty(detailDTO.getOrgList())) {
                    salesmanDetailInfoRespVO.setOrgName(detailDTO.getOrgList().get(0).getOrgName());
                    salesmanDetailInfoRespVO.setLeaderUserFullName(detailDTO.getOrgList().get(0).getLeaderUserFullName());
                }
                salesmanDetailInfoRespVOS.add(salesmanDetailInfoRespVO);
            }

            return ApiResult.ok(PagingVO.<SalesmanDetailInfoRespVO>builder()
                    .records(salesmanDetailInfoRespVOS)
                    .build());

            //只包含员工查询条件
        } else if (salesmanInfoQueryVO.getNoQueryParam() != 1) {
            EmployeePageQueryDTO employeePageQueryDTO = SalesmanInfoConvert.INSTANCE.salesmanInfoQueryVOToQueryDTO(salesmanInfoQueryVO);
            employeePageQueryDTO.setKeyword(salesmanInfoQueryVO.getSalesman());
            //先查询员工信息
            ApiResult<PagingVO<EmployeePageRespDTO>> result = employeeRpcService.queryByPage(employeePageQueryDTO);
            if (!result.isSuccess()) {
                throw new BusinessException("员工信息查询失败！" + result.getMsg());
            }
            if (result.getData().getTotal() == 0) {
                return ApiResult.ok();
            }
            List<EmployeePageRespDTO> employeePageRespDTOS = result.getData().getRecords();
            Set<String> codeSet = employeePageRespDTOS.stream().map(EmployeePageRespDTO::getCode).collect(Collectors.toSet());
            ApiResult<List<SysEmployeeDetailDTO>> apiResult = employeeRpcService.getDetailListByCode(codeSet);
            if (!apiResult.isSuccess()) {
                throw new BusinessException("员工详情信息查询失败！" + apiResult.getMsg());
            }
            List<SysEmployeeDetailDTO> employeeDetailDTOS = apiResult.getData();
            if (CollUtil.isEmpty(employeeDetailDTOS)) {
                return ApiResult.ok();
            }
            List<String> codes = employeeDetailDTOS.stream().map(SysEmployeeDetailDTO::getCode).collect(Collectors.toList());
            //业务员信息
            List<SalesmanInfoDO> salesmanInfoDOS = salesmanInfoRepo.findBySalesmanNoIn(codes);
            if (CollUtil.isEmpty(salesmanInfoDOS)){
                return ApiResult.ok();
            }
            //组装区域信息
            Map<String, String> regionMap = new HashMap<>();
            Map<Long, List<SalesmanRegionVO>> idRegionMap = getSalesmanRegionMap(regionUDCMap, salesmanInfoDOS.stream().map(SalesmanInfoDO::getId).collect(Collectors.toList()));
            for (SalesmanInfoDO salesmanInfoDO : salesmanInfoDOS) {
                StringBuffer stringBuffer = new StringBuffer();
                if (CollUtil.isNotEmpty(idRegionMap.get(salesmanInfoDO.getId()))){
                    for (SalesmanRegionVO regionVO : idRegionMap.get(salesmanInfoDO.getId())) {
                        if (StringUtils.isNotBlank(regionVO.getRegionName())) {
                            stringBuffer = stringBuffer.append(regionVO.getRegionName() + " ");
                        }
                    }
                    regionMap.put(salesmanInfoDO.getSalesmanNo(), stringBuffer.toString());
                }
            }
            //业务员map
            Map<String, SalesmanInfoDO> salesmanInfoDOMap = salesmanInfoDOS.stream()
                    .collect(Collectors.toMap(SalesmanInfoDO::getSalesmanNo, Function.identity(), (k1, k2) -> k1));
            for (SysEmployeeDetailDTO detailDTO : employeeDetailDTOS) {
                SalesmanDetailInfoRespVO salesmanDetailInfoRespVO = new SalesmanDetailInfoRespVO();
                if (Optional.ofNullable(salesmanInfoDOMap.get(detailDTO.getCode())).isPresent()){
                    salesmanDetailInfoRespVO.setId(salesmanInfoDOMap.get(detailDTO.getCode()).getId());
                    salesmanDetailInfoRespVO.setOuName(salesmanInfoDOMap.get(detailDTO.getCode()).getOuName());
                    salesmanDetailInfoRespVO.setSalesmanNo(salesmanInfoDOMap.get(detailDTO.getCode()).getSalesmanNo());
                    salesmanDetailInfoRespVO.setSalesmanType(salesmanTypeUDCMap.get(salesmanInfoDOMap.get(detailDTO.getCode()).getSalesmanType()));
                    salesmanDetailInfoRespVO.setEnableStatusName(salesmanInfoDOMap.get(detailDTO.getCode()).getEnableStatus() == 1 ? "启用" : "禁用");
                }
                salesmanDetailInfoRespVO.setJurisdiction(regionMap.get(detailDTO.getCode()));
                salesmanDetailInfoRespVO.setJoinTime(detailDTO.getJoinTime());
                salesmanDetailInfoRespVO.setUsername(detailDTO.getUsername());
                salesmanDetailInfoRespVO.setFullName(detailDTO.getFullName());
                salesmanDetailInfoRespVO.setGenderName(detailDTO.getGenderName());
                salesmanDetailInfoRespVO.setEmail(detailDTO.getEmail());
                salesmanDetailInfoRespVO.setPhone(detailDTO.getPhone());
                salesmanDetailInfoRespVO.setBirthDate(detailDTO.getBirthDate()==null?null:detailDTO.getBirthDate().format(DateTimeFormatter.ISO_LOCAL_DATE));
                salesmanDetailInfoRespVO.setIdCard(detailDTO.getIdCard());
                salesmanDetailInfoRespVO.setProvinceName(detailDTO.getAreaVO().getProvinceName());
                salesmanDetailInfoRespVO.setCityName(detailDTO.getAreaVO().getCityName());
                salesmanDetailInfoRespVO.setCountyName(detailDTO.getAreaVO().getCountyName());
                salesmanDetailInfoRespVO.setAddress(detailDTO.getAddress());
                if (CollUtil.isNotEmpty(detailDTO.getOrgList())){
                    salesmanDetailInfoRespVO.setOrgName(detailDTO.getOrgList().get(0).getOrgName());
                    salesmanDetailInfoRespVO.setLeaderUserFullName(detailDTO.getOrgList().get(0).getLeaderUserFullName());
                }
                salesmanDetailInfoRespVOS.add(salesmanDetailInfoRespVO);
            }

            return ApiResult.ok(PagingVO.<SalesmanDetailInfoRespVO>builder()
                    .records(salesmanDetailInfoRespVOS)
                    .build());
            }
        return ApiResult.ok();
    }

    private Map<String, String> buildReion(Map<String, String> regionUDCMap, List<SalesmanDetailInfoRespVO> salesmanInfoRespVOList) {
        Map<String, String> regionMap = new HashMap<>();
        Map<Long, List<SalesmanRegionVO>> idRegionMap = getSalesmanRegionMap(regionUDCMap, salesmanInfoRespVOList.stream().map(SalesmanDetailInfoRespVO::getId).collect(Collectors.toList()));
        for (SalesmanDetailInfoRespVO salesmanDetailInfoRespVO : salesmanInfoRespVOList) {
            StringBuffer stringBuffer = new StringBuffer();
            if (CollUtil.isNotEmpty(idRegionMap.get(salesmanDetailInfoRespVO.getId()))){
                for (SalesmanRegionVO regionVO : idRegionMap.get(salesmanDetailInfoRespVO.getId())) {
                    if (StringUtils.isNotBlank(regionVO.getRegionName())) {
                        stringBuffer = stringBuffer.append(regionVO.getRegionName() + " ");
                    }
                }
                regionMap.put(salesmanDetailInfoRespVO.getSalesmanNo(), stringBuffer.toString());
            }
        }
        return regionMap;
    }

    @Override
    public SalesmanLevelInfoDTO queryLevelInfo(Long id) {
        if (id == null){
            throw new BusinessException("id 不允许为空!");
        }
        SalesmanLevelInfoDTO salesmanLevelInfoDTO = new SalesmanLevelInfoDTO();
        List<SalesmanLevelInfoDTO.path> paths = new ArrayList<>();
        StringBuffer codeBuffer = new StringBuffer();
        //业务员信息
        SalesmanInfoDO infoDO = salesmanInfoRepoProc.get(id);
        if (Optional.ofNullable(infoDO).isEmpty()){
            throw new BusinessException(" 未获取到业务员信息，请稍后重试");
        }

        SalesmanLevelInfoDTO.path path = new SalesmanLevelInfoDTO.path();
        salesmanLevelInfoDTO.setId(infoDO.getId());
        salesmanLevelInfoDTO.setSalesmanNo(infoDO.getSalesmanNo());
        //查询上级和自己的信息（区域经理）
        ApiResult<SysEmployeeDetailDTO> salesmanDetailInfo = employeeRpcService.getDetailByCode(infoDO.getSalesmanNo());
        SysEmployeeDetailDTO salesmanDetailInfoData = salesmanDetailInfo.getData();
        if (!salesmanDetailInfo.isSuccess() || Optional.ofNullable(salesmanDetailInfoData).isEmpty()){
            return salesmanLevelInfoDTO;
        }
        path.setLevel(0);
        path.setCode(infoDO.getSalesmanNo());
        path.setType(infoDO.getSalesmanType());
        path.setName(salesmanDetailInfoData.getFullName());
        codeBuffer.append(infoDO.getSalesmanNo());
        paths.add(path);
        salesmanLevelInfoDTO.setSalesmanPathCode(codeBuffer.toString());
        salesmanLevelInfoDTO.setSalesman_path(paths);

        //业务员信息
        salesmanLevelInfoDTO.setId(infoDO.getId());
        salesmanLevelInfoDTO.setSalesmanNo(salesmanDetailInfoData.getCode());
        salesmanLevelInfoDTO.setSalesmanName(salesmanDetailInfoData.getFullName());
        salesmanLevelInfoDTO.setSalesmanId(salesmanDetailInfoData.getId());
        String reCode = "";
        if (CollUtil.isNotEmpty(salesmanDetailInfoData.getOrgList()) && StringUtils.isNotBlank(salesmanDetailInfoData.getOrgList().get(0).getLeaderEmployeeCode())){
            reCode = salesmanDetailInfoData.getOrgList().get(0).getLeaderEmployeeCode();
            Long reCId = salesmanDetailInfoData.getOrgList().get(0).getLeaderEmployeeId();
            String leaderUserFullName = salesmanDetailInfoData.getOrgList().get(0).getLeaderUserFullName();
            salesmanLevelInfoDTO.setSalesmanPathCode(buildPath(reCode, 1, paths, codeBuffer, leaderUserFullName));
            salesmanLevelInfoDTO.setSalesman_path(paths);
            salesmanLevelInfoDTO.setRemanageId(reCId);
            salesmanLevelInfoDTO.setRemanageNo(reCode);
            salesmanLevelInfoDTO.setRemanagerName(leaderUserFullName);
        }
        //查询上级信息（省区经理）
        if (StringUtils.isBlank(reCode)){
            return salesmanLevelInfoDTO;
        }
        ApiResult<SysEmployeeDetailDTO> remanagerDetailInfo = employeeRpcService.getDetailByCode(reCode);
        SysEmployeeDetailDTO remanagerDetailInfoData = remanagerDetailInfo.getData();
        if (!remanagerDetailInfo.isSuccess() || Optional.ofNullable(remanagerDetailInfoData).isEmpty()
                || StringUtils.isBlank(remanagerDetailInfoData.getOrgList().get(0).getLeaderEmployeeCode())){
            return salesmanLevelInfoDTO;
        }
        String prCode = remanagerDetailInfoData.getOrgList().get(0).getLeaderEmployeeCode();
        Long prId = remanagerDetailInfoData.getOrgList().get(0).getLeaderEmployeeId();
        String leaderUserFullName = remanagerDetailInfoData.getOrgList().get(0).getLeaderUserFullName();
        salesmanLevelInfoDTO.setSalesmanPathCode(buildPath(prCode, 2, paths, codeBuffer, leaderUserFullName));
        salesmanLevelInfoDTO.setSalesman_path(paths);
        salesmanLevelInfoDTO.setPrmanagerNo(prCode);
        salesmanLevelInfoDTO.setPrmanagerId(prId);
        salesmanLevelInfoDTO.setPrmanagerName(leaderUserFullName);
        //查询上级信息（销售总监）
        if (StringUtils.isBlank(prCode)){
            return salesmanLevelInfoDTO;
        }
        ApiResult<SysEmployeeDetailDTO> prmanagerDetailInfo = employeeRpcService.getDetailByCode(prCode);
        SysEmployeeDetailDTO prmanagerDetailInfoData = prmanagerDetailInfo.getData();
        if (!prmanagerDetailInfo.isSuccess() || Optional.ofNullable(prmanagerDetailInfoData).isEmpty()
                || StringUtils.isBlank(prmanagerDetailInfoData.getOrgList().get(0).getLeaderEmployeeCode())){
            return salesmanLevelInfoDTO;
        }
        String chCode = prmanagerDetailInfoData.getOrgList().get(0).getLeaderEmployeeCode();
        Long chId = prmanagerDetailInfoData.getOrgList().get(0).getLeaderEmployeeId();
        String leaderUserFullNameEnd = prmanagerDetailInfoData.getOrgList().get(0).getLeaderUserFullName();
        salesmanLevelInfoDTO.setSalesmanPathCode(buildPath(chCode, 3, paths, codeBuffer, leaderUserFullNameEnd));
        salesmanLevelInfoDTO.setSalesman_path(paths);
        salesmanLevelInfoDTO.setChiefNo(chCode);
        salesmanLevelInfoDTO.setChiefId(chId);
        salesmanLevelInfoDTO.setChiefName(leaderUserFullNameEnd);
        salesmanLevelInfoDTO.setSalesman_path(paths);
        return salesmanLevelInfoDTO;
    }

    private String buildPath(String code, int level, List<SalesmanLevelInfoDTO.path> paths, StringBuffer code1, String leaderUserFullName) {
        SalesmanInfoDO infoDO3 = salesmanInfoRepo.findBySalesmanNo(code);
        if (Optional.ofNullable(infoDO3).isPresent()){
            SalesmanLevelInfoDTO.path path1 = new SalesmanLevelInfoDTO.path();
            code1.append(",");
            code1.append(infoDO3.getSalesmanNo());
            path1.setLevel(level);
            path1.setCode(infoDO3.getSalesmanNo());
            path1.setType(infoDO3.getSalesmanType());
            path1.setName(leaderUserFullName);
            paths.add(path1);
            return code1.toString();
        }
        return code1.toString();
    }

    public ApiResult<List<SalesmanInfoAPPRespDTO>> salesmanTeam(SalesmanAPPQueryDTO salesmanAPPQueryDTO) {
        log.info("业务员团队信息查询入参{}", JSON.toJSONString(salesmanAPPQueryDTO));
//        if (Objects.nonNull(salesmanAPPQueryDTO.getDocTimeStart())) {
//            // 获取第一天的最小时间
//            LocalDateTime minTime = LocalDateTime.of(salesmanAPPQueryDTO.getDocTimeStart().toLocalDate(), LocalTime.MIN);
//            salesmanAPPQueryDTO.setDocTimeStart(minTime);
//        }
//        if (Objects.nonNull(salesmanAPPQueryDTO.getDocTimeEnd())) {
//            // 获取最后一天的最大时间
//            LocalDateTime maxTime = LocalDateTime.of(salesmanAPPQueryDTO.getDocTimeEnd().toLocalDate(), ConstantsSale.LOCAL_TIME_MAX);
//            salesmanAPPQueryDTO.setDocTimeEnd(maxTime);
//        }
        Map<String, String> salesmanTypeUDCMap = rmiSysUDCService.getCodeMap("yst-sale", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
        SalesmanInfoAPPRespDTO salesmanInfoAPPRespDTO = new SalesmanInfoAPPRespDTO();
        if (salesmanAPPQueryDTO.getOne() == 1 && StringUtils.isNotBlank(salesmanAPPQueryDTO.getSalesmanCode())){
            EmployeePageQueryDTO employeePageQueryDTO = new EmployeePageQueryDTO();
            employeePageQueryDTO.setEnabled(Boolean.TRUE);
            employeePageQueryDTO.setCodes(Set.of(salesmanAPPQueryDTO.getSalesmanCode()));
            ApiResult<PagingVO<EmployeePageRespDTO>> apiResult = employeeRpcService.queryByPage(employeePageQueryDTO);
            if (!apiResult.isSuccess()){
                return ApiResult.fail("查询信息失败！");
            }
            List<EmployeePageRespDTO> records = apiResult.getData().getRecords();
            if (CollUtil.isEmpty(records)){
                return ApiResult.ok();
            }
            EmployeePageRespDTO employeePageRespDTO = records.get(0);
            SalesmanInfoDO salesmanInfoDO = salesmanInfoRepo.findBySalesmanNo(employeePageRespDTO.getCode());
            if (Optional.ofNullable(salesmanInfoDO).isPresent()){
                salesmanInfoAPPRespDTO.setSalesmanType(salesmanInfoDO.getSalesmanType());
                salesmanInfoAPPRespDTO.setSalesmanTypeName(salesmanTypeUDCMap.get(salesmanInfoDO.getSalesmanType()));
            }
            salesmanInfoAPPRespDTO.setCode(employeePageRespDTO.getCode());
            salesmanInfoAPPRespDTO.setId(employeePageRespDTO.getId());
            salesmanInfoAPPRespDTO.setFullName(employeePageRespDTO.getFullName());
            salesmanInfoAPPRespDTO.setEnabled(employeePageRespDTO.getEnabled());
            salesmanInfoAPPRespDTO.setPhone(employeePageRespDTO.getPhone());
            salesmanInfoAPPRespDTO.setHasUnder(employeePageRespDTO.getHasUnderling());
            salesmanInfoAPPRespDTO.setUnderlingNum(employeePageRespDTO.getUnderlingNum());

            //组装每个业务员的经销商、门店的团队销售业绩和我的销售业绩
            salesmanRpcService.assembleSalePerformance(Collections.singletonList(salesmanInfoAPPRespDTO), salesmanAPPQueryDTO.getDocMonth(), salesmanAPPQueryDTO.getDocTimeStart(),salesmanAPPQueryDTO.getDocTimeEnd());
            return ApiResult.ok(List.of(salesmanInfoAPPRespDTO));
        }

        if (salesmanAPPQueryDTO.getOne() == 0 && StringUtils.isNotBlank(salesmanAPPQueryDTO.getSalesmanCode())){
            List<SalesmanInfoAPPRespDTO> salesmanInfoAPPRespDTOS = new ArrayList<>();
            ApiResult<List<EmployeeUnderlingDTO>> underlingByCode = employeeRpcService.getUnderlingByCode(salesmanAPPQueryDTO.getSalesmanCode(), salesmanAPPQueryDTO.getCascade(), true);
            if (!underlingByCode.isSuccess()){
                return ApiResult.fail("查询信息失败！");
            }
            List<EmployeeUnderlingDTO> data = underlingByCode.getData();
            if (CollUtil.isEmpty(data)){
                return ApiResult.ok();
            }
            List<SalesmanInfoDO> salesmanInfoDOS = salesmanInfoRepo.findBySalesmanNoIn(data.stream().map(EmployeeUnderlingDTO::getCode).distinct().collect(Collectors.toList()));
            Map<String, SalesmanInfoDO> infoDOMap = new HashMap<>();
            if (CollUtil.isNotEmpty(salesmanInfoDOS)){
                infoDOMap = salesmanInfoDOS.stream().collect(Collectors.toMap(SalesmanInfoDO::getSalesmanNo, Function.identity()));
            }
            for (EmployeeUnderlingDTO datum : data) {

                SalesmanInfoAPPRespDTO salesmanInfo = new SalesmanInfoAPPRespDTO();
                salesmanInfo.setCode(datum.getCode());
                salesmanInfo.setId(datum.getId());
                salesmanInfo.setFullName(datum.getFullName());
                salesmanInfo.setEnabled(datum.getEnabled());
                salesmanInfo.setPhone(datum.getPhone());
                salesmanInfo.setHasUnder(datum.getHasUnderling());
                if (infoDOMap.containsKey(datum.getCode())){
                    salesmanInfo.setSalesmanType(infoDOMap.get(datum.getCode()).getSalesmanType());
                    salesmanInfo.setSalesmanTypeName(salesmanTypeUDCMap.get(infoDOMap.get(datum.getCode()).getSalesmanType()));
                }
                List<SalesmanInfoAPPRespDTO> salesmanInfoAPPRespDTOList = salesmanRpcService.assembleUnderlingList(datum.getUnderlingList(),salesmanAPPQueryDTO.getDocMonth(), salesmanAPPQueryDTO.getDocTimeStart(),salesmanAPPQueryDTO.getDocTimeEnd());
                salesmanInfo.setUnderlingList(salesmanInfoAPPRespDTOList);
                salesmanInfoAPPRespDTOS.add(salesmanInfo);
            }
            //组装每个业务员的经销商、门店的团队销售业绩和我的销售业绩
            salesmanRpcService.assembleSalePerformance(salesmanInfoAPPRespDTOS,salesmanAPPQueryDTO.getDocMonth(), salesmanAPPQueryDTO.getDocTimeStart(),salesmanAPPQueryDTO.getDocTimeEnd());
            return ApiResult.ok(salesmanInfoAPPRespDTOS);
        }

        return ApiResult.ok(List.of(salesmanInfoAPPRespDTO));
    }

    public PagingVO<SalesmanInfoAPPRespDTO> salesmanTeamAll(SalesmanAPPQueryDTO salesmanAPPQueryDTO) {
        log.info("业务员团队信息查询入参{}", JSON.toJSONString(salesmanAPPQueryDTO));
//        if (Objects.nonNull(salesmanAPPQueryDTO.getDocTimeStart())) {
//            // 获取第一天的最小时间
//            LocalDateTime minTime = LocalDateTime.of(salesmanAPPQueryDTO.getDocTimeStart().toLocalDate(), LocalTime.MIN);
//            salesmanAPPQueryDTO.setDocTimeStart(minTime);
//        }
//        if (Objects.nonNull(salesmanAPPQueryDTO.getDocTimeEnd())) {
//            // 获取最后一天的最大时间
//            LocalDateTime maxTime = LocalDateTime.of(salesmanAPPQueryDTO.getDocTimeEnd().toLocalDate(), ConstantsSale.LOCAL_TIME_MAX);
//            salesmanAPPQueryDTO.setDocTimeEnd(maxTime);
//        }
        Map<String, String> salesmanTypeUDCMap = rmiSysUDCService.getCodeMap("yst-sale", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
        List<SalesmanInfoAPPRespDTO> infoAPPRespDTOS = new ArrayList<>();
        if (salesmanAPPQueryDTO.getOne() == 1){
            //查询没有上级的业务员基本信息
            List<EmployeePageRespDTO> employeePageRespDTOList = getWithoutLeaderEmployee();
            Map<String, SalesmanInfoDO> salesmanInfoDOMap = new HashMap<>();
            EmployeePageQueryDTO employeePageQueryDTO = new EmployeePageQueryDTO();

            MapBuilder mapBuilder = setMapBuilder(salesmanAPPQueryDTO, employeePageRespDTOList);
            //数据权限查询
            List<SalesmanInfoSearchBean> beanSearchResult = searchBeanService.getBeanSearcher().searchAll(SalesmanInfoSearchBean.class, mapBuilder.build());
            if (CollUtil.isEmpty(beanSearchResult)){
                throw new BusinessException("未查询到业务员信息");
            }
            List<SalesmanInfoDO> bySalesmanType = beanSearchResult.stream().map(SalesmanInfoConvert.INSTANCE::searchBeanToDO).collect(Collectors.toList());
            salesmanInfoDOMap = bySalesmanType.stream().collect(Collectors.toMap(SalesmanInfoDO::getSalesmanNo, Function.identity()));
            employeePageQueryDTO.setCodes(bySalesmanType.stream().map(SalesmanInfoDO::getSalesmanNo).collect(Collectors.toSet()));
            employeePageQueryDTO.setType(UdcEnum.CUST_TYPE_SALESMAN.getValueCode());
            employeePageQueryDTO.setEnabled(Boolean.TRUE);
            employeePageQueryDTO.setSize(salesmanAPPQueryDTO.getSize());
            employeePageQueryDTO.setOrders(salesmanAPPQueryDTO.getOrders());
            employeePageQueryDTO.setCurrent(salesmanAPPQueryDTO.getCurrent() + 2 );
            if (StringUtils.isNotBlank(salesmanAPPQueryDTO.getSalesmanCode())){
                employeePageQueryDTO.setCodes(Set.of(salesmanAPPQueryDTO.getSalesmanCode()));
            }else {
                employeePageQueryDTO.setWithoutLeader(true);
            }
            if (StringUtils.isNotBlank(salesmanAPPQueryDTO.getKeyword())){
                employeePageQueryDTO.setKeyword(salesmanAPPQueryDTO.getKeyword());
                employeePageQueryDTO.setCodes(Collections.emptySet());
                employeePageQueryDTO.setWithoutLeader(false);
            }
            ApiResult<PagingVO<EmployeePageRespDTO>> apiResult = employeeRpcService.queryByPage(employeePageQueryDTO);
            if (!apiResult.isSuccess()){
                throw new BusinessException("查询信息失败！"+ apiResult.getMsg());
            }
            List<EmployeePageRespDTO> records = apiResult.getData().getRecords();
            if (CollUtil.isEmpty(records)){
                return PagingVO.builder();
            }
            for (EmployeePageRespDTO record : records) {
                SalesmanInfoAPPRespDTO salesmanInfoAPPRespDTO = new SalesmanInfoAPPRespDTO();
                salesmanInfoAPPRespDTO.setCode(record.getCode());
                salesmanInfoAPPRespDTO.setId(record.getId());
                salesmanInfoAPPRespDTO.setFullName(record.getFullName());
                salesmanInfoAPPRespDTO.setEnabled(record.getEnabled());
                salesmanInfoAPPRespDTO.setPhone(record.getPhone());
                salesmanInfoAPPRespDTO.setHasUnder(record.getHasUnderling());
                salesmanInfoAPPRespDTO.setUnderlingNum(record.getUnderlingNum());
                if (Optional.ofNullable(salesmanInfoDOMap.get(record.getCode())).isPresent()) {
                    salesmanInfoAPPRespDTO.setSalesmanType(salesmanInfoDOMap.get(record.getCode()).getSalesmanType());
                }
                if(salesmanTypeUDCMap.get(record.getCode())!=null){
                    salesmanInfoAPPRespDTO.setSalesmanTypeName(salesmanTypeUDCMap.get(salesmanInfoDOMap.get(record.getCode()).getSalesmanType()));
                }
                infoAPPRespDTOS.add(salesmanInfoAPPRespDTO);
            }
            //组装每个业务员的经销商、门店的团队销售业绩和我的销售业绩
            salesmanRpcService.assembleSalePerformance(infoAPPRespDTOS,salesmanAPPQueryDTO.getDocMonth(),salesmanAPPQueryDTO.getDocTimeStart(),salesmanAPPQueryDTO.getDocTimeEnd());
            return PagingVO.<SalesmanInfoAPPRespDTO>builder()
                    .total(apiResult.getData().getTotal())
                    .records(infoAPPRespDTOS);
        }

        if (salesmanAPPQueryDTO.getOne() == 0 && StringUtils.isNotBlank(salesmanAPPQueryDTO.getSalesmanCode())){
            List<SalesmanInfoAPPRespDTO> salesmanInfoAPPRespDTOS = infoAPPRespDTOS;
            ApiResult<List<EmployeeUnderlingDTO>> underlingByCode = employeeRpcService.getUnderlingByCode(salesmanAPPQueryDTO.getSalesmanCode(), salesmanAPPQueryDTO.getCascade(), true);
            if (!underlingByCode.isSuccess()){
                throw new BusinessException("查询员工信息失败！"+underlingByCode.getMsg());
            }
            List<EmployeeUnderlingDTO> data = underlingByCode.getData();
            if (CollUtil.isEmpty(data)){
                return PagingVO.builder();
            }
            List<SalesmanInfoDO> salesmanInfoDOS = salesmanInfoRepo.findBySalesmanNoIn(data.stream().map(EmployeeUnderlingDTO::getCode).distinct().collect(Collectors.toList()));
            Map<String, SalesmanInfoDO> infoDOMap = new HashMap<>();
            if (CollUtil.isNotEmpty(salesmanInfoDOS)){
                infoDOMap = salesmanInfoDOS.stream().collect(Collectors.toMap(SalesmanInfoDO::getSalesmanNo, Function.identity()));
            }
            for (EmployeeUnderlingDTO datum : data) {
                SalesmanInfoAPPRespDTO salesmanInfo = new SalesmanInfoAPPRespDTO();
                salesmanInfo.setCode(datum.getCode());
                salesmanInfo.setId(datum.getId());
                salesmanInfo.setFullName(datum.getFullName());
                salesmanInfo.setEnabled(datum.getEnabled());
                salesmanInfo.setPhone(datum.getPhone());
                salesmanInfo.setHasUnder(datum.getHasUnderling());
                if (infoDOMap.containsKey(datum.getCode())){
                    salesmanInfo.setSalesmanType(infoDOMap.get(datum.getCode()).getSalesmanType());
                    salesmanInfo.setSalesmanTypeName(salesmanTypeUDCMap.get(infoDOMap.get(datum.getCode()).getSalesmanType()));
                }
                List<SalesmanInfoAPPRespDTO> salesmanInfoAPPRespDTOList = salesmanRpcService.assembleUnderlingList(datum.getUnderlingList(),salesmanAPPQueryDTO.getDocMonth(),salesmanAPPQueryDTO.getDocTimeStart(),salesmanAPPQueryDTO.getDocTimeEnd());
                salesmanInfo.setUnderlingList(salesmanInfoAPPRespDTOList);
                salesmanInfoAPPRespDTOS.add(salesmanInfo);
            }
            //组装每个业务员的经销商、门店的团队销售业绩和我的销售业绩
            salesmanRpcService.assembleSalePerformance(salesmanInfoAPPRespDTOS,salesmanAPPQueryDTO.getDocMonth(),salesmanAPPQueryDTO.getDocTimeStart(),salesmanAPPQueryDTO.getDocTimeEnd());
            return PagingVO.<SalesmanInfoAPPRespDTO>builder()
                    .total(salesmanInfoAPPRespDTOS.size())
                    .records(salesmanInfoAPPRespDTOS);
        }
        return PagingVO.builder();
    }

    public MapBuilder setMapBuilder(SalesmanAPPQueryDTO param, List<EmployeePageRespDTO> employeePageRespDTOList) {
        MapBuilder whereSqlMapBuilder = cn.zhxu.bs.util.MapUtils.builder();

        List<String> codes = employeePageRespDTOList.stream().map(EmployeePageRespDTO::getCode).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(codes)){
            whereSqlMapBuilder.field(SalesmanInfoSearchBean::getSalesmanNo, codes).op(FieldOps.InList);
        }
        whereSqlMapBuilder.field(SalesmanInfoSearchBean::getEnableStatus, 1).op(FieldOps.Equal);
        return whereSqlMapBuilder;
    }

    @Override
    public ApiResult<SalesmanInfoDTO> querySalesmanInfo(SalesmanQueryDTO salesmanQueryDTO) {
        Map<String, String> salesmanTypeUDCMap = rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
        SalesmanInfoDTO salesmanInfoDTO = new SalesmanInfoDTO();
        //id查询
        if (salesmanQueryDTO.getSalesmanId() != null){
            Optional<SalesmanInfoDO> salesmanInfoRepoById = salesmanInfoRepo.findById(salesmanQueryDTO.getSalesmanId());
            if (salesmanInfoRepoById.isEmpty()){
                return ApiResult.fail("未查询到业务员信息");
            }
            SalesmanInfoDO salesmanInfoDO = salesmanInfoRepoById.get();
            salesmanInfoDTO.setId(salesmanInfoDO.getId());
            salesmanInfoDTO.setSalesmanNo(salesmanInfoDO.getSalesmanNo());
            salesmanInfoDTO.setSalesmanType(salesmanInfoDO.getSalesmanType());
            salesmanInfoDTO.setSalesmanTypeName(salesmanTypeUDCMap.get(salesmanInfoDO.getSalesmanType()));
            salesmanInfoDTO.setOuName(salesmanInfoDO.getOuName());
            salesmanInfoDTO.setOuCode(salesmanInfoDO.getOuCode());
            salesmanInfoDTO.setFileCode(salesmanInfoDO.getFileCode());
            ApiResult<List<SysEmployeeDetailDTO>> detailListByCode = employeeRpcService.getDetailListByCode(Set.of(salesmanInfoDO.getSalesmanNo()));
            if (!detailListByCode.isSuccess()){
                return ApiResult.fail("查询员工信息失败");
            }
            List<SysEmployeeDetailDTO> detailDTOS = detailListByCode.getData();
            if (CollUtil.isEmpty(detailDTOS)){
                return ApiResult.ok(salesmanInfoDTO);
            }
            salesmanInfoDTO.setFullName(detailDTOS.get(0).getFullName());
            salesmanInfoDTO.setPhone(detailDTOS.get(0).getPhone());
            salesmanInfoDTO.setOrgId(detailDTOS.get(0).getOrgList().get(0).getOrgId());
            salesmanInfoDTO.setOrgName(detailDTOS.get(0).getOrgList().get(0).getOrgName());
            return ApiResult.ok(salesmanInfoDTO);
        }
        //编码查询
        if (salesmanQueryDTO.getSalesmanCode() != null){
            SalesmanInfoDO salesmanInfoRepoById = salesmanInfoRepo.findBySalesmanNo(salesmanQueryDTO.getSalesmanCode());
            if (Optional.ofNullable(salesmanInfoRepoById).isEmpty()){
                return ApiResult.fail("未查询到业务员信息");
            }
            salesmanInfoDTO.setId(salesmanInfoRepoById.getId());
            salesmanInfoDTO.setSalesmanNo(salesmanInfoRepoById.getSalesmanNo());
            salesmanInfoDTO.setSalesmanType(salesmanInfoRepoById.getSalesmanType());
            salesmanInfoDTO.setSalesmanTypeName(salesmanTypeUDCMap.get(salesmanInfoRepoById.getSalesmanType()));
            salesmanInfoDTO.setOuName(salesmanInfoRepoById.getOuName());
            salesmanInfoDTO.setOuCode(salesmanInfoRepoById.getOuCode());
            salesmanInfoDTO.setFileCode(salesmanInfoRepoById.getFileCode());
            ApiResult<List<SysEmployeeDetailDTO>> detailListByCode = employeeRpcService.getDetailListByCode(Set.of(salesmanInfoRepoById.getSalesmanNo()));
            if (!detailListByCode.isSuccess()){
                return ApiResult.fail("查询员工信息失败");
            }
            List<SysEmployeeDetailDTO> detailDTOS = detailListByCode.getData();
            if (CollUtil.isEmpty(detailDTOS)){
                return ApiResult.ok(salesmanInfoDTO);
            }
            salesmanInfoDTO.setFullName(detailDTOS.get(0).getFullName());
            salesmanInfoDTO.setPhone(detailDTOS.get(0).getPhone());
            salesmanInfoDTO.setOrgId(detailDTOS.get(0).getOrgList().get(0).getOrgId());
            salesmanInfoDTO.setOrgName(detailDTOS.get(0).getOrgList().get(0).getOrgName());
            return ApiResult.ok(salesmanInfoDTO);
        }

        return ApiResult.ok(salesmanInfoDTO);
    }

    @Override
    public ApiResult<List<CrmCustBaseRespVO>> queryAllByAgentEmpIdAndSub(Long agentEmpId) {
        Optional<SalesmanInfoDO> salesmanInfoOptional = salesmanInfoRepo.findById(agentEmpId);
        if(salesmanInfoOptional.isEmpty()){
            return ApiResult.ok();

        }
        SalesmanInfoDO salesmanInfo = salesmanInfoOptional.get();
        ApiResult<List<EmployeeUnderlingDTO>> apiResult = employeeRpcService.getUnderlingByCode(salesmanInfo.getSalesmanNo(),Boolean.TRUE,Boolean.TRUE);
        List<EmployeeUnderlingDTO> resultData = apiResult.getData();
        Set<String> codeList = new HashSet<>();
        codeList.add(salesmanInfo.getSalesmanNo());
        if (!CollUtil.isEmpty(resultData)) {
            List<EmployeeUnderlingDTO> listEmp = new ArrayList<>();
            List<EmployeeUnderlingDTO> res = this.treeToList(resultData,listEmp);
            codeList.addAll(res.stream().map(EmployeeUnderlingDTO::getCode).collect(Collectors.toList()));
        }
        List<SalesmanInfoDO> salesmanInfos = salesmanInfoRepoProc.getSalesmanByCodes(codeList);
        if(CollectionUtils.isEmpty(salesmanInfos)){
            return ApiResult.ok();
        }
        List<Long> agentEmpIds = salesmanInfos.stream().map(SalesmanInfoDO:: getId).collect(Collectors.toList());
        Map<Long,SalesmanInfoDO> empMap = salesmanInfos.stream().collect(Collectors.toMap(SalesmanInfoDO :: getId,t->t,(t1,t2) -> t1));
        List<CrmCustBaseRespVO> list = crmCustRepoProc.getCustByEmpIds(agentEmpIds);
        list.forEach(l ->{
            if(!MapUtils.isEmpty(empMap) && !ObjectUtils.isEmpty(l.getAgentEmpId()) && !ObjectUtils.isEmpty(empMap.get(l.getAgentEmpId()))){
                l.setAgentEmpName(empMap.get(l.getAgentEmpId()).getName());
                l.setAgentEmpCode(empMap.get(l.getAgentEmpId()).getSalesmanNo());
            }
        });
        return ApiResult.ok(list);
    }

    @Override
    public PagingVO<SalesmanInfoStdVO> queryAllSalemanInfosByAgentEmpId(SalesmanUnderLingQueryVO queryVO) {
        ApiResult<List<EmployeeUnderlingDTO>> apiResult = employeeRpcService.getUnderlingByCode(queryVO.getCode(), Boolean.TRUE, Boolean.TRUE);
        if (!apiResult.isSuccess()) {
            throw new BusinessException("查询客户及下级信息失败！" + apiResult.getMsg());
        }
        List<EmployeeUnderlingDTO> resultData = apiResult.getData();
        Set<String> codeList = new HashSet<>();
        codeList.add(queryVO.getCode());
        if (!CollUtil.isEmpty(resultData)) {
            List<EmployeeUnderlingDTO> listEmp = new ArrayList<>();
            List<EmployeeUnderlingDTO> res = this.treeToList(resultData,listEmp);
            codeList.addAll(res.stream().map(EmployeeUnderlingDTO::getCode).collect(Collectors.toList()));
        }
        queryVO.setUnderlingCodes(codeList.stream().collect(Collectors.toList()));
        PagingVO<SalesmanInfoDO> page = salesmanInfoRepoProc.getPageByQueryVO(queryVO);
        if (CollectionUtils.isEmpty(page.getRecords())){
            return new PagingVO<SalesmanInfoStdVO>().setTotal(0L).setRecords(Collections.emptyList());
        }else{
            List<SalesmanInfoStdVO> records = page.getRecords().stream().map(SalesmanInfoConvert.INSTANCE::doToVo).collect(Collectors.toList());
            return new PagingVO<SalesmanInfoStdVO>().setTotal(page.getTotal()).setRecords(records);
        }
    }


    public List<EmployeeUnderlingDTO> treeToList(List<EmployeeUnderlingDTO> source ,List<EmployeeUnderlingDTO> obj){
//        List<EmployeeUnderlingDTO> res = new ArrayList<>();
        source.stream().forEach(v ->{
            EmployeeUnderlingDTO t = new EmployeeUnderlingDTO();
            BeanUtils.copyProperties(v,t);
            t.setUnderlingList(new ArrayList<>());
            obj.add(t);
            if(CollectionUtil.isNotEmpty(v.getUnderlingList())){
                treeToList(v.getUnderlingList(),obj);
            }
        });
        return obj;
    }


}
