package com.elitesland.yst.production.sale.service;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.SaleStatisticsService;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsStoreQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsStoreRespVO;
import com.elitesland.yst.production.sale.search.store.service.StatisticsStoreSearchService;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

@Component
@RequiredArgsConstructor
public class StatisticsExportService implements DataExport<SaleStatisticsStoreRespVO, SaleStatisticsStoreQueryVO> {

    private final StatisticsStoreSearchService statisticsStoreSearchService;

    @Override
    public String getTmplCode() {
        return "sale_statistics_export";
    }

    @Override
    public PagingVO<SaleStatisticsStoreRespVO> executeExport(SaleStatisticsStoreQueryVO param){
        return statisticsStoreSearchService.page(param);
    }


}