package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.sale.api.dto.CustDTO;
import com.elitesland.yst.production.sale.api.service.PriSalePriceService;
import com.elitesland.yst.production.sale.api.service.ZoneSettingService;
import com.elitesland.yst.production.sale.api.service.shop.BipCustUserBindService;
import com.elitesland.yst.production.sale.api.vo.param.pri.PriSalePriceTypeQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.zone.ZoneSettingPageParam;
import com.elitesland.yst.production.sale.api.vo.resp.pri.PriSalePriceTypeRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.zone.ZoneRecParam;
import com.elitesland.yst.production.sale.api.vo.resp.zone.ZoneSaveSettingVO;
import com.elitesland.yst.production.sale.api.vo.resp.zone.ZoneSettingDVO;
import com.elitesland.yst.production.sale.api.vo.resp.zone.ZoneSettingVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.ZoneSettingConvert;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.QZoneSettingDDO;
import com.elitesland.yst.production.sale.entity.ZoneSettingDDO;
import com.elitesland.yst.production.sale.entity.ZoneSettingDO;
import com.elitesland.yst.production.sale.repo.ZoneSettingDRepo;
import com.elitesland.yst.production.sale.repo.ZoneSettingDRepoProc;
import com.elitesland.yst.production.sale.repo.ZoneSettingRepo;
import com.elitesland.yst.production.sale.repo.ZoneSettingRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepo;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.support.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgBuRpcService;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.google.common.collect.Lists;
import com.querydsl.core.types.dsl.BooleanExpression;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@Service
@Slf4j
@RequiredArgsConstructor
public class ZoneSettingServiceImpl implements ZoneSettingService {

    private final OrgBuRpcService orgBuRpcService;

    private final ZoneSettingRepoProc zoneSettingRepoProc;

    private final ZoneSettingRepo zoneSettingRepo;

    private final OrgEmpRpcService orgEmpRpcService;

    private final ZoneSettingDRepo zoneSettingDRepo;

    private final ZoneSettingDRepoProc zoneSettingDRepoProc;

    private final RmiSysNextNumberService rmiSysNextNumberService;

    private final BipItemRepoProc bipItemRepoProc;
    private final BipCustUserBindRepoProc bipCustUserBindRepoProc;
    private final BipCustUserBindService custUserBindService;
    private final PriSalePriceService salePriceService;
//    private final RmiItemService rmiItemService;
    private final BipItemSkuRepo bipItemSkuRepo;

    @Override
    @SysCodeProc
    public PagingVO<ZoneSettingVO> findZonePagingResult(ZoneSettingPageParam param) {
        //获取当前用户的ou
//        OrgUserEmpInfoRpcDTO empInfo = getCurrentEmpInfo();
//        if(null == empInfo.getOuId()){
//            return new PagingVO<>();
//        }
//        param.setOuId(empInfo.getOuId());
        PagingVO<ZoneSettingVO> list = zoneSettingRepoProc.findPagingResult(param);
        return list;
    }

    @Override
    @SysCodeProc
    public ZoneSettingVO findZoneById(Long id) {
        Optional<ZoneSettingDO> optional = zoneSettingRepo.findById(id);
        if (optional.isPresent()) {
            ZoneSettingDO zoneSettingDO = optional.get();
            ZoneSettingVO vo = new ZoneSettingVO();
            BeanUtils.copyProperties(zoneSettingDO, vo);
            List<ZoneSettingDVO> resList = new ArrayList<>();
            List<ZoneSettingDDO> list = getByZoneId(id);
            if (null != list) {
                list.stream().forEach(ddo -> {
                    if (null != ddo.getState() && ddo.getState().equals(UdcEnum.BIP_ITEM_STATE_SHELF.getValueCode())) {
                        ZoneSettingDVO zoneSettingDVO = new ZoneSettingDVO();
                        BeanUtils.copyProperties(ddo, zoneSettingDVO);
                        zoneSettingDVO.setItemId(ddo.getItemId());
                        resList.add(zoneSettingDVO);
                    }
                });
                if (null != resList && !resList.isEmpty()) {
                    vo.setList(resList.stream().sorted(Comparator.comparing(ZoneSettingDVO::getSort)).collect(Collectors.toList()));
                }
            }
            return vo;
        }
        return null;
    }

    public List<ZoneSettingDDO> getByZoneId(Long zoneId) {
        QZoneSettingDDO qZoneSettingDDO = QZoneSettingDDO.zoneSettingDDO;
        BooleanExpression expression = qZoneSettingDDO.zoneId.eq(zoneId).and(qZoneSettingDDO.deleteFlag.eq(0));
        Iterable<ZoneSettingDDO> iterables = zoneSettingDRepo.findAll(expression);
        if (!IterUtil.isEmpty(iterables)) {
            return Lists.newArrayList(iterables);
        }
        return null;
    }


    @Override
    public ApiResult<Object> addOrUpdateZone(ZoneSaveSettingVO param) {

        log.info("专区新增参数：{}", JSON.toJSONString(param));

        ZoneSettingDO zoneSettingDO = new ZoneSettingDO();
        //新增
        if (null == param.getId() || param.getId() < 0) {
            BeanUtils.copyProperties(param, zoneSettingDO);
            OrgUserEmpInfoRpcDTO empInfo = getCurrentEmpInfo();
            zoneSettingDO.setSecBuId(empInfo.getBuId());
            zoneSettingDO.setSecOuId(empInfo.getOuId());
            zoneSettingDO.setSecUserId(empInfo.getUserId());
            zoneSettingDO.setOuId(param.getOuId());
            zoneSettingDO.setOuName(param.getOuName());
            String logisticsCode = rmiSysNextNumberService.generateCode("yst-sale","ZONE_SETTING", new ArrayList<>());
            zoneSettingDO.setZoneCode(logisticsCode);
            zoneSettingDO.setStatus(UdcEnum.SAL_ZONE_STATUS_DRAFT.getValueCode());
            zoneSettingDO = zoneSettingRepo.save(zoneSettingDO);
        } else {
            Optional<ZoneSettingDO> optional = zoneSettingRepo.findById(param.getId());
            if (optional.isPresent()) {
                zoneSettingDO = optional.get();
                zoneSettingDO.setZoneCode(param.getZoneCode());
                zoneSettingDO.setZoneName(param.getZoneName());
                zoneSettingDO.setSort(param.getSort());
                zoneSettingDO.setOuId(param.getOuId());
                zoneSettingDO.setOuName(param.getOuName());
                //  zoneSettingDO.setStatus(param.getStatus());
                zoneSettingDO = zoneSettingRepo.save(zoneSettingDO);
                if (null != param.getList() && !param.getList().isEmpty()) {
                    //先删除商品明细
                    QZoneSettingDDO qZoneSettingDDO = QZoneSettingDDO.zoneSettingDDO;
                    BooleanExpression expression = qZoneSettingDDO.zoneId.eq(zoneSettingDO.getId());
                    Iterable<ZoneSettingDDO> iterables = zoneSettingDRepo.findAll(expression);
                    if (!IterUtil.isEmpty(iterables)) {
                        List<ZoneSettingDDO> list = Lists.newArrayList(iterables);
                        list.stream().forEach(l -> {
                            l.setDeleteFlag(1);
                            zoneSettingDRepo.save(l);
                        });
                    }
                }
            }
        }
        if (null != param.getList() && !param.getList().isEmpty()) {
            ZoneSettingDO finalZoneSettingDO = zoneSettingDO;
            param.getList().stream().forEach(p -> {
                ZoneSettingDDO zoneSettingDDO = new ZoneSettingDDO();
                BeanUtils.copyProperties(p, zoneSettingDDO);
                zoneSettingDDO.setOuId(param.getOuId());
                zoneSettingDDO.setOuName(param.getOuName());
                zoneSettingDDO.setZoneId(finalZoneSettingDO.getId());
                zoneSettingDDO.setItemAttr(p.getItemAttr());
                zoneSettingDDO.setItemCode(p.getItemCode());
                zoneSettingDDO.setItemBrand(p.getItemBrand());
                zoneSettingDDO.setCategoryName(p.getCategoryName());
                zoneSettingDDO.setItemId(p.getItemId());

                Assert.notNull(zoneSettingDDO.getItemId(),"商品【"+p.getItemName()+"】的ID不能为空！");
                Assert.notBlank(zoneSettingDDO.getItemCode(),"商品【"+p.getItemName()+"】的编码不能为空！");

                if (StringUtils.isBlank(p.getState())) {
                    zoneSettingDDO.setState(UdcEnum.BIP_ITEM_STATE_SHELF.getValueCode());
                }
                zoneSettingDRepo.save(zoneSettingDDO);
            });
        }
        return ApiResult.ok();
    }

    @Override
    public ApiResult<Object> delZone(List<Long> ids) {
        QZoneSettingDDO qZoneSettingDDO = QZoneSettingDDO.zoneSettingDDO;
        ids.stream().forEach(id -> {
            Optional<ZoneSettingDO> optional = zoneSettingRepo.findById(id);
            if (optional.isPresent()) {
                ZoneSettingDO zoneSettingDO = optional.get();
                zoneSettingDO.setDeleteFlag(1);
                zoneSettingRepo.save(zoneSettingDO);
                BooleanExpression expression = qZoneSettingDDO.zoneId.eq(id);
                Iterable<ZoneSettingDDO> iterables = zoneSettingDRepo.findAll(expression);
                if (!IterUtil.isEmpty(iterables)) {
                    List<ZoneSettingDDO> list = Lists.newArrayList(iterables);
                    list.stream().forEach(l -> {
                        l.setDeleteFlag(1);
                        zoneSettingDRepo.save(l);
                    });
                }
            }
        });
        return ApiResult.ok();
    }

    @Override
    public ApiResult<Object> activeZone(List<Long> ids) {
        ids.stream().forEach(id -> {
            Optional<ZoneSettingDO> optional = zoneSettingRepo.findById(id);
            ZoneSettingDO zoneSettingDO = optional.get();
            zoneSettingDO.setStatus(UdcEnum.SAL_ZONE_STATUS_ACTIVE.getValueCode());
            zoneSettingRepo.save(zoneSettingDO);
        });
        return ApiResult.ok();
    }

    @Override
    public ApiResult<Object> closedZone(List<Long> ids) {
        ids.stream().forEach(id -> {
            Optional<ZoneSettingDO> optional = zoneSettingRepo.findById(id);
            ZoneSettingDO zoneSettingDO = optional.get();
            zoneSettingDO.setStatus(UdcEnum.SAL_ZONE_STATUS_CLOSED.getValueCode());
            zoneSettingRepo.save(zoneSettingDO);
        });
        return ApiResult.ok();
    }

    @Override
    public List<ZoneSettingVO> homeRecommend(ZoneRecParam param) {

        List<ZoneSettingDO> all = zoneSettingRepo.findAllByOuIdAndStatus(param.getOuId(),
                UdcEnum.SAL_ZONE_STATUS_ACTIVE.getValueCode());

        if (CollUtil.isEmpty(all)) {
            return new ArrayList<>();
        }

        ZoneSettingConvert zoneSettingConvert = ZoneSettingConvert.INSTANCE;

        List<ZoneSettingVO> zoneSettingVOS = new ArrayList<>();
        for (ZoneSettingVO zoneSettingVO : zoneSettingConvert
                .dosToVos(all)) {
            if (zoneSettingVO.getSort() == null) {
                zoneSettingVO.setSort(999);
            }
            zoneSettingVOS.add(zoneSettingVO);
        }
        zoneSettingVOS.sort(Comparator.comparing(ZoneSettingVO::getSort));

        param.setCurrent(1);
        param.setSize(6);

        setZoneDetail(zoneSettingVOS, param);

        return zoneSettingVOS;

    }


    @Override
    public ZoneSettingVO getRecommendForMore(ZoneRecParam param) {

        log.info("首页专区入参：" + JSON.toJSONString(param));

        ZoneSettingDO zoneSettingDO = zoneSettingRepo.findById(param.getZoneId())
                .orElseThrow(() -> {
                    throw new BusinessException("未找到该专区：" + param.getZoneId());
                });

        List<ZoneSettingDO> dos = Collections.singletonList(zoneSettingDO);
        ZoneSettingConvert zoneSettingConvert = ZoneSettingConvert.INSTANCE;

        List<ZoneSettingVO> zoneSettingVOS = zoneSettingConvert.dosToVos(dos)
                .stream()
                .sorted(Comparator.comparing(ZoneSettingVO::getSort))
                .collect(Collectors.toList());

        log.info("首页专区主表：" + JSON.toJSONString(zoneSettingVOS));

        setZoneDetail(zoneSettingVOS, param);

        return zoneSettingVOS.get(0);
    }

    /**
     * 设置明细
     * @param zoneSettingVOS 专区主表
     * @param param 参数
     */
    private void setZoneDetail(List<ZoneSettingVO> zoneSettingVOS, ZoneRecParam param) {
//        for (ZoneSettingVO zoneSettingVO : zoneSettingVOS) {
//            Long zoneId = zoneSettingVO.getId();
//
//            QZoneSettingDDO qZoneSettingDDO = QZoneSettingDDO.zoneSettingDDO;
//
//            var ret = zoneSettingDRepo
//                    .findAll(qZoneSettingDDO.zoneId.eq(zoneId)
//                    .and(qZoneSettingDDO.ouId.eq(param.getOuId()))
//                    .and(qZoneSettingDDO.state.eq("SHELF")), param.getPageRequest()).getContent();
//
//            var vos = ret.stream()
//                    .map(ZoneSettingConvert.INSTANCE::doToVo)
//                    .sorted(Comparator.comparing(ZoneSettingDVO::getSort))
//                    .collect(Collectors.toList());
//
//            log.info("首页专区id" + zoneId + " 明细列表" + JSON.toJSONString(vos));
//
//            List<BipItemDO> items = bipItemRepoProc.getItemByCodes(vos.stream().map(ZoneSettingDVO::getItemCode).collect(Collectors.toList()));
//
//            Map<String, BipItemDO> itemDOMap = items.stream().collect(Collectors.toMap(BipItemDO::getItemCode, item -> item, (t1, t2) -> t1));
//
//            for (ZoneSettingDVO vo : vos) {
//
//                BipItemDO it = itemDOMap.get(vo.getItemCode());
//
//                if (it==null||!it.getOnShelf()) continue;
//
//                List<BipItemSkuDO> skuDOList = bipItemSkuRepo.findByBipItemIdInAndFreeze(Collections.singletonList(vo.getItemId()),false);
//
//                if (skuDOList.size()==0) continue;
//
//                ItmItemRpcDtoParam codeparam = new ItmItemRpcDtoParam();
//                codeparam.setItemCodes(skuDOList.stream().map(BipItemSkuDO::getSkuCode).collect(Collectors.toList()));
//
//                List<ItmItemRpcDTO> dtos = new ArrayList<>(rmiItemService.findItemListByParam(codeparam));
//                if (dtos.size() == 0){
//                    throw new BusinessException("查询商品价格时，未在支撑域找到该商品："+JSON.toJSONString(skuDOList));
//                }
//
//                Assert.notNull(it, "专区" + zoneId + "的列表未找到商品" + vo.getItemCode() + "的信息");
//
//                vo.setItemId(it.getId())
//                        .setMainPicId(it.getMainPicId())
//                        .setMainPicUrl(it.getMainPicUrl())
//                        .setItemTitle(it.getTitle())
//                        .setCurrCode("CNY");
//
//                List<SupportItem> supportItems = new ArrayList<>();
//                for (ItmItemRpcDTO dto : dtos) {
//                    SupportItem supportItem = SupportItem
//                            .builder()
//                            .id(dto.getId())
//                            .uom(dto.getUom())
//                            .build();
//
//                    supportItems.add(supportItem);
//                }
//                vo.setSupportItems(supportItems);
//            }
//
//            List<ZoneSettingDVO> collect = vos.stream().filter(zvo -> zvo.getSupportItems().size() > 0).collect(Collectors.toList());
//
//            // 添加最小客户等级价格
//            convertCustPrice(collect);
//
//            // 最小基础价格
//            convertBasePrice(collect, param.getOuId());
//
//            zoneSettingVO.setList(collect);
//        }
//
//        zoneSettingVOS.removeIf(zoneSettingVO -> zoneSettingVO.getList()==null||zoneSettingVO.getList().size()<=0);
    }

    private void convertCustPrice(List<ZoneSettingDVO> respVOList) {
        CurrentUserDTO user = UserService.currentUser();
        if (user==null){
            return;
        }
        CustDTO cust = custUserBindService.getCustOfUserBind(user.getUserId()).getData();

        if (cust == null || StringUtils.isBlank(cust.getCustLevel())) {
            return;
        }

        for (var resp : respVOList) {
            PriSalePriceTypeQueryParam param = new PriSalePriceTypeQueryParam();
            param.setPriceType(UdcEnum.PRI_SALE_PRICE_TYPE_GROUP.getValueCode());
            param.setCustLevel(cust.getCustLevel());
            param.setCurrCode(resp.getCurrCode());
            param.setOuId(cust.getOuId());

            // 客户等级价格
            resp.getSupportItems()
                    .stream()
                    .map(item -> {
                        param.setItemId(item.getId());
                        param.setUom(item.getUom());

                        PriSalePriceTypeRespVO vo = salePriceService.queryPrice(param);

                        log.info("菜单详情最小客户等级价格：" + JSON.toJSONString(vo));

                        return vo;
                    })
                    .filter(Objects::nonNull)
                    .map(PriSalePriceTypeRespVO::getPrice)
                    .min(BigDecimal::compareTo)
                    .ifPresentOrElse(resp::setPriceCust,()->resp.setPriceCust(null));
        }
    }

    private void convertBasePrice(List<ZoneSettingDVO> respVOList, Long ouId) {
        Assert.notNull(ouId,"专区列表的商品查询基础价格时公司ID不能为空");
        for (var resp : respVOList) {
            PriSalePriceTypeQueryParam param = new PriSalePriceTypeQueryParam();

            param.setPriceType(UdcEnum.PRI_SALE_PRICE_TYPE_BASE.getValueCode());
            param.setCurrCode(resp.getCurrCode());
            param.setOuId(ouId);

            // 设置最小基础价格
            resp.getSupportItems()
                    .stream()
                    .map(item->{
                        param.setItemId(item.getId());
                        param.setUom(item.getUom());

                        PriSalePriceTypeRespVO vo = salePriceService.queryPrice(param);

                        log.info("专区最小基础价格：" + JSON.toJSONString(vo));

                        return vo;
                    })
                    .filter(Objects::nonNull)
                    .map(PriSalePriceTypeRespVO::getPrice)
                    .min(BigDecimal::compareTo)
                    .ifPresentOrElse(resp::setPrice,()->resp.setPrice(null));
        }
    }

    private OrgUserEmpInfoRpcDTO getCurrentEmpInfo() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户已失效,请重登录重试");
        }
        OrgUserEmpInfoRpcDTO userEmpInfo = orgEmpRpcService.findUserEmpInfo(currentUser.getUserId());
        if (userEmpInfo == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "无法获取当前用户信息");
        }
        return userEmpInfo;
    }

}
