package com.elitesland.yst.production.sale.service.shop;

import com.alibaba.fastjson.JSON;
import com.elitesland.yst.production.sale.api.service.shop.BipMessageService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipMessageQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipMessageVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipFirstMessage;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipMessageSaveVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.BipMessageConvert;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.BipCustUserBindDO;
import com.elitesland.yst.production.sale.entity.BipMessageDO;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipMessageRepo;
import com.elitesland.yst.production.sale.repo.shop.BipMessageRepoProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import lombok.RequiredArgsConstructor;
import lombok.val;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * <p>
 * 消息业务实现类
 * </p>
 *
 * @author Shadow
 * @since 2021-08-24 09:09:47
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BipMessageServiceImpl implements BipMessageService {

    private final BipMessageRepo bipMessageRepo;
    private final BipMessageRepoProc bipMessageRepoProc;
    private final BipCustUserBindRepoProc bipCustUserBindRepoProc;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PagingVO<BipMessageVO> search(BipMessageQueryParamVO param) {
        Long userId = currentCust();
        param.setToCustId(userId);

        log.info("查询消息:{}", JSON.toJSONString(param));

        val ret = bipMessageRepo.findAll(bipMessageRepoProc.where(param), param.getPageRequest());

        // 查询过的消息设置已读
        List<BipMessageDO> collect = ret.getContent().stream()
                .filter(message -> UdcEnum.MESSAGE_STATUS_NOTREAD.getValueCode().equals(message.getStatus()))
                .peek(message -> message.setStatus(UdcEnum.MESSAGE_STATUS_READ.getValueCode()))
                .collect(Collectors.toList());

        bipMessageRepo.saveAll(collect);

        val vos = ret.getContent().stream().map(BipMessageConvert.INSTANCE::doToVO).collect(Collectors.toList());

        return PagingVO.<BipMessageVO>builder()
                .total(ret.getTotalElements())
                .records(vos)
                .build();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long createOne(BipMessageSaveVO param) {
        BipMessageDO bipMessageDO = BipMessageConvert.INSTANCE.voToDo(param);
        log.info("消息创建：{}", JSON.toJSONString(bipMessageDO));
        return bipMessageRepo.save(bipMessageDO).getId();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(BipMessageSaveVO param) {
        BipMessageDO objDo = BipMessageConvert.INSTANCE.voToDo(param);
        Optional<BipMessageDO> optional = bipMessageRepo.findById(objDo.getId());
        if (optional.isPresent()) {
            objDo.setId(optional.get().getId());
            bipMessageRepo.save(objDo);
        } else {
            throw new BusinessException(ApiCode.FAIL, "修改失败，数据不存在" + objDo.getId());
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteOne(Long id) {
        this.bipMessageRepo.deleteById(id);
    }

    @Override
    public BipFirstMessage firstMessage() {
        Long userID = currentCust();
        return bipMessageRepoProc.firstMessage(userID);
    }

    @Override
    public ApiResult<String> allRead() {
        Long userID = currentCust();
        bipMessageRepo.allRead(UdcEnum.MESSAGE_STATUS_READ.getValueCode(), userID);
        return ApiResult.ok();
    }

    private Long currentCust(){

        CurrentUserDTO currentUserDTO = UserService.currentUser();

        //获取当前登录人信息和客户信息
        BipCustUserBindDO bipCustUserBindDO = null;

        if(currentUserDTO == null){
            throw new BusinessException("请先登录!");
        }

        Long userId = currentUserDTO.getUserId();

        if (Objects.nonNull(userId)) {
            bipCustUserBindDO = bipCustUserBindRepoProc.getByUserId(userId);
        } else {
            throw new BusinessException("请先登录!");
        }
        if(bipCustUserBindDO == null){
            throw new BusinessException("请绑定公司信息!");
        }
        if (!UdcEnum.BIP_CUST_USER_STATE_ACTIVE.getValueCode().equals(bipCustUserBindDO.getState())){
            throw new BusinessException("请绑定公司信息!");
        }
        if (bipCustUserBindDO.getCustId() == null) {
            throw new BusinessException("请绑定公司信息!");
        }

        return userId;
    }

}
