/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.repo.shop;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.sale.api.dto.BipItemCatsDTO;
import com.elitesland.yst.production.sale.entity.BipItemDO;
import com.elitesland.yst.production.sale.entity.QBipItemDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;

@Repository
public class BipItemRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QBipItemDO DO = QBipItemDO.bipItemDO;

    public BipItemRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }

    public void updateCategoryName(Long categoryId, String categoryName, Integer level) {
        this.jpaQueryFactory.update((EntityPath)DO).set((Path)this.getCategoryName(level), (Object)categoryName).where(new Predicate[]{this.getCategory(level).eq((Object)categoryId)}).execute();
    }

    public void updateState(Long id, String state) {
        this.jpaQueryFactory.update((EntityPath)DO).set((Path)BipItemRepoProc.DO.state, (Object)state).where(new Predicate[]{BipItemRepoProc.DO.id.eq((Object)id)}).execute();
    }

    public void updateState(List<Long> ids, String state) {
        this.jpaQueryFactory.update((EntityPath)DO).set((Path)BipItemRepoProc.DO.state, (Object)state).where(new Predicate[]{BipItemRepoProc.DO.id.in(ids)}).execute();
    }

    public void updateSale(Long id, Long numSale, Long numSale90) {
        this.jpaQueryFactory.update((EntityPath)DO).set(BipItemRepoProc.DO.numSale, (Object)numSale).set(BipItemRepoProc.DO.numSale90, (Object)numSale90).where(new Predicate[]{BipItemRepoProc.DO.id.eq((Object)id)}).execute();
    }

    public void updateRateEvalGood(Long id, Long numEval, Long numEvalGood, BigDecimal rateEvalGood) {
        this.jpaQueryFactory.update((EntityPath)DO).set(BipItemRepoProc.DO.numEval, (Object)numEval).set(BipItemRepoProc.DO.numEvalGood, (Object)numEvalGood).set(BipItemRepoProc.DO.rateEvalGood, (Object)rateEvalGood).where(new Predicate[]{BipItemRepoProc.DO.id.eq((Object)id)}).execute();
    }

    public void updateScoreEval(Long id, BigDecimal scoreEval) {
        this.jpaQueryFactory.update((EntityPath)DO).set(BipItemRepoProc.DO.scoreEval, (Object)scoreEval).where(new Predicate[]{BipItemRepoProc.DO.id.eq((Object)id)}).execute();
    }

    public void updateLackStock(Long id, boolean lackStock) {
        this.jpaQueryFactory.update((EntityPath)DO).set((Path)BipItemRepoProc.DO.lackStock, (Object)lackStock).where(new Predicate[]{BipItemRepoProc.DO.id.eq((Object)id)}).execute();
    }

    public void deleteFake(Long id) {
        this.jpaQueryFactory.update((EntityPath)DO).set(BipItemRepoProc.DO.deleteFlag, (Object)1).set((Path)BipItemRepoProc.DO.onShelf, (Object)false).set(BipItemRepoProc.DO.timeOffShelf, (Object)LocalDateTime.now()).set((Path)BipItemRepoProc.DO.remark, (Object)"\u5220\u9664\u800c\u4e0b\u67b6").where(new Predicate[]{BipItemRepoProc.DO.id.eq((Object)id)}).execute();
    }

    public void deleteFake(List<Long> ids) {
        this.jpaQueryFactory.update((EntityPath)DO).set(BipItemRepoProc.DO.deleteFlag, (Object)1).set((Path)BipItemRepoProc.DO.onShelf, (Object)false).set(BipItemRepoProc.DO.timeOffShelf, (Object)LocalDateTime.now()).set((Path)BipItemRepoProc.DO.remark, (Object)"\u5220\u9664\u800c\u4e0b\u67b6").where(new Predicate[]{BipItemRepoProc.DO.id.in(ids)}).execute();
    }

    public void delete(Long id) {
        this.jpaQueryFactory.delete((EntityPath)DO).where(new Predicate[]{BipItemRepoProc.DO.id.eq((Object)id)}).execute();
    }

    public void delete(List<Long> ids) {
        this.jpaQueryFactory.delete((EntityPath)DO).where(new Predicate[]{BipItemRepoProc.DO.id.in(ids)}).execute();
    }

    public boolean existsById(Long id) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(BipItemRepoProc.DO.id).from((EntityPath)DO)).where((Predicate)BipItemRepoProc.DO.id.eq((Object)id))).limit(1L)).fetchOne() != null;
    }

    public boolean existsByShelfCode(String shelfCode) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(BipItemRepoProc.DO.id).from((EntityPath)DO)).where((Predicate)BipItemRepoProc.DO.shelfCode.eq((Object)shelfCode).and((Predicate)BipItemRepoProc.DO.deleteFlag.eq((Object)0)))).limit(1L)).fetchOne() != null;
    }

    public BipItemDO withoutMainImage(List<Long> ids) {
        return (BipItemDO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)DO).from((EntityPath)DO)).where((Predicate)BipItemRepoProc.DO.id.in(ids).and((Predicate)BipItemRepoProc.DO.mainPicFileCode.isNull().or((Predicate)BipItemRepoProc.DO.mainPicFileCode.eq((Object)""))))).limit(1L)).fetchOne();
    }

    public boolean existsByShelfCode(String shelfCode, Long id) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(BipItemRepoProc.DO.id).from((EntityPath)DO)).where((Predicate)BipItemRepoProc.DO.shelfCode.eq((Object)shelfCode).and((Predicate)BipItemRepoProc.DO.id.ne((Object)id)).and((Predicate)BipItemRepoProc.DO.deleteFlag.eq((Object)0)))).limit(1L)).fetchOne() != null;
    }

    public boolean existsByItemId(Long itemId) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(BipItemRepoProc.DO.id).from((EntityPath)DO)).where((Predicate)BipItemRepoProc.DO.itemId.eq((Object)itemId).and((Predicate)BipItemRepoProc.DO.deleteFlag.eq((Object)0)))).limit(1L)).fetchOne() != null;
    }

    public boolean existsByItemId(Long itemId, Long id) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(BipItemRepoProc.DO.id).from((EntityPath)DO)).where((Predicate)BipItemRepoProc.DO.itemId.eq((Object)itemId).and((Predicate)BipItemRepoProc.DO.id.ne((Object)id)).and((Predicate)BipItemRepoProc.DO.deleteFlag.eq((Object)0)))).limit(1L)).fetchOne() != null;
    }

    public boolean existsByCategoryId(Long categoryId, Integer level) {
        NumberPath<Long> condition = this.getCategory(level);
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(BipItemRepoProc.DO.id).from((EntityPath)DO)).where((Predicate)condition.eq((Object)categoryId).and((Predicate)BipItemRepoProc.DO.deleteFlag.eq((Object)0)))).limit(1L)).fetchOne() != null;
    }

    public List<Long> filterExists(List<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(BipItemRepoProc.DO.id).from((EntityPath)DO)).where((Predicate)BipItemRepoProc.DO.id.in(ids))).fetch();
    }

    public Long getItemId(Long id) {
        return (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(BipItemRepoProc.DO.itemId).from((EntityPath)DO)).where((Predicate)BipItemRepoProc.DO.id.eq((Object)id))).fetchOne();
    }

    public Long getIdByItemId(Long itemId) {
        return (Long)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(BipItemRepoProc.DO.id).from((EntityPath)DO)).where((Predicate)BipItemRepoProc.DO.itemId.eq((Object)itemId))).limit(1L)).fetchOne();
    }

    public String getState(Long id) {
        return (String)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)BipItemRepoProc.DO.state).from((EntityPath)DO)).where((Predicate)BipItemRepoProc.DO.id.eq((Object)id))).fetchOne();
    }

    public Map<Long, String> getState(List<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{BipItemRepoProc.DO.id, BipItemRepoProc.DO.state}).from((EntityPath)DO)).where((Predicate)BipItemRepoProc.DO.id.in(ids))).fetch().stream().collect(Collectors.toMap(t -> (Long)t.get(BipItemRepoProc.DO.id), t -> (String)t.get((Expression)BipItemRepoProc.DO.state), (t1, t2) -> t1));
    }

    public Boolean getShelf(Long id) {
        return (Boolean)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)BipItemRepoProc.DO.shelf).from((EntityPath)DO)).where((Predicate)BipItemRepoProc.DO.id.eq((Object)id))).fetchOne();
    }

    public Map<Long, Boolean> getShelf(List<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{BipItemRepoProc.DO.id, BipItemRepoProc.DO.shelf}).from((EntityPath)DO)).where((Predicate)BipItemRepoProc.DO.id.in(ids))).fetch().stream().collect(Collectors.toMap(t -> (Long)t.get(BipItemRepoProc.DO.id), t -> (Boolean)t.get((Expression)BipItemRepoProc.DO.shelf), (t1, t2) -> t1));
    }

    public BipItemCatsDTO getItemCategory(Long id) {
        return (BipItemCatsDTO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BipItemCatsDTO.class, (Expression[])new Expression[]{BipItemRepoProc.DO.categoryId1, BipItemRepoProc.DO.categoryId2, BipItemRepoProc.DO.categoryId3, BipItemRepoProc.DO.categoryName1, BipItemRepoProc.DO.categoryName2, BipItemRepoProc.DO.categoryName3})).from((EntityPath)DO)).where((Predicate)BipItemRepoProc.DO.id.eq((Object)id))).fetchOne();
    }

    public NumberPath<Long> getCategory(Integer level) {
        switch (level) {
            case 1: {
                return BipItemRepoProc.DO.categoryId1;
            }
            case 2: {
                return BipItemRepoProc.DO.categoryId2;
            }
            case 3: {
                return BipItemRepoProc.DO.categoryId3;
            }
        }
        throw new BusinessException("\u672a\u77e5\u5546\u54c1\u5206\u7c7b");
    }

    private StringPath getCategoryName(Integer level) {
        switch (level) {
            case 1: {
                return BipItemRepoProc.DO.categoryName1;
            }
            case 2: {
                return BipItemRepoProc.DO.categoryName2;
            }
            case 3: {
                return BipItemRepoProc.DO.categoryName3;
            }
        }
        throw new BusinessException("\u672a\u77e5\u5546\u54c1\u5206\u7c7b");
    }

    public BipItemDO getItemForImage(String code, String ouCode) {
        return (BipItemDO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)DO).from((EntityPath)DO)).where((Predicate)BipItemRepoProc.DO.itemCode.eq((Object)code).and((Predicate)BipItemRepoProc.DO.ouCode.eq((Object)ouCode)))).fetchOne();
    }

    public List<BipItemDO> getItemByCodes(List<String> codes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)DO).from((EntityPath)DO)).where((Predicate)BipItemRepoProc.DO.itemCode.in(codes))).fetch();
    }

    public List<Long> findByIdAndOuCode(List<Long> ids, String buCode) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(BipItemRepoProc.DO.id).from((EntityPath)DO)).where((Predicate)BipItemRepoProc.DO.id.in(ids).and((Predicate)BipItemRepoProc.DO.ouCode.eq((Object)buCode)))).fetch();
    }

    public List<Long> findIdByItemIds(List<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(BipItemRepoProc.DO.id).from((EntityPath)DO)).where((Predicate)BipItemRepoProc.DO.id.in(ids).and((Predicate)BipItemRepoProc.DO.deleteFlag.eq((Object)0)))).fetch();
    }

    public List<Long> findOuIdByItemIds(List<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(BipItemRepoProc.DO.ouId).from((EntityPath)DO)).where((Predicate)BipItemRepoProc.DO.id.in(ids).and((Predicate)BipItemRepoProc.DO.deleteFlag.eq((Object)0)))).fetch();
    }
}

