/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.dto.CustDTO;
import com.elitesland.yst.production.sale.api.service.BusFirstMenuConfService;
import com.elitesland.yst.production.sale.api.service.PriSalePriceService;
import com.elitesland.yst.production.sale.api.service.shop.BipCustUserBindService;
import com.elitesland.yst.production.sale.api.vo.param.menu.BusFirstMenuConfPagingParam;
import com.elitesland.yst.production.sale.api.vo.param.menu.BusFirstMenuConfSaveParam;
import com.elitesland.yst.production.sale.api.vo.param.pri.PriSalePriceTypeQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipHomeMenuPageVO;
import com.elitesland.yst.production.sale.api.vo.resp.menu.BusFirstMenuConfDVO;
import com.elitesland.yst.production.sale.api.vo.resp.menu.BusFirstMenuConfVO;
import com.elitesland.yst.production.sale.api.vo.resp.pri.PriSalePriceTypeRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipHomeDetailVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipHomeMenuVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.BusMenuConvert;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.BusFirstMenuConfDDO;
import com.elitesland.yst.production.sale.entity.BusFirstMenuConfDO;
import com.elitesland.yst.production.sale.entity.QBusFirstMenuConfDDO;
import com.elitesland.yst.production.sale.entity.QBusFirstMenuConfDO;
import com.elitesland.yst.production.sale.repo.BusFirstMenuConfDRepo;
import com.elitesland.yst.production.sale.repo.BusFirstMenuConfDRepoProc;
import com.elitesland.yst.production.sale.repo.BusFirstMenuConfRepo;
import com.elitesland.yst.production.sale.repo.BusFirstMenuConfRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.support.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class BusFirstMenuConfServiceImpl
implements BusFirstMenuConfService {
    private static final Logger log = LoggerFactory.getLogger(BusFirstMenuConfServiceImpl.class);
    private final BusFirstMenuConfRepo busFirstMenuConfRepo;
    private final BusFirstMenuConfRepoProc busFirstMenuConfRepoProc;
    private final RmiSysNextNumberService rmiSysNextNumberService;
    private final OrgEmpRpcService orgEmpRpcService;
    private final BusFirstMenuConfDRepo busFirstMenuConfDRepo;
    private final BusFirstMenuConfDRepoProc busFirstMenuConfDRepoProc;
    private final BipCustUserBindService custUserBindService;
    private final PriSalePriceService salePriceService;
    private final BipItemRepoProc bipItemRepoProc;
    private final BipItemSkuRepoProc bipItemSkuRepoProc;

    public ApiResult<Object> stopMenuConf(List<Long> ids) {
        if (null != ids && !ids.isEmpty()) {
            ids.stream().forEach(id -> {
                Optional optional = this.busFirstMenuConfRepo.findById(id);
                if (optional.isPresent()) {
                    BusFirstMenuConfDO busFirstMenuConfDO = (BusFirstMenuConfDO)optional.get();
                    busFirstMenuConfDO.setStatus(UdcEnum.COM_STATUS_ACTIVEORNO_INACTIVE.getValueCode());
                    this.busFirstMenuConfRepo.save(busFirstMenuConfDO);
                }
            });
        }
        return ApiResult.ok();
    }

    public void delMenuPic(Long id) {
        Optional optional = this.busFirstMenuConfRepo.findById(id);
        if (optional.isPresent()) {
            BusFirstMenuConfDO busFirstMenuConfDO = (BusFirstMenuConfDO)optional.get();
            busFirstMenuConfDO.setImgSign(null);
            this.busFirstMenuConfRepo.save(busFirstMenuConfDO);
        }
    }

    public List<BusFirstMenuConfVO> findFirstPage(Long ouId) {
        QBusFirstMenuConfDO qBusFirstMenuConfDO = QBusFirstMenuConfDO.busFirstMenuConfDO;
        BooleanExpression expression = qBusFirstMenuConfDO.ouId.eq((Object)ouId).and((Predicate)qBusFirstMenuConfDO.status.eq((Object)UdcEnum.COM_STATUS_ACTIVEORNO_ACTIVE.getCode()));
        Iterable iterable = this.busFirstMenuConfRepo.findAll((Predicate)expression);
        ArrayList<BusFirstMenuConfVO> list = new ArrayList<BusFirstMenuConfVO>();
        if (null != iterable) {
            iterable.forEach(d -> {
                BusFirstMenuConfVO busFirstMenuConfVO = new BusFirstMenuConfVO();
                BeanUtils.copyProperties((Object)d, (Object)busFirstMenuConfVO);
                list.add(busFirstMenuConfVO);
            });
        }
        return list;
    }

    public ApiResult<Object> delMenuConf(List<Long> ids) {
        if (null != ids && !ids.isEmpty()) {
            QBusFirstMenuConfDDO qBusFirstMenuConfDDO = QBusFirstMenuConfDDO.busFirstMenuConfDDO;
            ids.stream().forEach(id -> {
                Optional optional = this.busFirstMenuConfRepo.findById(id);
                if (optional.isPresent()) {
                    BusFirstMenuConfDO busFirstMenuConfDO = (BusFirstMenuConfDO)optional.get();
                    busFirstMenuConfDO.setDeleteFlag(1);
                    this.busFirstMenuConfRepo.save(busFirstMenuConfDO);
                    BooleanExpression expression = qBusFirstMenuConfDDO.menuId.eq(id);
                    Iterable iterables = this.busFirstMenuConfDRepo.findAll((Predicate)expression);
                    if (!IterUtil.isEmpty((Iterable)iterables)) {
                        ArrayList list = Lists.newArrayList((Iterable)iterables);
                        list.stream().forEach(l -> {
                            l.setDeleteFlag(1);
                            this.busFirstMenuConfDRepo.save(l);
                        });
                    }
                }
            });
        }
        return ApiResult.ok();
    }

    public ApiResult<Object> openMenuConf(List<Long> ids) {
        if (null != ids && !ids.isEmpty()) {
            ids.stream().forEach(id -> {
                Optional optional = this.busFirstMenuConfRepo.findById(id);
                if (optional.isPresent()) {
                    BusFirstMenuConfDO busFirstMenuConfDO = (BusFirstMenuConfDO)optional.get();
                    busFirstMenuConfDO.setStatus(UdcEnum.COM_STATUS_ACTIVEORNO_ACTIVE.getValueCode());
                    this.busFirstMenuConfRepo.save(busFirstMenuConfDO);
                }
            });
        }
        return ApiResult.ok();
    }

    @SysCodeProc
    public PagingVO<BusFirstMenuConfVO> findMenuConfPagingResult(BusFirstMenuConfPagingParam param) {
        PagingVO<BusFirstMenuConfVO> list = this.busFirstMenuConfRepoProc.findMenuConfPagingResult(param);
        return list;
    }

    @SysCodeProc
    public BusFirstMenuConfVO findMenuById(Long id) {
        Optional optional = this.busFirstMenuConfRepo.findById(id);
        if (optional.isPresent()) {
            BusFirstMenuConfDO busFirstMenuConfDO = (BusFirstMenuConfDO)optional.get();
            BusFirstMenuConfVO vo = new BusFirstMenuConfVO();
            BeanUtils.copyProperties((Object)busFirstMenuConfDO, (Object)vo);
            ArrayList resList = new ArrayList();
            List<BusFirstMenuConfDDO> list = this.getByMenuId(id);
            if (null != list && !list.isEmpty()) {
                list.stream().forEach(ddo -> {
                    if (StringUtils.isNotBlank((CharSequence)ddo.getState()) && ddo.getState().equals(UdcEnum.BIP_ITEM_STATE_SHELF.getValueCode())) {
                        BusFirstMenuConfDVO busFirstMenuConfDVO = new BusFirstMenuConfDVO();
                        BeanUtils.copyProperties((Object)ddo, (Object)busFirstMenuConfDVO);
                        busFirstMenuConfDVO.setItemId(ddo.getItemId());
                        resList.add(busFirstMenuConfDVO);
                    }
                });
                if (null != resList && !resList.isEmpty()) {
                    vo.setList(resList);
                }
            }
            return vo;
        }
        return null;
    }

    public List<BusFirstMenuConfDDO> getByMenuId(Long id) {
        QBusFirstMenuConfDDO qBusFirstMenuConfDDO = QBusFirstMenuConfDDO.busFirstMenuConfDDO;
        BooleanExpression expression = qBusFirstMenuConfDDO.menuId.eq((Object)id).and((Predicate)qBusFirstMenuConfDDO.deleteFlag.eq((Object)0));
        Iterable iterables = this.busFirstMenuConfDRepo.findAll((Predicate)expression);
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            return Lists.newArrayList((Iterable)iterables);
        }
        return null;
    }

    public ApiResult<Object> addOrUpdateMenuConf(BusFirstMenuConfSaveParam param) {
        List paramList;
        log.info("\u83dc\u5355\u65b0\u589e\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)param));
        BusFirstMenuConfDO busFirstMenuConfDO = new BusFirstMenuConfDO();
        OrgUserEmpInfoRpcDTO empInfo = this.getCurrentEmpInfo();
        if (null == param.getId()) {
            BeanUtils.copyProperties((Object)param, (Object)busFirstMenuConfDO);
            busFirstMenuConfDO.setSecBuId(empInfo.getBuId());
            busFirstMenuConfDO.setSecOuId(empInfo.getOuId());
            busFirstMenuConfDO.setSecUserId(empInfo.getUserId());
            busFirstMenuConfDO.setStatus(UdcEnum.COM_STATUS_ACTIVEORNO_INACTIVE.getValueCode());
            String menuCode = this.rmiSysNextNumberService.generateCode("yst-sale", "MENU_MANAGE", new ArrayList<String>());
            busFirstMenuConfDO.setMenuNo(menuCode);
        } else {
            Optional optional = this.busFirstMenuConfRepo.findById(param.getId());
            if (optional.isPresent()) {
                busFirstMenuConfDO = (BusFirstMenuConfDO)optional.get();
                busFirstMenuConfDO.setOuId(param.getOuId());
                busFirstMenuConfDO.setOuName(param.getOuName());
                busFirstMenuConfDO.setMenuName(param.getMenuName());
                busFirstMenuConfDO.setImgSign(param.getImgSign());
                busFirstMenuConfDO.setMenuSort(param.getMenuSort());
            }
        }
        busFirstMenuConfDO = (BusFirstMenuConfDO)this.busFirstMenuConfRepo.save(busFirstMenuConfDO);
        QBusFirstMenuConfDDO qBusFirstMenuConfDDO = QBusFirstMenuConfDDO.busFirstMenuConfDDO;
        BooleanExpression expression = qBusFirstMenuConfDDO.menuId.eq((Object)busFirstMenuConfDO.getId()).and((Predicate)qBusFirstMenuConfDDO.deleteFlag.eq((Object)0));
        Iterable iterables = this.busFirstMenuConfDRepo.findAll((Predicate)expression);
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            ArrayList ddoList = Lists.newArrayList((Iterable)iterables);
            ddoList.stream().forEach(ddo -> {
                ddo.setDeleteFlag(1);
                this.busFirstMenuConfDRepo.save(ddo);
            });
        }
        if (null != (paramList = param.getList()) && !paramList.isEmpty()) {
            BusFirstMenuConfDO finalBusFirstMenuConfDO = busFirstMenuConfDO;
            paramList.stream().forEach(params -> {
                BusFirstMenuConfDDO busFirstMenuConfDDO = new BusFirstMenuConfDDO();
                BeanUtils.copyProperties((Object)params, (Object)busFirstMenuConfDDO);
                busFirstMenuConfDDO.setOuId(param.getOuId());
                busFirstMenuConfDDO.setOuName(param.getOuName());
                busFirstMenuConfDDO.setItemId(params.getItemId());
                busFirstMenuConfDDO.setItemAttr(params.getItemAttr());
                busFirstMenuConfDDO.setItemBrand(params.getItemBrand());
                busFirstMenuConfDDO.setBarcode(params.getBarcode());
                busFirstMenuConfDDO.setSort(params.getSort());
                busFirstMenuConfDDO.setCategoryName(params.getCategoryName());
                busFirstMenuConfDDO.setMenuId(finalBusFirstMenuConfDO.getId());
                if (StringUtils.isBlank((CharSequence)params.getState())) {
                    busFirstMenuConfDDO.setState(UdcEnum.BIP_ITEM_STATE_SHELF.getValueCode());
                }
                Assert.notNull((Object)busFirstMenuConfDDO.getItemId(), (String)("\u5546\u54c1\u3010" + params.getItemName() + "\u3011\u7684ID\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
                Assert.notBlank((CharSequence)busFirstMenuConfDDO.getItemCode(), (String)("\u5546\u54c1\u3010" + params.getItemName() + "\u3011\u7684\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
                this.busFirstMenuConfDRepo.save(busFirstMenuConfDDO);
            });
        }
        return ApiResult.ok();
    }

    private OrgUserEmpInfoRpcDTO getCurrentEmpInfo() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u5df2\u5931\u6548,\u8bf7\u91cd\u767b\u5f55\u91cd\u8bd5");
        }
        OrgUserEmpInfoRpcDTO userEmpInfo = this.orgEmpRpcService.findUserEmpInfo(currentUser.getUserId());
        if (userEmpInfo == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f");
        }
        return userEmpInfo;
    }

    public List<BipHomeMenuVO> findHomeMenu(Long ouId) {
        if (ouId != null) {
            List<BusFirstMenuConfDO> dos = this.busFirstMenuConfRepoProc.selectForHome(ouId).stream().peek(bfmc -> {
                if (null != bfmc.getMenuSort()) {
                    return;
                }
                bfmc.setMenuSort(999);
            }).sorted(Comparator.comparing(BusFirstMenuConfDO::getMenuSort)).collect(Collectors.toList());
            return BusMenuConvert.INSTANCE.dosToVOS(dos);
        }
        return Collections.emptyList();
    }

    public PagingVO<BipHomeDetailVO> findHomeMenuDetails(BipHomeMenuPageVO bipHomeMenuPageVO) {
        return null;
    }

    private void convertCustPrice(List<BipHomeDetailVO> detail) {
        CurrentUserDTO user = UserService.currentUser();
        if (user == null) {
            return;
        }
        CustDTO cust = (CustDTO)this.custUserBindService.getCustOfUserBind(user.getUserId()).getData();
        if (cust == null || StringUtils.isBlank((CharSequence)cust.getCustLevel())) {
            return;
        }
        for (BipHomeDetailVO resp : detail) {
            PriSalePriceTypeQueryParam param = new PriSalePriceTypeQueryParam();
            param.setPriceType(UdcEnum.PRI_SALE_PRICE_TYPE_GROUP.getValueCode());
            param.setCustLevel(cust.getCustLevel());
            param.setCurrCode("CNY");
            param.setOuId(cust.getOuId());
            resp.getSupportItems().stream().map(item -> {
                param.setItemId(item.getId());
                param.setUom(item.getUom());
                PriSalePriceTypeRespVO vo = this.salePriceService.queryPrice(param);
                log.info("\u83dc\u5355\u8be6\u60c5\u6700\u5c0f\u5ba2\u6237\u7b49\u7ea7\u4ef7\u683c\uff1a" + JSON.toJSONString((Object)vo));
                return vo;
            }).filter(Objects::nonNull).map(PriSalePriceTypeRespVO::getPrice).min(BigDecimal::compareTo).ifPresentOrElse(arg_0 -> ((BipHomeDetailVO)resp).setPriceCust(arg_0), () -> resp.setPriceCust(null));
        }
    }

    private void convertBasePrice(List<BipHomeDetailVO> respVOList, Long ouId) {
        Assert.notNull((Object)ouId, (String)"\u83dc\u5355\u5217\u8868\u7684\u5546\u54c1\u67e5\u8be2\u57fa\u7840\u4ef7\u683c\u65f6\u516c\u53f8ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (BipHomeDetailVO resp : respVOList) {
            PriSalePriceTypeQueryParam param = new PriSalePriceTypeQueryParam();
            param.setPriceType(UdcEnum.PRI_SALE_PRICE_TYPE_BASE.getValueCode());
            param.setCurrCode(resp.getCurrCode());
            param.setOuId(ouId);
            resp.getSupportItems().stream().map(item -> {
                param.setItemId(item.getId());
                param.setUom(item.getUom());
                PriSalePriceTypeRespVO vo = this.salePriceService.queryPrice(param);
                log.info("\u83dc\u5355\u8be6\u60c5\u6700\u5c0f\u57fa\u7840\u4ef7\u683c\uff1a{}", (Object)JSON.toJSONString((Object)vo));
                return vo;
            }).filter(Objects::nonNull).map(PriSalePriceTypeRespVO::getPrice).min(BigDecimal::compareTo).ifPresentOrElse(arg_0 -> ((BipHomeDetailVO)resp).setPrice(arg_0), () -> resp.setPrice(null));
        }
    }

    public BusFirstMenuConfServiceImpl(BusFirstMenuConfRepo busFirstMenuConfRepo, BusFirstMenuConfRepoProc busFirstMenuConfRepoProc, RmiSysNextNumberService rmiSysNextNumberService, OrgEmpRpcService orgEmpRpcService, BusFirstMenuConfDRepo busFirstMenuConfDRepo, BusFirstMenuConfDRepoProc busFirstMenuConfDRepoProc, BipCustUserBindService custUserBindService, PriSalePriceService salePriceService, BipItemRepoProc bipItemRepoProc, BipItemSkuRepoProc bipItemSkuRepoProc) {
        this.busFirstMenuConfRepo = busFirstMenuConfRepo;
        this.busFirstMenuConfRepoProc = busFirstMenuConfRepoProc;
        this.rmiSysNextNumberService = rmiSysNextNumberService;
        this.orgEmpRpcService = orgEmpRpcService;
        this.busFirstMenuConfDRepo = busFirstMenuConfDRepo;
        this.busFirstMenuConfDRepoProc = busFirstMenuConfDRepoProc;
        this.custUserBindService = custUserBindService;
        this.salePriceService = salePriceService;
        this.bipItemRepoProc = bipItemRepoProc;
        this.bipItemSkuRepoProc = bipItemSkuRepoProc;
    }
}

