/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.resp.EmployeeUnderlingDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysAreaRpcService;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.sale.api.service.CrmCustOuService;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.service.SalesmanInfoService;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustOuParamVO;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustQueryLmParam;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustCode2BaseParam;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustBaseRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustPageLmVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustSimpleVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustAccountVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustCode2BaseDTO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.LmCrmCustSaveVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.yst.production.sale.api.vo.save.CrmCustOuSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.CrmCustSaveVO;
import com.elitesland.yst.production.sale.convert.CrmCustConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.dto.CrmAgentReqDTO;
import com.elitesland.yst.production.sale.dto.CrmCustBaseDTO;
import com.elitesland.yst.production.sale.dto.CrmCustDTO;
import com.elitesland.yst.production.sale.dto.CrmCustJudgeDTO;
import com.elitesland.yst.production.sale.dto.CrmCustRespDTO;
import com.elitesland.yst.production.sale.dto.CrmCustSimpleDTO;
import com.elitesland.yst.production.sale.dto.CustBaseInfoDTO;
import com.elitesland.yst.production.sale.dto.SalesmanInfoDTO;
import com.elitesland.yst.production.sale.dto.SalesmanLevelInfoDTO;
import com.elitesland.yst.production.sale.dto.param.CrmCustRpcDtoParam;
import com.elitesland.yst.production.sale.dto.query.SalesmanQueryDTO;
import com.elitesland.yst.production.sale.dto.save.CrmCustRpcSaveDto;
import com.elitesland.yst.production.sale.entity.CrmCustDO;
import com.elitesland.yst.production.sale.entity.QCrmCustDO;
import com.elitesland.yst.production.sale.entity.SalesmanInfoDO;
import com.elitesland.yst.production.sale.repo.CrmCustRepo;
import com.elitesland.yst.production.sale.repo.CrmCustRepoProc;
import com.elitesland.yst.production.sale.repo.CustAccountRepoProc;
import com.elitesland.yst.production.sale.repo.SalesmanInfoRepo;
import com.elitesland.yst.production.sale.repo.SalesmanInfoRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgEmpService;
import com.elitesland.yst.production.sale.service.CrmCustRpcService;
import com.google.common.collect.Lists;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"/rpc/cloudt/sale/cust"})
public class CrmCustRpcServiceImpl
extends BaseServiceImpl
implements CrmCustRpcService {
    private static final Logger log = LoggerFactory.getLogger(CrmCustRpcServiceImpl.class);
    @Autowired
    private CrmCustRepo crmCustRepo;
    @Autowired
    private CrmCustRepoProc crmCustRepoProc;
    @Autowired
    private CustAccountRepoProc custAccountRepoProc;
    @Autowired
    private CrmCustService crmCustService;
    @Autowired
    private CrmCustOuService crmCustOuService;
    @Autowired
    private RmiOrgEmpService rmiOrgEmpService;
    @Autowired
    private SalesmanInfoService salesmanInfoService;
    @Autowired
    private EmployeeRpcService employeeRpcService;
    @Autowired
    private SalesmanInfoRepo salesmanInfoRepo;
    @Autowired
    private SalesmanInfoRepoProc salesmanInfoRepoProc;
    @Autowired
    private SysAreaRpcService sysAreaRpcService;
    @Autowired
    private UdcProvider udcProvider;
    private final QCrmCustDO qCrmCustDO = QCrmCustDO.crmCustDO;

    public ApiResult<LmSaveCustRespVO> saveCustLm(LmCrmCustSaveVO save) {
        CrmCustConvert crmCustConvert = CrmCustConvert.INSTANCE;
        CrmCustSaveVO custSaveVO = crmCustConvert.saveLmToVo(save);
        ApiResult crmCustDetailResp = this.crmCustService.saveLm(custSaveVO);
        if (crmCustDetailResp.isSuccess() && !Objects.isNull(crmCustDetailResp)) {
            CrmCustDetailRespVO crmCustDetailRespVO = (CrmCustDetailRespVO)crmCustDetailResp.getData();
            LmSaveCustRespVO res = new LmSaveCustRespVO();
            res.setId(crmCustDetailRespVO.getId());
            res.setCustCode(crmCustDetailRespVO.getCustCode());
            res.setCustName(crmCustDetailRespVO.getCustName());
            return ApiResult.ok((Object)res);
        }
        return ApiResult.fail((String)crmCustDetailResp.getMsg());
    }

    public ApiResult<List<CustCode2BaseDTO>> getByCust2Base(CustCode2BaseParam param) {
        List<CustCode2BaseDTO> res = this.crmCustRepoProc.getByCust2Base(param);
        if (CollectionUtil.isNotEmpty(res)) {
            Map regionMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "REGION");
            Map<Object, Object> areaMap = new HashMap();
            List areaCodes = res.stream().map(CustCode2BaseDTO::getProvinceCode).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(areaCodes)) {
                HashSet<String> set = new HashSet<String>(areaCodes);
                areaMap = this.getArea(set);
            }
            HashMap finalAreaMap = areaMap;
            res.forEach(r -> {
                if (!MapUtils.isEmpty((Map)finalAreaMap) && StringUtil.isNotBlank((CharSequence)r.getProvinceCode()) && null != finalAreaMap.get(r.getProvinceCode())) {
                    r.setProvinceName(((SysAreaRespDTO)finalAreaMap.get(r.getProvinceCode())).getAreaName());
                }
                if (!MapUtils.isEmpty((Map)regionMap) && StringUtil.isNotBlank((CharSequence)r.getRegion()) && null != regionMap.get(r.getRegion())) {
                    r.setRegionName((String)regionMap.get(r.getRegion()));
                }
            });
        }
        return ApiResult.ok(res);
    }

    public Map<String, SysAreaRespDTO> getArea(Set<String> areaCodes) {
        Map<String, SysAreaRespDTO> map = new HashMap<String, SysAreaRespDTO>();
        ApiResult listByAreaCodes = this.sysAreaRpcService.listByAreaCodes(areaCodes);
        if (listByAreaCodes.isSuccess() && CollectionUtil.isNotEmpty((Collection)((Collection)listByAreaCodes.getData()))) {
            map = ((List)listByAreaCodes.getData()).stream().collect(Collectors.toMap(SysAreaRespDTO::getAreaCode, t -> t, (t1, t2) -> t1));
        }
        return map;
    }

    public PagingVO<CrmCustPageLmVO> pageLm(CrmCustQueryLmParam searchParam) {
        if (searchParam == null) {
            return new PagingVO();
        }
        PagingVO<CrmCustPageLmVO> pagingVO = this.crmCustRepoProc.findPageCust(searchParam);
        if (!pagingVO.isEmpty() && !pagingVO.getRecords().isEmpty()) {
            pagingVO.getRecords().forEach(p -> {
                ApiResult<SalesmanInfoDTO> res;
                if (!StringUtils.isEmpty((CharSequence)p.getPid())) {
                    String pidName = this.crmCustRepoProc.getCustNameByPidCode(p.getPid());
                    p.setPidName(pidName);
                }
                if (!Objects.isNull(p.getAgentEmpId()) && (res = this.getSaleManInfo(p.getAgentEmpId())).isSuccess() && !ObjectUtils.isEmpty(res) && !ObjectUtils.isEmpty((Object)res.getData())) {
                    p.setAgentEmpName(((SalesmanInfoDTO)res.getData()).getFullName());
                }
            });
        }
        return pagingVO;
    }

    public ApiResult<SalesmanInfoDTO> getSaleManInfo(Long agentEmpId) {
        SalesmanQueryDTO salesmanQueryDTO = new SalesmanQueryDTO();
        salesmanQueryDTO.setSalesmanId(agentEmpId);
        return this.salesmanInfoService.querySalesmanInfo(salesmanQueryDTO);
    }

    public List<CrmCustPageLmVO> searchExport(CrmCustQueryParam param) {
        List<CrmCustPageLmVO> list = this.crmCustRepoProc.searchExoprt(param);
        return list;
    }

    public ApiResult<List<LmSaveCustRespVO>> findInvCust(List<String> custCode) {
        List<LmSaveCustRespVO> list = this.crmCustRepoProc.findInvCustCodes(custCode);
        return ApiResult.ok(list);
    }

    public List<LmSaveCustRespVO> findBaseCustInfo(CustCode2BaseParam param) {
        List<LmSaveCustRespVO> list = this.crmCustRepoProc.findBaseCustInfo(param);
        return list;
    }

    public ApiResult<String> getCustName(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"\u5ba2\u6237ID\u4e3a\u7a7a");
        }
        String custName = this.crmCustRepoProc.getCustName(id);
        return ApiResult.ok((Object)custName);
    }

    public ApiResult<List<CrmCustDTO>> listCustById(List<Long> ids) {
        if (CollUtil.isEmpty(ids)) {
            return ApiResult.fail((String)"\u5ba2\u6237ID\u4e3a\u7a7a");
        }
        List custDOList = this.crmCustRepo.findAllById(ids);
        if (custDOList.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        CrmCustConvert convert = CrmCustConvert.INSTANCE;
        Map<String, String> regionNameMap = this.convertUdc(null);
        Map<String, String> custTypeNameMap = this.convertUdc(null);
        List custDTOList = custDOList.stream().map(t -> {
            CrmCustDTO custDTO = convert.do2Dto((CrmCustDO)t);
            custDTO.setRegionName((String)regionNameMap.get(t.getRegion()));
            custDTO.setCustTypeName((String)custTypeNameMap.get(t.getCustType()));
            return custDTO;
        }).collect(Collectors.toList());
        return ApiResult.ok(custDTOList);
    }

    public ApiResult<List<CrmCustSimpleDTO>> query(String keyword) {
        if (StrUtil.isBlank((CharSequence)keyword)) {
            return ApiResult.fail((String)"\u641c\u7d22\u5173\u952e\u5b57\u4e3a\u7a7a");
        }
        List<CrmCustSimpleDTO> simpleDTOList = this.crmCustRepoProc.query(keyword);
        return ApiResult.ok(simpleDTOList);
    }

    public ApiResult<List<CrmCustRespDTO>> queryAllByAgentEmpId(Long agentEmpId) {
        if (agentEmpId == null) {
            return ApiResult.fail((String)"\u67e5\u8be2\u7684\u4e1a\u52a1\u5458id\u4e3a\u7a7a");
        }
        List<CrmCustRespDTO> crmCustRespDTOS = this.crmCustRepoProc.queryAllByAgentEmpId(agentEmpId);
        return ApiResult.ok(crmCustRespDTOS);
    }

    public ApiResult<List<CrmCustBaseRespVO>> queryAllByAgentEmpIdAndSub(Long agentEmpId) {
        List<SalesmanInfoDO> salesmanInfos;
        Optional salesmanInfoOptional = this.salesmanInfoRepo.findById(agentEmpId);
        if (salesmanInfoOptional.isEmpty()) {
            return ApiResult.ok();
        }
        SalesmanInfoDO salesmanInfo = (SalesmanInfoDO)((Object)salesmanInfoOptional.get());
        ApiResult apiResult = this.employeeRpcService.getUnderlingByCode(salesmanInfo.getSalesmanNo(), Boolean.TRUE, Boolean.TRUE);
        List resultData = (List)apiResult.getData();
        HashSet<String> codeList = new HashSet<String>();
        codeList.add(salesmanInfo.getSalesmanNo());
        if (!CollUtil.isEmpty((Collection)resultData)) {
            ArrayList<EmployeeUnderlingDTO> listEmp = new ArrayList<EmployeeUnderlingDTO>();
            List<EmployeeUnderlingDTO> res = this.treeToList(resultData, listEmp);
            codeList.addAll(res.stream().map(EmployeeUnderlingDTO::getCode).collect(Collectors.toList()));
        }
        if (CollectionUtils.isEmpty(salesmanInfos = this.salesmanInfoRepoProc.getSalesmanByCodes(codeList))) {
            return ApiResult.ok();
        }
        List<Long> agentEmpIds = salesmanInfos.stream().map(BaseModel::getId).collect(Collectors.toList());
        Map<Long, SalesmanInfoDO> empMap = salesmanInfos.stream().collect(Collectors.toMap(BaseModel::getId, t -> t, (t1, t2) -> t1));
        List<CrmCustBaseRespVO> list = this.crmCustRepoProc.getCustByEmpIds(agentEmpIds);
        list.forEach(l -> {
            if (!(MapUtils.isEmpty((Map)empMap) || ObjectUtils.isEmpty((Object)l.getAgentEmpId()) || ObjectUtils.isEmpty(empMap.get(l.getAgentEmpId())))) {
                l.setAgentEmpName(((SalesmanInfoDO)((Object)((Object)empMap.get(l.getAgentEmpId())))).getName());
                l.setAgentEmpCode(((SalesmanInfoDO)((Object)((Object)empMap.get(l.getAgentEmpId())))).getSalesmanNo());
            }
        });
        return ApiResult.ok(list);
    }

    public List<EmployeeUnderlingDTO> treeToList(List<EmployeeUnderlingDTO> source, List<EmployeeUnderlingDTO> obj) {
        source.stream().forEach(v -> {
            EmployeeUnderlingDTO t = new EmployeeUnderlingDTO();
            BeanUtils.copyProperties((Object)v, (Object)t);
            t.setUnderlingList(new ArrayList());
            obj.add(t);
            if (CollectionUtil.isNotEmpty((Collection)v.getUnderlingList())) {
                this.treeToList(v.getUnderlingList(), obj);
            }
        });
        return obj;
    }

    public List<CrmCustSimpleDTO> getCustByUserName(String userName) {
        CustAccountVO custAccountVO;
        if (Objects.isNull(userName)) {
            GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
            if (Objects.isNull(userDetails) || Objects.isNull(userDetails.getUser())) {
                throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            }
            SysUserDTO currentUser = userDetails.getUser();
            userName = currentUser.getUsername();
        }
        if ((custAccountVO = this.custAccountRepoProc.getAccountByUserName(userName)) != null) {
            List<CrmCustSimpleDTO> custSimpleDTOS = this.crmCustRepoProc.getCustByCode(custAccountVO.getCustCode());
            custSimpleDTOS.stream().forEach(i -> i.setBalance(custAccountVO.getBalance()));
            return custSimpleDTOS;
        }
        return new ArrayList<CrmCustSimpleDTO>();
    }

    public ApiResult<CrmCustDTO> getCustInfo(String custCode) {
        if (StringUtil.isBlank((CharSequence)custCode)) {
            return ApiResult.fail((String)"\u5ba2\u6237\u7f16\u53f7\u4e3a\u7a7a");
        }
        CrmCustDO cust = this.getByCustCode(custCode);
        if (Objects.isNull(cust)) {
            throw new BusinessException("\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        CrmCustConvert convert = CrmCustConvert.INSTANCE;
        Map<String, String> regionNameMap = this.convertUdc(null);
        Map<String, String> custTypeNameMap = this.convertUdc(null);
        CrmCustDTO custDTO = convert.do2Dto(cust);
        custDTO.setRegionName(regionNameMap.get(cust.getRegion()));
        custDTO.setCustTypeName(custTypeNameMap.get(cust.getCustType()));
        return ApiResult.ok((Object)custDTO);
    }

    public CrmCustDO getByCustCode(String custCode) {
        BooleanExpression e = this.qCrmCustDO.deleteFlag.eq((Object)0).and((Predicate)this.qCrmCustDO.custCode.eq((Object)custCode));
        Iterable iterables = this.crmCustRepo.findAll((Predicate)e);
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            return (CrmCustDO)Lists.newArrayList((Iterable)iterables).get(0);
        }
        return new CrmCustDO();
    }

    public ApiResult<BigDecimal> getCreditLimitById(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"\u67e5\u8be2\u7684\u5ba2\u6237id\u4e3a\u7a7a");
        }
        BigDecimal creditLimit = this.crmCustRepoProc.getCreditLimitById(id);
        return ApiResult.ok((Object)creditLimit);
    }

    public ApiResult<String> getStatusById(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"\u67e5\u8be2\u7684\u5ba2\u6237id\u4e3a\u7a7a");
        }
        String custStatus = this.crmCustRepoProc.getStatusById(id);
        return ApiResult.ok((Object)custStatus);
    }

    public ApiResult<List<CrmCustBaseDTO>> getBaseCustByParam(List<String> custCodes) {
        if (!CollectionUtils.isEmpty(custCodes)) {
            JPAQuery<CrmCustBaseDTO> jpaQuery = this.selectCustBase(custCodes);
            return ApiResult.ok((Object)jpaQuery.fetch());
        }
        return ApiResult.ok();
    }

    public ApiResult<List<CrmCustRespDTO>> getCustByParam(CrmCustRpcDtoParam crmCustRpcDtoParam) {
        if (crmCustRpcDtoParam == null) {
            return ApiResult.fail((String)"\u67e5\u8be2\u7684\u5ba2\u6237\u6761\u4ef6\u4e3a\u7a7a");
        }
        JPAQuery<CrmCustRespDTO> crmCustRespDTOJPAQuery = this.select(crmCustRpcDtoParam);
        List crmCustRespDTOS = crmCustRespDTOJPAQuery.fetch();
        if (!CollectionUtils.isEmpty((Collection)crmCustRpcDtoParam.getAgentEmps())) {
            List<Long> agentEmpIds = crmCustRespDTOS.stream().map(CrmCustRespDTO::getAgentEmpId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            ArrayList salesmanInfos = new ArrayList();
            if (CollectionUtils.isEmpty(agentEmpIds)) {
                agentEmpIds.forEach(a -> {
                    ApiResult<SalesmanInfoDTO> res = this.getSaleManInfo((Long)a);
                    if (res.isSuccess() && !ObjectUtils.isEmpty(res) && !ObjectUtils.isEmpty((Object)res.getData())) {
                        salesmanInfos.add((SalesmanInfoDTO)res.getData());
                    }
                });
            }
            crmCustRespDTOS.forEach(crm -> salesmanInfos.stream().filter(emp -> emp.getId().equals(crm.getAgentEmpId())).findFirst().ifPresent(empD -> crm.setAgentEmpCode(empD.getSalesmanNo())));
        }
        return ApiResult.ok((Object)crmCustRespDTOS);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(CrmCustRpcSaveDto saveDto) {
        CrmCustConvert crmCustConvert = CrmCustConvert.INSTANCE;
        CrmCustSaveVO custSaveVO = crmCustConvert.saveRpcToVO(saveDto);
        CrmCustDetailRespVO crmCustDetailRespVO = (CrmCustDetailRespVO)this.crmCustService.save(custSaveVO).getData();
        return ApiResult.ok((Object)crmCustDetailRespVO.getId());
    }

    public ApiResult<Object> judgeDependEmpAndCust(List<CrmCustJudgeDTO> crmCustJudgeDTOS) {
        crmCustJudgeDTOS.forEach(crm -> {
            CrmCustRpcDtoParam searchParam = new CrmCustRpcDtoParam();
            CrmAgentReqDTO crmAgentReqDTO = new CrmAgentReqDTO();
            crmAgentReqDTO.setAgentEmpId(crm.getAgentEmpId());
            searchParam.setAgentEmps(List.of(crmAgentReqDTO));
            JPAQuery<CrmCustRespDTO> respDTOJPAQuery = this.select(searchParam);
            List custRespDTOS = respDTOJPAQuery.fetch();
            List custCodes = custRespDTOS.stream().map(CrmCustRespDTO::getCustCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (!custCodes.contains(crm.getCustCode())) {
                throw new BusinessException("\u5ba2\u6237\u7f16\u7801\u4e3a:\u3010" + crm.getCustCode() + "\u3011\u7684\u5ba2\u6237\u4e0d\u5c5e\u4e8e,\u5458\u5de5\u7f16\u53f7\u4e3a:\u3010" + crm.getAgentEmpCode() + "\u3011\u7684\u5458\u5de5");
            }
        });
        return ApiResult.ok();
    }

    public ApiResult<List<CustBaseInfoDTO>> getCustBaseInfoByCode(CustCode2BaseParam param) {
        if (ObjectUtils.isEmpty((Object)param) && CollectionUtils.isEmpty((Collection)param.getCustCode()) && CollectionUtils.isEmpty((Collection)param.getCustCode2())) {
            return ApiResult.ok();
        }
        List<CustBaseInfoDTO> list = this.crmCustRepoProc.getCustBaseInfo(param);
        return ApiResult.ok(list);
    }

    public ApiResult<List<SalesmanLevelInfoDTO>> queryLevelInfos(List<Long> ids) {
        ArrayList list = new ArrayList();
        ids.forEach(id -> {
            SalesmanLevelInfoDTO api = this.salesmanInfoService.queryLevelInfo(id);
            list.add(api);
        });
        return ApiResult.ok(list);
    }

    public CrmCustSimpleVO getCustSimple(String userName) {
        return this.crmCustService.getCustSimple(userName);
    }

    public JPAQuery<CrmCustRespDTO> select(CrmCustRpcDtoParam searchParam) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmCustRespDTO.class, (Expression[])new Expression[]{this.qCrmCustDO.id, this.qCrmCustDO.taxRateNo, this.qCrmCustDO.taxRate, this.qCrmCustDO.region, this.qCrmCustDO.custAbbr, this.qCrmCustDO.agentEmpId, this.qCrmCustDO.ouId, this.qCrmCustDO.ouCode, this.qCrmCustDO.ouName, this.qCrmCustDO.custCode, this.qCrmCustDO.custName, this.qCrmCustDO.custType, this.qCrmCustDO.custStatus, this.qCrmCustDO.custCode2, this.qCrmCustDO.custCurr})).from((EntityPath)this.qCrmCustDO);
        if (searchParam != null) {
            jpaQuery.where(this.where(searchParam));
        }
        return jpaQuery;
    }

    public JPAQuery<CrmCustBaseDTO> selectCustBase(List<String> custCodes) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmCustBaseDTO.class, (Expression[])new Expression[]{this.qCrmCustDO.id, this.qCrmCustDO.custCode, this.qCrmCustDO.custName, this.qCrmCustDO.custAbbr})).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.custCode.in(custCodes));
        return jpaQuery;
    }

    public Predicate where(CrmCustRpcDtoParam param) {
        List agentEmpIds;
        BooleanExpression predicate = this.qCrmCustDO.isNotNull();
        if (!CollectionUtils.isEmpty((Collection)param.getCustIds())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmCustDO.id.in((Collection)param.getCustIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)param.getCustCodes())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmCustDO.custCode.in((Collection)param.getCustCodes()));
        }
        if (!CollectionUtils.isEmpty((Collection)param.getAgentEmps()) && !CollectionUtils.isEmpty(agentEmpIds = param.getAgentEmps().stream().map(CrmAgentReqDTO::getAgentEmpId).distinct().filter(Objects::nonNull).collect(Collectors.toList()))) {
            List custCodes;
            CrmCustOuParamVO crmCustOuParamVO = new CrmCustOuParamVO();
            crmCustOuParamVO.setAgentEmpIds(agentEmpIds);
            crmCustOuParamVO.setIfTrans(Boolean.valueOf(false));
            List custOuSaveVOS = this.crmCustOuService.search(crmCustOuParamVO);
            predicate = !CollectionUtils.isEmpty((Collection)custOuSaveVOS) ? (!CollectionUtils.isEmpty(custCodes = custOuSaveVOS.stream().map(CrmCustOuSaveVO::getCustCode).distinct().collect(Collectors.toList())) ? ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmCustDO.custCode.in(custCodes).or((Predicate)this.qCrmCustDO.agentEmpId.in(agentEmpIds))) : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmCustDO.agentEmpId.in(agentEmpIds))) : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmCustDO.agentEmpId.in(agentEmpIds));
        }
        return predicate;
    }
}

