/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.core.support.udc.support.SysUdcProxyService;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeeUnderlingDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.service.SaleStatisticsService;
import com.elitesland.yst.production.sale.api.service.SalesmanInfoService;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustAddrFindParam;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsStoreDtlQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsStoreQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.BaseModelVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsStoreDtlRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsStoreRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsTeamRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsStoreSumRespVO;
import com.elitesland.yst.production.sale.api.vo.save.SaleStatisticsStoreDtlSaveVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.convert.StatisticsStoreDtlConvert;
import com.elitesland.yst.production.sale.dto.SalesmanLevelInfoDTO;
import com.elitesland.yst.production.sale.entity.SaleStatisticsStoreDO;
import com.elitesland.yst.production.sale.repo.SaleStatisticsStoreDtlRepo;
import com.elitesland.yst.production.sale.repo.SaleStatisticsStoreDtlRepoProc;
import com.elitesland.yst.production.sale.repo.SaleStatisticsStoreRepo;
import com.elitesland.yst.production.sale.repo.SaleStatisticsStoreRepoProc;
import com.elitesland.yst.production.sale.repo.SaleStatisticsStoreRepoSqlProc;
import com.elitesland.yst.production.sale.rmi.ystaftersale.RmiAfterSaleRpcService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiEmployeeRpcService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SaleStatisticsServiceImpl
implements SaleStatisticsService {
    private static final Logger log = LogManager.getLogger(SaleStatisticsServiceImpl.class);
    private final SaleStatisticsStoreRepo saleStatisticsRepo;
    private final SaleStatisticsStoreDtlRepo saleStatisticsStoreDtlRepo;
    private final SaleStatisticsStoreDtlRepoProc saleStatisticsStoreDtlRepoProc;
    private final RmiAfterSaleRpcService rmiAfterSaleRpcService;
    private final SysUdcProxyService sysUdcProxyService;
    private final SaleStatisticsStoreRepoProc saleStatisticsRepoProc;
    private final SaleStatisticsStoreRepoSqlProc saleStatisticsStoreRepoSqlProc;
    private final RmiEmployeeRpcService rmiEmployeeRpcService;
    private final CrmCustService custService;
    private final SalesmanInfoService salesmanInfoService;

    public PagingVO<SaleStatisticsStoreRespVO> pcPage(SaleStatisticsStoreQueryVO paramVO) {
        PagingVO<SaleStatisticsStoreRespVO> page;
        this.assembleDocTime(paramVO);
        if (paramVO.getAgentEmp() != null) {
            SaleStatisticsStoreDtlQueryVO queryVO = new SaleStatisticsStoreDtlQueryVO();
            queryVO.setCode(paramVO.getAgentEmp());
            List<Long> longs = this.checkLevel(queryVO);
            if (CollectionUtils.isEmpty(longs)) {
                return PagingVO.builder().total(0L).records(new ArrayList()).build();
            }
            List ids = CollectionUtils.isEmpty((Collection)paramVO.getIds()) ? Collections.EMPTY_LIST : paramVO.getIds();
            List idList = Stream.of(ids, longs).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            paramVO.setIds(idList);
        }
        if (CollectionUtils.isEmpty((Collection)(page = this.saleStatisticsRepoProc.pcPage(paramVO)).getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        this.sysUdcProxyService.translate((Object)page.getRecords());
        this.translateDealer(page.getRecords());
        return page;
    }

    @SysCodeProc
    public PagingVO<SaleStatisticsStoreRespVO> appPage(SaleStatisticsStoreQueryVO paramVO) {
        PagingVO<SaleStatisticsStoreRespVO> page;
        this.assembleDocTime(paramVO);
        if (StringUtils.isBlank((CharSequence)paramVO.getAgentEmp())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e1a\u52a1\u5458\u7f16\u7801\u4e3a\u7a7a!");
        }
        if (!this.checkOneselfAndSub(paramVO.getAgentEmp())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        if (paramVO.getAgentEmp() != null) {
            SaleStatisticsStoreDtlQueryVO queryVO = new SaleStatisticsStoreDtlQueryVO();
            if (Objects.isNull(paramVO.getSeeSelf())) {
                paramVO.setSeeSelf(Boolean.valueOf(true));
            }
            if (paramVO.getSeeSelf().booleanValue()) {
                queryVO.setLevel("0");
            }
            queryVO.setCode(paramVO.getAgentEmp());
            List<Long> longs = this.queryDtl(queryVO);
            if (CollectionUtils.isEmpty(longs)) {
                return PagingVO.builder().total(0L).records(new ArrayList()).build();
            }
            List ids = CollectionUtils.isEmpty((Collection)paramVO.getIds()) ? Collections.EMPTY_LIST : paramVO.getIds();
            List idList = Stream.of(ids, longs).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            paramVO.setIds(idList);
        }
        if (CollectionUtils.isEmpty((Collection)(page = this.saleStatisticsRepoProc.appPage(paramVO)).getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        this.sysUdcProxyService.translate((Object)page.getRecords());
        this.translateDealer(page.getRecords());
        return page;
    }

    public List<SaleStatisticsStoreRespVO> detail(SaleStatisticsStoreQueryVO paramVO) {
        this.checkDetail(paramVO);
        if (StringUtils.isNotEmpty((CharSequence)paramVO.getAgentEmp())) {
            SaleStatisticsStoreDtlQueryVO queryVO = new SaleStatisticsStoreDtlQueryVO();
            if (Objects.isNull(paramVO.getSeeSelf())) {
                paramVO.setSeeSelf(Boolean.valueOf(true));
            }
            if (paramVO.getSeeSelf().booleanValue()) {
                queryVO.setLevel("0");
            }
            queryVO.setCode(paramVO.getAgentEmp());
            List<Long> longs = this.queryDtl(queryVO);
            if (CollectionUtils.isEmpty(longs)) {
                return null;
            }
            paramVO.setIds(longs);
        } else {
            paramVO.setSalesmanPath(null);
        }
        List<SaleStatisticsStoreRespVO> query = this.saleStatisticsRepoProc.query(paramVO);
        this.translateDealer(query);
        this.sysUdcProxyService.translate(query);
        return query;
    }

    public StatisticsStoreSumRespVO querySum(SaleStatisticsStoreQueryVO paramVO) {
        this.assembleDocTime(paramVO);
        if (paramVO.getAgentEmp() != null) {
            SaleStatisticsStoreDtlQueryVO queryVO = new SaleStatisticsStoreDtlQueryVO();
            queryVO.setCode(paramVO.getAgentEmp());
            List<Long> longs = this.checkLevel(queryVO);
            if (CollectionUtils.isEmpty(longs)) {
                return null;
            }
            List ids = CollectionUtils.isEmpty((Collection)paramVO.getIds()) ? Collections.EMPTY_LIST : paramVO.getIds();
            List idList = Stream.of(ids, longs).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            paramVO.setIds(idList);
        }
        StatisticsStoreSumRespVO statisticsStoreSumRespVO = this.saleStatisticsStoreRepoSqlProc.pageSum(paramVO);
        return statisticsStoreSumRespVO;
    }

    public List<String> storeQuery(SaleStatisticsStoreQueryVO paramVO) {
        this.assembleDocTime(paramVO);
        if (paramVO.getAgentEmp() != null) {
            SaleStatisticsStoreDtlQueryVO queryVO = new SaleStatisticsStoreDtlQueryVO();
            queryVO.setCode(paramVO.getAgentEmp());
            List<Long> longs = this.checkLevel(queryVO);
            if (CollectionUtils.isEmpty(longs)) {
                return new ArrayList<String>();
            }
            List ids = CollectionUtils.isEmpty((Collection)paramVO.getIds()) ? Collections.EMPTY_LIST : paramVO.getIds();
            List idList = Stream.of(ids, longs).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            paramVO.setIds(idList);
        }
        return this.saleStatisticsRepoProc.storeQuery(paramVO).stream().distinct().map(SaleStatisticsStoreRespVO::getStoreCode).collect(Collectors.toList());
    }

    public StatisticsStoreSumRespVO appQerySum(SaleStatisticsStoreQueryVO paramVO) {
        this.assembleDocTime(paramVO);
        if (StringUtils.isBlank((CharSequence)paramVO.getAgentEmp())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e1a\u52a1\u5458\u7f16\u7801\u4e3a\u7a7a!");
        }
        if (!this.checkOneselfAndSub(paramVO.getAgentEmp())) {
            return null;
        }
        if (paramVO.getAgentEmp() != null) {
            SaleStatisticsStoreDtlQueryVO queryVO = new SaleStatisticsStoreDtlQueryVO();
            if (Objects.isNull(paramVO.getSeeSelf())) {
                paramVO.setSeeSelf(Boolean.valueOf(true));
            }
            if (paramVO.getSeeSelf().booleanValue()) {
                queryVO.setLevel("0");
            }
            queryVO.setCode(paramVO.getAgentEmp());
            List<Long> longs = this.queryDtl(queryVO);
            if (CollectionUtils.isEmpty(longs)) {
                return null;
            }
            List ids = CollectionUtils.isEmpty((Collection)paramVO.getIds()) ? Collections.EMPTY_LIST : paramVO.getIds();
            List idList = Stream.of(ids, longs).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            paramVO.setIds(idList);
        }
        StatisticsStoreSumRespVO statisticsStoreSumRespVO = this.saleStatisticsStoreRepoSqlProc.pageSum(paramVO);
        return statisticsStoreSumRespVO;
    }

    public List<SaleStatisticsTeamRespVO> queryByCodes(SaleStatisticsStoreQueryVO paramVO) {
        List empCodes = paramVO.getAgentEmpList();
        String docMonth = paramVO.getDocMonth();
        if (CollectionUtils.isEmpty((Collection)empCodes)) {
            return Collections.EMPTY_LIST;
        }
        if (paramVO.getDocTimeStart() != null) {
            paramVO.setDocTimeStart(LocalDateTime.of(paramVO.getDocTimeStart().toLocalDate(), LocalTime.MIN));
        }
        if (paramVO.getDocTimeEnd() != null) {
            paramVO.setDocTimeEnd(LocalDateTime.of(paramVO.getDocTimeEnd().toLocalDate(), ConstantsSale.LOCAL_TIME_MAX));
        }
        if (paramVO.getDocTimeStart() == null && paramVO.getDocTimeEnd() == null && StringUtils.isBlank((CharSequence)docMonth)) {
            paramVO.setDocTimeStart(LocalDateTime.of(LocalDate.now(), LocalTime.MIN));
            paramVO.setDocTimeEnd(LocalDateTime.of(LocalDate.now(), ConstantsSale.LOCAL_TIME_MAX));
        }
        SaleStatisticsStoreDtlQueryVO queryVO = new SaleStatisticsStoreDtlQueryVO();
        queryVO.setCodes(empCodes);
        queryVO.setDocMonth(docMonth);
        queryVO.setDocTimeStart(paramVO.getDocTimeStart());
        queryVO.setDocTimeEnd(paramVO.getDocTimeEnd());
        queryVO.setLevel("0");
        List<SaleStatisticsTeamRespVO> listByCodes = this.getListByCodes(queryVO);
        SaleStatisticsStoreDtlQueryVO teamVO = new SaleStatisticsStoreDtlQueryVO();
        teamVO.setCodes(empCodes);
        teamVO.setDocMonth(docMonth);
        teamVO.setDocTimeStart(paramVO.getDocTimeStart());
        teamVO.setDocTimeEnd(paramVO.getDocTimeEnd());
        List<SaleStatisticsTeamRespVO> teamRespVOS = this.getListByCodes(teamVO);
        ArrayList<SaleStatisticsTeamRespVO> respVOList = new ArrayList<SaleStatisticsTeamRespVO>();
        for (String code : empCodes) {
            Optional<SaleStatisticsTeamRespVO> teamOptional;
            SaleStatisticsTeamRespVO appSumRespVO = new SaleStatisticsTeamRespVO();
            appSumRespVO.setAgentEmp(code);
            appSumRespVO.setTeamPerformance(BigDecimal.ZERO);
            appSumRespVO.setPersonalPerformance(BigDecimal.ZERO);
            Optional<SaleStatisticsTeamRespVO> myOptional = listByCodes.stream().filter(respVO -> Objects.equals(respVO.getAgentEmp(), code)).findFirst();
            if (myOptional.isPresent()) {
                appSumRespVO.setPersonalPerformance(myOptional.get().getShipTotalQty());
            }
            if ((teamOptional = teamRespVOS.stream().filter(respVO -> Objects.equals(respVO.getAgentEmp(), code)).findFirst()).isPresent()) {
                appSumRespVO.setTeamPerformance(teamOptional.get().getShipTotalQty());
            }
            respVOList.add(appSumRespVO);
        }
        return respVOList;
    }

    public PagingVO<SaleStatisticsStoreRespVO> leaderPage(SaleStatisticsStoreQueryVO paramVO) {
        PagingVO<SaleStatisticsStoreRespVO> page;
        this.assembleDocTime(paramVO);
        if (StringUtils.isBlank((CharSequence)paramVO.getAgentEmp())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e1a\u52a1\u5458\u7f16\u7801\u4e3a\u7a7a!");
        }
        if (paramVO.getAgentEmp() != null) {
            SaleStatisticsStoreDtlQueryVO queryVO = new SaleStatisticsStoreDtlQueryVO();
            if (Objects.isNull(paramVO.getSeeSelf())) {
                paramVO.setSeeSelf(Boolean.valueOf(true));
            }
            if (paramVO.getSeeSelf().booleanValue()) {
                queryVO.setLevel("0");
            }
            queryVO.setCode(paramVO.getAgentEmp());
            List<Long> longs = this.queryDtl(queryVO);
            if (CollectionUtils.isEmpty(longs)) {
                return PagingVO.builder().total(0L).records(new ArrayList()).build();
            }
            List ids = CollectionUtils.isEmpty((Collection)paramVO.getIds()) ? Collections.EMPTY_LIST : paramVO.getIds();
            List idList = Stream.of(ids, longs).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            paramVO.setIds(idList);
        }
        if (CollectionUtils.isEmpty((Collection)(page = this.saleStatisticsRepoProc.appPage(paramVO)).getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        this.sysUdcProxyService.translate((Object)page.getRecords());
        this.translateDealer(page.getRecords());
        return page;
    }

    public StatisticsStoreSumRespVO leaderPageSum(SaleStatisticsStoreQueryVO paramVO) {
        this.assembleDocTime(paramVO);
        if (StringUtils.isBlank((CharSequence)paramVO.getAgentEmp())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e1a\u52a1\u5458\u7f16\u7801\u4e3a\u7a7a!");
        }
        if (paramVO.getAgentEmp() != null) {
            SaleStatisticsStoreDtlQueryVO queryVO = new SaleStatisticsStoreDtlQueryVO();
            if (Objects.isNull(paramVO.getSeeSelf())) {
                paramVO.setSeeSelf(Boolean.valueOf(true));
            }
            if (paramVO.getSeeSelf().booleanValue()) {
                queryVO.setLevel("0");
            }
            queryVO.setCode(paramVO.getAgentEmp());
            List<Long> longs = this.queryDtl(queryVO);
            if (CollectionUtils.isEmpty(longs)) {
                return null;
            }
            List ids = CollectionUtils.isEmpty((Collection)paramVO.getIds()) ? Collections.EMPTY_LIST : paramVO.getIds();
            List idList = Stream.of(ids, longs).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            paramVO.setIds(idList);
        }
        StatisticsStoreSumRespVO statisticsStoreSumRespVO = this.saleStatisticsStoreRepoSqlProc.pageSum(paramVO);
        return statisticsStoreSumRespVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public Object updateRegion(List<Long> ids) {
        Assert.notEmpty(ids, (String)"\u5165\u53c2\u6570\u636e\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ArrayList dtlDOList = new ArrayList();
        List<SaleStatisticsStoreRespVO> list = this.queryLisl(ids);
        Assert.notEmpty(list, (String)"\u672a\u67e5\u8be2\u5230\u6709\u6548\u6570\u636e\uff01", (Object[])new Object[0]);
        log.info("updateRegion\u67e5\u8be2\u6570\u636e\uff1a" + list);
        List collect = list.stream().map(SaleStatisticsStoreRespVO::getDealerCode).filter(Objects::nonNull).collect(Collectors.toList());
        Assert.notEmpty(collect, (String)"\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        CustAddrFindParam custAddrFindParam = new CustAddrFindParam();
        custAddrFindParam.setCustCodes(collect);
        List custInfoByParam = this.custService.getCustInfoByParam(custAddrFindParam);
        log.info("updateRegion\u67e5\u8be2\u5ba2\u6237\u6570\u636e\uff1a" + custInfoByParam);
        list.stream().forEach(t -> {
            SaleStatisticsStoreQueryVO saleStatisticsStoreQueryVO = new SaleStatisticsStoreQueryVO();
            saleStatisticsStoreQueryVO.setStoreCode(t.getStoreCode());
            saleStatisticsStoreQueryVO.setDealerCode(t.getDealerCode());
            saleStatisticsStoreQueryVO.setSalesmanPath(t.getSalesmanPath());
            saleStatisticsStoreQueryVO.setDocTime(t.getDocTime());
            Iterable storeDOIterable = this.saleStatisticsRepo.findAll(this.saleStatisticsRepoProc.querySumDetailWhere(saleStatisticsStoreQueryVO));
            List<SaleStatisticsStoreDO> saleStatisticsStoreDOSList = StreamSupport.stream(storeDOIterable.spliterator(), false).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(saleStatisticsStoreDOSList)) {
                this.assembleStatisticsStoreRegion(saleStatisticsStoreDOSList, custInfoByParam);
                dtlDOList.addAll(saleStatisticsStoreDOSList);
            }
        });
        log.info("updateRegion\u4fdd\u5b58\u6570\u636e\uff1a" + dtlDOList);
        if (!CollectionUtils.isEmpty(dtlDOList)) {
            this.saleStatisticsRepo.saveAll(dtlDOList);
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public Object updateSalesman(List<Long> ids) {
        Assert.notEmpty(ids, (String)"\u5165\u53c2\u6570\u636e\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ArrayList<SaleStatisticsStoreDO> storeDOList = new ArrayList<SaleStatisticsStoreDO>();
        HashMap custCodeAndAgentEmpMap = new HashMap();
        List<SaleStatisticsStoreRespVO> list = this.queryLisl(ids);
        Assert.notEmpty(list, (String)"\u672a\u67e5\u8be2\u5230\u6709\u6548\u6570\u636e\uff01", (Object[])new Object[0]);
        log.info("\u67e5\u8be2\u6570\u636e\uff1a" + list);
        List collect = list.stream().map(SaleStatisticsStoreRespVO::getDealerCode).filter(Objects::nonNull).collect(Collectors.toList());
        Assert.notEmpty(collect, (String)"\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        CustAddrFindParam custAddrFindParam = new CustAddrFindParam();
        custAddrFindParam.setCustCodes(collect);
        List custInfoByParam = this.custService.getCustInfoByParam(custAddrFindParam);
        Assert.notEmpty((Iterable)custInfoByParam, (String)"\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        log.info("\u5ba2\u6237\u6570\u636e\uff1a" + custInfoByParam);
        custInfoByParam.stream().forEach(t -> custCodeAndAgentEmpMap.put(t.getCustCode(), t.getAgentEmpId()));
        List<SalesmanLevelInfoDTO> salesmanLevelInfoDTOS = this.selectSalesmanLevelByIds(custInfoByParam);
        log.info("\u4e1a\u52a1\u5458\u6570\u636e\uff1a" + salesmanLevelInfoDTOS);
        list.stream().forEach(t -> {
            SaleStatisticsStoreQueryVO saleStatisticsStoreQueryVO = new SaleStatisticsStoreQueryVO();
            saleStatisticsStoreQueryVO.setRegion(t.getRegion());
            saleStatisticsStoreQueryVO.setStoreCode(t.getStoreCode());
            saleStatisticsStoreQueryVO.setDealerCode(t.getDealerCode());
            saleStatisticsStoreQueryVO.setDocTime(t.getDocTime());
            Iterable storeDOIterable = this.saleStatisticsRepo.findAll(this.saleStatisticsRepoProc.querySumDetailWhere(saleStatisticsStoreQueryVO));
            List<SaleStatisticsStoreDO> saleStatisticsStoreDOSList = StreamSupport.stream(storeDOIterable.spliterator(), false).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(saleStatisticsStoreDOSList)) {
                this.assembleStatisticsStoreSalesman(saleStatisticsStoreDOSList, custInfoByParam, custCodeAndAgentEmpMap, salesmanLevelInfoDTOS);
                storeDOList.addAll(saleStatisticsStoreDOSList);
            }
        });
        log.info("updateSalesman\u4fdd\u5b58\u6570\u636e\uff1a" + storeDOList);
        if (!CollectionUtils.isEmpty(storeDOList)) {
            List collect1 = this.saleStatisticsRepo.saveAll(storeDOList).stream().map(BaseModel::getId).collect(Collectors.toList());
            this.saveSaleStatisticsStoreDtl(storeDOList);
            return collect1;
        }
        return null;
    }

    public void saveSaleStatisticsStoreDtl(List<SaleStatisticsStoreDO> storeDOList) {
        ArrayList dealerDtlSaveVOList = new ArrayList();
        List collect = storeDOList.stream().map(BaseModel::getId).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            this.saleStatisticsStoreDtlRepo.deleteByMasIdIn(storeDOList.stream().map(BaseModel::getId).distinct().collect(Collectors.toList()));
        }
        storeDOList.forEach(saveVO -> {
            List dtlSaveVOList;
            if (Objects.nonNull(saveVO.getSalesmanPath()) && !CollectionUtils.isEmpty((Collection)(dtlSaveVOList = JSONObject.parseArray((String)saveVO.getSalesmanPath(), SaleStatisticsStoreDtlSaveVO.class)))) {
                dtlSaveVOList.forEach(dtlSaveVO -> dtlSaveVO.setMasId(saveVO.getId()));
                dealerDtlSaveVOList.addAll(dtlSaveVOList);
            }
        });
        if (!CollectionUtils.isEmpty(dealerDtlSaveVOList)) {
            Set<String> employeeCodes = dealerDtlSaveVOList.stream().map(SaleStatisticsStoreDtlSaveVO::getCode).filter(Objects::nonNull).collect(Collectors.toSet());
            List<SysEmployeeBasicDTO> basicDTOList = this.rmiEmployeeRpcService.findEmployeeByCodes(employeeCodes);
            dealerDtlSaveVOList.forEach(saveVO -> {
                Optional<SysEmployeeBasicDTO> optional = basicDTOList.stream().filter(employeeBasicDTO -> Objects.equals(saveVO.getCode(), employeeBasicDTO.getCode())).findFirst();
                optional.ifPresent(employeeBasicDTO -> saveVO.setUserId(employeeBasicDTO.getUserId()));
            });
            List dtlDOList = dealerDtlSaveVOList.stream().map(StatisticsStoreDtlConvert.INSTANCE::saveVoToDo).collect(Collectors.toList());
            this.saleStatisticsStoreDtlRepo.saveAll(dtlDOList);
        }
    }

    public List<SaleStatisticsStoreRespVO> queryLisl(List<Long> ids) {
        SaleStatisticsStoreQueryVO saleStatisticsStoreQueryVO = new SaleStatisticsStoreQueryVO();
        saleStatisticsStoreQueryVO.setIds(ids);
        List<SaleStatisticsStoreRespVO> list = this.saleStatisticsRepoProc.getList(saleStatisticsStoreQueryVO);
        return list;
    }

    public void assembleStatisticsStoreRegion(List<SaleStatisticsStoreDO> saleStatisticsStoreDOSList, List<LmSaveCustRespVO> custInfoByParam) {
        saleStatisticsStoreDOSList.stream().forEach(t -> {
            t.setUpdateRegionFailureReason(null);
            if (CollectionUtils.isEmpty((Collection)custInfoByParam)) {
                t.setUpdateRegionFailureReason("\u6ca1\u6709\u67e5\u8be2\u5230\u5ba2\u6237\u4fe1\u606f");
            } else {
                Optional<LmSaveCustRespVO> first = custInfoByParam.stream().filter(cust -> t.getDealerCode().equals(cust.getCustCode())).findFirst();
                if (first.isPresent()) {
                    if (StringUtils.isBlank((CharSequence)first.get().getRegion())) {
                        t.setUpdateRegionFailureReason("\u6b64\u5ba2\u6237\u7684\u533a\u57df\u4fe1\u606f\u4e3a\u7a7a");
                    } else {
                        t.setRegion(first.get().getRegion());
                    }
                } else {
                    t.setUpdateRegionFailureReason("\u6b64\u5ba2\u6237\u6ca1\u6709\u533a\u57df\u4fe1\u606f");
                }
            }
        });
    }

    public void assembleStatisticsStoreSalesman(List<SaleStatisticsStoreDO> saleStatisticsStoreDOSList, List<LmSaveCustRespVO> custInfoByParam, Map<String, Long> custCodeAndAgentEmpMap, List<SalesmanLevelInfoDTO> salesmanLevelInfoDTOS) {
        saleStatisticsStoreDOSList.stream().forEach(saleStatisticsStoreDO -> {
            saleStatisticsStoreDO.setUpdateSalesmanFailureReason(null);
            if (CollectionUtils.isEmpty((Collection)custInfoByParam)) {
                saleStatisticsStoreDO.setUpdateSalesmanFailureReason("\u672a\u67e5\u8be2\u5230\u5ba2\u6237\u6570\u636e");
            } else {
                Optional<LmSaveCustRespVO> custOptional = custInfoByParam.stream().filter(custRespVO -> Objects.equals(saleStatisticsStoreDO.getDealerCode(), custRespVO.getCustCode())).findFirst();
                if (custOptional.isPresent()) {
                    if (CollectionUtils.isEmpty((Map)custCodeAndAgentEmpMap) || Objects.isNull(custCodeAndAgentEmpMap.get(custOptional.get().getCustCode()))) {
                        saleStatisticsStoreDO.setUpdateSalesmanFailureReason("\u6b64\u5ba2\u6237\u7684\u4e1a\u52a1\u5458ID\u4fe1\u606f\u4e3a\u7a7a");
                    } else if (CollectionUtils.isEmpty((Collection)salesmanLevelInfoDTOS)) {
                        saleStatisticsStoreDO.setUpdateSalesmanFailureReason("\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u5458\u6570\u636e");
                    } else {
                        Long agentEmpId = (Long)custCodeAndAgentEmpMap.get(custOptional.get().getCustCode());
                        Optional<SalesmanLevelInfoDTO> salesmanOptional = salesmanLevelInfoDTOS.stream().filter(salesmanLevelInfo -> Objects.equals(agentEmpId, salesmanLevelInfo.getId())).findFirst();
                        if (salesmanOptional.isPresent()) {
                            if (CollectionUtils.isEmpty((Collection)salesmanOptional.get().getSalesman_path())) {
                                saleStatisticsStoreDO.setUpdateSalesmanFailureReason("\u6b64\u5ba2\u6237\u7684\u4e1a\u52a1\u5458\u7684\u4e1a\u52a1\u5458\u8def\u5f84\u4fe1\u606f\u4e3a\u7a7a");
                            } else {
                                saleStatisticsStoreDO.setSalesmanPath(JSON.toJSONString((Object)salesmanOptional.get().getSalesman_path()));
                            }
                        } else {
                            saleStatisticsStoreDO.setUpdateSalesmanFailureReason("\u672a\u67e5\u8be2\u5230\u6b64\u5ba2\u6237\u7684\u4e1a\u52a1\u5458\u4e3b\u4fe1\u606f");
                        }
                    }
                } else {
                    saleStatisticsStoreDO.setUpdateSalesmanFailureReason("\u5ba2\u6237\u63a5\u53e3\u65e0\u6b64\u4e1a\u52a1\u5458\u4fe1\u606f");
                }
            }
        });
    }

    private List<SalesmanLevelInfoDTO> selectSalesmanLevelByIds(List<LmSaveCustRespVO> custRespVOList) {
        if (CollectionUtils.isEmpty(custRespVOList)) {
            return Collections.EMPTY_LIST;
        }
        List agentEmpIds = custRespVOList.stream().map(LmSaveCustRespVO::getAgentEmpId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(agentEmpIds)) {
            return Collections.EMPTY_LIST;
        }
        List<SalesmanLevelInfoDTO> salesmanLevelInfoDTOList = agentEmpIds.stream().map(t -> this.salesmanInfoService.queryLevelInfo(t)).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(salesmanLevelInfoDTOList)) {
            return Collections.EMPTY_LIST;
        }
        return salesmanLevelInfoDTOList;
    }

    public List<SaleStatisticsTeamRespVO> getListByCodes(SaleStatisticsStoreDtlQueryVO queryVO) {
        List<SaleStatisticsTeamRespVO> listByCodes = this.saleStatisticsStoreDtlRepoProc.getListByCodes(queryVO);
        if (CollectionUtils.isEmpty(listByCodes)) {
            return Collections.EMPTY_LIST;
        }
        return listByCodes;
    }

    public void assembleDocTime(SaleStatisticsStoreQueryVO pageParam) {
        if (Objects.isNull(pageParam.getDocTimeStart()) || Objects.isNull(pageParam.getDocTimeEnd())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7edf\u8ba1\u65e5\u671f\u4e3a\u7a7a!");
        }
        if (Objects.nonNull(pageParam.getDocTimeStart())) {
            LocalDate localDateStart = pageParam.getDocTimeStart().toLocalDate();
            LocalDateTime minTime = LocalDateTime.of(localDateStart, LocalTime.MIN);
            pageParam.setDocTimeStart(minTime);
        }
        if (Objects.nonNull(pageParam.getDocTimeEnd())) {
            LocalDate localDateEnd = pageParam.getDocTimeEnd().toLocalDate();
            LocalDateTime maxTime = LocalDateTime.of(localDateEnd, ConstantsSale.LOCAL_TIME_MAX);
            pageParam.setDocTimeEnd(maxTime);
        }
    }

    public void checkDetail(SaleStatisticsStoreQueryVO paramVO) {
        if (Objects.isNull(paramVO.getDocTimeStart()) || Objects.isNull(paramVO.getDocTimeEnd())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7edf\u8ba1\u65f6\u95f4\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)paramVO.getStoreCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)paramVO.getDealerCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)paramVO.getAgentEmp())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e1a\u52a1\u5458\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public List<Long> checkLevel(SaleStatisticsStoreDtlQueryVO queryVO) {
        List<SaleStatisticsStoreDtlRespVO> levelList = this.saleStatisticsStoreDtlRepoProc.getQueryDtl(queryVO);
        if (CollectionUtils.isEmpty(levelList)) {
            return null;
        }
        return levelList.stream().distinct().map(SaleStatisticsStoreDtlRespVO::getMasId).collect(Collectors.toList());
    }

    public List<Long> queryDtl(SaleStatisticsStoreDtlQueryVO queryVO) {
        List<SaleStatisticsStoreDtlRespVO> levelList = this.saleStatisticsStoreDtlRepoProc.getLevelList(queryVO);
        if (CollectionUtils.isEmpty(levelList)) {
            return null;
        }
        return levelList.stream().distinct().map(SaleStatisticsStoreDtlRespVO::getMasId).collect(Collectors.toList());
    }

    private void translateDealer(List<SaleStatisticsStoreRespVO> respVOList) {
        List<Long> collect = respVOList.stream().map(BaseModelVO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<SaleStatisticsStoreDtlRespVO> dtlRespVOList = this.saleStatisticsStoreDtlRepoProc.getMasIds(collect);
        respVOList.forEach(respVO -> {
            List dtlRespVOS = dtlRespVOList.stream().filter(dtlRespVO -> Objects.equals(dtlRespVO.getMasId(), respVO.getId())).collect(Collectors.toList());
            respVO.setDtlRespVOS(dtlRespVOS);
            String docMonth = respVO.getDocTime().format(DateTimeFormatter.ofPattern("yyyy-MM"));
            respVO.setDocMonth(docMonth);
            this.sysUdcProxyService.translate(dtlRespVOS);
            dtlRespVOS.stream().forEach(dtlRespVO -> {
                StringJoiner spliceName = new StringJoiner(" ").add(dtlRespVO.getTypeName()).add(dtlRespVO.getName());
                if (Objects.equals("0", dtlRespVO.getLevel())) {
                    respVO.setAgentEmp(dtlRespVO.getCode());
                    respVO.setAgentEmpName(spliceName.toString());
                } else if (Objects.equals("1", dtlRespVO.getLevel())) {
                    respVO.setLevelOne(spliceName.toString());
                } else if (Objects.equals("2", dtlRespVO.getLevel())) {
                    respVO.setLevelTwo(spliceName.toString());
                } else if (Objects.equals("3", dtlRespVO.getLevel())) {
                    respVO.setLevelThree(spliceName.toString());
                } else if (Objects.equals("4", dtlRespVO.getLevel())) {
                    respVO.setLevelFour(spliceName.toString());
                } else if (Objects.equals("5", dtlRespVO.getLevel())) {
                    respVO.setLevelFive(spliceName.toString());
                }
            });
        });
    }

    private boolean checkOneselfAndSub(String agentEmp) {
        SysUserDTO sysUserDTO = this.getSysUser();
        SysEmployeeBasicDTO employeeBasicDTO = this.getEmployeeByUser(sysUserDTO);
        List<String> subEmployeeCodeList = this.queryAllSubEmployeeByCode(employeeBasicDTO.getCode());
        if (CollectionUtils.isEmpty(subEmployeeCodeList)) {
            return false;
        }
        return subEmployeeCodeList.contains(agentEmp);
    }

    private SysUserDTO getSysUser() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (Objects.isNull(userDetails) || Objects.isNull(userDetails.getUser())) {
            throw new BusinessException(ApiCode.UNAUTHORIZED, "\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        SysUserDTO sysUser = userDetails.getUser();
        if (ObjectUtils.isEmpty((Object)sysUser)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7528\u6237\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
        }
        return sysUser;
    }

    private SysEmployeeBasicDTO getEmployeeByUser(SysUserDTO sysUserDTO) {
        if (Objects.isNull(sysUserDTO)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a!");
        }
        SysEmployeeBasicDTO employeeBasicDTO = this.rmiEmployeeRpcService.findEmployeeByUserId(sysUserDTO.getId());
        if (Objects.isNull(employeeBasicDTO)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u6240\u5c5e\u5458\u5de5\u4fe1\u606f\u4e3a\u7a7a!");
        }
        return employeeBasicDTO;
    }

    private List<String> queryAllSubEmployeeByCode(String salesmanNo) {
        HashSet<String> codeList = new HashSet<String>();
        codeList.add(salesmanNo);
        List<EmployeeUnderlingDTO> resultData = this.rmiEmployeeRpcService.getUnderlingByCode(salesmanNo, Boolean.TRUE, Boolean.TRUE);
        if (CollectionUtils.isEmpty(resultData)) {
            return codeList.stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(resultData)) {
            ArrayList<EmployeeUnderlingDTO> listEmp = new ArrayList<EmployeeUnderlingDTO>();
            List<EmployeeUnderlingDTO> res = this.queryAllSubTreeToList(resultData, listEmp);
            codeList.addAll(res.stream().map(EmployeeUnderlingDTO::getCode).collect(Collectors.toList()));
        }
        return codeList.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<EmployeeUnderlingDTO> queryAllSubTreeToList(List<EmployeeUnderlingDTO> source, List<EmployeeUnderlingDTO> obj) {
        source.stream().forEach(v -> {
            EmployeeUnderlingDTO t = new EmployeeUnderlingDTO();
            BeanUtils.copyProperties((Object)v, (Object)t);
            t.setUnderlingList(new ArrayList());
            obj.add(t);
            if (CollectionUtil.isNotEmpty((Collection)v.getUnderlingList())) {
                this.queryAllSubTreeToList(v.getUnderlingList(), obj);
            }
        });
        return obj;
    }

    public SaleStatisticsServiceImpl(SaleStatisticsStoreRepo saleStatisticsRepo, SaleStatisticsStoreDtlRepo saleStatisticsStoreDtlRepo, SaleStatisticsStoreDtlRepoProc saleStatisticsStoreDtlRepoProc, RmiAfterSaleRpcService rmiAfterSaleRpcService, SysUdcProxyService sysUdcProxyService, SaleStatisticsStoreRepoProc saleStatisticsRepoProc, SaleStatisticsStoreRepoSqlProc saleStatisticsStoreRepoSqlProc, RmiEmployeeRpcService rmiEmployeeRpcService, CrmCustService custService, SalesmanInfoService salesmanInfoService) {
        this.saleStatisticsRepo = saleStatisticsRepo;
        this.saleStatisticsStoreDtlRepo = saleStatisticsStoreDtlRepo;
        this.saleStatisticsStoreDtlRepoProc = saleStatisticsStoreDtlRepoProc;
        this.rmiAfterSaleRpcService = rmiAfterSaleRpcService;
        this.sysUdcProxyService = sysUdcProxyService;
        this.saleStatisticsRepoProc = saleStatisticsRepoProc;
        this.saleStatisticsStoreRepoSqlProc = saleStatisticsStoreRepoSqlProc;
        this.rmiEmployeeRpcService = rmiEmployeeRpcService;
        this.custService = custService;
        this.salesmanInfoService = salesmanInfoService;
    }
}

