/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.service.ExectRecordService;
import com.elitesland.yst.production.sale.api.service.ExectRecordTempService;
import com.elitesland.yst.production.sale.api.service.TaskInfoDtlService;
import com.elitesland.yst.production.sale.api.service.TaskInfoService;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.FileInfoQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.TaskInfoDtlQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.TaskInfoQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.BaseModelVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.ExectRecordTempRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.FileInfoRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoDtlRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoExportRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoRespVO;
import com.elitesland.yst.production.sale.api.vo.save.FileInfoSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.TaskInfoDtlSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.TaskInfoSaveVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.FileinfoConvert;
import com.elitesland.yst.production.sale.convert.TaskInfoConvert;
import com.elitesland.yst.production.sale.convert.TaskInfoDtlConvert;
import com.elitesland.yst.production.sale.entity.FileInfoDO;
import com.elitesland.yst.production.sale.entity.SalesmanInfoDO;
import com.elitesland.yst.production.sale.entity.SalesmanRegionDO;
import com.elitesland.yst.production.sale.entity.TaskInfoDO;
import com.elitesland.yst.production.sale.repo.FileInfoRepo;
import com.elitesland.yst.production.sale.repo.FileInfoRepoProc;
import com.elitesland.yst.production.sale.repo.SalesmanInfoRepo;
import com.elitesland.yst.production.sale.repo.SalesmanRegionRepo;
import com.elitesland.yst.production.sale.repo.TaskInfoRepo;
import com.elitesland.yst.production.sale.repo.TaskInfoRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgStoreRpcService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiEmployeeRpcService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysAreaRpcService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiUdcService;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskInfoServiceImpl
implements TaskInfoService {
    private static final Logger log = LoggerFactory.getLogger(TaskInfoServiceImpl.class);
    @Autowired
    private TaskInfoRepo taskInfoRepo;
    @Autowired
    private TaskInfoRepoProc taskInfoRepoProc;
    @Autowired
    private TaskInfoDtlService taskInfoDtlService;
    @Autowired
    private RmiSysNextNumberService rmiSysNextNumberService;
    @Autowired
    private RmiOrgOuService rmiOrgOuService;
    @Autowired
    private RmiUdcService rmiUdcService;
    @Autowired
    private RmiEmployeeRpcService rmiEmployeeRpcService;
    @Autowired
    private RmiOrgStoreRpcService rmiOrgStoreRpcService;
    @Autowired
    private RmiSysAreaRpcService rmiSysAreaRpcService;
    @Autowired
    private CrmCustService crmCustService;
    @Autowired
    private FileInfoRepoProc fileInfoRepoProc;
    @Autowired
    private FileInfoRepo fileInfoRepo;
    @Autowired
    private SalesmanInfoRepo salesmanInfoRepo;
    @Autowired
    private SalesmanRegionRepo salesmanRegionRepo;
    private ExectRecordService exectRecordService;
    private ExectRecordTempService exectRecordTempService;

    @Autowired
    @Lazy
    public void setExectRecordService(ExectRecordService exectRecordService) {
        this.exectRecordService = exectRecordService;
    }

    @Autowired
    @Lazy
    public void setExectRecordTempService(ExectRecordTempService exectRecordTempService) {
        this.exectRecordTempService = exectRecordTempService;
    }

    @Transactional(rollbackFor={Exception.class})
    public TaskInfoRespVO createTask(TaskInfoSaveVO saveVO) {
        List dtlSaveVOList = saveVO.getDtlSaveVOList();
        this.checkMandatoryField(saveVO);
        this.checkMandatoryFieldDtlList(dtlSaveVOList);
        this.checkRepeatSet(saveVO);
        this.saveDefaultValue(true, saveVO, null);
        Long id = this.saveTaskInfo(saveVO);
        saveVO.setId(id);
        this.repeatSetSave(saveVO);
        this.saveDtlDefaultValue(dtlSaveVOList, saveVO);
        if (CollectionUtils.isNotEmpty((Collection)dtlSaveVOList)) {
            this.taskInfoDtlService.saveTaskInfoDtl(dtlSaveVOList);
        }
        if (saveVO.getReleaseSign().booleanValue()) {
            this.taskInfoDtlService.releaseDtl(saveVO.getId(), UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_WEE.getValueCode());
        }
        this.saveFile(saveVO.getFileInfoSaveVOS(), id);
        TaskInfoRespVO taskInfoRespVO = new TaskInfoRespVO();
        taskInfoRespVO.setId(id);
        return taskInfoRespVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public TaskInfoRespVO updateTask(TaskInfoSaveVO saveVO) {
        List dtlSaveVOList = saveVO.getDtlSaveVOList();
        this.checkMandatoryField(saveVO);
        this.checkMandatoryFieldDtlList(dtlSaveVOList);
        this.checkRepeatSet(saveVO);
        TaskInfoRespVO taskInfoRespVO = this.findById(saveVO.getId());
        if (Objects.isNull(taskInfoRespVO)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u8be5\u4efb\u52a1\u6570\u636e\u4fe1\u606f!");
        }
        this.checkUpdateBusiness(taskInfoRespVO);
        this.saveDefaultValue(false, saveVO, taskInfoRespVO);
        Long id = this.saveTaskInfo(saveVO);
        this.repeatSetSave(saveVO);
        this.saveDtlDefaultValue(dtlSaveVOList, saveVO);
        if (CollectionUtils.isNotEmpty((Collection)dtlSaveVOList)) {
            this.taskInfoDtlService.saveTaskInfoDtl(dtlSaveVOList);
        }
        if (saveVO.getReleaseSign().booleanValue()) {
            this.taskInfoDtlService.releaseDtl(saveVO.getId(), UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_WEE.getValueCode());
        }
        this.deleteFile(id);
        this.saveFile(saveVO.getFileInfoSaveVOS(), id);
        TaskInfoRespVO respVO = new TaskInfoRespVO();
        respVO.setId(id);
        return respVO;
    }

    public void saveFile(List<FileInfoSaveVO> fileInfoSaveVOS, Long id) {
        if (!org.springframework.util.CollectionUtils.isEmpty(fileInfoSaveVOS)) {
            List collect = fileInfoSaveVOS.stream().map(t -> {
                FileInfoDO fileInfoDO = FileinfoConvert.INSTANCE.voToDO((FileInfoSaveVO)t);
                fileInfoDO.setSourceId(id);
                return fileInfoDO;
            }).collect(Collectors.toList());
            this.fileInfoRepo.saveAll(collect);
        }
    }

    public void deleteFile(Long id) {
        if (Objects.nonNull(id)) {
            this.fileInfoRepoProc.sourceDel(Arrays.asList(id));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Long saveTaskInfo(TaskInfoSaveVO saveVO) {
        TaskInfoDO taskInfoDO = TaskInfoConvert.INSTANCE.saveVoToDo(saveVO);
        return ((TaskInfoDO)((Object)this.taskInfoRepo.save((Object)taskInfoDO))).getId();
    }

    private void saveDefaultValue(Boolean flag, TaskInfoSaveVO saveVO, TaskInfoRespVO respVO) {
        if (flag.booleanValue()) {
            saveVO.setCode(this.getTaskCode());
        } else if (StringUtils.isBlank((CharSequence)saveVO.getCode())) {
            saveVO.setCode(respVO.getCode());
        }
        if (saveVO.getReleaseSign().booleanValue()) {
            saveVO.setState(UdcEnum.SALESMAN_TASK_STATUS_WEE.getValueCode());
            if (Objects.isNull(saveVO.getExecutTemplateCode())) {
                ExectRecordTempRespVO exectRecordTempRespVO = this.getExecuteTemplate(saveVO.getType(), saveVO.getOuCode());
                saveVO.setExecutTemplateCode(exectRecordTempRespVO.getTempCode());
                saveVO.setExecutTemplateName(exectRecordTempRespVO.getTempName());
                saveVO.setExecutTemplateId(exectRecordTempRespVO.getId());
            }
        } else {
            saveVO.setState(UdcEnum.SALESMAN_TASK_STATUS_WRE.getValueCode());
        }
        saveVO.setDelayFlag(this.verifyDelayFlag(flag, saveVO));
        saveVO.setProgress(BigDecimal.ZERO);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)saveVO.getFileCodes())) {
            String fileInfo = this.transitionCodesToStr(saveVO.getFileCodes());
            saveVO.setFileInfo(fileInfo);
        }
        if (StringUtils.isBlank((CharSequence)saveVO.getOuCode())) {
            SysUserDTO sysUserDTO = this.getSysUser();
            saveVO.setOuCode(sysUserDTO.getOuCode());
        }
        if (StringUtils.isBlank((CharSequence)saveVO.getRepeatSet())) {
            saveVO.setRepeatSet("N");
        }
        if (Objects.isNull(saveVO.getSignInRange())) {
            saveVO.setSignInRange(BigDecimal.ZERO);
        }
        if (Objects.isNull(saveVO.getSignOutRange())) {
            saveVO.setSignOutRange(BigDecimal.ZERO);
        }
    }

    private String verifyDelayFlag(Boolean flag, TaskInfoSaveVO saveVO) {
        String delayFlag = UdcEnum.SALESMAN_TASK_DELAY_FLAG_N.getValueCode();
        ArrayList stateList = Lists.newArrayList((Object[])new String[]{UdcEnum.SALESMAN_TASK_STATUS_WRE.getValueCode(), UdcEnum.SALESMAN_TASK_STATUS_WEE.getValueCode(), UdcEnum.SALESMAN_TASK_STATUS_IPS.getValueCode()});
        if (flag.booleanValue()) {
            if (stateList.contains(saveVO.getState()) && LocalDateTime.of(LocalDate.now(), ConstantsSale.LOCAL_TIME_MAX).isAfter(saveVO.getEndTime())) {
                delayFlag = UdcEnum.SALESMAN_TASK_DELAY_FLAG_Y.getValueCode();
            }
        } else if (stateList.contains(saveVO.getState()) && LocalDateTime.of(LocalDate.now(), ConstantsSale.LOCAL_TIME_MAX).isAfter(saveVO.getEndTime())) {
            delayFlag = UdcEnum.SALESMAN_TASK_DELAY_FLAG_Y.getValueCode();
        }
        return delayFlag;
    }

    private void checkAndSaveDtlEmployeeId(List<TaskInfoDtlSaveVO> dtlSaveVOList) {
        Set<String> codes = dtlSaveVOList.stream().map(TaskInfoDtlSaveVO::getExecutUserCode).distinct().collect(Collectors.toSet());
        List<SysEmployeeBasicDTO> employeeList = this.rmiEmployeeRpcService.findEmployeeByCodes(codes);
        ArrayList<TaskInfoDtlSaveVO> errorDtlSaveVOList = new ArrayList<TaskInfoDtlSaveVO>();
        for (TaskInfoDtlSaveVO dtlSaveVO : dtlSaveVOList) {
            Optional<SysEmployeeBasicDTO> employeeOptional = employeeList.stream().filter(employeeDTO -> Objects.equals(employeeDTO.getCode(), dtlSaveVO.getExecutUserCode())).findFirst();
            if (employeeOptional.isPresent() && Objects.nonNull(employeeOptional.get().getId())) {
                Long employeeId = employeeOptional.get().getId();
                dtlSaveVO.setEmployeeId(employeeId);
                continue;
            }
            errorDtlSaveVOList.add(dtlSaveVO);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(errorDtlSaveVOList)) {
            String checkResult = errorDtlSaveVOList.stream().map(vo -> vo.getExecutUserCode()).collect(Collectors.joining(",", "\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u5458\u7684\u5458\u5de5\u4fe1\u606f,\u4e1a\u52a1\u5458\u7f16\u7801:[", "].\u8bf7\u68c0\u67e5!"));
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, checkResult);
        }
    }

    private void saveDtlDefaultValue(List<TaskInfoDtlSaveVO> dtlSaveVOList, TaskInfoSaveVO saveVO) {
        if (CollectionUtils.isNotEmpty(dtlSaveVOList)) {
            dtlSaveVOList.forEach(dtlSaveVO -> {
                dtlSaveVO.setMasId(saveVO.getId());
                if (saveVO.getReleaseSign().booleanValue()) {
                    dtlSaveVO.setCompleteState(UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_WEE.getValueCode());
                } else {
                    dtlSaveVO.setCompleteState(UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_WRE.getValueCode());
                }
                dtlSaveVO.setDelayFlag(this.verifyDtlDelayFlag(saveVO, (TaskInfoDtlSaveVO)dtlSaveVO));
            });
        }
    }

    private String verifyDtlDelayFlag(TaskInfoSaveVO saveVO, TaskInfoDtlSaveVO dtlSaveVO) {
        String delayFlag = UdcEnum.SALESMAN_TASK_DELAY_FLAG_N.getValueCode();
        if (Objects.equals(saveVO.getDelayFlag(), UdcEnum.SALESMAN_TASK_DELAY_FLAG_Y.getValueCode()) && !Objects.equals(dtlSaveVO.getCompleteState(), UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_CPD.getValueCode())) {
            delayFlag = UdcEnum.SALESMAN_TASK_DELAY_FLAG_Y.getValueCode();
        }
        return delayFlag;
    }

    private void transitionDtlToStr(List<TaskInfoDtlSaveVO> saveVOList) {
        saveVOList.forEach(saveVO -> {});
    }

    private ExectRecordTempRespVO getExecuteTemplate(String type, String ouCode) {
        if (StringUtils.isBlank((CharSequence)ouCode)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6240\u5c5e\u516c\u53f8\u4e0d\u53ef\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)type)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4efb\u52a1\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a!");
        }
        List recordTempList = this.exectRecordTempService.queryByCodeAndTask(type, ouCode);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)recordTempList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6839\u636e\u4efb\u52a1\u7c7b\u578b\u548c\u6240\u5c5e\u516c\u53f8\u672a\u67e5\u8be2\u5230\u6267\u884c\u6a21\u677f!");
        }
        ExectRecordTempRespVO recordTempRespVO = (ExectRecordTempRespVO)recordTempList.get(0);
        if (StringUtils.isBlank((CharSequence)recordTempRespVO.getTempCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6267\u884c\u6a21\u677f\u4e0d\u53ef\u4e3a\u7a7a!");
        }
        return recordTempRespVO;
    }

    private String getTaskCode() {
        String taskCode = this.rmiSysNextNumberService.generateCode("yst-sale", "SALESMAN_TASK_CODE", Collections.emptyList());
        if (StringUtils.isBlank((CharSequence)taskCode)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u751f\u6210\u4efb\u52a1\u7f16\u7801\u5931\u8d25!");
        }
        return taskCode;
    }

    private void checkUpdateBusiness(TaskInfoRespVO respVO) {
        if (!Objects.equals(respVO.getState(), UdcEnum.SALESMAN_TASK_STATUS_WRE.getValueCode()) && !Objects.equals(respVO.getState(), UdcEnum.SALESMAN_TASK_STATUS_CCD.getValueCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u6709\u5f85\u53d1\u5e03\u548c\u5df2\u53d6\u6d88\u7684\u4efb\u52a1\u624d\u53ef\u7f16\u8f91\u4fee\u6539!");
        }
    }

    private void checkMandatoryField(TaskInfoSaveVO saveVO) {
        if (StringUtils.isBlank((CharSequence)saveVO.getName())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4efb\u52a1\u540d\u79f0\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)saveVO.getType())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4efb\u52a1\u7c7b\u578b\u4e3a\u7a7a!");
        }
        if (Objects.isNull(saveVO.getStartTime())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a!");
        }
        if (Objects.isNull(saveVO.getEndTime())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)saveVO.getForceSignFlag())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f3a\u5236\u7b7e\u5230\u4e3a\u7a7a!");
        }
        if (Objects.isNull(saveVO.getPublishUserId())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53d1\u5e03\u4eba\u4e3a\u7a7a!");
        }
        if (Objects.isNull(saveVO.getReleaseSign())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53d1\u5e03\u6807\u5fd7\u4e3a\u7a7a!");
        }
    }

    private void checkMandatoryFieldDtlList(List<TaskInfoDtlSaveVO> saveVOList) {
        if (!org.springframework.util.CollectionUtils.isEmpty(saveVOList)) {
            saveVOList.forEach(saveVO -> this.checkMandatoryFieldDtl((TaskInfoDtlSaveVO)saveVO));
        }
    }

    private void checkMandatoryFieldDtl(TaskInfoDtlSaveVO saveVO) {
        if (StringUtils.isBlank((CharSequence)saveVO.getBusinessType())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a!");
        }
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)saveVO.getBusinessCodes()) && StringUtils.isBlank((CharSequence)saveVO.getBusinessCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e1a\u52a1\u7f16\u7801\u4e3a\u7a7a!");
        }
        if (Objects.isNull(saveVO.getExecutUserCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6267\u884c\u4eba\u4e3a\u7a7a!");
        }
    }

    private void checkRepeatSet(TaskInfoSaveVO saveVO) {
        if (Objects.equals(saveVO.getRepeatSet(), "Y")) {
            if (!ConstantsSale.SALESMAN_TASK_REPEAT_TYPE_LIST.contains(saveVO.getRepeatType())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u91cd\u590d\u7c7b\u578b\u672a\u5339\u914d\u5230!");
            }
            this.checkRepeatSet01(saveVO);
        }
    }

    private void checkRepeatSet01(TaskInfoSaveVO saveVO) {
        if (StringUtils.isBlank((CharSequence)saveVO.getRepeatType())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u91cd\u590d\u7c7b\u578b\u4e3a\u7a7a!");
        }
        if (!Objects.equals(saveVO.getRepeatType(), "TIMES") && Objects.isNull(saveVO.getRepeatInterval())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u91cd\u590d\u95f4\u9694\u4e3a\u7a7a!");
        }
        if (Objects.equals(saveVO.getRepeatType(), "WEEK") && StringUtils.isBlank((CharSequence)saveVO.getAppointDay())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u91cd\u590d\u7c7b\u578b\u4e3a\u5468\u65f6,\u6307\u5b9a\u503c\u4e3a\u7a7a!");
        }
        if (Objects.equals(saveVO.getRepeatType(), "MONTH") && StringUtils.isBlank((CharSequence)saveVO.getAppointDay())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u91cd\u590d\u7c7b\u578b\u4e3a\u6708\u65f6,\u6307\u5b9a\u503c\u4e3a\u7a7a!");
        }
        if (!Objects.equals(saveVO.getRepeatType(), "TIMES") && Objects.isNull(saveVO.getRepeatStartTime())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u91cd\u590d\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a!");
        }
        if (!Objects.equals(saveVO.getRepeatType(), "TIMES") && Objects.isNull(saveVO.getRepeatEndTime())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u91cd\u590d\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a!");
        }
        if (Objects.equals(saveVO.getRepeatType(), "TIMES") && Objects.isNull(saveVO.getExecutTime())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u91cd\u590d\u7c7b\u578b\u4e3a\u6b21\u65f6,\u6267\u884c\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    @SysCodeProc
    public PagingVO<TaskInfoRespVO> page(TaskInfoQueryVO pageParam) {
        PagingVO<TaskInfoRespVO> pagingVO;
        if (StringUtils.isNotBlank((CharSequence)pageParam.getBusinessKeyword()) || !org.springframework.util.CollectionUtils.isEmpty((Collection)pageParam.getExecutUserCodes()) || StringUtils.isNotBlank((CharSequence)pageParam.getExecutRecordKeyword())) {
            TaskInfoDtlQueryVO taskInfoDtlQueryVO = new TaskInfoDtlQueryVO();
            taskInfoDtlQueryVO.setBusinessKeyword(pageParam.getBusinessKeyword());
            taskInfoDtlQueryVO.setExecutUserCodes(pageParam.getExecutUserCodes());
            taskInfoDtlQueryVO.setExecutRecordKeyword(pageParam.getExecutRecordKeyword());
            List dtlRespVOList = this.taskInfoDtlService.selectByParam(taskInfoDtlQueryVO);
            List masIdList = dtlRespVOList.stream().map(TaskInfoDtlRespVO::getMasId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (!org.springframework.util.CollectionUtils.isEmpty(masIdList)) {
                List ids = org.springframework.util.CollectionUtils.isEmpty((Collection)pageParam.getIds()) ? Collections.EMPTY_LIST : pageParam.getIds();
                List idList = Stream.of(ids, masIdList).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                pageParam.setIds(idList);
            }
        }
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)(pagingVO = this.taskInfoRepoProc.page(pageParam)).getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List respVOList = pagingVO.getRecords();
        this.translateTask(respVOList);
        this.translateTaskUdc(respVOList);
        return PagingVO.builder().total(pagingVO.getTotal()).records(respVOList).build();
    }

    public List<FileInfoRespVO> selectFileBySourceId(Long sourceId) {
        if (Objects.isNull(sourceId)) {
            return Collections.EMPTY_LIST;
        }
        FileInfoQueryVO fileInfoQueryVO = new FileInfoQueryVO();
        fileInfoQueryVO.setSourceId(sourceId);
        List<FileInfoRespVO> list = this.fileInfoRepoProc.getList(fileInfoQueryVO);
        if (org.springframework.util.CollectionUtils.isEmpty(list)) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    public List<FileInfoRespVO> selectFileBySourceIds(List<Long> sourceIds) {
        if (org.springframework.util.CollectionUtils.isEmpty(sourceIds)) {
            return Collections.EMPTY_LIST;
        }
        FileInfoQueryVO fileInfoQueryVO = new FileInfoQueryVO();
        fileInfoQueryVO.setSourceIds(sourceIds);
        List<FileInfoRespVO> list = this.fileInfoRepoProc.getList(fileInfoQueryVO);
        if (org.springframework.util.CollectionUtils.isEmpty(list)) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    private void translateTask(List<TaskInfoRespVO> respVOList) {
        List<String> ouCodeList = respVOList.stream().map(TaskInfoRespVO::getOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<OrgOuRpcDTO> ouRpcDTOList = this.rmiOrgOuService.findOuDtoListByOuCodes(ouCodeList);
        Set<Long> publishUserIdList = respVOList.stream().map(TaskInfoRespVO::getPublishUserId).filter(Objects::nonNull).distinct().collect(Collectors.toSet());
        List<SysEmployeeBasicDTO> employeeList = this.rmiEmployeeRpcService.findEmployeeByIds(publishUserIdList);
        List templateCodeList = respVOList.stream().map(TaskInfoRespVO::getExecutTemplateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List recordTempVOList = this.exectRecordTempService.queryByCodes(templateCodeList);
        List<Long> idList = respVOList.stream().map(BaseModelVO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<FileInfoRespVO> fileInfoRespVOList = this.selectFileBySourceIds(idList);
        respVOList.forEach(respVO -> {
            Optional<OrgOuRpcDTO> ouRpcDTOOptional = ouRpcDTOList.stream().filter(ouRpcDTO -> Objects.equals(ouRpcDTO.getOuCode(), respVO.getOuCode())).findFirst();
            ouRpcDTOOptional.ifPresent(ouRpcDTO -> respVO.setOuName(ouRpcDTO.getOuName()));
            Optional<SysEmployeeBasicDTO> employeeDTOOptional = employeeList.stream().filter(employeeDTO -> Objects.equals(employeeDTO.getId(), respVO.getPublishUserId())).findFirst();
            employeeDTOOptional.ifPresent(employeeDTO -> respVO.setPublishUser(employeeDTO.getFullName()));
            List<String> fileCodes = this.transitionStrToCodes(respVO.getFileInfo());
            respVO.setFileCodes(fileCodes);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)recordTempVOList)) {
                Optional<ExectRecordTempRespVO> recordTempOptional = recordTempVOList.stream().filter(tempRespVO -> Objects.equals(tempRespVO.getTempCode(), respVO.getExecutTemplateCode())).findFirst();
                recordTempOptional.ifPresent(tempRespVO -> respVO.setExecutTemplateName(tempRespVO.getTempName()));
            }
            List fileInfoList = fileInfoRespVOList.stream().filter(fileInfoRespVO -> Objects.equals(fileInfoRespVO.getSourceId(), respVO.getId())).collect(Collectors.toList());
            respVO.setFileInfoRespVOS(fileInfoList);
        });
    }

    private void translateAppTask(List<TaskInfoRespVO> respVOList) {
        Set<Long> publishUserIdList = respVOList.stream().map(TaskInfoRespVO::getPublishUserId).filter(Objects::nonNull).distinct().collect(Collectors.toSet());
        List<SysEmployeeBasicDTO> employeeList = this.rmiEmployeeRpcService.findEmployeeByIds(publishUserIdList);
        List<Long> idList = respVOList.stream().map(BaseModelVO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<FileInfoRespVO> fileInfoRespVOList = this.selectFileBySourceIds(idList);
        respVOList.forEach(respVO -> {
            Optional<SysEmployeeBasicDTO> employeeDTOOptional = employeeList.stream().filter(employeeDTO -> Objects.equals(employeeDTO.getId(), respVO.getPublishUserId())).findFirst();
            employeeDTOOptional.ifPresent(employeeDTO -> respVO.setPublishUser(employeeDTO.getFullName()));
            List<String> fileCodes = this.transitionStrToCodes(respVO.getFileInfo());
            respVO.setFileCodes(fileCodes);
            List fileInfoList = fileInfoRespVOList.stream().filter(fileInfoRespVO -> Objects.equals(fileInfoRespVO.getSourceId(), respVO.getId())).collect(Collectors.toList());
            respVO.setFileInfoRespVOS(fileInfoList);
        });
    }

    private void translateTaskUdc(List<TaskInfoRespVO> respVOList) {
        Map<String, String> taskRepeatSetWeekMap = this.rmiUdcService.getUdcMapByUdcCode("yst-sale", UdcEnum.TASK_REPEAT_SET_WEEK_0.getCode());
        Map<String, String> taskRepeatSetMonthMap = this.rmiUdcService.getUdcMapByUdcCode("yst-sale", UdcEnum.TASK_REPEAT_SET_MONTH_0.getCode());
        respVOList.forEach(respVO -> {
            if (StringUtils.isNotBlank((CharSequence)respVO.getAppointDay()) && Objects.equals(respVO.getRepeatType(), "WEEK") && !MapUtils.isEmpty((Map)taskRepeatSetWeekMap)) {
                respVO.setAppointDayName((String)taskRepeatSetWeekMap.get(respVO.getAppointDay()));
            }
            if (StringUtils.isNotBlank((CharSequence)respVO.getAppointDay()) && Objects.equals(respVO.getRepeatType(), "MONTH") && !MapUtils.isEmpty((Map)taskRepeatSetMonthMap)) {
                respVO.setAppointDayName((String)taskRepeatSetMonthMap.get(respVO.getAppointDay()));
            }
        });
    }

    @SysCodeProc
    public TaskInfoRespVO findIdOne(Long id) {
        Optional optional = this.taskInfoRepo.findById(id);
        if (optional.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f!");
        }
        TaskInfoRespVO taskInfoRespVO = TaskInfoConvert.INSTANCE.doToRespVo((TaskInfoDO)((Object)optional.get()));
        this.selectTaskInfo(taskInfoRespVO);
        return taskInfoRespVO;
    }

    @SysCodeProc
    public TaskInfoRespVO findAppTaskById(Long id) {
        Optional optional = this.taskInfoRepo.findById(id);
        if (optional.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f!");
        }
        TaskInfoRespVO taskInfoRespVO = TaskInfoConvert.INSTANCE.doToRespVo((TaskInfoDO)((Object)optional.get()));
        this.translateAppTask(Collections.singletonList(taskInfoRespVO));
        List dtlRespVOList = this.taskInfoDtlService.selectByMasId(id);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)dtlRespVOList)) {
            taskInfoRespVO.setDtlRespVOList(dtlRespVOList);
        }
        return taskInfoRespVO;
    }

    @SysCodeProc
    public TaskInfoRespVO findTaskByDtlId(Long dtlId) {
        TaskInfoDtlRespVO taskInfoDtlRespVO = this.taskInfoDtlService.selectById(dtlId);
        if (Objects.isNull(taskInfoDtlRespVO)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u660e\u7ec6\u6570\u636e\u4fe1\u606f!");
        }
        Optional optional = this.taskInfoRepo.findById(taskInfoDtlRespVO.getMasId());
        if (optional.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u6570\u636e\u4fe1\u606f!");
        }
        TaskInfoRespVO taskInfoRespVO = TaskInfoConvert.INSTANCE.doToRespVo((TaskInfoDO)((Object)optional.get()));
        this.translateAppTask(Collections.singletonList(taskInfoRespVO));
        taskInfoRespVO.setDtlRespVOList(Collections.singletonList(taskInfoDtlRespVO));
        this.setJurisdictionName(List.of(taskInfoDtlRespVO));
        return taskInfoRespVO;
    }

    private void setJurisdictionName(List<TaskInfoDtlRespVO> records) {
        if (!org.springframework.util.CollectionUtils.isEmpty(records)) {
            List<String> salesmanNos = records.stream().map(TaskInfoDtlRespVO::getExecutUserCode).filter(CharSequenceUtil::isNotEmpty).distinct().collect(Collectors.toList());
            if (org.springframework.util.CollectionUtils.isEmpty(salesmanNos)) {
                return;
            }
            List<SalesmanInfoDO> bySalesmanNoIn = this.salesmanInfoRepo.findBySalesmanNoIn(salesmanNos);
            if (org.springframework.util.CollectionUtils.isEmpty(bySalesmanNoIn)) {
                return;
            }
            List<Long> salesmanIds = bySalesmanNoIn.stream().map(BaseModel::getId).collect(Collectors.toList());
            List<SalesmanRegionDO> regionDOS = this.salesmanRegionRepo.findByMasIdIn(salesmanIds);
            if (CollUtil.isNotEmpty(regionDOS)) {
                Map<Long, List<SalesmanRegionDO>> map = regionDOS.stream().collect(Collectors.groupingBy(SalesmanRegionDO::getMasId));
                Map<String, String> regionMap = this.rmiUdcService.getUdcMapByUdcCode("yst-supp", "REGION");
                records.forEach(i -> {
                    if (StringUtils.isNotEmpty((CharSequence)i.getExecutUserCode())) {
                        i.setExecutUserId((Long)bySalesmanNoIn.stream().filter(salesmanInfoDO -> salesmanInfoDO.getSalesmanNo().equals(i.getExecutUserCode())).map(BaseModel::getId).findAny().orElse(null));
                    }
                    if (!org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)map.get(i.getExecutUserId())))) {
                        String jurisdictionName = ((List)map.get(i.getExecutUserId())).stream().map(SalesmanRegionDO::getRegionCode).filter(StringUtils::isNotEmpty).map(regionCode -> (String)regionMap.get(regionCode)).filter(StringUtils::isNotEmpty).collect(Collectors.joining(","));
                        i.setJurisdictionName(jurisdictionName);
                    }
                });
            }
        }
    }

    @SysCodeProc
    public TaskInfoRespVO findById(Long id) {
        if (Objects.isNull(id)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        TaskInfoQueryVO queryVO = new TaskInfoQueryVO();
        queryVO.setId(id);
        List<TaskInfoRespVO> respVOList = this.taskInfoRepoProc.selectByQueryVO(queryVO);
        if (org.springframework.util.CollectionUtils.isEmpty(respVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f!");
        }
        if (respVOList.size() > 1) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u67e5\u8be2\u5230\u591a\u6761\u6570\u636e\u4fe1\u606f!");
        }
        TaskInfoRespVO taskInfoRespVO = respVOList.get(0);
        return taskInfoRespVO;
    }

    @SysCodeProc
    public TaskInfoRespVO findCodeOne(String code) {
        TaskInfoQueryVO queryVO = new TaskInfoQueryVO();
        queryVO.setCode(code);
        List<TaskInfoRespVO> respVOList = this.taskInfoRepoProc.selectByQueryVO(queryVO);
        if (org.springframework.util.CollectionUtils.isEmpty(respVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f!");
        }
        if (respVOList.size() > 1) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u67e5\u8be2\u5230\u591a\u6761\u6570\u636e\u4fe1\u606f!");
        }
        TaskInfoRespVO taskInfoRespVO = respVOList.get(0);
        this.selectTaskInfo(taskInfoRespVO);
        return taskInfoRespVO;
    }

    @SysCodeProc
    public TaskInfoRespVO findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4efb\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        TaskInfoQueryVO queryVO = new TaskInfoQueryVO();
        queryVO.setCode(code);
        List<TaskInfoRespVO> respVOList = this.taskInfoRepoProc.selectByQueryVO(queryVO);
        if (org.springframework.util.CollectionUtils.isEmpty(respVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f!");
        }
        if (respVOList.size() > 1) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u67e5\u8be2\u5230\u591a\u6761\u6570\u636e\u4fe1\u606f!");
        }
        TaskInfoRespVO taskInfoRespVO = respVOList.get(0);
        return taskInfoRespVO;
    }

    @SysCodeProc
    public List<TaskInfoRespVO> selectByParam(TaskInfoQueryVO queryVO) {
        List<TaskInfoRespVO> taskInfoRespVOList = this.taskInfoRepoProc.selectByQueryVO(queryVO);
        if (org.springframework.util.CollectionUtils.isEmpty(taskInfoRespVOList)) {
            return Collections.emptyList();
        }
        return taskInfoRespVOList;
    }

    @SysCodeProc
    public List<TaskInfoRespVO> selectPageByQueryVO(TaskInfoQueryVO queryVO) {
        List<TaskInfoRespVO> taskInfoRespVOList = this.taskInfoRepoProc.selectPageByQueryVO(queryVO);
        if (org.springframework.util.CollectionUtils.isEmpty(taskInfoRespVOList)) {
            return Collections.emptyList();
        }
        return taskInfoRespVOList;
    }

    private void selectTaskInfo(TaskInfoRespVO taskInfoRespVO) {
        Long id = taskInfoRespVO.getId();
        List<String> fileCodes = this.transitionStrToCodes(taskInfoRespVO.getFileInfo());
        taskInfoRespVO.setFileCodes(fileCodes);
        this.translateTask(Collections.singletonList(taskInfoRespVO));
        this.translateTaskUdc(Collections.singletonList(taskInfoRespVO));
        List dtlRespVOList = this.taskInfoDtlService.selectByMasId(id);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)dtlRespVOList)) {
            taskInfoRespVO.setDtlRespVOList(dtlRespVOList);
        }
    }

    private void transitionDtlToCodes(List<TaskInfoDtlRespVO> respVOList) {
        respVOList.forEach(respVO -> {});
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> ids) {
        TaskInfoQueryVO queryVO = new TaskInfoQueryVO();
        queryVO.setIds(ids);
        List<TaskInfoRespVO> respVOList = this.taskInfoRepoProc.selectByQueryVO(queryVO);
        if (org.springframework.util.CollectionUtils.isEmpty(respVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f!");
        }
        List voList = respVOList.stream().filter(respVO -> !Objects.equals(respVO.getState(), UdcEnum.SALESMAN_TASK_STATUS_WRE.getValueCode())).collect(Collectors.toList());
        if (!org.springframework.util.CollectionUtils.isEmpty(voList)) {
            String checkResult = voList.stream().map(vo -> "\u4efb\u52a1\u540d\u79f0:" + vo.getName()).collect(Collectors.joining(";", "\u53ea\u6709\u5f85\u53d1\u5e03\u53ef\u5220\u9664,[", "], \u8bf7\u68c0\u67e5"));
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, checkResult);
        }
        this.taskInfoRepoProc.updateDeleteFlagBatch(1, ids);
        this.taskInfoDtlService.updateDeleteFlagBatch(Integer.valueOf(1), ids);
    }

    @Transactional(rollbackFor={Exception.class})
    public void cancelTask(Long id) {
        TaskInfoRespVO respVO = this.findById(id);
        if (!Objects.equals(respVO.getState(), UdcEnum.SALESMAN_TASK_STATUS_WRE.getValueCode()) && !Objects.equals(respVO.getState(), UdcEnum.SALESMAN_TASK_STATUS_WEE.getValueCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f85\u53d1\u5e03\u548c\u5f85\u6267\u884c\u72b6\u6001\u624d\u53ef\u53d6\u6d88!");
        }
        this.updateStateById(UdcEnum.SALESMAN_TASK_STATUS_CCD.getValueCode(), id);
        this.taskInfoDtlService.updateCompleteStateByMasId(UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_CCD.getValueCode(), id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void releaseTask(Long id) {
        TaskInfoRespVO respVO = this.findById(id);
        if (!Objects.equals(respVO.getState(), UdcEnum.SALESMAN_TASK_STATUS_WRE.getValueCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f85\u53d1\u5e03\u72b6\u6001\u624d\u53ef\u53d1\u5e03!");
        }
        if (StringUtils.isBlank((CharSequence)respVO.getExecutTemplateCode())) {
            ExectRecordTempRespVO exectRecordTempRespVO = this.getExecuteTemplate(respVO.getType(), respVO.getOuCode());
            this.taskInfoRepoProc.updateExecuteTemplateCodeById(exectRecordTempRespVO.getId(), exectRecordTempRespVO.getTempCode(), exectRecordTempRespVO.getTempName(), id);
        }
        this.updateStateById(UdcEnum.SALESMAN_TASK_STATUS_WEE.getValueCode(), id);
        this.taskInfoDtlService.updateCompleteStateByMasId(UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_WEE.getValueCode(), id);
    }

    public Boolean accomplishCheckTask(Long id) {
        TaskInfoRespVO respVO = this.findById(id);
        if (!Objects.equals(respVO.getState(), UdcEnum.SALESMAN_TASK_STATUS_WEE.getValueCode()) && !Objects.equals(respVO.getState(), UdcEnum.SALESMAN_TASK_STATUS_IPS.getValueCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f85\u6267\u884c\u6216\u8fdb\u884c\u4e2d\u72b6\u6001\u624d\u53ef\u5b8c\u6210!");
        }
        TaskInfoDtlQueryVO dtlQueryVO = new TaskInfoDtlQueryVO();
        dtlQueryVO.setMasId(id);
        ArrayList completeStates = Lists.newArrayList((Object[])new String[]{UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_IPS.getValueCode(), UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_WAT.getValueCode(), UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_ARN.getValueCode()});
        dtlQueryVO.setCompleteStates((List)completeStates);
        List dtlRespVOList = this.taskInfoDtlService.selectByParam(dtlQueryVO);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)dtlRespVOList)) {
            return true;
        }
        List<String> recordCode = dtlRespVOList.stream().map(TaskInfoDtlRespVO::getExecutRecordCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        boolean recordFlag = this.selectExecutionRecordCheck(recordCode);
        if (recordFlag) {
            return false;
        }
        return true;
    }

    public boolean selectExecutionRecordCheck(List<String> recordCode) {
        if (org.springframework.util.CollectionUtils.isEmpty(recordCode)) {
            return false;
        }
        List executeRecordList = this.exectRecordService.queryByCodes(recordCode);
        return !org.springframework.util.CollectionUtils.isEmpty((Collection)executeRecordList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void accomplishTask(Long id) {
        TaskInfoRespVO respVO = this.findById(id);
        if (!Objects.equals(respVO.getState(), UdcEnum.SALESMAN_TASK_STATUS_WEE.getValueCode()) && !Objects.equals(respVO.getState(), UdcEnum.SALESMAN_TASK_STATUS_IPS.getValueCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f85\u6267\u884c\u6216\u8fdb\u884c\u4e2d\u72b6\u6001\u624d\u53ef\u5b8c\u6210!");
        }
        this.updateStateAndCompleteTime(UdcEnum.SALESMAN_TASK_STATUS_CPD.getValueCode(), LocalDateTime.now(), id);
        TaskInfoDtlQueryVO dtlQueryVO = new TaskInfoDtlQueryVO();
        dtlQueryVO.setMasId(id);
        List dtlRespVOList = this.taskInfoDtlService.selectByParam(dtlQueryVO);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)dtlRespVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u660e\u7ec6\u6570\u636e!");
        }
        List infoDtlRespVOList = dtlRespVOList.stream().filter(dtlRespVO -> this.accomplishTaskDtlCheck(dtlRespVO.getCompleteState())).collect(Collectors.toList());
        List dtlIds = infoDtlRespVOList.stream().map(BaseModelVO::getId).filter(Objects::nonNull).collect(Collectors.toList());
        if (!org.springframework.util.CollectionUtils.isEmpty(dtlIds)) {
            this.taskInfoDtlService.updateCompleteStateAndTimeByIdBatch(UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_CPD.getValueCode(), LocalDateTime.now(), dtlIds);
        }
        this.taskInfoDtlService.updateProgressById(id);
        this.accomplishUpdateExecuteRecord(id);
    }

    private boolean accomplishTaskDtlCheck(String completeState) {
        return !Objects.equals(completeState, UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_CPD.getValueCode()) && !Objects.equals(completeState, UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_CSD.getValueCode());
    }

    private void accomplishUpdateExecuteRecord(Long id) {
        TaskInfoDtlQueryVO dtlQueryVO = new TaskInfoDtlQueryVO();
        dtlQueryVO.setMasId(id);
        List dtlRespVOList = this.taskInfoDtlService.selectByParam(dtlQueryVO);
        List recordCodes = dtlRespVOList.stream().map(TaskInfoDtlRespVO::getExecutRecordCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (!org.springframework.util.CollectionUtils.isEmpty(recordCodes)) {
            this.exectRecordService.complete(recordCodes);
        }
    }

    public Boolean closeCheckTask(Long id) {
        TaskInfoRespVO respVO = this.findById(id);
        if (!Objects.equals(respVO.getState(), UdcEnum.SALESMAN_TASK_STATUS_WEE.getValueCode()) && !Objects.equals(respVO.getState(), UdcEnum.SALESMAN_TASK_STATUS_IPS.getValueCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f85\u6267\u884c\u6216\u8fdb\u884c\u4e2d\u72b6\u6001\u624d\u53ef\u5173\u95ed!");
        }
        TaskInfoDtlQueryVO dtlQueryVO = new TaskInfoDtlQueryVO();
        dtlQueryVO.setMasId(id);
        ArrayList completeStates = Lists.newArrayList((Object[])new String[]{UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_IPS.getValueCode(), UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_WAT.getValueCode(), UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_ARN.getValueCode()});
        dtlQueryVO.setCompleteStates((List)completeStates);
        List dtlRespVOList = this.taskInfoDtlService.selectByParam(dtlQueryVO);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)dtlRespVOList)) {
            return true;
        }
        List<String> recordCode = dtlRespVOList.stream().map(TaskInfoDtlRespVO::getExecutRecordCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        boolean recordFlag = this.selectExecutionRecordCheck(recordCode);
        if (recordFlag) {
            return false;
        }
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public void closeTask(Long id) {
        TaskInfoRespVO respVO = this.findById(id);
        if (!Objects.equals(respVO.getState(), UdcEnum.SALESMAN_TASK_STATUS_WEE.getValueCode()) && !Objects.equals(respVO.getState(), UdcEnum.SALESMAN_TASK_STATUS_IPS.getValueCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f85\u6267\u884c\u6216\u8fdb\u884c\u4e2d\u72b6\u6001\u624d\u53ef\u5173\u95ed!");
        }
        TaskInfoDtlQueryVO dtlQueryVO = new TaskInfoDtlQueryVO();
        dtlQueryVO.setMasId(id);
        List dtlRespVOList = this.taskInfoDtlService.selectByParam(dtlQueryVO);
        List dtlIds = dtlRespVOList.stream().filter(vo -> !Objects.equals(vo.getCompleteState(), UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_CPD.getValueCode())).map(BaseModelVO::getId).collect(Collectors.toList());
        this.taskInfoDtlService.updateCompleteStateByIdBatch(UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_CSD.getValueCode(), dtlIds);
        boolean dtlFlag1 = dtlRespVOList.stream().anyMatch(vo -> Objects.equals(vo.getCompleteState(), UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_CPD.getValueCode()));
        if (dtlFlag1) {
            this.updateStateAndCompleteTime(UdcEnum.SALESMAN_TASK_STATUS_CPD.getValueCode(), LocalDateTime.now(), id);
        } else {
            this.updateStateById(UdcEnum.SALESMAN_TASK_STATUS_CSD.getValueCode(), id);
        }
        this.closeUpdateExecuteRecord(dtlRespVOList);
    }

    private void closeUpdateExecuteRecord(List<TaskInfoDtlRespVO> dtlRespVOList) {
        List recordCodes = dtlRespVOList.stream().map(TaskInfoDtlRespVO::getExecutRecordCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (!org.springframework.util.CollectionUtils.isEmpty(recordCodes)) {
            this.exectRecordService.filterClose(recordCodes);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public List<Long> overdueTask(TaskInfoQueryVO queryVO) {
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)queryVO.getStateList())) {
            ArrayList stateList = Lists.newArrayList((Object[])new String[]{UdcEnum.SALESMAN_TASK_STATUS_WRE.getValueCode(), UdcEnum.SALESMAN_TASK_STATUS_WEE.getValueCode(), UdcEnum.SALESMAN_TASK_STATUS_IPS.getValueCode()});
            queryVO.setStateList((List)stateList);
        }
        if (Objects.isNull(queryVO.getEndTimeE())) {
            queryVO.setEndTimeE(LocalDateTime.of(LocalDate.now(), LocalTime.MIN));
        }
        queryVO.setDelayFlag(UdcEnum.SALESMAN_TASK_DELAY_FLAG_N.getValueCode());
        this.selectOverdueTask(queryVO, paramVO -> this.selectPageByQueryVO(queryVO));
        return Collections.emptyList();
    }

    private void selectOverdueTask(TaskInfoQueryVO queryParam, Function<TaskInfoQueryVO, List<TaskInfoRespVO>> dataProducer) {
        this.disposeOverdueTask((page, pageSize) -> {
            queryParam.setCurrent(page);
            queryParam.setSize(pageSize);
            return (List)dataProducer.apply(queryParam);
        });
    }

    private void disposeOverdueTask(BiFunction<Integer, Integer, List<TaskInfoRespVO>> dataProducer) {
        int page = 1;
        int size = 100;
        List<TaskInfoRespVO> dataList = null;
        while (!org.springframework.util.CollectionUtils.isEmpty(dataList = dataProducer.apply(page++, size))) {
            this.disposeOverdue(dataList);
            if (dataList.size() >= size) continue;
            break;
        }
    }

    private void disposeOverdue(List<TaskInfoRespVO> respVOList) {
        List<Long> ids = respVOList.stream().map(BaseModelVO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        this.taskInfoRepoProc.updateDelayFlagByIdBatch(UdcEnum.SALESMAN_TASK_DELAY_FLAG_Y.getValueCode(), ids);
        TaskInfoDtlQueryVO dtlQueryVO = new TaskInfoDtlQueryVO();
        dtlQueryVO.setMasIds(ids);
        dtlQueryVO.setNoCompleteState(UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_CPD.getValueCode());
        List dtlRespVOList = this.taskInfoDtlService.selectByParam(dtlQueryVO);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)dtlRespVOList)) {
            List dtlIds = dtlRespVOList.stream().map(BaseModelVO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            this.taskInfoDtlService.updateDelayFlagByIdBatch(UdcEnum.SALESMAN_TASK_DELAY_FLAG_Y.getValueCode(), dtlIds);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public TaskInfoRespVO repeatSetSave(TaskInfoSaveVO saveVO) {
        if (Objects.isNull(saveVO.getId())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4efb\u52a1ID\u4e3a\u7a7a!");
        }
        this.checkRepeatSet(saveVO);
        if (Objects.equals(saveVO.getRepeatSet(), "Y")) {
            switch (saveVO.getRepeatType()) {
                case "TIMES": {
                    this.repeatSetSaveTimes(saveVO);
                    break;
                }
                case "DAY": {
                    this.repeatSetSaveDay(saveVO);
                    break;
                }
                case "WEEK": {
                    this.repeatSetSaveWeek(saveVO);
                    break;
                }
                case "MONTH": {
                    this.repeatSetSaveMonth(saveVO);
                }
            }
        } else {
            saveVO.setRepeatSet("N");
            saveVO.setRepeatType(null);
            saveVO.setRepeatInterval(null);
            saveVO.setAppointDay(null);
            saveVO.setRepeatStartTime(null);
            saveVO.setRepeatEndTime(null);
            saveVO.setExecutTime(null);
            this.updateRepeatSetById(saveVO);
        }
        TaskInfoRespVO taskInfoRespVO = new TaskInfoRespVO();
        taskInfoRespVO.setId(saveVO.getId());
        return taskInfoRespVO;
    }

    private void repeatSetSaveTimes(TaskInfoSaveVO saveVO) {
        if (Objects.isNull(saveVO.getExecutTime())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u91cd\u590d\u8bbe\u7f6e\u7684\u6267\u884c\u65f6\u95f4\u4e3a\u7a7a!");
        }
        saveVO.setAppointDay(null);
        saveVO.setRepeatStartTime(null);
        saveVO.setRepeatEndTime(null);
        this.updateRepeatSetById(saveVO);
    }

    private void repeatSetSaveDay(TaskInfoSaveVO saveVO) {
        if (Objects.isNull(saveVO.getRepeatInterval())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u91cd\u590d\u8bbe\u7f6e\u7684\u91cd\u590d\u95f4\u9694\u4e3a\u7a7a!");
        }
        if (Objects.isNull(saveVO.getRepeatStartTime())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u91cd\u590d\u8bbe\u7f6e\u7684\u91cd\u590d\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a!");
        }
        if (Objects.isNull(saveVO.getRepeatEndTime())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u91cd\u590d\u8bbe\u7f6e\u7684\u91cd\u590d\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a!");
        }
        saveVO.setAppointDay(null);
        saveVO.setExecutTime(null);
        this.updateRepeatSetById(saveVO);
        this.disposeNextExecuteTimeDay(saveVO.getRepeatInterval(), saveVO.getRepeatStartTime(), saveVO.getRepeatEndTime(), saveVO.getExecutTime(), saveVO.getId());
    }

    private void repeatSetSaveWeek(TaskInfoSaveVO saveVO) {
        if (Objects.isNull(saveVO.getRepeatInterval())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u91cd\u590d\u8bbe\u7f6e\u7684\u91cd\u590d\u95f4\u9694\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)saveVO.getAppointDay())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u91cd\u590d\u8bbe\u7f6e\u7684\u6307\u5b9a\u5929\u4e3a\u7a7a!");
        }
        if (Objects.isNull(saveVO.getRepeatStartTime())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u91cd\u590d\u8bbe\u7f6e\u7684\u91cd\u590d\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a!");
        }
        if (Objects.isNull(saveVO.getRepeatEndTime())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u91cd\u590d\u8bbe\u7f6e\u7684\u91cd\u590d\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a!");
        }
        saveVO.setExecutTime(null);
        this.updateRepeatSetById(saveVO);
        this.disposeNextExecuteTimeWeek(saveVO.getRepeatInterval(), saveVO.getAppointDay(), saveVO.getRepeatStartTime(), saveVO.getRepeatEndTime(), saveVO.getExecutTime(), saveVO.getId());
    }

    private void repeatSetSaveMonth(TaskInfoSaveVO saveVO) {
        if (Objects.isNull(saveVO.getRepeatInterval())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u91cd\u590d\u8bbe\u7f6e\u7684\u91cd\u590d\u95f4\u9694\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)saveVO.getAppointDay())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u91cd\u590d\u8bbe\u7f6e\u7684\u6307\u5b9a\u5929\u4e3a\u7a7a!");
        }
        if (Objects.isNull(saveVO.getRepeatStartTime())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u91cd\u590d\u8bbe\u7f6e\u7684\u91cd\u590d\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a!");
        }
        if (Objects.isNull(saveVO.getRepeatEndTime())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u91cd\u590d\u8bbe\u7f6e\u7684\u91cd\u590d\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a!");
        }
        saveVO.setExecutTime(null);
        this.updateRepeatSetById(saveVO);
        this.disposeNextExecuteTimeMonth(saveVO.getRepeatInterval(), saveVO.getAppointDay(), saveVO.getRepeatStartTime(), saveVO.getRepeatEndTime(), saveVO.getExecutTime(), saveVO.getId());
    }

    @Transactional(rollbackFor={Exception.class})
    public void setTaskDuplication(TaskInfoQueryVO queryVO) {
        queryVO.setRepeatSet("Y");
        ArrayList stateList = Lists.newArrayList((Object[])new String[]{UdcEnum.SALESMAN_TASK_STATUS_WEE.getValueCode(), UdcEnum.SALESMAN_TASK_STATUS_IPS.getValueCode(), UdcEnum.SALESMAN_TASK_STATUS_CPD.getValueCode(), UdcEnum.SALESMAN_TASK_STATUS_CCD.getValueCode(), UdcEnum.SALESMAN_TASK_STATUS_CSD.getValueCode()});
        queryVO.setStateList((List)stateList);
        this.selectTaskDuplicationSet(queryVO, paramVO -> this.selectPageByQueryVO(queryVO));
    }

    private void selectTaskDuplicationSet(TaskInfoQueryVO queryParam, Function<TaskInfoQueryVO, List<TaskInfoRespVO>> dataProducer) {
        this.disposeTaskDuplicationSet((page, pageSize) -> {
            queryParam.setCurrent(page);
            queryParam.setSize(pageSize);
            return (List)dataProducer.apply(queryParam);
        });
    }

    private void disposeTaskDuplicationSet(BiFunction<Integer, Integer, List<TaskInfoRespVO>> dataProducer) {
        int page = 1;
        int size = 100;
        List<TaskInfoRespVO> dataList = null;
        while (!org.springframework.util.CollectionUtils.isEmpty(dataList = dataProducer.apply(page++, size))) {
            this.disposeDuplicationSet(dataList);
            if (dataList.size() >= size) continue;
            break;
        }
    }

    private void disposeDuplicationSet(List<TaskInfoRespVO> respVOList) {
        for (TaskInfoRespVO respVO : respVOList) {
            log.info("\u4efb\u52a1\u91cd\u590d\u8bbe\u7f6e\u6267\u884c,\u65f6\u95f4\uff1a{},\u4fe1\u606f\uff1a{}", (Object)LocalDateTime.now(), (Object)respVO);
            switch (respVO.getRepeatType()) {
                case "TIMES": {
                    this.disposeDuplicationSetTimes(respVO);
                    break;
                }
                case "DAY": {
                    this.disposeDuplicationSetDay(respVO);
                    break;
                }
                case "WEEK": {
                    this.disposeDuplicationSetWeek(respVO);
                    break;
                }
                case "MONTH": {
                    this.disposeDuplicationSetMonth(respVO);
                }
            }
        }
    }

    private void disposeDuplicationSetTimes(TaskInfoRespVO respVO) {
        if (!Objects.isNull(respVO.getExecutTime()) && LocalDate.now().isEqual(respVO.getExecutTime().toLocalDate())) {
            this.copyTaskInfoSave(respVO);
        }
    }

    private void disposeDuplicationSetDay(TaskInfoRespVO respVO) {
        if (!Objects.isNull(respVO.getExecutTime()) && LocalDate.now().isEqual(respVO.getExecutTime().toLocalDate())) {
            this.copyTaskInfoSave(respVO);
        }
        BigDecimal repeatInterval = respVO.getRepeatInterval();
        LocalDateTime repeatStartTime = respVO.getRepeatStartTime();
        LocalDateTime repeatEndTime = respVO.getRepeatEndTime();
        LocalDateTime executTime = respVO.getExecutTime();
        if (!(Objects.isNull(repeatInterval) || Objects.isNull(repeatStartTime) || Objects.isNull(repeatEndTime))) {
            this.disposeNextExecuteTimeDay(repeatInterval, repeatStartTime, repeatEndTime, executTime, respVO.getId());
        } else {
            log.error("\u6bcf\u5929\u65f6\u4efb\u52a1\u91cd\u590d\u8bbe\u7f6e\u6267\u884c,\u65f6\u95f4\uff1a{},\u4fe1\u606f\uff1a{}", (Object)LocalDateTime.now(), (Object)respVO);
        }
    }

    private void disposeNextExecuteTimeDay(BigDecimal repeatInterval, LocalDateTime repeatStartTime, LocalDateTime repeatEndTime, LocalDateTime executTime, Long id) {
        LocalDateTime referenceTime;
        LocalDateTime localDateTime = referenceTime = Objects.isNull(executTime) ? repeatStartTime : executTime;
        if (repeatInterval.compareTo(BigDecimal.ONE) == -1) {
            executTime = Objects.isNull(executTime) ? this.judgmentExecuteTime(repeatStartTime) : referenceTime.plusDays(1L);
        } else {
            long afterDays = repeatInterval.longValue();
            executTime = referenceTime.plusDays(afterDays);
        }
        if (executTime.isBefore(repeatEndTime)) {
            this.updateExecutTimeById(executTime, id);
        }
    }

    private LocalDateTime judgmentExecuteTime(LocalDateTime localDateTime) {
        LocalDate localDate = LocalDate.now();
        LocalDate executeDate = localDateTime.toLocalDate();
        LocalTime executeTime = localDateTime.toLocalTime();
        LocalDateTime newDateTime = localDateTime;
        if (localDate.isEqual(executeDate)) {
            newDateTime = LocalDateTime.of(executeDate, executeTime).plusDays(1L);
        } else if (localDate.isBefore(executeDate)) {
            newDateTime = localDateTime;
        } else if (localDate.isAfter(executeDate)) {
            newDateTime = LocalDateTime.of(localDate, executeTime).plusDays(1L);
        }
        return newDateTime;
    }

    private void disposeDuplicationSetWeek(TaskInfoRespVO respVO) {
        if (!Objects.isNull(respVO.getExecutTime()) && LocalDate.now().isEqual(respVO.getExecutTime().toLocalDate())) {
            this.copyTaskInfoSave(respVO);
        }
        BigDecimal repeatInterval = respVO.getRepeatInterval();
        String appointDay = respVO.getAppointDay();
        LocalDateTime repeatStartTime = respVO.getRepeatStartTime();
        LocalDateTime repeatEndTime = respVO.getRepeatEndTime();
        LocalDateTime executTime = respVO.getExecutTime();
        if (!Objects.isNull(repeatInterval) && StringUtils.isNotBlank((CharSequence)appointDay) && !Objects.isNull(repeatStartTime) && !Objects.isNull(repeatEndTime)) {
            this.disposeNextExecuteTimeWeek(repeatInterval, appointDay, repeatStartTime, repeatEndTime, executTime, respVO.getId());
        } else {
            log.error("\u6bcf\u5468\u65f6\u4efb\u52a1\u91cd\u590d\u8bbe\u7f6e\u6267\u884c,\u65f6\u95f4\uff1a{},\u4fe1\u606f\uff1a{}", (Object)LocalDateTime.now(), (Object)respVO);
        }
    }

    private void disposeNextExecuteTimeWeek(BigDecimal repeatInterval, String appointDay, LocalDateTime repeatStartTime, LocalDateTime repeatEndTime, LocalDateTime executTime, Long id) {
        LocalDateTime referenceTime;
        LocalDateTime localDateTime = referenceTime = Objects.isNull(executTime) ? repeatStartTime : executTime;
        if (repeatInterval.compareTo(BigDecimal.ONE) == -1) {
            executTime = this.getAppointDayOfWeek(appointDay, referenceTime);
        } else {
            long afterWeek = repeatInterval.longValue();
            LocalDateTime weekTime = referenceTime.plus(afterWeek, ChronoUnit.WEEKS);
            executTime = this.getAppointDayOfWeek(appointDay, weekTime);
        }
        if (!Objects.isNull(executTime) && executTime.isBefore(repeatEndTime)) {
            this.updateExecutTimeById(executTime, id);
        }
    }

    private LocalDateTime getAppointDayOfWeek(String appointDay, LocalDateTime weekTime) {
        LocalDateTime localDateTime = null;
        if (Objects.equals(appointDay, UdcEnum.TASK_REPEAT_SET_WEEK_0.getValueCode())) {
            localDateTime = weekTime;
        } else if (Objects.equals(appointDay, UdcEnum.TASK_REPEAT_SET_WEEK_1.getValueCode())) {
            localDateTime = weekTime.with(TemporalAdjusters.nextOrSame(DayOfWeek.MONDAY));
        } else if (Objects.equals(appointDay, UdcEnum.TASK_REPEAT_SET_WEEK_2.getValueCode())) {
            localDateTime = weekTime.with(TemporalAdjusters.nextOrSame(DayOfWeek.TUESDAY));
        } else if (Objects.equals(appointDay, UdcEnum.TASK_REPEAT_SET_WEEK_3.getValueCode())) {
            localDateTime = weekTime.with(TemporalAdjusters.nextOrSame(DayOfWeek.WEDNESDAY));
        } else if (Objects.equals(appointDay, UdcEnum.TASK_REPEAT_SET_WEEK_4.getValueCode())) {
            localDateTime = weekTime.with(TemporalAdjusters.nextOrSame(DayOfWeek.THURSDAY));
        } else if (Objects.equals(appointDay, UdcEnum.TASK_REPEAT_SET_WEEK_5.getValueCode())) {
            localDateTime = weekTime.with(TemporalAdjusters.nextOrSame(DayOfWeek.FRIDAY));
        } else if (Objects.equals(appointDay, UdcEnum.TASK_REPEAT_SET_WEEK_6.getValueCode())) {
            localDateTime = weekTime.with(TemporalAdjusters.nextOrSame(DayOfWeek.SATURDAY));
        } else if (Objects.equals(appointDay, UdcEnum.TASK_REPEAT_SET_WEEK_7.getValueCode())) {
            localDateTime = weekTime.with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY));
        }
        return localDateTime;
    }

    private void disposeDuplicationSetMonth(TaskInfoRespVO respVO) {
        if (!Objects.isNull(respVO.getExecutTime()) && LocalDate.now().isEqual(respVO.getExecutTime().toLocalDate())) {
            this.copyTaskInfoSave(respVO);
        }
        BigDecimal repeatInterval = respVO.getRepeatInterval();
        String appointDay = respVO.getAppointDay();
        LocalDateTime repeatStartTime = respVO.getRepeatStartTime();
        LocalDateTime repeatEndTime = respVO.getRepeatEndTime();
        LocalDateTime executTime = respVO.getExecutTime();
        if (!Objects.isNull(repeatInterval) && StringUtils.isNotBlank((CharSequence)appointDay) && !Objects.isNull(repeatStartTime) && !Objects.isNull(repeatEndTime)) {
            this.disposeNextExecuteTimeMonth(repeatInterval, appointDay, repeatStartTime, repeatEndTime, executTime, respVO.getId());
        } else {
            log.error("\u6bcf\u6708\u65f6\u4efb\u52a1\u91cd\u590d\u8bbe\u7f6e\u6267\u884c,\u65f6\u95f4\uff1a{},\u4fe1\u606f\uff1a{}", (Object)LocalDateTime.now(), (Object)respVO);
        }
    }

    private void disposeNextExecuteTimeMonth(BigDecimal repeatInterval, String appointDay, LocalDateTime repeatStartTime, LocalDateTime repeatEndTime, LocalDateTime executTime, Long id) {
        LocalDateTime referenceTime;
        LocalDateTime localDateTime = referenceTime = Objects.isNull(executTime) ? repeatStartTime : executTime;
        if (repeatInterval.compareTo(BigDecimal.ONE) == -1) {
            executTime = this.getAppointDayOfMonth(appointDay, referenceTime);
        } else {
            long afterMonth = repeatInterval.longValue();
            LocalDateTime monthTime = referenceTime.plus(afterMonth, ChronoUnit.MONTHS);
            executTime = this.getAppointDayOfMonth(appointDay, monthTime);
        }
        if (!Objects.isNull(executTime) && executTime.isBefore(repeatEndTime)) {
            this.updateExecutTimeById(executTime, id);
        }
    }

    private LocalDateTime getAppointDayOfMonth(String appointDay, LocalDateTime monthTime) {
        LocalDateTime localDateTime = null;
        if (Objects.equals(appointDay, UdcEnum.TASK_REPEAT_SET_MONTH_0.getValueCode())) {
            localDateTime = monthTime;
        } else if (!Objects.isNull(appointDay)) {
            LocalDateTime lastDayOfThisMonth;
            Integer appointDayOfMonth = Integer.valueOf(appointDay);
            Integer monthLength = monthTime.toLocalDate().lengthOfMonth();
            localDateTime = appointDayOfMonth > monthLength ? (lastDayOfThisMonth = monthTime.with(TemporalAdjusters.lastDayOfMonth())) : monthTime.withDayOfMonth(appointDayOfMonth);
        }
        return localDateTime;
    }

    private void copyTaskInfoSave(TaskInfoRespVO respVO) {
        ExectRecordTempRespVO recordTempRespVO;
        List recordTempList;
        TaskInfoSaveVO saveVO = TaskInfoConvert.INSTANCE.respVoToSaveVO(respVO);
        saveVO.setId(null);
        saveVO.setReleaseSign(Boolean.valueOf(false));
        saveVO.setCompleteTime(null);
        List<String> fileCodes = this.transitionStrToCodes(respVO.getFileInfo());
        saveVO.setFileCodes(fileCodes);
        if (!Objects.isNull(saveVO.getExecutTemplateCode()) && !org.springframework.util.CollectionUtils.isEmpty((Collection)(recordTempList = this.exectRecordTempService.queryByCodes(Collections.singletonList(saveVO.getExecutTemplateCode())))) && Objects.nonNull(recordTempRespVO = (ExectRecordTempRespVO)recordTempList.get(0)) && Objects.equals(recordTempRespVO.getState(), "1")) {
            saveVO.setExecutTemplateCode(null);
        }
        saveVO.setRepeatSet("N");
        saveVO.setRepeatType(null);
        saveVO.setRepeatInterval(null);
        saveVO.setAppointDay(null);
        saveVO.setRepeatStartTime(null);
        saveVO.setRepeatEndTime(null);
        saveVO.setExecutTime(null);
        saveVO.setStartTime(LocalDateTime.of(respVO.getExecutTime().toLocalDate(), LocalTime.MIN));
        long differ = TaskInfoServiceImpl.getChronoUnitBetween(respVO.getStartTime(), respVO.getEndTime(), ChronoUnit.DAYS);
        LocalDateTime endTime = respVO.getExecutTime().plusDays(differ);
        saveVO.setEndTime(LocalDateTime.of(endTime.toLocalDate(), ConstantsSale.LOCAL_TIME_MAX));
        saveVO.setCreateTime(LocalDateTime.now());
        saveVO.setModifyTime(LocalDateTime.now());
        List dtlRespVOList = this.taskInfoDtlService.selectByMasId(respVO.getId());
        List<TaskInfoDtlSaveVO> dtlSaveVOList = dtlRespVOList.stream().map(TaskInfoDtlConvert.INSTANCE::respVoToSaveVO).collect(Collectors.toList());
        dtlSaveVOList.forEach(dtlSaveVO -> {
            dtlSaveVO.setId(null);
            dtlSaveVO.setMasId(null);
            dtlSaveVO.setCompleteTime(null);
            dtlSaveVO.setExecutRecordId(null);
            dtlSaveVO.setExecutRecordCode(null);
            dtlSaveVO.setExecutRecordName(null);
            dtlSaveVO.setCreateTime(LocalDateTime.now());
            dtlSaveVO.setModifyTime(LocalDateTime.now());
        });
        saveVO.setDtlSaveVOList(dtlSaveVOList);
        List<FileInfoRespVO> fileInfoRespVOList = this.selectFileBySourceId(respVO.getId());
        if (!org.springframework.util.CollectionUtils.isEmpty(fileInfoRespVOList)) {
            List<FileInfoSaveVO> fileInfoSaveVOList = fileInfoRespVOList.stream().map(FileinfoConvert.INSTANCE::respVoToSaveVO).collect(Collectors.toList());
            fileInfoSaveVOList.forEach(fileInfoSaveVO -> {
                fileInfoSaveVO.setSourceId(null);
                fileInfoSaveVO.setId(null);
            });
            saveVO.setFileInfoSaveVOS(fileInfoSaveVOList);
        }
        this.createTask(saveVO);
    }

    public static long getChronoUnitBetween(LocalDateTime start, LocalDateTime end, ChronoUnit chronoUnit) {
        return Math.abs(start.until(end, chronoUnit));
    }

    private void updateExecutTimeById(LocalDateTime executTime, Long id) {
        this.taskInfoRepoProc.updateExecutTimeById(executTime, id);
    }

    private void updateRepeatSetById(TaskInfoSaveVO saveVO) {
        this.taskInfoRepoProc.updateRepeatSetById(saveVO);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateStateById(String state, Long id) {
        this.taskInfoRepoProc.updateStateById(state, id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateStateAndCompleteTime(String state, LocalDateTime completeTime, Long id) {
        this.taskInfoRepoProc.updateStateAndCompleteTimeById(state, completeTime, id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateProgressById(BigDecimal progress, Long id) {
        this.taskInfoRepoProc.updateProgressById(progress, id);
    }

    private SysUserDTO getSysUser() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (Objects.isNull(userDetails) || Objects.isNull(userDetails.getUser())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        SysUserDTO sysUser = userDetails.getUser();
        if (ObjectUtils.isEmpty((Object)sysUser)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7528\u6237\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
        }
        return sysUser;
    }

    private String transitionCodesToStr(List<String> codeList) {
        if (org.springframework.util.CollectionUtils.isEmpty(codeList)) {
            return null;
        }
        String codeString = codeList.stream().distinct().collect(Collectors.joining(","));
        return codeString;
    }

    private List<String> transitionStrToCodes(String codeString) {
        if (StringUtils.isEmpty((CharSequence)codeString)) {
            return Collections.emptyList();
        }
        List<String> codeList = Arrays.asList(codeString.split(","));
        return codeList;
    }

    @SysCodeProc
    public PagingVO<TaskInfoExportRespVO> exportPage(TaskInfoQueryVO pageParam) {
        PagingVO<TaskInfoExportRespVO> pagingVO = this.taskInfoRepoProc.exportPage(pageParam);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List respVOList = pagingVO.getRecords();
        this.exportTranslateTask(respVOList);
        this.exportTranslateTaskDtl(respVOList);
        this.exportTranslateAreaDtl(respVOList);
        return PagingVO.builder().total(pagingVO.getTotal()).records(respVOList).build();
    }

    public PagingVO<TaskInfoDtlRespVO> findPage(Long id) {
        TaskInfoDtlQueryVO param = new TaskInfoDtlQueryVO();
        param.setId(id);
        PagingVO page = this.taskInfoDtlService.page(param);
        return page;
    }

    private void exportTranslateTask(List<TaskInfoExportRespVO> respVOList) {
        List<String> ouCodeList = respVOList.stream().map(TaskInfoExportRespVO::getOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<OrgOuRpcDTO> ouRpcDTOList = this.rmiOrgOuService.findOuDtoListByOuCodes(ouCodeList);
        Set<Long> publishUserIdList = respVOList.stream().map(TaskInfoExportRespVO::getPublishUserId).filter(Objects::nonNull).distinct().collect(Collectors.toSet());
        List<SysEmployeeBasicDTO> employeeList = this.rmiEmployeeRpcService.findEmployeeByIds(publishUserIdList);
        List templateCodeList = respVOList.stream().map(TaskInfoExportRespVO::getExecutTemplateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List recordTempVOList = this.exectRecordTempService.queryByCodes(templateCodeList);
        respVOList.forEach(respVO -> {
            String progressStr = String.valueOf(respVO.getProgress());
            respVO.setProgressStr(progressStr + "%");
            Optional<OrgOuRpcDTO> ouRpcDTOOptional = ouRpcDTOList.stream().filter(ouRpcDTO -> Objects.equals(ouRpcDTO.getOuCode(), respVO.getOuCode())).findFirst();
            ouRpcDTOOptional.ifPresent(ouRpcDTO -> respVO.setOuName(ouRpcDTO.getOuName()));
            Optional<SysEmployeeBasicDTO> employeeDTOOptional = employeeList.stream().filter(employeeDTO -> Objects.equals(employeeDTO.getId(), respVO.getPublishUserId())).findFirst();
            employeeDTOOptional.ifPresent(employeeDTO -> respVO.setPublishUser(employeeDTO.getFullName()));
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)recordTempVOList)) {
                Optional<ExectRecordTempRespVO> recordTempOptional = recordTempVOList.stream().filter(tempRespVO -> Objects.equals(tempRespVO.getTempCode(), respVO.getExecutTemplateCode())).findFirst();
                recordTempOptional.ifPresent(tempRespVO -> respVO.setExecutTemplateName(tempRespVO.getTempName()));
            }
        });
    }

    private void exportTranslateTaskDtl(List<TaskInfoExportRespVO> dtlRespVOList) {
        List dealerCodeList = dtlRespVOList.stream().map(TaskInfoExportRespVO::getDealerCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List dealerList = this.crmCustService.getCustInfoByCustCodes(dealerCodeList);
        Set<String> executeUserCodeList = dtlRespVOList.stream().map(TaskInfoExportRespVO::getExecutUserCode).filter(Objects::nonNull).collect(Collectors.toSet());
        List<SysEmployeeBasicDTO> executeUserList = this.rmiEmployeeRpcService.findEmployeeByCodes(executeUserCodeList);
        List<Object> storeList = new ArrayList();
        List custList = new ArrayList();
        List<Object> employeeList = new ArrayList();
        Map<String, List<TaskInfoExportRespVO>> businessTypeListMap = dtlRespVOList.stream().filter(dtlRespVO -> StringUtils.isNotBlank((CharSequence)dtlRespVO.getBusinessType())).collect(Collectors.groupingBy(TaskInfoExportRespVO::getBusinessType));
        for (String key : businessTypeListMap.keySet()) {
            List<String> businessCodes = businessTypeListMap.get(key).stream().map(TaskInfoExportRespVO::getBusinessCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (Objects.equals(key, UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_STORE.getValueCode())) {
                storeList = this.rmiOrgStoreRpcService.findStoreByStoreCodes(businessCodes);
                continue;
            }
            if (Objects.equals(key, UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_DEALER.getValueCode())) {
                custList = this.crmCustService.getCustInfoByCustCodes(businessCodes);
                continue;
            }
            if (!Objects.equals(key, UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_SALESMAN.getValueCode())) continue;
            Set<String> businessCodeSet = businessCodes.stream().collect(Collectors.toSet());
            employeeList = this.rmiEmployeeRpcService.findEmployeeByCodes(businessCodeSet);
        }
        for (TaskInfoExportRespVO respVO : dtlRespVOList) {
            if (Objects.equals(respVO.getBusinessType(), UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_STORE.getValueCode())) {
                Optional<OrgStoreDetailRpcDTO> storeOptional = storeList.stream().filter(storeVO -> Objects.equals(storeVO.getStoreCode(), respVO.getBusinessCode())).findFirst();
                storeOptional.ifPresent(storeVO -> {
                    respVO.setBusinessName(storeVO.getStoreName());
                    respVO.setContactName(storeVO.getStoreManager());
                    respVO.setContactPhone(storeVO.getStoreContPhone());
                });
            }
            if (Objects.equals(respVO.getBusinessType(), UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_DEALER.getValueCode())) {
                Optional<LmSaveCustRespVO> custOptional = custList.stream().filter(custVO -> Objects.equals(custVO.getCustCode(), respVO.getBusinessCode())).findFirst();
                custOptional.ifPresent(custVO -> {
                    respVO.setBusinessName(custVO.getCustName());
                    respVO.setCustCode2(custVO.getCustCode2());
                    respVO.setContactName(custVO.getContactName());
                    respVO.setContactPhone(custVO.getContactPhone());
                });
            }
            if (Objects.equals(respVO.getBusinessType(), UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_SALESMAN.getValueCode())) {
                Optional<SysEmployeeBasicDTO> employeeOptional = employeeList.stream().filter(employeeVO -> Objects.equals(employeeVO.getCode(), respVO.getBusinessCode())).findFirst();
                employeeOptional.ifPresent(employeeVO -> {
                    respVO.setBusinessName(employeeVO.getFullName());
                    respVO.setContactName(employeeVO.getFullName());
                    respVO.setContactPhone(employeeVO.getPhone());
                });
            }
            Optional<LmSaveCustRespVO> dealerOptional = dealerList.stream().filter(dealerVO -> Objects.equals(dealerVO.getCustCode(), respVO.getDealerCode())).findFirst();
            dealerOptional.ifPresent(dealerVO -> respVO.setDealerName(dealerVO.getCustName()));
            Optional<SysEmployeeBasicDTO> executeUserOptional = executeUserList.stream().filter(executeUser -> Objects.equals(executeUser.getCode(), respVO.getExecutUserCode())).findFirst();
            executeUserOptional.ifPresent(executeUser -> respVO.setExecutUser(executeUser.getFullName()));
        }
    }

    private void exportTranslateAreaDtl(List<TaskInfoExportRespVO> dtlRespVOList) {
        Set provinces = dtlRespVOList.stream().map(TaskInfoExportRespVO::getProvince).distinct().filter(Objects::nonNull).collect(Collectors.toSet());
        Set cities = dtlRespVOList.stream().map(TaskInfoExportRespVO::getCity).distinct().filter(Objects::nonNull).collect(Collectors.toSet());
        Set counties = dtlRespVOList.stream().map(TaskInfoExportRespVO::getDistrict).distinct().filter(Objects::nonNull).collect(Collectors.toSet());
        HashSet<String> areaCodes = new HashSet<String>();
        areaCodes.addAll(provinces);
        areaCodes.addAll(cities);
        areaCodes.addAll(counties);
        List<SysAreaRespDTO> areaList = this.rmiSysAreaRpcService.findAreaByCodes(areaCodes);
        dtlRespVOList.forEach(dtlRespVO -> {
            Optional<SysAreaRespDTO> areaOptional1 = areaList.stream().filter(d -> Objects.equals(d.getAreaCode(), dtlRespVO.getProvince())).findFirst();
            areaOptional1.ifPresent(areaRespDTO -> dtlRespVO.setProvinceName(areaRespDTO.getAreaName()));
            Optional<SysAreaRespDTO> areaOptional2 = areaList.stream().filter(d -> Objects.equals(d.getAreaCode(), dtlRespVO.getCity())).findFirst();
            areaOptional2.ifPresent(areaRespDTO -> dtlRespVO.setCityName(areaRespDTO.getAreaName()));
            Optional<SysAreaRespDTO> areaOptional3 = areaList.stream().filter(d -> Objects.equals(d.getAreaCode(), dtlRespVO.getDistrict())).findFirst();
            areaOptional3.ifPresent(areaRespDTO -> dtlRespVO.setDistrictName(areaRespDTO.getAreaName()));
            StringJoiner sj = new StringJoiner("");
            if (StringUtils.isNotBlank((CharSequence)dtlRespVO.getProvinceName())) {
                sj.add(dtlRespVO.getProvinceName());
            }
            if (StringUtils.isNotBlank((CharSequence)dtlRespVO.getCityName())) {
                sj.add(dtlRespVO.getCityName());
            }
            if (StringUtils.isNotBlank((CharSequence)dtlRespVO.getDistrictName())) {
                sj.add(dtlRespVO.getDistrictName());
            }
            dtlRespVO.setRegionStr(sj.toString());
        });
    }
}

