/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.collection.IterUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.shop.BipCouponCustService;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponCustCurrentParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponQueryParam;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCouponCustVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCouponIndexVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.BipCouponCustDo;
import com.elitesland.yst.production.sale.entity.BipCouponDO;
import com.elitesland.yst.production.sale.entity.BipCouponIndexImgDO;
import com.elitesland.yst.production.sale.entity.BipCouponItemDO;
import com.elitesland.yst.production.sale.entity.BipCustUserBindDO;
import com.elitesland.yst.production.sale.entity.QBipCouponCustDo;
import com.elitesland.yst.production.sale.entity.QBipCouponDO;
import com.elitesland.yst.production.sale.entity.QBipCouponIndexImgDO;
import com.elitesland.yst.production.sale.entity.QBipCouponItemDO;
import com.elitesland.yst.production.sale.entity.QBipCustUserBindDO;
import com.elitesland.yst.production.sale.repo.shop.BipCouponCustRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCouponCustRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipCouponIndexImgRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCouponItemRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCouponRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepoProc;
import com.elitesland.yst.production.support.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BipCouponCustServiceImpl
implements BipCouponCustService {
    private static final Logger log = LoggerFactory.getLogger(BipCouponCustServiceImpl.class);
    private final BipCouponCustRepo bipCouponCustRepo;
    private final BipCouponRepo bipCouponRepo;
    private final BipCouponCustRepoProc bipCouponCustRepoProc;
    private final OrgEmpRpcService orgEmpRpcService;
    private final BipCouponItemRepo bipCouponItemRepo;
    private final BipCouponIndexImgRepo bipCouponIndexImgRepo;
    private final BipCustUserBindRepoProc bipCustUserBindRepoProc;
    private final BipCustUserBindRepo bipCustUserBindRepo;
    @Autowired
    private BipOrderService bipOrderService;

    public void deleteCouponCust(Long id) {
        Optional optional = this.bipCouponCustRepo.findById(id);
        if (optional.isPresent()) {
            BipCouponCustDo bipCouponCustDo = (BipCouponCustDo)optional.get();
            bipCouponCustDo.setDeleteFlag(1);
            bipCouponCustDo.setUseStatus(UdcEnum.SAL_COUPON_USE_STATUS_DEL.getValueCode());
            this.bipCouponCustRepo.save(bipCouponCustDo);
        }
    }

    @SysCodeProc
    public List<BipCouponCustVO> currentUserCouponCust(BipCouponCustCurrentParam param) {
        this.excuteOverDue(param.getOuId());
        ArrayList<BipCouponCustVO> list = new ArrayList<BipCouponCustVO>();
        List<BipCouponCustDo> availableList = this.getAvailableCouponCust(param.getUserId(), param);
        if (availableList == null || availableList.isEmpty()) {
            return null;
        }
        availableList.stream().forEach(available -> {
            List params;
            List<BipCouponItemDO> items;
            BipCouponDO bipCouponDO = this.getByCouponId(available.getCouponId());
            if (bipCouponDO.getState().equals(UdcEnum.SAL_COUPON_STATE_ACTIVE.getValueCode()) && null != (items = this.getItemByCouponId(available.getCouponId())) && !items.isEmpty() && null != (params = param.getList()) && !params.isEmpty()) {
                params.stream().forEach(p -> {
                    List skuIdList;
                    if (null != p.getSkuId() && !(skuIdList = items.stream().filter(x -> null != x.getSkuId()).map(BipCouponItemDO::getSkuId).collect(Collectors.toList())).isEmpty() && skuIdList.contains(p.getSkuId())) {
                        BipCouponCustVO bipCouponCustVO = new BipCouponCustVO();
                        BeanUtils.copyProperties((Object)available, (Object)bipCouponCustVO);
                        bipCouponCustVO.setValidEtime(bipCouponDO.getValidEtime());
                        bipCouponCustVO.setValidStime(bipCouponDO.getValidStime());
                        bipCouponCustVO.setState(bipCouponDO.getState());
                        bipCouponCustVO.setLimitAmt(bipCouponDO.getLimitAmt());
                        bipCouponCustVO.setFreeAmt(bipCouponDO.getFreeAmt());
                        bipCouponCustVO.setMatchType(bipCouponDO.getMatchType());
                        bipCouponCustVO.setCouponName(bipCouponDO.getCouponName());
                        bipCouponCustVO.setDetailInfo(bipCouponDO.getDetailInfo());
                        bipCouponCustVO.setType(bipCouponDO.getType());
                        list.add(bipCouponCustVO);
                        if (bipCouponDO.getType().equals(UdcEnum.SAL_COUPON_TYPE_FULL.getValueCode()) && p.getTotalAmount().compareTo(available.getLimitAmt()) == -1) {
                            list.remove(bipCouponCustVO);
                        }
                    }
                });
            }
        });
        if (null != list && !list.isEmpty()) {
            return list.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<BipCouponCustVO>(Comparator.comparing(n -> n.getCouponId()))), ArrayList::new));
        }
        return list;
    }

    public List<BipCouponItemDO> getItemByCouponId(Long couponId) {
        QBipCouponItemDO qBipCouponItemDO = QBipCouponItemDO.bipCouponItemDO;
        BooleanExpression expression = qBipCouponItemDO.couponId.eq((Object)couponId);
        Iterable iterables = this.bipCouponItemRepo.findAll((Predicate)expression);
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            return Lists.newArrayList((Iterable)iterables);
        }
        return null;
    }

    public BipCouponDO getByCouponId(Long couponId) {
        Optional optional = this.bipCouponRepo.findById(couponId);
        return (BipCouponDO)optional.get();
    }

    public List<BipCouponCustDo> getAvailableCouponCust(Long userId, BipCouponCustCurrentParam param) {
        ArrayList<BipCouponCustDo> resList = new ArrayList<BipCouponCustDo>();
        QBipCustUserBindDO qBipCustUserBindDO = QBipCustUserBindDO.bipCustUserBindDO;
        BooleanExpression e = qBipCustUserBindDO.deleteFlag.eq((Object)0).and((Predicate)qBipCustUserBindDO.userId.eq((Object)userId));
        Optional optional = this.bipCustUserBindRepo.findOne((Predicate)e);
        BipCustUserBindDO bipCustUserBindDO = new BipCustUserBindDO();
        if (optional.isPresent()) {
            bipCustUserBindDO = (BipCustUserBindDO)optional.get();
            if (null == bipCustUserBindDO.getCustId()) {
                return null;
            }
        } else {
            return null;
        }
        QBipCouponCustDo qBipCouponCustDo = QBipCouponCustDo.bipCouponCustDo;
        BooleanExpression expression = qBipCouponCustDo.userId.eq((Object)userId).and((Predicate)qBipCouponCustDo.useStatus.eq((Object)UdcEnum.SAL_COUPON_USE_STATUS_NOTUSED.getValueCode())).and((Predicate)qBipCouponCustDo.deleteFlag.eq((Object)0)).and((Predicate)qBipCouponCustDo.custId.eq((Object)bipCustUserBindDO.getCustId()));
        Iterable iterables = this.bipCouponCustRepo.findAll((Predicate)expression);
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            ArrayList list = Lists.newArrayList((Iterable)iterables);
            list.stream().forEach(cust -> resList.add((BipCouponCustDo)cust));
            return resList;
        }
        return null;
    }

    public List<BipCouponItemDO> getCouponItemByCouponId(Long couponId) {
        QBipCouponItemDO qBipCouponItemDO = QBipCouponItemDO.bipCouponItemDO;
        BooleanExpression expression = qBipCouponItemDO.couponId.eq((Object)couponId);
        Iterable iterables = this.bipCouponItemRepo.findAll((Predicate)expression);
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            return Lists.newArrayList((Iterable)iterables);
        }
        return null;
    }

    public void paySuccessUpdateCouponStatus(Long id, String status) {
        Optional optional = this.bipCouponCustRepo.findById(id);
        if (optional.isPresent()) {
            BipCouponCustDo bipCouponCustDo = (BipCouponCustDo)optional.get();
            bipCouponCustDo.setUseStatus(status);
            this.bipCouponCustRepo.save(bipCouponCustDo);
        }
    }

    public void modifyCouponCustUseStatus(Long id, String status) {
        Optional optional = this.bipCouponCustRepo.findById(id);
        if (optional.isPresent()) {
            BipCouponCustDo bipCouponCustDo = (BipCouponCustDo)optional.get();
            bipCouponCustDo.setUseStatus(status);
            this.bipCouponCustRepo.save(bipCouponCustDo);
        }
    }

    public void modifyOrderCouponCustUseStatus(Long couponId, String status) {
        CurrentUserDTO user = UserService.currentUser();
        if (null != user && null != user.getUserId()) {
            QBipCouponCustDo qBipCouponCustDo = QBipCouponCustDo.bipCouponCustDo;
            BooleanExpression expression = qBipCouponCustDo.couponId.eq((Object)couponId).and((Predicate)qBipCouponCustDo.userId.eq((Object)user.getUserId()));
            Iterable iterables = this.bipCouponCustRepo.findAll((Predicate)expression);
            if (!IterUtil.isEmpty((Iterable)iterables)) {
                ArrayList list = Lists.newArrayList((Iterable)iterables);
                list.stream().forEach(l -> {
                    l.setUseStatus(status);
                    this.bipCouponCustRepo.save(l);
                });
            }
        }
    }

    @SysCodeProc
    public BipCouponIndexVO indexPageShow() {
        OrgUserEmpInfoRpcDTO empInfo = this.getCurrentOuIdInfo();
        this.excuteOverDueByUserId(empInfo.getUserId());
        ArrayList resList = new ArrayList();
        BipCouponIndexVO bipCouponIndexVO = new BipCouponIndexVO();
        QBipCustUserBindDO qBipCustUserBindDO = QBipCustUserBindDO.bipCustUserBindDO;
        BooleanExpression e = qBipCustUserBindDO.deleteFlag.eq((Object)0).and((Predicate)qBipCustUserBindDO.userId.eq((Object)empInfo.getUserId()));
        Optional optional = this.bipCustUserBindRepo.findOne((Predicate)e);
        BipCustUserBindDO bipCustUserBindDO = new BipCustUserBindDO();
        if (optional.isPresent()) {
            bipCustUserBindDO = (BipCustUserBindDO)optional.get();
            if (null == bipCustUserBindDO.getCustId()) {
                return null;
            }
        } else {
            return null;
        }
        QBipCouponCustDo qBipCouponCustDo = QBipCouponCustDo.bipCouponCustDo;
        BooleanExpression expression = qBipCouponCustDo.userId.eq((Object)empInfo.getUserId()).and((Predicate)qBipCouponCustDo.useStatus.eq((Object)UdcEnum.SAL_COUPON_USE_STATUS_NOTUSED.getValueCode())).and((Predicate)qBipCouponCustDo.deleteFlag.eq((Object)0)).and((Predicate)qBipCouponCustDo.custId.eq((Object)bipCustUserBindDO.getCustId()));
        Iterable iterables = this.bipCouponCustRepo.findAll((Predicate)expression);
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            ArrayList list = Lists.newArrayList((Iterable)iterables);
            List<BipCouponCustDo> notUseList = this.getNotUseCoupon(list);
            LocalDateTime now = LocalDateTime.now();
            if (!notUseList.isEmpty()) {
                notUseList.stream().forEach(notList -> {
                    BipCouponDO bipCouponDO = this.getByCouponId(notList.getCouponId());
                    if (null != bipCouponDO.getNotifyDays() && null != bipCouponDO.getValidEtime()) {
                        Integer notifyDays = bipCouponDO.getNotifyDays();
                        LocalDateTime validETime = bipCouponDO.getValidEtime();
                        LocalDateTime remindTime = validETime.minusDays(notifyDays.intValue());
                        if (now.isAfter(remindTime) && now.isBefore(validETime)) {
                            BipCouponCustVO bipCouponCustVO = new BipCouponCustVO();
                            BeanUtils.copyProperties((Object)notList, (Object)bipCouponCustVO);
                            bipCouponCustVO.setValidEtime(bipCouponDO.getValidEtime());
                            bipCouponCustVO.setValidStime(bipCouponDO.getValidStime());
                            bipCouponCustVO.setState(bipCouponDO.getState());
                            bipCouponCustVO.setLimitAmt(bipCouponDO.getLimitAmt());
                            bipCouponCustVO.setFreeAmt(bipCouponDO.getFreeAmt());
                            bipCouponCustVO.setMatchType(bipCouponDO.getMatchType());
                            bipCouponCustVO.setCouponName(bipCouponDO.getCouponName());
                            bipCouponCustVO.setDetailInfo(bipCouponDO.getDetailInfo());
                            bipCouponCustVO.setType(bipCouponDO.getType());
                            resList.add(bipCouponCustVO);
                        }
                    }
                });
            }
        }
        if (!resList.isEmpty()) {
            bipCouponIndexVO.setCouponList(resList);
        }
        return bipCouponIndexVO;
    }

    public BipCouponIndexImgDO getIndexImgByOuId(Long ouId) {
        QBipCouponIndexImgDO qBipCouponIndexImgDO = QBipCouponIndexImgDO.bipCouponIndexImgDO;
        BooleanExpression expression = qBipCouponIndexImgDO.ouId.eq((Object)ouId).and((Predicate)qBipCouponIndexImgDO.deleteFlag.eq((Object)0));
        Optional optional = this.bipCouponIndexImgRepo.findOne((Predicate)expression);
        if (optional.isPresent()) {
            return (BipCouponIndexImgDO)optional.get();
        }
        return null;
    }

    public List<BipCouponCustDo> getNotUseCoupon(List<BipCouponCustDo> list) {
        ArrayList<BipCouponCustDo> resList = new ArrayList<BipCouponCustDo>();
        list.stream().forEach(l -> {
            BipCouponDO bipCouponDO;
            Integer notifyDays;
            Long couponId = l.getCouponId();
            Optional optional = this.bipCouponRepo.findById(couponId);
            if (optional.isPresent() && null != (notifyDays = (bipCouponDO = (BipCouponDO)optional.get()).getNotifyDays())) {
                LocalDateTime notifyDateTime = bipCouponDO.getValidEtime();
                Duration duration = Duration.between(LocalDateTime.now(), notifyDateTime);
                long days = duration.toDays();
                if (days >= 0L && days <= (long)notifyDays.intValue()) {
                    resList.add((BipCouponCustDo)l);
                }
            }
        });
        return resList;
    }

    @SysCodeProc
    public PagingVO<BipCouponCustVO> pageSearch(BipCouponQueryParam param) {
        OrgUserEmpInfoRpcDTO empInfo = this.getCurrentEmpInfo();
        if (null == empInfo.getOuId()) {
            return new PagingVO();
        }
        this.excuteOverDue(empInfo.getOuId());
        PagingVO<BipCouponCustVO> pagingVO = this.bipCouponCustRepoProc.pageSearch(param);
        List list = pagingVO.getRecords();
        list.stream().forEach(l -> {
            BipCouponDO couponDO = this.getCouponStateByCouponId(l.getCouponId());
            if (null != couponDO) {
                l.setDetailInfo(StringUtils.isNotBlank((CharSequence)couponDO.getDetailInfo()) ? couponDO.getDetailInfo() : null);
                l.setLimitAmt(couponDO.getLimitAmt() != null ? couponDO.getLimitAmt() : null);
                l.setFreeAmt(couponDO.getFreeAmt() != null ? couponDO.getFreeAmt() : null);
                l.setMatchType(StringUtils.isNotBlank((CharSequence)couponDO.getMatchType()) ? couponDO.getMatchType() : null);
                l.setType(StringUtils.isNotBlank((CharSequence)couponDO.getType()) ? couponDO.getType() : null);
                l.setValidEtime(couponDO.getValidEtime() != null ? couponDO.getValidEtime() : null);
                l.setValidStime(couponDO.getValidStime() != null ? couponDO.getValidStime() : null);
                l.setState(couponDO.getState() != null ? couponDO.getState() : null);
            }
        });
        pagingVO.setRecords(list);
        return pagingVO;
    }

    public BipCouponDO getCouponStateByCouponId(Long id) {
        Optional optional = this.bipCouponRepo.findById(id);
        if (optional.isPresent()) {
            return (BipCouponDO)optional.get();
        }
        return null;
    }

    @SysCodeProc
    public List<BipCouponCustVO> searchCouponCust(String useStatus, Long userId) {
        BipCustUserBindDO bipCustUserBindDO;
        this.excuteOverDueByUserId(userId);
        QBipCustUserBindDO qBipCustUserBindDO = QBipCustUserBindDO.bipCustUserBindDO;
        BooleanExpression e = qBipCustUserBindDO.deleteFlag.eq((Object)0).and((Predicate)qBipCustUserBindDO.userId.eq((Object)userId));
        Optional option = this.bipCustUserBindRepo.findOne((Predicate)e);
        if (!option.isEmpty() && null != (bipCustUserBindDO = (BipCustUserBindDO)option.get()).getCustId()) {
            QBipCouponCustDo qBipCouponCustDo = QBipCouponCustDo.bipCouponCustDo;
            BooleanExpression expression = qBipCouponCustDo.useStatus.eq((Object)useStatus).and((Predicate)qBipCouponCustDo.userId.eq((Object)userId)).and((Predicate)qBipCouponCustDo.custId.eq((Object)bipCustUserBindDO.getCustId())).and((Predicate)qBipCouponCustDo.deleteFlag.eq((Object)0));
            Iterable iterables = this.bipCouponCustRepo.findAll((Predicate)expression);
            if (!IterUtil.isEmpty((Iterable)iterables)) {
                ArrayList<BipCouponCustVO> resList = new ArrayList<BipCouponCustVO>();
                ArrayList list = Lists.newArrayList((Iterable)iterables);
                list.stream().forEach(l -> {
                    Optional optional = this.bipCouponRepo.findById(l.getCouponId());
                    if (optional.isPresent() && ((BipCouponDO)optional.get()).getState().equals(UdcEnum.SAL_COUPON_STATE_ACTIVE.getValueCode())) {
                        BipCouponDO bipCouponDO = (BipCouponDO)optional.get();
                        BipCouponCustVO vo = new BipCouponCustVO();
                        BeanUtils.copyProperties((Object)l, (Object)vo);
                        vo.setDetailInfo(bipCouponDO.getDetailInfo());
                        vo.setFreeAmt(bipCouponDO.getFreeAmt());
                        vo.setLimitAmt(bipCouponDO.getLimitAmt());
                        vo.setMatchType(bipCouponDO.getMatchType());
                        vo.setValidStime(bipCouponDO.getValidStime());
                        vo.setValidEtime(bipCouponDO.getValidEtime());
                        vo.setState(bipCouponDO.getState());
                        vo.setCouponName(bipCouponDO.getCouponName());
                        resList.add(vo);
                    }
                });
                return resList;
            }
        }
        return null;
    }

    public void newUserReceiveCoupon() {
        CurrentUserDTO currentUser;
        Boolean isPay;
        OrgUserEmpInfoRpcDTO empInfo = this.getCurrentOuIdInfo();
        Long ouId = empInfo.getOuId();
        if (null == ouId) {
            return;
        }
        BipCustUserBindDO bipCustUserBindDO = new BipCustUserBindDO();
        if (null != empInfo.getUserId()) {
            QBipCustUserBindDO qBipCustUserBindDO = QBipCustUserBindDO.bipCustUserBindDO;
            BooleanExpression e = qBipCustUserBindDO.deleteFlag.eq((Object)0).and((Predicate)qBipCustUserBindDO.userId.eq((Object)empInfo.getUserId()));
            Optional optional = this.bipCustUserBindRepo.findOne((Predicate)e);
            if (optional.isPresent()) {
                bipCustUserBindDO = (BipCustUserBindDO)optional.get();
                if (null == bipCustUserBindDO.getCustId()) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u672a\u7ed1\u5b9a\u5ba2\u6237\uff0c\u4e0d\u80fd\u9886\u53d6\u4f18\u60e0\u5238");
                }
            } else {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u672a\u7ed1\u5b9a\u5ba2\u6237\uff0c\u4e0d\u80fd\u9886\u53d6\u4f18\u60e0\u5238");
            }
        }
        if (!(isPay = this.bipOrderService.isFirstOrder((currentUser = UserService.currentUser()).getUserId(), "ps")).booleanValue()) {
            QBipCouponDO qBipCouponDO = QBipCouponDO.bipCouponDO;
            BooleanExpression expression = qBipCouponDO.deleteFlag.eq((Object)0).and((Predicate)qBipCouponDO.ouId.eq((Object)ouId)).and((Predicate)qBipCouponDO.newCustShow.eq((Object)"1")).and((Predicate)qBipCouponDO.newCustStime.gt((Comparable)LocalDateTime.now())).and((Predicate)qBipCouponDO.newCustEtime.lt((Comparable)LocalDateTime.now()));
            Iterable iterables = this.bipCouponRepo.findAll((Predicate)expression);
            if (!IterUtil.isEmpty((Iterable)iterables)) {
                ArrayList list = Lists.newArrayList((Iterable)iterables);
                BipCustUserBindDO finalBipCustUserBindDO = bipCustUserBindDO;
                list.stream().forEach(bipCouponDO -> {
                    if (!this.isReceiveCouponCust(bipCouponDO.getId(), currentUser.getUserId(), ouId).booleanValue()) {
                        BipCouponCustDo bipCouponCustDo = new BipCouponCustDo();
                        BeanUtils.copyProperties((Object)bipCouponDO, (Object)bipCouponCustDo);
                        bipCouponCustDo.setCouponId(bipCouponDO.getId());
                        bipCouponCustDo.setUserId(empInfo.getUserId());
                        bipCouponCustDo.setUserName(empInfo.getUserName());
                        bipCouponCustDo.setUseStatus(UdcEnum.SAL_COUPON_USE_STATUS_NOTUSED.getValueCode());
                        bipCouponCustDo.setCustId(finalBipCustUserBindDO.getCustId());
                        bipCouponCustDo.setCustName(finalBipCustUserBindDO.getCustName());
                        bipCouponCustDo.setCustCode(finalBipCustUserBindDO.getCustCode());
                        bipCouponCustDo.setId(null);
                        this.bipCouponCustRepo.save(bipCouponCustDo);
                        bipCouponDO.setTotalNum(bipCouponDO.getTotalNum() - 1L);
                        bipCouponDO.setReceiveNum(bipCouponDO.getReceiveNum() + 1);
                        this.bipCouponRepo.save(bipCouponDO);
                    }
                });
            }
        }
    }

    public Boolean isReceiveCouponCust(Long couponId, Long userId, Long ouId) {
        QBipCouponCustDo qBipCouponCustDo = QBipCouponCustDo.bipCouponCustDo;
        BooleanExpression expression = qBipCouponCustDo.couponId.eq((Object)couponId).and((Predicate)qBipCouponCustDo.userId.eq((Object)userId)).and((Predicate)qBipCouponCustDo.ouId.eq((Object)ouId));
        Long count = this.bipCouponCustRepo.count((Predicate)expression);
        if (count > 0L) {
            return true;
        }
        return false;
    }

    public void excuteOverDue(Long ouId) {
        QBipCouponCustDo qBipCouponCustDo = QBipCouponCustDo.bipCouponCustDo;
        BooleanExpression expression = qBipCouponCustDo.ouId.eq((Object)ouId).and((Predicate)qBipCouponCustDo.useStatus.eq((Object)"NOTUSED")).and((Predicate)qBipCouponCustDo.deleteFlag.eq((Object)0));
        Iterable iterables = this.bipCouponCustRepo.findAll((Predicate)expression);
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            ArrayList list = Lists.newArrayList((Iterable)iterables);
            list.stream().forEach(l -> {
                Long couponId = l.getCouponId();
                Optional optional = this.bipCouponRepo.findById(couponId);
                if (optional.isPresent()) {
                    BipCouponDO bipCouponDO = (BipCouponDO)optional.get();
                    LocalDateTime validEtime = bipCouponDO.getValidEtime();
                    l.setValidStime(bipCouponDO.getValidStime());
                    l.setValidEtime(validEtime);
                    if (LocalDateTime.now().isAfter(validEtime)) {
                        l.setUseStatus(UdcEnum.SAL_COUPON_USE_STATUS_OVERDUE.getValueCode());
                    }
                    this.bipCouponCustRepo.save(l);
                }
            });
        }
    }

    public void excuteOverDueByUserId(Long userId) {
        QBipCouponCustDo qBipCouponCustDo = QBipCouponCustDo.bipCouponCustDo;
        BooleanExpression expression = qBipCouponCustDo.userId.eq((Object)userId).and((Predicate)qBipCouponCustDo.useStatus.eq((Object)"NOTUSED")).and((Predicate)qBipCouponCustDo.deleteFlag.eq((Object)0));
        Iterable iterables = this.bipCouponCustRepo.findAll((Predicate)expression);
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            ArrayList list = Lists.newArrayList((Iterable)iterables);
            list.stream().forEach(l -> {
                Long couponId = l.getCouponId();
                Optional optional = this.bipCouponRepo.findById(couponId);
                if (optional.isPresent()) {
                    BipCouponDO bipCouponDO = (BipCouponDO)optional.get();
                    LocalDateTime validEtime = bipCouponDO.getValidEtime();
                    l.setValidEtime(validEtime);
                    l.setValidStime(bipCouponDO.getValidStime());
                    if (LocalDateTime.now().isAfter(validEtime)) {
                        l.setUseStatus(UdcEnum.SAL_COUPON_USE_STATUS_OVERDUE.getValueCode());
                        this.bipCouponCustRepo.save(l);
                    }
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> receiveCoupon(List<Long> ids) {
        OrgUserEmpInfoRpcDTO empInfo = this.getCurrentOuIdInfo();
        BipCustUserBindDO bipCustUserBindDO = new BipCustUserBindDO();
        if (null != empInfo.getUserId()) {
            QBipCustUserBindDO qBipCustUserBindDO = QBipCustUserBindDO.bipCustUserBindDO;
            BooleanExpression e = qBipCustUserBindDO.deleteFlag.eq((Object)0).and((Predicate)qBipCustUserBindDO.userId.eq((Object)empInfo.getUserId()));
            Optional optional = this.bipCustUserBindRepo.findOne((Predicate)e);
            if (optional.isPresent()) {
                bipCustUserBindDO = (BipCustUserBindDO)optional.get();
                if (null == bipCustUserBindDO.getCustId()) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u672a\u7ed1\u5b9a\u5ba2\u6237\uff0c\u4e0d\u80fd\u9886\u53d6\u4f18\u60e0\u5238");
                }
            } else {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u672a\u7ed1\u5b9a\u5ba2\u6237\uff0c\u4e0d\u80fd\u9886\u53d6\u4f18\u60e0\u5238");
            }
        }
        log.error("\u9886\u53d6\u4f18\u60e0\u5238ID\uff1a" + JSON.toJSONString(ids));
        for (Long id : ids) {
            Long totalNum;
            BipCouponDO bipCouponDO = this.getCouponById(id);
            if (null == bipCouponDO || (totalNum = bipCouponDO.getTotalNum()) <= 0L) continue;
            LocalDateTime now = LocalDateTime.now();
            if (bipCouponDO.getReceiveValidStime().isBefore(now) && bipCouponDO.getReceiveValidEtime().isAfter(now)) {
                BipCouponCustDo custDo = this.getByUserIdAndCouponId(empInfo.getUserId(), id);
                if (null != custDo) continue;
                BipCouponCustDo bipCouponCustDo = new BipCouponCustDo();
                BeanUtils.copyProperties((Object)bipCouponDO, (Object)bipCouponCustDo);
                bipCouponCustDo.setCouponId(bipCouponDO.getId());
                bipCouponCustDo.setUserId(empInfo.getUserId());
                bipCouponCustDo.setCustId(bipCustUserBindDO.getCustId());
                bipCouponCustDo.setCustCode(bipCustUserBindDO.getCustCode());
                bipCouponCustDo.setCustName(bipCustUserBindDO.getCustName());
                bipCouponCustDo.setUserName(empInfo.getUserName());
                bipCouponCustDo.setUseStatus(UdcEnum.SAL_COUPON_USE_STATUS_NOTUSED.getValueCode());
                bipCouponCustDo.setSecBuId(bipCouponDO.getSecBuId());
                bipCouponCustDo.setSecUserId(bipCouponDO.getSecUserId());
                bipCouponCustDo.setSecOuId(bipCouponDO.getOuId());
                bipCouponCustDo.setId(null);
                this.bipCouponCustRepo.save(bipCouponCustDo);
                bipCouponDO.setTotalNum(bipCouponDO.getTotalNum() - 1L);
                bipCouponDO.setReceiveNum(bipCouponDO.getReceiveNum() + 1);
                this.bipCouponRepo.save(bipCouponDO);
                continue;
            }
            throw new BusinessException("\u8be5\u4f18\u60e0\u5238\u5df2\u8d85\u51fa\u9886\u53d6\u65f6\u95f4");
        }
        return ApiResult.ok();
    }

    public BipCouponCustDo getByUserIdAndCouponId(Long userId, Long couponId) {
        QBipCouponCustDo qBipCouponCustDo = QBipCouponCustDo.bipCouponCustDo;
        BooleanExpression expression = qBipCouponCustDo.couponId.eq((Object)couponId).and((Predicate)qBipCouponCustDo.userId.eq((Object)userId)).and((Predicate)qBipCouponCustDo.deleteFlag.eq((Object)0));
        Optional optional = this.bipCouponCustRepo.findOne((Predicate)expression);
        if (optional.isEmpty()) {
            return null;
        }
        return (BipCouponCustDo)optional.get();
    }

    public BipCouponDO getCouponById(Long id) {
        Optional optional = this.bipCouponRepo.findById(id);
        if (optional.isEmpty()) {
            return null;
        }
        return (BipCouponDO)optional.get();
    }

    private OrgUserEmpInfoRpcDTO getCurrentEmpInfo() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u5df2\u5931\u6548,\u8bf7\u91cd\u767b\u5f55\u91cd\u8bd5");
        }
        OrgUserEmpInfoRpcDTO userEmpInfo = this.orgEmpRpcService.findUserEmpInfo(currentUser.getUserId());
        if (userEmpInfo == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f");
        }
        return userEmpInfo;
    }

    private OrgUserEmpInfoRpcDTO getCurrentOuIdInfo() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u5df2\u5931\u6548,\u8bf7\u91cd\u767b\u5f55\u91cd\u8bd5");
        }
        BipCustUserBindDO bipCustUserBindDO = this.bipCustUserBindRepoProc.getByUserId(currentUser.getUserId());
        if (bipCustUserBindDO == null || bipCustUserBindDO.getOuId() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u672a\u7ed1\u5b9a\u516c\u53f8");
        }
        OrgUserEmpInfoRpcDTO userEmpInfo = new OrgUserEmpInfoRpcDTO();
        userEmpInfo.setOuId(bipCustUserBindDO.getOuId());
        userEmpInfo.setUserId(currentUser.getUserId());
        userEmpInfo.setUserName(currentUser.getUserName());
        return userEmpInfo;
    }

    public BipCouponCustServiceImpl(BipCouponCustRepo bipCouponCustRepo, BipCouponRepo bipCouponRepo, BipCouponCustRepoProc bipCouponCustRepoProc, OrgEmpRpcService orgEmpRpcService, BipCouponItemRepo bipCouponItemRepo, BipCouponIndexImgRepo bipCouponIndexImgRepo, BipCustUserBindRepoProc bipCustUserBindRepoProc, BipCustUserBindRepo bipCustUserBindRepo) {
        this.bipCouponCustRepo = bipCouponCustRepo;
        this.bipCouponRepo = bipCouponRepo;
        this.bipCouponCustRepoProc = bipCouponCustRepoProc;
        this.orgEmpRpcService = orgEmpRpcService;
        this.bipCouponItemRepo = bipCouponItemRepo;
        this.bipCouponIndexImgRepo = bipCouponIndexImgRepo;
        this.bipCustUserBindRepoProc = bipCustUserBindRepoProc;
        this.bipCustUserBindRepo = bipCustUserBindRepo;
    }
}

