/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.el.coordinator.core.common.api.ApiResult;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.sale.api.service.shop.BipCustUserBindService;
import com.elitesland.yst.production.sale.api.service.shop.BipItemCategoryService;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemCategoryRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.ItemCatTreeAllRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.ItemCatTreeRespVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemCategorySaveVO;
import com.elitesland.yst.production.sale.convert.shop.BipItemCategoryConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.util.TreeDataUtil;
import com.elitesland.yst.production.sale.entity.BipItemCategoryDO;
import com.elitesland.yst.production.sale.repo.shop.BipItemCategoryRepo;
import com.elitesland.yst.production.sale.repo.shop.BipItemCategoryRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemRepoProc;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Valid
public class BipItemCategoryServiceImpl
extends BaseServiceImpl
implements BipItemCategoryService {
    private static final Logger log = LoggerFactory.getLogger(BipItemCategoryServiceImpl.class);
    private final BipItemCategoryRepo itemCategoryRepo;
    private final BipItemCategoryRepoProc itemCategoryRepoProc;
    private final BipItemRepoProc itemRepoProc;
    @Autowired
    private BipCustUserBindService bipCustUserBindService;
    private static final BipItemCategoryConvert CONVERT = BipItemCategoryConvert.INSTANCE;
    private static final long ROOT = -1L;
    private static final String CACHE_NAME = "yst_sale_item_cat";
    private static final String CACHE_KEY_TREE = "'tree'";

    @CacheEvict(value={"yst_sale_item_cat"}, allEntries=true, condition="#result.success")
    @Transactional(rollbackFor={Exception.class})
    public com.elitescloud.cloudt.common.base.ApiResult<Long> save(BipItemCategorySaveVO saveVO) {
        try {
            this.validateForSave(saveVO, null);
        }
        catch (IllegalArgumentException e) {
            log.info("\u4fdd\u5b58\u5546\u54c1\u5206\u7c7b\u6821\u9a8c\u4e0d\u901a\u8fc7", (Throwable)e);
            return com.elitescloud.cloudt.common.base.ApiResult.fail((String)("\u4fdd\u5b58\u5931\u8d25\uff0c" + e.getMessage()));
        }
        BipItemCategoryDO doo = CONVERT.vo2DO(saveVO);
        this.fillLevel(doo);
        this.itemCategoryRepo.save(doo);
        return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)doo.getId());
    }

    @CacheEvict(value={"yst_sale_item_cat"}, allEntries=true, condition="#result.success")
    @Transactional(rollbackFor={Exception.class})
    public com.elitescloud.cloudt.common.base.ApiResult<Long> update(BipItemCategorySaveVO saveVO, Long id) {
        try {
            this.validateForSave(saveVO, id);
        }
        catch (IllegalArgumentException e) {
            log.info("\u4fee\u6539\u5546\u54c1\u5206\u7c7b\u6821\u9a8c\u4e0d\u901a\u8fc7", (Throwable)e);
            return com.elitescloud.cloudt.common.base.ApiResult.fail((String)("\u4fee\u6539\u5931\u8d25\uff0c" + e.getMessage()));
        }
        BipItemCategoryDO category = (BipItemCategoryDO)this.itemCategoryRepo.findById(id).orElseThrow(new BusinessException("\u5206\u7c7b\u4e0d\u5b58\u5728"));
        CONVERT.copyVO2DO(saveVO, category);
        if (category.getLevel() == null) {
            this.fillLevel(category);
        }
        this.itemCategoryRepo.save(category);
        if (!StrUtil.equals((CharSequence)category.getName(), (CharSequence)saveVO.getName())) {
            this.itemRepoProc.updateCategoryName(id, category.getName(), category.getLevel());
        }
        return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)id);
    }

    @CacheEvict(value={"yst_sale_item_cat"}, allEntries=true, condition="#result.success")
    @Transactional(rollbackFor={Exception.class})
    public com.elitescloud.cloudt.common.base.ApiResult<Long> updateEnable(Long id) {
        Boolean enable = this.itemCategoryRepoProc.getEnable(id);
        this.itemCategoryRepoProc.updateEnable(id, !Boolean.TRUE.equals(enable));
        return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)id);
    }

    @CacheEvict(value={"yst_sale_item_cat"}, allEntries=true, condition="#result.success")
    @Transactional(rollbackFor={Exception.class})
    public com.elitescloud.cloudt.common.base.ApiResult<Long> delete(Long id) {
        boolean exists = this.itemCategoryRepoProc.existsById(id);
        if (!exists) {
            return com.elitescloud.cloudt.common.base.ApiResult.fail((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        exists = this.itemCategoryRepoProc.existsByPid(id);
        if (exists) {
            return com.elitescloud.cloudt.common.base.ApiResult.fail((String)"\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u5148\u5220\u9664\u4e0b\u7ea7\u5206\u7c7b");
        }
        Integer level = this.itemCategoryRepoProc.getLevel(id);
        exists = this.itemRepoProc.existsByCategoryId(id, level);
        if (exists) {
            return com.elitescloud.cloudt.common.base.ApiResult.fail((String)"\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u5148\u5220\u9664\u5206\u7c7b\u4e0b\u7684\u5546\u54c1");
        }
        this.itemCategoryRepoProc.delete(id);
        return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)id);
    }

    public com.elitescloud.cloudt.common.base.ApiResult<BipItemCategoryRespVO> get(Long id) {
        BipItemCategoryDO doo = this.itemCategoryRepo.findById(id).orElse(null);
        if (doo == null) {
            return com.elitescloud.cloudt.common.base.ApiResult.fail((String)"\u5546\u54c1\u5206\u7c7b\u4e0d\u5b58\u5728");
        }
        BipItemCategoryRespVO respVO = CONVERT.do2VO(doo);
        if (respVO.getPid() == -1L) {
            respVO.setPName("");
        } else {
            respVO.setPName(this.itemCategoryRepoProc.getName(respVO.getPid()));
        }
        if (StrUtil.isNotBlank((CharSequence)respVO.getPicFileCode())) {
            ApiResult picResult = this.fileService.get(respVO.getPicFileCode());
            if (!picResult.isSuccess()) {
                log.error("\u83b7\u53d6\u5206\u7c7b\u56fe\u7247\u5931\u8d25\uff1a{}", (Object)picResult.getMsg());
            }
            respVO.setPicFileInfo((FileObjRespVO)picResult.getData());
        }
        return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)respVO);
    }

    public com.elitescloud.cloudt.common.base.ApiResult<List<ItemCatTreeAllRespVO>> treeAll() {
        List doList = this.itemCategoryRepo.findAll();
        if (doList.isEmpty()) {
            return com.elitescloud.cloudt.common.base.ApiResult.ok(Collections.emptyList());
        }
        List<ItemCatTreeAllRespVO> respVOList = this.do2TreeAll(doList);
        return com.elitescloud.cloudt.common.base.ApiResult.ok(respVOList);
    }

    public com.elitescloud.cloudt.common.base.ApiResult<List<ItemCatTreeAllRespVO>> treeAll(Long ouId) {
        if (ouId == null) {
            return com.elitescloud.cloudt.common.base.ApiResult.ok(Collections.emptyList());
        }
        List<BipItemCategoryDO> doList = this.itemCategoryRepoProc.queryByOuId(ouId);
        if (doList.isEmpty()) {
            return com.elitescloud.cloudt.common.base.ApiResult.ok(Collections.emptyList());
        }
        List<ItemCatTreeAllRespVO> respVOList = this.do2TreeAll(doList);
        return com.elitescloud.cloudt.common.base.ApiResult.ok(respVOList);
    }

    @Cacheable(value={"yst_sale_item_cat"}, keyGenerator="currentUserCustOuIdKeyGenerator")
    public com.elitescloud.cloudt.common.base.ApiResult<List<ItemCatTreeRespVO>> treeOfOu(Long ouId) {
        return null;
    }

    @Cacheable(value={"yst_sale_item_cat"}, key="'tree'")
    public com.elitescloud.cloudt.common.base.ApiResult<List<ItemCatTreeRespVO>> tree() {
        List<BipItemCategoryDO> doList = this.itemCategoryRepo.findAll().stream().filter(BipItemCategoryDO::getEnable).collect(Collectors.toList());
        if (doList.isEmpty()) {
            return com.elitescloud.cloudt.common.base.ApiResult.ok(Collections.emptyList());
        }
        List<ItemCatTreeRespVO> respVOList = this.do2Tree(doList);
        return com.elitescloud.cloudt.common.base.ApiResult.ok(respVOList);
    }

    private List<ItemCatTreeRespVO> do2Tree(List<BipItemCategoryDO> doList) {
        List<ItemCatTreeRespVO> respVOList = CONVERT.do2TreeVO(doList);
        TreeDataUtil<ItemCatTreeRespVO> treeDataUtil = new TreeDataUtil<ItemCatTreeRespVO>(respVOList, ItemCatTreeRespVO::getId, ItemCatTreeRespVO::getPid, ItemCatTreeRespVO::setChildren, Comparator.comparingInt(ItemCatTreeRespVO::getSortNo));
        return treeDataUtil.getRoots().stream().filter(t -> t.getPid() == -1L).collect(Collectors.toList());
    }

    private List<ItemCatTreeAllRespVO> do2TreeAll(List<BipItemCategoryDO> doList) {
        List<ItemCatTreeAllRespVO> respVOList = CONVERT.do2TreeAllVO(doList);
        TreeDataUtil<ItemCatTreeAllRespVO> treeDataUtil = new TreeDataUtil<ItemCatTreeAllRespVO>(respVOList, ItemCatTreeAllRespVO::getId, ItemCatTreeAllRespVO::getPid, ItemCatTreeAllRespVO::setChildren, Comparator.comparingInt(ItemCatTreeAllRespVO::getSortNo));
        return treeDataUtil.getRoots().stream().filter(t -> t.getPid() == -1L).collect(Collectors.toList());
    }

    private void validateForSave(BipItemCategorySaveVO saveVO, Long id) {
        boolean isAdd = id == null;
        boolean exists = false;
        if (!isAdd) {
            exists = this.itemCategoryRepoProc.existsById(id);
            Assert.isTrue((boolean)exists, (String)"\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        saveVO.setPid((Long)ObjectUtil.defaultIfNull((Object)saveVO.getPid(), (Object)-1L));
        if (saveVO.getPid() != null && saveVO.getPid() != -1L) {
            exists = this.itemCategoryRepoProc.existsById(saveVO.getPid());
            Assert.isTrue((boolean)exists, (String)"\u4e0a\u7ea7\u5206\u7c7b\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        if (!isAdd) {
            Long pidOld = this.itemCategoryRepoProc.getPid(id);
            Assert.isTrue((pidOld.longValue() == saveVO.getPid().longValue() ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u5206\u7c7b\u4e0d\u53ef\u4fee\u6539", (Object[])new Object[0]);
        }
        exists = isAdd ? this.itemCategoryRepoProc.existsByCode(saveVO.getCode()) : this.itemCategoryRepoProc.existsByCode(saveVO.getCode(), id);
        Assert.isFalse((boolean)exists, (String)"\u7f16\u53f7\u5df2\u5b58\u5728", (Object[])new Object[0]);
        exists = saveVO.getPid() == -1L ? (isAdd ? this.itemCategoryRepoProc.existsBySortNo(saveVO.getOuId(), saveVO.getPid(), saveVO.getSortNo()) : this.itemCategoryRepoProc.existsBySortNo(saveVO.getOuId(), saveVO.getPid(), saveVO.getSortNo(), id)) : (isAdd ? this.itemCategoryRepoProc.existsBySortNo(saveVO.getPid(), saveVO.getSortNo()) : this.itemCategoryRepoProc.existsBySortNo(saveVO.getPid(), saveVO.getSortNo(), id));
        Assert.isFalse((boolean)exists, (String)"\u5e8f\u53f7\u5df2\u5b58\u5728", (Object[])new Object[0]);
        saveVO.setEnable((Boolean)ObjectUtil.defaultIfNull((Object)saveVO.getEnable(), (Object)false));
        if (StrUtil.isNotBlank((CharSequence)saveVO.getPicFileCode())) {
            exists = this.isExistsFile(saveVO.getPicFileCode());
            Assert.isTrue((boolean)exists, (String)"\u672a\u627e\u5230\u6709\u6548\u56fe\u7247\uff0c\u8bf7\u4ece\u65b0\u4e0a\u4f20", (Object[])new Object[0]);
        }
    }

    private void fillLevel(BipItemCategoryDO doo) {
        int level = doo.getPid() == -1L ? 1 : this.itemCategoryRepoProc.getLevel(doo.getPid()) + 1;
        doo.setLevel(level);
    }

    public BipItemCategoryServiceImpl(BipItemCategoryRepo itemCategoryRepo, BipItemCategoryRepoProc itemCategoryRepoProc, BipItemRepoProc itemRepoProc) {
        this.itemCategoryRepo = itemCategoryRepo;
        this.itemCategoryRepoProc = itemCategoryRepoProc;
        this.itemRepoProc = itemRepoProc;
    }
}

