/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.production.order.param.SalDoReturnTOBSaveDTO;
import com.elitesland.yst.production.sale.api.service.shop.BipCompanyManageService;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderBackDService;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderBackService;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderBackToOmsServicei;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipOrderBackDParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipOrderBackParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipOrderBackUserParmVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCompanyManageRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemSkuAttrRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipOrderBackDRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipOrderBackRespVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipOrderBackDSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipOrderBackLogistSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipOrderBackSaveVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.BipOrderBackConvert;
import com.elitesland.yst.production.sale.convert.shop.BipOrderBackDConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.dto.save.BipOrderBackRpcDto;
import com.elitesland.yst.production.sale.entity.BipCustUserBindDO;
import com.elitesland.yst.production.sale.entity.BipItemDO;
import com.elitesland.yst.production.sale.entity.BipItemSkuDO;
import com.elitesland.yst.production.sale.entity.BipOrderBackDDO;
import com.elitesland.yst.production.sale.entity.BipOrderBackDO;
import com.elitesland.yst.production.sale.entity.BipOrderDDO;
import com.elitesland.yst.production.sale.entity.BipOrderDO;
import com.elitesland.yst.production.sale.entity.QBipOrderBackDDO;
import com.elitesland.yst.production.sale.entity.QBipOrderBackDO;
import com.elitesland.yst.production.sale.entity.QBipOrderDO;
import com.elitesland.yst.production.sale.ext.cpcn.resp.CPCN5021Resp;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemRepo;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderBackDRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderBackRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderBackRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipOrderDRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderDRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipOrderRepo;
import com.elitesland.yst.production.sale.repo.shop.BipSendOrderErrLogRepo;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.sale.service.shop.BipAddressServiceImpl;
import com.elitesland.yst.production.sale.service.shop.BipOrderBackToOmsServiceimpl;
import com.elitesland.yst.production.sale.workflow.ProcDefKey;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgOuRpcDtoParam;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.StringUtils;

@Service
public class BipOrderBackServiceImpl
extends BaseServiceImpl
implements BipOrderBackService {
    private static final Logger log = LoggerFactory.getLogger(BipOrderBackServiceImpl.class);
    @Autowired
    private BipOrderBackRepo bipOrderBackRepo;
    @Autowired
    private BipOrderBackRepoProc bipOrderBackRepoProc;
    @Autowired
    private BipOrderBackDRepo bipOrderBackDRepo;
    @Autowired
    private BipCustUserBindRepoProc bipCustUserBindRepoProc;
    @Autowired
    private BipOrderDRepoProc bipOrderDRepoProc;
    @Autowired
    private BipOrderDRepo bipOrderDRepo;
    @Autowired
    private BipOrderRepo bipOrderRepo;
    @Autowired
    private BipOrderBackDService bipOrderBackDService;
    @Autowired
    private BipItemSkuRepo bipItemSkuRepo;
    @Autowired
    private BipItemRepo bipItemRepo;
    @Autowired
    private RmiOrgOuService rmiOrgOuService;
    @Autowired
    private UdcProvider udcProvider;
    @Autowired
    private BipCompanyManageService bipCompanyManageService;
    @Autowired
    private BipOrderBackToOmsServiceimpl bipOrderBackToOmsServiceimpl;
    @Autowired
    private BipAddressServiceImpl bipAddressService;
    @Autowired
    private BipOrderBackServiceImpl bipOrderBackService;
    @Autowired
    private BipSendOrderErrLogRepo bipSendOrderErrLogRepo;
    @Autowired
    private BipOrderBackToOmsServicei bipOrderBackToOmsServicei;
    private final RmiSysNextNumberService rmiSysNextNumberService;
    private String returnNoticUrl;
    private final TransactionTemplate transactionTemplate;
    private final QBipOrderBackDO qBipOrderBackDO = QBipOrderBackDO.bipOrderBackDO;
    private final QBipOrderBackDDO qBipOrderBackDDO = QBipOrderBackDDO.bipOrderBackDDO;

    @Transactional(rollbackFor={Exception.class})
    public void createOrderBack(BipOrderBackSaveVO bipOrderBackSaveVO) {
        List<BipItemSkuDO> shipOneList;
        if (bipOrderBackSaveVO.getOrderId() == null) {
            throw new BusinessException("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (bipOrderBackSaveVO.getOrderDocNo() == null) {
            throw new BusinessException("\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        List bipOrderBackDSaveVOS = bipOrderBackSaveVO.getBipOrderBackDSaveVOS();
        List<Long> orderDids = bipOrderBackDSaveVOS.stream().map(BipOrderBackDSaveVO::getOrderDId).distinct().collect(Collectors.toList());
        ArrayList<BipOrderBackSaveVO> bipOrderBackSaveVOS = new ArrayList<BipOrderBackSaveVO>();
        Map<String, List<BipItemSkuDO>> shipOneGroupMap = this.spliteOrderBackD(orderDids);
        List<BipItemSkuDO> shipOneNoList = shipOneGroupMap.get(Boolean.FALSE.toString());
        log.info("shipOneNoList---------:" + JSON.toJSONString(shipOneNoList));
        log.info("bipOrderBackSaveVO----------:" + JSON.toJSONString((Object)bipOrderBackSaveVO));
        if (null != shipOneNoList && !shipOneNoList.isEmpty()) {
            BipOrderBackSaveVO shipOneNoBipOrderBackSaveVO1 = this.createSpliteOrderBack(shipOneNoList, bipOrderBackSaveVO);
            bipOrderBackSaveVOS.add(shipOneNoBipOrderBackSaveVO1);
            log.info("\u975e\u4e00\u4ef6\u4ee3\u53d1\u9000\u8d27\u5355\u4fe1\u606f:--" + JSON.toJSONString((Object)shipOneNoBipOrderBackSaveVO1));
        }
        if ((shipOneList = shipOneGroupMap.get(Boolean.TRUE.toString())) != null && !shipOneList.isEmpty()) {
            Map<String, List<BipItemSkuDO>> shipOneGroupMpa = shipOneList.stream().collect(Collectors.groupingBy(BipItemSkuDO::getSupplier));
            for (String supplier : shipOneGroupMpa.keySet()) {
                List<BipItemSkuDO> bipItemSkuDOS = shipOneGroupMpa.get(supplier);
                BipOrderBackSaveVO shipOneBipOrderBackSaveVO = this.createSpliteOrderBack(bipItemSkuDOS, bipOrderBackSaveVO);
                log.info("\u4e00\u4ef6\u4ee3\u53d1\u9000\u8d27\u5355\u4fe1\u606f:--" + JSON.toJSONString((Object)shipOneBipOrderBackSaveVO));
                bipOrderBackSaveVOS.add(shipOneBipOrderBackSaveVO);
            }
        }
        ArrayList<Long> orderBackIds = new ArrayList<Long>();
        for (BipOrderBackSaveVO backSaveVO : bipOrderBackSaveVOS) {
            this.saveBipOrderBack(backSaveVO, orderBackIds);
        }
        this.bipOrderBackToOmsServiceimpl.sendToOms(orderBackIds);
    }

    public ApiResult subBipOrderBack(BipOrderBackSaveVO bipOrderBackSaveVO) {
        List<BipItemSkuDO> shipOneList;
        if (bipOrderBackSaveVO.getOrderId() == null) {
            throw new BusinessException("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (bipOrderBackSaveVO.getOrderDocNo() == null) {
            throw new BusinessException("\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        ArrayList<String> docNoList = new ArrayList<String>();
        docNoList.add(bipOrderBackSaveVO.getOrderDocNo());
        Optional optionalBipOrderDO = this.bipOrderRepo.findById(bipOrderBackSaveVO.getOrderId());
        if (null == optionalBipOrderDO || optionalBipOrderDO.isEmpty()) {
            throw new BusinessException("\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a!");
        }
        BipOrderDO orderDo = (BipOrderDO)optionalBipOrderDO.get();
        orderDo.setStatus("cancelled");
        this.bipOrderRepo.save(orderDo);
        List bipOrderBackDSaveVOS = bipOrderBackSaveVO.getBipOrderBackDSaveVOS();
        List<Long> orderDids = bipOrderBackDSaveVOS.stream().map(BipOrderBackDSaveVO::getOrderDId).distinct().collect(Collectors.toList());
        ArrayList<BipOrderBackSaveVO> bipOrderBackSaveVOS = new ArrayList<BipOrderBackSaveVO>();
        Map<String, List<BipItemSkuDO>> shipOneGroupMap = this.spliteOrderBackD(orderDids);
        List<BipItemSkuDO> shipOneNoList = shipOneGroupMap.get(Boolean.FALSE.toString());
        log.info("shipOneNoList---------:" + JSON.toJSONString(shipOneNoList));
        log.info("bipOrderBackSaveVO----------:" + JSON.toJSONString((Object)bipOrderBackSaveVO));
        if (null != shipOneNoList && !shipOneNoList.isEmpty()) {
            BipOrderBackSaveVO shipOneNoBipOrderBackSaveVO1 = this.createSpliteOrderBack(shipOneNoList, bipOrderBackSaveVO);
            bipOrderBackSaveVOS.add(shipOneNoBipOrderBackSaveVO1);
            log.info("\u975e\u4e00\u4ef6\u4ee3\u53d1\u9000\u8d27\u5355\u4fe1\u606f:--" + JSON.toJSONString((Object)shipOneNoBipOrderBackSaveVO1));
        }
        if ((shipOneList = shipOneGroupMap.get(Boolean.TRUE.toString())) != null && !shipOneList.isEmpty()) {
            Map<String, List<BipItemSkuDO>> shipOneGroupMpa = shipOneList.stream().collect(Collectors.groupingBy(bipItemSkuDO -> bipItemSkuDO.getSupplier()));
            for (String string : shipOneGroupMpa.keySet()) {
                List<BipItemSkuDO> bipItemSkuDOS = shipOneGroupMpa.get(string);
                BipOrderBackSaveVO shipOneBipOrderBackSaveVO = this.createSpliteOrderBack(bipItemSkuDOS, bipOrderBackSaveVO);
                log.info("\u4e00\u4ef6\u4ee3\u53d1\u9000\u8d27\u5355\u4fe1\u606f:--" + JSON.toJSONString((Object)shipOneBipOrderBackSaveVO));
                bipOrderBackSaveVOS.add(shipOneBipOrderBackSaveVO);
            }
        }
        ArrayList<Long> orderBackIds = new ArrayList<Long>();
        BipOrderBackDO bipOrderBackDO = new BipOrderBackDO();
        log.info("bipOrderBackSaveVOS:----------" + JSON.toJSONString(bipOrderBackSaveVOS));
        for (BipOrderBackSaveVO backSaveVO : bipOrderBackSaveVOS) {
            bipOrderBackDO = this.saveSubBipOrderBack(backSaveVO, orderBackIds);
        }
        if (null == bipOrderBackDO || null == bipOrderBackDO.getId()) {
            throw new BusinessException("\u9000\u6b3e\u5355\u4fe1\u606f\u4e3a\u7a7a");
        }
        this.bipOrderBackToOmsServiceimpl.sendToOms(orderBackIds);
        BipOrderBackRpcDto bipOrderBackRpcDto = new BipOrderBackRpcDto();
        bipOrderBackRpcDto.setDocNo(bipOrderBackDO.getOrderBackDocNo());
        bipOrderBackRpcDto.setStatus(UdcEnum.SAL_RSO_STATUS_DONE.getValueCode());
        return this.updateOrderBackStatus(bipOrderBackRpcDto);
    }

    public ApiResult updateOrderBackStatus(BipOrderBackRpcDto bipOrderBackRpcDto) {
        ArrayList<BipOrderBackDO> bipOrderBackDOS = new ArrayList<BipOrderBackDO>();
        if (bipOrderBackRpcDto.getDocNo() == null) {
            throw new BusinessException("\u4e3b\u8868ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)bipOrderBackRpcDto.getStatus())) {
            throw new BusinessException("\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a!---");
        }
        ArrayList<String> docNos = new ArrayList<String>();
        log.info("\u67e5\u8be2\u9000\u8d27\u5355\u4fe1\u606f:----");
        BipOrderBackDO bipOrderBackDO = this.bipOrderBackRepoProc.findOrderBackByDocNo(bipOrderBackRpcDto.getDocNo());
        log.info("\u9000\u8d27\u5355\u7684\u4fe1\u606f" + JSON.toJSONString((Object)bipOrderBackDO));
        bipOrderBackDO.setStatus(bipOrderBackRpcDto.getStatus());
        log.info("\u8bbe\u7f6e\u9000\u8d27\u5355\u72b6\u6001:----");
        if (bipOrderBackDO.getOrderId() == null) {
            throw new BusinessException("\u9000\u8d27\u5355\u672a\u5173\u8054\u8ba2\u5355");
        }
        log.info("\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f:----");
        BipOrderDO bipOrderDo = (BipOrderDO)this.bipOrderRepo.findById(bipOrderBackDO.getOrderId()).get();
        log.info("\u8ba2\u5355\u4fe1\u606f:----" + JSON.toJSONString((Object)bipOrderDo));
        log.info("\u9000\u6b3e\u4e2d\u72b6\u6001:----");
        docNos.add(bipOrderBackRpcDto.getDocNo());
        bipOrderBackDO.setStatus(UdcEnum.SAL_RSO_STATUS_DONE.getValueCode());
        bipOrderBackDOS.add(bipOrderBackDO);
        log.info("\u9000\u8d27\u5355\u6570\u636e:---" + JSON.toJSONString(bipOrderBackDOS));
        this.bipOrderBackRepo.saveAll(bipOrderBackDOS);
        if (null != docNos && !docNos.isEmpty()) {
            log.info("\u540c\u610f\u9000\u6b3e\u4f20\u7ed9\u8ba2\u5355\u4e2d\u5fc3\u7684\u53c2\u6570:" + docNos);
            docNos.stream().forEach(docNo -> {
                log.info("\u751f\u6210\u9000\u6b3e\u5355\u5355\u53f7:-------" + docNo);
                this.bipOrderBackToOmsServicei.createSalReceiptService(docNo);
            });
        }
        return ApiResult.ok();
    }

    public BipOrderBackSaveVO createSpliteOrderBack(List<BipItemSkuDO> bipItemSkuDOS, BipOrderBackSaveVO bipOrderBackSaveVO) {
        if (!bipItemSkuDOS.isEmpty()) {
            List<Long> skuIds = bipItemSkuDOS.stream().map(bipItemSkuDO -> bipItemSkuDO.getId()).distinct().collect(Collectors.toList());
            List<Long> orderdIds = this.findOrderBackDBySkuId(skuIds, bipOrderBackSaveVO.getOrderId());
            BipOrderBackSaveVO shipNoBipOrderBackSaveVO = new BipOrderBackSaveVO();
            BipOrderBackConvert.INSTANCE.copySaveVO(bipOrderBackSaveVO, shipNoBipOrderBackSaveVO);
            shipNoBipOrderBackSaveVO.setOrderId(bipOrderBackSaveVO.getOrderId());
            shipNoBipOrderBackSaveVO.setOrderDocNo(bipOrderBackSaveVO.getOrderDocNo());
            List bipOrderBackDSaveVOS = bipOrderBackSaveVO.getBipOrderBackDSaveVOS();
            List shipNobipOrderBackDSaveVOS = bipOrderBackDSaveVOS.stream().filter(bipOrderBackDSaveVO -> orderdIds.contains(bipOrderBackDSaveVO.getOrderDId())).collect(Collectors.toList());
            shipNoBipOrderBackSaveVO.setBipOrderBackDSaveVOS(shipNobipOrderBackDSaveVOS);
            return shipNoBipOrderBackSaveVO;
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveBipOrderBack(BipOrderBackSaveVO bipOrderBackSaveVO, List<Long> orderBackIds) {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        log.info("\u9000\u8d27\u5355\u53c2\u6570: " + JSON.toJSONString((Object)bipOrderBackSaveVO));
        BipCustUserBindDO bipCustUserBindDO = null;
        if (!Objects.nonNull(currentUserDTO.getUserId())) {
            throw new BusinessException("\u8bf7\u5148\u767b\u5f55!");
        }
        bipCustUserBindDO = this.bipCustUserBindRepoProc.getByUserId(currentUserDTO.getUserId());
        BipOrderBackDO bipOrderBackDO = BipOrderBackConvert.INSTANCE.saveToDo(bipOrderBackSaveVO);
        this.fillOrderCustInfo(bipCustUserBindDO, bipOrderBackDO);
        List bipOrderBackDSaveVOS = bipOrderBackSaveVO.getBipOrderBackDSaveVOS();
        String docNo = this.rmiSysNextNumberService.generateCode("yst-sale", "ORDER_BACK_DOC_NO", new ArrayList<String>());
        bipOrderBackDO.setOrderBackDocNo(docNo);
        bipOrderBackDO.setBackTime(LocalDateTime.now());
        bipOrderBackDO = (BipOrderBackDO)this.bipOrderBackRepo.save(bipOrderBackDO);
        List<BipOrderBackDDO> bipOrderBackDDOList = BipOrderBackDConvert.INSTANCE.savesToDos(bipOrderBackDSaveVOS);
        ArrayList<BipOrderBackDDO> bipOrderBackDDOSaveList = new ArrayList<BipOrderBackDDO>();
        BigDecimal backAmtTotal = new BigDecimal(0);
        int lineNo = 1;
        for (BipOrderBackDDO bipOrderBackDDO : bipOrderBackDDOList) {
            bipOrderBackDDO.setLineNo(lineNo);
            ++lineNo;
            bipOrderBackDDO.setCustAccountId(bipCustUserBindDO.getUserId());
            bipOrderBackDDO.setCustAccountName(bipCustUserBindDO.getUsername());
            if (bipOrderBackDDO.getOrderDId() == null) {
                throw new BusinessException("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            this.buildItemfoByOrderId(bipOrderBackDDO.getOrderDId(), bipOrderBackDDO);
            bipOrderBackDDO.setOrderBackId(bipOrderBackDO.getId());
            bipOrderBackDDO.setOrderBackDocNo(bipOrderBackDO.getOrderBackDocNo());
            bipOrderBackDDO.setPayAmt(bipOrderBackDDO.getPayAmt());
            bipOrderBackDDO.setApplyBackAmt(bipOrderBackDDO.getPayAmt().multiply(new BigDecimal(bipOrderBackDDO.getBackNum())));
            if (bipOrderBackDDO.getApplyBackAmt() != null) {
                BigDecimal backAmt = bipOrderBackDDO.getApplyBackAmt();
                bipOrderBackDDO.setApproveBackAmt(backAmt);
                backAmtTotal = backAmtTotal.add(backAmt);
            }
            bipOrderBackDDOSaveList.add(bipOrderBackDDO);
        }
        this.bipOrderBackDRepo.saveAll(bipOrderBackDDOSaveList);
        bipOrderBackDO.setApplyBackAmt(backAmtTotal);
        bipOrderBackDO.setApproveBackAmt(backAmtTotal);
        bipOrderBackDO.setStatus(UdcEnum.SAL_RSO_STATUS_APPING.getValueCode());
        this.bipOrderBackRepo.save(bipOrderBackDO);
        orderBackIds.add(bipOrderBackDO.getId());
    }

    @Transactional(rollbackFor={Exception.class})
    public BipOrderBackDO saveSubBipOrderBack(BipOrderBackSaveVO bipOrderBackSaveVO, List<Long> orderBackIds) {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        log.info("\u9000\u8d27\u5355\u53c2\u6570: " + JSON.toJSONString((Object)bipOrderBackSaveVO));
        BipCustUserBindDO bipCustUserBindDO = null;
        if (!Objects.nonNull(currentUserDTO.getUserId())) {
            throw new BusinessException("\u8bf7\u5148\u767b\u5f55!");
        }
        bipCustUserBindDO = this.bipCustUserBindRepoProc.getByUserId(currentUserDTO.getUserId());
        BipOrderBackDO bipOrderBackDO = BipOrderBackConvert.INSTANCE.saveToDo(bipOrderBackSaveVO);
        this.fillOrderCustInfo(bipCustUserBindDO, bipOrderBackDO);
        List bipOrderBackDSaveVOS = bipOrderBackSaveVO.getBipOrderBackDSaveVOS();
        String docNo = this.rmiSysNextNumberService.generateCode("yst-sale", "ORDER_BACK_DOC_NO", new ArrayList<String>());
        bipOrderBackDO.setOrderBackDocNo(docNo);
        bipOrderBackDO.setBackTime(LocalDateTime.now());
        bipOrderBackDO = (BipOrderBackDO)this.bipOrderBackRepo.save(bipOrderBackDO);
        List<BipOrderBackDDO> bipOrderBackDDOList = BipOrderBackDConvert.INSTANCE.savesToDos(bipOrderBackDSaveVOS);
        ArrayList<BipOrderBackDDO> bipOrderBackDDOSaveList = new ArrayList<BipOrderBackDDO>();
        BigDecimal backAmtTotal = new BigDecimal(0);
        int lineNo = 1;
        for (BipOrderBackDDO bipOrderBackDDO : bipOrderBackDDOList) {
            bipOrderBackDDO.setLineNo(lineNo);
            ++lineNo;
            bipOrderBackDDO.setCustAccountId(bipCustUserBindDO.getUserId());
            bipOrderBackDDO.setCustAccountName(bipCustUserBindDO.getUsername());
            if (bipOrderBackDDO.getOrderDId() == null) {
                throw new BusinessException("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            this.buildSubItemfoByOrderId(bipOrderBackDDO.getOrderDId(), bipOrderBackDDO);
            bipOrderBackDDO.setOrderBackId(bipOrderBackDO.getId());
            bipOrderBackDDO.setOrderBackDocNo(bipOrderBackDO.getOrderBackDocNo());
            bipOrderBackDDO.setPayAmt(bipOrderBackDDO.getPayAmt());
            if (bipOrderBackDDO.getApplyBackAmt() != null) {
                BigDecimal backAmt = bipOrderBackDDO.getApplyBackAmt();
                bipOrderBackDDO.setApproveBackAmt(backAmt);
                backAmtTotal = backAmtTotal.add(backAmt);
            }
            bipOrderBackDDOSaveList.add(bipOrderBackDDO);
        }
        this.bipOrderBackDRepo.saveAll(bipOrderBackDDOSaveList);
        bipOrderBackDO.setApplyBackAmt(backAmtTotal);
        bipOrderBackDO.setApproveBackAmt(backAmtTotal);
        bipOrderBackDO.setStatus(UdcEnum.SAL_RSO_STATUS_DONE.getValueCode());
        log.info("\u9000\u6b3e\u5355\u4fdd\u5b58\u53c2\u6570\uff1a----------------" + JSON.toJSONString((Object)bipOrderBackDO));
        bipOrderBackDO = (BipOrderBackDO)this.bipOrderBackRepo.save(bipOrderBackDO);
        log.info("\u9000\u6b3e\u5355\u4fdd\u5b58\u53c2\u6570\u6210\u529f" + JSON.toJSONString((Object)bipOrderBackDO));
        orderBackIds.add(bipOrderBackDO.getId());
        return bipOrderBackDO;
    }

    public Map<String, List<BipItemSkuDO>> spliteOrderBackD(List<Long> orderDIds) {
        List<Long> skuIdByIds = this.bipOrderDRepoProc.findOrderDSkuIdByIds(orderDIds);
        List bipItemSkuDOList = this.bipItemSkuRepo.findAllById(skuIdByIds);
        Map<String, List<BipItemSkuDO>> bipItemSkuDOListGroupMap = bipItemSkuDOList.stream().collect(Collectors.groupingBy(bipItemSkuDO -> bipItemSkuDO.getShipOne().toString()));
        log.info("bipItemSkuDOListGroupMap-------:" + JSON.toJSONString(bipItemSkuDOListGroupMap));
        log.info("\u662f\u5426\u4e00\u4ef6\u4ee3\u53d1\u5206\u7ec4KEY:" + JSON.toJSONString((Object)bipItemSkuDOListGroupMap.keySet().toString()));
        return bipItemSkuDOListGroupMap;
    }

    public Map<String, List<BipItemSkuDO>> spliteShipOneOrderBackD(List<BipItemSkuDO> shipOnelist) {
        Map<String, List<BipItemSkuDO>> shipGroupMap = shipOnelist.stream().collect(Collectors.groupingBy(bipItemSkuDO -> bipItemSkuDO.getSupplier()));
        return shipGroupMap;
    }

    public List<Long> findOrderBackDBySkuId(List<Long> skuIds, Long orderId) {
        List<Long> orderDIds = this.bipOrderDRepoProc.findOrderDIdBySkuId(skuIds, orderId);
        if (orderDIds == null || orderDIds.isEmpty()) {
            throw new BusinessException("\u6570\u636e\u5f02\u5e38,\u6839\u636e\u8ba2\u5355id\u548cskuId\u67e5\u8be2\u660e\u7ec6\u6570\u636e\u9519\u8bef");
        }
        return orderDIds;
    }

    public void buildItemfoByOrderId(Long orderId, BipOrderBackDDO bipOrderBackDDO) {
        BipOrderDDO bipOrderDDo = (BipOrderDDO)this.bipOrderDRepo.findById(orderId).get();
        bipOrderBackDDO.setItemId(bipOrderDDo.getItemId());
        bipOrderBackDDO.setSkuId(bipOrderDDo.getSkuId());
        bipOrderBackDDO.setRelateItemId(bipOrderDDo.getRelateItemId());
        bipOrderBackDDO.setItemCode(bipOrderDDo.getItemCode());
        bipOrderBackDDO.setItemName(bipOrderDDo.getItemName());
        bipOrderBackDDO.setItemTitle(bipOrderDDo.getItemTitle());
        bipOrderBackDDO.setItmeBrandID(bipOrderDDo.getItmeBrandID());
        bipOrderBackDDO.setItemBrand(bipOrderDDo.getItemBrand());
        bipOrderBackDDO.setItemSpec(bipOrderDDo.getItemSpec());
        bipOrderBackDDO.setUom(bipOrderDDo.getUom());
        bipOrderBackDDO.setItemPicFileCode(bipOrderDDo.getItemPicFileCode());
        bipOrderBackDDO.setOrderDocNo(bipOrderDDo.getOrderDocNo());
        bipOrderBackDDO.setOrderId(bipOrderDDo.getOrderId());
        bipOrderBackDDO.setItemType(bipOrderDDo.getItemType());
        bipOrderBackDDO.setPayAmt(bipOrderDDo.getBuyAmt());
        Long allowBackNum = bipOrderDDo.getAllowBackNum();
        if (allowBackNum == null) {
            allowBackNum = bipOrderDDo.getBuyQty();
        }
        bipOrderDDo.setAllowBackNum(allowBackNum - bipOrderBackDDO.getBackNum());
        this.bipOrderDRepo.save(bipOrderDDo);
        log.info("\u8ba2\u5355\u8f6c\u9000\u8d27\u5355\u8d60\u54c1\u4fe1\u606f" + JSON.toJSONString((Object)bipOrderBackDDO));
    }

    public void buildSubItemfoByOrderId(Long orderId, BipOrderBackDDO bipOrderBackDDO) {
        BipOrderDDO bipOrderDDo = (BipOrderDDO)this.bipOrderDRepo.findById(orderId).get();
        bipOrderBackDDO.setItemId(bipOrderDDo.getItemId());
        bipOrderBackDDO.setSkuId(bipOrderDDo.getSkuId());
        bipOrderBackDDO.setRelateItemId(bipOrderDDo.getRelateItemId());
        bipOrderBackDDO.setItemCode(bipOrderDDo.getItemCode());
        bipOrderBackDDO.setItemName(bipOrderDDo.getItemName());
        bipOrderBackDDO.setItemTitle(bipOrderDDo.getItemTitle());
        bipOrderBackDDO.setItmeBrandID(bipOrderDDo.getItmeBrandID());
        bipOrderBackDDO.setItemBrand(bipOrderDDo.getItemBrand());
        bipOrderBackDDO.setItemSpec(bipOrderDDo.getItemSpec());
        bipOrderBackDDO.setUom(bipOrderDDo.getUom());
        bipOrderBackDDO.setItemPicFileCode(bipOrderDDo.getItemPicFileCode());
        bipOrderBackDDO.setOrderDocNo(bipOrderDDo.getOrderDocNo());
        bipOrderBackDDO.setOrderId(bipOrderDDo.getOrderId());
        bipOrderBackDDO.setItemType(bipOrderDDo.getItemType());
        bipOrderBackDDO.setApplyBackAmt(bipOrderDDo.getPayAmt());
        bipOrderBackDDO.setApproveBackAmt(bipOrderDDo.getPayAmt());
        bipOrderBackDDO.setPayAmt(bipOrderDDo.getBuyAmt());
        Long allowBackNum = bipOrderDDo.getAllowBackNum();
        if (allowBackNum == null) {
            allowBackNum = bipOrderDDo.getBuyQty();
        }
        bipOrderDDo.setAllowBackNum(allowBackNum - bipOrderBackDDO.getBackNum());
        this.bipOrderDRepo.save(bipOrderDDo);
        log.info("\u8ba2\u5355\u8f6c\u9000\u8d27\u5355\u8d60\u54c1\u4fe1\u606f" + JSON.toJSONString((Object)bipOrderBackDDO));
    }

    @Transactional(rollbackFor={Exception.class})
    public void reBack(Long id) {
        BipOrderBackDO bipOrderBackDO = (BipOrderBackDO)this.bipOrderBackRepo.findById(id).get();
        BipOrderBackDO reBipOrderBackDo = null;
        reBipOrderBackDo = BipOrderBackConvert.INSTANCE.copy(bipOrderBackDO);
        reBipOrderBackDo.setStatus(UdcEnum.SAL_RSO_STATUS_APPING.getValueCode());
        reBipOrderBackDo.setId(null);
        String docNo = this.rmiSysNextNumberService.generateCode("yst-sale", "ORDER_BACK_DOC_NO", new ArrayList<String>());
        reBipOrderBackDo.setOrderBackDocNo(docNo);
        reBipOrderBackDo = (BipOrderBackDO)this.bipOrderBackRepo.save(reBipOrderBackDo);
        List<BipOrderBackDDO> bipOrderBackDDOList = this.bipOrderBackDRepo.findByOrderBackId(id);
        ArrayList<BipOrderBackDDO> reBipOrderBackDDOList = new ArrayList<BipOrderBackDDO>();
        for (BipOrderBackDDO bipOrderBackDDO : bipOrderBackDDOList) {
            Long num = bipOrderBackDDO.getBackNum();
            BipOrderBackDDO reBipOrderBackDDo = BipOrderBackDConvert.INSTANCE.copy(bipOrderBackDDO);
            reBipOrderBackDDo.setId(null);
            reBipOrderBackDDo.setOrderBackId(reBipOrderBackDo.getId());
            reBipOrderBackDDo.setOrderBackDocNo(docNo);
            reBipOrderBackDDo.setCreateTime(LocalDateTime.now());
            reBipOrderBackDDo.setCreateUserId(null);
            reBipOrderBackDDo.setUpdater(null);
            reBipOrderBackDDo.setModifyTime(LocalDateTime.now());
            reBipOrderBackDDo.setModifyUserId(null);
            Long orderDId = bipOrderBackDDO.getOrderDId();
            if (orderDId == null) {
                throw new BusinessException("\u6570\u636e\u9519\u8bef,\u9000\u8d27\u5355\u672a\u5173\u8054\u8ba2\u5355!");
            }
            this.bipOrderDRepoProc.updateOrderDAllowBackNum(orderDId, -num.longValue());
            reBipOrderBackDDOList.add(reBipOrderBackDDo);
        }
        this.bipOrderBackDRepo.saveAll(reBipOrderBackDDOList);
    }

    private void fillOrderCustInfo(BipCustUserBindDO bipCustUserBindDO, BipOrderBackDO orderBackDO) {
        List bipCompanyManageRespVOS;
        Long custId = bipCustUserBindDO.getCustId();
        orderBackDO.setOuId(bipCustUserBindDO.getOuId());
        Long ouId = bipCustUserBindDO.getOuId();
        ArrayList<Long> ouList = new ArrayList<Long>();
        ouList.add(ouId);
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuIds(ouList);
        log.info("\u8c03\u7528\u516c\u53f8\u63a5\u53e3\u53c2\u6570---" + JSON.toJSONString((Object)orgOuRpcDtoParam));
        List<OrgOuRpcDTO> orgOuRpcDTOS = this.rmiOrgOuService.findOuDtoListByParam(orgOuRpcDtoParam);
        if (orgOuRpcDTOS != null && !orgOuRpcDTOS.isEmpty()) {
            OrgOuRpcDTO orgOuRpcDTO = orgOuRpcDTOS.get(0);
            orderBackDO.setOuName(orgOuRpcDTO.getOuName());
            orderBackDO.setOuCode(orgOuRpcDTO.getOuCode());
        }
        if ((bipCompanyManageRespVOS = this.bipCompanyManageService.findCompanyManageByOuIds(ouList)) != null && !bipCompanyManageRespVOS.isEmpty()) {
            BipCompanyManageRespVO bipCompanyManageRespVO = (BipCompanyManageRespVO)bipCompanyManageRespVOS.get(0);
            orderBackDO.setBuId(bipCompanyManageRespVO.getBuId());
            orderBackDO.setBuCode(bipCompanyManageRespVO.getBuCode());
            orderBackDO.setBuName(bipCompanyManageRespVO.getBuName());
        }
        orderBackDO.setCustAccountId(bipCustUserBindDO.getUserId());
        orderBackDO.setCustAccountName(bipCustUserBindDO.getUsername());
        orderBackDO.setCustId(custId);
        orderBackDO.setCustCode(bipCustUserBindDO.getCustCode());
        orderBackDO.setCustName(bipCustUserBindDO.getCustName());
        orderBackDO.setAgentEmpId(bipCustUserBindDO.getAgentEmpId());
    }

    public PagingVO<BipOrderBackRespVO> findBipOrderBackPage(BipOrderBackParmVO bipOrderBackParmVO) {
        Page page = this.bipOrderBackRepo.findAll(this.where(bipOrderBackParmVO), (Pageable)bipOrderBackParmVO.getPageRequest());
        List resList = page.getContent().stream().map(BipOrderBackConvert.INSTANCE::doToresp).collect(Collectors.toList());
        for (BipOrderBackRespVO bipOrderBackRespVO : resList) {
            this.findStatusName(bipOrderBackRespVO);
            this.findBackTypeName(bipOrderBackRespVO);
            this.findBackResonName(bipOrderBackRespVO);
        }
        return PagingVO.builder().total(page.getTotalElements()).records(resList).build();
    }

    public void updateSync(BipOrderBackSaveVO bipOrderBackSaveVO) {
        if (bipOrderBackSaveVO.getId() == null) {
            throw new BusinessException("ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        BipOrderBackDO bipOrderBackDO = (BipOrderBackDO)this.bipOrderBackRepo.findById(bipOrderBackSaveVO.getId()).get();
        BipOrderBackConvert.INSTANCE.copySaveToDo(bipOrderBackSaveVO, bipOrderBackDO);
        this.bipOrderBackRepo.save(bipOrderBackDO);
        ArrayList<BipOrderBackDDO> bipOrderBackDDOS = new ArrayList<BipOrderBackDDO>();
        for (BipOrderBackDSaveVO dSaveVO : bipOrderBackSaveVO.getBipOrderBackDSaveVOS()) {
            Optional byId = this.bipOrderBackDRepo.findById(dSaveVO.getId());
            if (!byId.isPresent()) continue;
            BipOrderBackDDO backDDO = (BipOrderBackDDO)byId.get();
            backDDO.setApproveBackAmt(dSaveVO.getApproveBackAmt());
            backDDO.setIsWorkOrder(dSaveVO.getIsWorkOrder());
            bipOrderBackDDOS.add(backDDO);
        }
        this.bipOrderBackDRepo.saveAll(bipOrderBackDDOS);
        this.bipOrderBackToOmsServiceimpl.updateBackOrder(bipOrderBackDDOS, bipOrderBackSaveVO.getStatus());
    }

    public void cancelSync(Long id) {
        BipOrderBackDO bipOrderBackDO = (BipOrderBackDO)this.bipOrderBackRepo.findById(id).orElseThrow(() -> new BusinessException("\u9000\u6b3e\u5355\u3010" + id + "\u3011\u4e0d\u5b58\u5728\uff01"));
        bipOrderBackDO.setStatus("CL");
        this.bipOrderBackRepo.save(bipOrderBackDO);
        List<BipOrderBackDDO> bipOrderBackDDOS = this.bipOrderBackDRepo.findByOrderBackId(id);
        Assert.notNull(bipOrderBackDDOS, (String)("\u9000\u6b3e\u5355\u3010" + id + "\u3011\u660e\u7ec6\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
        this.bipOrderBackToOmsServiceimpl.updateBackOrder(bipOrderBackDDOS, "CL");
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteBipOrderBackByIds(List<Long> ids) {
        this.bipOrderBackRepo.deleteOrderBackByIds(ids);
        this.bipOrderBackDRepo.deleteOrderBackDByOrderbackIds(ids);
    }

    public Predicate where(BipOrderBackParmVO bipOrderBackParmVO) {
        BooleanExpression predicate = this.qBipOrderBackDO.isNotNull();
        if (Objects.nonNull(bipOrderBackParmVO)) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bipOrderBackParmVO.getOrderBackDocNo())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderBackDO.orderBackDocNo.like("%" + bipOrderBackParmVO.getOrderBackDocNo() + "%"));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bipOrderBackParmVO.getOrderDocNo())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderBackDO.orderDocNo.like("%" + bipOrderBackParmVO.getOrderDocNo() + "%"));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bipOrderBackParmVO.getLogistDocNo())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderBackDO.logistDocNo.like("%" + bipOrderBackParmVO.getLogistDocNo() + "%"));
            }
            if (Objects.nonNull(bipOrderBackParmVO.getOuId())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderBackDO.ouId.eq((Object)bipOrderBackParmVO.getOuId()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bipOrderBackParmVO.getStatus())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderBackDO.status.eq((Object)bipOrderBackParmVO.getStatus()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bipOrderBackParmVO.getShipperName())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderBackDO.shipperName.like("%" + bipOrderBackParmVO.getShipperName() + "%"));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bipOrderBackParmVO.getShipperTel())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderBackDO.shipperTel.like("%" + bipOrderBackParmVO.getShipperTel() + "%"));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bipOrderBackParmVO.getCustAccountName())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderBackDO.custAccountName.like("%" + bipOrderBackParmVO.getCustAccountName() + "%"));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bipOrderBackParmVO.getBuName())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderBackDO.buName.like("%" + bipOrderBackParmVO.getBuName() + "%"));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bipOrderBackParmVO.getBackReason())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderBackDO.backReason.eq((Object)bipOrderBackParmVO.getBackReason()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bipOrderBackParmVO.getBackType())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderBackDO.backType.eq((Object)bipOrderBackParmVO.getBackType()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bipOrderBackParmVO.getReceiverName())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderBackDO.receiverName.like("%" + bipOrderBackParmVO.getReceiverName() + "%"));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bipOrderBackParmVO.getReceiverTel())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderBackDO.receiverTel.like("%" + bipOrderBackParmVO.getReceiverTel() + "%"));
            }
            if (Objects.nonNull(bipOrderBackParmVO.getCreateTime())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderBackDO.createTime.eq((Object)bipOrderBackParmVO.getCreateTime()));
            }
            if (Objects.nonNull(bipOrderBackParmVO.getSignTime())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderBackDO.signTime.eq((Object)bipOrderBackParmVO.getSignTime()));
            }
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)this.qBipOrderBackDO.getMetadata()));
        }
        return predicate;
    }

    public BipOrderBackRespVO findPolymerizeOrderBack(Long orderBackId) {
        BipOrderBackDO bipOrderBackDO = (BipOrderBackDO)this.bipOrderBackRepo.findById(orderBackId).get();
        BipOrderBackRespVO bipOrderBackRespVO = BipOrderBackConvert.INSTANCE.doToresp(bipOrderBackDO);
        BipOrderBackDParmVO bipOrderBackDParmVO = new BipOrderBackDParmVO();
        bipOrderBackDParmVO.setOrderBackId(orderBackId);
        List list = this.bipOrderBackDService.findBipOrderBackD(bipOrderBackDParmVO);
        if (null != list && !list.isEmpty()) {
            list.stream().forEach(l -> {
                Long skuId = l.getSkuId();
                BipItemSkuDO skuDO = (BipItemSkuDO)this.bipItemSkuRepo.findById(skuId).get();
                l.setItemCode(skuDO.getSkuCode());
                l.setItemName(skuDO.getItemName());
            });
        }
        bipOrderBackRespVO.setBipOrderBackDRespVOList(list);
        this.findStatusName(bipOrderBackRespVO);
        this.findBackTypeName(bipOrderBackRespVO);
        this.findBackResonName(bipOrderBackRespVO);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bipOrderBackDO.getFileCodes())) {
            bipOrderBackRespVO.setFileCodes(bipOrderBackDO.getFileCodes().split(","));
        }
        return bipOrderBackRespVO;
    }

    public PagingVO<BipOrderBackRespVO> findUserOrderBack(BipOrderBackUserParmVO bipOrderBackUserParmVO) {
        CurrentUserDTO currentUser = UserService.currentUser();
        Long userId = currentUser.getUserId();
        if (currentUser == null || userId == null) {
            throw new BusinessException("\u8bf7\u5148\u767b\u5f55!");
        }
        BooleanExpression predicate = this.qBipOrderBackDO.isNotNull();
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderBackDO.custAccountId.eq((Object)userId));
        Page page = this.bipOrderBackRepo.findAll((Predicate)predicate, (Pageable)bipOrderBackUserParmVO.getPageRequest());
        List bipOrderBackRespVOList = page.getContent().stream().map(BipOrderBackConvert.INSTANCE::doToresp).collect(Collectors.toList());
        bipOrderBackRespVOList.stream().forEach(bipOrderBackRespVO -> {
            this.findStatusName((BipOrderBackRespVO)bipOrderBackRespVO);
            this.findBackTypeName((BipOrderBackRespVO)bipOrderBackRespVO);
            this.findBackResonName((BipOrderBackRespVO)bipOrderBackRespVO);
            List<BipOrderBackDDO> bipOrderBackDDOList = this.bipOrderBackDRepo.findByOrderBackId(bipOrderBackRespVO.getId());
            List<BipOrderBackDRespVO> bipOrderBackDRespVOS = BipOrderBackDConvert.INSTANCE.dosToresps(bipOrderBackDDOList);
            log.info("\u8ba2\u5355\u660e\u7ec6\u96c6\u5408\u2014\u2014" + JSON.toJSONString(bipOrderBackDDOList));
            List skuIds = bipOrderBackDDOList.stream().filter(bipOrderDRespVO -> bipOrderDRespVO.getSkuId() != null).map(bipOrderDRespVO -> bipOrderDRespVO.getSkuId()).distinct().collect(Collectors.toList());
            List bipItemSkuDOS = this.bipItemSkuRepo.findAllById(skuIds);
            log.info("\u8ba2\u5355\u660e\u7ec6sku\u96c6\u5408\u2014\u2014" + JSON.toJSONString((Object)bipItemSkuDOS));
            Map<Long, List<BipItemSkuDO>> skuMap = bipItemSkuDOS.stream().collect(Collectors.groupingBy(BaseModel::getId));
            bipOrderBackDRespVOS.stream().forEach(bipOrderBackDRespVO -> {
                Optional optionalBipItemDO;
                List skus;
                BipOrderDDO bipOrderDDO = (BipOrderDDO)this.bipOrderDRepo.findById(bipOrderBackDRespVO.getOrderDId()).get();
                bipOrderBackDRespVO.setBuyAmt(bipOrderDDO.getBuyAmt());
                if (bipOrderBackDRespVO.getSkuId() != null && (skus = (List)skuMap.get(bipOrderBackDRespVO.getSkuId())) != null & skus.size() > 0) {
                    BipItemSkuDO skuDO = (BipItemSkuDO)skus.get(0);
                    List<BipItemSkuAttrRespVO> attrList = this.convert2List(skuDO.getAttr(), BipItemSkuAttrRespVO.class);
                    ArrayList<CallSite> list = new ArrayList<CallSite>();
                    for (int i = 0; i < attrList.size(); ++i) {
                        BipItemSkuAttrRespVO bipItemSkuAttrRespVO = (BipItemSkuAttrRespVO)JSON.parseObject((String)JSON.toJSONString((Object)attrList.get(0)), BipItemSkuAttrRespVO.class);
                        if (bipItemSkuAttrRespVO == null) continue;
                        list.add((CallSite)((Object)(bipItemSkuAttrRespVO.getName() + ":" + bipItemSkuAttrRespVO.getValue())));
                    }
                    String attstr = String.join((CharSequence)";", list);
                    bipOrderBackDRespVO.setItemAttr(attstr);
                }
                if (bipOrderBackDRespVO.getItemId() != null && null != (optionalBipItemDO = this.bipItemRepo.findById(bipOrderBackDRespVO.getItemId())) && !optionalBipItemDO.isEmpty()) {
                    BipItemDO bipItemDO = (BipItemDO)optionalBipItemDO.get();
                    bipOrderBackDRespVO.setItemPicFileCode(bipItemDO.getMainPicFileCode());
                    bipOrderBackDRespVO.setItemTitle(bipItemDO.getTitle());
                }
            });
            bipOrderBackRespVO.setBipOrderBackDRespVOList(bipOrderBackDRespVOS);
        });
        return PagingVO.builder().total(page.getTotalElements()).records(bipOrderBackRespVOList).build();
    }

    @SysCodeProc
    public BipOrderBackRespVO findOrderBackDetailById(Long id) {
        BipOrderBackDO bipOrderBackDO = (BipOrderBackDO)this.bipOrderBackRepo.findById(id).get();
        BipOrderBackRespVO bipOrderBackRespVO = BipOrderBackConvert.INSTANCE.doToresp(bipOrderBackDO);
        bipOrderBackDO.setLogisCompany(bipOrderBackDO.getLogisCompany());
        List<BipOrderBackDDO> bipOrderBackDDOList = this.bipOrderBackDRepo.findByOrderBackId(id);
        List<BipOrderBackDRespVO> bipOrderBackDRespVOS = BipOrderBackDConvert.INSTANCE.dosToresps(bipOrderBackDDOList);
        log.info("\u8ba2\u5355\u660e\u7ec6\u96c6\u5408\u2014\u2014" + JSON.toJSONString(bipOrderBackDDOList));
        List skuIds = bipOrderBackDDOList.stream().filter(bipOrderDRespVO -> bipOrderDRespVO.getSkuId() != null).map(bipOrderDRespVO -> bipOrderDRespVO.getSkuId()).distinct().collect(Collectors.toList());
        List bipItemSkuDOS = this.bipItemSkuRepo.findAllById(skuIds);
        log.info("\u8ba2\u5355\u660e\u7ec6sku\u96c6\u5408\u2014\u2014" + JSON.toJSONString((Object)bipItemSkuDOS));
        Map<Long, List<BipItemSkuDO>> skuMap = bipItemSkuDOS.stream().collect(Collectors.groupingBy(BaseModel::getId));
        bipOrderBackDRespVOS.stream().forEach(bipOrderBackDRespVO -> {
            List skus;
            if (bipOrderBackDRespVO.getSkuId() != null && (skus = (List)skuMap.get(bipOrderBackDRespVO.getSkuId())) != null & skus.size() > 0) {
                BipItemSkuDO skuDO = (BipItemSkuDO)skus.get(0);
                List<BipItemSkuAttrRespVO> attrList = this.convert2List(skuDO.getAttr(), BipItemSkuAttrRespVO.class);
                ArrayList<CallSite> list = new ArrayList<CallSite>();
                for (int i = 0; i < attrList.size(); ++i) {
                    BipItemSkuAttrRespVO bipItemSkuAttrRespVO = (BipItemSkuAttrRespVO)JSON.parseObject((String)JSON.toJSONString((Object)attrList.get(0)), BipItemSkuAttrRespVO.class);
                    if (bipItemSkuAttrRespVO == null) continue;
                    list.add((CallSite)((Object)(bipItemSkuAttrRespVO.getName() + ":" + bipItemSkuAttrRespVO.getValue())));
                }
                String attstr = String.join((CharSequence)";", list);
                bipOrderBackDRespVO.setItemAttr(attstr);
            }
            if (bipOrderBackDRespVO.getItemId() != null) {
                BipItemDO bipItemDO = (BipItemDO)this.bipItemRepo.findById(bipOrderBackDRespVO.getItemId()).get();
                bipOrderBackDRespVO.setItemPicFileCode(bipItemDO.getMainPicFileCode());
            }
        });
        this.findStatusName(bipOrderBackRespVO);
        this.findBackResonName(bipOrderBackRespVO);
        bipOrderBackRespVO.setBipOrderBackDRespVOList(bipOrderBackDRespVOS);
        return bipOrderBackRespVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateOrderBackLogistInfo(BipOrderBackLogistSaveVO bipOrderBackLogistSaveVO) {
        if (bipOrderBackLogistSaveVO.getId() == null) {
            throw new BusinessException("ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BipOrderBackDO bipOrderBackDO = (BipOrderBackDO)this.bipOrderBackRepo.findById(bipOrderBackLogistSaveVO.getId()).get();
        BipOrderBackConvert.INSTANCE.logisSaveVOToDo(bipOrderBackLogistSaveVO, bipOrderBackDO);
        bipOrderBackDO.setStatus(UdcEnum.SAL_RSO_STATUS_RTING.getValueCode());
        bipOrderBackDO.setLogisCompany(bipOrderBackLogistSaveVO.getLogisCompany());
        this.bipOrderBackRepo.save(bipOrderBackDO);
        SalDoReturnTOBSaveDTO salDoReturnTOBSaveDTO = new SalDoReturnTOBSaveDTO();
        salDoReturnTOBSaveDTO.setDocNo(bipOrderBackDO.getOrderBackDocNo());
        salDoReturnTOBSaveDTO.setShiptranNo(bipOrderBackLogistSaveVO.getLogistDocNo());
        salDoReturnTOBSaveDTO.setRecvContactName(bipOrderBackLogistSaveVO.getReceiverName());
        salDoReturnTOBSaveDTO.setRecvContactTel(bipOrderBackLogistSaveVO.getReceiverTel());
        salDoReturnTOBSaveDTO.setFlag("3");
        QBipOrderDO qBipOrderDO = QBipOrderDO.bipOrderDO;
        BooleanExpression expression = qBipOrderDO.docNo.eq((Object)bipOrderBackDO.getOrderDocNo()).and((Predicate)qBipOrderDO.deleteFlag.eq((Object)0));
        Optional optional = this.bipOrderRepo.findOne((Predicate)expression);
        if (optional.isPresent()) {
            BipOrderDO order = (BipOrderDO)optional.get();
            salDoReturnTOBSaveDTO.setRecvProvince(order.getProvince());
            salDoReturnTOBSaveDTO.setRecvCity(order.getCity());
            salDoReturnTOBSaveDTO.setRecvCounty(order.getCounty());
            salDoReturnTOBSaveDTO.setRecvDetailaddr(order.getDetailAddr());
            salDoReturnTOBSaveDTO.setLogisCarrierNo(bipOrderBackLogistSaveVO.getLogisCompany());
        } else {
            log.info("\u540c\u6b65\u8ba2\u5355\u4e2d\u5fc3\u7269\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
        }
        try {
            log.info("----------\u540c\u6b65\u8ba2\u5355\u4e2d\u5fc3\u7269\u6d41\u4fe1\u606f------------" + JSON.toJSONString((Object)salDoReturnTOBSaveDTO));
            log.info("\u540c\u6b65\u8ba2\u5355\u4e2d\u5fc3\u7269\u6d41\u4fe1\u606f\u5b8c\u6210");
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u8ba2\u5355\u4e2d\u5fc3\u7269\u6d41\u4fe1\u606f" + e.getMessage());
            throw e;
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateCheckStatus(BipOrderBackSaveVO bipOrderBackSaveVO) {
        CurrentUserDTO user;
        List<BipOrderBackDDO> bipOrderBackDDOList;
        log.info("\u66f4\u65b0\u9000\u8d27\u5355\u5ba1\u6838\u72b6\u6001:---------" + JSON.toJSONString((Object)bipOrderBackSaveVO));
        if (bipOrderBackSaveVO.getId() == null) {
            throw new BusinessException("ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (bipOrderBackSaveVO.getStatus() == null) {
            throw new BusinessException("\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        BipOrderBackDO orderBackDO = (BipOrderBackDO)this.bipOrderBackRepo.findById(bipOrderBackSaveVO.getId()).orElseThrow(() -> new BusinessException("\u4e0d\u5b58\u5728\u8be5\u8bb0\u5f55\uff1a" + bipOrderBackSaveVO.getId()));
        if (!bipOrderBackSaveVO.getStatus().equals("WH") && !bipOrderBackSaveVO.getStatus().equals("WK")) {
            this.updateOrderDAllowBackNum(orderBackDO.getId());
        }
        if ((bipOrderBackDDOList = this.bipOrderBackDRepo.findByOrderBackId(bipOrderBackSaveVO.getId())) == null || bipOrderBackDDOList.isEmpty()) {
            throw new BusinessException("\u9000\u8d27\u5355\u660e\u7ec6\u4e3a\u7a7a!");
        }
        BigDecimal approveAmt = bipOrderBackDDOList.stream().map(bipOrderBackDDO -> {
            if (null != bipOrderBackDDO.getApproveBackAmt()) {
                return bipOrderBackDDO.getApproveBackAmt();
            }
            return BigDecimal.ZERO;
        }).reduce(BigDecimal::add).get();
        orderBackDO.setStatus(bipOrderBackSaveVO.getStatus());
        orderBackDO.setApproveBackAmt(approveAmt);
        if (UdcEnum.SAL_RSO_STATUS_RJ.getValueCode().equals(orderBackDO.getStatus())) {
            this.updateOrderDAllowBackNum(bipOrderBackSaveVO.getId());
        }
        if ((user = UserService.currentUser()) != null) {
            orderBackDO.setApproveUserId(user.getUserId());
            orderBackDO.setApproveUserName(user.getDetail().getFirstName());
        }
        orderBackDO.setApproveTime(LocalDateTime.now());
        this.bipOrderBackToOmsServiceimpl.updateBackOrder(bipOrderBackDDOList, bipOrderBackSaveVO.getStatus());
        this.bipOrderBackRepo.save(orderBackDO);
    }

    @Transactional(rollbackFor={Exception.class})
    public void submit(BipOrderBackSaveVO bipOrderBackSaveVO) {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u5230\u83b7\u53d6\u5f53\u524d\u7528\u6237");
        }
        this.transactionTemplate.setPropagationBehavior(3);
        BipOrderBackDO bipOrderBackDO1 = (BipOrderBackDO)this.transactionTemplate.execute(transactionStatus -> {
            try {
                ArrayList<BipOrderBackDDO> bipOrderBackDDOS = new ArrayList<BipOrderBackDDO>();
                for (BipOrderBackDSaveVO dSaveVO : bipOrderBackSaveVO.getBipOrderBackDSaveVOS()) {
                    Optional byId = this.bipOrderBackDRepo.findById(dSaveVO.getId());
                    if (!byId.isPresent()) continue;
                    BipOrderBackDDO backDDO = (BipOrderBackDDO)byId.get();
                    backDDO.setApproveBackAmt(dSaveVO.getApproveBackAmt());
                    backDDO.setIsWorkOrder(dSaveVO.getIsWorkOrder());
                    bipOrderBackDDOS.add(backDDO);
                }
                this.bipOrderBackDRepo.saveAll(bipOrderBackDDOS);
                this.bipOrderBackToOmsServiceimpl.updateBackOrder(bipOrderBackDDOS, bipOrderBackSaveVO.getStatus());
                return (BipOrderBackDO)this.bipOrderBackRepo.findById(bipOrderBackSaveVO.getId()).get();
            }
            catch (Exception e) {
                transactionStatus.setRollbackOnly();
                throw e;
            }
        });
        if (!StringUtils.isEmpty((Object)bipOrderBackSaveVO.getProcInstId())) {
            throw new BusinessException("\u53ea\u6709\u672a\u8d77\u8fc7\u5de5\u4f5c\u6d41\u7684\u5355\u5b50\u624d\u80fd\u5f00\u59cb\u5ba1\u6279,\u8bf7\u68c0\u67e5");
        }
        String procInstName = "B\u7aef\u5546\u57ce\u9000\u8d27";
        ProcDefKey procDefKey = ProcDefKey.TOB_SALE_RETURN;
    }

    @Transactional(rollbackFor={Exception.class})
    public void cancle(Long id) {
        this.updateOrderDAllowBackNum(id);
        this.bipOrderBackRepoProc.updateStatus(id, "CL");
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateOrderDAllowBackNum(Long id) {
        BipOrderBackDO bipOrderBackDO = (BipOrderBackDO)this.bipOrderBackRepo.findById(id).get();
        Long orderId = bipOrderBackDO.getOrderId();
        List<BipOrderBackDDO> bipOrderBackDDOList = this.bipOrderBackDRepo.findByOrderBackId(id);
        for (BipOrderBackDDO bipOrderBackDDO : bipOrderBackDDOList) {
            Long orderDId = bipOrderBackDDO.getOrderDId();
            Long backNum = bipOrderBackDDO.getBackNum();
            Optional optional = this.bipOrderDRepo.findById(orderDId);
            if (!optional.isPresent()) continue;
            BipOrderDDO orderDDO = (BipOrderDDO)optional.get();
            orderDDO.setAllowBackNum(orderDDO.getAllowBackNum() + backNum);
            this.bipOrderDRepo.save(orderDDO);
        }
    }

    public void findStatusName(BipOrderBackRespVO bipOrderBackRespVO) {
        Map statusMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "RSO_STATUS");
        if (statusMap != null) {
            String statusName = (String)statusMap.get(bipOrderBackRespVO.getStatus());
            bipOrderBackRespVO.setStatusName(statusName);
        }
    }

    public void findBackTypeName(BipOrderBackRespVO bipOrderBackRespVO) {
        Map backTypeMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "SO_BACK_TYPE");
        if (backTypeMap != null) {
            String statusName = (String)backTypeMap.get(bipOrderBackRespVO.getBackType());
            bipOrderBackRespVO.setBackTypeName(statusName);
        }
    }

    public void findBackResonName(BipOrderBackRespVO bipOrderBackRespVO) {
        Map backReasonMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "SO_RETURN_REASON");
        if (backReasonMap != null) {
            String reasonName = (String)backReasonMap.get(bipOrderBackRespVO.getBackReason());
            bipOrderBackRespVO.setBackReasonName(reasonName);
        }
    }

    public CPCN5021Resp cpcn5011Request(Long backOrderId) {
        return null;
    }

    public BipOrderBackServiceImpl(RmiSysNextNumberService rmiSysNextNumberService, TransactionTemplate transactionTemplate) {
        this.rmiSysNextNumberService = rmiSysNextNumberService;
        this.transactionTemplate = transactionTemplate;
    }
}

