/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCustUserBineSimpleRespVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.dto.save.BipOrderRpcDto;
import com.elitesland.yst.production.sale.entity.BipMessageDO;
import com.elitesland.yst.production.sale.entity.BipOrderDDO;
import com.elitesland.yst.production.sale.entity.BipOrderDO;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipMessageRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderDRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderRepoProc;
import com.elitesland.yst.production.sale.service.BipOrderRpcService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"/rpc/cloudt/sale/order"})
public class BipOrderRpcServiceImpl
implements BipOrderRpcService {
    private static final Logger log = LoggerFactory.getLogger(BipOrderRpcServiceImpl.class);
    @Autowired
    private BipOrderRepoProc bipOrderRepoProc;
    @Autowired
    private BipOrderDRepo bipOrderDRepo;
    @Autowired
    private BipOrderRepo bipOrderRepo;
    @Autowired
    private BipMessageRepo bipMessageRepo;
    @Autowired
    private BipCustUserBindRepoProc bipCustUserBindRepoProc;

    @Override
    public ApiResult updateOrderLogistInfo(List<BipOrderRpcDto> bipOrderRpcDtoList) {
        ArrayList<BipOrderDDO> bipOrderDDOS = new ArrayList<BipOrderDDO>();
        for (BipOrderRpcDto bipOrderRpcDto : bipOrderRpcDtoList) {
            if (bipOrderRpcDto.getOrderDId() == null) {
                throw new BusinessException("\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            BipOrderDDO bipOrderDDo = (BipOrderDDO)this.bipOrderDRepo.findById(bipOrderRpcDto.getOrderDId()).get();
            bipOrderDDo.setLogisNo(bipOrderRpcDto.getLogistNo());
            bipOrderDDo.setLogisId(bipOrderRpcDto.getLogistId());
            bipOrderDDOS.add(bipOrderDDo);
        }
        this.bipOrderDRepo.saveAll(bipOrderDDOS);
        return ApiResult.ok();
    }

    @Override
    public ApiResult updateorderStatus(BipOrderRpcDto bipOrderRpcDto) {
        if (bipOrderRpcDto.getId() == null) {
            throw new BusinessException("\u9000\u8d27\u4e3b\u8868ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)bipOrderRpcDto.getStatus())) {
            throw new BusinessException("\u9000\u8d27\u4e3b\u8868\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        log.info("\u8fdc\u7a0b\u540c\u6b65\u9000\u8d27\u5355\u72b6\u6001\u53c2\u6570\u4fe1\u606f:" + JSON.toJSONString((Object)bipOrderRpcDto));
        this.bipOrderRepoProc.updatStatusByIdAndStatus(bipOrderRpcDto.getId(), bipOrderRpcDto.getStatus());
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult shipMentMessagePush(List<String> bipShipMentOrderCodes) {
        log.info("\u53d1\u8d27\u6d88\u606f\u63a8\u9001\u8ba2\u5355\u7f16\u7801\u5165\u53c2{}", (Object)JSON.toJSONString(bipShipMentOrderCodes));
        List<BipOrderDO> bipOrderDOS = this.bipOrderRepo.findAllByDocNoIn(bipShipMentOrderCodes);
        List<Long> custIds = bipOrderDOS.stream().map(BipOrderDO::getCustId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List<BipCustUserBineSimpleRespVO> userIdByCustId = this.bipCustUserBindRepoProc.getUserIdByCustId(custIds);
        List bipMessageDOS = bipOrderDOS.stream().map(mes -> {
            BipMessageDO bipMessageDO = new BipMessageDO();
            bipMessageDO.setTitle("\u3010\u53d1\u8d27\u901a\u77e5\u3011");
            bipMessageDO.setContext("\u60a8\u6709\u8ba2\u5355\u5df2\u53d1\u8d27");
            bipMessageDO.setStatus(UdcEnum.MESSAGE_STATUS_NOTREAD.getValueCode());
            Optional<BipCustUserBineSimpleRespVO> simpleRespVO = userIdByCustId.stream().filter(user -> user.getCustId().equals(mes.getCustId())).findFirst();
            if (!simpleRespVO.isPresent()) {
                throw new BusinessException("\u8ba2\u5355\u3010" + mes.getDocNo() + "\u3011\u7684\u5ba2\u6237\u672a\u7ed1\u5b9a\u7528\u6237");
            }
            bipMessageDO.setToCustId(simpleRespVO.get().getUserId());
            return bipMessageDO;
        }).collect(Collectors.toList());
        this.bipMessageRepo.saveAll(bipMessageDOS);
        return null;
    }

    @Override
    public ApiResult updateOrderIsSend(List<String> orderCodes) {
        try {
            this.bipOrderRepoProc.updateOrderIsSend(orderCodes);
        }
        catch (Exception e) {
            log.info("OMS\u8c03\u7528\u540c\u6b65\u8ba2\u5355\u662f\u5426\u53d1\u8d27\u72b6\u6001\u5b57\u6bb5\u5f02\u5e38" + e);
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25:" + e.getMessage());
        }
        return ApiResult.ok();
    }
}

