package com.elitesland.yst.production.sale.config.cas.support;

import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.cloudt.authorization.api.provider.provider.user.AbstractUserDetailManager;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.sale.config.cas.UserSourceService;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;

import javax.validation.constraints.NotBlank;
import java.util.List;
import java.util.function.Supplier;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/29
 */
@Log4j2
public class CustomUserDetailManager extends AbstractUserDetailManager {

    private final UserSourceService userSourceService;

    private TenantClientProvider tenantClientProvider;
    private TenantDataIsolateProvider tenantDataIsolateProvider;

    public CustomUserDetailManager(AuthorizationProperties authorizationProperties, UserSourceService userSourceService) {
        super(authorizationProperties);
        this.userSourceService = userSourceService;
    }

    @Override
    public GeneralUserDetails loadUserByUsername(@NotBlank String username) {
        log.info("根据用户名登录,用户名为【"+username+"】");
        return this.loadUser(() -> userSourceService.loadUserByUsername(username));
    }

    @Override
    public GeneralUserDetails loadUserByMobile(@NotBlank String mobile) {
        log.info("根据手机号登录,手机号为【"+mobile+"】");
        return this.loadUser(() -> userSourceService.loadUserByMobile(mobile));
//        log.error("暂不支持根据手机号登录");
//        throw new AuthorizationException("登录失败");
    }

    @Override
    public GeneralUserDetails loadUserByEmail(@NotBlank String email) {
        log.error("暂不支持根据邮箱登录");
        throw new AuthorizationException("登录失败");
    }

//    @Override
//    public GeneralUserDetails loadUserById(@NotBlank String id) {
//        log.error("暂不支持根据用户ID登录");
//        throw new AuthorizationException("登录失败");
//    }

    @Override
    public GeneralUserDetails loadUserById(@NotBlank String id) {
        log.info("根据用户ID为【"+id+"】");
        return this.loadUser(() -> userSourceService.loadUserById(Long.valueOf(id)));
//        log.error("暂不支持根据用户ID登录");
//        throw new AuthorizationException("登录失败");
    }

    @Override
    public GeneralUserDetails loadUserByAccount(@NotBlank String account) {
        log.error("暂不支持根据账号登录");
        throw new AuthorizationException("登录失败");
    }

    @Override
    public GeneralUserDetails loadUserByWechatOpenid(@NotBlank String openId) {
        log.error("暂不支持根据微信号号登录");
        throw new AuthorizationException("登录失败");
    }

    private GeneralUserDetails loadUser(Supplier<SysUserDTO> userDTOSupplier) {
        // 查询用户信息
        SysUserDTO user = tenantDataIsolateProvider.byNone(userDTOSupplier::get);
        if (user == null) {
            return null;
        }

        if (tenantClientProvider.enabledTenant()) {
            var tenant = tenantClientProvider.getCurrentTenant();
            if (tenant != null) {
                user.setSysTenantVO(tenant);
                user.setSysTenantDTOList(List.of(tenant));
            }
        }

        return super.wrapUserDetails(user);
    }

    @Autowired(required = false)
    public void setTenantClientProvider(TenantClientProvider tenantClientProvider) {
        this.tenantClientProvider = tenantClientProvider;
    }

    @Autowired
    public void setTenantDataIsolateProvider(TenantDataIsolateProvider tenantDataIsolateProvider) {
        this.tenantDataIsolateProvider = tenantDataIsolateProvider;
    }
}
