package com.elitesland.yst.production.sale.controller.logistics;

import com.elitesland.yst.production.sale.api.service.LogisticsTemplateService;
import com.elitesland.yst.production.sale.api.vo.param.logistics.LogisticsTemplateParam;
import com.elitesland.yst.production.sale.api.vo.param.logistics.LogisticsTemplateSaveParam;
import com.elitesland.yst.production.sale.api.vo.resp.logistics.BaseAreaVO;
import com.elitesland.yst.production.sale.api.vo.resp.logistics.LogisticsTemplateDVO;
import com.elitesland.yst.production.sale.api.vo.resp.logistics.LogisticsTemplateVO;
import com.elitesland.yst.production.sale.api.vo.resp.menu.BusFirstMenuConfVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 运费模板
 */
@RestController
@RequestMapping(value = "/logistics/conf", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "运费模板")
@RequiredArgsConstructor
public class LogisticsTemplateController extends BaseController {


    private final LogisticsTemplateService  logisticsTemplateService;


    @PostMapping(value = "/pageList")
    @ApiOperation(value = "运费模板列表分页")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<LogisticsTemplateVO>> findPagingResult(@RequestBody LogisticsTemplateParam logisticsTemplateParam){
        PagingVO<LogisticsTemplateVO> list = logisticsTemplateService.findPagingResult(logisticsTemplateParam);
        return ApiResult.ok(list);
    }

    @PostMapping(value = "/findCouponById/{id}")
    @ApiOperation(value = "根据ID查询运费模板信息")
    @ApiOperationSupport(order = 1)
    public ApiResult<LogisticsTemplateVO> findCouponById(@PathVariable Long id){
        LogisticsTemplateVO logisticsTemplateVO = logisticsTemplateService.findCouponById(id);
        return ApiResult.ok(logisticsTemplateVO);
    }


    @PostMapping(value = "/saveLogistics")
    @ApiOperation(value = "保存/修改运费模板")
    @ApiOperationSupport(order = 2)
    public ApiResult<Object> saveLogistics(@RequestBody LogisticsTemplateSaveParam logisticsTemplateParam){
        return logisticsTemplateService.saveLogistics(logisticsTemplateParam);
    }


    @PostMapping(value = "/delLogistics")
    @ApiOperation(value = "删除运费模板")
    @ApiOperationSupport(order = 3)
    public ApiResult<Object> delLogistics(@RequestBody List<Long> ids){
        return logisticsTemplateService.delLogistics(ids);
    }


    @PostMapping(value = "/openLogistics")
    @ApiOperation(value = "启用运费模板")
    @ApiOperationSupport(order = 4)
    public ApiResult<Object> openLogistics(@RequestBody List<Long> ids){
        return logisticsTemplateService.openLogistics(ids);
    }


    @PostMapping(value = "/stopLogistics")
    @ApiOperation(value = "停用运费模板")
    @ApiOperationSupport(order = 5)
    public ApiResult<Object> stopLogistics(@RequestBody List<Long> ids){
        return logisticsTemplateService.stopLogistics(ids);
    }

    @GetMapping(value = "/getprovince")
    @ApiOperation(value = "获取所有省份")
    @ApiOperationSupport(order = 6)
    public ApiResult<List<BaseAreaVO>> getprovince(){
        List<BaseAreaVO> list = logisticsTemplateService.getProvince();
        return ApiResult.ok(list);
    }

    @GetMapping(value = "/getCityByProvince/{id}")
    @ApiOperation(value = "获取省份下的市")
    @ApiOperationSupport(order = 7)
    public ApiResult<List<BaseAreaVO>> getCityByProvince(@PathVariable Long id){
        List<BaseAreaVO> list = logisticsTemplateService.getCityByProvince(id);
        return ApiResult.ok(list);
    }









//    @PostMapping(value = "/searchByArea")
//    @ApiOperation(value = "停用运费模板")
//    @ApiOperationSupport(order = 5)
//    public ApiResult<Object> stopLogistics(@RequestBody List<Long> ids){
//        return logisticsTemplateService.stopLogistics(ids);
//    }


}
