package com.elitesland.yst.production.sale.controller.sal;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.SalQuotationService;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalQuotationQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalOuDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalQuoTranContactRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalQuotationDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalQuotationPageRespVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import com.elitesland.yst.production.sale.core.util.excel.support.ExportColumnParam;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import io.seata.spring.annotation.GlobalTransactional;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/15 19:11
 */
@RestController
@RequestMapping(value = "/sal/quotation", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "销售报价主表")
@Slf4j
public class SalQuotationController extends BaseController {

    private final SalQuotationService salQuotationService;

    public SalQuotationController(SalQuotationService salQuotationService) {
        this.salQuotationService = salQuotationService;
    }

    @PostMapping(value = "/search")
    @ApiOperation(value = "分页查询销售报价主数据")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<SalQuotationPageRespVO>> search(@RequestBody SalQuotationQueryParamVO searchParam) {
        return ApiResult.ok(salQuotationService.search(searchParam));
    }

    @PostMapping(value = "/submitSalQuotation")
    @ApiOperation(value = "提交销售报价信息")
    @ApiOperationSupport(order = 7)
//    @GlobalTransactional
    public ApiResult<Long> submitSalQuotation(@RequestBody SalQuotationDetailRespVO salQuotationDetailRespVO) {
        return ApiResult.ok(salQuotationService.submitSalQuotation(salQuotationDetailRespVO));
    }

    @PostMapping(value = "/exportData")
    @ApiOperation(value = "销售报价单导出")
    @ApiOperationSupport(order = 5)
    public ApiResult<Long> exportSalQuotation(HttpServletResponse response, @RequestBody SalQuotationQueryParamVO salQuotationQueryParamVO) {
        //导出列
        List<ExportColumnParam> columnParamList = new ArrayList<>(16);
        //确定导出字段
        columnParamList.add(new ExportColumnParam("ouName", "公司名称"));
        columnParamList.add(new ExportColumnParam("agentEmpName", "业务员"));
        columnParamList.add(new ExportColumnParam("docNo", "报价单号"));
        columnParamList.add(new ExportColumnParam("quotationDate2", "报价日期"));
        columnParamList.add(new ExportColumnParam("custCode", "客户编码"));
        columnParamList.add(new ExportColumnParam("custName", "客户名称"));
        columnParamList.add(new ExportColumnParam("custContactName", "客户联系人"));
        columnParamList.add(new ExportColumnParam("custContactTel", "客户联系人电话"));
        columnParamList.add(new ExportColumnParam("itemCode", "商品编码"));
        columnParamList.add(new ExportColumnParam("itemName", "商品名称"));
        columnParamList.add(new ExportColumnParam("itemSpec", "规格型号"));
        columnParamList.add(new ExportColumnParam("qty", "数量"));
        columnParamList.add(new ExportColumnParam("uomName", "计量单位"));
        columnParamList.add(new ExportColumnParam("price", "含税单价"));
        columnParamList.add(new ExportColumnParam("amt", "含税金额"));
        columnParamList.add(new ExportColumnParam("taxRate2", "税率"));
        columnParamList.add(new ExportColumnParam("remark", "备注"));
        try {
            export(response, "发货单导出数据", columnParamList, paramVO -> salQuotationService.searchForExport(paramVO).getData(), salQuotationQueryParamVO);
        } catch (Exception e) {
            throw new BusinessException("导出失败");
        }
        return ApiResult.ok();
    }

    @GetMapping(value = "/get/{id}")
    @ApiOperation(value = "查询销售报价详细信息")
    @ApiOperationSupport(order = 2)
    public ApiResult<SalQuotationDetailRespVO> getSalQuotationById(@PathVariable Long id) {
        return ApiResult.ok(salQuotationService.findSalQuotationById(id));
    }

    @PostMapping(value = "/createSalQuotation")
    @ApiOperation(value = "保存销售报价信息")
    @ApiOperationSupport(order = 3)
    public ApiResult<Long> createSalQuotation(@RequestBody SalQuotationDetailRespVO salQuotationDetailRespVO) {
        return ApiResult.ok(salQuotationService.createSalQuotation(salQuotationDetailRespVO));
    }
}