package com.elitesland.yst.production.sale.controller.shop;

import com.elitesland.yst.production.sale.api.service.shop.BipCartService;
import com.elitesland.yst.production.sale.api.service.shop.BipItemService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCartParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipFareAmtQueryParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipBuyNowSettleParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipCartSettleParmVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCartVo;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.AttrAPPRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.AttrAppParamVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/16/13:33
 * @Description:
 */

@RestController
@RequestMapping(value = "/bip/cart")
@Api(value = "购物车",tags = "购物车")
@Slf4j
public class BipItemCartController {
    @Autowired
    private BipCartService bipCartService;

    @Autowired
    private BipItemService bipItemService;

    @PostMapping(value = "/find/{ouId}")
    @ApiOperation(value = "我的购物车")
    @ApiOperationSupport(order = 1)
    public ApiResult<BipCartVo> findMyCart(@PathVariable Long ouId){
        BipCartVo bipCartVo=bipCartService.findMyCart(ouId);
        if(bipCartVo==null){
            return ApiResult.ok(null,"暂无购物信息!");
        }
        return ApiResult.ok(bipCartVo);
    }

    @PostMapping(value = "/update")
    @ApiOperation(value = "购物车更新")
    @ApiOperationSupport(order = 2)
    public ApiResult updateCart(@RequestBody BipCartParmVO bipCartParmVO){
        bipCartService.updateCart(bipCartParmVO);
        return ApiResult.ok();
    }


    @PostMapping(value = "/add")
    @ApiOperation(value = "购物车新增")
    @ApiOperationSupport(order = 3)
    public ApiResult addItemCart(@RequestBody BipCartParmVO bipCartParmVO){
        bipCartService.addItemToCart(bipCartParmVO);
        return ApiResult.ok();
    }

    @PostMapping(value = "/delete")
    @ApiOperation(value = "购物车删除")
    @ApiOperationSupport(order = 4)
    public ApiResult  deleteCart(@RequestBody List<Long> idList){
        bipCartService.deleteCart(idList);
        return ApiResult.ok();
    }


    // 之后调转到支付页面
    @PostMapping(value = "/per/pay/{ouId}")
    @ApiOperation(value = "购物车结算页面")
    @ApiOperationSupport(order = 5)
    public ApiResult<BipCartVo>  perPay(@RequestBody BipCartSettleParmVO bipCartSettleParmVO,@PathVariable Long ouId){
        bipCartSettleParmVO.setOuId(ouId);
        BipCartVo bipCartVo=bipCartService.findMyCartEable(bipCartSettleParmVO);
        return ApiResult.ok(bipCartVo);
    }


    @PostMapping(value = "/buyNow/per/pay")
    @ApiOperation(value = "立即购买结算页面")
    @ApiOperationSupport(order = 6)
    public ApiResult<BipCartVo> buyNowPer(@RequestBody BipBuyNowSettleParmVO bipBuyNowSettleParmVO){
        BipCartVo bipCartVo=bipCartService.findBuyNowOrderPer(bipBuyNowSettleParmVO);
        return ApiResult.ok(bipCartVo);
    }

    @PostMapping(value = "/per/pay/farefee")
    @ApiOperation(value = "结算页面获取运费信息")
    @ApiOperationSupport(order = 7)
    public ApiResult<HashMap>  buyNowPer(@RequestBody BipFareAmtQueryParmVO bipFareAmtQueryParmVO){
//        BigDecimal fareAmt=bipCartService.findFeeFare(bipFareAmtQueryParmVO);
//        HashMap<String,BigDecimal> hashMap=new HashMap();
//        hashMap.put("totalFareAmt",fareAmt);
        HashMap<String,Object> hashMap = bipCartService.findFeeFare(bipFareAmtQueryParmVO);
        return ApiResult.ok(hashMap);
    }

    @PostMapping(value = "/getAttrList")
    @ApiOperation(value = "SKU匹配")
    @ApiOperationSupport(order = 7)
    public ApiResult<List<AttrAPPRespVO>> getAttrList(@RequestBody AttrAppParamVO attrAppParamVO){
        List<AttrAPPRespVO> list = bipCartService.getAttrList(attrAppParamVO);
        return ApiResult.ok(list);
    }




}
