package com.elitesland.yst.production.sale.controller.shop;

import com.elitesland.yst.production.sale.api.service.shop.BipOrderBackDService;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderBackService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipOrderBackDParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipOrderBackParmVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipOrderBackDSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipOrderBackSaveVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/09/15/17:28
 * @Description:
 */
@RestController
@RequestMapping("/bip/orderBackD")
@Api(value = "退货单详情", tags = {"退货单详情"})
@RequiredArgsConstructor
public class BipOrderBackDController {

    @Autowired
    private BipOrderBackDService bipOrderBackDService;


    @PostMapping("/find")
    @ApiOperation("分页查询")
    @ApiOperationSupport(order = 1)
    public ApiResult findBipOrderBackPage(@RequestBody BipOrderBackDParmVO bipOrderBackDParmVO){

        return ApiResult.ok(bipOrderBackDService.findBipOrderBackD(bipOrderBackDParmVO)) ;
    }


    @PostMapping("/save")
    @ApiOperation("保存")
    @ApiOperationSupport(order = 2)
    public ApiResult saveBipOrderBack(@RequestBody BipOrderBackDSaveVO bipOrderBackDSaveVO){
        bipOrderBackDService.updateBipOrderBackD(bipOrderBackDSaveVO);
        return ApiResult.ok();
    }


    @PostMapping("/update")
    @ApiOperation("更新")
    @ApiOperationSupport(order = 3)
    public ApiResult updateBipOrderBack(@RequestBody BipOrderBackDSaveVO bipOrderBackDSaveVO){
        bipOrderBackDService.updateBipOrderBackD(bipOrderBackDSaveVO);
        return ApiResult.ok();
    }

    @PostMapping("/delete/id")
    @ApiOperation("删除")
    @ApiOperationSupport(order = 4)
    public ApiResult deleteBipOrderBackByIds(@RequestBody List<Long> ids){
        bipOrderBackDService.deleteBipOrderBackDById(ids);
        return ApiResult.ok();
    }
}
