package com.elitesland.yst.production.sale.controller.shop;

import com.elitesland.yst.production.sale.api.service.shop.MktDiscountOffsetService;
import com.elitesland.yst.production.sale.api.vo.param.shop.MktDiscountOffsetQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.MktDiscountOffsetSaveVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktDiscountOffsetRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktDiscountOffsetVO;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import netscape.javascript.JSObject;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;
import java.util.List;

/**
 * <p>
 * 功能说明：
 * </p>
 *
 * @author ssy
 * @since 2021/8/19
 */
@Slf4j
@RestController
@RequestMapping("/mkt/discountOffset")
@Api(value = "满减折扣", tags = {"满减折扣"})
@RequiredArgsConstructor
public class MktDiscountOffsetController {

    private final MktDiscountOffsetService mktDiscountOffsetService;

    @PostMapping("/search")
    @ApiOperation("分页查询(主表)")
    @ApiOperationSupport(order = 1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "param", value = "分页查询参数", required = true, dataType = "MktDiscountOffsetQueryVO")
    })
    public ApiResult<PagingVO<MktDiscountOffsetRespVO>> search(@RequestBody MktDiscountOffsetQueryVO param) {
        val ret = mktDiscountOffsetService.search(param);
        return ApiResult.ok(ret);
    }

    @GetMapping("/findCodeOne/{key}")
    @ApiOperation("根据编码查询数据（主表、明细表）")
    @ApiOperationSupport(order = 2)
    public ApiResult<MktDiscountOffsetRespVO> findCodeOne(@PathVariable String key) {
        return mktDiscountOffsetService.findCodeOne(key).map(ApiResult::ok)
                .orElse(ApiResult.fail(ApiCode.NOT_FOUND));
    }

    @GetMapping("/findIdOne/{id}")
    @ApiOperation("根据ID查询数据（主表、明细表）")
    @ApiOperationSupport(order = 3)
    public ApiResult<MktDiscountOffsetRespVO> findIdOne(@PathVariable Long id) {
        return mktDiscountOffsetService.findIdOne(id).map(ApiResult::ok)
                .orElse(ApiResult.fail(ApiCode.NOT_FOUND));
    }

    @PostMapping("/createOne")
    @ApiOperation("新增数据")
    @ApiOperationSupport(order = 4)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "param", value = "新增数据", required = true, dataType = "MktDiscountOffsetSaveVO")
    })
    public ApiResult<Object> createOne(@RequestBody MktDiscountOffsetSaveVO param) {
        return ApiResult.ok(mktDiscountOffsetService.createBatch(Collections.singletonList(param)));
    }

    @PostMapping("/createBatch")
    @ApiOperation("批量新增数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "param", value = "新增数据", required = true, dataType = "MktDiscountOffsetSaveVO")
    })
    @ApiOperationSupport(order = 5)
    public ApiResult<Object> createBatch(@RequestBody List<MktDiscountOffsetSaveVO> list) {
        return ApiResult.ok(mktDiscountOffsetService.createBatch(list));
    }

    @PutMapping("/update")
    @ApiOperation("修改数据")
    @ApiOperationSupport(order = 6)
    public ApiResult<Object> update(@RequestBody MktDiscountOffsetSaveVO param) {
        mktDiscountOffsetService.update(param);
        return ApiResult.ok();
    }

    @PatchMapping("/updateDeleteFlagBatch/{ids}")
    @ApiOperation("批量删除(逻辑删除)")
    @ApiOperationSupport(order = 7)
    public ApiResult<Object> updateDeleteFlagBatch(@PathVariable List<Long> ids) {
        mktDiscountOffsetService.updateDeleteFlagBatch(ids);
        return ApiResult.ok();
    }

    @DeleteMapping("/deleteBatch")
    @ApiOperation("批量删除(物理删除)")
    @ApiOperationSupport(order = 8)
    public ApiResult<Object> deleteBatch(@RequestBody List<Long> ids) {
        mktDiscountOffsetService.deleteBatch(ids);
        return ApiResult.ok();
    }

    @GetMapping("/findMktDiscountOffsetByParam")
    @ApiOperation("根据入参 查询符合条件的商品折扣信息")
    @ApiOperationSupport(order = 9)
    public ApiResult<List<MktDiscountOffsetVO>> findMktDiscountOffsetByParam(
            @RequestParam Long ouId,
            @RequestParam(required = false) String customLevel,
            @RequestParam List<Long> itemIds) {
        return ApiResult.ok(mktDiscountOffsetService.findMktDiscountOffsetByParam(ouId, customLevel, itemIds));
    }

    @PatchMapping(value = "/appr/{ids}/{status}")
    @ApiOperation(value = "审批(启用：ENABLE、禁用：DISABLE)")
    @ApiOperationSupport(order = 20)
    public ApiResult<JSObject> appr(@PathVariable("ids") List<Long> ids, @PathVariable("status") String status) {
        mktDiscountOffsetService.appr(ids, status);
        return ApiResult.ok();
    }
}
