package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/03/16:35
 * @Description:优惠券实体类
 */

@Entity
@Table(name = "bip_coupon", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "bip_coupon", comment = "优惠券")
@EnableJpaAuditing
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")

public class BipCouponDO extends BaseModel implements Serializable {

    @Column(name = "coupon_code", columnDefinition = "varchar(128) not null  comment '编码'")
    private String couponCode;

    @Column(name = "coupon_name", columnDefinition = "varchar(128) not null  comment '名称'")
    private String couponName;

    //优惠券类型 满减 立减
    @Column(name = "type", columnDefinition = "varchar(128) not null  comment '优惠券类型 0满减 1立减'")
    private String type;

    @Column(name = "ou_id", columnDefinition = "bigInt(20) not null  comment '公司id'")
    private Long ouId;

    @Column(name = "ou_code", columnDefinition = "varchar(32)   comment '公司编码'")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(32)    comment '公司名称'")
    private String ouName;

    @Column(name = "total_num", columnDefinition = "bigInt(20)    comment '优惠券数量'")
    private Long totalNum;

    @Column(name="cust_level",columnDefinition = "varchar(32)   comment '客户等级'")
    private String custLevel;

    @Column(name="limit_amt",columnDefinition = "decimal(20, 2)   comment '满减最低金额'")
    private BigDecimal limitAmt;

    @Column(name="free_amt",columnDefinition = "decimal(20, 2)   comment '优惠金额'")
    private BigDecimal freeAmt;

    @Column(name="state",columnDefinition = "varchar(32) default '0' comment '优惠券状态'")
    private String state;

    // 失效提前通知天数
    @Column(name = "notify_days",columnDefinition = "int(10) default 0 comment '失效提前通知天数'")
    private Integer notifyDays;

    @Column(name = "notify_time",columnDefinition = "datetime   comment '失效提前通知时间'")
    private LocalDateTime notifyTime;

    // 优惠券使用类型，匹配品类  匹配商品
    @Column(name = "match_type",columnDefinition = "varchar(32)   comment '优惠券使用类型，匹配品类  匹配商品'")
    private String matchType;

    //匹配集合
    @Column(name = "match_ids",columnDefinition = "varchar(256)   comment '匹配集合'")
    private String matchIds;

    @Column(name = "detail_info",columnDefinition = "varchar(300)   comment '详细信息'")
    private String  detailInfo;

    @Column(name = "special_area_show",columnDefinition = "varchar(32)   comment '是否专区显示'")
    private String specialAreaShow;

    @Column(name = "special_area_stime",columnDefinition = "datetime   comment '专区开始时间'")
    private LocalDateTime specialAreaStime;

    @Column(name = "special_area_etime",columnDefinition = "datetime   comment '专区结束时间'")
    private LocalDateTime specialAreaEtime;

    @Column(name = "index_page_show",columnDefinition = "varchar(32)   comment '是否首页弹出'")
    private String indexPageShow;

    @Column(name = "new_cust_show",columnDefinition = "varchar(32)   comment '是否新人专享 0不是  1是'")
    private String newCustShow;

    @Column(name = "new_cust_stime",columnDefinition = "datetime   comment '新人开始时间'")
    private LocalDateTime newCustStime;

    @Column(name = "new_cust_etime",columnDefinition = "datetime   comment '新人结束时间'")
    private LocalDateTime newCustEtime;

    @Column(name = "valid_stime",columnDefinition = "datetime   comment '生效时间'")
    private LocalDateTime validStime;

    @Column(name = "valid_etime",columnDefinition = "datetime   comment '失效时间'")
    private LocalDateTime validEtime;

    @Column(name = "receive_valid_stime",columnDefinition = "datetime   comment '领取生效时间'")
    private LocalDateTime receiveValidStime;

    @Column(name = "receive_valid_etime",columnDefinition = "datetime   comment '领取失效时间'")
    private LocalDateTime receiveValidEtime;


    @Column(name = "receive_num",columnDefinition = "bigInt(20) default 0  comment '领取数量'")
    private Integer receiveNum;


}
