package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/30
 */
@Entity
@Table(name = "bip_cust_user_bind", indexes = {
        @Index(name = "idx_bip_cust_user_bind_user", columnList = "user_id"),
        @Index(name = "idx_bip_cust_user_bind_cust", columnList = "cust_id"),
        @Index(name = "idx_bip_cust_user_bind_ou", columnList = "ou_id"),
        @Index(name = "idx_bip_cust_user_bind_emp", columnList = "agent_emp_id"),
})
@org.hibernate.annotations.Table(appliesTo = "bip_cust_user_bind", comment = "用户客户绑定关系")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class BipCustUserBindDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -7700761952753978782L;

    @Column(name = "user_id", columnDefinition = "bigint(20) comment '用户ID'")
    private Long userId;

    @Column(name = "user_name", columnDefinition = "varchar(128) not null comment '用户名，登录号'")
    private String username;

    @Column(name = "ou_id", columnDefinition = "bigint(20) comment '所属公司ID'")
    private Long ouId;

    @Column(name = "cust_id", columnDefinition = "bigint(20) comment '客户ID'")
    private Long custId;

    @Column(name = "agent_emp_id", columnDefinition = "bigint(18) comment '业务员ID'")
    private Long agentEmpId;

    @Column(name = "cust_code", columnDefinition = "varchar(64) default '' comment '客户编码'")
    private String custCode;

    @Column(name = "cust_name", columnDefinition = "varchar(128) default '' comment '客户名称'")
    private String custName;

    @Column(name = "tax_reg_no", columnDefinition = "varchar(64) default '' comment '税务登记号'")
    private String taxRegNo;

    @Column(name = "cert_file_code", columnDefinition = "varchar(64) default '' comment '营业执照的文件标识'")
    private String certFileCode;

    @Column(name = "contact_name", columnDefinition = "varchar(32) default '' comment '联系人姓名'")
    private String contactName;

    @Column(name = "contact_phone", columnDefinition = "varchar(32) default '' comment '联系人电话'")
    private String contactPhone;

    @Column(name = "time_apply", columnDefinition = "datetime default null  comment '申请绑定时间'")
    private LocalDateTime timeApply;

    @Column(name = "state", columnDefinition = "varchar(32) not null comment '状态，[UDC]SAL:CUST_USER_STATE'")
    private String state;

    @Column(name = "state_apply", columnDefinition = "varchar(32) comment '申请状态，[UDC]SAL:CUST_USER_APPLY'")
    private String stateApply;

    @Column(name = "approve_reason", columnDefinition = "varchar(1024) default '' comment '审批拒绝理由（或通过原因）'")
    private String approveReason;

    @Column(name = "time_approve", columnDefinition = "datetime default null  comment '审批时间'")
    private LocalDateTime timeApprove;

    @Column(name = "time_register", columnDefinition = "datetime default null  comment '注册时间'")
    private LocalDateTime timeRegister;
}
