package com.elitesland.yst.production.sale.entity;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import org.hibernate.annotations.Where;

/**
 * @author : http://www.chiner.pre
 * @date : 2023-4-12
 * @desc : 执行记录
 */
@Entity
@Table(name="execut_record")
@org.hibernate.annotations.Table(appliesTo = "execut_record", comment = "执行记录")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class ExecutRecordDO extends BaseModel {

    @Column(name = "code", columnDefinition = "varchar(255) comment '执行记录编码'")
    private String code;

    @Column(name = "task_code", columnDefinition = "varchar(255) comment '任务编码'")
    private String taskCode;

    @Column(name = "task_id", columnDefinition = "bigint(20) comment '任务id'")
    private Long taskId;

    @Column(name = "task_dtl_id", columnDefinition = "bigint(20) comment '任务明细id'")
    private Long taskDtlId;

    @Column(name = "task_name", columnDefinition = "varchar(255) comment '任务名称'")
    private String taskName;

    @Column(name = "task_type", columnDefinition = "varchar(255) comment '任务类型'")
    private String taskType;

    @Column(name = "publish_user", columnDefinition = "varchar(255) comment '发布人'")
    private String publishUser;

    @Column(name = "publish_user_id", columnDefinition = "bigint(20) comment '发布人id'")
    private Long publishUserId;

    @Column(name = "publish_user_code", columnDefinition = "varchar(255) comment '发布人code'")
    private String publishUserCode;

    @Column(name = "state", columnDefinition = "varchar(255) comment '状态'")
    private String state;

    @Column(name = "execut_user", columnDefinition = "varchar(255) comment '执行人'")
    private String executUser;

    @Column(name = "execut_user_id", columnDefinition = "bigint(20) comment '执行人id'")
    private Long executUserId;

    @Column(name = "execut_user_code", columnDefinition = "varchar(255) comment '执行人code'")
    private String executUserCode;

    @Column(name = "business_type", columnDefinition = "varchar(255) comment '业务类型'")
    private String businessType;

    @Column(name = "business_id", columnDefinition = "bigint(20) comment '业务'")
    private Long businessId;

    @Column(name = "business_code", columnDefinition = "varchar(255) comment '业务编码'")
    private String businessCode;

    @Column(name = "business_name", columnDefinition = "varchar(255) comment '业务名称'")
    private String businessName;

    @Column(name = "start_time", columnDefinition = "datetime(6) comment '开始时间'")
    private LocalDateTime startTime;

    @Column(name = "end_time", columnDefinition = "datetime(6) comment '结束时间'")
    private LocalDateTime endTime;

    @Column(name = "audit_desc", columnDefinition = "varchar(255) comment '审核内容'")
    private String auditDesc;


}