package com.elitesland.yst.production.sale.ext.cpcn.resp;

import lombok.Data;
/**
 * @author yifansir(jin yan qiang)
 * @date 2021/8/4
 */
@Data
public class CPCN5018Req {
    /**
     * 机构编码
     */
    private String institutionID;
    /**
     * 订单编号
     */
    private String orderNo;
    /**
     * 交易流水号
     */
    private String txSN;
    /**
     * 交易金额(单位:分)
     */
    private String amount;
    /**
     * 可用分账金额(单位:分)
     */
    private String availableSplitAmount;
    /**
     * 支付状态
     * 10=未支付
     * 20=支付处理中
     * 30=支付成功
     * 40=支付失败
     * 50=订单关闭
     */
    private String status;
    /**
     * 支付方式
     */
    private String paymentWay;
    /**
     * 收款用户手续费总金额(单位:分)
     */
    private String payeeUserFee;
    /**
     * 付款人手续费总金额(单位:分)
     */
    private String payerUserFee;
    /**
     * 聚合支付类型
     */
    private String qRPaymentType;
    /**
     * 聚合支付方式
     */
    private String qRPaymentWay;
    /**
     * 支付类型
     */
    private String orderType;
    /**
     * 收款人名称
     */
    private String payeeName;
    /**
     * 收款人账号
     */
    private String payeeAccountNumber;
    /**
     * 实际支付方式
     */
    private String actualPayType;
    /**
     * 申码系统流水号
     */
    private String applyCodeNO;
    /**
     * 支付回单流水号
     */
    private String bankTraceNo;
    /**
     * 平台订单号
     */
    private String traceNo;
    /**
     * 付款银行
     */
    private String bankID;
    /**
     * 付款账户名称
     */
    private String payerAccountName;
    /**
     * 付款账户账号
     */
    private String payerAccountNumber;
    /**
     * 分支行
     */
    private String payerBranchName;
    /**
     * 省
     */
    private String payerProvince;
    /**
     * 城市
     */
    private String payerCity;
    /**
     * 分期银行
     */
    private String installmentBankID;
    /**
     * 分期期数
     */
    private String installmentPeriods;
    /**
     * 分期期数
     */
    private String expireTime;
    /**
     * 付款用户ID
     */
    private String payerID;
    /**
     * 实际支付方式
     */
    private String subOpenID;
    /**
     * 实际支付银行卡类型:
     *  10=余额
     *  20=借记卡
     *  30=贷记卡
     *  40=其他
     */
    private String actualCardType;
    /**
     * 转账识别码
     */
    private String udID;
    /**
     * 用信申请URL
     */
    private String creditPayURL;
    /**
     * 银行处理时间
     */
    private String responseTime;
    /**
     * 响应代码
     */
    private String responseCode;
    /**
     * 响应消息
     */
    private String responseMessage;
}
