package com.elitesland.yst.production.sale.repo;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.FileInfoQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.FileInfoRespVO;
import com.elitesland.yst.production.sale.entity.QFileInfoDO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author : http://www.chiner.pre
 * @date : 2023-4-12
 * @desc : 文件信息RepoProc
 */
@Component
public class FileInfoRepoProc {

    private final QFileInfoDO qFileInfoDO = QFileInfoDO.fileInfoDO;
    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    public PagingVO<FileInfoRespVO> page(FileInfoQueryVO fileInfoPageParam) {
        JPAQuery<FileInfoRespVO> query = select(FileInfoRespVO.class)
                .where(bulidPredicate(fileInfoPageParam));
        fileInfoPageParam.setPaging(query);
        fileInfoPageParam.fillOrders(query, qFileInfoDO);
        return PagingVO.<FileInfoRespVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }


    public Long del(List<Long> ids) {
        Long res = jpaQueryFactory.update(qFileInfoDO)
                .set(qFileInfoDO.deleteFlag, 1)
                .where(qFileInfoDO.id.in(ids))
                .execute();
        return res;
    }


    public FileInfoRespVO get(Long id) {
        FileInfoRespVO fileInfoVO = select(FileInfoRespVO.class)
                .where(qFileInfoDO.id.eq(id))
                .fetchOne();
        return fileInfoVO;
    }


    public List<FileInfoRespVO> getList(FileInfoQueryVO fileInfoPageParam) {
        List<FileInfoRespVO> res = select(FileInfoRespVO.class)
                .where(bulidPredicate(fileInfoPageParam))
                .fetch();
        return res;
    }


    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qFileInfoDO.url,
                qFileInfoDO.code,
                qFileInfoDO.sourceId,
                qFileInfoDO.sourceType,
                qFileInfoDO.fileName,
                qFileInfoDO.fileType,
                qFileInfoDO.filePath,
                qFileInfoDO.oldFileName,
                qFileInfoDO.fileSize,
                qFileInfoDO.fileInfo,
                qFileInfoDO.id,
                qFileInfoDO.createTime,
                qFileInfoDO.remark,
                qFileInfoDO.updater,
                qFileInfoDO.modifyTime
        )).from(qFileInfoDO);
    }


    private Predicate bulidPredicate(FileInfoQueryVO fileInfoPageParam) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder()
                .andEq(StringUtils.isNotBlank(fileInfoPageParam.getUrl()), qFileInfoDO.url, fileInfoPageParam.getUrl())
                .andEq(StringUtils.isNotBlank(fileInfoPageParam.getCode()), qFileInfoDO.code, fileInfoPageParam.getCode())
                .andEq(null != fileInfoPageParam.getSourceId(), qFileInfoDO.sourceId, fileInfoPageParam.getSourceId())
                .andIn(CollectionUtils.isNotEmpty(fileInfoPageParam.getSourceIds()), qFileInfoDO.sourceId, fileInfoPageParam.getSourceIds())
                .andEq(StringUtils.isNotBlank(fileInfoPageParam.getSourceType()), qFileInfoDO.sourceType, fileInfoPageParam.getSourceType())
                .andEq(StringUtils.isNotBlank(fileInfoPageParam.getFileName()), qFileInfoDO.fileName, fileInfoPageParam.getFileName())
                .andEq(StringUtils.isNotBlank(fileInfoPageParam.getOldFileName()), qFileInfoDO.oldFileName, fileInfoPageParam.getOldFileName())
                .andEq(StringUtils.isNotBlank(fileInfoPageParam.getFileSize()), qFileInfoDO.fileSize, fileInfoPageParam.getFileSize())
                .andEq(StringUtils.isNotBlank(fileInfoPageParam.getFileInfo()), qFileInfoDO.fileInfo, fileInfoPageParam.getFileInfo())
                .build();
        return predicate;
    }

    public Long sourceDel(List<Long> ids) {
        Long res = jpaQueryFactory.update(qFileInfoDO)
                .set(qFileInfoDO.deleteFlag, 1)
                .where(qFileInfoDO.sourceId.in(ids))
                .execute();
        return res;
    }
}
