package com.elitesland.yst.production.sale.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsStoreQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsStoreRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsStoreSumRespVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.entity.QSaleStatisticsStoreDO;
import com.elitesland.yst.production.sale.entity.QSaleStatisticsStoreDtlDO;
import com.elitesland.yst.production.sale.entity.SaleStatisticsStoreDO;
import com.querydsl.core.types.*;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.impl.JPAQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;


/**
 * @author : WWW
 * @date : 2023-5-22
 * @desc : 销售业绩统计-门店RepoProc
 */

@Component
public class SaleStatisticsStoreRepoProc extends BaseRepoProc<SaleStatisticsStoreDO> {

    private static final QSaleStatisticsStoreDO QDO = QSaleStatisticsStoreDO.saleStatisticsStoreDO;
    private static final QSaleStatisticsStoreDtlDO DTL_DO = QSaleStatisticsStoreDtlDO.saleStatisticsStoreDtlDO;

    private final String SHIP_TOTAL_QTY = "shipTotalQty";
    private final String STORE_TOTAL_QTY = "storeTotalQty";

    protected SaleStatisticsStoreRepoProc() {

        super(QDO);

    }


    public PagingVO<SaleStatisticsStoreRespVO>  pcPage(SaleStatisticsStoreQueryVO saleStatisticsStorePageParam) {


        JPAQuery<SaleStatisticsStoreRespVO> query = selectTwo(SaleStatisticsStoreRespVO.class)
                .where(ExpressionUtils.allOf(bulidPredicatePc(saleStatisticsStorePageParam)))
                .groupBy(QDO.region, QDO.storeCode, QDO.dealerCode, QDO.salesmanPath, QDO.vehicleType, QDO.docTime);



        if (!Objects.isNull(saleStatisticsStorePageParam.getShipTotalQtyFrom())) {
            query.having(QDO.shipQty.sum().goe(saleStatisticsStorePageParam.getShipTotalQtyFrom()));
        }
        if (!Objects.isNull(saleStatisticsStorePageParam.getShipTotalQtyTo())) {
            query.having(QDO.shipQty.sum().loe(saleStatisticsStorePageParam.getShipTotalQtyTo()));
        }
        saleStatisticsStorePageParam.setPaging(query);
        if (CollectionUtils.isNotEmpty(saleStatisticsStorePageParam.getOrders())) {
            for (OrderItem orderItem : saleStatisticsStorePageParam.getOrders()) {
                if (StringUtils.isNotBlank(orderItem.getColumn())) {
                    Order order = orderItem.isAsc() ? Order.ASC : Order.DESC;
                    OrderSpecifier orderSpecifier3 = new OrderSpecifier(order,
                            Expressions.stringTemplate(orderItem.getColumn()));
                    query.orderBy(orderSpecifier3);
                }
            }
        }
        query.orderBy(QDO.docTime.desc());
        query.orderBy(QDO.createTime.desc());

        return PagingVO.<SaleStatisticsStoreRespVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }

    public PagingVO<SaleStatisticsStoreRespVO> appPage(SaleStatisticsStoreQueryVO saleStatisticsStorePageParam) {

        JPAQuery<SaleStatisticsStoreRespVO> query = selectTwo(SaleStatisticsStoreRespVO.class)
                .where(ExpressionUtils.allOf(bulidPredicatePc(saleStatisticsStorePageParam)))
                .groupBy(QDO.region, QDO.storeCode, QDO.dealerCode, QDO.salesmanPath, QDO.docTime);

        if (!Objects.isNull(saleStatisticsStorePageParam.getShipTotalQtyFrom())) {
            query.having(QDO.shipQty.sum().goe(saleStatisticsStorePageParam.getShipTotalQtyFrom()));
        }
        if (!Objects.isNull(saleStatisticsStorePageParam.getShipTotalQtyTo())) {
            query.having(QDO.shipQty.sum().loe(saleStatisticsStorePageParam.getShipTotalQtyTo()));
        }

        saleStatisticsStorePageParam.setPaging(query);
//        query.orderBy(QDO.docTime.yearMonth().desc());
        if (CollectionUtils.isNotEmpty(saleStatisticsStorePageParam.getOrders())) {
            for (OrderItem orderItem : saleStatisticsStorePageParam.getOrders()) {
                if (StringUtils.isNotBlank(orderItem.getColumn())) {
                    Order order = orderItem.isAsc() ? Order.ASC : Order.DESC;
                    OrderSpecifier orderSpecifier3 = new OrderSpecifier(order,
                            Expressions.stringTemplate(orderItem.getColumn()));
                    query.orderBy(orderSpecifier3);
                }
            }
        }
        query.orderBy(QDO.docTime.desc());
        query.orderBy(QDO.createTime.desc());

        return PagingVO.<SaleStatisticsStoreRespVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }

    public List<SaleStatisticsStoreRespVO> query(SaleStatisticsStoreQueryVO saleStatisticsStorePageParam) {

        JPAQuery<SaleStatisticsStoreRespVO> query = selectTwo(SaleStatisticsStoreRespVO.class)
                .where(ExpressionUtils.allOf(detailBulidPredicate(saleStatisticsStorePageParam)))
                .groupBy(QDO.itemType3, QDO.vehicleType, QDO.docTime);
        if (!Objects.isNull(saleStatisticsStorePageParam.getShipTotalQtyFrom())) {
            query.having(QDO.shipQty.sum().goe(saleStatisticsStorePageParam.getShipTotalQtyFrom()));
        }
        if (!Objects.isNull(saleStatisticsStorePageParam.getShipTotalQtyTo())) {
            query.having(QDO.shipQty.sum().loe(saleStatisticsStorePageParam.getShipTotalQtyTo()));
        }
        return query.fetch();

    }

    public StatisticsStoreSumRespVO pageSum(SaleStatisticsStoreQueryVO saleStatisticsStorePageParam) {
        JPAQuery<StatisticsStoreSumRespVO> query = jpaQueryFactory.select(
                        Projections.bean(StatisticsStoreSumRespVO.class,
                                        QDO.storeCode.countDistinct().as(STORE_TOTAL_QTY),
                                        QDO.shipQty.sum().as(SHIP_TOTAL_QTY)))
                .from(QDO)
                .where(ExpressionUtils.allOf(bulidPredicate(saleStatisticsStorePageParam)));
        return query.fetchFirst();
    }




    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(QDO)
                .set(QDO.deleteFlag, 1)
                .where(QDO.id.in(ids))

                .execute();
        return res;

    }


    public SaleStatisticsStoreRespVO get(Long id) {

        SaleStatisticsStoreRespVO saleStatisticsStoreVO = select(SaleStatisticsStoreRespVO.class)
                .where(QDO.id.eq(id))
                .fetchOne();

        return saleStatisticsStoreVO;

    }


    public List<SaleStatisticsStoreRespVO> getList(SaleStatisticsStoreQueryVO saleStatisticsStorePageParam) {

        List<SaleStatisticsStoreRespVO> res = select(SaleStatisticsStoreRespVO.class)
                .where(ExpressionUtils.allOf(bulidPredicate(saleStatisticsStorePageParam)))
                .fetch();

        return res;

    }

    public List<SaleStatisticsStoreRespVO> getByCustCode(SaleStatisticsStoreQueryVO saleStatisticsStorePageParam) {

        List<SaleStatisticsStoreRespVO> res = select(SaleStatisticsStoreRespVO.class)
                .where(ExpressionUtils.allOf(bulidPredicate(saleStatisticsStorePageParam)))
                .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return jpaQueryFactory.select(Projections.bean(cls,
                QDO.docTime,
                QDO.storeCode,
                QDO.storeName,
                QDO.empCode,
                QDO.empName,
                QDO.userId2,
                QDO.storeName,
                QDO.dealerCode,
                QDO.dealerName,
                QDO.dealerSerialNo,
                QDO.storeType2,
                QDO.region,
                QDO.type,
                QDO.salesmanPath,
                QDO.vehicleType,
                QDO.itemType3,
                QDO.shipQty,
                QDO.id,
                QDO.detailAddr,
                QDO.createTime,
                QDO.remark,
                QDO.updateRegionFailureReason,
                QDO.updateSalesmanFailureReason
        )).from(QDO);

    }

    private <T> JPAQuery<T> selectTwo(Class<T> cls) {

        return jpaQueryFactory.select(Projections.bean(cls,
                QDO.docTime,
                QDO.storeCode,
                QDO.storeName,
                QDO.empCode,
                QDO.empName,
                QDO.userId2,
                QDO.dealerCode,
                QDO.storeType2,
                QDO.dealerName,
                QDO.dealerSerialNo,
                QDO.region,
                QDO.type,
                QDO.salesmanPath,
                QDO.vehicleType,
                QDO.itemType3,
                QDO.shipQty.sum().as(SHIP_TOTAL_QTY),
                QDO.id,
                QDO.createTime,
                QDO.detailAddr,
                QDO.remark,
                QDO.updateRegionFailureReason,
                QDO.updateSalesmanFailureReason
        )).from(QDO);

    }


    private List<Predicate> bulidPredicate(SaleStatisticsStoreQueryVO param) {
        List<Predicate> predicates = new ArrayList<>();
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder()
                .andGoe(null != param.getDocTimeStart(), QDO.docTime, LocalDateTime.of((param.getDocTimeStart() == null? LocalDateTime.now():param.getDocTimeStart()).toLocalDate() , LocalTime.MIN))
                .andLoe(null != param.getDocTimeEnd(), QDO.docTime, LocalDateTime.of((param.getDocTimeEnd() == null? LocalDateTime.now():param.getDocTimeEnd()).toLocalDate() , ConstantsSale.LOCAL_TIME_MAX))
                .andLike(StringUtils.isNotBlank(param.getStoreCode()), QDO.storeCode, param.getStoreCode())
                .andLike(StringUtils.isNotBlank(param.getStoreName()), QDO.storeName, param.getStoreName())
                .andEq(StringUtils.isNotBlank(param.getDealerCode()), QDO.dealerCode, param.getDealerCode())
                .andEq(StringUtils.isNotBlank(param.getDealerName()), QDO.dealerName, param.getDealerName())
                .andEq(StringUtils.isNotBlank(param.getEmpName()), QDO.empName, param.getEmpName())
                .andEq(StringUtils.isNotBlank(param.getEmpCode()), QDO.empCode, param.getEmpCode())
                .andEq(StringUtils.isNotBlank(param.getDealerSerialNo()), QDO.dealerSerialNo, param.getDealerSerialNo())
                .andEq(StringUtils.isNotBlank(param.getType()), QDO.type, param.getType())
                .andEq(StringUtils.isNotBlank(param.getVehicleType()), QDO.vehicleType, param.getVehicleType())
                .andEq(StringUtils.isNotBlank(param.getItemType3()), QDO.itemType3, param.getItemType3())
                .andEq(StringUtils.isNotBlank(param.getStoreType2()), QDO.storeType2, param.getStoreType2())
                .andLike(StringUtils.isNotBlank(param.getDetailAddr()), QDO.detailAddr, param.getDetailAddr())
                .andEq(null != param.getShipQty(), QDO.shipQty, param.getShipQty())
                .andEq(StringUtils.isNotBlank(param.getRegion()), QDO.region, param.getRegion())
                .andIn(!CollectionUtils.isEmpty(param.getIds()), QDO.id, param.getIds())
                .andIn(!CollectionUtils.isEmpty(param.getDealerCodeList()), QDO.dealerCode, param.getDealerCodeList())
                .build();

        predicates.add(predicate);
        if (!StringUtils.isEmpty(param.getDealerKeyword())) {
            predicates.add(QDO.dealerCode.like("%" + param.getDealerKeyword() + "%").or(QDO.dealerName.like("%" + param.getDealerKeyword() + "%")));
        }
        if (!StringUtils.isEmpty(param.getKeyword())) {
            predicates.add(QDO.storeCode.like("%" + param.getKeyword() + "%").or(QDO.storeName.like("%" + param.getKeyword() + "%")));
        }
        if (Objects.nonNull(param.getDocMonth())) {
            BooleanExpression booleanTemplate = Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m')", QDO.docTime)
                    .eq(param.getDocMonth());
            predicates.add(booleanTemplate);
        }
        if (Objects.equals(param.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_YES.getValueCode())){
            predicates.add(QDO.region.isNull());
        }
        if (Objects.equals(param.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_NO.getValueCode())){
            predicates.add(QDO.region.isNotNull());
        }
        if (Objects.equals(param.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_YES.getValueCode())){
            predicates.add(QDO.salesmanPath.isNull());
        }
        if (Objects.equals(param.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_NO.getValueCode())){
            predicates.add(QDO.salesmanPath.isNotNull());
        }
        return predicates;

    }

    private List<Predicate> bulidPredicatePc(SaleStatisticsStoreQueryVO param) {
        List<Predicate> predicates = new ArrayList<>();
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder()
                .andGoe(null != param.getDocTimeStart(), QDO.docTime, LocalDateTime.of((param.getDocTimeStart() == null? LocalDateTime.now():param.getDocTimeStart()).toLocalDate() , LocalTime.MIN))
                .andLoe(null != param.getDocTimeEnd(), QDO.docTime, LocalDateTime.of((param.getDocTimeEnd() == null? LocalDateTime.now():param.getDocTimeEnd()).toLocalDate() , ConstantsSale.LOCAL_TIME_MAX))
                .andLike(StringUtils.isNotBlank(param.getStoreCode()), QDO.storeCode, param.getStoreCode())
                .andLike(StringUtils.isNotBlank(param.getStoreName()), QDO.storeName, param.getStoreName())
                .andEq(StringUtils.isNotBlank(param.getDealerCode()), QDO.dealerCode, param.getDealerCode())
                .andEq(StringUtils.isNotBlank(param.getDealerName()), QDO.dealerName, param.getDealerName())
                .andEq(StringUtils.isNotBlank(param.getEmpName()), QDO.empName, param.getEmpName())
                .andEq(StringUtils.isNotBlank(param.getEmpCode()), QDO.empCode, param.getEmpCode())
                .andEq(StringUtils.isNotBlank(param.getDealerSerialNo()), QDO.dealerSerialNo, param.getDealerSerialNo())
                .andEq(StringUtils.isNotBlank(param.getType()), QDO.type, param.getType())
                .andEq(StringUtils.isNotBlank(param.getVehicleType()), QDO.vehicleType, param.getVehicleType())
                .andEq(StringUtils.isNotBlank(param.getItemType3()), QDO.itemType3, param.getItemType3())
                .andEq(StringUtils.isNotBlank(param.getStoreType2()), QDO.storeType2, param.getStoreType2())
                .andLike(StringUtils.isNotBlank(param.getDetailAddr()), QDO.detailAddr, param.getDetailAddr())
                .andEq(null != param.getShipQty(), QDO.shipQty, param.getShipQty())
                .andEq(StringUtils.isNotBlank(param.getRegion()), QDO.region, param.getRegion())
                .andIn(!CollectionUtils.isEmpty(param.getIds()), QDO.id, param.getIds())
                .andIn(!CollectionUtils.isEmpty(param.getDealerCodeList()), QDO.dealerCode, param.getDealerCodeList())
                .build();

        predicates.add(predicate);
        if (!StringUtils.isEmpty(param.getDealerKeyword())) {
            predicates.add(QDO.dealerCode.like("%" + param.getDealerKeyword() + "%").or(QDO.dealerName.like("%" + param.getDealerKeyword() + "%")));
        }
        if (!StringUtils.isEmpty(param.getKeyword())) {
            predicates.add(QDO.storeCode.like("%" + param.getKeyword() + "%").or(QDO.storeName.like("%" + param.getKeyword() + "%")));
        }
        if (Objects.nonNull(param.getDocMonth())) {
            BooleanExpression booleanTemplate = Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m')", QDO.docTime)
                    .eq(param.getDocMonth());
            predicates.add(booleanTemplate);
        }
        if (Objects.equals(param.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_YES.getValueCode())){
            predicates.add(QDO.region.isNull());
        }
        if (Objects.equals(param.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_NO.getValueCode())){
            predicates.add(QDO.region.isNotNull());
        }
        if (Objects.equals(param.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_YES.getValueCode())){
            predicates.add(QDO.salesmanPath.isNull());
        }
        if (Objects.equals(param.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_NO.getValueCode())){
            predicates.add(QDO.salesmanPath.isNotNull());
        }

        if(!Objects.isNull(param.getAgentEmp())){
            predicates.add(QDO.id.in(JPAExpressions
                    .select(DTL_DO.masId)
                    .from(DTL_DO)
                    .where(DTL_DO.deleteFlag.eq(0)
                            .and(DTL_DO.code.eq(param.getAgentEmp())))));
        }
        return predicates;

    }

    /**
     * 明细单独调用predicate
     * @param param
     * @return
     */
    private List<Predicate> detailBulidPredicate(SaleStatisticsStoreQueryVO param) {
        List<Predicate> predicates = new ArrayList<>();
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder()
                .andGoe(null != param.getDocTimeStart(), QDO.docTime, LocalDateTime.of(param.getDocTimeStart().toLocalDate(), LocalTime.MIN))
                .andLoe(null != param.getDocTimeEnd(), QDO.docTime, LocalDateTime.of(param.getDocTimeEnd().toLocalDate(), ConstantsSale.LOCAL_TIME_MAX))
                .andLike(StringUtils.isNotBlank(param.getStoreCode()), QDO.storeCode, param.getStoreCode())
                .andLike(StringUtils.isNotBlank(param.getStoreName()), QDO.storeName, param.getStoreName())
                .andEq(StringUtils.isNotBlank(param.getDealerCode()), QDO.dealerCode, param.getDealerCode())
                .andEq(StringUtils.isNotBlank(param.getDealerName()), QDO.dealerName, param.getDealerName())
                .andEq(StringUtils.isNotBlank(param.getEmpName()), QDO.empName, param.getEmpName())
                .andEq(StringUtils.isNotBlank(param.getEmpCode()), QDO.empCode, param.getEmpCode())
                .andEq(StringUtils.isNotBlank(param.getDealerSerialNo()), QDO.dealerSerialNo, param.getDealerSerialNo())
                .andEq(StringUtils.isNotBlank(param.getType()), QDO.type, param.getType())
                .andEq(StringUtils.isNotBlank(param.getVehicleType()), QDO.vehicleType, param.getVehicleType())
                .andEq(StringUtils.isNotBlank(param.getItemType3()), QDO.itemType3, param.getItemType3())
                .andEq(StringUtils.isNotBlank(param.getStoreType2()), QDO.storeType2, param.getStoreType2())
                .andLike(StringUtils.isNotBlank(param.getDetailAddr()), QDO.detailAddr, param.getDetailAddr())
                .andEq(null != param.getShipQty(), QDO.shipQty, param.getShipQty())
                .andEq(StringUtils.isNotBlank(param.getRegion()), QDO.region, param.getRegion())
                .andIn(!CollectionUtils.isEmpty(param.getIds()), QDO.id, param.getIds())
                .build();

        predicates.add(predicate);
        if (!StringUtils.isEmpty(param.getDealerKeyword())) {
            predicates.add(QDO.dealerCode.like("%" + param.getDealerKeyword() + "%").or(QDO.dealerName.like("%" + param.getDealerKeyword() + "%")));
        }
        if (!StringUtils.isEmpty(param.getKeyword())) {
            predicates.add(QDO.storeCode.like("%" + param.getKeyword() + "%").or(QDO.storeName.like("%" + param.getKeyword() + "%")));
        }
        if (StringUtils.isEmpty(param.getAgentEmp())) {
            predicates.add(QDO.salesmanPath.isNull());
        }
        if (StringUtils.isEmpty(param.getRegion())) {
            predicates.add(QDO.region.isNull());
        }else{
            predicates.add(QDO.region.eq(param.getRegion()));
        }
        if (Objects.nonNull(param.getDocMonth())) {
            BooleanExpression booleanTemplate = Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m')", QDO.docTime)
                    .eq(param.getDocMonth());
            predicates.add(booleanTemplate);
        }
        if (Objects.equals(param.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_YES.getValueCode())){
            predicates.add(QDO.region.isNull());
        }
        if (Objects.equals(param.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_NO.getValueCode())){
            predicates.add(QDO.region.isNotNull());
        }
        if (Objects.equals(param.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_YES.getValueCode())){
            predicates.add(QDO.salesmanPath.isNull());
        }
        if (Objects.equals(param.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_NO.getValueCode())){
            predicates.add(QDO.salesmanPath.isNotNull());
        }

        if (StringUtils.isNotBlank(param.getAgentEmp())) {
            predicates.add(QDO.id.in(JPAExpressions
                    .select(DTL_DO.masId)
                    .from(DTL_DO)
                    .where(DTL_DO.code.eq(param.getAgentEmp()))));
        }
        return predicates;

    }

    public List<SaleStatisticsStoreRespVO> storeQuery(SaleStatisticsStoreQueryVO paramVO) {

        JPAQuery<SaleStatisticsStoreRespVO> query = selectTwo(SaleStatisticsStoreRespVO.class)
                .where(ExpressionUtils.allOf(bulidPredicate(paramVO)))
                .groupBy(QDO.region, QDO.storeCode, QDO.dealerCode, QDO.salesmanPath, QDO.vehicleType, QDO.docTime);

        if (!Objects.isNull(paramVO.getShipTotalQtyFrom())) {
            query.having(QDO.shipQty.sum().goe(paramVO.getShipTotalQtyFrom()));
        }
        if (!Objects.isNull(paramVO.getShipTotalQtyTo())) {
            query.having(QDO.shipQty.sum().loe(paramVO.getShipTotalQtyTo()));
        }
        return query.fetch();
    }

    public Predicate querySumDetailWhere(SaleStatisticsStoreQueryVO param) {
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if (!StringUtils.isEmpty(param.getDealerCode())) {
            predicate = ExpressionUtils.and(predicate,QDO.dealerCode.eq(param.getDealerCode()));
        }
        if (!StringUtils.isEmpty(param.getStoreCode())) {
            predicate = ExpressionUtils.and(predicate,QDO.storeCode.eq(param.getStoreCode()));
        }
        if (!StringUtils.isEmpty(param.getSalesmanPath())) {
            predicate = ExpressionUtils.and(predicate,QDO.salesmanPath.eq(param.getSalesmanPath()));
        }
        if (!StringUtils.isEmpty(param.getRegion())) {
            predicate = ExpressionUtils.and(predicate,QDO.region.eq(param.getRegion()));
        }
        if (Objects.nonNull(param.getDocTime())) {
            predicate = ExpressionUtils.and(predicate,QDO.docTime.eq(param.getDocTime()));
        }
        if (Objects.nonNull(param.getDocMonth())) {
            BooleanExpression booleanTemplate = Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m')", QDO.docTime)
                    .eq(param.getDocMonth());
            predicate = ExpressionUtils.and(predicate, booleanTemplate);
        }
        return predicate;
    }


    /**
     * 根据客户编码查询主表ID，按id正序排列
     * @param custCode
     * @param minId
     * @param limit
     * @return
     */
    public List<Long> findIdsByCustCode(String custCode, Long minId, int limit) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(QDO.id)
                .from(QDO)
                .where(QDO.dealerCode.eq(custCode))
                .orderBy(QDO.id.asc())
                .limit(limit);
        if(minId != null){
            jpaQuery.where(QDO.id.gt(minId));
        }

        return jpaQuery.fetch();
    }
}
