package com.elitesland.yst.production.sale.repo.common;

import com.elitesland.yst.production.sale.api.vo.param.com.DeAccountRoleParam;
import com.elitesland.yst.production.sale.api.vo.resp.com.DeAccountRoleVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.entity.QDeAccountRoleDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2023/2/22 20:14
 */
@Component
@RequiredArgsConstructor
public class DeAccountRoleRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QDeAccountRoleDO qLmAccountRoleDO = QDeAccountRoleDO.deAccountRoleDO;

    private final QBean<DeAccountRoleVO> lmAccountRoleVOQBean = Projections.fields(
            DeAccountRoleVO.class,
            qLmAccountRoleDO.id,
            qLmAccountRoleDO.tenantId,
            qLmAccountRoleDO.modifyUserId,
            qLmAccountRoleDO.createUserId,
            qLmAccountRoleDO.createTime,
            qLmAccountRoleDO.creator,
            qLmAccountRoleDO.modifyTime,
            qLmAccountRoleDO.updater,
            qLmAccountRoleDO.deleteFlag,
            qLmAccountRoleDO.userId,
            qLmAccountRoleDO.remark,
            qLmAccountRoleDO.roleCode,
            qLmAccountRoleDO.roleName,
            qLmAccountRoleDO.dealerType,
            qLmAccountRoleDO.businessType,
            qLmAccountRoleDO.sonRoleFlag,
            qLmAccountRoleDO.roleId
    );
    

    public List<DeAccountRoleVO> getRole(DeAccountRoleParam param) {
        JPAQuery<DeAccountRoleVO> vojpaQuery = jpaQueryFactory.select(lmAccountRoleVOQBean)
                .from(qLmAccountRoleDO)
                .where(where(param));
        return vojpaQuery.fetch();
    }

    private Predicate where(DeAccountRoleParam param) {
        Predicate predicate = qLmAccountRoleDO.isNotNull();

        // 经销商类型
        if (!ObjectUtils.isEmpty(param.getDealerType())) {
            predicate = ExpressionUtils.and(predicate, qLmAccountRoleDO.dealerType.eq(param.getDealerType()));
            // 是否是子权限
            if (!ObjectUtils.isEmpty(param.getSonRoleFlag())) {
                predicate = ExpressionUtils.and(predicate, qLmAccountRoleDO.sonRoleFlag.eq(param.getSonRoleFlag()));
                if (UdcEnum.ROLE_BU_TYPE_VE.getValueCode().equals(param.getBusinessType())) {
                    predicate = ExpressionUtils.and(predicate, qLmAccountRoleDO.businessType.ne(UdcEnum.ROLE_BU_TYPE_VEPAOR.getValueCode()));
                }
                if (UdcEnum.ROLE_BU_TYPE_PA.getValueCode().equals(param.getBusinessType())){
                    predicate = ExpressionUtils.and(predicate, qLmAccountRoleDO.businessType
                            .in(UdcEnum.ROLE_BU_TYPE_PAOR.getValueCode(),UdcEnum.ROLE_BU_TYPE_OR.getValueCode()));
                }if (UdcEnum.ROLE_BU_TYPE_NULL.getValueCode().equals(param.getBusinessType())){
                    predicate = ExpressionUtils.and(predicate, qLmAccountRoleDO.businessType.eq(UdcEnum.ROLE_BU_TYPE_OR.getValueCode()));
                }
            }else if (!ObjectUtils.isEmpty(param.getBusinessType())) {
                // 业务类型
                predicate = ExpressionUtils.and(predicate, qLmAccountRoleDO.businessType.eq(param.getBusinessType()));
            }
        }

        // 用户id
        if (!ObjectUtils.isEmpty(param.getUserId())){
            predicate = ExpressionUtils.and(predicate, qLmAccountRoleDO.userId.eq(param.getUserId()));
        }

        return predicate;
    }
}
