package com.elitesland.yst.production.sale.repo.shop;

import com.elitesland.yst.production.sale.entity.QBipFavoritesDo;
import com.elitesland.workflow.utils.CollUtils;
import com.mysql.cj.x.protobuf.MysqlxCrud;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/9/30 19:45
 */
@Repository
public class BipFavoritesRepoProc {

    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    private final QBipFavoritesDo qBipFavoritesDo = QBipFavoritesDo.bipFavoritesDo;
    /**
     * 判断商品是否已被收藏
     *
     *
     * @param accountId 账户id
     * @param itemId 客户ID集合
     * @return 客户名称
     */
    public Boolean exists(Long accountId, Long itemId) {
        Predicate predicate = qBipFavoritesDo.deleteFlag.eq(0).or(qBipFavoritesDo.deleteFlag.isNull());
        predicate = ObjectUtils.isEmpty(accountId) ? predicate : ExpressionUtils.and(predicate, qBipFavoritesDo.custAccountId.eq(accountId));
        predicate = ObjectUtils.isEmpty(itemId) ? predicate : ExpressionUtils.and(predicate, qBipFavoritesDo.itemId.eq(itemId));
        return jpaQueryFactory.select(qBipFavoritesDo)
                .from(qBipFavoritesDo)
                .where(predicate)
                .fetchCount() > 0;
    }

}
