package com.elitesland.yst.production.sale.repo.shop;


import com.elitesland.yst.production.sale.api.vo.param.shop.BipMessageQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipMessageVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipFirstMessage;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.entity.QBipMessageDO;
import com.querydsl.core.types.dsl.Expressions;
import org.springframework.util.StringUtils;

import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import lombok.val;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

/**
 * <p>
 * 消息实体类proc
 * </p>
 *
 * @author Shadow
 * @since 2021-08-24 09:05:46
 */
@Component
@RequiredArgsConstructor
public class BipMessageRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QBipMessageDO qBipMessageDO = QBipMessageDO.bipMessageDO;

    /**
     * 查询字段
     */
    public JPAQuery<BipMessageVO> select(BipMessageQueryParamVO param) {
        QBipMessageDO jpaQDo = QBipMessageDO.bipMessageDO;
        JPAQuery<BipMessageVO> jpaQuery = jpaQueryFactory.select(Projections.bean(BipMessageVO.class,
                jpaQDo.id,
                jpaQDo.ouId,
                jpaQDo.ouCode,
                jpaQDo.ouName,
                jpaQDo.title,
                jpaQDo.context,
                jpaQDo.status,
                jpaQDo.toCustId,
                jpaQDo.createTime
        )).from(jpaQDo);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        return jpaQuery;
    }

    /**
     * 条件查询
     *
     * @param param 查询条件
     */
    public Predicate where(BipMessageQueryParamVO param) {
        val jpaQDo = QBipMessageDO.bipMessageDO;
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);;
        if (!StringUtils.isEmpty(param.getId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(param.getId()));
        }
        if (!StringUtils.isEmpty(param.getOuId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouId.eq(param.getOuId()));
        }
        if (!StringUtils.isEmpty(param.getOuCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouCode.eq(param.getOuCode()));
        }
        if (!StringUtils.isEmpty(param.getOuName())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouName.eq(param.getOuName()));
        }
        if (!StringUtils.isEmpty(param.getTitle())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.title.eq(param.getTitle()));
        }
        if (!StringUtils.isEmpty(param.getContext())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.context.eq(param.getContext()));
        }
        if (!StringUtils.isEmpty(param.getStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.status.eq(param.getStatus()));
        }
        if (!StringUtils.isEmpty(param.getToCustId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.toCustId.eq(param.getToCustId()));
        }

        return predicate;
    }

    public boolean checkExist(Long bid, String type, Long UserID){
         return jpaQueryFactory.select(qBipMessageDO).from(qBipMessageDO)
                .where(qBipMessageDO.businessId.eq(bid)
                        .and(qBipMessageDO.businessType.eq(type))
                        .and(qBipMessageDO.toCustId.eq(UserID)))
                 .limit(1)
                .fetchCount() > 0;
    }

    public BipFirstMessage firstMessage(Long userId){
        BipMessageVO vo = jpaQueryFactory.select(Projections.bean(BipMessageVO.class,
                qBipMessageDO.id,
                qBipMessageDO.ouId,
                qBipMessageDO.ouCode,
                qBipMessageDO.ouName,
                qBipMessageDO.title,
                qBipMessageDO.context,
                qBipMessageDO.status,
                qBipMessageDO.toCustId,
                qBipMessageDO.createTime
        )).from(qBipMessageDO)
                .where(qBipMessageDO.toCustId.eq(userId))
                .orderBy(qBipMessageDO.createTime.desc())
                .limit(1)
                .fetchOne();
        long count = jpaQueryFactory.select(qBipMessageDO.count()).from(qBipMessageDO)
                .where(qBipMessageDO.toCustId.eq(userId).and(qBipMessageDO.status.eq(UdcEnum.MESSAGE_STATUS_NOTREAD.getValueCode())))
                .fetchCount();
        BipFirstMessage bipFirstMessage = new BipFirstMessage();
        bipFirstMessage.setUnReadTotal(count);
        bipFirstMessage.setMessage(vo);
        return bipFirstMessage;
    }
}

