package com.elitesland.yst.production.sale.repo.shop;

import com.elitesland.yst.production.sale.api.vo.save.shop.BipOrderSaveVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.entity.BipOrderDO;
import com.elitesland.yst.production.sale.entity.QBipOrderDO;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/17/9:24
 * @Description:
 */
@Repository
@RequiredArgsConstructor
public class BipOrderRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    /**
     * 订单签收
     * @param orderId
     * @param status
     * @return
     */
    @Transactional
    public boolean updateSignStatus(Long orderId,String status){
        QBipOrderDO qBipOrderDO=QBipOrderDO.bipOrderDO;
        Predicate predicate = qBipOrderDO.isNotNull();
        return jpaQueryFactory.update(qBipOrderDO)
                .set(qBipOrderDO.status,status)
                .set(qBipOrderDO.signTime, LocalDateTime.now())
                .where(qBipOrderDO.id.eq(orderId))
                .execute()==1;
    }


    @Transactional
    public boolean updateOrderAllowStatus(Long orderId,String status){
        QBipOrderDO qBipOrderDO=QBipOrderDO.bipOrderDO;
        Predicate predicate = qBipOrderDO.isNotNull();
        return jpaQueryFactory.update(qBipOrderDO)
                .set(qBipOrderDO.status,status)
                .where(qBipOrderDO.id.eq(orderId))
                .execute()==1;
    }


    /**
     * 更新订单状态
     * @param bipOrderSaveVO
     * @return
     */
    @Transactional
    public boolean updatStatus(BipOrderSaveVO bipOrderSaveVO){
        QBipOrderDO qBipOrderDO=QBipOrderDO.bipOrderDO;
        Predicate predicate = qBipOrderDO.isNotNull();
        return jpaQueryFactory.update(qBipOrderDO)
                .set(qBipOrderDO.status,bipOrderSaveVO.getStatus())
                .where(qBipOrderDO.id.eq(bipOrderSaveVO.getId()))
                .execute()==1;
    }


    /**
     * 更新订单状态通过id和status
     * @param id
     * @param status
     * @return
     */
    @Transactional
    public boolean updatStatusByIdAndStatus(Long id,String status){
        QBipOrderDO qBipOrderDO=QBipOrderDO.bipOrderDO;
        Predicate predicate = qBipOrderDO.isNotNull();
        return jpaQueryFactory.update(qBipOrderDO)
                .set(qBipOrderDO.status,status)
                .where(qBipOrderDO.id.eq(id))
                .execute()==1;
    }

    /**
     *
     * @param payStatus
     * @param docNo
     * @param status
     * @return
     */
    @Transactional
    public boolean updateOrderPayStatus(String payStatus, String docNo, String status, String txsn, LocalDateTime payTime, BigDecimal payAmt){
        QBipOrderDO qBipOrderDO=QBipOrderDO.bipOrderDO;
        Predicate predicate = qBipOrderDO.isNotNull();
        return jpaQueryFactory.update(qBipOrderDO)
                .set(qBipOrderDO.status,status)
                .set(qBipOrderDO.payStatus,payStatus)
                .set(qBipOrderDO.txsn,txsn)
                .set(qBipOrderDO.payTime,payTime)
                .set(qBipOrderDO.payDoneAmt,payAmt)
                .where(qBipOrderDO.docNo.eq(docNo))
                .execute()==1;
    }


    /**
     * 根据订单号查询订单
     * @param docNo
     * @return
     */
    public BipOrderDO findOrderByDocNo(String docNo){
        QBipOrderDO qBipOrderDO=QBipOrderDO.bipOrderDO;
       return jpaQueryFactory.select(qBipOrderDO).from(qBipOrderDO).where(qBipOrderDO.docNo.eq(docNo)).fetchOne();

    }

    /**
     * 根据自动签收天数获取可以自动签收订单的信息
     *
     */
    public List<BipOrderDO> findOrderByAuSignDays(Long days){
        QBipOrderDO qBipOrderDO = QBipOrderDO.bipOrderDO;
        return jpaQueryFactory.select(qBipOrderDO)
                .from(qBipOrderDO)
                .where( qBipOrderDO.status.eq(ConstantsSale.SHIPPING)
                        .and(qBipOrderDO.payTime.isNotNull().and(qBipOrderDO.payTime.before(LocalDateTime.now().minusDays(days))))
                        .and(qBipOrderDO.deleteFlag.ne(ConstantsSale.COMMON_DELETE_YSE)))
                .fetch();
    }

    @Transactional
    public boolean updateOrderIsSend(List<String> orderCodes){
        QBipOrderDO qBipOrderDO=QBipOrderDO.bipOrderDO;
        Predicate predicate = qBipOrderDO.isNotNull();
        return jpaQueryFactory.update(qBipOrderDO)
                .set(qBipOrderDO.isSend,true)
                .where(qBipOrderDO.docNo.in(orderCodes))
                .execute()==1;
    }

}
