package com.elitesland.yst.production.sale.rmi.ystaftersale;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.aftersale.dto.AfterSaleVehicleDTO;
import com.elitesland.yst.production.aftersale.dto.AfterSaleVehicleRespDTO;
import com.elitesland.yst.production.aftersale.service.AfterSaleRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author wz
 * @date 2023-05-24 11:08:54
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class RmiAfterSaleRpcService {

    private final AfterSaleRpcService afterSaleRpcService;


    public List<AfterSaleVehicleRespDTO> getPriceListByParam(AfterSaleVehicleDTO afterSaleVehicleDTO) {
        try {
            log.info("查询绑车激活信息："+ JSON.toJSONString(afterSaleVehicleDTO));
            ApiResult<List<AfterSaleVehicleRespDTO>> listApiResult = afterSaleRpcService.queryVehicle(afterSaleVehicleDTO);

            return CollUtil.isNotEmpty(listApiResult.getData()) ? listApiResult.getData() : new ArrayList<>();
        } catch (Exception e) {
            log.error("远程调用售后域相关服务异常:{}", e.getMessage());
            throw new BusinessException("远程调用售后域查询相关服务异常",e);
        }
    }

}
