package com.elitesland.yst.production.sale.rmi.ystsystem;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.cloudt.system.provider.SysSeqNumRpcService;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 发号器服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2021-05-13
 */
@Slf4j
@Component
public class RmiSysNextNumberService {

//    @DubboReference(version = "${provider.service.version}", check = false, timeout = 10000)
//    @DubboReference(check = false, timeout = 10000)
//    private SysUserService sysUserService;

//    @DubboReference(version = "${provider.service.version}", check = false, timeout = 10000)

    @Autowired
    private SeqNumProvider seqNumProvider;

    @Autowired
    private SysSeqNumRpcService sysSeqNumRpcService;


    public String generateCode(String appName,String ruleCode, List<String> runtimeValues){
        try {
//            ApiResult<String> res = sysSeqNumRpcService.generateCode(appName,ruleCode, runtimeValues);
//            if(res.isSuccess()){
//                return res.getData();
//            }
//            throw new BusinessException("远程调用系统域发号器接口失败---" + JSON.toJSONString(res));
            return seqNumProvider.generateCode(appName,ruleCode,runtimeValues);
        } catch (Exception e) {
            log.error("远程调用系统域发号器相关服务异常:", e);
            throw new BusinessException("远程调用系统域发号器接口失败", e);
        }
    }



}
