package com.elitesland.yst.production.sale.service;


import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.IterUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysEmployeeDetailDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeeUnderlingDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysAreaRpcService;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitesland.yst.production.sale.Application;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.sale.api.service.CrmCustOuService;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.service.SalesmanInfoService;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustOuParamVO;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustQueryLmParam;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustCode2BaseParam;
import com.elitesland.yst.production.sale.api.vo.resp.crm.*;
import com.elitesland.yst.production.sale.api.vo.save.CrmCustOuSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.CrmCustSaveVO;
import com.elitesland.yst.production.sale.convert.CrmCustConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.dto.*;
import com.elitesland.yst.production.sale.dto.param.CrmCust2BaseParam;
import com.elitesland.yst.production.sale.dto.param.CrmCustRpcDtoParam;
import com.elitesland.yst.production.sale.dto.query.SalesmanQueryDTO;
import com.elitesland.yst.production.sale.dto.save.CrmCustRpcSaveDto;
import com.elitesland.yst.production.sale.entity.CrmCustDO;
import com.elitesland.yst.production.sale.entity.QCrmCustDO;
import com.elitesland.yst.production.sale.entity.SalesmanInfoDO;
import com.elitesland.yst.production.sale.repo.*;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgEmpService;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.support.provider.org.dto.OrgEmpRpcDTO;
import com.google.common.collect.Lists;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import jodd.util.StringUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 客户信息服务接口实现.
 *
 * @author Kaiser（wang shao）
 * @date 2021-05-14
 */
@Service
@Slf4j
@RequiredArgsConstructor
@RestController
@RequestMapping(CrmCustRpcService.URI)
public class CrmCustRpcServiceImpl extends BaseServiceImpl implements CrmCustRpcService {

    @Autowired
    private CrmCustRepo crmCustRepo;
    @Autowired
    private CrmCustRepoProc crmCustRepoProc;

    @Autowired
    private CustAccountRepoProc custAccountRepoProc;

    @Autowired
    private CrmCustService crmCustService;

    @Autowired
    private CrmCustOuService crmCustOuService;

    @Autowired
    private RmiOrgEmpService rmiOrgEmpService;

    @Autowired
    private SalesmanInfoService salesmanInfoService;

    @Autowired
    private EmployeeRpcService employeeRpcService;

    @Autowired
    private SalesmanInfoRepo salesmanInfoRepo;

    @Autowired
    private SalesmanInfoRepoProc salesmanInfoRepoProc;

//    @Autowired
//    private RmiSysUserService rmiSysUserService;

    @Autowired
    private SysAreaRpcService sysAreaRpcService;

    @Autowired
    private UdcProvider udcProvider;


    private final QCrmCustDO qCrmCustDO = QCrmCustDO.crmCustDO;

    @Override
    public ApiResult<LmSaveCustRespVO> saveCustLm(LmCrmCustSaveVO save) {
        CrmCustConvert crmCustConvert = CrmCustConvert.INSTANCE;
        CrmCustSaveVO custSaveVO = crmCustConvert.saveLmToVo(save);
        ApiResult<CrmCustDetailRespVO> crmCustDetailResp = crmCustService.saveLm(custSaveVO);
        if(crmCustDetailResp.isSuccess() && !Objects.isNull(crmCustDetailResp)){
            CrmCustDetailRespVO crmCustDetailRespVO = crmCustDetailResp.getData();
            LmSaveCustRespVO res = new LmSaveCustRespVO();
            res.setId(crmCustDetailRespVO.getId());
            res.setCustCode(crmCustDetailRespVO.getCustCode());
            res.setCustName(crmCustDetailRespVO.getCustName());
            return ApiResult.ok(res);
        }
        return ApiResult.fail(crmCustDetailResp.getMsg());
    }

    @Override
    public ApiResult<List<CustCode2BaseDTO>> getByCust2Base(CustCode2BaseParam param) {
        List<CustCode2BaseDTO> res = crmCustRepoProc.getByCust2Base(param);
        if(CollectionUtil.isNotEmpty(res)){
            Map<String, String> regionMap = udcProvider.getValueMapByUdcCode("yst-supp", "REGION");
            Map<String,SysAreaRespDTO> areaMap = new HashMap<>();
            List<String> areaCodes = res.stream().map(CustCode2BaseDTO :: getProvinceCode).collect(Collectors.toList());
            if(CollectionUtil.isNotEmpty(areaCodes)){
                Set<String> set = new HashSet<>(areaCodes);
                areaMap = this.getArea(set);
            }
            Map<String, SysAreaRespDTO> finalAreaMap = areaMap;
            res.forEach(r ->{
                if(!MapUtils.isEmpty(finalAreaMap) && StringUtil.isNotBlank(r.getProvinceCode()) && null != finalAreaMap.get(r.getProvinceCode())){
                    r.setProvinceName(finalAreaMap.get(r.getProvinceCode()).getAreaName());
                }
                if(!MapUtils.isEmpty(regionMap) && StringUtil.isNotBlank(r.getRegion()) && null != regionMap.get(r.getRegion())){
                    r.setRegionName(regionMap.get(r.getRegion()));
                }
            });
        }
        return ApiResult.ok(res);
    }

    public Map<String,SysAreaRespDTO> getArea(Set<String> areaCodes){
        Map<String,SysAreaRespDTO> map = new HashMap<>();
        ApiResult<List<SysAreaRespDTO>> listByAreaCodes = sysAreaRpcService.listByAreaCodes(areaCodes);
        if(listByAreaCodes.isSuccess() && CollectionUtil.isNotEmpty(listByAreaCodes.getData())){
            map = listByAreaCodes.getData().stream().collect(Collectors.toMap(SysAreaRespDTO :: getAreaCode,t ->t ,(t1,t2) -> t1));
        }
        return map;
    }


    @Override
    public PagingVO<CrmCustPageLmVO> pageLm(CrmCustQueryLmParam searchParam) {
        if (searchParam == null) {
            return new PagingVO<>();
        }
        PagingVO<CrmCustPageLmVO> pagingVO = crmCustRepoProc.findPageCust(searchParam);
        if(!pagingVO.isEmpty() && !pagingVO.getRecords().isEmpty()){
            pagingVO.getRecords().forEach(p ->{
                if (!StringUtils.isEmpty(p.getPid())) {
                    String pidName = crmCustRepoProc.getCustNameByPidCode(p.getPid());
                    p.setPidName(pidName);
                }
                if(!Objects.isNull(p.getAgentEmpId())){
                    ApiResult<SalesmanInfoDTO> res = this.getSaleManInfo(p.getAgentEmpId());
                    if(res.isSuccess() && !ObjectUtils.isEmpty(res) && !ObjectUtils.isEmpty(res.getData())){
                        p.setAgentEmpName(res.getData().getFullName());
                    }
                }
            });
        }
        return pagingVO;
    }

    public ApiResult<SalesmanInfoDTO> getSaleManInfo(Long agentEmpId){
        SalesmanQueryDTO salesmanQueryDTO = new SalesmanQueryDTO();
        salesmanQueryDTO.setSalesmanId(agentEmpId);
        return salesmanInfoService.querySalesmanInfo(salesmanQueryDTO);
    }

    @Override
    public List<CrmCustPageLmVO> searchExport(CrmCustQueryParam param) {
        List<CrmCustPageLmVO> list = crmCustRepoProc.searchExoprt(param);
        return list;
    }

    @Override
    public ApiResult<List<LmSaveCustRespVO>> findInvCust(List<String> custCode) {
        List<LmSaveCustRespVO> list = crmCustRepoProc.findInvCustCodes(custCode);
        return ApiResult.ok(list);
    }

    @Override
    public List<LmSaveCustRespVO> findBaseCustInfo(CustCode2BaseParam param) {
        List<LmSaveCustRespVO> list = crmCustRepoProc.findBaseCustInfo(param);
        return list;
    }


    @Override
    public ApiResult<String> getCustName(Long id) {
        if (id == null) {
            return ApiResult.fail("客户ID为空");
        }

        String custName = crmCustRepoProc.getCustName(id);
        return ApiResult.ok(custName);
    }

    @Override
    public ApiResult<List<CrmCustDTO>> listCustById(List<Long> ids) {
        if (CollUtil.isEmpty(ids)) {
            return ApiResult.fail("客户ID为空");
        }

        List<CrmCustDO> custDOList = crmCustRepo.findAllById(ids);
        if (custDOList.isEmpty()) {
            // 未查询到客户信息
            return ApiResult.ok(Collections.emptyList());
        }

        // 转为dto后返回
        CrmCustConvert convert = CrmCustConvert.INSTANCE;
        Map<String, String> regionNameMap = convertUdc(null);
        Map<String, String> custTypeNameMap = convertUdc(null);
        List<CrmCustDTO> custDTOList = custDOList.stream()
                .map(t -> {
                    CrmCustDTO custDTO = convert.do2Dto(t);
                    custDTO.setRegionName(regionNameMap.get(t.getRegion()));
                    custDTO.setCustTypeName(custTypeNameMap.get(t.getCustType()));

                    return custDTO;
                }).collect(Collectors.toList());

        return ApiResult.ok(custDTOList);
    }

    @Override
    public ApiResult<List<CrmCustSimpleDTO>> query(String keyword) {
        if (StrUtil.isBlank(keyword)) {
            return ApiResult.fail("搜索关键字为空");
        }

        List<CrmCustSimpleDTO> simpleDTOList = crmCustRepoProc.query(keyword);

        return ApiResult.ok(simpleDTOList);
    }

    @Override
    public ApiResult<List<CrmCustRespDTO>> queryAllByAgentEmpId(Long agentEmpId) {
        if (agentEmpId == null) {
            return ApiResult.fail("查询的业务员id为空");
        }
        List<CrmCustRespDTO> crmCustRespDTOS = crmCustRepoProc.queryAllByAgentEmpId(agentEmpId);
        return ApiResult.ok(crmCustRespDTOS);
    }

    @Override
    public ApiResult<List<CrmCustBaseRespVO>> queryAllByAgentEmpIdAndSub(Long agentEmpId) {
        Optional<SalesmanInfoDO> salesmanInfoOptional = salesmanInfoRepo.findById(agentEmpId);
        if(salesmanInfoOptional.isEmpty()){
            return ApiResult.ok();

        }
        SalesmanInfoDO salesmanInfo = salesmanInfoOptional.get();
        ApiResult<List<EmployeeUnderlingDTO>> apiResult = employeeRpcService.getUnderlingByCode(salesmanInfo.getSalesmanNo(),Boolean.TRUE,Boolean.TRUE);
        List<EmployeeUnderlingDTO> resultData = apiResult.getData();
        Set<String> codeList = new HashSet<>();
        codeList.add(salesmanInfo.getSalesmanNo());
        if (!CollUtil.isEmpty(resultData)) {
            List<EmployeeUnderlingDTO> listEmp = new ArrayList<>();
            List<EmployeeUnderlingDTO> res = this.treeToList(resultData,listEmp);
            codeList.addAll(res.stream().map(EmployeeUnderlingDTO::getCode).collect(Collectors.toList()));
        }
        List<SalesmanInfoDO> salesmanInfos = salesmanInfoRepoProc.getSalesmanByCodes(codeList);
        if(CollectionUtils.isEmpty(salesmanInfos)){
           return ApiResult.ok();
        }
        List<Long> agentEmpIds = salesmanInfos.stream().map(SalesmanInfoDO:: getId).collect(Collectors.toList());
        Map<Long,SalesmanInfoDO> empMap = salesmanInfos.stream().collect(Collectors.toMap(SalesmanInfoDO :: getId,t->t,(t1,t2) -> t1));
        List<CrmCustBaseRespVO> list = crmCustRepoProc.getCustByEmpIds(agentEmpIds);
        list.forEach(l ->{
            if(!MapUtils.isEmpty(empMap) && !ObjectUtils.isEmpty(l.getAgentEmpId()) && !ObjectUtils.isEmpty(empMap.get(l.getAgentEmpId()))){
                l.setAgentEmpName(empMap.get(l.getAgentEmpId()).getName());
                l.setAgentEmpCode(empMap.get(l.getAgentEmpId()).getSalesmanNo());
            }
        });
        return ApiResult.ok(list);
    }

    public List<EmployeeUnderlingDTO> treeToList(List<EmployeeUnderlingDTO> source ,List<EmployeeUnderlingDTO> obj){
//        List<EmployeeUnderlingDTO> res = new ArrayList<>();
        source.stream().forEach(v ->{
            EmployeeUnderlingDTO t = new EmployeeUnderlingDTO();
            BeanUtils.copyProperties(v,t);
            t.setUnderlingList(new ArrayList<>());
            obj.add(t);
            if(CollectionUtil.isNotEmpty(v.getUnderlingList())){
                treeToList(v.getUnderlingList(),obj);
            }
        });
        return obj;
    }

    @Override
    public List<CrmCustSimpleDTO> getCustByUserName(String userName) {
        if(Objects.isNull(userName)){
            GeneralUserDetails userDetails =SecurityContextUtil.currentUser();
            if(Objects.isNull(userDetails) || Objects.isNull(userDetails.getUser())){
                throw new BusinessException("获取当前用户信息失败");
            }
            SysUserDTO currentUser = userDetails.getUser();
            userName = currentUser.getUsername();
        }
        CustAccountVO custAccountVO = custAccountRepoProc.getAccountByUserName(userName);
        if(custAccountVO != null){
            List<CrmCustSimpleDTO> custSimpleDTOS = crmCustRepoProc.getCustByCode(custAccountVO.getCustCode());
            custSimpleDTOS.stream().forEach(i ->{
                i.setBalance(custAccountVO.getBalance());
            });
            return custSimpleDTOS;
        } else {
            return new ArrayList<>();
        }
    }

    @Override
    public ApiResult<CrmCustDTO> getCustInfo(String custCode) {
        if (StringUtil.isBlank(custCode)) {
            return ApiResult.fail("客户编号为空");
        }
        CrmCustDO cust = this.getByCustCode(custCode);
        if(Objects.isNull(cust)){
           throw new BusinessException("客户信息为空");
        }
        // 转为dto后返回
        CrmCustConvert convert = CrmCustConvert.INSTANCE;
        Map<String, String> regionNameMap = convertUdc(null);
        Map<String, String> custTypeNameMap = convertUdc(null);
        CrmCustDTO custDTO = convert.do2Dto(cust);
        custDTO.setRegionName(regionNameMap.get(cust.getRegion()));
        custDTO.setCustTypeName(custTypeNameMap.get(cust.getCustType()));
        return ApiResult.ok(custDTO);
    }


    public CrmCustDO getByCustCode(String custCode){
        BooleanExpression e = qCrmCustDO.deleteFlag.eq(0).and(qCrmCustDO.custCode.eq(custCode));
        Iterable<CrmCustDO> iterables = crmCustRepo.findAll(e);
        if(!IterUtil.isEmpty(iterables)){
            return Lists.newArrayList(iterables).get(0);
        }
        return new CrmCustDO();
    }

    @Override
    public ApiResult<BigDecimal> getCreditLimitById(Long id) {
        if (id == null) {
            return ApiResult.fail("查询的客户id为空");
        }
        BigDecimal creditLimit = crmCustRepoProc.getCreditLimitById(id);
        return ApiResult.ok(creditLimit);
    }

    @Override
    public ApiResult<String> getStatusById(Long id) {
        if (id == null) {
            return ApiResult.fail("查询的客户id为空");
        }
        String custStatus = crmCustRepoProc.getStatusById(id);
        return ApiResult.ok(custStatus);
    }

    @Override
    public ApiResult<List<CrmCustBaseDTO>> getBaseCustByParam(List<String> custCodes) {
        if(!CollectionUtils.isEmpty(custCodes)){
            JPAQuery<CrmCustBaseDTO> jpaQuery = this.selectCustBase(custCodes);
            return ApiResult.ok(jpaQuery.fetch());
        }
        return ApiResult.ok();
    }

    @Override
    public ApiResult<List<CrmCustRespDTO>> getCustByParam(CrmCustRpcDtoParam crmCustRpcDtoParam) {
        if (crmCustRpcDtoParam == null) {
            return ApiResult.fail("查询的客户条件为空");
        }
        JPAQuery<CrmCustRespDTO> crmCustRespDTOJPAQuery = this.select(crmCustRpcDtoParam);
        List<CrmCustRespDTO> crmCustRespDTOS = crmCustRespDTOJPAQuery.fetch();
        if (!CollectionUtils.isEmpty(crmCustRpcDtoParam.getAgentEmps())) {
            List<Long> agentEmpIds = crmCustRespDTOS.stream().map(CrmCustRespDTO::getAgentEmpId).filter(Objects::nonNull).distinct()
                    .collect(Collectors.toList());
            List<SalesmanInfoDTO> salesmanInfos = new ArrayList<>();
            if(CollectionUtils.isEmpty(agentEmpIds)){
                agentEmpIds.forEach(a ->{
                    ApiResult<SalesmanInfoDTO> res = this.getSaleManInfo(a);
                    if(res.isSuccess() && !ObjectUtils.isEmpty(res) && !ObjectUtils.isEmpty(res.getData())){
                        salesmanInfos.add(res.getData());
                    }
                });
            }
            crmCustRespDTOS.forEach(crm -> {
                salesmanInfos.stream().filter(emp -> emp.getId().equals(crm.getAgentEmpId()))
                        .findFirst().ifPresent(empD -> crm.setAgentEmpCode(empD.getSalesmanNo()));
            });
        }
        return ApiResult.ok(crmCustRespDTOS);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Long> save(CrmCustRpcSaveDto saveDto) {
        CrmCustConvert crmCustConvert = CrmCustConvert.INSTANCE;
        CrmCustSaveVO custSaveVO = crmCustConvert.saveRpcToVO(saveDto);
        CrmCustDetailRespVO crmCustDetailRespVO = crmCustService.save(custSaveVO).getData();
        return ApiResult.ok(crmCustDetailRespVO.getId());
    }

//    @Override
//    public ApiResult<List<String>> getAllErpCode() {
//        List<String> fetch = jpaQueryFactory.selectDistinct(qCrmCustDO.custCode2).from(qCrmCustDO).where(qCrmCustDO.custCode2.isNotNull()).fetch();
//        return ApiResult.ok(fetch);
//    }

    @Override
    public ApiResult<Object> judgeDependEmpAndCust(List<CrmCustJudgeDTO> crmCustJudgeDTOS) {
        crmCustJudgeDTOS.forEach(crm -> {
            // 获取该员工所属的所有客户的编码
            CrmCustRpcDtoParam searchParam = new CrmCustRpcDtoParam();
            CrmAgentReqDTO crmAgentReqDTO = new CrmAgentReqDTO();
            crmAgentReqDTO.setAgentEmpId(crm.getAgentEmpId());
            searchParam.setAgentEmps(List.of(crmAgentReqDTO));
            JPAQuery<CrmCustRespDTO> respDTOJPAQuery = this.select(searchParam);
            List<CrmCustRespDTO> custRespDTOS = respDTOJPAQuery.fetch();
            List<String> custCodes = custRespDTOS.stream().map(CrmCustRespDTO::getCustCode).filter(Objects::nonNull).distinct()
                    .collect(Collectors.toList());
            // 判断客户是都属于该员工
            if (! custCodes.contains(crm.getCustCode())){
                throw new BusinessException("客户编码为:【"+crm.getCustCode()+"】的客户不属于,员工编号为:【"+crm.getAgentEmpCode()+"】的员工");
            }
        });
        return ApiResult.ok();
    }

    @Override
    public ApiResult<List<CustBaseInfoDTO>> getCustBaseInfoByCode(CustCode2BaseParam param) {
        if(ObjectUtils.isEmpty(param) && (CollectionUtils.isEmpty(param.getCustCode()) && CollectionUtils.isEmpty(param.getCustCode2()))){
            return ApiResult.ok();
        }
        List<CustBaseInfoDTO> list = crmCustRepoProc.getCustBaseInfo(param);
        return ApiResult.ok(list);
    }

    @Override
    public ApiResult<List<SalesmanLevelInfoDTO>> queryLevelInfos(List<Long> ids) {
        List<SalesmanLevelInfoDTO> list = new ArrayList<>();
        ids.forEach(id ->{
            SalesmanLevelInfoDTO api = salesmanInfoService.queryLevelInfo(id);
            list.add(api);
        });
        return ApiResult.ok(list);
    }

    @Override
    public CrmCustSimpleVO getCustSimple(String userName) {
        return crmCustService.getCustSimple(userName);
    }


    public JPAQuery<CrmCustRespDTO> select(CrmCustRpcDtoParam searchParam) {

        val jpaQuery = jpaQueryFactory.select(Projections.bean(CrmCustRespDTO.class,
                qCrmCustDO.id,

                qCrmCustDO.taxRateNo,
                qCrmCustDO.taxRate,
                qCrmCustDO.region,
                qCrmCustDO.custAbbr,

                qCrmCustDO.agentEmpId,

                qCrmCustDO.ouId,
                qCrmCustDO.ouCode,
                qCrmCustDO.ouName,
                qCrmCustDO.custCode,
                qCrmCustDO.custName,
                qCrmCustDO.custType,
                qCrmCustDO.custStatus,
                qCrmCustDO.custCode2,
                qCrmCustDO.custCurr
        )).from(qCrmCustDO);
        if (searchParam != null) {
            jpaQuery.where(where(searchParam));
        }
        return jpaQuery;
    }

    public JPAQuery<CrmCustBaseDTO> selectCustBase(List<String> custCodes) {

        val jpaQuery = jpaQueryFactory.select(Projections.bean(CrmCustBaseDTO.class,
                qCrmCustDO.id,
                qCrmCustDO.custCode,
                qCrmCustDO.custName,
                qCrmCustDO.custAbbr
        )).from(qCrmCustDO)
                .where(qCrmCustDO.custCode.in(custCodes));
        return jpaQuery;
    }

    /**
     * 条件查询
     *
     * @param param 查询条件
     */
    public Predicate where(CrmCustRpcDtoParam param) {

        Predicate predicate = qCrmCustDO.isNotNull();

        if (!CollectionUtils.isEmpty(param.getCustIds())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.id.in(param.getCustIds()));
        }
        if (!CollectionUtils.isEmpty(param.getCustCodes())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.custCode.in(param.getCustCodes()));
        }
        if (!CollectionUtils.isEmpty(param.getAgentEmps())) {
            List<Long> agentEmpIds = param.getAgentEmps().stream().map(CrmAgentReqDTO::getAgentEmpId).distinct().filter(Objects::nonNull)
                    .collect(Collectors.toList());
            // 判断一 : 是判断该员工是不是在拓展公司表中
            // 判断二 : 如果该员工是否在拓展公司表中
            //        是: 获取该员工在拓展公司表中所有的客户的客户编码，作为筛选条件,过滤主表中为该员工的客户，和客户编码为前面客户编码的客户
            //        否: 只获取主表中为该员工的客户
            if (!CollectionUtils.isEmpty(agentEmpIds)) {
                CrmCustOuParamVO crmCustOuParamVO = new CrmCustOuParamVO();
                crmCustOuParamVO.setAgentEmpIds(agentEmpIds);
                crmCustOuParamVO.setIfTrans(false);
                List<CrmCustOuSaveVO> custOuSaveVOS = crmCustOuService.search(crmCustOuParamVO);
                if (!CollectionUtils.isEmpty(custOuSaveVOS)) { // 如果能够查到拓展关系数据
                    List<String> custCodes = custOuSaveVOS.stream().map(CrmCustOuSaveVO::getCustCode).distinct().collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(custCodes)) {
                        predicate = ExpressionUtils.and(predicate, qCrmCustDO.custCode.in(custCodes).or(qCrmCustDO.agentEmpId.in(agentEmpIds)));
                    } else {
                        predicate = ExpressionUtils.and(predicate, qCrmCustDO.agentEmpId.in(agentEmpIds));
                    }
                } else {
                    predicate = ExpressionUtils.and(predicate, qCrmCustDO.agentEmpId.in(agentEmpIds));
                }
            }
        }
        return predicate;
    }
}
