package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollUtil;
import com.el.coordinator.core.common.exception.BusinessException;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.service.CustLoginLogService;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustAccountVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustLoginLogRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustLoginLogVO;
import com.elitesland.yst.production.sale.entity.CrmCustDO;
import com.elitesland.yst.production.sale.entity.CustLoginLogDO;
import com.elitesland.yst.production.sale.entity.QCrmCustDO;
import com.elitesland.yst.production.sale.repo.CrmCustRepo;
import com.elitesland.yst.production.sale.repo.CustAccountRepoProc;
import com.elitesland.yst.production.sale.repo.CustLoginLogRepo;
import com.elitesland.yst.production.sale.repo.CustLoginLogRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysUserService;
import com.querydsl.core.types.dsl.BooleanExpression;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Service
@RequiredArgsConstructor
@Slf4j
public class CustLoginLogServiceImpl implements CustLoginLogService {

    private final CustLoginLogRepo custLoginLogRepo;

    private final CustLoginLogRepoProc custLoginLogRepoProc;

    private final CustAccountRepoProc custAccountRepoProc;

    private final RmiSysUserService rmiSysUserService;

    private final CrmCustService crmCustService;

    private final CrmCustRepo crmCustRepo;

    private static final String UN_KNOWN = "unKnown";



    @Override
    public void save(CustLoginLogVO custLoginLogVO) {
        if(!Objects.isNull(custLoginLogVO)){
            CustLoginLogDO custLoginLogDO = new CustLoginLogDO();
            custLoginLogDO.setUserId(custLoginLogVO.getUserId());
            custLoginLogDO.setLoginTime(LocalDateTime.now());

            custLoginLogDO.setUserName(custLoginLogVO.getUserName());
            if(StringUtils.isEmpty(custLoginLogVO.getLoginIp())){
                custLoginLogDO.setLoginIp(getIpAddress());
            }
            custLoginLogRepo.save(custLoginLogDO);
        }
    }

    @Override
    public CustLoginLogRespVO getCustLoginInfo(String userName) {
        List<CustLoginLogVO> list = custLoginLogRepoProc.getByUserName(userName);
        //本次登录信息
        if(CollUtil.isEmpty(list)){
            return null;
        }
        CustLoginLogRespVO res = new CustLoginLogRespVO();
        CustLoginLogVO thisLog = list.get(0);
        res.setThisLoginIp(thisLog.getLoginIp());
        res.setThisLoginTime(thisLog.getLoginTime());
        if(list.size() > 1){
            //上次登录信息
            CustLoginLogVO lastLog = list.get(1);
            res.setLastLoginIp(lastLog.getLoginIp());
            res.setLastLoginTime(lastLog.getLoginTime());
        }
        //查询注册时间
        CustAccountVO custAccountVO = custAccountRepoProc.getAccountByUserName(userName);
        res.setRegistTime(custAccountVO.getCreateAccountTime());
        //修改时间不知道在哪取
        res.setModifyTime(custAccountVO.getUpdatePwdTime());
        //账户信息 获取用户登录账号  查询到客户信息
        res.setBalance(custAccountVO.getBalance());
        CrmCustDO crmCust = this.getBYCustCode(custAccountVO.getCustCode());
        res.setCustType(crmCust.getCustType());
        res.setUserName(userName);
        res.setContactName(crmCust.getContactName());
        res.setMobile(custAccountVO.getMobile());
        return res;
    }

    public CrmCustDO getBYCustCode(String custCode){
        QCrmCustDO qCrmCustDO = QCrmCustDO.crmCustDO;
        BooleanExpression e = qCrmCustDO.deleteFlag.eq(0).and(qCrmCustDO.custCode.eq(custCode));
        Optional<CrmCustDO> optional = crmCustRepo.findOne(e);
        if(optional.isPresent()){
            return optional.get();
        }
        return new CrmCustDO();
    }



    private String getIpAddress() {
        if (ObjectUtils.isEmpty(RequestContextHolder.getRequestAttributes())) {
            return null;
        }
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();

        String xip = request.getHeader("X-Real-IP");
        String xFor = request.getHeader("X-Forwarded-For");
        if(!StringUtils.isEmpty(xFor) && !UN_KNOWN.equalsIgnoreCase(xFor)){
            //多次反向代理后会有多个ip值，第一个ip才是真实ip
            int index = xFor.indexOf(",");
            if(index != -1){
                return xFor.substring(0,index);
            }else{
                return xFor;
            }
        }
        xFor = xip;
        if(!StringUtils.isEmpty(xFor) && !UN_KNOWN.equalsIgnoreCase(xFor)){
            return xFor;
        }
        if (StringUtils.isEmpty(xFor) || UN_KNOWN.equalsIgnoreCase(xFor)) {
            xFor = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isEmpty(xFor) || UN_KNOWN.equalsIgnoreCase(xFor)) {
            xFor = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isEmpty(xFor) || UN_KNOWN.equalsIgnoreCase(xFor)) {
            xFor = request.getHeader("HTTP_CLIENT_IP");
        }
        if (StringUtils.isEmpty(xFor) || UN_KNOWN.equalsIgnoreCase(xFor)) {
            xFor = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (StringUtils.isEmpty(xFor) || UN_KNOWN.equalsIgnoreCase(xFor)) {
            xFor = request.getRemoteAddr();
        }
        return xFor;
    }


}
