package com.elitesland.yst.production.sale.service;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.FileInfoQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.FileInfoRespVO;
import com.elitesland.yst.production.sale.api.vo.save.FileInfoSaveVO;
import com.elitesland.yst.production.sale.entity.FileInfoDO;
import com.elitesland.yst.production.sale.repo.FileInfoRepo;
import com.elitesland.yst.production.sale.repo.FileInfoRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.sale.service
 * @date 2023/4/12 14:16
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class FileInfoServiceImpl implements FileInfoService {

    private final FileInfoRepoProc fileInfoRepoProc;
    private final FileInfoRepo fileInfoRepo;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public FileInfoDO save(FileInfoSaveVO fileInfoParam) {
        checkData(fileInfoParam);
        FileInfoDO fileInfoDO = new FileInfoDO();
        FileInfoDO res = fileInfoRepo.save(fileInfoDO);
        return res;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public FileInfoDO update(FileInfoSaveVO fileInfoParam) {
        Assert.notNull(fileInfoParam.getId(), "id is null");
        FileInfoDO res = save(fileInfoParam);
        return res;
    }

    @Override
    public FileInfoRespVO get(Long id) {
        FileInfoRespVO res = fileInfoRepoProc.get(id);
        return res;
    }

    @Override
    public PagingVO<FileInfoRespVO> page(FileInfoQueryVO fileInfoPageParam) {
        PagingVO<FileInfoRespVO> res = fileInfoRepoProc.page(fileInfoPageParam);
        return res;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {
        Long res = fileInfoRepoProc.del(ids);
        return res;
    }

    /**
     * 数据校验
     *
     * @param fileInfoParam
     */
    private void checkData(FileInfoSaveVO fileInfoParam) {

    }

}
