package com.elitesland.yst.production.sale.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.dto.PriBasePriceDTO;
import com.elitesland.yst.production.sale.dto.PriCrossPriceDTO;
import com.elitesland.yst.production.sale.dto.PriSalePriceDTO;
import com.elitesland.yst.production.sale.dto.query.PriBasePriceReqDTO;
import com.elitesland.yst.production.sale.dto.query.PriCrossPriceReqDTO;
import com.elitesland.yst.production.sale.dto.query.PriSalePriceReqDTO;
import com.elitesland.yst.production.sale.entity.PriSalePriceDO;
import com.elitesland.yst.production.sale.entity.QPriSalePriceDO;
import com.elitesland.yst.production.sale.repo.CrmCustRepoProc;
import com.elitesland.yst.production.sale.rmi.ystpur.RmiPurPriceService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiPriMainPriceService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiCommonService;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemUomConvRpcDTO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/5/28 1:33 下午
 */
@Service
@Slf4j
//@Service
@RequiredArgsConstructor
@RestController
@RequestMapping(PriSalePriceRpcService.URI)
public class PriSalePriceRpcServiceImpl extends BaseServiceImpl implements PriSalePriceRpcService {

    private final QPriSalePriceDO qPriSalePriceDO = QPriSalePriceDO.priSalePriceDO;
//    private final RmiItemService rmiItemService;
    private final RmiPriMainPriceService rmiPriMainPriceService;
    private final CrmCustService crmCustService;
    private final RmiPurPriceService rmiPurPriceService;
    private final RmiCommonService rmiCommonService;
    private final CrmCustRepoProc crmCustRepoProc;

    @Override
    public ApiResult<PriSalePriceDTO> findSalePriceDto(PriSalePriceReqDTO param) {
        //反查custId通过custCode
//        if (ObjectUtils.isEmpty(param.getCustId()) && ObjectUtils.isEmpty(param.getCustCode())){
//            return ApiResult.fail("客户Id不能为空");
//        }
//        if(ObjectUtils.isEmpty(param.getCustId()) && !ObjectUtils.isEmpty(param.getCustCode())){
//            List<CrmCustSimpleDTO> custSimpleDTOS = crmCustRepoProc.query(param.getCustCode());
//            if (!CollectionUtils.isEmpty(custSimpleDTOS)){
//                param.setCustId(custSimpleDTOS.get(0).getId());
//            }else{
//                return ApiResult.fail("客户编码为:"+param.getCustCode()+"的数据不存在");
//            }
//        }
//
//        param.setCurrCode(StrUtil.isBlank(param.getCurrCode()) ? "CNY" : param.getCurrCode());
//        List<PriSaleItemReqDTO> items = param.getItems().stream().distinct().collect(Collectors.toList());
//        List<Long> itemIds = items.stream().map(PriSaleItemReqDTO::getItemId).distinct().collect(Collectors.toList());
//
//        // 查询【销售公司 + 商品 + 币种】除【内部结算价】的所有类型价格，直接先筛选出三种价格
//        List<PriSalePriceDO> salePriceList = doQueryPrice(false, param.getOuId(), param.getCurrCode(), itemIds);
//        List<PriSalePriceDO> basePriceList = salePriceList.stream().filter(p -> TYPE_BASE.equals(p.getPriceType())).collect(Collectors.toList());
//        List<PriSalePriceDO> custPriceList = salePriceList.stream().filter(p -> TYPE_CUST.equals(p.getPriceType())).collect(Collectors.toList());
//        List<PriSalePriceDO> groupPriceList = salePriceList.stream().filter(p -> TYPE_GROUP.equals(p.getPriceType())).collect(Collectors.toList());
//
//        // 获取客户等级、商品主数据、商品价格、计量单位转换关系相关辅助信息
//        CrmCustDetailRespVO crmCust = crmCustService.get(param.getCustId());
//        if (Objects.isNull(crmCust)) {
//            return ApiResult.fail("客户[" + param.getCustId() + "]不存在");
//        }
//        String custLevel = StrUtil.isBlank(crmCust.getCustLevel()) ? "NO_LEVEL" : crmCust.getCustLevel();
//        List<ItmItemRpcDTO> itemRpcList = rmiItemService.findItemList(itemIds, null);
//     //   List<PriMainPriceRpcDTO> priceRpcResult = rmiPriMainPriceService.findMainPriceDtoList(itemIds, null);
//        List<ItmItemUomConvRpcDTO> itemUomConvRpcResult = rmiItemService.findItemUomConvDtoList(itemIds);
//        // 获取主档税率编号
//        ComTaxRateRpcDtoParam comTaxRateRpcDtoParam = new ComTaxRateRpcDtoParam();
//        List<BigDecimal> taxRate2s = itemRpcList.stream().map(ItmItemRpcDTO::getTaxRate2).distinct().filter(Objects::nonNull).collect(Collectors.toList());
//        List<Double> taxRates = taxRate2s.stream().map(BigDecimal::doubleValue).collect(Collectors.toList());
//        comTaxRateRpcDtoParam.setTaxRates(taxRates);
//        List<ComTaxRateRpcDTO> taxRateRpcDtoByParam = rmiCommonService.findTaxRateRpcDtoByParam(comTaxRateRpcDtoParam);
//        // 获取采购价
//        PurPriceBatchParamDTO purPriceParam = new PurPriceBatchParamDTO();
//        purPriceParam.setOuId(param.getOuId());
//        purPriceParam.setValidDate(LocalDate.now());
//        List<PurPriceDetailParamDTO> collect = param.getItems().stream().map(vi -> {
//            PurPriceDetailParamDTO detail = new PurPriceDetailParamDTO();
//            detail.setItemId(vi.getItemId());
//            detail.setUom(vi.getUom());
//            detail.setCurrCode(param.getCurrCode());
//            return detail;
//        }).collect(Collectors.toList());
//        purPriceParam.setPurPriceDetailParamDtoList(collect);
//        List<PurPriceBaseDTO> purPriRpcResult = rmiPurPriceService.getPriceListByParam(purPriceParam);
//
//        var result = PriSalePriceConvert.INSTANCE.reqDtoToRespDto(param);
//        var errorJoiner = new StringJoiner(",");
//        List<PriSalePriceSimpleDTO> priceList = new ArrayList<>(items.size());
//        // 循环构造数据
//        for (PriSaleItemReqDTO req : items) {
//            var priSimpleDTO = new PriSalePriceSimpleDTO();
//            priSimpleDTO.setItemId(req.getItemId());
//            priSimpleDTO.setUom(req.getUom());
//
//            // 获取销售指导价
//            BigDecimal guidePrice = null;
//            Optional<ItmItemRpcDTO> io = itemRpcList.stream().filter(it -> it.getId().equals(req.getItemId())).findFirst();
//            if (io.isPresent()) {
//                priSimpleDTO.setItemCode(io.get().getItemCode());
//
//                // 获取采购价
//                purPriRpcResult.stream().filter(p -> p.getItemId().equals(priSimpleDTO.getItemId())
//                        && p.getToUom().equals(priSimpleDTO.getUom()))
//                        .findFirst().ifPresent(pri -> priSimpleDTO.setFloorPrice(pri.getPrice()));
//
//                // 获取指导价、销售底价
////                Optional<PriMainPriceRpcDTO> mpo = priceRpcResult.stream().filter(price -> req.getItemId().equals(price.getItemId())).findFirst();
////                if (mpo.isPresent()) {
////                    guidePrice = mpo.get().getPrice2();
////                    // 根据采购价计算销售底价：销售底价 = 采购价 /（1 - 毛利控制率） price4
////                    if (Objects.nonNull(mpo.get().getPrice4()) && Objects.nonNull(priSimpleDTO.getFloorPrice())) {
////                        priSimpleDTO.setFloorPrice(priSimpleDTO.getFloorPrice().divide(BigDecimal.ONE.subtract(mpo.get().getPrice4()), 4, RoundingMode.HALF_UP));
////                    } else {
////                        priSimpleDTO.setFloorPrice(null);
////                    }
////                }
//
//                // 临时记录最终获取到的价格计量单位
//                String priceUom = null;
//                // 先维护返回值中的基础价格：
//                // 若查询到的基础价单位与请求单位不一致，需要进行转换。若未找到转换系数，则以未查找到基础价处理，返回null
//                Optional<PriSalePriceDO> bpo = basePriceList.stream().filter(sp -> req.getItemId().equals(sp.getItemId())).findFirst();
//                if (bpo.isPresent()) {
//                    PriSalePriceDO basePrice = bpo.get();
//                    if ((!ObjectUtils.isEmpty(basePrice.getPromDateF()) && (basePrice.getPromDateF().isBefore(LocalDateTime.now()) || basePrice.getPromDateF().isEqual(LocalDateTime.now())))
//                            && (!ObjectUtils.isEmpty(basePrice.getPromDateT()) && (basePrice.getPromDateT().isAfter(LocalDateTime.now()) || basePrice.getPromDateT().isEqual(LocalDateTime.now())))){
//                        priSimpleDTO.setBasePrice(basePrice.getPromotionPrice());
//                    }else{
//                        priSimpleDTO.setBasePrice(basePrice.getPrice());
//                    }
//                    priSimpleDTO.setTaxRate(basePrice.getTaxRate());
//                    priSimpleDTO.setTaxRateNo(basePrice.getTaxRateNo());
//                    priceUom = basePrice.getUom();
//                    if (!req.getUom().equals(priceUom)) {
//                        BigDecimal ratio = this.getItemUomConvRatio(itemUomConvRpcResult, req.getItemId(), req.getUom(), priceUom);
//                        if (Objects.isNull(ratio)) {
//                            priSimpleDTO.setBasePrice(null);
//                            priSimpleDTO.setTaxRate(null);
//                            priSimpleDTO.setTaxRateNo(null);
//                        }
//                    }
//                }
//                // 1.先获取客户价格
//                Optional<PriSalePriceDO> cpo = custPriceList.stream()
//                        .filter(cp -> req.getItemId().equals(cp.getItemId()) && param.getCustId().equals(cp.getCustId())).findFirst();
//                if (cpo.isPresent()) {
//                    PriSalePriceDO custPrice = cpo.get();
//                    priSimpleDTO.setSalePrice(custPrice.getPrice());
//                    priSimpleDTO.setTaxRate(custPrice.getTaxRate());
//                    priSimpleDTO.setTaxRateNo(custPrice.getTaxRateNo());
//                    priceUom = custPrice.getUom();
//                } else {
//                    // 2.客户价格不存在，则获取客户等级价格进行赋值
//                    Optional<PriSalePriceDO> gpo = groupPriceList.stream()
//                            .filter(gp -> req.getItemId().equals(gp.getItemId()) && custLevel.equals(gp.getCustGroup())).findFirst();
//                    if (gpo.isPresent()) {
//                        PriSalePriceDO groupPrice = gpo.get();
//                        priSimpleDTO.setSalePrice(groupPrice.getPrice());
//                        priSimpleDTO.setTaxRate(groupPrice.getTaxRate());
//                        priSimpleDTO.setTaxRateNo(groupPrice.getTaxRateNo());
//                        priceUom = groupPrice.getUom();
//                    } else {
//                        // 3.客户等级价格不存在，则获取基础价格进行赋值
//                        priSimpleDTO.setSalePrice(priSimpleDTO.getBasePrice());
//                        // 4.基础价格也为空，则获取销售指导价进行赋值，且此时税率为商品主档税率
//                        if (Objects.isNull(priSimpleDTO.getSalePrice())) {
//                            priSimpleDTO.setSalePrice(guidePrice);
//                            priSimpleDTO.setTaxRate(io.get().getTaxRate2());
//                            // 查询主档价格税率编号
//                            taxRateRpcDtoByParam.stream().filter(tax -> tax.getTaxRateValue().equals(io.get().getTaxRate2().doubleValue()))
//                                    .findFirst()
//                                    .ifPresent(rate -> {
//                                        priSimpleDTO.setTaxRateNo(rate.getTaxRateNo());
//                                    });
//                            priceUom = io.get().getUom();
//                        }
//                    }
//                }
//
//                // 若最终未查询到销售价格，返回异常信息
//                // 若查询到价格，则需要校验计量单位与请求计量单位是否一致，不一致需要进行转换处理
//                if (Objects.isNull(priSimpleDTO.getSalePrice())) {
//                    priSimpleDTO.setTaxRate(null);
//                    priSimpleDTO.setTaxRateNo(null);
//                    priSimpleDTO.setErrorMsg("未维护销售价格");
//                    errorJoiner.add("商品[CODE=" + priSimpleDTO.getItemCode() + "]" + priSimpleDTO.getErrorMsg());
//                } else {
//                    if (!req.getUom().equals(priceUom)) {
//                        BigDecimal ratio = this.getItemUomConvRatio(itemUomConvRpcResult, req.getItemId(), req.getUom(), priceUom);
//                        if (Objects.isNull(ratio)) {
//                            priSimpleDTO.setSalePrice(null);
//                            priSimpleDTO.setTaxRate(null);
//                            priSimpleDTO.setTaxRateNo(null);
//                            priSimpleDTO.setErrorMsg("未维护计量单位" + req.getUom() + "->" + priceUom + "转化关系");
//                            errorJoiner.add("商品[CODE=" + priSimpleDTO.getItemCode() + "]" + priSimpleDTO.getErrorMsg());
//                        } else {
//                            priSimpleDTO.setSalePrice(priSimpleDTO.getSalePrice().multiply(ratio));
//                        }
//                    }
//                }
//                priceList.add(priSimpleDTO);
//            } else {
//                priSimpleDTO.setErrorMsg("商品不存在");
//                errorJoiner.add("商品[ID=" + req.getItemId() + "]不存在");
//            }
//        }
//        result.setPriceList(priceList);
//        // 校验是否存在errorMsg，且调用方直接返回错误，若存在直接返回失败
//        if (StrUtil.isNotBlank(errorJoiner.toString()) && (Objects.nonNull(param.getFailFast()) && param.getFailFast())) {
//            return ApiResult.fail("商品[" + errorJoiner.toString() + "]未获取到销售价格");
//        }
//        return ApiResult.ok(result);
        return null;
    }

    @Override
    public ApiResult<List<PriSalePriceDTO>> findSalePriceListDto(List<PriSalePriceReqDTO> params) throws InterruptedException {
        if (CollectionUtils.isEmpty(params)){
            return ApiResult.ok();
        }
        ExecutorService executorService = Executors.newFixedThreadPool(200);
        List<Callable<PriSalePriceDTO>> tasks = new ArrayList<>(params.size());
        params.forEach(p ->{
            tasks.add(() -> findSalePriceDto(p).getData());
        });
        List<PriSalePriceDTO> resList = new ArrayList<>();
        List<Future<PriSalePriceDTO>> list = executorService.invokeAll(tasks);
        for(Future<PriSalePriceDTO> f : list){
            try {
                resList.add(f.get());
            }catch (Exception e){
                log.info(e.getMessage());
                return ApiResult.fail();
            }
        }
//        List<PriSalePriceDTO> priSalePriceDTOS = params.stream().map(i ->
//        }{
//            ApiResult<PriSalePriceDTO> salePriceDto = this.findSalePriceDto(i);
//            if (!salePriceDto.isSuccess()) {
//                throw new BusinessException(salePriceDto.getMsg());
//            } else {
//                return salePriceDto.getData();
//            }
//        }).collect(Collectors.toList());
//        return ApiResult.ok(priSalePriceDTOS);
        return ApiResult.ok(resList);
    }

    @Override
    public ApiResult<PriCrossPriceDTO> findCrossPriceDto(PriCrossPriceReqDTO param) {
//        List<PriSaleItemReqDTO> items = param.getItems().stream().distinct().collect(Collectors.toList());
//        List<Long> itemIds = items.stream().map(PriSaleItemReqDTO::getItemId).collect(Collectors.toList());
//        // 查询【销售公司 + 商品 + 币种】所有内部结算价
//        List<PriSalePriceDO> crossPriceList = doQueryPrice(true, param.getOuId(), param.getCurrCode(), itemIds);
//        // 查询商品信息及计量单位转换率
//        List<ItmItemRpcDTO> itmRpcResult = rmiItemService.findItemList(itemIds, null);
//        List<ItmItemUomConvRpcDTO> itmUomConvRpcResult = rmiItemService.findItemUomConvDtoList(itemIds);
//
//        var result = PriSalePriceConvert.INSTANCE.reqDtoToRespDto(param);
//
//        // 循环构造数据
//        List<PriCrossPriceSimpleDTO> priceList = new ArrayList<>(items.size());
//        for (PriSaleItemReqDTO req : items) {
//            var priSimpleDTO = new PriCrossPriceSimpleDTO();
//            priSimpleDTO.setItemId(req.getItemId());
//            priSimpleDTO.setUom(req.getUom());
//            Optional<ItmItemRpcDTO> io = itmRpcResult.stream().filter(i -> i.getId().equals(req.getItemId())).findFirst();
//            if (io.isPresent()) {
//                priSimpleDTO.setItemCode(io.get().getItemCode());
//                priSimpleDTO.setItemName(io.get().getItemName());
//                // 1.先查找客户的（custId不为空，saleRegion为空）
//                Optional<PriSalePriceDO> cco = crossPriceList.stream().filter(cp -> cp.getItemId().equals(req.getItemId())
//                        && Objects.nonNull(cp.getCustId()) && cp.getCustId().equals(param.getCustId())
//                        && StrUtil.isBlank(cp.getSaleRegion())).findFirst();
//                if (cco.isPresent()) {
//                    PriSalePriceDO crossPrice = cco.get();
//                    if ((!ObjectUtils.isEmpty(crossPrice.getPromDateF()) && (crossPrice.getPromDateF().isBefore(LocalDateTime.now()) || crossPrice.getPromDateF().isEqual(LocalDateTime.now())))
//                            && (!ObjectUtils.isEmpty(crossPrice.getPromDateT()) && (crossPrice.getPromDateT().isAfter(LocalDateTime.now()) || crossPrice.getPromDateT().isEqual(LocalDateTime.now())))){
//                        priSimpleDTO.setOriginPrice(crossPrice.getPromotionPrice());
//                    }else{
//                        priSimpleDTO.setOriginPrice(crossPrice.getPrice());
//                    }
////                    priSimpleDTO.setOriginPrice(cco.get().getPrice());
//                    priSimpleDTO.setTaxRate(crossPrice.getTaxRate());
//                    priSimpleDTO.setTaxRateNo(crossPrice.getTaxRateNo());
//                    priSimpleDTO.setPriceUom(crossPrice.getUom());
//                } else {
//                    // 2.客户未找到，找区域的（custId为空，saleRegion不为空）
//                    Optional<PriSalePriceDO> rco = crossPriceList.stream().filter(cp -> cp.getItemId().equals(req.getItemId())
//                            && StrUtil.isNotBlank(cp.getSaleRegion()) && cp.getSaleRegion().equals(param.getRegion())
//                            && Objects.isNull(cp.getCustId())).findFirst();
//                    if (rco.isPresent()) {
//                        PriSalePriceDO crossPrice = rco.get();
//                        if ((!ObjectUtils.isEmpty(crossPrice.getPromDateF()) && (crossPrice.getPromDateF().isBefore(LocalDateTime.now()) || crossPrice.getPromDateF().isEqual(LocalDateTime.now())))
//                                && (!ObjectUtils.isEmpty(crossPrice.getPromDateT()) && (crossPrice.getPromDateT().isAfter(LocalDateTime.now()) || crossPrice.getPromDateT().isEqual(LocalDateTime.now())))){
//                            priSimpleDTO.setOriginPrice(crossPrice.getPromotionPrice());
//                        }else{
//                            priSimpleDTO.setOriginPrice(crossPrice.getPrice());
//                        }
////                        priSimpleDTO.setOriginPrice(rco.get().getPrice());
//                        priSimpleDTO.setTaxRate(crossPrice.getTaxRate());
//                        priSimpleDTO.setTaxRateNo(crossPrice.getTaxRateNo());
//                        priSimpleDTO.setPriceUom(crossPrice.getUom());
//                    } else {
//                        // 3.区域未找到，找公司的（custId和saleRegion都为空）
//                        Optional<PriSalePriceDO> co = crossPriceList.stream().filter(cp -> cp.getItemId().equals(req.getItemId())
//                                && Objects.isNull(cp.getCustId()) && StrUtil.isBlank(cp.getSaleRegion())).findFirst();
//                        if (co.isPresent()) {
//                            PriSalePriceDO crossPrice = co.get();
//                            if ((!ObjectUtils.isEmpty(crossPrice.getPromDateF()) && (crossPrice.getPromDateF().isBefore(LocalDateTime.now()) || crossPrice.getPromDateF().isEqual(LocalDateTime.now())))
//                                    && (!ObjectUtils.isEmpty(crossPrice.getPromDateT()) && (crossPrice.getPromDateT().isAfter(LocalDateTime.now()) || crossPrice.getPromDateT().isEqual(LocalDateTime.now())))){
//                                priSimpleDTO.setOriginPrice(crossPrice.getPromotionPrice());
//                            }else{
//                                priSimpleDTO.setOriginPrice(crossPrice.getPrice());
//                            }
//                            priSimpleDTO.setTaxRate(crossPrice.getTaxRate());
//                            priSimpleDTO.setTaxRateNo(crossPrice.getTaxRateNo());
////                            priSimpleDTO.setOriginPrice(crossPrice.getPrice());
//                            priSimpleDTO.setPriceUom(co.get().getUom());
//                        } else {
//                            priSimpleDTO.setErrorMsg("未维护内部结算价");
//                        }
//                    }
//                }
//                // 若查询到价格，则需要校验计量单位与请求计量单位是否一致，不一致需要进行转换处理
//                if (Objects.nonNull(priSimpleDTO.getOriginPrice())) {
//                    if (!req.getUom().equals(priSimpleDTO.getPriceUom())) {
//                        BigDecimal ratio = this.getItemUomConvRatio(itmUomConvRpcResult, req.getItemId(), req.getUom(), priSimpleDTO.getPriceUom());
//                        if (Objects.isNull(ratio)) {
//                            priSimpleDTO.setPrice(null);
//                            priSimpleDTO.setErrorMsg("未维护计量单位转化关系");
//                        } else {
//                            priSimpleDTO.setPrice(priSimpleDTO.getOriginPrice().multiply(ratio));
//                        }
//                    } else {
//                        priSimpleDTO.setPrice(priSimpleDTO.getOriginPrice());
//                    }
//                }
//            } else {
//                priSimpleDTO.setErrorMsg("商品不存在");
//            }
//            priceList.add(priSimpleDTO);
//        }
//        result.setPriceList(priceList);
//        return ApiResult.ok(result);
        return null;
    }

    @Override
    public ApiResult<PriBasePriceDTO> findBasePriceDto(PriBasePriceReqDTO param) {
//        param.setCurrCode(StrUtil.isBlank(param.getCurrCode()) ? "CNY" : param.getCurrCode());
//        List<PriSaleItemReqDTO> items = param.getItems().stream().distinct().collect(Collectors.toList());
//        List<Long> itemIds = items.stream().map(PriSaleItemReqDTO::getItemId).distinct().collect(Collectors.toList());
//
//        // 查询【销售公司 + 商品 + 币种】除【内部结算价】的所有类型价格，直接先筛选出基础价格
//        List<PriSalePriceDO> salePriceList = doQueryPrice(false, param.getOuId(), param.getCurrCode(), itemIds);
//        List<PriSalePriceDO> basePriceList = salePriceList.stream().filter(p -> TYPE_BASE.equals(p.getPriceType())).collect(Collectors.toList());
//
//        List<ItmItemRpcDTO> itemRpcList = rmiItemService.findItemList(itemIds, null);
//        List<ItmItemUomConvRpcDTO> itemUomConvRpcResult = rmiItemService.findItemUomConvDtoList(itemIds);
//
//        var result = PriSalePriceConvert.INSTANCE.reqDtoToRespDto(param);
//        var errorJoiner = new StringJoiner(",");
//        List<PriBasePriceSimpleDTO> priceList = new ArrayList<>(items.size());
//        // 循环构造数据
//        for (PriSaleItemReqDTO req : items) {
//            var priSimpleDTO = new PriBasePriceSimpleDTO();
//            priSimpleDTO.setItemId(req.getItemId());
//            priSimpleDTO.setUom(req.getUom());
//
//            Optional<ItmItemRpcDTO> io = itemRpcList.stream().filter(it -> it.getId().equals(req.getItemId())).findFirst();
//            if (io.isPresent()) {
//                priSimpleDTO.setItemCode(io.get().getItemCode());
//
//                // 临时记录最终获取到的价格计量单位
//                String priceUom = null;
//                // 先维护返回值中的基础价格：
//                // 若查询到的基础价单位与请求单位不一致，需要进行转换。若未找到转换系数，则以未查找到基础价处理，返回null
//                Optional<PriSalePriceDO> bpo = basePriceList.stream().filter(sp -> req.getItemId().equals(sp.getItemId())).findFirst();
//                if (bpo.isPresent()) {
//                    PriSalePriceDO basePrice = bpo.get();
//                    if ((!ObjectUtils.isEmpty(basePrice.getPromDateF()) && (basePrice.getPromDateF().isBefore(LocalDateTime.now()) || basePrice.getPromDateF().isEqual(LocalDateTime.now())))
//                            && (!ObjectUtils.isEmpty(basePrice.getPromDateT()) && (basePrice.getPromDateT().isAfter(LocalDateTime.now()) || basePrice.getPromDateT().isEqual(LocalDateTime.now())))){
//                        priSimpleDTO.setBasePrice(basePrice.getPromotionPrice());
//                    }else{
//                        priSimpleDTO.setBasePrice(basePrice.getPrice());
//                    }
//                    priSimpleDTO.setTaxRate(basePrice.getTaxRate());
//                    priSimpleDTO.setTaxRateNo(basePrice.getTaxRateNo());
//                    priceUom = basePrice.getUom();
//                    if (!req.getUom().equals(priceUom)) {
//                        BigDecimal ratio = this.getItemUomConvRatio(itemUomConvRpcResult, req.getItemId(), req.getUom(), priceUom);
//                        if (Objects.isNull(ratio)) {
//                            priSimpleDTO.setBasePrice(null);
//                            priSimpleDTO.setTaxRate(null);
//                            priSimpleDTO.setTaxRateNo(null);
//                            priSimpleDTO.setErrorMsg("未维护计量单位" + req.getUom() + "->" + priceUom + "转化关系");
//                            errorJoiner.add("商品[CODE=" + priSimpleDTO.getItemCode() + "]" + priSimpleDTO.getErrorMsg());
//                        } else {
//                            priSimpleDTO.setBasePrice(priSimpleDTO.getBasePrice().multiply(ratio));
//                        }
//                    }
//                } else {
//                    priSimpleDTO.setTaxRate(null);
//                    priSimpleDTO.setTaxRateNo(null);
//                    priSimpleDTO.setErrorMsg("未维护基础价格");
//                    errorJoiner.add("商品[CODE=" + priSimpleDTO.getItemCode() + "]" + priSimpleDTO.getErrorMsg());
//                }
//                priceList.add(priSimpleDTO);
//            } else {
//                priSimpleDTO.setErrorMsg("商品不存在");
//                errorJoiner.add("商品[ID=" + req.getItemId() + "]不存在");
//            }
//        }
//        result.setPriceList(priceList);
//        // 校验是否存在errorMsg，且调用方直接返回错误，若存在直接返回失败
//        if (StrUtil.isNotBlank(errorJoiner.toString()) && (Objects.nonNull(param.getFailFast()) && param.getFailFast())) {
//            return ApiResult.fail("商品[" + errorJoiner.toString() + "]未获取到基础价格");
//        }
//        return ApiResult.ok(result);
        return null;
    }

    @Override
    public ApiResult<PriSalePriceDTO> findSaleTaxRateDto(PriSalePriceReqDTO param) {
        //反查custId通过custCode
//        if(ObjectUtils.isEmpty(param.getCustId()) && !ObjectUtils.isEmpty(param.getCustCode())){
//            List<CrmCustSimpleDTO> custSimpleDTOS = crmCustRepoProc.query(param.getCustCode());
//            if (!CollectionUtils.isEmpty(custSimpleDTOS)){
//                param.setCustId(custSimpleDTOS.get(0).getId());
//            }else{
//                return null;
//            }
//        }
//        // 设置默认币种
//        param.setCurrCode(StrUtil.isBlank(param.getCurrCode()) ? "CNY" : param.getCurrCode());
//        // 过滤筛选商品id
//        List<PriSaleItemReqDTO> items = param.getItems().stream().distinct().collect(Collectors.toList());
//        List<Long> itemIds = items.stream().map(PriSaleItemReqDTO::getItemId).distinct().collect(Collectors.toList());
//
//        // 查询【销售公司 + 商品 + 客户】筛选出客户价格
//        List<PriSalePriceDO> salePriceList = doQueryPrice(false, param.getOuId(), param.getCurrCode(), itemIds);
//        List<PriSalePriceDO> custPriceList = salePriceList.stream().filter(p -> TYPE_CUST.equals(p.getPriceType())).collect(Collectors.toList());
//
//        // 获取商品主数据相关辅助信息
//        List<ItmItemRpcDTO> itemRpcList = rmiItemService.findItemList(itemIds, null);
//
//        var result = PriSalePriceConvert.INSTANCE.reqDtoToRespDto(param);
//        var errorJoiner = new StringJoiner(",");
//        List<PriSalePriceSimpleDTO> priceList = new ArrayList<>(items.size());
//        // 循环构造数据
//        for (PriSaleItemReqDTO req : items) {
//            var priSimpleDTO = new PriSalePriceSimpleDTO();
//            priSimpleDTO.setItemId(req.getItemId());
//            priSimpleDTO.setUom(req.getUom());
//
//            // 获取销售指导价
//            Optional<ItmItemRpcDTO> io = itemRpcList.stream().filter(it -> it.getId().equals(req.getItemId())).findFirst();
//            if (io.isPresent()) {
//                // 1.先获取客户价格
//                Optional<PriSalePriceDO> cpo = custPriceList.stream()
//                        .filter(cp -> req.getItemId().equals(cp.getItemId()) && param.getCustId().equals(cp.getCustId())).findFirst();
//                if (cpo.isPresent()) {
//                    PriSalePriceDO custPrice = cpo.get();
//                    priSimpleDTO.setSalePrice(custPrice.getPrice());
//                    priSimpleDTO.setTaxRate(custPrice.getTaxRate());
//                    priSimpleDTO.setTaxRateNo(custPrice.getTaxRateNo());
//                }
//                priceList.add(priSimpleDTO);
//            } else {
//                priSimpleDTO.setErrorMsg("商品不存在");
//                errorJoiner.add("商品[ID=" + req.getItemId() + "]不存在");
//            }
//        }
//        result.setPriceList(priceList);
//        // 校验是否存在errorMsg，且调用方直接返回错误，若存在直接返回失败
//        if (StrUtil.isNotBlank(errorJoiner.toString()) && (Objects.nonNull(param.getFailFast()) && param.getFailFast())) {
//            return ApiResult.fail("商品[" + errorJoiner.toString() + "]未获取到销售价格相关信息");
//        }
//        return ApiResult.ok(result);
        return null;
    }

    /**
     * 查询价格
     */
    private List<PriSalePriceDO> doQueryPrice(boolean crossType, Long ouId, String currCode, List<Long> itemIds) {
        Predicate predicate = qPriSalePriceDO.ouId.eq(ouId);
        if (crossType) {
            predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.priceType.eq(TYPE_CROSS));
        } else {
            predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.priceType.notIn(TYPE_CROSS));
        }
        predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.currCode.eq(currCode));
        predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.itemId.in(itemIds));
        LocalDateTime validTime = LocalDateTime.now();
        predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.validFrom.before(validTime).or(qPriSalePriceDO.validFrom.eq(validTime)));
        predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.validTo.after(validTime).or(qPriSalePriceDO.validTo.eq(validTime)));
        var jpaQuery = jpaQueryFactory.selectFrom(qPriSalePriceDO).where(predicate);
        return jpaQuery.fetch();
    }

    /**
     * 获取商品从fromUom到toUom的转化率
     */
    private BigDecimal getItemUomConvRatio(List<ItmItemUomConvRpcDTO> itmUomConvRpcResult, Long itemId, String fromUom, String toUom) {
        Optional<ItmItemUomConvRpcDTO> uo = itmUomConvRpcResult.stream().filter(u -> u.getItemId().equals(itemId)
                && fromUom.equals(u.getFromUom()) && toUom.equals(u.getToUom())).findFirst();
        return uo.map(ItmItemUomConvRpcDTO::getRatio).orElse(null);
    }

    // 四种价格类型
    public static final String TYPE_BASE = UdcEnum.PRI_SALE_PRICE_TYPE_BASE.getValueCode();
    public static final String TYPE_CUST = UdcEnum.PRI_SALE_PRICE_TYPE_CUST.getValueCode();
    public static final String TYPE_GROUP = UdcEnum.PRI_SALE_PRICE_TYPE_GROUP.getValueCode();
    public static final String TYPE_CROSS = UdcEnum.PRI_SALE_PRICE_TYPE_CROSS.getValueCode();
}
