package com.elitesland.yst.production.sale.service;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitescloud.cloudt.system.dto.SysUdcDTO;
import com.elitescloud.cloudt.system.dto.req.SysAreaQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysCurrencyRpcService;
import com.elitesland.yst.production.pur.dto.PurPriceBaseDTO;
import com.elitesland.yst.production.pur.dto.PurPriceBatchParamDTO;
import com.elitesland.yst.production.pur.dto.PurPriceDetailParamDTO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.elitesland.yst.production.inv.dto.invwh.InvWhRpcDTO;
import com.elitesland.yst.production.sale.Application;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.service.SalQuotationDService;
import com.elitesland.yst.production.sale.api.service.SalQuotationService;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalQuotationQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalQuotationDRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalQuotationDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalQuotationExportVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalQuotationPageRespVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.SalQuotationConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.QSalQuotationDDO;
import com.elitesland.yst.production.sale.entity.QSalQuotationDO;
import com.elitesland.yst.production.sale.entity.SalQuotationDO;
import com.elitesland.yst.production.sale.repo.CrmCustRepoProc;
import com.elitesland.yst.production.sale.repo.SalQuotationRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCompanyManageRepoProc;
import com.elitesland.yst.production.sale.rmi.ystinv.RmiInvWhProviderService;
import com.elitesland.yst.production.sale.rmi.ystpur.RmiPurPriceService;
import com.elitesland.yst.production.sale.rmi.ystsupport.*;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiCommonService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.sale.workflow.ProcDefKey;
import com.elitesland.yst.production.support.provider.item.param.ItmCheckBusinessStatusRpcParam;
import com.elitesland.yst.production.support.provider.item.param.ItmCheckLifeStatusRpcParam;
import com.elitesland.yst.production.support.provider.item.service.ItmItemRpcService;
import com.elitesland.yst.production.support.provider.org.dto.OrgBuRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgEmpRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgBuRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.param.OrgEmpRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.param.OrgOuRpcDtoParam;
import com.elitesland.yst.production.support.provider.price.dto.PriMainPriceRpcDTO;
import com.google.common.collect.Sets;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/15 20:58
 */
@Service("salQuotationServiceImpl")
@RequiredArgsConstructor
@Slf4j
public class SalQuotationServiceImpl extends BaseServiceImpl implements SalQuotationService {

    private static final QSalQuotationDO salQuotationDO = QSalQuotationDO.salQuotationDO;

    private static final QSalQuotationDDO salQuotationDDO = QSalQuotationDDO.salQuotationDDO;

    private final RmiInvWhProviderService rmiInvWhProviderService;

    private final RmiOrgEmpService rmiOrgEmpService;

    private final RmiOrgOuService rmiOrgOuService;

    private final RmiOrgBuService rmiOrgBuService;

    private final SalQuotationDService salQuotationDService;

    private final RmiSysNextNumberService rmiSysNextNumberService;

    private final SalQuotationRepo salQuotationRepo;

    private final CrmCustRepoProc crmCustRepoProc;

    private final RmiCommonService rmiCommonService;

    private final RmiOrgAddrService rmiOrgAddrService;

    private final CrmCustService crmCustService;

    private final TransactionTemplate transactionTemplate;

    private final RmiPurPriceService rmiPurPriceService;

    private final RmiPriMainPriceService rmiPriMainPriceService;

    private final RmiCityCodeService rmiCityCodeService;

    private final BipCompanyManageRepoProc bipCompanyManageRepoProc;

    private final SysCurrencyRpcService sysCurrencyRpcService;

    private final ItmItemRpcService itemRpcService;

    private final WorkflowService workflowService;

    private final UdcProvider udcProvider;


    @Override
    @SysCodeProc
    public PagingVO<SalQuotationPageRespVO> search(SalQuotationQueryParamVO searchParam) {
        var jpaQuery = this.select(searchParam);
        long total = jpaQuery.fetchCount();
        if (total == 0) {
            return PagingVO.<SalQuotationPageRespVO>builder().build();
        }
        // 添加分页和排序
        PageRequest pageRequest = wrapperPageRequest(searchParam.getPageRequest(), null);
        appendPageAndSort(jpaQuery, pageRequest, salQuotationDO);
        List<SalQuotationPageRespVO> respVOS = jpaQuery.fetch();
        // 补充数据
        this.translatePage(respVOS);
        return PagingVO.<SalQuotationPageRespVO>builder()
                .total(total)
                .records(respVOS).build();
    }

    public JPAQuery<SalQuotationPageRespVO> select(SalQuotationQueryParamVO searchParam) {

        val jpaQuery = jpaQueryFactory.select(Projections.bean(SalQuotationPageRespVO.class,
                salQuotationDO.id,
                salQuotationDO.qtCustType,
                salQuotationDO.custCode,
                salQuotationDO.custName,
                salQuotationDO.ouId,
                salQuotationDO.buId,
                salQuotationDO.agentEmpId,
                salQuotationDO.quotationDate,
                salQuotationDO.quotationStatus,
                salQuotationDO.approvedTime,
                salQuotationDO.apprUserId,
                salQuotationDO.whId,
                salQuotationDO.netAmt,
                salQuotationDO.amt,
                salQuotationDO.payMethod,
                salQuotationDO.custContactName,
                salQuotationDO.custContactTel,
                salQuotationDO.demandTimespan,
                salQuotationDO.deliverMethod,
                salQuotationDO.recvAddrNo,
                salQuotationDO.recvDetailaddr,
                salQuotationDO.currCode,
                salQuotationDO.taxAmt,
                salQuotationDO.docNo,
                salQuotationDO.remark,
                salQuotationDO.saleRegion
//                salQuotationDO.apprComment

        )).from(salQuotationDO);
        if (searchParam != null) {
            jpaQuery.where(where(searchParam));
        }
        return jpaQuery;
    }

    private void translatePage(List<SalQuotationPageRespVO> respVOS) {
        if (CollectionUtils.isEmpty(respVOS)) {
            return;
        }
        List<Long> agentEmpIds = respVOS.stream().map(SalQuotationPageRespVO::getAgentEmpId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> apprAppIds = respVOS.stream().map(SalQuotationPageRespVO::getApprUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
        List<OrgEmpRpcDTO> empDtoByParam = new ArrayList<>();
        agentEmpIds.addAll(apprAppIds);
        List<Long> empIds = agentEmpIds.stream().distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(empIds)) {
            orgEmpRpcDtoParam.setEmpIds(empIds);
            empDtoByParam = rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);
        }

        OrgBuRpcDtoParam orgBuRpcDtoParam = new OrgBuRpcDtoParam();
        List<Long> buIds = respVOS.stream().map(SalQuotationPageRespVO::getBuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<OrgBuRpcDTO> buDtoByParam = new ArrayList<>();
        if (!CollectionUtils.isEmpty(buIds)) {
            orgBuRpcDtoParam.setBuIds(buIds);
            buDtoByParam = rmiOrgBuService.findBuDtoByParam(orgBuRpcDtoParam);
        }
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        List<Long> ouIds = respVOS.stream().map(SalQuotationPageRespVO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<OrgOuRpcDTO> ouDtoListByParam = new ArrayList<>();
        if (!CollectionUtils.isEmpty(ouIds)) {
            orgOuRpcDtoParam.setOuIds(ouIds);
            ouDtoListByParam = rmiOrgOuService.findOuDtoListByParam(orgOuRpcDtoParam);
        }
        List<Long> whIds = respVOS.stream().map(SalQuotationPageRespVO::getWhId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<InvWhRpcDTO> dtoByPara = new ArrayList<>();
        if (!CollectionUtils.isEmpty(whIds)) {
            dtoByPara = rmiInvWhProviderService.findBuDtoByParam(whIds);
        }
        Set<String> currCodes = respVOS.stream().map(SalQuotationPageRespVO::getCurrCode).filter(Objects::nonNull).distinct().collect(Collectors.toSet());

        List<SysCurrencyRespDTO> currDtoList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(currCodes)) {
            ApiResult<List<SysCurrencyRespDTO>> sysCurrencyRespDTOListApiResult = sysCurrencyRpcService.listByCodes(currCodes);
            Assert.notNull(sysCurrencyRespDTOListApiResult,"根据编码查询币种失败");
            Assert.isTrue(sysCurrencyRespDTOListApiResult.isSuccess(),"根据编码查询币种失败");
            currDtoList = sysCurrencyRpcService.listByCodes(currCodes).getData();

        }

        List<OrgEmpRpcDTO> finalEmpDtoByParam = empDtoByParam;
        List<OrgBuRpcDTO> finalBuDtoByParam = buDtoByParam;
        List<OrgOuRpcDTO> finalOuDtoListByParam = ouDtoListByParam;
        List<InvWhRpcDTO> finalDtoByPara = dtoByPara;
        List<SysCurrencyRespDTO> finalCurrDtoList = currDtoList;
        for (SalQuotationPageRespVO quo : respVOS) {
            if (!StringUtils.isEmpty(quo.getAgentEmpId())) {
                finalEmpDtoByParam.stream().filter(salQuo -> quo.getAgentEmpId().equals(salQuo.getId()))
                        .findFirst()
                        .ifPresent(sal -> quo.setAgentEmpName(sal.getEmpName()));
            }
            if (!StringUtils.isEmpty(quo.getBuId())) {
                finalBuDtoByParam.stream().filter(salQuo -> quo.getBuId().equals(salQuo.getId()))
                        .findFirst()
                        .ifPresent(sal -> quo.setBuName(sal.getBuName()));
            }
            if (!StringUtils.isEmpty(quo.getOuId())) {
                finalOuDtoListByParam.stream().filter(salQuo -> quo.getOuId().equals(salQuo.getId()))
                        .findFirst()
                        .ifPresent(sal -> quo.setOuName(sal.getOuName()));
            }
            if (!StringUtils.isEmpty(quo.getWhId())) {
                finalDtoByPara.stream().filter(salQuo -> quo.getWhId().equals(salQuo.getWhId()))
                        .findFirst()
                        .ifPresent(sal -> quo.setWhName(sal.getWhName()));
            }
            if (!StringUtils.isEmpty(quo.getCurrCode())) {
                finalCurrDtoList.stream().filter(salQuo -> quo.getCurrCode().equals(salQuo.getCurrCode()))
                        .findFirst()
                        .ifPresent(sal -> quo.setCurrCodeName(sal.getCurrName()));
            }
            if (!StringUtils.isEmpty(quo.getApprUserId())){
                finalEmpDtoByParam.stream().filter(salQuo -> quo.getApprUserId().equals(salQuo.getId()))
                        .findFirst()
                        .ifPresent(sal -> quo.setApprUserName(sal.getEmpName()));
            }
        }
    }

    /**
     * 条件查询
     *
     * @param param 查询条件
     */
    public Predicate where(SalQuotationQueryParamVO param) {

        Predicate predicate = salQuotationDO.isNotNull();
        predicate = ExpressionUtils.and(predicate, salQuotationDO.deleteFlag.ne(ConstantsSale.COMMON_DELETE_YSE));
        //报价单id
        if (!StringUtils.isEmpty(param.getId())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.id.eq(param.getId()));
        }
        //id集合
        if (!CollectionUtils.isEmpty(param.getIds())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.id.in(param.getIds()));
        }
        //客户类型
        if (!StringUtils.isEmpty(param.getQtCustType())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.qtCustType.eq(param.getQtCustType()));
        }
        //客户编码
        if (!StringUtils.isEmpty(param.getCustCode())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.custCode.like("%" + param.getCustCode() + "%"));
        }
        //客户名称
        if (!StringUtils.isEmpty(param.getCustName())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.custName.like("%" + param.getCustName() + "%"));
        }
        //公司id
        if (!StringUtils.isEmpty(param.getOuId())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.ouId.eq(param.getOuId()));
        }
        //经销商id
        if (!StringUtils.isEmpty(param.getBuId())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.buId.eq(param.getBuId()));
        }
        //业务员id
        if (!StringUtils.isEmpty(param.getAgentEmpId())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.agentEmpId.eq(param.getAgentEmpId()));
        }
        //报价日期
        if (!StringUtils.isEmpty(param.getBeginQuotationDate())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.quotationDate.eq(param.getBeginQuotationDate()).or(salQuotationDO.quotationDate.after(param.getBeginQuotationDate())));
        }
        if (!StringUtils.isEmpty(param.getEndQuotationDate())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.quotationDate.eq(param.getEndQuotationDate()).or(salQuotationDO.quotationDate.before(param.getEndQuotationDate())));
        }
        //报价单状态
        if (!StringUtils.isEmpty(param.getQuotationStatus())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.quotationStatus.eq(param.getQuotationStatus()));
        }
        //审批日期
        if (!StringUtils.isEmpty(param.getBeginApprTime())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.approvedTime.eq(param.getBeginApprTime()).or(salQuotationDO.approvedTime.after(param.getBeginApprTime())));
        }
        if (!StringUtils.isEmpty(param.getEndApprTime())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.approvedTime.eq(param.getEndApprTime()).or(salQuotationDO.approvedTime.before(param.getBeginApprTime())));
        }
        //审批人id
        if (!StringUtils.isEmpty(param.getApprUserId())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.apprUserId.eq(param.getApprUserId()));
        }
        //报价单单号
        if (!StringUtils.isEmpty(param.getDocNo())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.docNo.eq(param.getDocNo()));
        }
        //区域
        if (!StringUtils.isEmpty(param.getSaleRegion())){
            predicate = ExpressionUtils.and(predicate, salQuotationDO.saleRegion.eq(param.getSaleRegion()));
        }
        if (!ObjectUtils.isEmpty(param.getIfCheckApprovalFlag()) && param.getIfCheckApprovalFlag().equals(Boolean.TRUE)){
            predicate = ExpressionUtils.and(predicate, salQuotationDO.quotationStatus.eq(UdcEnum.SAL_QUOTATION_STATUS_APPROVED.getValueCode())
                    .or(salQuotationDO.quotationStatus.eq(UdcEnum.SAL_QUOTATION_STATUS_REJECTED.getValueCode())));
        }
//        // 添加权限信息
        predicate = ExpressionUtils.and(predicate, DataAuthJpaUtil.dataAuthJpaPredicate(salQuotationDO.getMetadata()));
        return predicate;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long submitSalQuotation(SalQuotationDetailRespVO salQuotationDetailRespVO) {

        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "无法到获取当前用户");
        }

        checkFreeze(salQuotationDetailRespVO);


        // 设置隔离级别
        transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
        // ----------- 不同价格类型，进行校验特定的参数，校验通过返回已存在的申请单 -----------
        // 开启事务
        SalQuotationDO quotationDO1 = transactionTemplate.execute(transactionStatus ->{
            try {
                Long salQuotationId = this.createSalQuotation(salQuotationDetailRespVO);
                return  salQuotationRepo.findById(salQuotationId).get();
            } catch (Exception e){
                // 回滚
                transactionStatus.setRollbackOnly();
                throw e;
            }
        });
        quotationDO1.setQuotationStatus(UdcEnum.SAL_QUOTATION_STATUS_APPROVING.getValueCode());
        SalQuotationDO quotationDO = salQuotationRepo.save(quotationDO1);

        /************************************************************************
         *                              工作流开始                                *
         ************************************************************************/
        if (StringUtils.isEmpty(quotationDO1.getId())                                                                    //1,新对象
                || StringUtils.isEmpty(quotationDO1.getProcInstId())                                                   //2,旧单子，未起过工作流
                || WorkflowConstant.CAN_START_PROC_STATUSES.contains(quotationDO1.getProcInstStatus())    //3,旧单子，可以起工作流
        ) {
            /**
             * 为什么要加上面3个判断，是因为流程已经启动了,就没必要再启动流程(场景:在'审批中'的过程中，做保存操作)
             * 工作流规则:
             *  1,一个业务单据在一个流程没结束前是不能再起的同一个工作流
             *  2,一个业务单据可以同时有2个"不同类型"的流程再跑
             */
            //启动流程
            String procInstName = null;//流程实例名称
            ProcDefKey procDefKey = null;//流程

            procInstName = "B端销售报价单";//这里可以自定义
            procDefKey = ProcDefKey.SAL_QUOTATION;

            HashMap<String,Object> variables = new HashMap<>();
            /**
             * 业务代码判断所有的销售底价之和和所有的含税金额之间的大小比较
             */
            Boolean aBoolean = this.processBranchControl(salQuotationDetailRespVO);

            if (aBoolean.equals(Boolean.TRUE)){
                variables.put("belowPrice",1);
            }else{
                variables.put("belowPrice",0);
            }


            WorkflowResult<ProcessInfo> processInfo= workflowService.startProcess(StartProcessPayload.of(procDefKey.name(),
                    procInstName+"-"+quotationDO1.getDocNo(),quotationDO1.getId() + "",variables));

            if(ObjectUtils.isEmpty(processInfo)){
                throw new BusinessException("工作流启动服务失败,请检查");
            }
            Assert.isTrue(processInfo.isSuccess(),"工作流启动服务失败,请检查");
            log.info("工作流启动返回参数{}",JSON.toJSONString(processInfo));
            //修改业务审批数据
            QSalQuotationDO qSalQuotationDO = QSalQuotationDO.salQuotationDO;
            JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qSalQuotationDO)
                    .set(qSalQuotationDO.procInstId, processInfo.getData().getProcInstId())//流程实例id
//                        .set(qPriSalePriceAlterDO.procInstStatus, ProcInstStatus.APPROVING)//审批状态
                    .set(qSalQuotationDO.submitTime, LocalDateTime.now())//提交实际那
//                        .set(qPriSalePriceAlterDO.docStatus, UdcEnum.PRI_APPLY_STATUS_APPING.getValueCode())//单据状态
                    .where(qSalQuotationDO.id.eq(quotationDO1.getId()));
            if (!Objects.equals(processInfo.getData().getProcInstStatus(),ProcInstStatus.APPROVED)){
                jpaUpdateClause.set(qSalQuotationDO.procInstStatus,ProcInstStatus.APPROVING);
                jpaUpdateClause.set(qSalQuotationDO.quotationStatus,UdcEnum.SAL_QUOTATION_STATUS_APPROVING.getValueCode());
            }
            jpaUpdateClause.execute();
        }
        /************************************************************************
         *                              工作流结束                                *
         ************************************************************************/
        return quotationDO.getId();
    }

    private Boolean processBranchControl(SalQuotationDetailRespVO salQuotationDetailRespVO){
        List<SalQuotationDRespVO> salQuotationDRespVO = salQuotationDetailRespVO.getSalQuotationDRespVO();
        if (!CollectionUtils.isEmpty(salQuotationDRespVO)){
            // 获得含税价格
            BigDecimal amt = salQuotationDRespVO.stream().map(SalQuotationDRespVO::getAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            // 获取销售底价
            // 1.获取采购价
            PurPriceBatchParamDTO purPriceParam = new PurPriceBatchParamDTO();
            purPriceParam.setOuId(salQuotationDetailRespVO.getOuId());
            purPriceParam.setValidDate(LocalDate.now());
            List<PurPriceDetailParamDTO> collect = salQuotationDRespVO.stream().map(vi -> {
                PurPriceDetailParamDTO detail = new PurPriceDetailParamDTO();
                detail.setItemId(vi.getItemId());
                detail.setUom(vi.getUom());
                detail.setCurrCode(salQuotationDetailRespVO.getCurrCode());
                return detail;
            }).collect(Collectors.toList());
            purPriceParam.setPurPriceDetailParamDtoList(collect);
            List<PurPriceBaseDTO> purPriRpcResult = rmiPurPriceService.getPriceListByParam(purPriceParam);
            log.info("查询采购价格结果{}", JSON.toJSONString(purPriRpcResult));
            // 2.获取毛利率
            List<Long> itemIds = salQuotationDRespVO.stream().map(SalQuotationDRespVO::getItemId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
            List<PriMainPriceRpcDTO> mainPriceDtoList = new ArrayList<>();
            if (!CollectionUtils.isEmpty(itemIds)){
                mainPriceDtoList = rmiPriMainPriceService.findMainPriceDtoList(itemIds, null);
            }
            log.info("查询B端毛利控制率结果{}", JSON.toJSONString(mainPriceDtoList));
            // 循环获取销售底价
            List<PriMainPriceRpcDTO> priMainPriceRpcDTOS = mainPriceDtoList;
            List<BigDecimal> grossPrices = new ArrayList<>();
            BigDecimal floorPrice = salQuotationDRespVO.stream().map(sal -> {
                BigDecimal purPrice = BigDecimal.ZERO;
                BigDecimal grossProfit = BigDecimal.ZERO;
                Optional<PurPriceBaseDTO> purPriceBaseDTO = purPriRpcResult.stream().filter(pur -> sal.getItemId().equals(pur.getItemId()) &&
                        sal.getUom().equals(pur.getToUom()))
                        .findFirst();
                if (purPriceBaseDTO.isPresent() && !ObjectUtils.isEmpty(purPriceBaseDTO.get()) && !ObjectUtils.isEmpty(purPriceBaseDTO.get().getPrice())) {
                    purPrice = purPriceBaseDTO.get().getPrice();
                }
                Optional<PriMainPriceRpcDTO> priMainPriceRpcDTO = priMainPriceRpcDTOS.stream().filter(itm -> itm.getItemId().equals(sal.getItemId()))
                        .findFirst();
                if (priMainPriceRpcDTO.isPresent()) {
                    grossProfit = priMainPriceRpcDTO.get().getPrice4();
                }
//                if (grossProfit)
                BigDecimal grossPrice = purPrice.divide(BigDecimal.ONE.subtract(grossProfit),4, RoundingMode.HALF_UP);
                grossPrices.add(grossPrice);
                return grossPrice.multiply(BigDecimal.valueOf(sal.getQty()));
            }).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            log.info("商品的销售底价打印{}",JSON.toJSONString(grossPrices));
            log.info("商品的销售底价总金额{}",floorPrice);
            if (amt.compareTo(floorPrice) == -1){
                return Boolean.TRUE;
            }else{
                return Boolean.FALSE;
            }
        }else{
            return Boolean.FALSE;
        }
    }

    private void checkFreeze(SalQuotationDetailRespVO saveVO) {
        log.info("报价单冻结检验入参：{}", JSON.toJSONString(saveVO));
        Assert.notNull(saveVO.getOuCode(),"冻结校验时公司编码为空！");

        ItmCheckLifeStatusRpcParam param = new ItmCheckLifeStatusRpcParam();
        param.setBusinessCode("S004");
        param.setItemLifeStatus("SALE_FREEZE");
        param.setStatusTime(LocalDateTime.now());
        List<ItmCheckBusinessStatusRpcParam> businessList = new ArrayList<>();

        for (SalQuotationDRespVO respVO : saveVO.getSalQuotationDRespVO()) {
            ItmCheckBusinessStatusRpcParam business = new ItmCheckBusinessStatusRpcParam();
            business.setBuCode(saveVO.getOuCode());
            business.setItemCode(respVO.getItemCode());
            businessList.add(business);
        }
        param.setBusinessList(businessList);

        log.info("支撑域报价单冻结检验入参："+JSON.toJSONString(param));

        itemRpcService.checkItemLifeStatusConfigByParam(param);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long createSalQuotation(SalQuotationDetailRespVO saveVO) {
        SalQuotationConvert salQuotationConvert = SalQuotationConvert.INSTANCE;
        /*
         * 第一步
         *   1.必填校验
         */
        if (StringUtils.isEmpty(saveVO.getId()) && StringUtils.isEmpty(saveVO.getDocNo())) {
            String salQuoDocNo = rmiSysNextNumberService.generateCode(Application.NAME,"QT", null);
            saveVO.setDocNo(salQuoDocNo);
        }

        checkForSave(saveVO);
        checkFreeze(saveVO);
        /*
         * 第二步
         *   2.数据保存
         */
        if (StringUtils.isEmpty(saveVO.getId())) {
            saveVO.setQuotationStatus(UdcEnum.SAL_QUOTATION_STATUS_DRAFT.getValueCode());
        }
        SalQuotationDO save = salQuotationRepo.save(salQuotationConvert.detailRespVOToDo(saveVO));
        // 权限字段设置
        save.setSecBuId(saveVO.getBuId());
        save.setSecOuId(saveVO.getOuId());
        save.setSecUserId(saveVO.getAgentEmpId());
        List<SalQuotationDRespVO> salQuotationDRespVo = saveVO.getSalQuotationDRespVO();
        if (!StringUtils.isEmpty(salQuotationDRespVo)) {
            salQuotationDRespVo.forEach(sal -> sal.setMasId(save.getId()));
            salQuotationDService.createSalQuotationD(salQuotationDRespVo, saveVO.getId());
        }
        return save.getId();
    }

    @Override
    @SysCodeProc
    public ApiResult<PagingVO<SalQuotationExportVO>> searchForExport(SalQuotationQueryParamVO paramVO) {
        // 联表查询主表和明细
        JPAQuery<SalQuotationExportVO> jpaQuery = this.selectForExport(paramVO);

        jpaQuery.orderBy(salQuotationDO.docNo.desc()).offset(Math.multiplyExact(paramVO.getCurrent(), paramVO.getSize())).limit(paramVO.getSize());

        long total = jpaQuery.fetchCount();

        List<SalQuotationExportVO> respVOList = jpaQuery.fetch();
        this.translateForExport(respVOList);
        return ApiResult.ok(PagingVO.<SalQuotationExportVO>builder()
                .total(total)
                .records(respVOList)
                .build());
    }

    @Override
    @SysCodeProc
    public SalQuotationDetailRespVO findSalQuotationById(Long id) {
        SalQuotationQueryParamVO salQuotationQueryParamVO = new SalQuotationQueryParamVO();
        salQuotationQueryParamVO.setId(id);
        List<SalQuotationDetailRespVO> salQuotationDetailRespVOS = this.selectDetail(salQuotationQueryParamVO).fetch();
        SalQuotationDetailRespVO salQuotationDetailRespVO;
        if (!CollectionUtils.isEmpty(salQuotationDetailRespVOS)) {
            salQuotationDetailRespVO = salQuotationDetailRespVOS.get(0);
            if (!StringUtils.isEmpty(salQuotationDetailRespVO.getAmt())) {
                salQuotationDetailRespVO.setAmt(salQuotationDetailRespVO.getAmt().setScale(2, BigDecimal.ROUND_DOWN));
            }
            if (!StringUtils.isEmpty(salQuotationDetailRespVO.getTaxAmt())) {
                salQuotationDetailRespVO.setTaxAmt(salQuotationDetailRespVO.getTaxAmt().setScale(2, BigDecimal.ROUND_DOWN));
            }
            if (!StringUtils.isEmpty(salQuotationDetailRespVO.getNetAmt())) {
                salQuotationDetailRespVO.setNetAmt(salQuotationDetailRespVO.getNetAmt().setScale(2, BigDecimal.ROUND_DOWN));
            }
            List<SalQuotationDRespVO> salQuotationD = salQuotationDService.findSalQuotationdByMasId(id);
            this.amountProcess(salQuotationD);
            salQuotationDetailRespVO.setSalQuotationDRespVO(salQuotationD);
        } else {
            throw new BusinessException("该销售报价单不存在,请检查");
        }
        this.translateDetail(salQuotationDetailRespVO);
        return salQuotationDetailRespVO;
    }

    private void translateDetail(SalQuotationDetailRespVO salQuotationDetailRespVO) {

        OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
        List<OrgEmpRpcDTO> empDtoByParam;
        if (!StringUtils.isEmpty(salQuotationDetailRespVO.getAgentEmpId())) {
            List<Long> agentEmpIds = new ArrayList<>();
            agentEmpIds.add(salQuotationDetailRespVO.getAgentEmpId());
            orgEmpRpcDtoParam.setEmpIds(agentEmpIds);
            empDtoByParam = rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);
            empDtoByParam.stream().findFirst().ifPresent(emp -> salQuotationDetailRespVO.setAgentEmpName(emp.getEmpName()));
        }
        OrgBuRpcDtoParam orgBuRpcDtoParam = new OrgBuRpcDtoParam();
        List<OrgBuRpcDTO> buDtoByParam;
        if (!StringUtils.isEmpty(salQuotationDetailRespVO.getBuId())) {
            List<Long> buIds = new ArrayList<>();
            buIds.add(salQuotationDetailRespVO.getBuId());
            orgBuRpcDtoParam.setBuIds(buIds);
            buDtoByParam = rmiOrgBuService.findBuDtoByParam(orgBuRpcDtoParam);
            buDtoByParam.stream().findFirst().ifPresent(bu -> salQuotationDetailRespVO.setBuName(bu.getBuName()));
        }
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        List<OrgOuRpcDTO> ouDtoListByParam;
        if (!StringUtils.isEmpty(salQuotationDetailRespVO.getOuId())) {
            List<Long> ouIds = new ArrayList<>();
            ouIds.add(salQuotationDetailRespVO.getOuId());
            orgOuRpcDtoParam.setOuIds(ouIds);
            ouDtoListByParam = rmiOrgOuService.findOuDtoListByParam(orgOuRpcDtoParam);
            ouDtoListByParam.stream().findFirst().ifPresent(ou -> {
                salQuotationDetailRespVO.setOuName(ou.getOuName());
                salQuotationDetailRespVO.setOuCode(ou.getOuCode());
            });
        }
        if (!StringUtils.isEmpty(salQuotationDetailRespVO.getCurrCode())) {
            Set<String> currCodes = new HashSet<>();
            currCodes.add(salQuotationDetailRespVO.getCurrCode());
            ApiResult<List<SysCurrencyRespDTO>> sysCurrencyRespDTOListApiResult;


            sysCurrencyRespDTOListApiResult = sysCurrencyRpcService.listByCodes(currCodes);

            sysCurrencyRespDTOListApiResult.getData().stream().filter(salQuo -> salQuotationDetailRespVO.getCurrCode().equals(salQuo.getCurrCode()))
                    .findFirst()
                    .ifPresent(sal -> salQuotationDetailRespVO.setCurrCodeName(sal.getCurrName()));
        }
        OrgEmpRpcDtoParam orgEmpRpcDtoParam1 = new OrgEmpRpcDtoParam();
        List<OrgEmpRpcDTO> empDtoByParam1;
        if (!StringUtils.isEmpty(salQuotationDetailRespVO.getApprUserId())){
            List<Long> agentEmpIds = new ArrayList<>();
            agentEmpIds.add(salQuotationDetailRespVO.getApprUserId());
            orgEmpRpcDtoParam1.setEmpIds(agentEmpIds);
            empDtoByParam1 = rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam1);
            empDtoByParam1.stream().findFirst().ifPresent(emp -> salQuotationDetailRespVO.setApprUserName(emp.getEmpName()));
        }

        // 省市区处理
        if (!ObjectUtils.isEmpty(salQuotationDetailRespVO.getContractCity())) {
            String[] cityCodes = salQuotationDetailRespVO.getContractCity().split("/");
            SysAreaQueryDTO sysAreaQueryDTO = new SysAreaQueryDTO();
            Set<String> cityCodeLists = new HashSet<>();
            for (int i = 0; i < cityCodes.length; i++) {
                cityCodeLists.add(cityCodes[i]);
            }
            sysAreaQueryDTO.setAreaCodes(cityCodeLists);
            List<SysAreaRespDTO> cityCodeListByParam = rmiCityCodeService.findCityCodeListByParam(sysAreaQueryDTO);
            StringBuilder cityNames = new StringBuilder();
            for (int k = 0; k < cityCodes.length; k++) {
                String finalK = cityCodes[k];
                cityCodeListByParam.stream().filter(city -> city.getAreaCode().equals(finalK))
                        .findFirst()
                        .ifPresent(c -> cityNames.append(c.getAreaName()));
                if (k != (cityCodes.length - 1)){
                    cityNames.append("/");
                }
            }
            salQuotationDetailRespVO.setContractCityName(cityNames.toString());
        }
    }

    private void amountProcess(List<SalQuotationDRespVO> salQuotationDRespVo) {
        salQuotationDRespVo.forEach(sal -> {
            if (!StringUtils.isEmpty(sal.getPrice())) {
                sal.setPrice(sal.getPrice().setScale(4, BigDecimal.ROUND_DOWN));
            }
            if (!StringUtils.isEmpty(sal.getAmt())) {
                sal.setAmt(sal.getAmt().setScale(2, BigDecimal.ROUND_DOWN));
            }
            if (!StringUtils.isEmpty(sal.getNetAmt())) {
                sal.setNetAmt(sal.getNetAmt().setScale(2, BigDecimal.ROUND_DOWN));
            }
            if (!StringUtils.isEmpty(sal.getNetPrice())) {
                sal.setNetPrice(sal.getNetPrice().setScale(4, BigDecimal.ROUND_DOWN));
            }
            if (!StringUtils.isEmpty(sal.getTaxAmt())) {
                sal.setTaxAmt(sal.getTaxAmt().setScale(2, BigDecimal.ROUND_DOWN));
            }
            if (!StringUtils.isEmpty(sal.getTaxRate())) {
                sal.setTaxRate(sal.getTaxRate().setScale(2, BigDecimal.ROUND_DOWN));
            }
            if (!StringUtils.isEmpty(sal.getDiscRatio())) {
                sal.setDiscRatio(sal.getDiscRatio().setScale(2, BigDecimal.ROUND_DOWN));
            }
            if (!StringUtils.isEmpty(sal.getDiscAmt())) {
                sal.setDiscAmt(sal.getDiscAmt().setScale(2, BigDecimal.ROUND_DOWN));
            }
            if (!StringUtils.isEmpty(sal.getPriceOrig())) {
                sal.setPriceOrig(sal.getPriceOrig().setScale(4, BigDecimal.ROUND_DOWN));
            }
        });
    }

    public JPAQuery<SalQuotationDetailRespVO> selectDetail(SalQuotationQueryParamVO searchParam) {

        val jpaQuery = jpaQueryFactory.select(Projections.bean(SalQuotationDetailRespVO.class,
                salQuotationDO.id,
                salQuotationDO.qtCustType,
                salQuotationDO.custCode,
                salQuotationDO.custName,
                salQuotationDO.ouId,
                salQuotationDO.buId,
                salQuotationDO.agentEmpId,
                salQuotationDO.quotationDate,
                salQuotationDO.quotationStatus,
                salQuotationDO.approvedTime,
                salQuotationDO.apprUserId,
                salQuotationDO.whId,
                salQuotationDO.netAmt,
                salQuotationDO.amt,
                salQuotationDO.payMethod,
                salQuotationDO.custContactName,
                salQuotationDO.custContactTel,
                salQuotationDO.demandTimespan,
                salQuotationDO.deliverMethod,
                salQuotationDO.recvAddrNo,
                salQuotationDO.recvDetailaddr,
                salQuotationDO.currCode,
                salQuotationDO.taxAmt,
                salQuotationDO.docNo,
                salQuotationDO.remark,
                salQuotationDO.saleRegion,
                salQuotationDO.contractCity,
                salQuotationDO.projId,
                salQuotationDO.projName,
                salQuotationDO.projNo,
                salQuotationDO.custId,
                salQuotationDO.procInstId
        )).from(salQuotationDO);
        if (searchParam != null) {
            jpaQuery.where(detailWhere(searchParam));
        }
        return jpaQuery;
    }

    /**
     * 条件查询
     *
     * @param param 查询条件
     */
    public Predicate detailWhere(SalQuotationQueryParamVO param) {

        Predicate predicate = salQuotationDO.isNotNull();
        predicate = ExpressionUtils.and(predicate, salQuotationDO.deleteFlag.ne(ConstantsSale.COMMON_DELETE_YSE));
        //报价单id
        if (!StringUtils.isEmpty(param.getId())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.id.eq(param.getId()));
        }
        //id集合
        if (!CollectionUtils.isEmpty(param.getIds())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.id.in(param.getIds()));
        }
        //客户类型
        if (!StringUtils.isEmpty(param.getQtCustType())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.qtCustType.eq(param.getQtCustType()));
        }
        //客户编码
        if (!StringUtils.isEmpty(param.getCustCode())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.custCode.like("%" + param.getCustCode() + "%"));
        }
        //客户名称
        if (!StringUtils.isEmpty(param.getCustName())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.custName.like("%" + param.getCustName() + "%"));
        }
        //公司id
        if (!StringUtils.isEmpty(param.getOuId())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.ouId.eq(param.getOuId()));
        }
        //经销商id
        if (!StringUtils.isEmpty(param.getBuId())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.buId.eq(param.getBuId()));
        }
        //业务员id
        if (!StringUtils.isEmpty(param.getAgentEmpId())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.agentEmpId.eq(param.getAgentEmpId()));
        }
        //报价日期
        if (!StringUtils.isEmpty(param.getBeginQuotationDate())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.quotationDate.eq(param.getBeginQuotationDate()).or(salQuotationDO.quotationDate.after(param.getBeginQuotationDate())));
        }
        if (!StringUtils.isEmpty(param.getEndQuotationDate())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.quotationDate.eq(param.getEndQuotationDate()).or(salQuotationDO.quotationDate.before(param.getEndQuotationDate())));
        }
        //报价单状态
        if (!StringUtils.isEmpty(param.getQuotationStatus())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.quotationStatus.eq(param.getQuotationStatus()));
        }
        //审批日期
        if (!StringUtils.isEmpty(param.getBeginApprTime())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.approvedTime.eq(param.getBeginApprTime()).or(salQuotationDO.approvedTime.after(param.getBeginApprTime())));
        }
        if (!StringUtils.isEmpty(param.getEndApprTime())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.approvedTime.eq(param.getEndApprTime()).or(salQuotationDO.approvedTime.before(param.getBeginApprTime())));
        }
        //审批人id
        if (!StringUtils.isEmpty(param.getApprUserId())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.apprUserId.eq(param.getApprUserId()));
        }
        //报价单单号
        if (!StringUtils.isEmpty(param.getDocNo())) {
            predicate = ExpressionUtils.and(predicate, salQuotationDO.docNo.eq(param.getDocNo()));
        }
        //区域
        if (!StringUtils.isEmpty(param.getSaleRegion())){
            predicate = ExpressionUtils.and(predicate, salQuotationDO.saleRegion.eq(param.getSaleRegion()));
        }
        return predicate;
    }

    private void translateForExport(List<SalQuotationExportVO> respVOList) {

        if (CollectionUtils.isEmpty(respVOList)) {
            return;
        }

        //手动翻译udc
        List<SysUdcDTO> sysUdcDTOList = udcProvider.listByUdcCode("yst-supp", Sets.newHashSet("UOM"));

        List<Long> agentEmpIds = respVOList.stream().map(SalQuotationExportVO::getAgentEmpId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
        List<OrgEmpRpcDTO> empDtoByParam = new ArrayList<>();
        if (!CollectionUtils.isEmpty(agentEmpIds)) {
            orgEmpRpcDtoParam.setEmpIds(agentEmpIds);
            empDtoByParam = rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);

        }
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        List<Long> ouIds = respVOList.stream().map(SalQuotationExportVO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<OrgOuRpcDTO> ouDtoListByParam = new ArrayList<>();
        if (!CollectionUtils.isEmpty(ouIds)) {
            orgOuRpcDtoParam.setOuIds(ouIds);
            ouDtoListByParam = rmiOrgOuService.findOuDtoListByParam(orgOuRpcDtoParam);
        }

        List<OrgOuRpcDTO> finalOuDtoListByParam = ouDtoListByParam;
        List<OrgEmpRpcDTO> finalEmpDtoByParam = empDtoByParam;
        respVOList.forEach(sal -> {
            finalOuDtoListByParam.stream().filter(ou -> sal.getOuId().equals(ou.getId()))
                    .findFirst()
                    .ifPresent(salOu -> sal.setOuName(salOu.getOuName()));
            finalEmpDtoByParam.stream().filter(emp -> sal.getAgentEmpId().equals(emp.getId()))
                    .findFirst()
                    .ifPresent(salEmp -> sal.setAgentEmpName(salEmp.getEmpName()));
            if (!StringUtils.isEmpty(sal.getUom())){
                sysUdcDTOList.stream().filter(uom -> sal.getUom().equals(uom.getUdcCode()))
                        .findFirst()
                        .ifPresent(uomUdc ->sal.setUomName(uomUdc.getUdcDescribe()));
            }
            if (!StringUtils.isEmpty(sal.getPrice())) {
                sal.setPrice(sal.getPrice().setScale(4, BigDecimal.ROUND_DOWN));
            }
            if (!StringUtils.isEmpty(sal.getTaxRate())) {
                BigDecimal decimal = sal.getTaxRate().setScale(2, BigDecimal.ROUND_DOWN);
                BigDecimal decimal1 = decimal.multiply(BigDecimal.valueOf(100));
                sal.setTaxRate2(decimal1 + "%");
            }
            if (!StringUtils.isEmpty(sal.getAmt())) {
                sal.setAmt(sal.getAmt().setScale(2, BigDecimal.ROUND_DOWN));
            }
            if (!StringUtils.isEmpty(sal.getQuotationDate())) {
                LocalDate localDate = sal.getQuotationDate().toLocalDate();
                sal.setQuotationDate2(localDate);
            }
        });
    }

    @SysCodeProc
    public JPAQuery<SalQuotationExportVO> selectForExport(SalQuotationQueryParamVO queryParam) {
        return jpaQueryFactory.select(Projections.bean(SalQuotationExportVO.class,
                salQuotationDO.ouId,
                salQuotationDO.agentEmpId,
                salQuotationDO.docNo,
                salQuotationDO.quotationDate,
                salQuotationDO.currCode,
                salQuotationDO.custCode,
                salQuotationDO.custName,
                salQuotationDO.custContactName,
                salQuotationDO.custContactTel,
                salQuotationDDO.itemCode,
                salQuotationDDO.itemName,
                salQuotationDDO.itemSpec,
                salQuotationDDO.qty,
                salQuotationDDO.uom,
                salQuotationDDO.price,
                salQuotationDDO.amt,
                salQuotationDDO.taxRate,
                salQuotationDDO.remark
        ))
                .from(salQuotationDO).leftJoin(salQuotationDDO).on(salQuotationDDO.masId.eq(salQuotationDO.id))
                .where(where(queryParam));
    }

    private void checkForSave(SalQuotationDetailRespVO saveVO) {
        Assert.notNull(saveVO, "保存信息为空");
        Assert.isFalse(StringUtils.isEmpty(saveVO.getQtCustType()), "保存数据客户类型为空");
        Assert.isFalse(StringUtils.isEmpty(saveVO.getCustCode()), "保存数据客户编码为空");
        Assert.isFalse(StringUtils.isEmpty(saveVO.getCustName()), "保存数据客户名称为空");
        Assert.isFalse(StringUtils.isEmpty(saveVO.getContractCity()), "保存数据省市区为空");
        Assert.isFalse(StringUtils.isEmpty(saveVO.getOuId()), "保存数据公司为空");
        Assert.isFalse(StringUtils.isEmpty(saveVO.getPayMethod()), "保存付款方式为空");
        Assert.isFalse(StringUtils.isEmpty(saveVO.getAgentEmpId()), "保存数据客户管理专员为空");
        Assert.isFalse(StringUtils.isEmpty(saveVO.getCustContactName()), "保存数据客户联系人为空");
        Assert.isFalse(StringUtils.isEmpty(saveVO.getCustContactTel()), "保存数据联系人电话为空");
        Assert.isFalse(StringUtils.isEmpty(saveVO.getDemandTimespan()), "保存数据要求发货日期为空");
        Assert.isFalse(StringUtils.isEmpty(saveVO.getDeliverMethod()), "保存数据货运方法为空");
    }
}