/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.controller.shop;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.shop.BipInvService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipInvCreateParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipInvQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipInvViewAndDownParam;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipInvVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bip/inv"})
@Api(value="\u53d1\u7968", tags={"\u5c0f\u7a0b\u5e8f-\u53d1\u7968"})
public class BipInvController {
    private final BipInvService bipInvService;

    @PostMapping(value={"/create"})
    @ApiOperation(value="(\u5c0f\u7a0b\u5e8f\u7aef)\u5f00\u7968\u5e76\u4fdd\u5b58\u4fe1\u606f\u5230\u6570\u636e\u5e93")
    @ApiOperationSupport(order=1)
    public ApiResult<List<String>> create(@RequestBody BipInvCreateParam param) {
        return this.bipInvService.createInv(param);
    }

    @PostMapping(value={"/FindAllByID"})
    @ApiOperation(value="(\u5c0f\u7a0b\u5e8f\u7aef)\u6839\u636euserID\u5206\u9875\u67e5\u8be2\u6240\u6709\u53d1\u7968")
    @ApiOperationSupport(order=2)
    public ApiResult<PagingVO<BipInvVO>> queryByUserId(@RequestBody BipInvQueryParam param) {
        return ApiResult.ok((Object)this.bipInvService.appFindAll(param));
    }

    @GetMapping(value={"/findByInvId/{invId}"})
    @ApiOperation(value="\u6839\u636eInvId\u67e5\u8be2\u53d1\u7968\u4fe1\u606f")
    @ApiOperationSupport(order=3)
    public ApiResult<BipInvVO> query(@PathVariable Long invId) {
        return ApiResult.ok((Object)this.bipInvService.findByInvId(invId));
    }

    @PostMapping(value={"/findAll"})
    @ApiOperation(value="(\u7ba1\u7406\u7aef)\u6839\u636e\u6761\u4ef6\u5206\u9875\u67e5\u8be2\u6240\u6709\u53d1\u7968")
    @ApiOperationSupport(order=4)
    public ApiResult<PagingVO<BipInvVO>> findAllByParam(@RequestBody BipInvQueryParam param) {
        return ApiResult.ok((Object)this.bipInvService.findAllByParam(param));
    }

    @GetMapping(value={"/findAll/{orderId}"})
    @ApiOperation(value="\u6839\u636e\u8ba2\u5355id\u67e5\u8be5\u8ba2\u5355\u4e0b\u7684\u53d1\u7968")
    @ApiOperationSupport(order=5)
    public ApiResult<List<BipInvVO>> findInvByOrderId(@PathVariable Long orderId) {
        return ApiResult.ok((Object)this.bipInvService.findInvByOrderId(orderId));
    }

    @GetMapping(value={"/creditInv/{orderId}"})
    @ApiOperation(value="\u7ea2\u51b2\u5e76\u5f00\u5177\u65b0\u7684\u53d1\u7968")
    @ApiOperationSupport(order=6)
    public ApiResult<Long> creditInv(@PathVariable Long orderId) {
        return ApiResult.ok((Object)this.bipInvService.creditInv(orderId));
    }

    @GetMapping(value={"/uReditInv/{orderId}"})
    @ApiOperation(value="\u7ea2\u51b2\u5e76\u66f4\u6539\u8ba2\u5355\u6807\u8bb0")
    @ApiOperationSupport(order=6)
    public ApiResult<Long> uReditInv(@PathVariable Long orderId) {
        return ApiResult.ok((Object)this.bipInvService.uReditInv(orderId));
    }

    @GetMapping(value={"/send/{to}/{invId}"})
    @ApiOperation(value="\u53d1\u9001\u90ae\u4ef6")
    @ApiOperationSupport(order=7)
    public ApiResult<Long> sendEmail(@PathVariable String to, @PathVariable Long invId) {
        return this.bipInvService.sendEmail(to, invId);
    }

    @PostMapping(value={"/viewAndDownload/invoice"})
    @ApiOperation(value="\u67e5\u770b\u5e76\u4e0b\u8f7d\u53d1\u7968")
    @ApiOperationSupport(order=8)
    public ApiResult<List<String>> viewAndDownload(@RequestBody BipInvViewAndDownParam bipInvViewAndDownParam) {
        return this.bipInvService.viewAndDownload(bipInvViewAndDownParam);
    }

    @PostMapping(value={"/findInvByInvSerialNum/{invSerialNum}"})
    @ApiOperation(value="\u6839\u636e\u53d1\u7968\u6d41\u6c34\u53f7\u67e5\u770b\u53d1\u7968")
    @ApiOperationSupport(order=9)
    public ApiResult<String> findInvByInvSerialNum(@PathVariable String invSerialNum) {
        return this.bipInvService.findInvByInvSerialNum(invSerialNum);
    }

    public BipInvController(BipInvService bipInvService) {
        this.bipInvService = bipInvService;
    }
}

