/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.controller.shop;

import cn.hutool.core.lang.Assert;
import com.el.coordinator.boot.fsm.service.FileService;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.shop.BipItemMngService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipItemApproveQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipItemOffShelfQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipItemOnShelfQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipItemQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipItemToShelfQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.ItemImageParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemApproveRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemOffShelfRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemOnShelfRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemQueryRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemSkuRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemToShelfRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemUomConvertRespVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemApproveSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemLimitBuySaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemShelfOffSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemShelfOnSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemStockSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemUpdateVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import net.lingala.zip4j.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@Api(tags={"\u5546\u54c1\u7ba1\u7406"})
@ApiSupport(author="Kaiser\uff08wang shao\uff09")
@RestController
@RequestMapping(value={"/bip/item"}, produces={"application/json"})
public class BipItemMngController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(BipItemMngController.class);
    private final BipItemMngService itemMngService;
    private final FileService fileService;

    @ApiOperation(value="\u5546\u54c1\u4fdd\u5b58")
    @ApiOperationSupport(order=1)
    @PostMapping(value={""})
    public ApiResult<Long> save(@RequestBody @Valid BipItemSaveVO saveVO) {
        return this.itemMngService.save(saveVO);
    }

    @ApiOperation(value="\u5546\u54c1\u4fee\u6539")
    @ApiOperationSupport(order=2)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5546\u54c1ID")})
    @PutMapping(value={"/{id}"})
    public ApiResult<Long> update(@PathVariable Long id, @RequestBody @Valid BipItemUpdateVO updateVO) {
        return this.itemMngService.update(id, updateVO);
    }

    @ApiOperation(value="\u5546\u54c1\u83b7\u53d6")
    @ApiOperationSupport(order=3)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5546\u54c1ID")})
    @GetMapping(value={"/{id}"})
    public ApiResult<BipItemDetailRespVO> get(@PathVariable Long id) {
        return this.itemMngService.get(id);
    }

    @ApiOperation(value="\u5546\u54c1\u5220\u9664")
    @ApiOperationSupport(order=4)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5546\u54c1ID")})
    @DeleteMapping(value={"/{id}"})
    public ApiResult<Long> delete(@PathVariable Long id) {
        return this.itemMngService.delete(id);
    }

    @ApiOperation(value="\u5546\u54c1\u6279\u91cf\u5220\u9664")
    @ApiOperationSupport(order=4)
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="\u5546\u54c1ID", allowMultiple=true, paramType="body", dataType="int")})
    @DeleteMapping(value={"/batch"})
    public ApiResult<List<Long>> deleteBatch(@RequestBody List<Long> ids) {
        return this.itemMngService.delete(ids);
    }

    @ApiOperation(value="\u6279\u91cf\u7acb\u5373\u4e0a\u67b6")
    @ApiOperationSupport(order=5)
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="\u5546\u54c1ID", allowMultiple=true, paramType="body", dataType="int")})
    @PostMapping(value={"/batch/onShelf"})
    public ApiResult<List<Long>> onShelf(@RequestBody @NotEmpty(message="\u5546\u54c1ID\u4e3a\u7a7a") @NotEmpty(message="\u5546\u54c1ID\u4e3a\u7a7a") List<Long> ids) {
        return this.itemMngService.updateShelf(ids, true);
    }

    @ApiOperation(value="\u6279\u91cf\u7acb\u5373\u4e0b\u67b6")
    @ApiOperationSupport(order=5)
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="\u5546\u54c1ID", allowMultiple=true, paramType="body", dataType="int")})
    @PostMapping(value={"/batch/offShelf"})
    public ApiResult<List<Long>> offShelf(@RequestBody @NotEmpty(message="\u5546\u54c1ID\u4e3a\u7a7a") @NotEmpty(message="\u5546\u54c1ID\u4e3a\u7a7a") List<Long> ids) {
        return this.itemMngService.updateShelf(ids, false);
    }

    @ApiOperation(value="\u5ba1\u6279\u5546\u54c1")
    @ApiOperationSupport(order=6)
    @PostMapping(value={"/approve"})
    public ApiResult<List<Long>> approve(@RequestBody @Valid BipItemApproveSaveVO approveSaveVO) {
        return this.itemMngService.updateApprove(approveSaveVO);
    }

    @ApiOperation(value="\u6279\u91cf\u5b9a\u65f6\u4e0a\u67b6")
    @ApiOperationSupport(order=7)
    @PostMapping(value={"/timing/onShelf"})
    public ApiResult<List<Long>> timingOnShelf(@RequestBody @Valid BipItemShelfOnSaveVO shelfSaveVO) {
        return this.itemMngService.updateOnShelfTiming(shelfSaveVO);
    }

    @ApiOperation(value="\u6279\u91cf\u5b9a\u65f6\u4e0b\u67b6")
    @ApiOperationSupport(order=7)
    @PostMapping(value={"/timing/offShelf"})
    public ApiResult<List<Long>> timingOffShelf(@RequestBody @Valid BipItemShelfOffSaveVO shelfSaveVO) {
        return this.itemMngService.updateOffShelfTiming(shelfSaveVO);
    }

    @ApiOperation(value="\u8c03\u6574\u6700\u5c0f\u8d77\u8ba2\u91cf")
    @ApiOperationSupport(order=8)
    @PostMapping(value={"/limitBuy"})
    public ApiResult<List<Long>> updateLimitBuy(@RequestBody @Valid BipItemLimitBuySaveVO limitBuySaveVO) {
        return this.itemMngService.updateLimitBuy(limitBuySaveVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u5546\u54c1\u7684SKU\u4fe1\u606f")
    @ApiOperationSupport(order=9)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5546\u54c1ID")})
    @GetMapping(value={"/{id}/sku"})
    public ApiResult<List<BipItemSkuRespVO>> getSku(@PathVariable Long id) {
        return this.itemMngService.getSku(id);
    }

    @ApiOperation(value="\u8c03\u6574\u5546\u54c1\u7684\u5e93\u5b58")
    @ApiOperationSupport(order=10)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5546\u54c1ID")})
    @PostMapping(value={"/{id}/stock"})
    public ApiResult<Long> updateSkuStock(@PathVariable Long id, @RequestBody @Valid List<BipItemStockSaveVO> stockSaveVOList) {
        return this.itemMngService.updateSkuStock(id, stockSaveVOList);
    }

    @ApiOperation(value="\u83b7\u53d6\u5546\u54c1\u8ba1\u91cf\u5355\u4f4d\u7684\u8f6c\u6362\u5173\u7cfb")
    @ApiOperationSupport(order=20)
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="\u5546\u54c1\u4e2d\u5fc3\u7684\u5546\u54c1ID", required=true, allowMultiple=true, paramType="query", dataType="int")})
    @GetMapping(value={"/uom/conversion"})
    public ApiResult<List<BipItemUomConvertRespVO>> uomConversion(@RequestParam(name="ids", required=false) List<Long> ids) {
        return this.itemMngService.queryItemUomConvert(ids);
    }

    @ApiOperation(value="\u5f85\u4e0a\u67b6\u5546\u54c1\u5217\u8868")
    @ApiOperationSupport(order=21)
    @PostMapping(value={"/search/toShelf"})
    public ApiResult<PagingVO<BipItemToShelfRespVO>> queryToShelf(@RequestBody BipItemToShelfQueryParamVO queryParamVO) {
        return this.itemMngService.queryForToShelf(queryParamVO);
    }

    @ApiOperation(value="\u5f85\u5ba1\u6279\u5546\u54c1\u5217\u8868")
    @ApiOperationSupport(order=22)
    @PostMapping(value={"/search/toApprove"})
    public ApiResult<PagingVO<BipItemApproveRespVO>> queryToApprove(@RequestBody BipItemApproveQueryParamVO queryParamVO) {
        return this.itemMngService.queryForApprove(queryParamVO);
    }

    @ApiOperation(value="\u5df2\u4e0a\u67b6\u5546\u54c1\u5217\u8868")
    @ApiOperationSupport(order=23)
    @PostMapping(value={"/search/onShelf"})
    public ApiResult<PagingVO<BipItemOnShelfRespVO>> queryOnShelf(@RequestBody BipItemOnShelfQueryParamVO queryParamVO) {
        return this.itemMngService.queryForOnShelf(queryParamVO);
    }

    @ApiOperation(value="\u5df2\u4e0b\u67b6\u5546\u54c1\u5217\u8868")
    @ApiOperationSupport(order=23)
    @PostMapping(value={"/search/offShelf"})
    public ApiResult<PagingVO<BipItemOffShelfRespVO>> queryOffShelf(@RequestBody BipItemOffShelfQueryParamVO queryParamVO) {
        return this.itemMngService.queryForOffShelf(queryParamVO);
    }

    @ApiOperation(value="\u67e5\u8be2\u5546\u54c1\uff08SKU\u7ea7\u522b\uff09")
    @ApiOperationSupport(order=31)
    @PostMapping(value={"/search/sku"})
    public ApiResult<PagingVO<BipItemQueryRespVO>> query(@RequestBody BipItemQueryParamVO queryParamVO) {
        return this.itemMngService.query(queryParamVO);
    }

    @ApiOperation(value="\u6839\u636e\u5546\u54c1\u5206\u7c7b\u67e5\u8be2\u5546\u54c1\uff08SKU\u7ea7\u522b\uff09")
    @ApiOperationSupport(order=32)
    @ApiImplicitParams(value={@ApiImplicitParam(name="categoryCode", value="\u5546\u54c1\u5206\u7c7b\u7f16\u7801", paramType="query"), @ApiImplicitParam(name="ouId", value="\u516c\u53f8ID", paramType="query"), @ApiImplicitParam(name="onShelf", value="\u662f\u5426\u5df2\u4e0a\u67b6", paramType="query")})
    @GetMapping(value={"/searchByCat/sku"})
    public ApiResult<List<BipItemQueryRespVO>> queryByCategory(String categoryCode, Long ouId, Boolean onShelf) {
        return this.itemMngService.queryByCategory(ouId, categoryCode, onShelf);
    }

    @PostMapping(value={"/uploadBatch"})
    @ApiOperationSupport(order=33)
    @ApiOperation(value="\u6279\u91cf\u4e0a\u4f20\u5546\u54c1\u56fe\u7247")
    public ApiResult<String> fileUpload(@RequestBody @Valid ItemImageParamVO imageParamVO) throws Exception {
        HttpEntity download = this.fileService.download(imageParamVO.getFileCode(), null);
        StreamingResponseBody body = (StreamingResponseBody)download.getBody();
        Assert.notNull((Object)body, (String)("\u65e0\u6cd5\u4e0b\u8f7d\u6587\u4ef6\u3010" + imageParamVO.getFileCode() + "\u3011\uff01"), (Object[])new Object[0]);
        File inFile = new File("/item-image-cache/" + imageParamVO.getFileCode());
        File outFile = new File("/item-image-cache/" + imageParamVO.getFileCode() + ".zip");
        if (!inFile.exists()) {
            inFile.mkdirs();
        }
        if (!outFile.exists()) {
            outFile.createNewFile();
        }
        try {
            body.writeTo((OutputStream)new FileOutputStream(outFile));
            ZipFile zFile = new ZipFile(outFile.getPath());
            zFile.setCharset(Charset.forName("GBK"));
            zFile.extractAll(inFile.getPath());
            this.itemMngService.handleImage(new File(inFile.getPath() + "/" + imageParamVO.getOuCode()), imageParamVO.getOuCode());
        }
        catch (Exception e) {
            log.error("\u5546\u54c1\u56fe\u7247\u5904\u7406\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new BusinessException(e.getMessage());
        }
        finally {
            outFile.delete();
            this.deleteAllFilesOfDir(inFile);
        }
        return ApiResult.ok();
    }

    private void deleteAllFilesOfDir(File path) {
        if (!path.exists()) {
            return;
        }
        if (path.isFile()) {
            path.delete();
            return;
        }
        File[] files = path.listFiles();
        for (int i = 0; i < files.length; ++i) {
            this.deleteAllFilesOfDir(files[i]);
        }
        path.delete();
    }

    public BipItemMngController(BipItemMngService itemMngService, FileService fileService) {
        this.itemMngService = itemMngService;
        this.fileService = fileService;
    }
}

