/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.provider.extend.SysCurrencyRpcService;
import com.elitesland.yst.production.sale.api.service.SalContractRecvService;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalContractRecvPagingParam;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalContractRecvPageRespVO;
import com.elitesland.yst.production.sale.api.vo.save.SalConRecvImportSaveVO;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.SalContractRecvConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.SalContractDO;
import com.elitesland.yst.production.sale.entity.SalContractRecvDO;
import com.elitesland.yst.production.sale.repo.CrmCustRepoProc;
import com.elitesland.yst.production.sale.repo.SalContractRecvRepo;
import com.elitesland.yst.production.sale.repo.SalContractRepo;
import com.elitesland.yst.production.sale.repo.SalContractRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiCommonService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class SalContractRecvServiceImpl
extends BaseServiceImpl
implements SalContractRecvService {
    private final RmiCommonService rmiCommonService;
    private final CrmCustRepoProc crmCustRepoProc;
    private final SalContractRepo salContractRepo;
    private final SalContractRecvRepo salContractRecvRepo;
    private final SalContractRepoProc salContractRepoProc;
    private final SysCurrencyRpcService sysCurrencyRpcService;

    @SysCodeProc
    public PagingVO<SalContractRecvPageRespVO> query(SalContractRecvPagingParam pageParam) {
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> conRecvImportData(List<SalConRecvImportSaveVO> parseData) {
        this.importDataHadle(parseData);
        List salContractRecvDOS = parseData.stream().map(SalContractRecvConvert.INSTANCE::importToDO).collect(Collectors.toList());
        this.salContractRecvRepo.saveAll(salContractRecvDOS);
        return ApiResult.ok();
    }

    private void importDataHadle(List<SalConRecvImportSaveVO> parseData) {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u5230\u83b7\u53d6\u5f53\u524d\u7528\u6237");
        }
        List<String> contractCodes = parseData.stream().map(SalConRecvImportSaveVO::getContractNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Set currNames = parseData.stream().map(SalConRecvImportSaveVO::getCurrCode).filter(Objects::nonNull).collect(Collectors.toSet());
        List<SalContractDO> allByContractNoIn = this.salContractRepo.findAllByContractNoIn(contractCodes);
        ApiResult sysCurrencyRespDTOListApiResult = this.sysCurrencyRpcService.listByCodes(currNames);
        Assert.notNull((Object)sysCurrencyRespDTOListApiResult, (String)"\u67e5\u8be2\u5e01\u79cd\u5931\u8d25", (Object[])new Object[0]);
        Assert.isTrue((boolean)sysCurrencyRespDTOListApiResult.isSuccess(), (String)"\u67e5\u8be2\u5e01\u79cd\u5931\u8d25", (Object[])new Object[0]);
        Map<String, List<SalConRecvImportSaveVO>> contractRecvListMap = parseData.stream().collect(Collectors.groupingBy(SalConRecvImportSaveVO::getContractNo));
        parseData.forEach(importVo -> {
            Assert.isFalse((boolean)StringUtils.isEmpty((Object)importVo.getContractNo()), (String)"excel\u4e2d\u5b58\u5728\u6570\u636e\u5408\u540c\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.isFalse((boolean)StringUtils.isEmpty((Object)importVo.getArDate()), (String)"excel\u4e2d\u5b58\u5728\u6570\u636e\u5e94\u6536\u65e5\u671f\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.isFalse((boolean)StringUtils.isEmpty((Object)importVo.getArAmt()), (String)"excel\u4e2d\u5b58\u5728\u6570\u636e\u5e94\u6536\u91d1\u989d\u4e3a\u7a7a", (Object[])new Object[0]);
            SalContractDO salContractDO = allByContractNoIn.stream().filter(con -> con.getContractNo().equals(importVo.getContractNo())).findFirst().orElseThrow(new BusinessException("\u5408\u540c\u53f7\u4e3a:" + importVo.getContractNo() + "\u7684\u5408\u540c\u5728\u6211\u65b9\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5"));
            importVo.setMasId(salContractDO.getId());
            importVo.setSecOuId(salContractDO.getSecOuId());
            importVo.setSecBuId(salContractDO.getSecBuId());
            importVo.setSecUserId(salContractDO.getSecUserId());
            if (ObjectUtils.isEmpty((Object)importVo.getInputer())) {
                importVo.setInputer(currentUser.getDetail().getUsername());
            }
            importVo.setInputDate(LocalDate.now());
            if (!ObjectUtils.isEmpty((Object)importVo.getCurrCode())) {
                String currCode = ((List)sysCurrencyRespDTOListApiResult.getData()).stream().filter(curr -> curr.getCurrName().equals(importVo.getCurrCode())).findFirst().orElseThrow(new BusinessException("\u5408\u540c\u53f7\u4e3a:" + importVo.getContractNo() + "\u7684\u5408\u540c\u6536\u6b3e\u8ba1\u5212\u6570\u636e\u5e01\u79cd\u4e0d\u5b58\u5728\u4e8e\u672c\u7cfb\u7edf\u4e2d\u8bf7\u68c0\u67e5")).getCurrCode();
                importVo.setCurrCode(currCode);
                if (!importVo.getCurrCode().equals(salContractDO.getCurrCode())) {
                    throw new BusinessException("\u5408\u540c\u53f7\u4e3a:" + importVo.getContractNo() + "\u7684\u5408\u540c\u6536\u6b3e\u8ba1\u5212\u6570\u636e\u5e01\u79cd\u4e0e\u6240\u5c5e\u5408\u540c\u7684\u5e01\u79cd\u4e0d\u4e00\u81f4\u8bf7\u68c0\u67e5");
                }
            } else {
                importVo.setCurrCode(salContractDO.getCurrCode());
            }
        });
        for (String key : contractRecvListMap.keySet()) {
            List<SalContractRecvDO> allByContractNo = this.salContractRecvRepo.findAllByContractNo(key);
            BigDecimal totalArAmt = BigDecimal.ZERO;
            if (!CollectionUtils.isEmpty(allByContractNo)) {
                totalArAmt = allByContractNo.stream().map(SalContractRecvDO::getArAmt).reduce(BigDecimal::add).get();
            }
            BigDecimal totalAmt = this.salContractRepoProc.getTotalAmt(key);
            List<SalConRecvImportSaveVO> salConRecvImportSaveVOS = contractRecvListMap.get(key);
            BigDecimal acTotalAmt = salConRecvImportSaveVOS.stream().map(SalConRecvImportSaveVO::getArAmt).reduce(BigDecimal::add).get();
            if (totalArAmt.add(acTotalAmt).compareTo(totalAmt) != 1) continue;
            throw new BusinessException("\u5408\u540c\u53f7\u4e3a:" + key + "\u7684\u5408\u540c\u6536\u6b3e\u8ba1\u5212\u6570\u636e,\u6536\u6b3e\u91d1\u989d\u603b\u548c\u5927\u4e8e\u5408\u540c\u7684\u603b\u91d1\u989d,\u8bf7\u68c0\u67e5");
        }
    }

    public SalContractRecvServiceImpl(RmiCommonService rmiCommonService, CrmCustRepoProc crmCustRepoProc, SalContractRepo salContractRepo, SalContractRecvRepo salContractRecvRepo, SalContractRepoProc salContractRepoProc, SysCurrencyRpcService sysCurrencyRpcService) {
        this.rmiCommonService = rmiCommonService;
        this.crmCustRepoProc = crmCustRepoProc;
        this.salContractRepo = salContractRepo;
        this.salContractRecvRepo = salContractRecvRepo;
        this.salContractRepoProc = salContractRepoProc;
        this.sysCurrencyRpcService = sysCurrencyRpcService;
    }
}

