/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.common.param.AreaVO;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.SysEmployeeDetailDTO;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeePageQueryDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeQueryDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeUpsertDTO;
import com.elitescloud.cloudt.system.dto.req.SysAreaQueryDTO;
import com.elitescloud.cloudt.system.dto.req.UserRoleSaveDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeePageRespDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeeUnderlingDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.param.SysOrgQueryDTO;
import com.elitescloud.cloudt.system.provider.SysUserPermissionRpcService;
import com.elitescloud.cloudt.system.provider.extend.SysAreaRpcService;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitescloud.cloudt.system.provider.org.OrgRpcService;
import com.elitesland.yst.production.sale.api.service.SalesmanInfoService;
import com.elitesland.yst.production.sale.api.vo.param.salesman.SalesmanInfoChangeVO;
import com.elitesland.yst.production.sale.api.vo.param.salesman.SalesmanInfoQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.salesman.SalesmanInfoSimpleQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.salesman.SalesmanRegionVO;
import com.elitesland.yst.production.sale.api.vo.param.salesman.SalesmanSubordinateQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.salesman.SalesmanSuperiorQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.salesman.SalesmanUnderLingQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustBaseRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.salesman.EmployeeDetailInfoRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.salesman.EmployeeInfoRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.salesman.SalesmanDetailInfoRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.salesman.SalesmanInfoAppDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.salesman.SalesmanInfoDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.salesman.SalesmanInfoRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.salesman.SalesmanInfoSimpleRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.salesman.SalesmanInfoStdVO;
import com.elitesland.yst.production.sale.api.vo.resp.salesman.SalesmanSuperiorRespVO;
import com.elitesland.yst.production.sale.api.vo.save.SalesmanImportSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.SalesmanInfoSaveVO;
import com.elitesland.yst.production.sale.common.constant.Constant;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.SalesmanInfoConvert;
import com.elitesland.yst.production.sale.dto.SalesmanInfoDTO;
import com.elitesland.yst.production.sale.dto.SalesmanLevelInfoDTO;
import com.elitesland.yst.production.sale.dto.query.SalesmanAPPQueryDTO;
import com.elitesland.yst.production.sale.dto.query.SalesmanInfoAPPRespDTO;
import com.elitesland.yst.production.sale.dto.query.SalesmanQueryDTO;
import com.elitesland.yst.production.sale.entity.SalesmanInfoDO;
import com.elitesland.yst.production.sale.entity.SalesmanRegionDO;
import com.elitesland.yst.production.sale.repo.CrmCustRepoProc;
import com.elitesland.yst.production.sale.repo.SalesmanInfoRepo;
import com.elitesland.yst.production.sale.repo.SalesmanInfoRepoProc;
import com.elitesland.yst.production.sale.repo.SalesmanRegionRepo;
import com.elitesland.yst.production.sale.search.bean.SalesmanInfoSearchBean;
import com.elitesland.yst.production.sale.search.service.SearchBeanService;
import com.elitesland.yst.production.sale.service.RmiSysUDCService;
import com.elitesland.yst.production.sale.service.SalesmanRpcServiceImpl;
import com.elitesland.yst.production.sale.util.ExcelEntityDataListener;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgOuRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.service.OrgOuRpcService;
import com.querydsl.jpa.impl.JPAQuery;
import java.io.InputStream;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SalesmanInfoServiceImpl
implements SalesmanInfoService {
    private static final Logger log = LogManager.getLogger(SalesmanInfoServiceImpl.class);
    @Autowired
    private SalesmanInfoRepo salesmanInfoRepo;
    @Autowired
    private SalesmanInfoRepoProc salesmanInfoRepoProc;
    @Autowired
    private RmiSysUDCService rmiSysUDCService;
    @Autowired
    private EmployeeRpcService employeeRpcService;
    @Autowired
    private OrgRpcService orgRpcService;
    @Autowired
    private Constant constant;
    @Autowired
    private SalesmanRegionRepo salesmanRegionRepo;
    @Autowired
    private OrgOuRpcService orgOuRpcService;
    @Autowired
    private SysAreaRpcService sysAreaRpcService;
    @Autowired
    private SysUserPermissionRpcService sysUserPermissionRpcService;
    @Autowired
    private SalesmanRpcServiceImpl salesmanRpcService;
    @Autowired
    private CrmCustRepoProc crmCustRepoProc;
    @Autowired
    private SearchBeanService searchBeanService;

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> save(SalesmanInfoSaveVO salesmanInfoSaveVO) {
        log.info("\u4e1a\u52a1\u5458\u4fe1\u606f\u4fdd\u5b58\u5165\u53c2 {}", (Object)salesmanInfoSaveVO.toString());
        if (salesmanInfoSaveVO.getSalesmanType().equals(UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getValueCode()) && CollUtil.isEmpty((Collection)salesmanInfoSaveVO.getJurisdictions())) {
            return ApiResult.fail((String)"\u9500\u552e\u603b\u76d1\u5fc5\u987b\u586b\u5199\u7ba1\u8f96\u533a\u57df\uff01");
        }
        if (salesmanInfoSaveVO.getSalesmanType().equals(UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getValueCode()) && salesmanInfoSaveVO.getLeaderUserId() != null) {
            return ApiResult.fail((String)"\u9500\u552e\u603b\u76d1\u4e0d\u5141\u8bb8\u6709\u4e0a\u7ea7");
        }
        SalesmanInfoDO bySalesmanNo = this.salesmanInfoRepo.findBySalesmanNo(salesmanInfoSaveVO.getSalesmanNo());
        if (Optional.ofNullable(bySalesmanNo).isPresent() && (salesmanInfoSaveVO.getId() == null || salesmanInfoSaveVO.getId() == 0L)) {
            return ApiResult.fail((String)"\u8be5\u7f16\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        SalesmanInfoDO byLoginAccount = this.salesmanInfoRepo.findByLoginAccount(salesmanInfoSaveVO.getLoginAccount());
        if (Optional.ofNullable(byLoginAccount).isPresent() && (salesmanInfoSaveVO.getId() == null || salesmanInfoSaveVO.getId() == 0L)) {
            throw new BusinessException("\u8be5\u767b\u5f55\u8d26\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        if (salesmanInfoSaveVO.getId() != null) {
            this.salesmanRegionRepo.deleteByMasId(salesmanInfoSaveVO.getId());
        }
        SalesmanInfoDO salesmanInfoDO = SalesmanInfoConvert.INSTANCE.salesmanInfoSaveToDO(salesmanInfoSaveVO);
        salesmanInfoDO.setEnableStatus(1);
        EmployeeUpsertDTO upsertDTO = SalesmanInfoConvert.INSTANCE.salesmanInfoSaveVOToUpsertDTO(salesmanInfoSaveVO);
        if (StringUtils.isNotBlank((CharSequence)salesmanInfoSaveVO.getBirthdayTime())) {
            upsertDTO.setBirthDate(this.constant.stringToLocalDate(salesmanInfoSaveVO.getBirthdayTime()));
        }
        if (StringUtils.isNotBlank((CharSequence)salesmanInfoSaveVO.getJoinTime())) {
            upsertDTO.setJoinTime(this.constant.swapTimeMin(salesmanInfoSaveVO.getJoinTime()));
        }
        this.buildEmployee(salesmanInfoSaveVO, salesmanInfoDO, upsertDTO);
        SalesmanInfoDO save = (SalesmanInfoDO)((Object)this.salesmanInfoRepo.save((Object)salesmanInfoDO));
        ArrayList<SalesmanRegionDO> salesmanRegionDOS = new ArrayList<SalesmanRegionDO>();
        if (CollUtil.isNotEmpty((Collection)salesmanInfoSaveVO.getJurisdictions())) {
            for (String jurisdiction : salesmanInfoSaveVO.getJurisdictions()) {
                SalesmanRegionDO salesmanRegionDO = new SalesmanRegionDO();
                salesmanRegionDO.setRegionCode(jurisdiction);
                salesmanRegionDO.setMasId(save.getId());
                salesmanRegionDOS.add(salesmanRegionDO);
            }
        }
        this.salesmanRegionRepo.saveAll(salesmanRegionDOS);
        return ApiResult.ok();
    }

    private void buildEmployee(SalesmanInfoSaveVO salesmanInfoSaveVO, SalesmanInfoDO salesmanInfoDO, EmployeeUpsertDTO employeeUpsertDTO) {
        AreaVO areaVO = new AreaVO();
        areaVO.setProvinceCode(salesmanInfoSaveVO.getProvince());
        areaVO.setCityCode(salesmanInfoSaveVO.getCity());
        areaVO.setCountyCode(salesmanInfoSaveVO.getArea());
        EmployeeUpsertDTO.EmployeeOrg employeeOrg = new EmployeeUpsertDTO.EmployeeOrg();
        employeeOrg.setOrgId(salesmanInfoSaveVO.getBuId());
        employeeOrg.setLeaderUserId(salesmanInfoSaveVO.getLeaderUserId());
        if (salesmanInfoSaveVO.getSex() != null) {
            employeeUpsertDTO.setGender(salesmanInfoSaveVO.getSex().equals(1) ? "MALE" : "FEMALE");
        }
        employeeUpsertDTO.setAreaVO(areaVO);
        employeeUpsertDTO.setPhone(salesmanInfoSaveVO.getPhone());
        employeeUpsertDTO.setType(UdcEnum.CUST_TYPE_SALESMAN.getValueCode());
        employeeUpsertDTO.setId(salesmanInfoSaveVO.getUserId());
        employeeUpsertDTO.setOrgList(List.of(employeeOrg));
        employeeUpsertDTO.setCode(salesmanInfoDO.getSalesmanNo());
        ApiResult result = this.employeeRpcService.upsert(employeeUpsertDTO);
        if (!result.isSuccess()) {
            throw new BusinessException(result.getMsg() + " \u4fdd\u5b58\u5458\u5de5\u5931\u8d25");
        }
        UserRoleSaveDTO userRoleSaveDTO = new UserRoleSaveDTO();
        userRoleSaveDTO.setUsername(salesmanInfoSaveVO.getLoginAccount());
        userRoleSaveDTO.setRoleCodes(Collections.singleton("salesman"));
        ApiResult userRoles = this.sysUserPermissionRpcService.saveUserRoles(Collections.singletonList(userRoleSaveDTO));
        if (userRoles.isFailed()) {
            throw new BusinessException(userRoles.getMsg() + " \u4fdd\u5b58\u4e1a\u52a1\u5458\u89d2\u8272\u5931\u8d25");
        }
    }

    public ApiResult<PagingVO<SalesmanInfoRespVO>> query(SalesmanInfoQueryVO salesmanInfoQueryVO) {
        log.info("\u4e1a\u52a1\u5458\u4fe1\u606f\u5206\u9875\u67e5\u8be2\u5165\u53c2 {}", (Object)salesmanInfoQueryVO);
        Map<String, String> salesmanTypeUDCMap = this.rmiSysUDCService.getCodeMap("yst-sale", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
        Map<String, String> regionUDCMap = this.rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.CRM_CUST_REGION_HN_NORTH.getCode());
        if (salesmanInfoQueryVO.getNoQueryParam() == 1) {
            List<EmployeePageRespDTO> employeePageRespDTOList = this.getWithoutLeaderEmployee();
            List<EmployeeInfoRespVO> employeeInfoRespVOS = SalesmanInfoConvert.INSTANCE.employeePageRespDTOToEmployeeInfoRespVO(employeePageRespDTOList);
            Map employeeInfoRespVOMap = employeeInfoRespVOS.stream().collect(Collectors.toMap(EmployeeInfoRespVO::getCode, Function.identity(), (k1, k2) -> k1));
            salesmanInfoQueryVO.setCodes(employeePageRespDTOList.stream().map(EmployeePageRespDTO::getCode).collect(Collectors.toList()));
            JPAQuery<SalesmanInfoRespVO> jpaQuery = this.salesmanInfoRepoProc.findSalesmanInfo(salesmanInfoQueryVO);
            List salesmanInfoRespVOList = jpaQuery.fetch();
            if (CollUtil.isEmpty((Collection)salesmanInfoRespVOList)) {
                ApiResult.ok((Object)PagingVO.builder().total(0L).records(Collections.emptyList()).build());
            }
            Map<Long, List<SalesmanRegionVO>> regionMap = this.getSalesmanRegionMap(regionUDCMap, salesmanInfoRespVOList.stream().map(SalesmanInfoRespVO::getId).collect(Collectors.toList()));
            for (SalesmanInfoRespVO salesmanInfoRespVO : salesmanInfoRespVOList) {
                salesmanInfoRespVO.setEmployeeInfoRespVO((EmployeeInfoRespVO)employeeInfoRespVOMap.get(salesmanInfoRespVO.getSalesmanNo()));
                salesmanInfoRespVO.setEnableStatusName(salesmanInfoRespVO.getEnableStatus() == 1 ? "\u542f\u7528" : "\u7981\u7528");
                salesmanInfoRespVO.setSalesmanTypeName(salesmanTypeUDCMap.get(salesmanInfoRespVO.getSalesmanType()));
                salesmanInfoRespVO.setJurisdiction(regionMap.get(salesmanInfoRespVO.getId()));
                if (!CollUtil.isNotEmpty((Collection)salesmanInfoRespVO.getJurisdiction())) continue;
                String jurisdictionName = salesmanInfoRespVO.getJurisdiction().stream().map(SalesmanRegionVO::getRegionName).filter(StringUtils::isNotEmpty).collect(Collectors.joining(","));
                salesmanInfoRespVO.setJurisdictionName(jurisdictionName);
            }
            List page = ListUtil.page((int)salesmanInfoQueryVO.getCurrent(), (int)salesmanInfoQueryVO.getSize(), (List)salesmanInfoRespVOList);
            return ApiResult.ok((Object)PagingVO.builder().total((long)salesmanInfoRespVOList.size()).records(page).build());
        }
        EmployeePageQueryDTO employeePageQueryDTO = new EmployeePageQueryDTO();
        employeePageQueryDTO.setType(UdcEnum.CUST_TYPE_SALESMAN.getValueCode());
        employeePageQueryDTO.setSize(Integer.valueOf(60000));
        ApiResult result = this.employeeRpcService.queryByPage(employeePageQueryDTO);
        if (!result.isSuccess()) {
            throw new BusinessException("\u5458\u5de5\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01" + result.getMsg());
        }
        List<Object> employeePageRespDTOList = ((PagingVO)result.getData()).getRecords();
        if (CollUtil.isEmpty((Collection)employeePageRespDTOList)) {
            return ApiResult.ok((Object)PagingVO.builder().total(0L).records(Collections.emptyList()).build());
        }
        if (StringUtils.isNotBlank((CharSequence)salesmanInfoQueryVO.getSalesman())) {
            employeePageRespDTOList = employeePageRespDTOList.stream().filter(s -> StringUtils.isNotBlank((CharSequence)s.getFullName()) && StringUtils.isNotBlank((CharSequence)s.getCode()) && (s.getFullName().contains(salesmanInfoQueryVO.getSalesman()) || s.getCode().contains(salesmanInfoQueryVO.getSalesman()))).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)salesmanInfoQueryVO.getOrgId())) {
            employeePageRespDTOList = employeePageRespDTOList.stream().filter(s -> {
                if (CollUtil.isNotEmpty((Collection)s.getOrgList())) {
                    for (IdCodeNameParam idCodeNameParam : s.getOrgList()) {
                        if (!Long.valueOf(salesmanInfoQueryVO.getOrgId()).equals(idCodeNameParam.getId())) continue;
                        return true;
                    }
                }
                return false;
            }).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)salesmanInfoQueryVO.getLoginAccount())) {
            employeePageRespDTOList = employeePageRespDTOList.stream().filter(s -> StringUtils.isNotBlank((CharSequence)s.getUsername()) && s.getUsername().contains(salesmanInfoQueryVO.getLoginAccount())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)salesmanInfoQueryVO.getPhone())) {
            employeePageRespDTOList = employeePageRespDTOList.stream().filter(s -> StringUtils.isNotBlank((CharSequence)s.getPhone()) && s.getPhone().contains(salesmanInfoQueryVO.getPhone())).collect(Collectors.toList());
        }
        if (CollUtil.isEmpty(employeePageRespDTOList)) {
            return ApiResult.ok((Object)PagingVO.builder().total(0L).records(Collections.emptyList()).build());
        }
        List<EmployeeInfoRespVO> employeeInfoRespVOS = SalesmanInfoConvert.INSTANCE.employeePageRespDTOToEmployeeInfoRespVO(employeePageRespDTOList);
        Map employeeInfoRespVOMap = employeeInfoRespVOS.stream().collect(Collectors.toMap(EmployeeInfoRespVO::getCode, Function.identity(), (k1, k2) -> k1));
        salesmanInfoQueryVO.setCodes(employeePageRespDTOList.stream().map(EmployeePageRespDTO::getCode).collect(Collectors.toList()));
        JPAQuery<SalesmanInfoRespVO> jpaQuery = this.salesmanInfoRepoProc.findSalesmanInfo(salesmanInfoQueryVO);
        List salesmanInfoRespVOList = jpaQuery.fetch();
        if (CollUtil.isEmpty((Collection)salesmanInfoRespVOList)) {
            return ApiResult.ok((Object)PagingVO.builder().total(0L).records(Collections.emptyList()).build());
        }
        if (StringUtils.isNotBlank((CharSequence)salesmanInfoQueryVO.getOuCode())) {
            salesmanInfoRespVOList = salesmanInfoRespVOList.stream().filter(s -> salesmanInfoQueryVO.getOuCode().equals(s.getOuCode())).collect(Collectors.toList());
        }
        if (salesmanInfoQueryVO.getEnableStatus() != null) {
            salesmanInfoRespVOList = salesmanInfoRespVOList.stream().filter(s -> salesmanInfoQueryVO.getEnableStatus().equals(s.getEnableStatus())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)salesmanInfoQueryVO.getSalesmanType())) {
            salesmanInfoRespVOList = salesmanInfoRespVOList.stream().filter(s -> salesmanInfoQueryVO.getSalesmanType().equals(s.getSalesmanType())).collect(Collectors.toList());
        }
        if (CollUtil.isEmpty(salesmanInfoRespVOList)) {
            return ApiResult.ok((Object)PagingVO.builder().total(0L).records(Collections.emptyList()).build());
        }
        Map<Long, List<SalesmanRegionVO>> regionMap = this.getSalesmanRegionMap(regionUDCMap, salesmanInfoRespVOList.stream().map(SalesmanInfoRespVO::getId).collect(Collectors.toList()));
        for (SalesmanInfoRespVO salesmanInfoRespVO : salesmanInfoRespVOList) {
            salesmanInfoRespVO.setEmployeeInfoRespVO((EmployeeInfoRespVO)employeeInfoRespVOMap.get(salesmanInfoRespVO.getSalesmanNo()));
            salesmanInfoRespVO.setEnableStatusName(salesmanInfoRespVO.getEnableStatus() == 1 ? "\u542f\u7528" : "\u7981\u7528");
            salesmanInfoRespVO.setSalesmanTypeName(salesmanTypeUDCMap.get(salesmanInfoRespVO.getSalesmanType()));
            salesmanInfoRespVO.setJurisdiction(regionMap.get(salesmanInfoRespVO.getId()));
            if (!CollUtil.isNotEmpty((Collection)salesmanInfoRespVO.getJurisdiction())) continue;
            String jurisdictionName = salesmanInfoRespVO.getJurisdiction().stream().map(SalesmanRegionVO::getRegionName).filter(StringUtils::isNotEmpty).collect(Collectors.joining(","));
            salesmanInfoRespVO.setJurisdictionName(jurisdictionName);
        }
        List page = ListUtil.page((int)salesmanInfoQueryVO.getCurrent(), (int)salesmanInfoQueryVO.getSize(), salesmanInfoRespVOList);
        return ApiResult.ok((Object)PagingVO.builder().total((long)salesmanInfoRespVOList.size()).records(page).build());
    }

    public ApiResult<PagingVO<SalesmanInfoRespVO>> queryUser(SalesmanInfoQueryVO salesmanInfoQueryVO) {
        ArrayList<SalesmanInfoRespVO> list = new ArrayList<SalesmanInfoRespVO>();
        SysOrgQueryDTO sysOrgQueryDTO = new SysOrgQueryDTO();
        sysOrgQueryDTO.setType("SALEORG");
        ApiResult listApiResult = this.orgRpcService.queryList(sysOrgQueryDTO);
        List buList = (List)listApiResult.getData();
        log.info("\u9500\u552e\u7ec4\u7ec7\u5217\u8868 : {}", (Object)JSON.toJSONString((Object)buList));
        for (SysOrgBasicDTO sysOrgBasicDTO : buList) {
            EmployeeQueryDTO employeeQueryDTO = new EmployeeQueryDTO();
            employeeQueryDTO.setOrgIdBelong(sysOrgBasicDTO.getId());
            ApiResult apiResult = this.employeeRpcService.queryList(employeeQueryDTO);
            List data = (List)apiResult.getData();
            log.info("\u67e5\u8be2\u5458\u5de5\u4fe1\u606f \u53c2\u6570 : {} \u6570\u636e : {}", (Object)JSON.toJSONString((Object)employeeQueryDTO), (Object)JSON.toJSONString((Object)apiResult.getData()));
            if (!CollUtil.isNotEmpty((Collection)data)) continue;
            for (SysEmployeeBasicDTO sysEmployeeBasicDTO : data) {
                EmployeeInfoRespVO employeeInfoRespVO = new EmployeeInfoRespVO();
                employeeInfoRespVO.setId(sysEmployeeBasicDTO.getId());
                employeeInfoRespVO.setCode(sysEmployeeBasicDTO.getCode());
                employeeInfoRespVO.setGender(sysEmployeeBasicDTO.getGender());
                employeeInfoRespVO.setPhone(sysEmployeeBasicDTO.getPhone());
                employeeInfoRespVO.setFullName(sysEmployeeBasicDTO.getFullName());
                employeeInfoRespVO.setEmail(sysEmployeeBasicDTO.getEmail());
                Long orgId = sysEmployeeBasicDTO.getOrgId();
                ApiResult serviceById = this.orgRpcService.getById(orgId);
                SysOrgBasicDTO data1 = (SysOrgBasicDTO)serviceById.getData();
                log.info("\u67e5\u8be2\u516c\u53f8 : {}", (Object)JSON.toJSONString((Object)data1));
                SalesmanInfoRespVO salesmanInfoRespVO = new SalesmanInfoRespVO();
                salesmanInfoRespVO.setEmployeeInfoRespVO(employeeInfoRespVO);
                salesmanInfoRespVO.setOuCode(data1.getCode());
                salesmanInfoRespVO.setOuName(data1.getName());
                list.add(salesmanInfoRespVO);
            }
        }
        List page = ListUtil.page((int)salesmanInfoQueryVO.getCurrent(), (int)salesmanInfoQueryVO.getSize(), list);
        return ApiResult.ok((Object)PagingVO.builder().total((long)list.size()).records(page).build());
    }

    @Nullable
    private List<EmployeePageRespDTO> getWithoutLeaderEmployee() {
        EmployeePageQueryDTO employeePageQueryDTO = new EmployeePageQueryDTO();
        employeePageQueryDTO.setSize(Integer.valueOf(60000));
        employeePageQueryDTO.setWithoutLeader(Boolean.valueOf(true));
        ApiResult result = this.employeeRpcService.queryByPage(employeePageQueryDTO);
        if (!result.isSuccess()) {
            throw new BusinessException("\u5458\u5de5\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01" + result.getMsg());
        }
        List employeePageRespDTOList = ((PagingVO)result.getData()).getRecords();
        if (CollUtil.isEmpty((Collection)employeePageRespDTOList)) {
            ApiResult.ok((Object)PagingVO.builder().total(0L).build());
        }
        return employeePageRespDTOList;
    }

    public List<SalesmanInfoSimpleRespVO> simpleQuery(SalesmanInfoSimpleQueryVO param) {
        log.info("\u4e1a\u52a1\u5458\u57fa\u672c\u4fe1\u606f\u67e5\u8be2\u5165\u53c2 {}", (Object)param);
        List<SalesmanInfoSimpleRespVO> simpleRespVOS = this.salesmanInfoRepoProc.simpleQuery(param);
        if (CollUtil.isEmpty(simpleRespVOS)) {
            return new ArrayList<SalesmanInfoSimpleRespVO>();
        }
        Set codes = simpleRespVOS.stream().map(SalesmanInfoSimpleRespVO::getSalesmanNo).collect(Collectors.toSet());
        ApiResult detailListByCode = this.employeeRpcService.getDetailListByCode(codes);
        if (!detailListByCode.isSuccess()) {
            return simpleRespVOS;
        }
        List employeeDetailDTOS = (List)detailListByCode.getData();
        Map<String, SysEmployeeDetailDTO> detailDTOMap = employeeDetailDTOS.stream().collect(Collectors.toMap(SysEmployeeDetailDTO::getCode, v -> v, (v1, v2) -> v1));
        for (SalesmanInfoSimpleRespVO simpleRespVO : simpleRespVOS) {
            SysEmployeeDetailDTO employeeDetailDTO = detailDTOMap.get(simpleRespVO.getSalesmanNo());
            if (!Optional.ofNullable(employeeDetailDTO).isPresent()) continue;
            simpleRespVO.setFullName(employeeDetailDTO.getFullName());
            simpleRespVO.setAreaVO(employeeDetailDTO.getAreaVO());
            simpleRespVO.setAddress(employeeDetailDTO.getAddress());
            simpleRespVO.setPhone(employeeDetailDTO.getPhone());
        }
        return simpleRespVOS;
    }

    public SalesmanInfoAppDetailRespVO appQueryDetail(String code) {
        log.info("\u4e1a\u52a1\u5458app\u4e2a\u4eba\u4fe1\u606f\u67e5\u8be2\u5165\u53c2 {}", (Object)code);
        SalesmanInfoAppDetailRespVO salesmanInfoAppDetailRespVO = new SalesmanInfoAppDetailRespVO();
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new BusinessException(ApiCode.FAIL, "\u4e1a\u52a1\u5458\u8d26\u53f7\u4e3a\u7a7a\uff01");
        }
        SalesmanInfoDO salesmanInfoDO = this.salesmanInfoRepo.findByLoginAccount(code);
        if (Optional.ofNullable(salesmanInfoDO).isEmpty()) {
            return salesmanInfoAppDetailRespVO;
        }
        Map<String, String> salesmanTypeUDCMap = this.rmiSysUDCService.getCodeMap("yst-sale", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
        salesmanInfoAppDetailRespVO.setId(salesmanInfoDO.getId());
        salesmanInfoAppDetailRespVO.setSalesmanNo(salesmanInfoDO.getSalesmanNo());
        salesmanInfoAppDetailRespVO.setFileCode(salesmanInfoDO.getFileCode());
        salesmanInfoAppDetailRespVO.setSalesmanType(salesmanInfoDO.getSalesmanType());
        salesmanInfoAppDetailRespVO.setSalesmanTypeName(salesmanTypeUDCMap.get(salesmanInfoDO.getSalesmanType()));
        salesmanInfoAppDetailRespVO.setEnableStatus(salesmanInfoDO.getEnableStatus());
        salesmanInfoAppDetailRespVO.setEnableStatusName(salesmanInfoDO.getEnableStatus() == 1 ? "\u542f\u7528" : "\u7981\u7528");
        ApiResult detailByCode = this.employeeRpcService.getDetailByCode(salesmanInfoDO.getSalesmanNo());
        if (!detailByCode.isSuccess()) {
            log.error("\u67e5\u8be2\u5458\u5de5\u8be6\u60c5\u4fe1\u606f\u5931\u8d25\uff01 {}", (Object)detailByCode.getMsg());
            return salesmanInfoAppDetailRespVO;
        }
        SysEmployeeDetailDTO employeeDetailDTO = (SysEmployeeDetailDTO)detailByCode.getData();
        salesmanInfoAppDetailRespVO.setUsername(employeeDetailDTO.getUsername());
        salesmanInfoAppDetailRespVO.setPhone(employeeDetailDTO.getPhone());
        salesmanInfoAppDetailRespVO.setFullName(employeeDetailDTO.getFullName());
        ArrayList<SalesmanInfoAppDetailRespVO.EmployeeOrg> employeeOrgs = new ArrayList<SalesmanInfoAppDetailRespVO.EmployeeOrg>();
        if (CollUtil.isNotEmpty((Collection)employeeDetailDTO.getOrgList())) {
            for (SysEmployeeDetailDTO.EmployeeOrg employeeOrg : employeeDetailDTO.getOrgList()) {
                SalesmanInfoAppDetailRespVO.EmployeeOrg org = new SalesmanInfoAppDetailRespVO.EmployeeOrg();
                org.setOrgId(employeeOrg.getOrgId());
                org.setOrgName(employeeOrg.getOrgName());
                employeeOrgs.add(org);
            }
        }
        salesmanInfoAppDetailRespVO.setOrgList(employeeOrgs);
        return salesmanInfoAppDetailRespVO;
    }

    public Map<Long, List<SalesmanRegionVO>> getSalesmanRegionMap(Map<String, String> regionUDCMap, List<Long> ids) {
        List<SalesmanRegionDO> regionDOS = this.salesmanRegionRepo.findByMasIdIn(ids);
        Map<Long, List<SalesmanRegionVO>> regionMap = new HashMap<Long, List<SalesmanRegionVO>>();
        if (CollUtil.isNotEmpty(regionDOS)) {
            List<SalesmanRegionVO> salesmanRegionVOS = SalesmanInfoConvert.INSTANCE.salesmanRegionDOToVo(regionDOS);
            for (SalesmanRegionVO regionVO : salesmanRegionVOS) {
                regionVO.setRegionName(regionUDCMap.get(regionVO.getRegionCode()));
            }
            regionMap = salesmanRegionVOS.stream().collect(Collectors.groupingBy(SalesmanRegionVO::getMasId));
        }
        return regionMap;
    }

    public ApiResult<SalesmanInfoDetailRespVO> queryDetail(Long id) {
        log.info("\u4e1a\u52a1\u5458\u8be6\u7ec6\u4fe1\u606f\u67e5\u8be2\u5165\u53c2 {}", (Object)id);
        Optional salesmanInfoDOOptional = this.salesmanInfoRepo.findById(id);
        if (salesmanInfoDOOptional.isEmpty()) {
            return ApiResult.ok();
        }
        Map<String, String> salesmanTypeUDCMap = this.rmiSysUDCService.getCodeMap("yst-sale", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
        Map<String, String> regionUDCMap = this.rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.CRM_CUST_REGION_HN_NORTH.getCode());
        SalesmanInfoDO salesmanInfoDO = (SalesmanInfoDO)((Object)salesmanInfoDOOptional.get());
        ApiResult detailByCode = this.employeeRpcService.getDetailByCode(salesmanInfoDO.getSalesmanNo());
        if (!detailByCode.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5458\u5de5\u8be6\u60c5\u4fe1\u606f\u5931\u8d25\uff01" + detailByCode.getMsg());
        }
        EmployeeDetailInfoRespVO employeeDetailInfoRespVO = SalesmanInfoConvert.INSTANCE.SysEmployeeDetailDTOToRespVO((SysEmployeeDetailDTO)detailByCode.getData());
        SalesmanInfoDetailRespVO salesmanInfoDetailRespVO = SalesmanInfoConvert.INSTANCE.salesmanInfoDOToDetailRespVO(salesmanInfoDO);
        Map<Long, List<SalesmanRegionVO>> salesmanRegionMap = this.getSalesmanRegionMap(regionUDCMap, List.of(salesmanInfoDO.getId()));
        salesmanInfoDetailRespVO.setEnableStatusName(salesmanInfoDetailRespVO.getEnableStatus() == 1 ? "\u542f\u7528" : "\u7981\u7528");
        salesmanInfoDetailRespVO.setSalesmanTypeName(salesmanTypeUDCMap.get(salesmanInfoDetailRespVO.getSalesmanType()));
        salesmanInfoDetailRespVO.setJurisdiction(salesmanRegionMap.get(salesmanInfoDO.getId()));
        salesmanInfoDetailRespVO.setEmployeeDetailInfoRespVO(employeeDetailInfoRespVO);
        return ApiResult.ok((Object)salesmanInfoDetailRespVO);
    }

    public SysEmployeeBasicDTO queryDetailByUserId(Long userId) {
        ApiResult empInfo = this.employeeRpcService.getByUserId(userId);
        if (empInfo.isSuccess()) {
            return (SysEmployeeBasicDTO)empInfo.getData();
        }
        return null;
    }

    public ApiResult<PagingVO<SalesmanInfoRespVO>> querySubordinate(SalesmanSubordinateQueryVO salesmanSubordinateQueryVO) {
        log.info("\u4e1a\u52a1\u5458\u4e0b\u7ea7\u4fe1\u606f\u67e5\u8be2\u5165\u53c2 {}", (Object)salesmanSubordinateQueryVO);
        ApiResult apiResult = this.employeeRpcService.getUnderlingByCode(salesmanSubordinateQueryVO.getCode(), Boolean.valueOf(true), null);
        if (!apiResult.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5458\u5de5\u4e0b\u7ea7\u4fe1\u606f\u5931\u8d25\uff01" + apiResult.getMsg());
        }
        List resultData = (List)apiResult.getData();
        ArrayList<String> codeList = new ArrayList<String>();
        if (CollUtil.isEmpty((Collection)resultData)) {
            return ApiResult.ok();
        }
        codeList.addAll(resultData.stream().map(EmployeeUnderlingDTO::getCode).collect(Collectors.toList()));
        List<EmployeeInfoRespVO> employeeInfoRespVOS = SalesmanInfoConvert.INSTANCE.employeeUnderlingDTOToRespVO(resultData);
        Map employeeInfoRespVOMap = employeeInfoRespVOS.stream().collect(Collectors.toMap(EmployeeInfoRespVO::getCode, Function.identity(), (k1, k2) -> k1));
        JPAQuery<SalesmanInfoRespVO> jpaQuery = this.salesmanInfoRepoProc.findByRelateCode(codeList, salesmanSubordinateQueryVO);
        List salesmanInfoRespVOS = jpaQuery.fetch();
        if (CollUtil.isEmpty((Collection)salesmanInfoRespVOS)) {
            return ApiResult.ok();
        }
        Map<String, String> salesmanTypeUDCMap = this.rmiSysUDCService.getCodeMap("yst-sale", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
        Map<String, String> regionUDCMap = this.rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.CRM_CUST_REGION_HN_NORTH.getCode());
        Map<Long, List<SalesmanRegionVO>> salesmanRegionMap = this.getSalesmanRegionMap(regionUDCMap, salesmanInfoRespVOS.stream().map(SalesmanInfoRespVO::getId).collect(Collectors.toList()));
        Iterator iterator = salesmanInfoRespVOS.iterator();
        while (iterator.hasNext()) {
            SalesmanInfoRespVO salesmanInfoRespVO;
            salesmanInfoRespVO.setEnableStatusName((salesmanInfoRespVO = (SalesmanInfoRespVO)iterator.next()).getEnableStatus() == 1 ? "\u542f\u7528" : "\u7981\u7528");
            salesmanInfoRespVO.setSalesmanTypeName(salesmanTypeUDCMap.get(salesmanInfoRespVO.getSalesmanType()));
            salesmanInfoRespVO.setJurisdiction(salesmanRegionMap.get(salesmanInfoRespVO.getId()));
            salesmanInfoRespVO.setEmployeeInfoRespVO((EmployeeInfoRespVO)employeeInfoRespVOMap.get(salesmanInfoRespVO.getSalesmanNo()));
            if (!CollUtil.isNotEmpty((Collection)salesmanInfoRespVO.getEmployeeInfoRespVO().getUnderlingList())) continue;
            salesmanInfoRespVO.setHasUnder(true);
        }
        return ApiResult.ok((Object)PagingVO.builder().total(jpaQuery.fetchCount()).records(salesmanInfoRespVOS).build());
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> changeStatus(SalesmanInfoChangeVO salesmanInfoChangeVO) {
        ApiResult result;
        log.info("\u4e1a\u52a1\u5458\u72b6\u6001\u4fe1\u606f\u66f4\u6539\u5165\u53c2 {}", (Object)salesmanInfoChangeVO);
        Optional salesmanInfoDO = this.salesmanInfoRepo.findById(salesmanInfoChangeVO.getId());
        if (salesmanInfoDO.isEmpty()) {
            return ApiResult.fail((String)"\u672a\u67e5\u8be2\u5230\u4fe1\u606f");
        }
        if (salesmanInfoChangeVO.isSync() && !(result = this.employeeRpcService.updateEnabledByCode(salesmanInfoChangeVO.getCode(), Boolean.valueOf(salesmanInfoChangeVO.getEnableStatus() == 1))).isSuccess()) {
            throw new BusinessException("\u66f4\u65b0\u5458\u5de5\u72b6\u6001\u5931\u8d25\uff01" + result.getMsg());
        }
        this.salesmanInfoRepoProc.changeEnableStatus(salesmanInfoChangeVO.getId(), salesmanInfoChangeVO.getEnableStatus());
        return ApiResult.ok();
    }

    public ApiResult<PagingVO<SalesmanSuperiorRespVO>> querySuperior(SalesmanSuperiorQueryVO salesmanSuperiorQueryVO) {
        log.info("\u67e5\u8be2\u4e1a\u52a1\u5458\u4e0a\u7ea7\u5165\u53c2 {}", (Object)JSON.toJSONString((Object)salesmanSuperiorQueryVO));
        PagingVO<SalesmanSuperiorRespVO> page = this.salesmanInfoRepoProc.getSalesmanSelectPage(salesmanSuperiorQueryVO);
        if (page.isNotEmpty() && CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            Map<String, String> salesmanTypeUDCMap = this.rmiSysUDCService.getCodeMap("yst-sale", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
            Set codes = page.getRecords().stream().map(SalesmanSuperiorRespVO::getSalesmanNo).collect(Collectors.toSet());
            EmployeeQueryDTO employeeQueryDTO = new EmployeeQueryDTO();
            employeeQueryDTO.setCodes(codes);
            ApiResult emp = this.employeeRpcService.queryList(employeeQueryDTO);
            Map<Object, Object> map = new HashMap();
            if (emp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)emp.getData()))) {
                map = ((List)emp.getData()).stream().collect(Collectors.toMap(SysEmployeeBasicDTO::getCode, SysEmployeeBasicDTO::getUserId, (t1, t2) -> t1));
            }
            HashMap finalMap = map;
            page.getRecords().forEach(p -> {
                p.setTypeName((String)salesmanTypeUDCMap.get(p.getType()));
                if (org.apache.commons.collections4.MapUtils.isNotEmpty((Map)finalMap) && StringUtils.isNotBlank((CharSequence)p.getSalesmanNo())) {
                    p.setUserId((Long)finalMap.get(p.getSalesmanNo()));
                }
            });
        }
        return ApiResult.ok(page);
    }

    public ApiResult<Object> salesmanImport(MultipartFile file) {
        ExcelEntityDataListener dataListener = new ExcelEntityDataListener();
        try {
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)file.getInputStream(), SalesmanImportSaveVO.class, dataListener).sheet(Integer.valueOf(0)).headRowNumber(Integer.valueOf(2))).doRead();
        }
        catch (Exception e) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5bfc\u5165\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165 excel\u7684\u5217\u503c\u662f\u5426\u4e0e\u6a21\u677f\u5bf9\u5e94");
        }
        List<SalesmanImportSaveVO> recommendRelateCustVOS = dataListener.getDatas();
        List<String> list = recommendRelateCustVOS.stream().map(SalesmanImportSaveVO::getSalesmanNo).collect(Collectors.toList());
        if (CollUtil.isEmpty(recommendRelateCustVOS)) {
            throw new BusinessException("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        StringBuffer failMsg = new StringBuffer();
        boolean failFlag = false;
        Map<String, String> salesmanTypeUDCMap = this.rmiSysUDCService.getCodeMap("yst-sale", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
        Map<String, String> newTypeMap = salesmanTypeUDCMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        Map<String, String> regionUDCMap = this.rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.CRM_CUST_REGION_HN_NORTH.getCode());
        Map<String, String> newRegionMap = regionUDCMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        Map<String, List<SalesmanInfoDO>> salesmanMap = this.getSalesMap(list);
        Map<String, List<SalesmanInfoDO>> loginMap = this.getLoginMap(recommendRelateCustVOS);
        Map<String, List<SysOrgBasicDTO>> buMap = this.getBuMap(recommendRelateCustVOS);
        Map<String, List<OrgOuRpcDTO>> ouMap = this.getOuMap(recommendRelateCustVOS);
        Map<String, Long> userCodeIdMap = this.getLeaderMap(recommendRelateCustVOS);
        ArrayList<String> areaNameList = new ArrayList();
        Map<Object, Object> areaMap = new HashMap();
        ApiResult areaList = this.sysAreaRpcService.queryList(new SysAreaQueryDTO());
        if (!areaList.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7701\u5e02\u533a\u4fe1\u606f\u5931\u8d25\uff01" + areaList.getMsg());
        }
        List areaListData = (List)areaList.getData();
        if (!CollUtil.isNotEmpty((Collection)areaListData)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u7701\u5e02\u533a\u4fe1\u606f\uff01");
        }
        areaNameList = areaListData.stream().map(SysAreaRespDTO::getAreaName).collect(Collectors.toList());
        areaMap = areaListData.stream().collect(Collectors.groupingBy(SysAreaRespDTO::getAreaName));
        failFlag = SalesmanInfoServiceImpl.checkData(failFlag, recommendRelateCustVOS, failMsg, salesmanMap, loginMap, buMap, userCodeIdMap, ouMap, newTypeMap, newRegionMap, areaNameList);
        if (failFlag) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, failMsg.toString());
        }
        if (failFlag = this.checkEmployee(recommendRelateCustVOS, failMsg, failFlag, buMap)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, failMsg.toString());
        }
        int line = 3;
        for (SalesmanImportSaveVO recommendRelateCustVO : recommendRelateCustVOS) {
            SalesmanInfoDO salesmanInfoDO = SalesmanInfoConvert.INSTANCE.salesmanImportSaveToDO(recommendRelateCustVO);
            salesmanInfoDO.setEnableStatus(1);
            salesmanInfoDO.setSalesmanType(newTypeMap.get(salesmanInfoDO.getSalesmanType()));
            salesmanInfoDO.setOuName(ouMap.get(salesmanInfoDO.getOuCode()).get(0).getOuName());
            List<Object> regions = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)salesmanInfoDO.getJurisdiction())) {
                String[] jurisdictions = salesmanInfoDO.getJurisdiction().split("[;\uff1b]");
                regions = List.of(jurisdictions);
            }
            EmployeeUpsertDTO upsertDTO = SalesmanInfoConvert.INSTANCE.salesmanImportSaveVOToUpsertDTO(recommendRelateCustVO);
            if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getSexName())) {
                upsertDTO.setGender(recommendRelateCustVO.getSexName().equals("\u7537") ? "MALE" : "FEMALE");
            }
            AreaVO areaVO = new AreaVO();
            if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getBirthdayTime())) {
                upsertDTO.setBirthDate(this.constant.stringToLocalDate(recommendRelateCustVO.getBirthdayTime()));
            }
            if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getJoinTime())) {
                upsertDTO.setJoinTime(this.constant.swapTimeMin(recommendRelateCustVO.getJoinTime()));
            }
            areaVO.setProvinceName(recommendRelateCustVO.getProvince());
            areaVO.setCityName(recommendRelateCustVO.getCity());
            areaVO.setCountyName(recommendRelateCustVO.getArea());
            if (CollUtil.isNotEmpty((Collection)((Collection)areaMap.get(recommendRelateCustVO.getProvince())))) {
                areaVO.setProvinceCode(((SysAreaRespDTO)((List)areaMap.get(recommendRelateCustVO.getProvince())).get(0)).getAreaCode());
            }
            if (CollUtil.isNotEmpty((Collection)((Collection)areaMap.get(recommendRelateCustVO.getCity())))) {
                areaVO.setCityCode(((SysAreaRespDTO)((List)areaMap.get(recommendRelateCustVO.getCity())).get(0)).getAreaCode());
            }
            if (CollUtil.isNotEmpty((Collection)((Collection)areaMap.get(recommendRelateCustVO.getArea())))) {
                areaVO.setCountyCode(((SysAreaRespDTO)((List)areaMap.get(recommendRelateCustVO.getArea())).get(0)).getAreaCode());
            }
            upsertDTO.setAreaVO(areaVO);
            EmployeeUpsertDTO.EmployeeOrg employeeOrg = new EmployeeUpsertDTO.EmployeeOrg();
            if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getLeaderUserCode())) {
                employeeOrg.setLeaderUserId(userCodeIdMap.get(recommendRelateCustVO.getLeaderUserCode()));
            }
            if (CollUtil.isNotEmpty((Collection)buMap.get(recommendRelateCustVO.getBuCode()))) {
                employeeOrg.setOrgId(buMap.get(recommendRelateCustVO.getBuCode()).get(0).getId());
            }
            upsertDTO.setOrgList(List.of(employeeOrg));
            upsertDTO.setCode(recommendRelateCustVO.getSalesmanNo());
            upsertDTO.setType(UdcEnum.CUST_TYPE_SALESMAN.getValueCode());
            ApiResult result = this.employeeRpcService.upsert(upsertDTO);
            if (!result.isSuccess()) {
                throw new BusinessException("\u7b2c" + line + "\u884c" + result.getMsg() + "  \u7b2c" + line + "\u884c\u53ca\u4e4b\u540e\u6570\u636e\u8c03\u7528\u521b\u5efa\u65b0\u5458\u5de5\u63a5\u53e3\u5931\u8d25\uff01 ");
            }
            UserRoleSaveDTO userRoleSaveDTO = new UserRoleSaveDTO();
            userRoleSaveDTO.setUsername(recommendRelateCustVO.getLoginAccount());
            userRoleSaveDTO.setRoleCodes(Collections.singleton("salesman"));
            ApiResult userRoles = this.sysUserPermissionRpcService.saveUserRoles(Collections.singletonList(userRoleSaveDTO));
            if (userRoles.isFailed()) {
                throw new BusinessException("\u7b2c" + line + "\u884c" + userRoles.getMsg() + " \u4fdd\u5b58\u4e1a\u52a1\u5458\u89d2\u8272\u5931\u8d25");
            }
            SalesmanInfoDO save = (SalesmanInfoDO)((Object)this.salesmanInfoRepo.save((Object)salesmanInfoDO));
            if (Optional.ofNullable(save).isEmpty()) {
                throw new BusinessException("  \u7b2c" + line + "\u884c\u53ca\u4e4b\u540e\u6570\u636e\u8c03\u7528\u4fdd\u5b58\u63a5\u53e3\u5931\u8d25\uff01");
            }
            ArrayList<SalesmanRegionDO> regionDOS = new ArrayList<SalesmanRegionDO>();
            if (CollUtil.isNotEmpty(regions)) {
                for (String string : regions) {
                    SalesmanRegionDO salesmanRegionDO = new SalesmanRegionDO();
                    salesmanRegionDO.setRegionCode(newRegionMap.get(string));
                    salesmanRegionDO.setMasId(save.getId());
                    regionDOS.add(salesmanRegionDO);
                }
                this.salesmanRegionRepo.saveAll(regionDOS);
            }
            ++line;
        }
        return ApiResult.ok();
    }

    private Map<String, List<SysOrgBasicDTO>> getBuMap(List<SalesmanImportSaveVO> recommendRelateCustVOS) {
        Set buCodesSet = recommendRelateCustVOS.stream().map(SalesmanImportSaveVO::getBuCode).collect(Collectors.toSet());
        SysOrgQueryDTO sysOrgQueryDTO = new SysOrgQueryDTO();
        sysOrgQueryDTO.setCodes(buCodesSet);
        ApiResult listApiResult = this.orgRpcService.queryList(sysOrgQueryDTO);
        if (!listApiResult.isSuccess()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01 " + listApiResult.getMsg());
        }
        List buList = (List)listApiResult.getData();
        Map<String, List<SysOrgBasicDTO>> buMap = new HashMap<String, List<SysOrgBasicDTO>>();
        if (CollUtil.isNotEmpty((Collection)buList)) {
            buMap = buList.stream().collect(Collectors.groupingBy(SysOrgBasicDTO::getCode));
        }
        return buMap;
    }

    private boolean checkEmployee(List<SalesmanImportSaveVO> recommendRelateCustVOS, StringBuffer failMsg, boolean failFlag, Map<String, List<SysOrgBasicDTO>> buMap) {
        ArrayList<EmployeeUpsertDTO> employeeUpsertDTOS = new ArrayList<EmployeeUpsertDTO>();
        for (SalesmanImportSaveVO recommendRelateCustVO : recommendRelateCustVOS) {
            EmployeeUpsertDTO upsertDTO = SalesmanInfoConvert.INSTANCE.salesmanImportSaveVOToUpsertDTO(recommendRelateCustVO);
            if (CollUtil.isNotEmpty((Collection)buMap.get(recommendRelateCustVO.getBuCode()))) {
                EmployeeUpsertDTO.EmployeeOrg employeeOrg = new EmployeeUpsertDTO.EmployeeOrg();
                employeeOrg.setOrgId(buMap.get(recommendRelateCustVO.getBuCode()).get(0).getId());
                upsertDTO.setOrgList(List.of(employeeOrg));
            }
            employeeUpsertDTOS.add(upsertDTO);
        }
        ApiResult apiResult = this.employeeRpcService.checkBatch(employeeUpsertDTOS);
        List data = (List)apiResult.getData();
        if (apiResult.isSuccess() && CollUtil.isNotEmpty((Collection)data)) {
            int n = 3;
            for (String datum : data) {
                if (StringUtils.isNotBlank((CharSequence)datum) && datum.contains("IllegalArgumentException")) {
                    failFlag = true;
                    failMsg.append("\u7b2c" + n + "\u884c\u6570\u636e" + datum + " ");
                }
                ++n;
            }
        }
        return failFlag;
    }

    private Map<String, List<SalesmanInfoDO>> getSalesMap(List<String> list) {
        List<SalesmanInfoDO> byMasSalesmanNoIn = this.salesmanInfoRepo.findBySalesmanNoIn(list);
        Map<String, List<SalesmanInfoDO>> salesmanMap = new HashMap<String, List<SalesmanInfoDO>>();
        if (CollUtil.isNotEmpty(byMasSalesmanNoIn)) {
            salesmanMap = byMasSalesmanNoIn.stream().collect(Collectors.groupingBy(SalesmanInfoDO::getSalesmanNo));
        }
        return salesmanMap;
    }

    private Map<String, List<SalesmanInfoDO>> getLoginMap(List<SalesmanImportSaveVO> recommendRelateCustVOS) {
        List<String> loginAccounts = recommendRelateCustVOS.stream().map(SalesmanImportSaveVO::getLoginAccount).collect(Collectors.toList());
        List<SalesmanInfoDO> salesmanInfoRepoByLoginAccountIn = this.salesmanInfoRepo.findByLoginAccountIn(loginAccounts);
        Map<String, List<SalesmanInfoDO>> loginMap = new HashMap<String, List<SalesmanInfoDO>>();
        if (CollUtil.isNotEmpty(salesmanInfoRepoByLoginAccountIn)) {
            loginMap = salesmanInfoRepoByLoginAccountIn.stream().collect(Collectors.groupingBy(SalesmanInfoDO::getLoginAccount));
        }
        return loginMap;
    }

    @NotNull
    private Map<String, Long> getLeaderMap(List<SalesmanImportSaveVO> recommendRelateCustVOS) {
        Set leaderCodes = recommendRelateCustVOS.stream().map(SalesmanImportSaveVO::getLeaderUserCode).filter(leaderUserCode -> leaderUserCode != null).collect(Collectors.toSet());
        Map<String, Long> userCodeIdMap = new HashMap<String, Long>();
        if (CollUtil.isNotEmpty(leaderCodes)) {
            EmployeePageQueryDTO employeePageQueryDTO = new EmployeePageQueryDTO();
            employeePageQueryDTO.setCodes(leaderCodes);
            ApiResult apiResult = this.employeeRpcService.queryByPage(employeePageQueryDTO);
            if (!apiResult.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u4e0a\u7ea7\u4fe1\u606f\u5931\u8d25\uff01" + apiResult.getMsg());
            }
            userCodeIdMap = ((PagingVO)apiResult.getData()).getRecords().stream().collect(Collectors.toMap(EmployeePageRespDTO::getCode, EmployeePageRespDTO::getUserId));
        }
        return userCodeIdMap;
    }

    private Map<String, List<OrgOuRpcDTO>> getOuMap(List<SalesmanImportSaveVO> recommendRelateCustVOS) {
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuCodes(recommendRelateCustVOS.stream().map(SalesmanImportSaveVO::getOuCode).distinct().collect(Collectors.toList()));
        List ouDtoByParam = this.orgOuRpcService.findOuDtoByParam(orgOuRpcDtoParam);
        Map<String, List<OrgOuRpcDTO>> ouMap = new HashMap<String, List<OrgOuRpcDTO>>();
        if (CollUtil.isNotEmpty((Collection)ouDtoByParam)) {
            ouMap = ouDtoByParam.stream().collect(Collectors.groupingBy(OrgOuRpcDTO::getOuCode));
        }
        return ouMap;
    }

    private static Boolean checkData(Boolean failFlag, List<SalesmanImportSaveVO> recommendRelateCustVOS, StringBuffer failMsg, Map<String, List<SalesmanInfoDO>> salesmanMap, Map<String, List<SalesmanInfoDO>> loginMap, Map<String, List<SysOrgBasicDTO>> buMap, Map<String, Long> userCodeIdMap, Map<String, List<OrgOuRpcDTO>> ouMap, Map<String, String> salesmanTypeUDCMap, Map<String, String> newRegionMap, List<String> areaNameList) {
        int i = 3;
        for (SalesmanImportSaveVO recommendRelateCustVO : recommendRelateCustVOS) {
            if (StringUtils.isBlank((CharSequence)recommendRelateCustVO.getSalesmanNo())) {
                failFlag = true;
                failMsg.append("\u7b2c").append(i).append("\u884c\u5bfc\u5165\u7684\u4e1a\u52a1\u5458\u7f16\u53f7\u4e3a\u7a7a ");
            }
            if (UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getValueCode().equals(salesmanTypeUDCMap.get(recommendRelateCustVO.getSalesmanType())) && StringUtils.isBlank((CharSequence)recommendRelateCustVO.getJurisdiction())) {
                failFlag = true;
                failMsg.append("\u7b2c" + i + "\u884c\u9500\u552e\u603b\u76d1\u7684\u7ba1\u8f96\u533a\u57df\u4e3a\u7a7a ");
            }
            if (UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getValueCode().equals(salesmanTypeUDCMap.get(recommendRelateCustVO.getSalesmanType())) && StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getLeaderUserCode())) {
                failFlag = true;
                failMsg.append("\u7b2c" + i + "\u884c\u9500\u552e\u603b\u76d1\u4e0d\u5141\u8bb8\u6709\u4e0a\u7ea7 ");
            }
            if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getJurisdiction())) {
                String[] split;
                for (String s : split = recommendRelateCustVO.getJurisdiction().split("[;\uff1b]")) {
                    if (!StringUtils.isBlank((CharSequence)newRegionMap.get(s))) continue;
                    failFlag = true;
                    failMsg.append("\u7b2c" + i + "\u884c\u533a\u57df\u4fe1\u606f\u9519\u8bef,\u533a\u57df" + s + "\u4e0d\u5b58\u5728 ");
                }
            }
            if (StringUtils.isBlank((CharSequence)recommendRelateCustVO.getName())) {
                failFlag = true;
                failMsg.append("\u7b2c" + i + "\u884c\u5bfc\u5165\u7684\u59d3\u540d\u4e3a\u7a7a ");
            }
            if (StringUtils.isBlank((CharSequence)recommendRelateCustVO.getPhone())) {
                failFlag = true;
                failMsg.append("\u7b2c" + i + "\u884c\u5bfc\u5165\u7684\u624b\u673a\u53f7\u4e3a\u7a7a ");
            }
            if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getProvince()) && !areaNameList.contains(recommendRelateCustVO.getProvince())) {
                failFlag = true;
                failMsg.append("\u7b2c" + i + "\u884c\u5bfc\u5165\u7684\u7701\u4fe1\u606f\u4e0d\u5b58\u5728 ");
            }
            if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getCity()) && !areaNameList.contains(recommendRelateCustVO.getCity())) {
                failFlag = true;
                failMsg.append("\u7b2c" + i + "\u884c\u5bfc\u5165\u7684\u5e02\u4fe1\u606f\u4e0d\u5b58\u5728 ");
            }
            if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getArea()) && !areaNameList.contains(recommendRelateCustVO.getArea())) {
                failFlag = true;
                failMsg.append("\u7b2c" + i + "\u884c\u5bfc\u5165\u7684\u533a\u4fe1\u606f\u4e0d\u5b58\u5728 ");
            }
            if (StringUtils.isBlank((CharSequence)recommendRelateCustVO.getOuCode())) {
                failFlag = true;
                failMsg.append("\u7b2c" + i + "\u884c\u5bfc\u5165\u7684\u516c\u53f8\u7f16\u53f7\u4e3a\u7a7a ");
            }
            if (StringUtils.isBlank((CharSequence)recommendRelateCustVO.getBuCode())) {
                failFlag = true;
                failMsg.append("\u7b2c" + i + "\u884c\u5bfc\u5165\u7684\u7ec4\u7ec7\u7f16\u53f7\u4e3a\u7a7a ");
            }
            if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getBuCode()) && CollUtil.isEmpty((Collection)buMap.get(recommendRelateCustVO.getBuCode()))) {
                failFlag = true;
                failMsg.append("\u7b2c" + i + "\u884c\u5bfc\u5165\u7684\u7ec4\u7ec7\u7f16\u53f7\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f ");
            }
            if (StringUtils.isBlank((CharSequence)recommendRelateCustVO.getLoginAccount())) {
                failFlag = true;
                failMsg.append("\u7b2c" + i + "\u884c\u5bfc\u5165\u7684\u767b\u5f55\u8d26\u53f7\u4e3a\u7a7a ");
            }
            if (StringUtils.isBlank((CharSequence)recommendRelateCustVO.getSalesmanType())) {
                failFlag = true;
                failMsg.append("\u7b2c" + i + "\u884c\u5bfc\u5165\u7684\u4e1a\u52a1\u5458\u7c7b\u578b\u4e3a\u7a7a ");
            }
            if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getSalesmanType()) && StringUtils.isBlank((CharSequence)salesmanTypeUDCMap.get(recommendRelateCustVO.getSalesmanType()))) {
                failFlag = true;
                failMsg.append("\u7b2c" + i + "\u884c\u5bfc\u5165\u7684\u4e1a\u52a1\u5458\u7c7b\u578b\u4e0d\u5b58\u5728 ");
            }
            if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getSalesmanNo()) && CollUtil.isNotEmpty((Collection)salesmanMap.get(recommendRelateCustVO.getSalesmanNo()))) {
                failFlag = true;
                failMsg.append("\u7b2c" + i + "\u884c\u5bfc\u5165\u7684\u4e1a\u52a1\u5458\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165 ");
            }
            if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getLoginAccount()) && CollUtil.isNotEmpty((Collection)loginMap.get(recommendRelateCustVO.getLoginAccount()))) {
                failFlag = true;
                failMsg.append("\u7b2c" + i + "\u884c\u5bfc\u5165\u7684\u767b\u5f55\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165 ");
            }
            if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getBuCode()) && StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getOuCode()) && CollUtil.isNotEmpty((Collection)buMap.get(recommendRelateCustVO.getBuCode())) && CollUtil.isNotEmpty((Collection)ouMap.get(recommendRelateCustVO.getOuCode())) && ouMap.get(recommendRelateCustVO.getOuCode()).get(0).getBuId() != null && buMap.get(recommendRelateCustVO.getBuCode()).get(0).getId() != null && !ouMap.get(recommendRelateCustVO.getOuCode()).get(0).getBuId().equals(buMap.get(recommendRelateCustVO.getBuCode()).get(0).getId()) && !recommendRelateCustVO.getOuCode().equals(buMap.get(recommendRelateCustVO.getBuCode()).get(0).getParentCode())) {
                failFlag = true;
                failMsg.append("\u7b2c" + i + "\u884c\u5bfc\u5165\u7684\u4fe1\u606f\u9519\u8bef\uff0c\u8be5\u516c\u53f8\u4e0e\u8be5\u7ec4\u7ec7\u6ca1\u6709\u7ed1\u5b9a\u5173\u7cfb\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165 ");
            }
            if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getOuCode()) && CollUtil.isEmpty((Collection)ouMap.get(recommendRelateCustVO.getOuCode()))) {
                failFlag = true;
                failMsg.append("\u7b2c" + i + "\u884c\u5bfc\u5165\u7684\u516c\u53f8\u7f16\u53f7\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u516c\u53f8\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165 ");
            }
            if (StringUtils.isNotBlank((CharSequence)recommendRelateCustVO.getLeaderUserCode()) && userCodeIdMap.get(recommendRelateCustVO.getLeaderUserCode()) == null) {
                failFlag = true;
                failMsg.append("\u7b2c" + i + "\u884c\u5bfc\u5165\u4e0a\u7ea7\u7f16\u53f7\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u4e0a\u7ea7\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165 ");
            }
            ++i;
        }
        return failFlag;
    }

    public ApiResult<PagingVO<SalesmanDetailInfoRespVO>> querySalesmanAllInfo(SalesmanInfoQueryVO salesmanInfoQueryVO) {
        log.info("\u4e1a\u52a1\u5458\u5168\u90e8\u4fe1\u606f\u67e5\u8be2\u5165\u53c2 {}", (Object)salesmanInfoQueryVO);
        Map<String, String> salesmanTypeUDCMap = this.rmiSysUDCService.getCodeMap("yst-sale", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
        Map<String, String> regionUDCMap = this.rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.CRM_CUST_REGION_HN_NORTH.getCode());
        ArrayList<SalesmanDetailInfoRespVO> salesmanDetailInfoRespVOS = new ArrayList<SalesmanDetailInfoRespVO>();
        if (salesmanInfoQueryVO.getEnableStatus() != null || StringUtils.isNotBlank((CharSequence)salesmanInfoQueryVO.getOuCode()) || StringUtils.isNotBlank((CharSequence)salesmanInfoQueryVO.getSalesmanType()) || salesmanInfoQueryVO.getNoQueryParam() == 1) {
            Set detailCodeSet;
            ApiResult apiResult;
            JPAQuery<SalesmanDetailInfoRespVO> jpaQuery = this.salesmanInfoRepoProc.findSalesmanInfoDetail(salesmanInfoQueryVO);
            List salesmanInfoRespVOList = jpaQuery.fetch();
            if (CollUtil.isEmpty((Collection)salesmanInfoRespVOList)) {
                return ApiResult.ok();
            }
            Map<String, String> regionMap = this.buildReion(regionUDCMap, salesmanInfoRespVOList);
            Map salesmanMap = salesmanInfoRespVOList.stream().collect(Collectors.toMap(SalesmanDetailInfoRespVO::getSalesmanNo, Function.identity(), (k1, k2) -> k1));
            Set codeList = salesmanInfoRespVOList.stream().map(SalesmanDetailInfoRespVO::getSalesmanNo).collect(Collectors.toSet());
            EmployeePageQueryDTO employeePageQueryDTO = SalesmanInfoConvert.INSTANCE.salesmanInfoQueryVOToQueryDTO(salesmanInfoQueryVO);
            employeePageQueryDTO.setKeyword(salesmanInfoQueryVO.getSalesman());
            employeePageQueryDTO.setCodes(codeList);
            ApiResult result = this.employeeRpcService.queryByPage(employeePageQueryDTO);
            if (!result.isSuccess()) {
                throw new BusinessException("\u5458\u5de5\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01" + result.getMsg());
            }
            List employeePageRespDTOList = new ArrayList();
            if (Optional.ofNullable((PagingVO)result.getData()).isPresent()) {
                employeePageRespDTOList = ((PagingVO)result.getData()).getRecords();
            }
            if (CollUtil.isEmpty(employeePageRespDTOList)) {
                ApiResult.ok((Object)PagingVO.builder().records(salesmanDetailInfoRespVOS));
            }
            if (!(apiResult = this.employeeRpcService.getDetailListByCode(detailCodeSet = employeePageRespDTOList.stream().map(EmployeePageRespDTO::getCode).collect(Collectors.toSet()))).isSuccess()) {
                throw new BusinessException("\u5458\u5de5\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01" + apiResult.getMsg());
            }
            List detailDTOS = (List)apiResult.getData();
            if (CollUtil.isEmpty((Collection)detailDTOS)) {
                return ApiResult.ok();
            }
            for (SysEmployeeDetailDTO detailDTO : detailDTOS) {
                SalesmanDetailInfoRespVO salesmanDetailInfoRespVO = new SalesmanDetailInfoRespVO();
                if (Optional.ofNullable((SalesmanDetailInfoRespVO)salesmanMap.get(detailDTO.getCode())).isPresent()) {
                    salesmanDetailInfoRespVO.setOuName(((SalesmanDetailInfoRespVO)salesmanMap.get(detailDTO.getCode())).getOuName());
                    salesmanDetailInfoRespVO.setId(((SalesmanDetailInfoRespVO)salesmanMap.get(detailDTO.getCode())).getId());
                    salesmanDetailInfoRespVO.setSalesmanNo(((SalesmanDetailInfoRespVO)salesmanMap.get(detailDTO.getCode())).getSalesmanNo());
                    salesmanDetailInfoRespVO.setSalesmanType(salesmanTypeUDCMap.get(((SalesmanDetailInfoRespVO)salesmanMap.get(detailDTO.getCode())).getSalesmanType()));
                    salesmanDetailInfoRespVO.setEnableStatusName(((SalesmanDetailInfoRespVO)salesmanMap.get(detailDTO.getCode())).getEnableStatus() == 1 ? "\u542f\u7528" : "\u7981\u7528");
                }
                salesmanDetailInfoRespVO.setJurisdiction(regionMap.get(detailDTO.getCode()));
                salesmanDetailInfoRespVO.setJoinTime(detailDTO.getJoinTime());
                salesmanDetailInfoRespVO.setUsername(detailDTO.getUsername());
                salesmanDetailInfoRespVO.setFullName(detailDTO.getFullName());
                salesmanDetailInfoRespVO.setGenderName(detailDTO.getGenderName());
                salesmanDetailInfoRespVO.setEmail(detailDTO.getEmail());
                salesmanDetailInfoRespVO.setPhone(detailDTO.getPhone());
                salesmanDetailInfoRespVO.setBirthDate(detailDTO.getBirthDate() == null ? null : detailDTO.getBirthDate().format(DateTimeFormatter.ISO_LOCAL_DATE));
                salesmanDetailInfoRespVO.setIdCard(detailDTO.getIdCard());
                salesmanDetailInfoRespVO.setProvinceName(detailDTO.getAreaVO().getProvinceName());
                salesmanDetailInfoRespVO.setCityName(detailDTO.getAreaVO().getCityName());
                salesmanDetailInfoRespVO.setCountyName(detailDTO.getAreaVO().getCountyName());
                salesmanDetailInfoRespVO.setAddress(detailDTO.getAddress());
                if (CollUtil.isNotEmpty((Collection)detailDTO.getOrgList())) {
                    salesmanDetailInfoRespVO.setOrgName(((SysEmployeeDetailDTO.EmployeeOrg)detailDTO.getOrgList().get(0)).getOrgName());
                    salesmanDetailInfoRespVO.setLeaderUserFullName(((SysEmployeeDetailDTO.EmployeeOrg)detailDTO.getOrgList().get(0)).getLeaderUserFullName());
                }
                salesmanDetailInfoRespVOS.add(salesmanDetailInfoRespVO);
            }
            return ApiResult.ok((Object)PagingVO.builder().records(salesmanDetailInfoRespVOS).build());
        }
        if (salesmanInfoQueryVO.getNoQueryParam() != 1) {
            EmployeePageQueryDTO employeePageQueryDTO = SalesmanInfoConvert.INSTANCE.salesmanInfoQueryVOToQueryDTO(salesmanInfoQueryVO);
            employeePageQueryDTO.setKeyword(salesmanInfoQueryVO.getSalesman());
            ApiResult result = this.employeeRpcService.queryByPage(employeePageQueryDTO);
            if (!result.isSuccess()) {
                throw new BusinessException("\u5458\u5de5\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01" + result.getMsg());
            }
            if (((PagingVO)result.getData()).getTotal() == 0L) {
                return ApiResult.ok();
            }
            List employeePageRespDTOS = ((PagingVO)result.getData()).getRecords();
            Set codeSet = employeePageRespDTOS.stream().map(EmployeePageRespDTO::getCode).collect(Collectors.toSet());
            ApiResult apiResult = this.employeeRpcService.getDetailListByCode(codeSet);
            if (!apiResult.isSuccess()) {
                throw new BusinessException("\u5458\u5de5\u8be6\u60c5\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01" + apiResult.getMsg());
            }
            List employeeDetailDTOS = (List)apiResult.getData();
            if (CollUtil.isEmpty((Collection)employeeDetailDTOS)) {
                return ApiResult.ok();
            }
            List<String> codes = employeeDetailDTOS.stream().map(SysEmployeeDetailDTO::getCode).collect(Collectors.toList());
            List<SalesmanInfoDO> salesmanInfoDOS = this.salesmanInfoRepo.findBySalesmanNoIn(codes);
            if (CollUtil.isEmpty(salesmanInfoDOS)) {
                return ApiResult.ok();
            }
            HashMap<String, String> regionMap = new HashMap<String, String>();
            Map<Long, List<SalesmanRegionVO>> idRegionMap = this.getSalesmanRegionMap(regionUDCMap, salesmanInfoDOS.stream().map(BaseModel::getId).collect(Collectors.toList()));
            for (SalesmanInfoDO salesmanInfoDO : salesmanInfoDOS) {
                StringBuffer stringBuffer = new StringBuffer();
                if (!CollUtil.isNotEmpty((Collection)idRegionMap.get(salesmanInfoDO.getId()))) continue;
                for (SalesmanRegionVO regionVO : idRegionMap.get(salesmanInfoDO.getId())) {
                    if (!StringUtils.isNotBlank((CharSequence)regionVO.getRegionName())) continue;
                    stringBuffer = stringBuffer.append(regionVO.getRegionName() + " ");
                }
                regionMap.put(salesmanInfoDO.getSalesmanNo(), stringBuffer.toString());
            }
            Map salesmanInfoDOMap = salesmanInfoDOS.stream().collect(Collectors.toMap(SalesmanInfoDO::getSalesmanNo, Function.identity(), (k1, k2) -> k1));
            for (SysEmployeeDetailDTO detailDTO : employeeDetailDTOS) {
                SalesmanDetailInfoRespVO salesmanDetailInfoRespVO = new SalesmanDetailInfoRespVO();
                if (Optional.ofNullable((SalesmanInfoDO)((Object)salesmanInfoDOMap.get(detailDTO.getCode()))).isPresent()) {
                    salesmanDetailInfoRespVO.setId(((SalesmanInfoDO)((Object)salesmanInfoDOMap.get(detailDTO.getCode()))).getId());
                    salesmanDetailInfoRespVO.setOuName(((SalesmanInfoDO)((Object)salesmanInfoDOMap.get(detailDTO.getCode()))).getOuName());
                    salesmanDetailInfoRespVO.setSalesmanNo(((SalesmanInfoDO)((Object)salesmanInfoDOMap.get(detailDTO.getCode()))).getSalesmanNo());
                    salesmanDetailInfoRespVO.setSalesmanType(salesmanTypeUDCMap.get(((SalesmanInfoDO)((Object)salesmanInfoDOMap.get(detailDTO.getCode()))).getSalesmanType()));
                    salesmanDetailInfoRespVO.setEnableStatusName(((SalesmanInfoDO)((Object)salesmanInfoDOMap.get(detailDTO.getCode()))).getEnableStatus() == 1 ? "\u542f\u7528" : "\u7981\u7528");
                }
                salesmanDetailInfoRespVO.setJurisdiction((String)regionMap.get(detailDTO.getCode()));
                salesmanDetailInfoRespVO.setJoinTime(detailDTO.getJoinTime());
                salesmanDetailInfoRespVO.setUsername(detailDTO.getUsername());
                salesmanDetailInfoRespVO.setFullName(detailDTO.getFullName());
                salesmanDetailInfoRespVO.setGenderName(detailDTO.getGenderName());
                salesmanDetailInfoRespVO.setEmail(detailDTO.getEmail());
                salesmanDetailInfoRespVO.setPhone(detailDTO.getPhone());
                salesmanDetailInfoRespVO.setBirthDate(detailDTO.getBirthDate() == null ? null : detailDTO.getBirthDate().format(DateTimeFormatter.ISO_LOCAL_DATE));
                salesmanDetailInfoRespVO.setIdCard(detailDTO.getIdCard());
                salesmanDetailInfoRespVO.setProvinceName(detailDTO.getAreaVO().getProvinceName());
                salesmanDetailInfoRespVO.setCityName(detailDTO.getAreaVO().getCityName());
                salesmanDetailInfoRespVO.setCountyName(detailDTO.getAreaVO().getCountyName());
                salesmanDetailInfoRespVO.setAddress(detailDTO.getAddress());
                if (CollUtil.isNotEmpty((Collection)detailDTO.getOrgList())) {
                    salesmanDetailInfoRespVO.setOrgName(((SysEmployeeDetailDTO.EmployeeOrg)detailDTO.getOrgList().get(0)).getOrgName());
                    salesmanDetailInfoRespVO.setLeaderUserFullName(((SysEmployeeDetailDTO.EmployeeOrg)detailDTO.getOrgList().get(0)).getLeaderUserFullName());
                }
                salesmanDetailInfoRespVOS.add(salesmanDetailInfoRespVO);
            }
            return ApiResult.ok((Object)PagingVO.builder().records(salesmanDetailInfoRespVOS).build());
        }
        return ApiResult.ok();
    }

    private Map<String, String> buildReion(Map<String, String> regionUDCMap, List<SalesmanDetailInfoRespVO> salesmanInfoRespVOList) {
        HashMap<String, String> regionMap = new HashMap<String, String>();
        Map<Long, List<SalesmanRegionVO>> idRegionMap = this.getSalesmanRegionMap(regionUDCMap, salesmanInfoRespVOList.stream().map(SalesmanDetailInfoRespVO::getId).collect(Collectors.toList()));
        for (SalesmanDetailInfoRespVO salesmanDetailInfoRespVO : salesmanInfoRespVOList) {
            StringBuffer stringBuffer = new StringBuffer();
            if (!CollUtil.isNotEmpty((Collection)idRegionMap.get(salesmanDetailInfoRespVO.getId()))) continue;
            for (SalesmanRegionVO regionVO : idRegionMap.get(salesmanDetailInfoRespVO.getId())) {
                if (!StringUtils.isNotBlank((CharSequence)regionVO.getRegionName())) continue;
                stringBuffer = stringBuffer.append(regionVO.getRegionName() + " ");
            }
            regionMap.put(salesmanDetailInfoRespVO.getSalesmanNo(), stringBuffer.toString());
        }
        return regionMap;
    }

    public SalesmanLevelInfoDTO queryLevelInfo(Long id) {
        if (id == null) {
            throw new BusinessException("id \u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
        }
        SalesmanLevelInfoDTO salesmanLevelInfoDTO = new SalesmanLevelInfoDTO();
        ArrayList<SalesmanLevelInfoDTO.path> paths = new ArrayList<SalesmanLevelInfoDTO.path>();
        StringBuffer codeBuffer = new StringBuffer();
        SalesmanInfoDO infoDO = (SalesmanInfoDO)((Object)this.salesmanInfoRepoProc.get(id));
        if (Optional.ofNullable(infoDO).isEmpty()) {
            throw new BusinessException(" \u672a\u83b7\u53d6\u5230\u4e1a\u52a1\u5458\u4fe1\u606f\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        SalesmanLevelInfoDTO.path path2 = new SalesmanLevelInfoDTO.path();
        salesmanLevelInfoDTO.setId(infoDO.getId());
        salesmanLevelInfoDTO.setSalesmanNo(infoDO.getSalesmanNo());
        ApiResult salesmanDetailInfo = this.employeeRpcService.getDetailByCode(infoDO.getSalesmanNo());
        SysEmployeeDetailDTO salesmanDetailInfoData = (SysEmployeeDetailDTO)salesmanDetailInfo.getData();
        if (!salesmanDetailInfo.isSuccess() || Optional.ofNullable(salesmanDetailInfoData).isEmpty()) {
            return salesmanLevelInfoDTO;
        }
        path2.setLevel(Integer.valueOf(0));
        path2.setCode(infoDO.getSalesmanNo());
        path2.setType(infoDO.getSalesmanType());
        path2.setName(salesmanDetailInfoData.getFullName());
        codeBuffer.append(infoDO.getSalesmanNo());
        paths.add(path2);
        salesmanLevelInfoDTO.setSalesmanPathCode(codeBuffer.toString());
        salesmanLevelInfoDTO.setSalesman_path(paths);
        salesmanLevelInfoDTO.setId(infoDO.getId());
        salesmanLevelInfoDTO.setSalesmanNo(salesmanDetailInfoData.getCode());
        salesmanLevelInfoDTO.setSalesmanName(salesmanDetailInfoData.getFullName());
        salesmanLevelInfoDTO.setSalesmanId(salesmanDetailInfoData.getId());
        String reCode = "";
        if (CollUtil.isNotEmpty((Collection)salesmanDetailInfoData.getOrgList()) && StringUtils.isNotBlank((CharSequence)((SysEmployeeDetailDTO.EmployeeOrg)salesmanDetailInfoData.getOrgList().get(0)).getLeaderEmployeeCode())) {
            reCode = ((SysEmployeeDetailDTO.EmployeeOrg)salesmanDetailInfoData.getOrgList().get(0)).getLeaderEmployeeCode();
            Long reCId = ((SysEmployeeDetailDTO.EmployeeOrg)salesmanDetailInfoData.getOrgList().get(0)).getLeaderEmployeeId();
            String leaderUserFullName = ((SysEmployeeDetailDTO.EmployeeOrg)salesmanDetailInfoData.getOrgList().get(0)).getLeaderUserFullName();
            salesmanLevelInfoDTO.setSalesmanPathCode(this.buildPath(reCode, 1, paths, codeBuffer, leaderUserFullName));
            salesmanLevelInfoDTO.setSalesman_path(paths);
            salesmanLevelInfoDTO.setRemanageId(reCId);
            salesmanLevelInfoDTO.setRemanageNo(reCode);
            salesmanLevelInfoDTO.setRemanagerName(leaderUserFullName);
        }
        if (StringUtils.isBlank((CharSequence)reCode)) {
            return salesmanLevelInfoDTO;
        }
        ApiResult remanagerDetailInfo = this.employeeRpcService.getDetailByCode(reCode);
        SysEmployeeDetailDTO remanagerDetailInfoData = (SysEmployeeDetailDTO)remanagerDetailInfo.getData();
        if (!remanagerDetailInfo.isSuccess() || Optional.ofNullable(remanagerDetailInfoData).isEmpty() || StringUtils.isBlank((CharSequence)((SysEmployeeDetailDTO.EmployeeOrg)remanagerDetailInfoData.getOrgList().get(0)).getLeaderEmployeeCode())) {
            return salesmanLevelInfoDTO;
        }
        String prCode = ((SysEmployeeDetailDTO.EmployeeOrg)remanagerDetailInfoData.getOrgList().get(0)).getLeaderEmployeeCode();
        Long prId = ((SysEmployeeDetailDTO.EmployeeOrg)remanagerDetailInfoData.getOrgList().get(0)).getLeaderEmployeeId();
        String leaderUserFullName = ((SysEmployeeDetailDTO.EmployeeOrg)remanagerDetailInfoData.getOrgList().get(0)).getLeaderUserFullName();
        salesmanLevelInfoDTO.setSalesmanPathCode(this.buildPath(prCode, 2, paths, codeBuffer, leaderUserFullName));
        salesmanLevelInfoDTO.setSalesman_path(paths);
        salesmanLevelInfoDTO.setPrmanagerNo(prCode);
        salesmanLevelInfoDTO.setPrmanagerId(prId);
        salesmanLevelInfoDTO.setPrmanagerName(leaderUserFullName);
        if (StringUtils.isBlank((CharSequence)prCode)) {
            return salesmanLevelInfoDTO;
        }
        ApiResult prmanagerDetailInfo = this.employeeRpcService.getDetailByCode(prCode);
        SysEmployeeDetailDTO prmanagerDetailInfoData = (SysEmployeeDetailDTO)prmanagerDetailInfo.getData();
        if (!prmanagerDetailInfo.isSuccess() || Optional.ofNullable(prmanagerDetailInfoData).isEmpty() || StringUtils.isBlank((CharSequence)((SysEmployeeDetailDTO.EmployeeOrg)prmanagerDetailInfoData.getOrgList().get(0)).getLeaderEmployeeCode())) {
            return salesmanLevelInfoDTO;
        }
        String chCode = ((SysEmployeeDetailDTO.EmployeeOrg)prmanagerDetailInfoData.getOrgList().get(0)).getLeaderEmployeeCode();
        Long chId = ((SysEmployeeDetailDTO.EmployeeOrg)prmanagerDetailInfoData.getOrgList().get(0)).getLeaderEmployeeId();
        String leaderUserFullNameEnd = ((SysEmployeeDetailDTO.EmployeeOrg)prmanagerDetailInfoData.getOrgList().get(0)).getLeaderUserFullName();
        salesmanLevelInfoDTO.setSalesmanPathCode(this.buildPath(chCode, 3, paths, codeBuffer, leaderUserFullNameEnd));
        salesmanLevelInfoDTO.setSalesman_path(paths);
        salesmanLevelInfoDTO.setChiefNo(chCode);
        salesmanLevelInfoDTO.setChiefId(chId);
        salesmanLevelInfoDTO.setChiefName(leaderUserFullNameEnd);
        salesmanLevelInfoDTO.setSalesman_path(paths);
        return salesmanLevelInfoDTO;
    }

    private String buildPath(String code, int level, List<SalesmanLevelInfoDTO.path> paths, StringBuffer code1, String leaderUserFullName) {
        SalesmanInfoDO infoDO3 = this.salesmanInfoRepo.findBySalesmanNo(code);
        if (Optional.ofNullable(infoDO3).isPresent()) {
            SalesmanLevelInfoDTO.path path1 = new SalesmanLevelInfoDTO.path();
            code1.append(",");
            code1.append(infoDO3.getSalesmanNo());
            path1.setLevel(Integer.valueOf(level));
            path1.setCode(infoDO3.getSalesmanNo());
            path1.setType(infoDO3.getSalesmanType());
            path1.setName(leaderUserFullName);
            paths.add(path1);
            return code1.toString();
        }
        return code1.toString();
    }

    public ApiResult<List<SalesmanInfoAPPRespDTO>> salesmanTeam(SalesmanAPPQueryDTO salesmanAPPQueryDTO) {
        log.info("\u4e1a\u52a1\u5458\u56e2\u961f\u4fe1\u606f\u67e5\u8be2\u5165\u53c2{}", (Object)JSON.toJSONString((Object)salesmanAPPQueryDTO));
        Map<String, String> salesmanTypeUDCMap = this.rmiSysUDCService.getCodeMap("yst-sale", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
        SalesmanInfoAPPRespDTO salesmanInfoAPPRespDTO = new SalesmanInfoAPPRespDTO();
        if (salesmanAPPQueryDTO.getOne() == 1 && StringUtils.isNotBlank((CharSequence)salesmanAPPQueryDTO.getSalesmanCode())) {
            EmployeePageQueryDTO employeePageQueryDTO = new EmployeePageQueryDTO();
            employeePageQueryDTO.setEnabled(Boolean.TRUE);
            employeePageQueryDTO.setCodes(Set.of(salesmanAPPQueryDTO.getSalesmanCode()));
            ApiResult apiResult = this.employeeRpcService.queryByPage(employeePageQueryDTO);
            if (!apiResult.isSuccess()) {
                return ApiResult.fail((String)"\u67e5\u8be2\u4fe1\u606f\u5931\u8d25\uff01");
            }
            List records = ((PagingVO)apiResult.getData()).getRecords();
            if (CollUtil.isEmpty((Collection)records)) {
                return ApiResult.ok();
            }
            EmployeePageRespDTO employeePageRespDTO = (EmployeePageRespDTO)records.get(0);
            SalesmanInfoDO salesmanInfoDO = this.salesmanInfoRepo.findBySalesmanNo(employeePageRespDTO.getCode());
            if (Optional.ofNullable(salesmanInfoDO).isPresent()) {
                salesmanInfoAPPRespDTO.setSalesmanType(salesmanInfoDO.getSalesmanType());
                salesmanInfoAPPRespDTO.setSalesmanTypeName(salesmanTypeUDCMap.get(salesmanInfoDO.getSalesmanType()));
            }
            salesmanInfoAPPRespDTO.setCode(employeePageRespDTO.getCode());
            salesmanInfoAPPRespDTO.setId(employeePageRespDTO.getId());
            salesmanInfoAPPRespDTO.setFullName(employeePageRespDTO.getFullName());
            salesmanInfoAPPRespDTO.setEnabled(employeePageRespDTO.getEnabled());
            salesmanInfoAPPRespDTO.setPhone(employeePageRespDTO.getPhone());
            salesmanInfoAPPRespDTO.setHasUnder(employeePageRespDTO.getHasUnderling());
            salesmanInfoAPPRespDTO.setUnderlingNum(employeePageRespDTO.getUnderlingNum());
            this.salesmanRpcService.assembleSalePerformance(Collections.singletonList(salesmanInfoAPPRespDTO), salesmanAPPQueryDTO.getDocMonth(), salesmanAPPQueryDTO.getDocTimeStart(), salesmanAPPQueryDTO.getDocTimeEnd());
            return ApiResult.ok(List.of(salesmanInfoAPPRespDTO));
        }
        if (salesmanAPPQueryDTO.getOne() == 0 && StringUtils.isNotBlank((CharSequence)salesmanAPPQueryDTO.getSalesmanCode())) {
            ArrayList<SalesmanInfoAPPRespDTO> salesmanInfoAPPRespDTOS = new ArrayList<SalesmanInfoAPPRespDTO>();
            ApiResult underlingByCode = this.employeeRpcService.getUnderlingByCode(salesmanAPPQueryDTO.getSalesmanCode(), salesmanAPPQueryDTO.getCascade(), Boolean.valueOf(true));
            if (!underlingByCode.isSuccess()) {
                return ApiResult.fail((String)"\u67e5\u8be2\u4fe1\u606f\u5931\u8d25\uff01");
            }
            List data = (List)underlingByCode.getData();
            if (CollUtil.isEmpty((Collection)data)) {
                return ApiResult.ok();
            }
            List<SalesmanInfoDO> salesmanInfoDOS = this.salesmanInfoRepo.findBySalesmanNoIn(data.stream().map(EmployeeUnderlingDTO::getCode).distinct().collect(Collectors.toList()));
            Map<Object, Object> infoDOMap = new HashMap();
            if (CollUtil.isNotEmpty(salesmanInfoDOS)) {
                infoDOMap = salesmanInfoDOS.stream().collect(Collectors.toMap(SalesmanInfoDO::getSalesmanNo, Function.identity()));
            }
            for (EmployeeUnderlingDTO datum : data) {
                SalesmanInfoAPPRespDTO salesmanInfo = new SalesmanInfoAPPRespDTO();
                salesmanInfo.setCode(datum.getCode());
                salesmanInfo.setId(datum.getId());
                salesmanInfo.setFullName(datum.getFullName());
                salesmanInfo.setEnabled(datum.getEnabled());
                salesmanInfo.setPhone(datum.getPhone());
                salesmanInfo.setHasUnder(datum.getHasUnderling());
                if (infoDOMap.containsKey(datum.getCode())) {
                    salesmanInfo.setSalesmanType(((SalesmanInfoDO)((Object)infoDOMap.get(datum.getCode()))).getSalesmanType());
                    salesmanInfo.setSalesmanTypeName(salesmanTypeUDCMap.get(((SalesmanInfoDO)((Object)infoDOMap.get(datum.getCode()))).getSalesmanType()));
                }
                List<SalesmanInfoAPPRespDTO> salesmanInfoAPPRespDTOList = this.salesmanRpcService.assembleUnderlingList(datum.getUnderlingList(), salesmanAPPQueryDTO.getDocMonth(), salesmanAPPQueryDTO.getDocTimeStart(), salesmanAPPQueryDTO.getDocTimeEnd());
                salesmanInfo.setUnderlingList(salesmanInfoAPPRespDTOList);
                salesmanInfoAPPRespDTOS.add(salesmanInfo);
            }
            this.salesmanRpcService.assembleSalePerformance(salesmanInfoAPPRespDTOS, salesmanAPPQueryDTO.getDocMonth(), salesmanAPPQueryDTO.getDocTimeStart(), salesmanAPPQueryDTO.getDocTimeEnd());
            return ApiResult.ok(salesmanInfoAPPRespDTOS);
        }
        return ApiResult.ok(List.of(salesmanInfoAPPRespDTO));
    }

    public PagingVO<SalesmanInfoAPPRespDTO> salesmanTeamAll(SalesmanAPPQueryDTO salesmanAPPQueryDTO) {
        log.info("\u4e1a\u52a1\u5458\u56e2\u961f\u4fe1\u606f\u67e5\u8be2\u5165\u53c2{}", (Object)JSON.toJSONString((Object)salesmanAPPQueryDTO));
        Map<String, String> salesmanTypeUDCMap = this.rmiSysUDCService.getCodeMap("yst-sale", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
        ArrayList<SalesmanInfoAPPRespDTO> infoAPPRespDTOS = new ArrayList<SalesmanInfoAPPRespDTO>();
        if (salesmanAPPQueryDTO.getOne() == 1) {
            ApiResult apiResult;
            List<EmployeePageRespDTO> employeePageRespDTOList = this.getWithoutLeaderEmployee();
            Map<Object, Object> salesmanInfoDOMap = new HashMap();
            EmployeePageQueryDTO employeePageQueryDTO = new EmployeePageQueryDTO();
            MapBuilder mapBuilder = this.setMapBuilder(salesmanAPPQueryDTO, employeePageRespDTOList);
            List beanSearchResult = this.searchBeanService.getBeanSearcher().searchAll(SalesmanInfoSearchBean.class, mapBuilder.build());
            if (CollUtil.isEmpty((Collection)beanSearchResult)) {
                throw new BusinessException("\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u5458\u4fe1\u606f");
            }
            List bySalesmanType = beanSearchResult.stream().map(SalesmanInfoConvert.INSTANCE::searchBeanToDO).collect(Collectors.toList());
            salesmanInfoDOMap = bySalesmanType.stream().collect(Collectors.toMap(SalesmanInfoDO::getSalesmanNo, Function.identity()));
            employeePageQueryDTO.setCodes(bySalesmanType.stream().map(SalesmanInfoDO::getSalesmanNo).collect(Collectors.toSet()));
            employeePageQueryDTO.setType(UdcEnum.CUST_TYPE_SALESMAN.getValueCode());
            employeePageQueryDTO.setEnabled(Boolean.TRUE);
            employeePageQueryDTO.setSize(salesmanAPPQueryDTO.getSize());
            employeePageQueryDTO.setOrders(salesmanAPPQueryDTO.getOrders());
            employeePageQueryDTO.setCurrent(Integer.valueOf(salesmanAPPQueryDTO.getCurrent() + 2));
            if (StringUtils.isNotBlank((CharSequence)salesmanAPPQueryDTO.getSalesmanCode())) {
                employeePageQueryDTO.setCodes(Set.of(salesmanAPPQueryDTO.getSalesmanCode()));
            } else {
                employeePageQueryDTO.setWithoutLeader(Boolean.valueOf(true));
            }
            if (StringUtils.isNotBlank((CharSequence)salesmanAPPQueryDTO.getKeyword())) {
                employeePageQueryDTO.setKeyword(salesmanAPPQueryDTO.getKeyword());
                employeePageQueryDTO.setCodes(Collections.emptySet());
                employeePageQueryDTO.setWithoutLeader(Boolean.valueOf(false));
            }
            if (!(apiResult = this.employeeRpcService.queryByPage(employeePageQueryDTO)).isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u4fe1\u606f\u5931\u8d25\uff01" + apiResult.getMsg());
            }
            List records = ((PagingVO)apiResult.getData()).getRecords();
            if (CollUtil.isEmpty((Collection)records)) {
                return PagingVO.builder();
            }
            for (EmployeePageRespDTO record : records) {
                SalesmanInfoAPPRespDTO salesmanInfoAPPRespDTO = new SalesmanInfoAPPRespDTO();
                salesmanInfoAPPRespDTO.setCode(record.getCode());
                salesmanInfoAPPRespDTO.setId(record.getId());
                salesmanInfoAPPRespDTO.setFullName(record.getFullName());
                salesmanInfoAPPRespDTO.setEnabled(record.getEnabled());
                salesmanInfoAPPRespDTO.setPhone(record.getPhone());
                salesmanInfoAPPRespDTO.setHasUnder(record.getHasUnderling());
                salesmanInfoAPPRespDTO.setUnderlingNum(record.getUnderlingNum());
                if (Optional.ofNullable((SalesmanInfoDO)((Object)salesmanInfoDOMap.get(record.getCode()))).isPresent()) {
                    salesmanInfoAPPRespDTO.setSalesmanType(((SalesmanInfoDO)((Object)salesmanInfoDOMap.get(record.getCode()))).getSalesmanType());
                }
                if (salesmanTypeUDCMap.get(record.getCode()) != null) {
                    salesmanInfoAPPRespDTO.setSalesmanTypeName(salesmanTypeUDCMap.get(((SalesmanInfoDO)((Object)salesmanInfoDOMap.get(record.getCode()))).getSalesmanType()));
                }
                infoAPPRespDTOS.add(salesmanInfoAPPRespDTO);
            }
            this.salesmanRpcService.assembleSalePerformance(infoAPPRespDTOS, salesmanAPPQueryDTO.getDocMonth(), salesmanAPPQueryDTO.getDocTimeStart(), salesmanAPPQueryDTO.getDocTimeEnd());
            return PagingVO.builder().total(((PagingVO)apiResult.getData()).getTotal()).records(infoAPPRespDTOS);
        }
        if (salesmanAPPQueryDTO.getOne() == 0 && StringUtils.isNotBlank((CharSequence)salesmanAPPQueryDTO.getSalesmanCode())) {
            ArrayList<SalesmanInfoAPPRespDTO> salesmanInfoAPPRespDTOS = infoAPPRespDTOS;
            ApiResult underlingByCode = this.employeeRpcService.getUnderlingByCode(salesmanAPPQueryDTO.getSalesmanCode(), salesmanAPPQueryDTO.getCascade(), Boolean.valueOf(true));
            if (!underlingByCode.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u5458\u5de5\u4fe1\u606f\u5931\u8d25\uff01" + underlingByCode.getMsg());
            }
            List data = (List)underlingByCode.getData();
            if (CollUtil.isEmpty((Collection)data)) {
                return PagingVO.builder();
            }
            List<SalesmanInfoDO> salesmanInfoDOS = this.salesmanInfoRepo.findBySalesmanNoIn(data.stream().map(EmployeeUnderlingDTO::getCode).distinct().collect(Collectors.toList()));
            Map<Object, Object> infoDOMap = new HashMap();
            if (CollUtil.isNotEmpty(salesmanInfoDOS)) {
                infoDOMap = salesmanInfoDOS.stream().collect(Collectors.toMap(SalesmanInfoDO::getSalesmanNo, Function.identity()));
            }
            for (EmployeeUnderlingDTO datum : data) {
                SalesmanInfoAPPRespDTO salesmanInfo = new SalesmanInfoAPPRespDTO();
                salesmanInfo.setCode(datum.getCode());
                salesmanInfo.setId(datum.getId());
                salesmanInfo.setFullName(datum.getFullName());
                salesmanInfo.setEnabled(datum.getEnabled());
                salesmanInfo.setPhone(datum.getPhone());
                salesmanInfo.setHasUnder(datum.getHasUnderling());
                if (infoDOMap.containsKey(datum.getCode())) {
                    salesmanInfo.setSalesmanType(((SalesmanInfoDO)((Object)infoDOMap.get(datum.getCode()))).getSalesmanType());
                    salesmanInfo.setSalesmanTypeName(salesmanTypeUDCMap.get(((SalesmanInfoDO)((Object)infoDOMap.get(datum.getCode()))).getSalesmanType()));
                }
                List<SalesmanInfoAPPRespDTO> salesmanInfoAPPRespDTOList = this.salesmanRpcService.assembleUnderlingList(datum.getUnderlingList(), salesmanAPPQueryDTO.getDocMonth(), salesmanAPPQueryDTO.getDocTimeStart(), salesmanAPPQueryDTO.getDocTimeEnd());
                salesmanInfo.setUnderlingList(salesmanInfoAPPRespDTOList);
                salesmanInfoAPPRespDTOS.add(salesmanInfo);
            }
            this.salesmanRpcService.assembleSalePerformance(salesmanInfoAPPRespDTOS, salesmanAPPQueryDTO.getDocMonth(), salesmanAPPQueryDTO.getDocTimeStart(), salesmanAPPQueryDTO.getDocTimeEnd());
            return PagingVO.builder().total((long)salesmanInfoAPPRespDTOS.size()).records(salesmanInfoAPPRespDTOS);
        }
        return PagingVO.builder();
    }

    public MapBuilder setMapBuilder(SalesmanAPPQueryDTO param, List<EmployeePageRespDTO> employeePageRespDTOList) {
        MapBuilder whereSqlMapBuilder = MapUtils.builder();
        List codes = employeePageRespDTOList.stream().map(EmployeePageRespDTO::getCode).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(codes)) {
            ((MapBuilder)whereSqlMapBuilder.field(SalesmanInfoSearchBean::getSalesmanNo, codes)).op((FieldOp)FieldOps.InList);
        }
        ((MapBuilder)whereSqlMapBuilder.field(SalesmanInfoSearchBean::getEnableStatus, new Object[]{1})).op((FieldOp)FieldOps.Equal);
        return whereSqlMapBuilder;
    }

    public ApiResult<SalesmanInfoDTO> querySalesmanInfo(SalesmanQueryDTO salesmanQueryDTO) {
        Map<String, String> salesmanTypeUDCMap = this.rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
        SalesmanInfoDTO salesmanInfoDTO = new SalesmanInfoDTO();
        if (salesmanQueryDTO.getSalesmanId() != null) {
            Optional salesmanInfoRepoById = this.salesmanInfoRepo.findById(salesmanQueryDTO.getSalesmanId());
            if (salesmanInfoRepoById.isEmpty()) {
                return ApiResult.fail((String)"\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u5458\u4fe1\u606f");
            }
            SalesmanInfoDO salesmanInfoDO = (SalesmanInfoDO)((Object)salesmanInfoRepoById.get());
            salesmanInfoDTO.setId(salesmanInfoDO.getId());
            salesmanInfoDTO.setSalesmanNo(salesmanInfoDO.getSalesmanNo());
            salesmanInfoDTO.setSalesmanType(salesmanInfoDO.getSalesmanType());
            salesmanInfoDTO.setSalesmanTypeName(salesmanTypeUDCMap.get(salesmanInfoDO.getSalesmanType()));
            salesmanInfoDTO.setOuName(salesmanInfoDO.getOuName());
            salesmanInfoDTO.setOuCode(salesmanInfoDO.getOuCode());
            salesmanInfoDTO.setFileCode(salesmanInfoDO.getFileCode());
            ApiResult detailListByCode = this.employeeRpcService.getDetailListByCode(Set.of(salesmanInfoDO.getSalesmanNo()));
            if (!detailListByCode.isSuccess()) {
                return ApiResult.fail((String)"\u67e5\u8be2\u5458\u5de5\u4fe1\u606f\u5931\u8d25");
            }
            List detailDTOS = (List)detailListByCode.getData();
            if (CollUtil.isEmpty((Collection)detailDTOS)) {
                return ApiResult.ok((Object)salesmanInfoDTO);
            }
            salesmanInfoDTO.setFullName(((SysEmployeeDetailDTO)detailDTOS.get(0)).getFullName());
            salesmanInfoDTO.setPhone(((SysEmployeeDetailDTO)detailDTOS.get(0)).getPhone());
            salesmanInfoDTO.setOrgId(((SysEmployeeDetailDTO.EmployeeOrg)((SysEmployeeDetailDTO)detailDTOS.get(0)).getOrgList().get(0)).getOrgId());
            salesmanInfoDTO.setOrgName(((SysEmployeeDetailDTO.EmployeeOrg)((SysEmployeeDetailDTO)detailDTOS.get(0)).getOrgList().get(0)).getOrgName());
            return ApiResult.ok((Object)salesmanInfoDTO);
        }
        if (salesmanQueryDTO.getSalesmanCode() != null) {
            SalesmanInfoDO salesmanInfoRepoById = this.salesmanInfoRepo.findBySalesmanNo(salesmanQueryDTO.getSalesmanCode());
            if (Optional.ofNullable(salesmanInfoRepoById).isEmpty()) {
                return ApiResult.fail((String)"\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u5458\u4fe1\u606f");
            }
            salesmanInfoDTO.setId(salesmanInfoRepoById.getId());
            salesmanInfoDTO.setSalesmanNo(salesmanInfoRepoById.getSalesmanNo());
            salesmanInfoDTO.setSalesmanType(salesmanInfoRepoById.getSalesmanType());
            salesmanInfoDTO.setSalesmanTypeName(salesmanTypeUDCMap.get(salesmanInfoRepoById.getSalesmanType()));
            salesmanInfoDTO.setOuName(salesmanInfoRepoById.getOuName());
            salesmanInfoDTO.setOuCode(salesmanInfoRepoById.getOuCode());
            salesmanInfoDTO.setFileCode(salesmanInfoRepoById.getFileCode());
            ApiResult detailListByCode = this.employeeRpcService.getDetailListByCode(Set.of(salesmanInfoRepoById.getSalesmanNo()));
            if (!detailListByCode.isSuccess()) {
                return ApiResult.fail((String)"\u67e5\u8be2\u5458\u5de5\u4fe1\u606f\u5931\u8d25");
            }
            List detailDTOS = (List)detailListByCode.getData();
            if (CollUtil.isEmpty((Collection)detailDTOS)) {
                return ApiResult.ok((Object)salesmanInfoDTO);
            }
            salesmanInfoDTO.setFullName(((SysEmployeeDetailDTO)detailDTOS.get(0)).getFullName());
            salesmanInfoDTO.setPhone(((SysEmployeeDetailDTO)detailDTOS.get(0)).getPhone());
            salesmanInfoDTO.setOrgId(((SysEmployeeDetailDTO.EmployeeOrg)((SysEmployeeDetailDTO)detailDTOS.get(0)).getOrgList().get(0)).getOrgId());
            salesmanInfoDTO.setOrgName(((SysEmployeeDetailDTO.EmployeeOrg)((SysEmployeeDetailDTO)detailDTOS.get(0)).getOrgList().get(0)).getOrgName());
            return ApiResult.ok((Object)salesmanInfoDTO);
        }
        return ApiResult.ok((Object)salesmanInfoDTO);
    }

    public ApiResult<List<CrmCustBaseRespVO>> queryAllByAgentEmpIdAndSub(Long agentEmpId) {
        List<SalesmanInfoDO> salesmanInfos;
        Optional salesmanInfoOptional = this.salesmanInfoRepo.findById(agentEmpId);
        if (salesmanInfoOptional.isEmpty()) {
            return ApiResult.ok();
        }
        SalesmanInfoDO salesmanInfo = (SalesmanInfoDO)((Object)salesmanInfoOptional.get());
        ApiResult apiResult = this.employeeRpcService.getUnderlingByCode(salesmanInfo.getSalesmanNo(), Boolean.TRUE, Boolean.TRUE);
        List resultData = (List)apiResult.getData();
        HashSet<String> codeList = new HashSet<String>();
        codeList.add(salesmanInfo.getSalesmanNo());
        if (!CollUtil.isEmpty((Collection)resultData)) {
            ArrayList<EmployeeUnderlingDTO> listEmp = new ArrayList<EmployeeUnderlingDTO>();
            List<EmployeeUnderlingDTO> res = this.treeToList(resultData, listEmp);
            codeList.addAll(res.stream().map(EmployeeUnderlingDTO::getCode).collect(Collectors.toList()));
        }
        if (org.springframework.util.CollectionUtils.isEmpty(salesmanInfos = this.salesmanInfoRepoProc.getSalesmanByCodes(codeList))) {
            return ApiResult.ok();
        }
        List<Long> agentEmpIds = salesmanInfos.stream().map(BaseModel::getId).collect(Collectors.toList());
        Map<Long, SalesmanInfoDO> empMap = salesmanInfos.stream().collect(Collectors.toMap(BaseModel::getId, t -> t, (t1, t2) -> t1));
        List<CrmCustBaseRespVO> list = this.crmCustRepoProc.getCustByEmpIds(agentEmpIds);
        list.forEach(l -> {
            if (!(org.apache.commons.collections4.MapUtils.isEmpty((Map)empMap) || ObjectUtils.isEmpty((Object)l.getAgentEmpId()) || ObjectUtils.isEmpty(empMap.get(l.getAgentEmpId())))) {
                l.setAgentEmpName(((SalesmanInfoDO)((Object)((Object)empMap.get(l.getAgentEmpId())))).getName());
                l.setAgentEmpCode(((SalesmanInfoDO)((Object)((Object)empMap.get(l.getAgentEmpId())))).getSalesmanNo());
            }
        });
        return ApiResult.ok(list);
    }

    public PagingVO<SalesmanInfoStdVO> queryAllSalemanInfosByAgentEmpId(SalesmanUnderLingQueryVO queryVO) {
        ApiResult apiResult = this.employeeRpcService.getUnderlingByCode(queryVO.getCode(), Boolean.TRUE, Boolean.TRUE);
        if (!apiResult.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5ba2\u6237\u53ca\u4e0b\u7ea7\u4fe1\u606f\u5931\u8d25\uff01" + apiResult.getMsg());
        }
        List resultData = (List)apiResult.getData();
        HashSet<String> codeList = new HashSet<String>();
        codeList.add(queryVO.getCode());
        if (!CollUtil.isEmpty((Collection)resultData)) {
            ArrayList<EmployeeUnderlingDTO> listEmp = new ArrayList<EmployeeUnderlingDTO>();
            List<EmployeeUnderlingDTO> res = this.treeToList(resultData, listEmp);
            codeList.addAll(res.stream().map(EmployeeUnderlingDTO::getCode).collect(Collectors.toList()));
        }
        queryVO.setUnderlingCodes(codeList.stream().collect(Collectors.toList()));
        PagingVO<SalesmanInfoDO> page = this.salesmanInfoRepoProc.getPageByQueryVO(queryVO);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return new PagingVO().setTotal(0L).setRecords(Collections.emptyList());
        }
        List records = page.getRecords().stream().map(SalesmanInfoConvert.INSTANCE::doToVo).collect(Collectors.toList());
        return new PagingVO().setTotal(page.getTotal()).setRecords(records);
    }

    public List<EmployeeUnderlingDTO> treeToList(List<EmployeeUnderlingDTO> source, List<EmployeeUnderlingDTO> obj) {
        source.stream().forEach(v -> {
            EmployeeUnderlingDTO t = new EmployeeUnderlingDTO();
            BeanUtils.copyProperties((Object)v, (Object)t);
            t.setUnderlingList(new ArrayList());
            obj.add(t);
            if (CollectionUtil.isNotEmpty((Collection)v.getUnderlingList())) {
                this.treeToList(v.getUnderlingList(), obj);
            }
        });
        return obj;
    }
}

