/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.MD5;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.yst.production.sale.api.dto.CustDTO;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.service.shop.BipCompanyManageService;
import com.elitesland.yst.production.sale.api.service.shop.BipCustUserBindService;
import com.elitesland.yst.production.sale.api.vo.param.com.SmsVerifyCodeParamVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCustUserBindPageQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCompanyManageRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCustUserBindCheckRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCustUserBindPageRespVO;
import com.elitesland.yst.production.sale.api.vo.save.CrmCustSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipCustUserBindSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipCustUserRegisterSaveVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.BipCustUserBindDO;
import com.elitesland.yst.production.sale.entity.CrmCustDO;
import com.elitesland.yst.production.sale.entity.QBipCustUserBindDO;
import com.elitesland.yst.production.sale.repo.CrmCustRepo;
import com.elitesland.yst.production.sale.repo.CrmCustRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepoProc;
import com.elitesland.yst.production.sale.rmi.ystauth.RmiOauthSystemRegisterRpcService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgEmpService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysUserService;
import com.elitesland.yst.production.support.provider.org.dto.OrgEmpRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgEmpRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.param.OrgOuRpcDtoParam;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Caching;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class BipCustUserBindServiceImpl
extends BaseServiceImpl
implements BipCustUserBindService {
    private static final Logger log = LoggerFactory.getLogger(BipCustUserBindServiceImpl.class);
    private final BipCustUserBindRepo bipCustUserBindRepo;
    private final BipCustUserBindRepoProc bipCustUserBindRepoProc;
    private final CrmCustRepo crmCustRepo;
    private final CrmCustRepoProc crmCustRepoProc;
    private final CrmCustService crmCustService;
    private final RmiOauthSystemRegisterRpcService systemRegisterRpcService;
    private final RmiSysUserService rmiSysUserService;
    private final RmiOrgOuService rmiOrgOuService;
    private final RmiOrgEmpService rmiOrgEmpService;
    private final RedisUtils redisUtils;
    private final BipCompanyManageService bipCompanyManageService;
    @Autowired
    private UdcProvider udcProvider;
    private static final QBipCustUserBindDO bipCustUserBindDO = QBipCustUserBindDO.bipCustUserBindDO;
    private static final String CACHE_NAME = "yst_sale_user_bind_cust";
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
    private static final MD5 MD_5 = MD5.create();

    @Transactional(rollbackFor={Exception.class})
    @Caching(evict={@CacheEvict(value={"yst_sale_user_bind_cust"}, key="#result.data", condition="#result.success")})
    public ApiResult<Long> saveRegister(BipCustUserRegisterSaveVO registerSaveVO) {
        BipCustUserBindDO bindDO = this.saveRegisterInfo(registerSaveVO);
        Long userId = this.systemRegister(registerSaveVO, bindDO.getUsername());
        this.bipCustUserBindRepoProc.updateUserId(bindDO.getId(), userId);
        return ApiResult.ok((Object)userId);
    }

    @Transactional(rollbackFor={Exception.class})
    @Caching(evict={@CacheEvict(value={"yst_sale_user_bind_cust"}, keyGenerator="currentUserKeyGenerator", condition="#result.success")})
    public ApiResult<Long> saveBind(BipCustUserBindSaveVO saveVO) {
        GeneralUserDetails user = this.currentUser();
        if (user == null) {
            return ApiResult.fail((String)"\u7ed1\u5b9a\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        String codeKey = this.generateSmsKeyForBind(saveVO.getContactPhone());
        String code = (String)this.redisUtils.get(codeKey);
        if (StrUtil.isBlank((CharSequence)code)) {
            return ApiResult.fail((String)"\u7ed1\u5b9a\u5931\u8d25\uff0c\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f");
        }
        if (!StrUtil.equals((CharSequence)code, (CharSequence)saveVO.getVerifyCode())) {
            return ApiResult.fail((String)"\u7ed1\u5b9a\u5931\u8d25\uff0c\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
        }
        CrmCustDO cust = this.getCrmCust(saveVO.getTaxRegNo());
        BipCustUserBindDO bindDO = this.bipCustUserBindRepoProc.getByUserId(user.getUser().getId());
        if (bindDO == null) {
            bindDO = this.addCustUserBind(user, saveVO, cust);
            return ApiResult.ok((Object)bindDO.getId());
        }
        this.updateCustUserBind(user, saveVO, bindDO, cust);
        return ApiResult.ok((Object)bindDO.getId());
    }

    public ApiResult<Long> getCustIdByUserId(Long userId) {
        Long custId = this.bipCustUserBindRepoProc.getCustIdByUserId(userId);
        return ApiResult.ok((Object)custId);
    }

    public ApiResult<CustDTO> getCustOfUserBind(Long userId) {
        if (userId == null) {
            return ApiResult.ok(null);
        }
        Long custId = this.bipCustUserBindRepoProc.getCustIdByUserId(userId);
        if (custId == null) {
            return ApiResult.ok(null);
        }
        CustDTO cust = this.crmCustRepoProc.getCustSimpleInfo(custId);
        return ApiResult.ok((Object)cust);
    }

    public ApiResult<Boolean> sendSmsVerifyCodeForBind(SmsVerifyCodeParamVO paramVO) {
        String cacheKey = this.generateSmsKeyForBind(paramVO.getMobile());
        Object codeOld = this.redisUtils.get(cacheKey);
        if (codeOld != null) {
            return ApiResult.fail((String)"\u9a8c\u8bc1\u7801\u53d1\u9001\u8fc7\u4e8e\u9891\u7e41");
        }
        String verifyCode = RandomUtil.randomStringUpper((int)((Integer)ObjectUtil.defaultIfNull((Object)paramVO.getCodeLength(), (Object)4)));
        this.redisUtils.set(cacheKey, (Object)verifyCode, ((Long)ObjectUtil.defaultIfNull((Object)paramVO.getPeriod(), (Object)60L)).longValue(), TimeUnit.SECONDS);
        this.redisUtils.del(new String[]{cacheKey});
        return ApiResult.ok((Object)true);
    }

    public PagingVO<BipCustUserBindPageRespVO> search(BipCustUserBindPageQueryVO queryParam) {
        JPAQuery<BipCustUserBindPageRespVO> jpaQuery = this.bipCustUserBindRepoProc.select(queryParam);
        long total = jpaQuery.fetchCount();
        if (total == 0L) {
            return PagingVO.builder().build();
        }
        PageRequest pageRequest = this.wrapperPageRequest(queryParam.getPageRequest(), null);
        this.appendPageAndSort(jpaQuery, pageRequest, bipCustUserBindDO);
        List pageResult = jpaQuery.fetch();
        this.setDisplayFields(pageResult);
        this.transUdc(pageResult);
        return PagingVO.builder().total(total).records(pageResult).build();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateStateApply(List<Long> ids, String stateApply) {
        Assert.isFalse((boolean)CollectionUtil.isEmpty(ids), (String)"[\u5ba2\u6237\u4fe1\u606f]\u64cd\u4f5c\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        Map stateApplyUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "CUST_USER_APPLY");
        Assert.isTrue((boolean)this.checkUdcValueExit(stateApplyUdcMap, stateApply), (String)"[\u5ba2\u6237\u4fe1\u606f]\u5ba1\u6279\u72b6\u6001\u6570\u636e\u5f02\u5e38", (Object[])new Object[0]);
        List bipCustUserBindDOS = this.bipCustUserBindRepo.findAllById(ids);
        CurrentUserDTO currentUser = this.getCurrentUser();
        OrgUserEmpInfoRpcDTO orgUserEmpInfoRpcDTO = this.rmiOrgEmpService.findUserEmpInfo(currentUser.getUserId());
        List manageByOuIds = this.bipCompanyManageService.findCompanyManageByOuIds(Arrays.asList(orgUserEmpInfoRpcDTO.getOuId()));
        if (CollectionUtils.isEmpty((Collection)manageByOuIds)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u516c\u53f8\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (UdcEnum.BIP_CUST_USER_APPLY_PASSED.getValueCode().equals(stateApply)) {
            List<Long> ouIds = bipCustUserBindDOS.stream().map(BipCustUserBindDO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<OrgOuRpcDTO> ouDtoList = this.getOrgOuRpcDTOList(ouIds);
            bipCustUserBindDOS.forEach(i -> {
                CrmCustDO crmCustDO = Validator.isNull((Object)i.getCustId()) ? this.crmCustRepoProc.getByTaxRegNo(i.getTaxRegNo()) : (CrmCustDO)this.crmCustRepo.findById(i.getCustId()).orElse(null);
                if (Validator.isNull((Object)crmCustDO) || 1 == crmCustDO.getDeleteFlag()) {
                    crmCustDO = null;
                }
                if (Validator.isNotNull((Object)crmCustDO)) {
                    crmCustDO.setContactPhone(i.getContactPhone());
                    crmCustDO.setContactName(i.getContactName());
                    crmCustDO.setIsCreatedAccount(true);
                    crmCustDO.setSecOuId(orgUserEmpInfoRpcDTO.getOuId());
                    crmCustDO.setSecUserId(orgUserEmpInfoRpcDTO.getUserId());
                    crmCustDO.setSecBuId(((BipCompanyManageRespVO)manageByOuIds.get(0)).getBuId());
                    this.crmCustRepo.save(crmCustDO);
                    i.setCustId(crmCustDO.getId());
                    i.setCustCode(crmCustDO.getCustCode());
                } else {
                    CrmCustSaveVO saveVO = new CrmCustSaveVO();
                    saveVO.setSecOuId(orgUserEmpInfoRpcDTO.getOuId());
                    saveVO.setSecUserId(orgUserEmpInfoRpcDTO.getUserId());
                    saveVO.setSecBuId(((BipCompanyManageRespVO)manageByOuIds.get(0)).getBuId());
                    saveVO.setCustType2(UdcEnum.CRM_CUST_TYPE2_A.getValueCode());
                    saveVO.setCustName(i.getCustName());
                    saveVO.setTaxRegNo(i.getTaxRegNo());
                    saveVO.setCustType(UdcEnum.CRM_CUST_TYPE_D.getValueCode());
                    saveVO.setInvType(UdcEnum.COM_INV_TYPE_VANA.getValueCode());
                    saveVO.setInvTitle(i.getCustName());
                    saveVO.setContactPhone(i.getContactPhone());
                    saveVO.setContactName(i.getContactName());
                    saveVO.setAgentEmpId(orgUserEmpInfoRpcDTO.getEmpId());
                    saveVO.setCustStatus("ACTIVE");
                    OrgOuRpcDTO orgOuRpcDTO = ouDtoList.stream().filter(o -> o.getId().equals(i.getOuId())).findAny().orElse(null);
                    saveVO.setOuId(i.getOuId());
                    if (Validator.isNotNull((Object)orgOuRpcDTO)) {
                        saveVO.setOuName(orgOuRpcDTO.getOuName());
                        saveVO.setOuCode(orgOuRpcDTO.getOuCode());
                        saveVO.setRegion(orgOuRpcDTO.getRegion());
                    }
                    if (Validator.isNotNull((Object)orgUserEmpInfoRpcDTO)) {
                        saveVO.setBuId(orgUserEmpInfoRpcDTO.getBuId());
                        saveVO.setBuCode(orgUserEmpInfoRpcDTO.getBuCode());
                        saveVO.setBuName(orgUserEmpInfoRpcDTO.getBuName());
                    }
                    ApiResult save = this.crmCustService.save(saveVO);
                    i.setCustId(((CrmCustDetailRespVO)save.getData()).getId());
                    i.setCustCode(((CrmCustDetailRespVO)save.getData()).getCustCode());
                }
                i.setState(UdcEnum.BIP_CUST_USER_STATE_ACTIVE.getValueCode());
                i.setStateApply(stateApply);
                i.setTimeApply(LocalDateTime.now());
                i.setAgentEmpId(orgUserEmpInfoRpcDTO.getEmpId());
                i.setSecOuId(orgUserEmpInfoRpcDTO.getOuId());
                i.setSecBuId(((BipCompanyManageRespVO)manageByOuIds.get(0)).getBuId());
                i.setSecUserId(orgUserEmpInfoRpcDTO.getUserId());
                this.bipCustUserBindRepo.save(i);
            });
        } else {
            this.bipCustUserBindRepoProc.updateStateApplyBatch(ids, UdcEnum.BIP_CUST_USER_STATE_BIND_FAIL.getValueCode(), stateApply, orgUserEmpInfoRpcDTO.getEmpId(), LocalDateTime.now());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateState(List<Long> ids, String state) {
        Map stateUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "CUST_USER_STATE");
        Assert.isFalse((boolean)CollectionUtil.isEmpty(ids), (String)"[\u5ba2\u6237\u4fe1\u606f]\u64cd\u4f5c\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((boolean)this.checkUdcValueExit(stateUdcMap, state), (String)"[\u5ba2\u6237\u4fe1\u606f]\u72b6\u6001\u6570\u636e\u5f02\u5e38", (Object[])new Object[0]);
        CurrentUserDTO currentUser = this.getCurrentUser();
        OrgUserEmpInfoRpcDTO orgUserEmpInfoRpcDTO = this.rmiOrgEmpService.findUserEmpInfo(currentUser.getUserId());
        this.bipCustUserBindRepoProc.updateStateBatch(ids, orgUserEmpInfoRpcDTO.getEmpId(), state);
    }

    public BipCustUserBindCheckRespVO checkCustUserBindInfo() {
        CurrentUserDTO currentUser = this.getCurrentUser();
        Long userId = currentUser.getUserId();
        Assert.isFalse((boolean)Validator.isNull((Object)userId), (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BipCustUserBindCheckRespVO result = new BipCustUserBindCheckRespVO();
        BipCustUserBindPageQueryVO queryParam = new BipCustUserBindPageQueryVO();
        queryParam.setUserId(userId);
        log.info("\u68c0\u9a8c\u7528\u6237-\u7ed1\u5b9a\u5165\u53c2\uff1a" + JSON.toJSONString((Object)queryParam));
        BipCustUserBindPageRespVO bipCustUserBindPageRespVO = (BipCustUserBindPageRespVO)this.bipCustUserBindRepoProc.select(queryParam).fetchFirst();
        log.info("\u68c0\u9a8c\u7528\u6237-\u7ed1\u5b9a\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)bipCustUserBindPageRespVO));
        ArrayList<Long> ouIds = new ArrayList<Long>();
        ouIds.add(bipCustUserBindPageRespVO.getOuId());
        List companyManageByOuIds = null;
        if (ouIds.get(0) != null) {
            companyManageByOuIds = this.bipCompanyManageService.findCompanyManageByOuIds(ouIds);
        }
        log.info("\u68c0\u9a8c\u7528\u6237-\u516c\u53f8\u4fe1\u606f\uff1a" + JSON.toJSONString(companyManageByOuIds));
        if (!CollectionUtils.isEmpty((Collection)companyManageByOuIds)) {
            bipCustUserBindPageRespVO.setViewOuName(((BipCompanyManageRespVO)companyManageByOuIds.get(0)).getViewOuName());
            bipCustUserBindPageRespVO.setSource(((BipCompanyManageRespVO)companyManageByOuIds.get(0)).getCustServiceSource());
            bipCustUserBindPageRespVO.setServiceTel(((BipCompanyManageRespVO)companyManageByOuIds.get(0)).getServiceTel());
        }
        if (Validator.isNotNull((Object)bipCustUserBindPageRespVO)) {
            this.setDisplayFields(Collections.singletonList(bipCustUserBindPageRespVO));
            this.transUdc(Collections.singletonList(bipCustUserBindPageRespVO));
        }
        result.setBipCustUserBindPageRespVO(bipCustUserBindPageRespVO);
        if (Validator.isNull((Object)bipCustUserBindPageRespVO) || bipCustUserBindPageRespVO.getOuId() == null || UdcEnum.BIP_CUST_USER_STATE_UNBIND.getValueCode().equals(bipCustUserBindPageRespVO.getState())) {
            result.setCode("201");
            result.setMsg("\u8bf7\u7ed1\u5b9a\u516c\u53f8\u4fe1\u606f\u3002");
        } else if (UdcEnum.BIP_CUST_USER_STATE_DISABLE.getValueCode().equals(bipCustUserBindPageRespVO.getState())) {
            result.setCode("202");
            result.setMsg("\u60a8\u7684\u8d26\u53f7\u5df2\u51bb\u7ed3\uff0c\u8bf7\u8054\u7cfb\u4e1a\u52a1\u5458\u3002");
        } else if (UdcEnum.BIP_CUST_USER_APPLY_TO_APPR.getValueCode().equals(bipCustUserBindPageRespVO.getStateApply())) {
            result.setCode("203");
            result.setMsg("\u8bf7\u7b49\u5f85\u5ba1\u6838\u5b8c\u6210\u540e\u4e0b\u5355\u6216\u8054\u7cfb\u4e1a\u52a1\u5458\u3002");
        } else if (UdcEnum.BIP_CUST_USER_APPLY_REFUSE.getValueCode().equals(bipCustUserBindPageRespVO.getStateApply())) {
            result.setCode("204");
            result.setMsg("\u8bf7\u91cd\u65b0\u7ed1\u5b9a\u516c\u53f8\u4fe1\u606f\u3002");
        } else {
            result.setCode("200");
            result.setMsg("\u7528\u6237\u72b6\u6001\u6b63\u5e38\u3002");
        }
        return result;
    }

    private Long systemRegister(BipCustUserRegisterSaveVO registerSaveVO, String username) {
        return null;
    }

    private BipCustUserBindDO saveRegisterInfo(BipCustUserRegisterSaveVO registerSaveVO) {
        LocalDateTime nowTime = LocalDateTime.now();
        String userName = MD_5.digestHex16(nowTime.format(FORMATTER)) + "_" + RandomUtil.randomString((int)6);
        BipCustUserBindDO userBindDO = new BipCustUserBindDO();
        userBindDO.setUsername(userName);
        userBindDO.setState(UdcEnum.BIP_CUST_USER_STATE_UNBIND.getValueCode());
        userBindDO.setTimeRegister(LocalDateTime.now());
        this.bipCustUserBindRepo.saveAndFlush(userBindDO);
        return userBindDO;
    }

    private void updateCustUserBind(GeneralUserDetails user, BipCustUserBindSaveVO bindInfo, BipCustUserBindDO bindDO, CrmCustDO crmCust) {
        if (StrUtil.equals((CharSequence)UdcEnum.BIP_CUST_USER_STATE_TO_APPR.getValueCode(), (CharSequence)bindDO.getState())) {
            throw new BusinessException("\u4fe1\u606f\u5df2\u63d0\u4ea4\uff0c\u8bf7\u7b49\u5f85\u5ba1\u6838");
        }
        if (StrUtil.equals((CharSequence)UdcEnum.BIP_CUST_USER_STATE_ACTIVE.getValueCode(), (CharSequence)bindDO.getState())) {
            throw new BusinessException("\u5df2\u7ed1\u5b9a\u6210\u529f\uff0c\u65e0\u9700\u518d\u6b21\u7ed1\u5b9a");
        }
        if (StrUtil.equals((CharSequence)UdcEnum.BIP_CUST_USER_STATE_DISABLE.getValueCode(), (CharSequence)bindDO.getState())) {
            throw new BusinessException("\u60a8\u7684\u8d26\u53f7\u5df2\u88ab\u516c\u53f8\u7981\u7528");
        }
        this.initBindInfo(bindDO, user, bindInfo, crmCust);
        this.bipCustUserBindRepo.save(bindDO);
    }

    private BipCustUserBindDO addCustUserBind(GeneralUserDetails user, BipCustUserBindSaveVO bindInfo, CrmCustDO crmCust) {
        BipCustUserBindDO bindDO = new BipCustUserBindDO();
        this.initBindInfo(bindDO, user, bindInfo, crmCust);
        this.bipCustUserBindRepo.save(bindDO);
        return bindDO;
    }

    private void initBindInfo(BipCustUserBindDO bindDO, GeneralUserDetails user, BipCustUserBindSaveVO bindInfo, CrmCustDO crmCust) {
        List manageByOuIds = this.bipCompanyManageService.findCompanyManageByOuIds(Arrays.asList(bindInfo.getOuId()));
        if (CollectionUtils.isEmpty((Collection)manageByOuIds)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u516c\u53f8\u4fe1\u606f\u4e3a\u7a7a");
        }
        bindDO.setSecOuId(bindInfo.getOuId());
        bindDO.setSecBuId(((BipCompanyManageRespVO)manageByOuIds.get(0)).getBuId());
        bindDO.setUserId(user.getUser().getId());
        bindDO.setUsername(user.getUsername());
        bindDO.setOuId(bindInfo.getOuId());
        if (crmCust != null) {
            throw new BusinessException("\u4f01\u4e1a\u5df2\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        bindDO.setCustId(null);
        bindDO.setAgentEmpId(null);
        bindDO.setCustCode(null);
        bindDO.setCustName(bindInfo.getCustName());
        bindDO.setTaxRegNo(bindInfo.getTaxRegNo());
        if (StrUtil.isNotBlank((CharSequence)bindInfo.getCertFileCode())) {
            if (!this.isExistsFile(bindInfo.getCertFileCode())) {
                throw new BusinessException("\u8bf7\u91cd\u65b0\u4e0a\u4f20\u8425\u4e1a\u6267\u7167");
            }
            bindDO.setCertFileCode(bindInfo.getCertFileCode());
        }
        bindDO.setContactName(bindInfo.getContactName());
        bindDO.setContactPhone(bindInfo.getContactPhone());
        bindDO.setTimeApply(LocalDateTime.now());
        bindDO.setState(UdcEnum.BIP_CUST_USER_STATE_TO_APPR.getValueCode());
        bindDO.setStateApply(UdcEnum.BIP_CUST_USER_APPLY_TO_APPR.getValueCode());
        bindDO.setApproveReason("");
        bindDO.setTimeApprove(null);
    }

    private CrmCustDO getCrmCust(String taxRegNo) {
        return this.crmCustRepoProc.getByTaxRegNo(taxRegNo);
    }

    private void setDisplayFields(List<BipCustUserBindPageRespVO> source) {
        if (CollectionUtil.isNotEmpty(source)) {
            List<Long> userIds = source.stream().map(BipCustUserBindPageRespVO::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List ouIds = source.stream().map(BipCustUserBindPageRespVO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<Long> agentEmpIdIds = source.stream().map(BipCustUserBindPageRespVO::getAgentEmpId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            log.info("\u68c0\u9a8c\u7528\u6237-\u5165\u53c2\uff1auserIds-" + JSON.toJSONString(userIds));
            log.info("\u68c0\u9a8c\u7528\u6237-\u5165\u53c2\uff1aouIds-" + JSON.toJSONString(ouIds));
            log.info("\u68c0\u9a8c\u7528\u6237-\u5165\u53c2\uff1aagentEmpIdIds-" + JSON.toJSONString(agentEmpIdIds));
            List<OrgOuRpcDTO> ouList = null;
            if (ouIds.size() > 0 && ouIds.get(0) != null) {
                ouList = this.rmiOrgOuService.findOuDtoListByParam(OrgOuRpcDtoParam.builder().ouIds(ouIds).build());
            }
            List<SysUserVO> userList = this.rmiSysUserService.getUsers(userIds);
            List<OrgEmpRpcDTO> agentEmpList = this.getOrgEmpRpcDTOList(agentEmpIdIds);
            if (CollectionUtil.isNotEmpty(userList)) {
                source.stream().filter(i -> i.getUserId() != null).forEach(i -> userList.stream().filter(v -> v.getId().equals(i.getUserId())).findAny().ifPresent(v -> i.setMobile(v.getMobile())));
            }
            if (CollectionUtil.isNotEmpty(ouList)) {
                List<OrgOuRpcDTO> finalOuList = ouList;
                source.stream().filter(i -> i.getOuId() != null).forEach(i -> finalOuList.stream().filter(v -> v.getId().equals(i.getOuId())).findAny().ifPresent(v -> i.setOuName(v.getOuName())));
            }
            if (CollectionUtil.isNotEmpty(agentEmpList)) {
                source.stream().filter(i -> i.getAgentEmpId() != null).forEach(i -> agentEmpList.stream().filter(v -> v.getId().equals(i.getAgentEmpId())).findAny().ifPresent(v -> i.setAgentEmpName(v.getEmpName())));
            }
        }
    }

    private void transUdc(List<BipCustUserBindPageRespVO> source) {
        Map stateUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "CUST_USER_STATE");
        Map stateApplyUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "CUST_USER_APPLY");
        source.forEach(i -> {
            if (StringUtils.isNotBlank((CharSequence)i.getState()) && !MapUtils.isEmpty((Map)stateUdcMap)) {
                i.setStateName((String)stateUdcMap.get(i.getState()));
            }
            if (StringUtils.isNotBlank((CharSequence)i.getStateApply()) && !MapUtils.isEmpty((Map)stateApplyUdcMap)) {
                i.setStateApplyName((String)stateApplyUdcMap.get(i.getStateApply()));
            }
        });
    }

    private String generateSmsKeyForBind(String mobile) {
        return "yst_sale_cust_user_bind_sms_" + mobile;
    }

    private String generateSmsContentForBind(String code) {
        return StrUtil.format((CharSequence)this.sysConfigProperties.getSmsContentOfBindOu(), (Object[])new Object[]{code});
    }

    private List<OrgEmpRpcDTO> getOrgEmpRpcDTOList(List<Long> empIds) {
        List<OrgEmpRpcDTO> empRpcDTOList = Collections.emptyList();
        if (CollectionUtil.isNotEmpty(empIds)) {
            OrgEmpRpcDtoParam param = new OrgEmpRpcDtoParam();
            param.setEmpIds(empIds);
            empRpcDTOList = this.rmiOrgEmpService.findEmpListByParam(param);
        }
        return empRpcDTOList;
    }

    private List<OrgOuRpcDTO> getOrgOuRpcDTOList(List<Long> ouIds) {
        List<OrgOuRpcDTO> ouDtoList = Collections.emptyList();
        if (CollectionUtil.isNotEmpty(ouIds)) {
            ouDtoList = this.rmiOrgOuService.findOuDtoList(ouIds, null);
        }
        return ouDtoList;
    }

    private CurrentUserDTO getCurrentUser() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u5df2\u5931\u6548,\u8bf7\u91cd\u767b\u5f55\u91cd\u8bd5");
        }
        return currentUser;
    }

    public BipCustUserBindServiceImpl(BipCustUserBindRepo bipCustUserBindRepo, BipCustUserBindRepoProc bipCustUserBindRepoProc, CrmCustRepo crmCustRepo, CrmCustRepoProc crmCustRepoProc, CrmCustService crmCustService, RmiOauthSystemRegisterRpcService systemRegisterRpcService, RmiSysUserService rmiSysUserService, RmiOrgOuService rmiOrgOuService, RmiOrgEmpService rmiOrgEmpService, RedisUtils redisUtils, BipCompanyManageService bipCompanyManageService, UdcProvider udcProvider) {
        this.bipCustUserBindRepo = bipCustUserBindRepo;
        this.bipCustUserBindRepoProc = bipCustUserBindRepoProc;
        this.crmCustRepo = crmCustRepo;
        this.crmCustRepoProc = crmCustRepoProc;
        this.crmCustService = crmCustService;
        this.systemRegisterRpcService = systemRegisterRpcService;
        this.rmiSysUserService = rmiSysUserService;
        this.rmiOrgOuService = rmiOrgOuService;
        this.rmiOrgEmpService = rmiOrgEmpService;
        this.redisUtils = redisUtils;
        this.bipCompanyManageService = bipCompanyManageService;
        this.udcProvider = udcProvider;
    }
}

