/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.controller.crm;

import com.elitescloud.boot.common.param.ComSearchParam;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.CrmCust2Service;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.service.shop.BipCrmCustService;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustAddrParamVO;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustBaseParamVO;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustPlugInParamVO;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmEmpAssignParamVO;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustPredictionParamVO;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustSwitchStatusParamVO;
import com.elitesland.yst.production.sale.api.vo.param.crm.OrgAddrAddressSaveParam;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustAddrRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustBasePageVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustPageRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustPlugInRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustSimpleVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustSalePredictionVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.RmiOuDetailVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.RmiOuInfoByAddr;
import com.elitesland.yst.production.sale.api.vo.save.CrmAddrImplSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.CrmCustImportSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.CrmCustSaveVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import com.elitesland.yst.production.sale.core.util.excel.support.ExportColumnParam;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/crm/cust"}, produces={"application/json"})
@Api(tags={"\u5ba2\u6237\u4fe1\u606f"})
@ApiSupport(author="wang shao", order=1)
public class CrmCustController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(CrmCustController.class);
    @Autowired
    private CrmCustService custService;
    @Autowired
    private BipCrmCustService bipCrmCustService;
    @Autowired
    private CrmCust2Service crmCust2Service;

    @PostMapping(value={"/queryCustAddr"})
    @ApiOperation(value="\u67e5\u8be2\u5ba2\u6237\u5730\u5740\u4fe1\u606f")
    public ApiResult<List<CrmCustAddrRespVO>> queryCustAddr() {
        List res = this.custService.queryCustAddr();
        return ApiResult.ok((Object)res);
    }

    @PostMapping(value={"/saveCustAddr"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539\u5ba2\u6237\u5730\u5740\u4fe1\u606f")
    public ApiResult<Object> saveCustAddr(@RequestBody OrgAddrAddressSaveParam param) {
        Long res = this.custService.saveCustAddr(param);
        return ApiResult.ok((Object)res);
    }

    @DeleteMapping(value={"/delCustAddr/{id}"})
    @ApiOperation(value="\u5220\u9664\u5730\u5740\u4fe1\u606f")
    public ApiResult<Object> delCustAddr(@PathVariable Long id) {
        this.custService.delCustAddr(id);
        return ApiResult.ok();
    }

    @PostMapping(value={"/query"})
    @ApiOperation(value="\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f")
    @ApiOperationSupport(order=1)
    public ApiResult<PagingVO<CrmCustSimpleVO>> query(@RequestBody ComSearchParam searchParam) {
        return this.custService.query(searchParam);
    }

    @PostMapping(value={"/queryCustPlugIn"})
    @ApiOperation(value="\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f(\u5ba2\u6237\u5f39\u6846\u9009\u62e9)")
    @ApiOperationSupport(order=2)
    public ApiResult<PagingVO<CrmCustPlugInRespVO>> queryCustPlugIn(@RequestBody CrmCustPlugInParamVO searchParam) {
        return this.custService.queryCustPlugIn(searchParam);
    }

    @PostMapping(value={"/queryCustSalePrediction"})
    @ApiOperation(value="\u9500\u552e\u9884\u6d4b\u67e5\u8be2\u5ba2\u6237")
    public ApiResult<PagingVO<CustSalePredictionVO>> queryCustSalePrediction(@RequestBody CustPredictionParamVO param) {
        return ApiResult.ok((Object)this.custService.queryCustSalePrediction(param));
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u67e5\u8be2\u5ba2\u6237\u8be6\u60c5\u6570\u636e")
    @ApiOperationSupport(order=2)
    public ApiResult<CrmCustDetailRespVO> get(@PathVariable Long id) {
        return ApiResult.ok((Object)this.custService.get(id));
    }

    @GetMapping(value={"/getByUserName/{userId}"})
    @ApiOperation(value="\u901a\u8fc7\u7528\u6237\u540d\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f")
    @ApiOperationSupport(order=2)
    public ApiResult<CrmCustDetailRespVO> getByUserName(@PathVariable Long userId) {
        return ApiResult.ok((Object)this.custService.getByUserId(userId));
    }

    @PostMapping(value={"/switch"})
    @ApiOperation(value="\u542f\u7528/\u7981\u7528 \u5ba2\u6237")
    public ApiResult<Object> switchStatusByIds(@RequestBody CustSwitchStatusParamVO paramVO) {
        this.custService.switchStatusByIds(paramVO);
        return ApiResult.ok();
    }

    @PostMapping(value={"/search"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5ba2\u6237\u5217\u8868")
    @ApiOperationSupport(order=3)
    public ApiResult<PagingVO<CrmCustPageRespVO>> search(@RequestBody CrmCustQueryParamVO searchParam) {
        PagingVO result = this.custService.search(searchParam);
        return ApiResult.ok((Object)result);
    }

    @PostMapping(value={""})
    @ApiOperation(value="\u4fdd\u5b58\u6570\u636e")
    @ApiOperationSupport(order=4)
    public ApiResult<Long> save(@RequestBody CrmCustSaveVO saveVO) {
        CrmCustDetailRespVO crmCustDetailRespVO = (CrmCustDetailRespVO)this.custService.save(saveVO).getData();
        return ApiResult.ok((Object)crmCustDetailRespVO.getId());
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u4fdd\u5b58\u6570\u636e")
    @ApiOperationSupport(order=4)
    public ApiResult<Long> bcSave(@RequestBody CrmCustSaveVO saveVO) {
        CrmCustDetailRespVO crmCustDetailRespVO = (CrmCustDetailRespVO)this.custService.bcSave(saveVO).getData();
        return ApiResult.ok((Object)crmCustDetailRespVO.getId());
    }

    @PostMapping(value={"/ImportData"})
    @ApiOperation(value="\u89e3\u6790\u5bfc\u5165\u5ba2\u6237\u4fe1\u606f\u6570\u636e")
    @ApiOperationSupport(order=5)
    public ApiResult<List<CrmCustImportSaveVO>> parseImportData(MultipartFile file) {
        List<?> parseData = null;
        try {
            parseData = this.importExcel(file, CrmCustImportSaveVO.class, 2, 2);
        }
        catch (Exception e) {
            return ApiResult.fail((String)"\u89e3\u6790\u5bfc\u5165\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u4e25\u683c\u6309\u7167\u539f\u59cb\u6a21\u677f\u6570\u636e\u683c\u5f0f\u8fdb\u884c\u5bfc\u5165");
        }
        if (!CollectionUtils.isEmpty(parseData)) {
            return this.custService.custImportData(parseData);
        }
        return ApiResult.ok();
    }

    @PostMapping(value={"/ImportAddrData"})
    @ApiOperation(value="\u89e3\u6790\u5bfc\u5165\u5ba2\u6237\u5730\u5740\u4fe1\u606f\u6570\u636e")
    @ApiOperationSupport(order=6)
    public ApiResult<List<CrmAddrImplSaveVO>> parseImportAddrData(MultipartFile file) {
        List<?> parseData = null;
        try {
            parseData = this.importExcel(file, CrmAddrImplSaveVO.class, 2, 2);
        }
        catch (Exception e) {
            return ApiResult.fail((String)"\u89e3\u6790\u5bfc\u5165\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u4e25\u683c\u6309\u7167\u539f\u59cb\u6a21\u677f\u6570\u636e\u683c\u5f0f\u8fdb\u884c\u5bfc\u5165");
        }
        if (!CollectionUtils.isEmpty(parseData)) {
            return this.custService.custaddrImportData(parseData);
        }
        return ApiResult.ok();
    }

    @PostMapping(value={"/empAssign"})
    @ApiOperation(value="\u6279\u91cf\u5206\u914d\u4e1a\u52a1\u5458")
    @ApiOperationSupport(order=7)
    public ApiResult<Object> empAssign(@RequestBody CrmEmpAssignParamVO crmEmpAssignParamVO) {
        this.custService.empAssign(crmEmpAssignParamVO);
        return ApiResult.ok();
    }

    @PostMapping(value={"/findAddrsByParam"})
    @ApiOperation(value="\u901a\u8fc7\u67e5\u8be2\u6761\u4ef6\u67e5\u8be2\u5730\u5740\u4fe1\u606f")
    @ApiOperationSupport(order=8)
    public ApiResult<List<CrmCustAddrRespVO>> findAddrsByAddrNo(@RequestBody CrmCustAddrParamVO crmCustAddrParamVO) {
        List crmCustAddrRespVOS = this.custService.findAddrsByParam(crmCustAddrParamVO);
        return ApiResult.ok((Object)crmCustAddrRespVOS);
    }

    @GetMapping(value={"/custMdmSync/{id}"})
    @ApiOperation(value="\u901a\u8fc7id\u540cMdm\u7cfb\u7edf\u540c\u6b65\u6570\u636e")
    @ApiOperationSupport(order=8)
    public ApiResult<Object> custMdmSync(@PathVariable Long id) {
        this.custService.custMdmSync(id);
        return ApiResult.ok();
    }

    @GetMapping(value={"/findCustByCode/{custCode}"})
    @ApiOperation(value="\u901a\u8fc7\u5ba2\u6237\u7f16\u7801\u7cbe\u786e\u67e5\u8be2\u6570\u636e")
    @ApiOperationSupport(order=9)
    public ApiResult<Object> findCustByCode(@PathVariable String custCode) {
        return ApiResult.ok((Object)this.custService.findCustByCode(custCode));
    }

    @ApiOperation(value="\u521b\u5efa\u5ba2\u6237\u767b\u9646\u8d26\u6237")
    @ApiOperationSupport(order=10)
    @PutMapping(value={"/createUserAccount/{ids}"})
    public ApiResult<Object> createUserAccount(@PathVariable List<Long> ids) {
        String createInfo = this.bipCrmCustService.createUserAccount(ids);
        return StringUtils.isEmpty((Object)createInfo) ? ApiResult.ok() : ApiResult.fail((String)createInfo);
    }

    @PostMapping(value={"/exportData"})
    @ApiOperation(value="\u5ba2 \u6237\u5bfc\u51fa")
    @ApiOperationSupport(order=11)
    public void exportCrm(HttpServletResponse response, @RequestBody CrmCustQueryParamVO pagingParamVO) {
        ArrayList<ExportColumnParam> columnParamList = new ArrayList<ExportColumnParam>(16);
        columnParamList.add(new ExportColumnParam("custCode", "\u5ba2\u6237\u7f16\u7801"));
        columnParamList.add(new ExportColumnParam("custName", "\u5ba2\u6237\u540d\u79f0"));
        columnParamList.add(new ExportColumnParam("custAbbr", "\u5ba2\u6237\u7b80\u79f0"));
        columnParamList.add(new ExportColumnParam("custName2", "\u82f1\u6587\u540d\u79f0"));
        columnParamList.add(new ExportColumnParam("custCode2", "\u5916\u90e8\u5ba2\u6237\u7f16\u7801"));
        columnParamList.add(new ExportColumnParam("taxRegNo", "\u7a0e\u52a1\u767b\u8bb0\u53f7"));
        columnParamList.add(new ExportColumnParam("custType2Name", "\u5ba2\u6237\u5f52\u7c7b"));
        columnParamList.add(new ExportColumnParam("contactName", "B\u7aef\u5546\u57ce\u8054\u7cfb\u4eba"));
        columnParamList.add(new ExportColumnParam("contactPhone", "B\u7aef\u5546\u57ce\u8054\u7cfb\u4eba\u7535\u8bdd"));
        columnParamList.add(new ExportColumnParam("ouName", "\u516c\u53f8"));
        columnParamList.add(new ExportColumnParam("buName", "\u7ec4\u7ec7"));
        columnParamList.add(new ExportColumnParam("regionName", "\u533a\u57df"));
        columnParamList.add(new ExportColumnParam("agentEmpName", "\u4e1a\u52a1\u5458"));
        columnParamList.add(new ExportColumnParam("custTypeName", "\u5ba2\u6237\u5206\u7c7b"));
        columnParamList.add(new ExportColumnParam("custIndustryName", "\u5ba2\u6237\u884c\u4e1a"));
        columnParamList.add(new ExportColumnParam("custLevel", "\u5ba2\u6237\u7b49\u7ea7"));
        columnParamList.add(new ExportColumnParam("custStatusName", "\u5ba2\u6237\u72b6\u6001"));
        columnParamList.add(new ExportColumnParam("custSourceName", "\u5ba2\u6237\u6765\u6e90"));
        columnParamList.add(new ExportColumnParam("compScaleName", "\u5ba2\u6237\u89c4\u6a21"));
        columnParamList.add(new ExportColumnParam("compTurnover", "\u5ba2\u6237\u5e74\u8425\u4e1a\u989d"));
        columnParamList.add(new ExportColumnParam("financialAttributeName", "\u8d22\u52a1\u5c5e\u60271"));
        columnParamList.add(new ExportColumnParam("financialAttribute2Name", "\u8d22\u52a1\u5c5e\u60272"));
        columnParamList.add(new ExportColumnParam("financialAttribute3Name", "\u8d22\u52a1\u5c5e\u60273"));
        columnParamList.add(new ExportColumnParam("financialAttribute4Name", "\u8d22\u52a1\u5c5e\u60274"));
        columnParamList.add(new ExportColumnParam("financialGroup", "\u8d22\u52a1\u5c5e\u6027\u7ec4\u5408"));
        columnParamList.add(new ExportColumnParam("custGroup2Name", "\u5927B/\u5c0fB"));
        columnParamList.add(new ExportColumnParam("invTypeName", "\u53d1\u7968\u7c7b\u578b"));
        columnParamList.add(new ExportColumnParam("invTitle", "\u5f00\u7968\u62ac\u5934"));
        columnParamList.add(new ExportColumnParam("taxerNo", "\u7a0e\u53f7"));
        columnParamList.add(new ExportColumnParam("invAddress", "\u5f00\u7968\u5730\u5740"));
        columnParamList.add(new ExportColumnParam("invTel", "\u5f00\u7968\u7535\u8bdd"));
        columnParamList.add(new ExportColumnParam("invBankName", "\u5f00\u6237\u94f6\u884c"));
        columnParamList.add(new ExportColumnParam("invBankAcc", "\u94f6\u884c\u8d26\u6237"));
        columnParamList.add(new ExportColumnParam("invPicName", "\u8054\u7cfb\u4eba"));
        columnParamList.add(new ExportColumnParam("paymentTermName", "\u4ed8\u6b3e\u6761\u6b3e"));
        columnParamList.add(new ExportColumnParam("ardaysCheckTypeName", "\u8d26\u671f\u68c0\u67e5\u7c7b\u578b"));
        columnParamList.add(new ExportColumnParam("creditCheckTypeName", "\u4fe1\u8d37\u68c0\u67e5\u7c7b\u578b"));
        columnParamList.add(new ExportColumnParam("creditLimit", "\u4fe1\u8d37\u989d\u5ea6"));
        columnParamList.add(new ExportColumnParam("contPerson", "\u5ba2\u6237\u5730\u5740\u8054\u7cfb\u4eba"));
        columnParamList.add(new ExportColumnParam("contPersonMobile", "\u5ba2\u6237\u5730\u5740\u8054\u7cfb\u4eba\u624b\u673a"));
        columnParamList.add(new ExportColumnParam("contPersonTel", "\u5ba2\u6237\u8054\u7cfb\u4eba\u7535\u8bdd"));
        columnParamList.add(new ExportColumnParam("contPersonFax", "\u5ba2\u6237\u8054\u7cfb\u4eba\u4f20\u771f"));
        columnParamList.add(new ExportColumnParam("contPersonEmail", "\u5ba2\u6237\u8054\u7cfb\u4eba\u90ae\u7bb1"));
        columnParamList.add(new ExportColumnParam("country", "\u56fd\u5bb6"));
        columnParamList.add(new ExportColumnParam("contractCityName", "\u7701/\u5e02/(\u533a\u3001\u53bf)"));
        columnParamList.add(new ExportColumnParam("street", "\u4e61\u9547/\u8857\u9053"));
        columnParamList.add(new ExportColumnParam("addrDetail", "\u5ba2\u6237\u8be6\u7ec6\u5730\u5740"));
        try {
            this.export(response, "\u53d1\u8d27\u5355\u5bfc\u51fa\u6570\u636e", columnParamList, paramVO -> (PagingVO)this.crmCust2Service.searchForExport(paramVO).getData(), pagingParamVO);
        }
        catch (Exception e) {
            throw new BusinessException("\u5bfc\u51fa\u5931\u8d25");
        }
    }

    @GetMapping(value={"/getOuByAddr/{addrNo}"})
    @ApiOperation(value="\u83b7\u53d6\u516c\u53f8\u4fe1\u606f")
    @ApiOperationSupport(order=13)
    public ApiResult<RmiOuInfoByAddr> getOuByAddr(@PathVariable Long addrNo) {
        return ApiResult.ok((Object)this.custService.getOuByAddr(addrNo));
    }

    @GetMapping(value={"/getOuDetail/{ouCode}"})
    @ApiOperation(value="\u83b7\u53d6\u516c\u53f8\u4fe1\u606f2")
    @ApiOperationSupport(order=14)
    public ApiResult<RmiOuDetailVO> getOuByCode(@PathVariable String ouCode) {
        return ApiResult.ok((Object)this.custService.getOuByCode(ouCode));
    }

    @PostMapping(value={"/getCustBasePage"})
    @ApiOperation(value="\u95e8\u5e97\u4e13\u7528\u5ba2\u6237\u4fe1\u606f\u5206\u9875")
    public ApiResult<PagingVO<CrmCustBasePageVO>> getCustBasePage(@RequestBody CrmCustBaseParamVO crmCustBaseParamVO) {
        return ApiResult.ok((Object)this.custService.getCustBasePage(crmCustBaseParamVO));
    }

    @GetMapping(value={"/syncSyncToOu/{ids}"})
    @ApiOperation(value="\u540c\u6b65\u6570\u636e\u5230\u516c\u53f8")
    public ApiResult<Object> syncSyncToOu(@PathVariable List<Long> ids) {
        return this.custService.syncSyncToOu(ids);
    }
}

