/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.controller.shop;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipOrderParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipOrderUserParmVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipOrderRespVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipAppOrderPayVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipAppOrderSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipOrderSaveVO;
import com.elitesland.yst.production.sale.service.shop.BipOrderBackToOmsServiceimpl;
import com.elitesland.yst.production.sale.service.shop.BipOrderToOmsServiceimpl;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bip/order"})
@Api(value="\u8ba2\u5355\u4e3b\u8868", tags={"\u8ba2\u5355\u4e3b\u8868"})
public class BipOrderController {
    private static final Logger log = LoggerFactory.getLogger(BipOrderController.class);
    @Autowired
    private BipOrderService bipOrderService;
    @Autowired
    private BipOrderToOmsServiceimpl bipOrderToOmsServiceimpl;
    @Autowired
    private BipOrderBackToOmsServiceimpl bipOrderBackToOmsServiceimpl;

    @PostMapping(value={"/page/search"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @ApiOperationSupport(order=1)
    public ApiResult<PagingVO<BipOrderRespVO>> findPageOrder(@RequestBody BipOrderParmVO bipOrderParmVO) {
        return ApiResult.ok((Object)this.bipOrderService.findPageOrder(bipOrderParmVO));
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u8ba2\u5355\u4fdd\u5b58")
    @ApiOperationSupport(order=2)
    public ApiResult saveOrder(@RequestBody BipAppOrderSaveVO bipAppOrderSaveVO) {
        Map hashMap = this.bipOrderService.saveOrder(bipAppOrderSaveVO);
        return ApiResult.ok((Object)hashMap);
    }

    @GetMapping(value={"/find"})
    @ApiOperation(value="\u8ba2\u5355\u67e5\u8be2--\u6839\u636eid")
    @ApiOperationSupport(order=3)
    public ApiResult<BipOrderRespVO> findOrderById(Long id) {
        BipOrderRespVO bipOrderRespVO = this.bipOrderService.findOrderById(id);
        return ApiResult.ok((Object)bipOrderRespVO);
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u8ba2\u5355\u66f4\u65b0")
    @ApiOperationSupport(order=4)
    public ApiResult updateOrder(@RequestBody BipOrderSaveVO bipOrderSaveVOS) {
        this.bipOrderService.updateOrder(bipOrderSaveVOS);
        return ApiResult.ok();
    }

    @PostMapping(value={"/delete/id"})
    @ApiOperation(value="\u8ba2\u5355\u5220\u9664--\u901a\u8fc7id\uff0c\u652f\u6301\u6279\u91cf")
    @ApiOperationSupport(order=5)
    public ApiResult deleteOrderByIds(@RequestBody List<Long> ids) {
        this.bipOrderService.deleteOrderByIds(ids);
        return ApiResult.ok();
    }

    @GetMapping(value={"/delete/{id}"})
    @ApiOperation(value="\u8ba2\u5355\u5220\u9664--\u901a\u8fc7id\uff0c\u5355\u4e2a\u5220\u9664")
    @ApiOperationSupport(order=5)
    public ApiResult deleteOrderById(@PathVariable Long id) {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(id);
        this.bipOrderService.deleteOrderByIds(ids);
        return ApiResult.ok();
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u8ba2\u5355\u5220\u9664")
    @ApiOperationSupport(order=6)
    public ApiResult deleteOrder(@RequestBody List<BipOrderSaveVO> bipOrderSaveVOS) {
        this.bipOrderService.deleteOrder(bipOrderSaveVOS);
        return ApiResult.ok();
    }

    @GetMapping(value={"/update/sign/{id}"})
    @ApiOperation(value="\u8ba2\u5355\u7b7e\u6536")
    @ApiOperationSupport(order=7)
    public ApiResult siginOrder(@PathVariable Long id) {
        return this.bipOrderService.updateOrderSignStatus(id);
    }

    @PostMapping(value={"/find/user"})
    @ApiOperation(value="\u6211\u7684\u8ba2\u5355")
    @ApiOperationSupport(order=8)
    public ApiResult<PagingVO<BipOrderRespVO>> findUserOrder(@RequestBody BipOrderUserParmVO bipOrderUserParmVO) {
        PagingVO pagingVO = this.bipOrderService.findUserOrder(bipOrderUserParmVO);
        return ApiResult.ok((Object)pagingVO);
    }

    @GetMapping(value={"/find/detail/{id}"})
    @ApiOperation(value="\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2")
    @ApiOperationSupport(order=9)
    public ApiResult<BipOrderRespVO> findOrderDetailById(@PathVariable Long id) {
        BipOrderRespVO bipOrderRespVO = this.bipOrderService.findPolymerizeOrder(id);
        return ApiResult.ok((Object)bipOrderRespVO);
    }

    @PostMapping(value={"/cancle"})
    @ApiOperation(value="\u8ba2\u5355\u53d6\u6d88")
    @ApiOperationSupport(order=10)
    public ApiResult cancleOrder(@RequestBody BipOrderSaveVO bipOrderSaveVOS) {
        this.bipOrderService.cancleOrder(bipOrderSaveVOS);
        return ApiResult.ok();
    }

    @GetMapping(value={"/sendToOms/{id}/{syncOms}"})
    @ApiOperation(value="\u540c\u6b65\u8ba2\u5355\u5230oms")
    @ApiOperationSupport(order=11)
    public ApiResult sendToOms(@PathVariable Long id, @PathVariable Boolean syncOms) {
        if (!syncOms.booleanValue()) {
            this.bipOrderToOmsServiceimpl.sendToOms(id);
        }
        return ApiResult.ok();
    }

    @PostMapping(value={"/test/{id}"})
    @ApiOperation(value="\u8ba2\u5355\u63a5\u5165\u6d4b\u8bd5")
    @ApiOperationSupport(order=11)
    public ApiResult test(@PathVariable Long id) {
        this.bipOrderToOmsServiceimpl.sendToOms(id);
        return ApiResult.ok();
    }

    @PostMapping(value={"/test/back"})
    @ApiOperation(value="\u9000\u8d27\u5355\u63a5\u5165\u6d4b\u8bd5")
    @ApiOperationSupport(order=12)
    public ApiResult testBack(@RequestBody List<Long> ids) {
        this.bipOrderBackToOmsServiceimpl.sendToOms(ids);
        return ApiResult.ok();
    }

    @PostMapping(value={"/test/pay"})
    @ApiOperation(value="\u652f\u4ed8\u63a5\u5165\u6d4b\u8bd5")
    @ApiOperationSupport(order=13)
    public ApiResult testPay() {
        BipAppOrderSaveVO bipAppOrderSaveVO = new BipAppOrderSaveVO();
        Map map = this.bipOrderService.saveOrder(bipAppOrderSaveVO);
        return ApiResult.ok((Object)map);
    }

    @GetMapping(value={"/find/user/{id}"})
    @ApiOperation(value="\u8ba2\u5355\u8be6\u60c5")
    @ApiOperationSupport(order=14)
    public ApiResult<BipOrderRespVO> findUserOrderDetail(@PathVariable Long id) {
        BipOrderRespVO bipOrderRespVO = this.bipOrderService.findUserOrderDetail(id);
        return ApiResult.ok((Object)bipOrderRespVO);
    }

    @PostMapping(value={"/order/pay"})
    @ApiOperation(value="\u8ba2\u5355\u8be6\u60c5")
    @ApiOperationSupport(order=15)
    public ApiResult<Map> findUserOrderDetail(@RequestBody BipAppOrderPayVO bipAppOrderPayVO) {
        Map map = this.bipOrderService.orderPay(bipAppOrderPayVO);
        return ApiResult.ok((Object)map);
    }

    @GetMapping(value={"/order/count/{userId}"})
    @ApiOperation(value="\u8ba2\u5355\u8be6\u60c5")
    @ApiOperationSupport(order=15)
    public ApiResult<JSONObject> findUserOrderCount(@PathVariable Long userId) {
        JSONObject js = this.bipOrderService.findUserOrderCount(userId);
        return ApiResult.ok((Object)js);
    }
}

