/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.core.service;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.el.coordinator.boot.fsm.service.FileService;
import com.el.coordinator.core.common.api.ApiResult;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.core.config.SysConfigProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.PlatformTransactionManager;

public abstract class BaseServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(BaseServiceImpl.class);
    @Autowired
    protected JPAQueryFactory jpaQueryFactory;
    @Autowired
    protected ObjectMapper objectMapper;
    @Autowired
    protected PlatformTransactionManager transactionManager;
    @Autowired(required=false)
    protected SysConfigProperties sysConfigProperties;
    @Autowired
    protected ApplicationEventPublisher eventPublisher;
    @Autowired
    private UdcProvider udcProvider;
    @Autowired
    protected FileService fileService;

    protected boolean isExistsFile(@NonNull String fileCode) {
        if (fileCode == null) {
            throw new NullPointerException("fileCode is marked non-null but is null");
        }
        ApiResult queryResult = this.fileService.existsAll(fileCode);
        if (!queryResult.isSuccess()) {
            log.error("\u5224\u65ad\u6587\u4ef6\u3010{}\u3011\u662f\u5426\u5b58\u5728\u5931\u8d25\uff1a{}", (Object)fileCode, (Object)queryResult.getMsg());
            throw new BusinessException("\u6587\u4ef6\u670d\u52a1\u5668\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return (Boolean)queryResult.getData();
    }

    protected FileObjRespVO<?> getFile(@NonNull String fileCode) {
        if (fileCode == null) {
            throw new NullPointerException("fileCode is marked non-null but is null");
        }
        ApiResult getResult = this.fileService.get(fileCode);
        if (getResult.isSuccess()) {
            return (FileObjRespVO)getResult.getData();
        }
        log.debug("\u83b7\u53d6\u6587\u4ef6\u3010{}\u3011\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)fileCode, (Object)getResult.getMsg());
        return null;
    }

    protected List<FileObjRespVO<?>> getFile(@NonNull List<String> fileCodes) {
        if (fileCodes == null) {
            throw new NullPointerException("fileCodes is marked non-null but is null");
        }
        if (fileCodes.isEmpty()) {
            return Collections.emptyList();
        }
        ApiResult getResult = this.fileService.query(fileCodes);
        if (getResult.isSuccess()) {
            return (List)getResult.getData();
        }
        log.debug("\u83b7\u53d6\u6587\u4ef6\u3010{}\u3011\u4fe1\u606f\u5931\u8d25\uff1a{}", fileCodes, (Object)getResult.getMsg());
        return Collections.emptyList();
    }

    protected Map<String, String> convertUdc(UdcEnum udc) {
        if (udc == null) {
            return Collections.emptyMap();
        }
        return this.udcProvider.getValueMapByUdcCode("yst-sale", udc.getCode());
    }

    protected PageRequest wrapperPageRequest(PageRequest pageRequest, Sort defaultSort) {
        if (pageRequest == null) {
            return null;
        }
        Sort sort = pageRequest.getSort();
        if (sort.isUnsorted()) {
            sort = defaultSort == null ? Sort.by((Sort.Direction)Sort.DEFAULT_DIRECTION, (String[])new String[]{"id"}) : defaultSort.and(Sort.by((String[])new String[]{"id"}));
        }
        return PageRequest.of((int)pageRequest.getPageNumber(), (int)pageRequest.getPageSize(), (Sort)sort);
    }

    protected <T extends EntityPathBase> OrderSpecifier<?>[] obtainOrder(PageRequest pageRequest, T entityPath) {
        return this.obtainOrder(pageRequest, entityPath, new OrderSpecifier[0]);
    }

    protected <T extends EntityPathBase> OrderSpecifier<?>[] obtainOrder(PageRequest pageRequest, T entityPath, OrderSpecifier<?>[] defaultOrder) {
        if (pageRequest == null) {
            return defaultOrder;
        }
        Sort sort = pageRequest.getSort();
        if (sort.isUnsorted()) {
            return defaultOrder;
        }
        PathBuilder pathBuilder = new PathBuilder(entityPath.getClass(), entityPath.getMetadata());
        return (OrderSpecifier[])sort.stream().map(o -> new OrderSpecifier(o.getDirection().isAscending() ? Order.ASC : Order.DESC, (Expression)pathBuilder.get(o.getProperty()))).toArray(OrderSpecifier[]::new);
    }

    protected <T extends EntityPathBase> void appendPageAndSort(JPAQuery<?> jpaQuery, PageRequest pageRequest, T entityPath) {
        ((JPAQuery)((JPAQuery)jpaQuery.orderBy(this.obtainOrder(pageRequest, entityPath))).offset(pageRequest.getOffset())).limit((long)pageRequest.getPageSize());
    }

    protected BooleanExpression appendAndCondition(BooleanExpression predicate, BooleanExpression condition) {
        return predicate == null ? condition : predicate.and((Predicate)condition);
    }

    protected BooleanExpression appendOrCondition(BooleanExpression predicate, BooleanExpression condition) {
        return predicate == null ? condition : predicate.or((Predicate)condition);
    }

    protected String convertObj2Str(Object object) {
        if (object == null) {
            return "";
        }
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            log.error("\u8f6c\u6362\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new IllegalArgumentException("\u8f6c\u6362\u4fe1\u606f\u5931\u8d25", e);
        }
    }

    protected <T> T convert2Obj(String jsonStr, Class<T> cls) {
        if (StrUtil.isBlank((CharSequence)jsonStr)) {
            return null;
        }
        try {
            return (T)this.objectMapper.readValue(jsonStr, cls);
        }
        catch (JsonProcessingException e) {
            log.error("\u8f6c\u6362\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new IllegalArgumentException("\u8f6c\u6362\u4fe1\u606f\u5931\u8d25", e);
        }
    }

    protected List<String> convert2List(String jsonStr) {
        if (StrUtil.isBlank((CharSequence)jsonStr)) {
            return Collections.emptyList();
        }
        try {
            return (List)this.objectMapper.readValue(jsonStr, (TypeReference)new TypeReference<List<String>>(){});
        }
        catch (JsonProcessingException e) {
            log.error("\u8f6c\u6362\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new IllegalArgumentException("\u8f6c\u6362\u4fe1\u606f\u5931\u8d25", e);
        }
    }

    protected <T> List<T> convert2List(String jsonStr, Class<T> cls) {
        if (StrUtil.isBlank((CharSequence)jsonStr)) {
            return Collections.emptyList();
        }
        try {
            return (List)this.objectMapper.readValue(jsonStr, new TypeReference<List<T>>(){});
        }
        catch (JsonProcessingException e) {
            log.error("\u8f6c\u6362\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new IllegalArgumentException("\u8f6c\u6362\u4fe1\u606f\u5931\u8d25", e);
        }
    }

    protected void assertApiResult(com.elitescloud.cloudt.common.base.ApiResult<?> apiResult, String defMsg) {
        if (apiResult == null) {
            throw new BusinessException((String)ObjectUtil.defaultIfNull((Object)defMsg, (Object)"\u64cd\u4f5c\u5931\u8d25"));
        }
        if (apiResult.isSuccess()) {
            return;
        }
        throw new BusinessException((String)ObjectUtil.defaultIfNull((Object)apiResult.getMsg(), (Object)((String)ObjectUtil.defaultIfNull((Object)defMsg, (Object)"\u64cd\u4f5c\u5931\u8d25"))));
    }

    protected void printApiResultOnFail(com.elitescloud.cloudt.common.base.ApiResult<?> apiResult, String errorMsg, Object ... param) {
        if (apiResult == null) {
            log.error(errorMsg, param);
            return;
        }
        if (!apiResult.isSuccess()) {
            log.error(errorMsg + "\uff0c" + apiResult.getMsg(), param);
        }
    }

    protected boolean checkUdcValueExit(Map<String, String> udcMap, String value) {
        if (value == null) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)value) && !MapUtils.isEmpty(udcMap)) {
            return udcMap.keySet().stream().filter(key -> value.equals(key)).count() == 1L;
        }
        return false;
    }

    protected void publishEventSync(ApplicationEvent event) {
        this.eventPublisher.publishEvent(event);
    }

    protected void publishEventAsync(ApplicationEvent event) {
        CompletableFuture.runAsync(() -> this.eventPublisher.publishEvent(event));
    }

    protected Long currentUserId() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        return user == null ? null : user.getUser().getId();
    }

    protected GeneralUserDetails currentUser() {
        return SecurityContextUtil.currentUser();
    }
}

