/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.FileInfoQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.FileInfoRespVO;
import com.elitesland.yst.production.sale.entity.QFileInfoDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FileInfoRepoProc {
    private final QFileInfoDO qFileInfoDO = QFileInfoDO.fileInfoDO;
    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    public PagingVO<FileInfoRespVO> page(FileInfoQueryVO fileInfoPageParam) {
        JPAQuery query = (JPAQuery)this.select(FileInfoRespVO.class).where(this.bulidPredicate(fileInfoPageParam));
        fileInfoPageParam.setPaging(query);
        fileInfoPageParam.fillOrders(query, (EntityPathBase)this.qFileInfoDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public Long del(List<Long> ids) {
        Long res = this.jpaQueryFactory.update((EntityPath)this.qFileInfoDO).set(this.qFileInfoDO.deleteFlag, (Object)1).where(new Predicate[]{this.qFileInfoDO.id.in(ids)}).execute();
        return res;
    }

    public FileInfoRespVO get(Long id) {
        FileInfoRespVO fileInfoVO = (FileInfoRespVO)((JPAQuery)this.select(FileInfoRespVO.class).where((Predicate)this.qFileInfoDO.id.eq((Object)id))).fetchOne();
        return fileInfoVO;
    }

    public List<FileInfoRespVO> getList(FileInfoQueryVO fileInfoPageParam) {
        List res = ((JPAQuery)this.select(FileInfoRespVO.class).where(this.bulidPredicate(fileInfoPageParam))).fetch();
        return res;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qFileInfoDO.url, this.qFileInfoDO.code, this.qFileInfoDO.sourceId, this.qFileInfoDO.sourceType, this.qFileInfoDO.fileName, this.qFileInfoDO.fileType, this.qFileInfoDO.filePath, this.qFileInfoDO.oldFileName, this.qFileInfoDO.fileSize, this.qFileInfoDO.fileInfo, this.qFileInfoDO.id, this.qFileInfoDO.createTime, this.qFileInfoDO.remark, this.qFileInfoDO.updater, this.qFileInfoDO.modifyTime})).from((EntityPath)this.qFileInfoDO);
    }

    private Predicate bulidPredicate(FileInfoQueryVO fileInfoPageParam) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq(StringUtils.isNotBlank((CharSequence)fileInfoPageParam.getUrl()), (SimpleExpression)this.qFileInfoDO.url, (Object)fileInfoPageParam.getUrl()).andEq(StringUtils.isNotBlank((CharSequence)fileInfoPageParam.getCode()), (SimpleExpression)this.qFileInfoDO.code, (Object)fileInfoPageParam.getCode()).andEq(null != fileInfoPageParam.getSourceId(), this.qFileInfoDO.sourceId, (Object)fileInfoPageParam.getSourceId()).andIn(CollectionUtils.isNotEmpty((Collection)fileInfoPageParam.getSourceIds()), this.qFileInfoDO.sourceId, (Collection)fileInfoPageParam.getSourceIds()).andEq(StringUtils.isNotBlank((CharSequence)fileInfoPageParam.getSourceType()), (SimpleExpression)this.qFileInfoDO.sourceType, (Object)fileInfoPageParam.getSourceType()).andEq(StringUtils.isNotBlank((CharSequence)fileInfoPageParam.getFileName()), (SimpleExpression)this.qFileInfoDO.fileName, (Object)fileInfoPageParam.getFileName()).andEq(StringUtils.isNotBlank((CharSequence)fileInfoPageParam.getOldFileName()), (SimpleExpression)this.qFileInfoDO.oldFileName, (Object)fileInfoPageParam.getOldFileName()).andEq(StringUtils.isNotBlank((CharSequence)fileInfoPageParam.getFileSize()), (SimpleExpression)this.qFileInfoDO.fileSize, (Object)fileInfoPageParam.getFileSize()).andEq(StringUtils.isNotBlank((CharSequence)fileInfoPageParam.getFileInfo()), (SimpleExpression)this.qFileInfoDO.fileInfo, (Object)fileInfoPageParam.getFileInfo()).build();
        return predicate;
    }

    public Long sourceDel(List<Long> ids) {
        Long res = this.jpaQueryFactory.update((EntityPath)this.qFileInfoDO).set(this.qFileInfoDO.deleteFlag, (Object)1).where(new Predicate[]{this.qFileInfoDO.sourceId.in(ids)}).execute();
        return res;
    }
}

