/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.auth.cas.model.AuthUserDTO;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.core.support.verifycode.common.VerifyCodeManager;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.req.UserCreateDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.sale.api.service.CustAccountService;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustAccountVO;
import com.elitesland.yst.production.sale.api.vo.save.CheckKapchaParam;
import com.elitesland.yst.production.sale.api.vo.save.CustAccountEnableVO;
import com.elitesland.yst.production.sale.api.vo.save.CustAccountUpdateVO;
import com.elitesland.yst.production.sale.entity.CustAccountDO;
import com.elitesland.yst.production.sale.repo.CrmCustRepo;
import com.elitesland.yst.production.sale.repo.CustAccountRepo;
import com.elitesland.yst.production.sale.repo.CustAccountRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysUserService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class CustAccountServiceImpl
implements CustAccountService {
    private static final Logger log = LoggerFactory.getLogger(CustAccountServiceImpl.class);
    @Autowired
    private CustAccountRepo custAccountRepo;
    @Autowired
    private RmiSysUserService rmiSysUserService;
    @Autowired
    private CrmCustRepo crmCustRepo;
    @Autowired
    private CustAccountRepoProc custAccountRepoProc;
    @Autowired
    private VerifyCodeManager verifyCodeManager;
    public static final String PWD_MATCHES = "(?=.*[0-9])(?=.*[a-zA-Z]).{6,}";
    private static final String BUSINESS_TYPE_RETRIEVE_PWD = "yst_sale_retrieve_pwd";

    public List<AuthUserDTO> createUser(List<String> custCodes) {
        if (CollectionUtil.isEmpty(custCodes)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u9700\u8981\u751f\u6210\u7528\u6237\u7684\u6570\u636e");
        }
        ArrayList<AuthUserDTO> res = new ArrayList<AuthUserDTO>();
        custCodes.forEach(custCode -> {
            CustAccountDO account = this.custAccountRepoProc.getByCustCode((String)custCode);
            if (Boolean.TRUE.equals(account.getIsOpenAccount())) {
                throw new BusinessException(custCode + "\u5df2\u7ecf\u5f00\u901a\u8fc7\u8d26\u53f7");
            }
            this.checkUserName(account.getUserName());
            AuthUserDTO authUser = this.excuteUserInfo(account);
            res.add(authUser);
        });
        return res;
    }

    public void checkUserName(String userName) {
        List<CustAccountVO> custAccount = this.custAccountRepoProc.getAccountListByUserName(userName);
        if (!CollectionUtil.isEmpty(custAccount) && custAccount.size() >= 1) {
            throw new BusinessException("\u6b64\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728\uff01");
        }
    }

    public AuthUserDTO excuteUserInfo(CustAccountDO custAccountDO) {
        AuthUserDTO authUser = new AuthUserDTO();
        authUser.setUsername(custAccountDO.getUserName());
        authUser.setPassword(custAccountDO.getPwd());
        authUser.setMobile(custAccountDO.getMobile());
        authUser.setEnabled(Boolean.valueOf(true));
        return authUser;
    }

    public ApiResult<SysUserDTO> updatePwd(CustAccountUpdateVO custAccountUpdate) {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (Objects.isNull(userDetails) || Objects.isNull(userDetails.getUser())) {
            return ApiResult.fail((String)"\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        SysUserDTO sysUser = userDetails.getUser();
        if (ObjectUtils.isEmpty((Object)sysUser)) {
            return ApiResult.fail((String)"\u7528\u6237\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
        }
        String mobile = sysUser.getMobile();
        String verify = this.verifyCodeManager.verify(BUSINESS_TYPE_RETRIEVE_PWD, mobile, custAccountUpdate.getKaptcha());
        if (!ObjectUtils.isEmpty((Object)verify)) {
            return ApiResult.fail((String)verify);
        }
        CustAccountVO custAccount = this.custAccountRepoProc.getAccountByUserId(sysUser.getId());
        ApiResult<SysUserDTO> check = this.checkPwd(custAccountUpdate, custAccount);
        if (!check.isSuccess()) {
            return check;
        }
        return ApiResult.ok((Object)sysUser);
    }

    public ApiResult<String> checkKaptcha(CheckKapchaParam param) {
        if (StringUtil.isEmpty((CharSequence)param.getMobile()) || StringUtil.isEmpty((CharSequence)param.getKaptcha())) {
            return ApiResult.fail((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String verify = this.verifyCodeManager.verify(BUSINESS_TYPE_RETRIEVE_PWD, param.getMobile(), param.getKaptcha());
        if (!ObjectUtils.isEmpty((Object)verify)) {
            return ApiResult.fail((String)verify);
        }
        return ApiResult.ok();
    }

    public void updateCustAccount(CustAccountVO custAccountVO, CustAccountUpdateVO custAccountUpdate) {
        CustAccountDO custAccountDO = new CustAccountDO();
        BeanUtils.copyProperties((Object)custAccountVO, (Object)custAccountDO);
        custAccountDO.setPwd(custAccountUpdate.getNewPwd());
        custAccountDO.setUpdatePwdTime(LocalDateTime.now());
        this.custAccountRepo.save(custAccountDO);
    }

    public void updateAccountPwd(Long userId, CustAccountUpdateVO custAccountUpdate) {
        CustAccountDO account = this.custAccountRepoProc.getByUserId(userId);
        account.setPwd(custAccountUpdate.getNewPwd());
        account.setUpdatePwdTime(LocalDateTime.now());
        account.setIsModifyPwd(Boolean.TRUE);
        this.custAccountRepo.save(account);
    }

    public List<CustAccountVO> getByCustCodes(CustAccountEnableVO custAccountEnableVO) {
        if (Objects.isNull(custAccountEnableVO)) {
            throw new BusinessException("\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        Assert.notNull((Object)custAccountEnableVO.getCustCodes(), (String)"\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Assert.notNull((Object)custAccountEnableVO.getEnable(), (String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<CustAccountVO> res = this.custAccountRepoProc.getAccountByCustCode(custAccountEnableVO.getCustCodes());
        return res;
    }

    public List<CustAccountVO> getByUserName(List<String> userNames) {
        Assert.notNull(userNames, (String)"\u5ba2\u6237\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return this.custAccountRepoProc.getAccountByUserNames(userNames);
    }

    public List<CustAccountVO> getByUserNameAndSource(List<String> userNames, List<String> dealerTypes, String businessTypeCust) {
        Assert.notNull(userNames, (String)"\u5ba2\u6237\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return this.custAccountRepoProc.getAccountByUserNamesAndSource(userNames, dealerTypes, businessTypeCust);
    }

    public List<CustAccountVO> getByCustCodes(List<String> custCodes) {
        Assert.notNull(custCodes, (String)"\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return this.custAccountRepoProc.getAccountByCustCode(custCodes);
    }

    public List<CustAccountVO> getByCustCodesAndUserName(String custCode, String userName, List<String> dealerTypes) {
        Assert.notNull((Object)custCode, (String)"\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return this.custAccountRepoProc.getByCustCodesAndUserName(custCode, userName, dealerTypes);
    }

    public List<Long> updateAccountEnable(List<Long> accountIds, Boolean enable) {
        List list = this.custAccountRepo.findAllById(accountIds);
        ArrayList<Long> res = new ArrayList<Long>();
        list.forEach(l -> {
            l.setEnable(enable);
            res.add(l.getId());
        });
        this.custAccountRepo.saveAll(list);
        return res;
    }

    public void deleteAccount(List<Long> ids) {
        List list = this.custAccountRepo.findAllById(ids);
        list.forEach(l -> l.setDeleteFlag(1));
        this.custAccountRepo.saveAll(list);
    }

    public ApiResult<SysUserDTO> checkPwd(CustAccountUpdateVO custAccountUpdateVO, CustAccountVO custAccount) {
        if (ObjectUtils.isEmpty((Object)custAccountUpdateVO)) {
            return ApiResult.fail((String)"\u5bc6\u7801\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (!custAccountUpdateVO.getNewPwd().equals(custAccountUpdateVO.getConfirmPwd())) {
            return ApiResult.fail((String)"\u5bc6\u7801\u4e0d\u4e00\u81f4\uff01");
        }
        if (ObjectUtils.isEmpty((Object)custAccount)) {
            return ApiResult.fail((String)"\u67e5\u8be2\u8d26\u6237\u4fe1\u606f\u5931\u8d25\uff01");
        }
        String pwd = custAccount.getPwd();
        if (!custAccountUpdateVO.getOldPwd().equals(pwd)) {
            return ApiResult.fail((String)"\u65e7\u5bc6\u7801\u4e0d\u5339\u914d\uff01");
        }
        if (!custAccountUpdateVO.getNewPwd().matches(PWD_MATCHES)) {
            return ApiResult.fail((String)"\u5bc6\u7801\u5fc5\u987b\u5305\u542b\u6570\u5b57\u5b57\u6bcd\u4e0d\u80fd\u5c11\u4e8e6\u4f4d");
        }
        return ApiResult.ok();
    }

    public UserCreateDTO excuteUserParam(CustAccountDO custAccountDO) {
        UserCreateDTO userCreateDTO = new UserCreateDTO();
        userCreateDTO.setEnabled(Boolean.valueOf(true));
        userCreateDTO.setUsername(custAccountDO.getUserName());
        userCreateDTO.setPassword(custAccountDO.getPwd());
        userCreateDTO.setMobile(custAccountDO.getMobile());
        return userCreateDTO;
    }
}

